/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.tekto;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.SpaceConfig;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.tekto.TTree;
import com.hbm.dim.tekto.biome.BiomeGenBaseTekto;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGeneratorTekto
implements IWorldGenerator {
    public WorldGeneratorTekto() {
        NBTStructure.registerNullWeight(SpaceConfig.tektoDimension, 24);
        BlockOre.addValidBody(ModBlocks.ore_tekto, SolarSystem.Body.TEKTO);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == SpaceConfig.tektoDimension) {
            this.generateTekto(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateTekto(World world, Random rand, int i, int j) {
        int y;
        int z;
        int x;
        int o;
        int meta = CelestialBody.getMeta(world);
        Block stone = ((WorldProviderCelestial)world.field_73011_w).getStone();
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.cobaltSpawn * 2, 6, 4, 8, ModBlocks.ore_cobalt, meta, stone);
        BiomeGenBase biome = world.func_72807_a(i + 16, j + 16);
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                for (int y2 = 32; y2 < 128; ++y2) {
                    int ox = i + x2 + 8;
                    int oz = j + z2 + 8;
                    Block b = world.func_147439_a(ox, y2, oz);
                    if (b != ModBlocks.geysir_chloric) continue;
                    world.func_147449_b(ox, y2, oz, ModBlocks.geysir_chloric);
                    world.func_147471_g(ox, y2, oz);
                }
            }
        }
        if (biome == BiomeGenBaseTekto.polyvinylPlains) {
            for (o = 0; o < 2; ++o) {
                if (rand.nextInt(10) == 0) {
                    x = i + rand.nextInt(16) + 8;
                    z = j + rand.nextInt(16) + 8;
                    y = world.func_72976_f(x, z);
                    TTree customTreeGen = new TTree(false, 4, 2, 10, 2, 4, false, ModBlocks.pvc_log, ModBlocks.rubber_leaves);
                    customTreeGen.func_76484_a(world, rand, x, y, z);
                }
                if (rand.nextInt(8) != 0) continue;
                x = i + rand.nextInt(16) + 8;
                z = j + rand.nextInt(16) + 8;
                y = world.func_72976_f(x, z);
                TTree chopped = new TTree(false, 2, 4, 5, 3, 2, false, ModBlocks.vinyl_log, ModBlocks.pet_leaves);
                chopped.func_76484_a(world, rand, x, y, z);
            }
        }
        if (biome == BiomeGenBaseTekto.halogenHills && rand.nextInt(12) == 0) {
            for (o = 0; o < 4; ++o) {
                x = i + rand.nextInt(16) + 8;
                z = j + rand.nextInt(16) + 8;
                y = world.func_72976_f(x, z);
                TTree customTreeGen = new TTree(false, 3, 2, 14, 3, 3, false, ModBlocks.pvc_log, ModBlocks.rubber_leaves);
                customTreeGen.func_76484_a(world, rand, x, y, z);
            }
        }
        if (biome == BiomeGenBaseTekto.forest) {
            for (o = 0; o < 8; ++o) {
                x = i + rand.nextInt(16) + 8;
                z = j + rand.nextInt(16) + 8;
                y = world.func_72976_f(x, z);
                if (rand.nextInt(2) == 0) {
                    TTree customTreeGen = new TTree(false, 3, 2, 20, 3, 5, true, ModBlocks.pvc_log, ModBlocks.rubber_leaves);
                    customTreeGen.func_76484_a(world, rand, x, y, z);
                    continue;
                }
                TTree tustomTreeGen = new TTree(false, 3, 1, 1, 3, 5, false, ModBlocks.pvc_log, ModBlocks.rubber_leaves);
                tustomTreeGen.func_76484_a(world, rand, x, y, z);
            }
        }
    }
}

