/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import com.hbm.blocks.BlockFallingNT;
import com.hbm.blocks.ISpotlight;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFallingBlockNT
extends Entity {
    private Block fallingBlock;
    private int fallingMeta = -1;
    public int fallingTicks;
    public boolean canDrop = true;
    private boolean destroyOnLand;
    private boolean canHurtEntities;
    private int damageCap = 40;
    private float damageAmount = 2.0f;
    public NBTTagCompound tileNBT;

    public EntityFallingBlockNT(World world) {
        super(world);
        this.func_70105_a(0.98f, 0.98f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityFallingBlockNT(World world, double x, double y, double z, Block block) {
        this(world, x, y, z, block, 0);
    }

    public EntityFallingBlockNT(World world, double x, double y, double z, Block block, int meta) {
        super(world);
        this.fallingBlock = block;
        this.field_70180_af.func_75692_b(10, (Object)Block.func_149682_b((Block)this.fallingBlock));
        this.fallingMeta = meta;
        this.field_70180_af.func_75692_b(11, (Object)this.fallingMeta);
        this.field_70156_m = true;
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(11, (Object)new Integer(0));
    }

    public Block getBlock() {
        if (this.fallingBlock != null) {
            return this.fallingBlock;
        }
        this.fallingBlock = Block.func_149729_e((int)this.field_70180_af.func_75679_c(10));
        return this.fallingBlock;
    }

    public int getMeta() {
        if (this.fallingMeta != -1) {
            return this.fallingMeta;
        }
        this.fallingMeta = 0;
        this.fallingMeta = this.field_70180_af.func_75679_c(11);
        return this.fallingMeta;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.getBlock().func_149688_o() == Material.field_151579_a || this.getBlock() instanceof ISpotlight) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            ++this.fallingTicks;
            this.field_70181_x -= 0.04;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            if (!this.field_70170_p.field_72995_K) {
                int x = MathHelper.func_76128_c((double)this.field_70165_t);
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                int z = MathHelper.func_76128_c((double)this.field_70161_v);
                int meta = this.getMeta();
                if (this.fallingTicks == 1) {
                    if (this.field_70170_p.func_147439_a(x, y, z) != this.getBlock()) {
                        this.func_70106_y();
                        return;
                    }
                    this.field_70170_p.func_147468_f(x, y, z);
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.7;
                    this.field_70179_y *= 0.7;
                    this.field_70181_x *= -0.5;
                    if (this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150326_M) {
                        this.func_70106_y();
                        if (!this.destroyOnLand && this.replacementCheck(x, y, z) && this.field_70170_p.func_147465_d(x, y, z, this.getBlock(), meta, 3)) {
                            TileEntity tileentity;
                            if (this.getBlock() instanceof BlockFalling) {
                                ((BlockFalling)this.getBlock()).func_149828_a(this.field_70170_p, x, y, z, meta);
                            }
                            if (this.getBlock() instanceof BlockFallingNT) {
                                ((BlockFallingNT)this.getBlock()).onLand(this.field_70170_p, x, y, z, meta);
                            }
                            if (this.tileNBT != null && this.getBlock() instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_147438_o(x, y, z)) != null) {
                                NBTTagCompound nbt = new NBTTagCompound();
                                tileentity.func_145841_b(nbt);
                                for (String s : this.tileNBT.func_150296_c()) {
                                    NBTBase nbtbase = this.tileNBT.func_74781_a(s);
                                    if (s.equals("x") || s.equals("y") || s.equals("z")) continue;
                                    nbt.func_74782_a(s, nbtbase.func_74737_b());
                                }
                                tileentity.func_145839_a(nbt);
                                tileentity.func_70296_d();
                            }
                        } else if (this.canDrop && !this.destroyOnLand && this.getBlock().func_149650_a(meta, this.field_70146_Z, 0) != null) {
                            this.func_70099_a(new ItemStack(this.getBlock().func_149650_a(meta, this.field_70146_Z, 0), 1, this.getBlock().func_149692_a(meta)), 0.0f);
                        }
                    }
                } else if (this.fallingTicks > 100 && !this.field_70170_p.field_72995_K && (y < 1 || y > 256) || this.fallingTicks > 600) {
                    if (this.canDrop && this.getBlock().func_149650_a(meta, this.field_70146_Z, 0) != null) {
                        this.func_70099_a(new ItemStack(this.getBlock().func_149650_a(meta, this.field_70146_Z, 0), 1, this.getBlock().func_149692_a(meta)), 0.0f);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    public boolean replacementCheck(int x, int y, int z) {
        return this.field_70170_p.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_70170_p, x, y, z) && this.getBlock().func_149718_j(this.field_70170_p, x, y, z);
    }

    protected void func_70069_a(float fallDistance) {
        int fall;
        if (this.canHurtEntities && (fall = MathHelper.func_76123_f((float)(fallDistance - 1.0f))) > 0) {
            ArrayList arraylist = new ArrayList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D));
            boolean isAnvil = this.getBlock() == Blocks.field_150467_bQ;
            DamageSource damagesource = isAnvil ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : arraylist) {
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)fall * this.damageAmount)), this.damageCap));
            }
            if (isAnvil && (double)this.field_70146_Z.nextFloat() < 0.05 + (double)fall * 0.05) {
                int j = this.getMeta() >> 2;
                int k = this.getMeta() & 3;
                if (++j > 2) {
                    this.destroyOnLand = true;
                } else {
                    this.fallingMeta = k | j << 2;
                }
            }
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Tile", (byte)Block.func_149682_b((Block)this.fallingBlock));
        nbt.func_74768_a("TileID", Block.func_149682_b((Block)this.fallingBlock));
        nbt.func_74774_a("Data", (byte)this.fallingMeta);
        nbt.func_74774_a("Time", (byte)this.fallingTicks);
        nbt.func_74757_a("DropItem", this.canDrop);
        nbt.func_74757_a("HurtEntities", this.canHurtEntities);
        nbt.func_74776_a("FallHurtAmount", this.damageAmount);
        nbt.func_74768_a("FallHurtMax", this.damageCap);
        if (this.tileNBT != null) {
            nbt.func_74782_a("TileEntityData", (NBTBase)this.tileNBT);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.fallingBlock = nbt.func_150297_b("TileID", 99) ? Block.func_149729_e((int)nbt.func_74762_e("TileID")) : Block.func_149729_e((int)(nbt.func_74771_c("Tile") & 0xFF));
        this.fallingMeta = nbt.func_74771_c("Data") & 0xFF;
        this.fallingTicks = nbt.func_74771_c("Time") & 0xFF;
        if (nbt.func_150297_b("HurtEntities", 99)) {
            this.canHurtEntities = nbt.func_74767_n("HurtEntities");
            this.damageAmount = nbt.func_74760_g("FallHurtAmount");
            this.damageCap = nbt.func_74762_e("FallHurtMax");
        } else if (this.fallingBlock == Blocks.field_150467_bQ) {
            this.canHurtEntities = true;
        }
        if (nbt.func_150297_b("DropItem", 99)) {
            this.canDrop = nbt.func_74767_n("DropItem");
        }
        if (nbt.func_150297_b("TileEntityData", 10)) {
            this.tileNBT = nbt.func_74775_l("TileEntityData");
        }
        if (this.fallingBlock.func_149688_o() == Material.field_151579_a) {
            this.fallingBlock = Blocks.field_150354_m;
        }
    }

    public void func_145806_a(boolean p_145806_1_) {
        this.canHurtEntities = p_145806_1_;
    }

    public void func_85029_a(CrashReportCategory report) {
        super.func_85029_a(report);
        report.func_71507_a("Immitating block ID", (Object)Block.func_149682_b((Block)this.fallingBlock));
        report.func_71507_a("Immitating block data", (Object)this.fallingMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorldForRender() {
        return this.field_70170_p;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public Block getBlockForRender() {
        return this.getBlock();
    }
}

