/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import api.hbm.entity.ISuffocationImmune;
import com.hbm.config.GeneralConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.entity.mob.EntityCreeperNuclear;
import com.hbm.entity.mob.EntityCyberCrab;
import com.hbm.entity.mob.EntityDuck;
import com.hbm.entity.mob.EntityQuackos;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.HbmKeybinds;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.interfaces.IArmorModDash;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.weapon.sedna.factory.ConfettiUtil;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.packet.toclient.ExtPropPacket;
import com.hbm.particle.helper.FlameCreator;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.world.biome.BiomeGenCraterBase;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeGenBase;

public class EntityEffectHandler {
    public static void onUpdate(EntityLivingBase entity) {
        BiomeGenBase biome;
        EntityPlayer player;
        if (entity.field_70173_aa % 20 == 0) {
            HbmLivingProps.setRadBuf(entity, HbmLivingProps.getRadEnv(entity));
            HbmLivingProps.setRadEnv(entity, 0.0f);
        }
        if (entity instanceof EntityPlayer && entity == MainRegistry.proxy.me() && (player = MainRegistry.proxy.me()) != null && ((biome = player.field_70170_p.func_72807_a((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70161_v))) == BiomeGenCraterBase.craterBiome || biome == BiomeGenCraterBase.craterInnerBiome)) {
            Random rand = player.func_70681_au();
            for (int i = 0; i < 3; ++i) {
                player.field_70170_p.func_72869_a("townaura", player.field_70165_t + rand.nextGaussian() * 3.0, player.field_70163_u + rand.nextGaussian() * 2.0, player.field_70161_v + rand.nextGaussian() * 3.0, 0.0, 0.0, 0.0);
            }
        }
        if (entity instanceof EntityPlayerMP) {
            HbmLivingProps props = HbmLivingProps.getData(entity);
            HbmPlayerProps pprps = HbmPlayerProps.getData((EntityPlayer)((EntityPlayerMP)entity));
            if (pprps.shield < pprps.getEffectiveMaxShield() && entity.field_70173_aa > pprps.lastDamage + 60) {
                int tsd = entity.field_70173_aa - (pprps.lastDamage + 60);
                pprps.shield += Math.min(pprps.getEffectiveMaxShield() - pprps.shield, 0.005f * (float)tsd);
            }
            if (pprps.shield > pprps.getEffectiveMaxShield()) {
                pprps.shield = pprps.getEffectiveMaxShield();
            }
            PacketThreading.createSendToThreadedPacket(new ExtPropPacket(props, pprps), (EntityPlayerMP)entity);
        }
        if (!entity.field_70170_p.field_72995_K) {
            int timer = HbmLivingProps.getTimer(entity);
            if (timer > 0) {
                HbmLivingProps.setTimer(entity, timer - 1);
                if (timer == 1) {
                    ExplosionNukeSmall.explode(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ExplosionNukeSmall.PARAMS_MEDIUM);
                }
            }
            if (GeneralConfig.enable528NetherBurn && entity instanceof EntityPlayer && !entity.func_70045_F() && entity.field_70170_p.field_73011_w instanceof WorldProviderHell) {
                entity.func_70015_d(5);
            }
            biome = entity.field_70170_p.func_72807_a((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v));
            float radiation = 0.0f;
            if (biome == BiomeGenCraterBase.craterOuterBiome) {
                radiation = WorldConfig.craterBiomeOuterRad;
            }
            if (biome == BiomeGenCraterBase.craterBiome) {
                radiation = WorldConfig.craterBiomeRad;
            }
            if (biome == BiomeGenCraterBase.craterInnerBiome) {
                radiation = WorldConfig.craterBiomeInnerRad;
            }
            if (entity.func_70026_G()) {
                radiation *= WorldConfig.craterBiomeWaterMult;
            }
            if (radiation > 0.0f) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, radiation / 20.0f);
            }
            CBT_Atmosphere atmosphere = EntityEffectHandler.getAtmosphereCached(entity);
            EntityEffectHandler.handleOxy(entity, atmosphere);
            EntityEffectHandler.handleCorrosion(entity, atmosphere);
        }
        EntityEffectHandler.handleContamination(entity);
        EntityEffectHandler.handleContagion(entity);
        EntityEffectHandler.handleRadiationEffect(entity);
        EntityEffectHandler.handleRadiationFX(entity);
        EntityEffectHandler.handleDigamma(entity);
        EntityEffectHandler.handleLungDisease(entity);
        EntityEffectHandler.handleOil(entity);
        EntityEffectHandler.handlePollution(entity);
        EntityEffectHandler.handleTemperature((Entity)entity);
        EntityEffectHandler.handleDashing((Entity)entity);
        EntityEffectHandler.handlePlinking((Entity)entity);
        if (entity instanceof EntityPlayer) {
            EntityEffectHandler.handleFauxLadder((EntityPlayer)entity);
        }
    }

    private static void handleFauxLadder(EntityPlayer player) {
        HbmPlayerProps props = HbmPlayerProps.getData(player);
        if (props.isOnLadder) {
            double climbSpeed = 0.15;
            if (player.field_70159_w < -climbSpeed) {
                player.field_70159_w = -climbSpeed;
            }
            if (player.field_70159_w > climbSpeed) {
                player.field_70159_w = climbSpeed;
            }
            if (player.field_70179_y < -climbSpeed) {
                player.field_70179_y = -climbSpeed;
            }
            if (player.field_70179_y > climbSpeed) {
                player.field_70179_y = climbSpeed;
            }
            player.field_70143_R = 0.0f;
            if (player.field_70181_x < -climbSpeed) {
                player.field_70181_x = -climbSpeed;
            }
            if (player.func_70093_af() && player.field_70181_x < 0.0) {
                player.field_70181_x = 0.0;
            }
            if (player.field_70123_F) {
                player.field_70181_x = 0.2;
            }
            props.isOnLadder = false;
            if (!player.field_70170_p.field_72995_K) {
                ArmorUtil.resetFlightTime(player);
            }
        }
    }

    private static CBT_Atmosphere getAtmosphereCached(EntityLivingBase entity) {
        if (entity instanceof EntityPlayerMP || entity.field_70173_aa % 20 == 0) {
            CBT_Atmosphere atmosphere = ChunkAtmosphereManager.proxy.getAtmosphere((Entity)entity);
            HbmLivingProps.setAtmosphere(entity, atmosphere);
            return atmosphere;
        }
        return HbmLivingProps.getAtmosphere(entity);
    }

    private static void handleContamination(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        List<HbmLivingProps.ContaminationEffect> contamination = HbmLivingProps.getCont(entity);
        ArrayList<HbmLivingProps.ContaminationEffect> rem = new ArrayList<HbmLivingProps.ContaminationEffect>();
        for (HbmLivingProps.ContaminationEffect con : contamination) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, con.ignoreArmor ? ContaminationUtil.ContaminationType.RAD_BYPASS : ContaminationUtil.ContaminationType.CREATIVE, con.getRad());
            --con.time;
            if (con.time > 0) continue;
            rem.add(con);
        }
        contamination.removeAll(rem);
    }

    private static void handleRadiationEffect(EntityLivingBase entity) {
        if (entity.field_70128_L) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        World world = entity.field_70170_p;
        float eRad = HbmLivingProps.getRadiation(entity);
        if (entity.getClass().equals(EntityCreeper.class) && eRad >= 200.0f && entity.func_110143_aJ() > 0.0f) {
            if (world.field_73012_v.nextInt(3) == 0) {
                EntityCreeperNuclear creep = new EntityCreeperNuclear(world);
                creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                world.func_72838_d((Entity)creep);
                entity.func_70106_y();
            } else {
                entity.func_70097_a(ModDamageSource.radiation, 100.0f);
            }
            return;
        }
        if (entity instanceof EntityCow && !(entity instanceof EntityMooshroom) && eRad >= 50.0f) {
            EntityMooshroom cow = new EntityMooshroom(world);
            cow.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            world.func_72838_d((Entity)cow);
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityVillager && eRad >= 500.0f) {
            EntityZombie zomb = new EntityZombie(world);
            zomb.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            world.func_72838_d((Entity)zomb);
            entity.func_70106_y();
            return;
        }
        if (entity.getClass().equals(EntityDuck.class) && eRad >= 200.0f) {
            EntityQuackos quacc = new EntityQuackos(world);
            quacc.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            world.func_72838_d((Entity)quacc);
            entity.func_70106_y();
            return;
        }
        if (eRad < 200.0f || ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        if (eRad > 2500.0f) {
            HbmLivingProps.setRadiation(entity, 2500.0f);
        }
        if (eRad >= 1000.0f) {
            entity.func_70097_a(ModDamageSource.radiation, 1000.0f);
            HbmLivingProps.setRadiation(entity, 0.0f);
            if (entity.func_110143_aJ() > 0.0f) {
                entity.func_70606_j(0.0f);
                entity.func_70645_a(ModDamageSource.radiation);
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.achRadDeath);
            }
        } else if (eRad >= 800.0f) {
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
            }
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
            }
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 2));
            }
            if (world.field_73012_v.nextInt(500) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 2));
            }
            if (world.field_73012_v.nextInt(700) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60, 1));
            }
        } else if (eRad >= 600.0f) {
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
            }
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
            }
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 2));
            }
            if (world.field_73012_v.nextInt(500) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 1));
            }
        } else if (eRad >= 400.0f) {
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
            }
            if (world.field_73012_v.nextInt(500) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 0));
            }
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 1));
            }
        } else if (eRad >= 200.0f) {
            if (world.field_73012_v.nextInt(300) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
            }
            if (world.field_73012_v.nextInt(500) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 0));
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.achRadPoison);
            }
        }
    }

    private static void handleRadiationFX(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            NBTTagCompound nbt;
            if (ContaminationUtil.isRadImmune((Entity)entity)) {
                return;
            }
            int ix = MathHelper.func_76128_c((double)entity.field_70165_t);
            int iy = MathHelper.func_76128_c((double)entity.field_70163_u);
            int iz = MathHelper.func_76128_c((double)entity.field_70161_v);
            float rad = ChunkRadiationManager.proxy.getRadiation(world, ix, iy, iz);
            float neut = HbmLivingProps.getNeutronActivation(entity);
            if (neut > 0.0f && !RadiationConfig.disableNeutron) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, neut / 20.0f);
                HbmLivingProps.setNeutronActivation(entity, neut * 0.998816f);
            }
            if ((double)neut < 1.0E-5) {
                HbmLivingProps.setNeutronActivation(entity, 0.0f);
            }
            if (world.field_73011_w instanceof WorldProviderHell && RadiationConfig.hellRad > 0.0 && (double)rad < RadiationConfig.hellRad) {
                rad = (float)RadiationConfig.hellRad;
            }
            if ((world.field_73011_w instanceof WorldProviderCelestial || world.field_73011_w instanceof WorldProviderOrbit) && world.func_72972_b(EnumSkyBlock.Sky, ix, iy, iz) - world.field_73008_k >= 14) {
                ItemVOTVdrive.Target target = CelestialBody.getTarget(world, ix, iz);
                CBT_Atmosphere atmosphere = !target.inOrbit ? CelestialBody.getTrait(world, CBT_Atmosphere.class) : null;
                float targetRad = target.body.getSunPower();
                if (atmosphere != null) {
                    targetRad -= (float)atmosphere.getPressure() * 4.0f;
                }
                if ((targetRad = (float)((double)targetRad * RadiationConfig.celestialRadMultiplier)) > rad) {
                    rad = targetRad;
                }
            }
            if (rad > 0.0f) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad / 20.0f);
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            Random rand = new Random(entity.func_145782_y());
            int r600 = rand.nextInt(600);
            int r1200 = rand.nextInt(1200);
            if (HbmLivingProps.getRadiation(entity) > 600.0f) {
                if ((world.func_82737_E() + (long)r600) % 600L < 20L && EntityEffectHandler.canVomit((Entity)entity)) {
                    nbt = new NBTTagCompound();
                    nbt.func_74778_a("type", "vomit");
                    nbt.func_74778_a("mode", "blood");
                    nbt.func_74768_a("count", 25);
                    nbt.func_74768_a("entity", entity.func_145782_y());
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                    if ((world.func_82737_E() + (long)r600) % 600L == 1L) {
                        world.func_72908_a((double)ix, (double)iy, (double)iz, "hbm:player.vomit", 1.0f, 1.0f);
                        entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 60, 19));
                    }
                }
            } else if (HbmLivingProps.getRadiation(entity) > 200.0f && (world.func_82737_E() + (long)r1200) % 1200L < 20L && EntityEffectHandler.canVomit((Entity)entity)) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74778_a("mode", "normal");
                nbt.func_74768_a("count", 15);
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                if ((world.func_82737_E() + (long)r1200) % 1200L == 1L) {
                    world.func_72908_a((double)ix, (double)iy, (double)iz, "hbm:player.vomit", 1.0f, 1.0f);
                    entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 60, 19));
                }
            }
            if (HbmLivingProps.getRadiation(entity) > 900.0f && (world.func_82737_E() + (long)rand.nextInt(10)) % 10L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "sweat");
                nbt.func_74768_a("count", 1);
                nbt.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        } else {
            float radiation = HbmLivingProps.getRadiation(entity);
            if (entity instanceof EntityPlayer && radiation > 600.0f) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "radiation");
                nbt.func_74768_a("count", radiation > 900.0f ? 4 : (radiation > 800.0f ? 2 : 1));
                MainRegistry.proxy.effectNT(nbt);
            }
        }
    }

    private static void handleOxy(EntityLivingBase entity, CBT_Atmosphere atmosphere) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof ISuffocationImmune) {
            return;
        }
        if (entity.field_70154_o != null && entity.field_70154_o instanceof EntityRideableRocket) {
            return;
        }
        if (!ArmorUtil.checkForOxy(entity, atmosphere)) {
            HbmLivingProps.setOxy(entity, HbmLivingProps.getOxy(entity) - 1);
        } else {
            HbmLivingProps.setOxy(entity, 100);
        }
    }

    private static void handleCorrosion(EntityLivingBase entity, CBT_Atmosphere atmosphere) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityGlyphid) {
            return;
        }
        if (entity instanceof EntityCyberCrab) {
            return;
        }
        if (entity.field_70154_o != null && entity.field_70154_o instanceof EntityRideableRocket) {
            return;
        }
        if (ArmorUtil.checkForCorrosion(entity, atmosphere)) {
            entity.func_70097_a(ModDamageSource.acid, 1.0f);
        }
    }

    private static void handleDigamma(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            float digamma = HbmLivingProps.getDigamma(entity);
            if (digamma < 0.01f) {
                return;
            }
            int chance = Math.max(10 - (int)digamma, 1);
            if (chance == 1 || entity.func_70681_au().nextInt(chance) == 0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "sweat");
                data.func_74768_a("count", 1);
                data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
                data.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }

    private static void handleContagion(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        if (!entity.field_70170_p.field_72995_K) {
            Random rand = entity.func_70681_au();
            int minute = 1200;
            int hour = 60 * minute;
            int contagion = HbmLivingProps.getContagion(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                int randSlot = rand.nextInt(player.field_71071_by.field_70462_a.length);
                ItemStack stack = player.field_71071_by.func_70301_a(randSlot);
                if (rand.nextInt(100) == 0) {
                    stack = player.field_71071_by.func_70440_f(rand.nextInt(4));
                }
                if (stack != null && stack.func_77976_d() == 1) {
                    if (contagion > 0) {
                        if (!stack.func_77942_o()) {
                            stack.field_77990_d = new NBTTagCompound();
                        }
                        stack.field_77990_d.func_74757_a("ntmContagion", true);
                    } else if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("ntmContagion") && (!ArmorUtil.checkForHaz2((EntityLivingBase)player) || !ArmorRegistry.hasProtection((EntityLivingBase)player, 3, ArmorRegistry.HazardClass.BACTERIA))) {
                        HbmLivingProps.setContagion((EntityLivingBase)player, 3 * hour);
                    }
                }
            }
            if (contagion > 0) {
                HbmLivingProps.setContagion(entity, contagion - 1);
                if (contagion < 2 * hour + 55 * minute && contagion % 20 == 0) {
                    double range = entity.func_70026_G() ? 16.0 : 2.0;
                    List list = world.func_72839_b((Entity)entity, entity.field_70121_D.func_72314_b(range, range, range));
                    for (Entity ent : list) {
                        EntityLivingBase living;
                        if (!(!(ent instanceof EntityLivingBase) || HbmLivingProps.getContagion(living = (EntityLivingBase)ent) > 0 || ArmorUtil.checkForHaz2(living) && ArmorRegistry.hasProtection(living, 3, ArmorRegistry.HazardClass.BACTERIA))) {
                            HbmLivingProps.setContagion(living, 3 * hour);
                        }
                        if (!(ent instanceof EntityItem)) continue;
                        ItemStack stack = ((EntityItem)ent).func_92059_d();
                        if (!stack.func_77942_o()) {
                            stack.field_77990_d = new NBTTagCompound();
                        }
                        stack.field_77990_d.func_74757_a("ntmContagion", true);
                    }
                }
                if (contagion < 2 * hour && rand.nextInt(1000) == 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 20, 0));
                }
                if (contagion < 1 * hour && rand.nextInt(100) == 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 60, 0));
                    entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 300, 4));
                }
                if (contagion < 30 * minute && rand.nextInt(400) == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 1.0f);
                }
                if (contagion < 5 * minute && rand.nextInt(100) == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 2.0f);
                }
                if (contagion < 30 * minute && (contagion + entity.func_145782_y()) % 200 < 20 && EntityEffectHandler.canVomit((Entity)entity)) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("type", "vomit");
                    nbt.func_74778_a("mode", "blood");
                    nbt.func_74768_a("count", 25);
                    nbt.func_74768_a("entity", entity.func_145782_y());
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                    if ((contagion + entity.func_145782_y()) % 200 == 19) {
                        world.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:player.vomit", 1.0f, 1.0f);
                    }
                }
                if (contagion == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 1000.0f);
                }
            }
        }
    }

    private static void handleLungDisease(EntityLivingBase entity) {
        boolean coughs;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            HbmLivingProps.setBlackLung(entity, 0);
            HbmLivingProps.setAsbestos(entity, 0);
            return;
        }
        int bl = HbmLivingProps.getBlackLung(entity);
        if (bl > 0 && (double)bl < 72000.0) {
            HbmLivingProps.setBlackLung(entity, HbmLivingProps.getBlackLung(entity) - 1);
        }
        double blacklung = Math.min(HbmLivingProps.getBlackLung(entity), 144000);
        double asbestos = Math.min(HbmLivingProps.getAsbestos(entity), 72000);
        double soot = 0.0;
        if (entity instanceof EntityPlayer && !ArmorRegistry.hasProtection(entity, 3, ArmorRegistry.HazardClass.PARTICLE_COARSE)) {
            soot = PollutionHandler.getPollution(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u + (double)entity.func_70047_e()), (int)Math.floor(entity.field_70161_v), PollutionHandler.PollutionType.SOOT);
        }
        boolean bl2 = coughs = blacklung / 144000.0 > 0.25 || asbestos / 72000.0 > 0.25 || soot > 30.0;
        if (!coughs) {
            return;
        }
        boolean coughsCoal = blacklung / 144000.0 > 0.5;
        boolean coughsALotOfCoal = blacklung / 144000.0 > 0.8;
        boolean coughsBlood = asbestos / 72000.0 > 0.75 || blacklung / 144000.0 > 0.75;
        double blacklungDelta = 1.0 - blacklung / 144000.0;
        double asbestosDelta = 1.0 - asbestos / 72000.0;
        double sootDelta = 1.0 - Math.min(soot / 100.0, 1.0);
        double total = 1.0 - blacklungDelta * asbestosDelta;
        World world = entity.field_70170_p;
        if (total > 0.75) {
            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 2));
        }
        if (total > 0.95) {
            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
        }
        total = 1.0 - blacklungDelta * asbestosDelta * sootDelta;
        int freq = Math.max((int)(1000.0 - 950.0 * total), 20);
        if (world.func_82737_E() % (long)freq == (long)(entity.func_145782_y() % freq)) {
            NBTTagCompound nbt;
            world.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:player.cough", 1.0f, 1.0f);
            if (coughsBlood) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74778_a("mode", "blood");
                nbt.func_74768_a("count", 5);
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
            if (coughsCoal) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74778_a("mode", "smoke");
                nbt.func_74768_a("count", coughsALotOfCoal ? 50 : 10);
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }

    private static void handleOil(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int oil = HbmLivingProps.getOil(entity);
        if (oil > 0) {
            if (entity.func_70027_ad()) {
                HbmLivingProps.setOil(entity, 0);
                entity.field_70170_p.func_72885_a(null, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, 3.0f, false, true);
            } else {
                HbmLivingProps.setOil(entity, oil - 1);
            }
            if (entity.field_70173_aa % 5 == 0) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "sweat");
                nbt.func_74768_a("count", 1);
                nbt.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150402_ci));
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }

    private static void handlePollution(EntityLivingBase entity) {
        float poison;
        if (!RadiationConfig.enablePollution) {
            return;
        }
        if (RadiationConfig.enablePoison && !ArmorRegistry.hasProtection(entity, 3, ArmorRegistry.HazardClass.GAS_BLISTERING) && entity.field_70173_aa % 60 == 0 && (poison = PollutionHandler.getPollution(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u + (double)entity.func_70047_e()), (int)Math.floor(entity.field_70161_v), PollutionHandler.PollutionType.POISON)) > 10.0f) {
            if (poison < 25.0f) {
                entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 0));
            } else if (poison < 50.0f) {
                entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100, 1));
            } else {
                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 2));
            }
        }
        if (RadiationConfig.enableLeadPoisoning && !ArmorRegistry.hasProtection(entity, 3, ArmorRegistry.HazardClass.PARTICLE_FINE) && entity.field_70173_aa % 60 == 0 && (poison = PollutionHandler.getPollution(entity.field_70170_p, (int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u + (double)entity.func_70047_e()), (int)Math.floor(entity.field_70161_v), PollutionHandler.PollutionType.HEAVYMETAL)) > 25.0f) {
            if (poison < 50.0f) {
                entity.func_70690_d(new PotionEffect(HbmPotion.lead.field_76415_H, 100, 0));
            } else if (poison < 75.0f) {
                entity.func_70690_d(new PotionEffect(HbmPotion.lead.field_76415_H, 100, 2));
            } else {
                entity.func_70690_d(new PotionEffect(HbmPotion.lead.field_76415_H, 100, 2));
            }
        }
    }

    private static void handleTemperature(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        HbmLivingProps props = HbmLivingProps.getData(living);
        Random rand = living.func_70681_au();
        if (!entity.func_70089_S()) {
            return;
        }
        if (living.func_70045_F()) {
            props.fire = 0;
            props.phosphorus = 0;
        }
        double x = living.field_70165_t;
        double y = living.field_70163_u;
        double z = living.field_70161_v;
        if (living.func_70090_H() || living.func_70026_G()) {
            props.fire = 0;
        }
        if (props.fire > 0) {
            --props.fire;
            if ((living.field_70173_aa + living.func_145782_y()) % 15 == 0) {
                living.field_70170_p.func_72908_a(living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 2.0f), living.field_70161_v, "random.fizz", 1.0f, 1.5f + rand.nextFloat() * 0.5f);
            }
            if ((living.field_70173_aa + living.func_145782_y()) % 40 == 0) {
                living.func_70097_a(DamageSource.field_76370_b, 2.0f);
            }
            FlameCreator.composeEffect(entity.field_70170_p, x - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), y + rand.nextDouble() * (double)living.field_70131_O, z - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), FlameCreator.META_FIRE);
        }
        if (props.phosphorus > 0) {
            --props.phosphorus;
            if ((living.field_70173_aa + living.func_145782_y()) % 15 == 0) {
                living.field_70170_p.func_72908_a(living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 2.0f), living.field_70161_v, "random.fizz", 1.0f, 1.5f + rand.nextFloat() * 0.5f);
            }
            if ((living.field_70173_aa + living.func_145782_y()) % 40 == 0) {
                living.func_70097_a(DamageSource.field_76370_b, 5.0f);
            }
            FlameCreator.composeEffect(entity.field_70170_p, x - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), y + rand.nextDouble() * (double)living.field_70131_O, z - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), FlameCreator.META_FIRE);
        }
        if (props.balefire > 0) {
            --props.balefire;
            if ((living.field_70173_aa + living.func_145782_y()) % 15 == 0) {
                living.field_70170_p.func_72908_a(living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 2.0f), living.field_70161_v, "random.fizz", 1.0f, 1.5f + rand.nextFloat() * 0.5f);
            }
            ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 5.0f);
            if ((living.field_70173_aa + living.func_145782_y()) % 20 == 0) {
                living.func_70097_a(DamageSource.field_76370_b, 5.0f);
            }
            FlameCreator.composeEffect(entity.field_70170_p, x - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), y + rand.nextDouble() * (double)living.field_70131_O, z - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), FlameCreator.META_BALEFIRE);
        }
        if (props.blackFire > 0) {
            --props.blackFire;
            if ((living.field_70173_aa + living.func_145782_y()) % 10 == 0) {
                living.field_70170_p.func_72908_a(living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 2.0f), living.field_70161_v, "random.fizz", 1.0f, 1.5f + rand.nextFloat() * 0.5f);
            }
            ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 5.0f);
            if ((living.field_70173_aa + living.func_145782_y()) % 10 == 0) {
                living.func_70097_a(DamageSource.field_76370_b, 10.0f);
            }
            FlameCreator.composeEffect(entity.field_70170_p, x - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), y + rand.nextDouble() * (double)living.field_70131_O, z - (double)(living.field_70130_N / 2.0f) + (double)living.field_70130_N * rand.nextDouble(), FlameCreator.META_BLACK);
        }
        if (!(props.fire <= 0 && props.phosphorus <= 0 && props.balefire <= 0 && props.blackFire <= 0 || entity.func_70089_S())) {
            ConfettiUtil.decideConfetti(living, DamageSource.field_76370_b);
        }
    }

    private static void handleDashing(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            HbmPlayerProps props = HbmPlayerProps.getData(player);
            props.setDashCount(0);
            ArmorFSB chestplate = null;
            int armorDashCount = 0;
            int armorModDashCount = 0;
            if (ArmorFSB.hasFSBArmor(player)) {
                ItemStack plate = player.field_71071_by.field_70460_b[2];
                chestplate = (ArmorFSB)plate.func_77973_b();
            }
            if (chestplate != null) {
                armorDashCount = chestplate.dashCount;
            }
            for (int armorSlot = 0; armorSlot < 4; ++armorSlot) {
                ItemStack armorStack = player.field_71071_by.field_70460_b[armorSlot];
                if (armorStack == null || !(armorStack.func_77973_b() instanceof ItemArmor)) continue;
                for (int modSlot = 0; modSlot < 8; ++modSlot) {
                    ItemStack mod = ArmorModHandler.pryMods(armorStack)[modSlot];
                    if (mod == null || !(mod.func_77973_b() instanceof IArmorModDash)) continue;
                    int count = ((IArmorModDash)mod.func_77973_b()).getDashes();
                    armorModDashCount += count;
                }
            }
            int dashCount = armorDashCount + armorModDashCount;
            boolean dashActivated = props.getKeyPressed(HbmKeybinds.EnumKeybind.DASH);
            if (dashCount * 30 < props.getStamina()) {
                props.setStamina(dashCount * 30);
            }
            if (dashCount > 0) {
                int perDash = 30;
                int stamina = props.getStamina();
                props.setDashCount(dashCount);
                if (props.getDashCooldown() <= 0) {
                    if (dashActivated && stamina >= perDash) {
                        Vec3 lookingIn = player.func_70040_Z();
                        Vec3 strafeVec = player.func_70040_Z();
                        strafeVec.func_72442_b(1.5707964f);
                        int forward = (int)Math.signum(player.field_70701_bs);
                        int strafe = (int)Math.signum(player.field_70702_br);
                        if (forward == 0 && strafe == 0) {
                            forward = 1;
                        }
                        player.func_70024_g(lookingIn.field_72450_a * (double)forward + strafeVec.field_72450_a * (double)strafe, 0.0, lookingIn.field_72449_c * (double)forward + strafeVec.field_72449_c * (double)strafe);
                        player.field_70181_x = 0.0;
                        player.field_70143_R = 0.0f;
                        player.func_85030_a("hbm:player.dash", 1.0f, 1.0f);
                        props.setDashCooldown(5);
                        stamina -= perDash;
                    }
                } else {
                    props.setDashCooldown(props.getDashCooldown() - 1);
                }
                if (stamina < props.getDashCount() * perDash && ++stamina % perDash == perDash - 1) {
                    player.func_85030_a("hbm:player.dashRecharge", 1.0f, 1.0f + 0.083333336f * (float)(stamina / perDash));
                    ++stamina;
                }
                props.setStamina(stamina);
            }
        }
    }

    private static void handlePlinking(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            HbmPlayerProps props = HbmPlayerProps.getData(player);
            if (props.plinkCooldown > 0) {
                --props.plinkCooldown;
            }
        }
    }

    private static boolean canVomit(Entity e) {
        return !e.isCreatureType(EnumCreatureType.waterCreature, false);
    }
}

