/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.saveddata.TomSaveData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class ImpactWorldHandler {
    public static World lastSyncWorld = null;
    public static float fire = 0.0f;
    public static float dust = 0.0f;
    public static long time = 0L;
    public static boolean impact = false;

    public static void impactEffects(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        TomSaveData data = TomSaveData.forWorld(world);
        if (data.dust <= 0.0f && data.fire <= 0.0f) {
            return;
        }
        WorldServer serv = (WorldServer)world;
        List list = serv.field_73059_b.field_73245_g;
        int listSize = list.size();
        if (listSize > 0) {
            for (int i = 0; i < 3; ++i) {
                Chunk chunk = (Chunk)list.get(serv.field_73012_v.nextInt(listSize));
                ChunkCoordIntPair coord = chunk.func_76632_l();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (world.field_73012_v.nextBoolean()) continue;
                        int X = coord.func_77273_a() - 8 + x;
                        int Z = coord.func_77274_b() - 8 + z;
                        int Y = world.func_72976_f(X, Z) - world.field_73012_v.nextInt(Math.max(1, world.func_72976_f(X, Z)));
                        if (data.dust > 0.0f) {
                            ImpactWorldHandler.die(world, X, Y, Z);
                        }
                        if (!(data.fire > 0.0f)) continue;
                        ImpactWorldHandler.burn(world, X, Y, Z);
                    }
                }
            }
        }
    }

    public static void die(World world, int x, int y, int z) {
        TomSaveData data = TomSaveData.forWorld(world);
        int light = Math.max(world.func_72972_b(EnumSkyBlock.Block, x, y + 1, z), (int)((float)world.func_72957_l(x, y + 1, z) * (1.0f - data.dust)));
        if (light < 4) {
            if (world.func_147439_a(x, y, z) == Blocks.field_150349_c) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            } else if (world.func_147439_a(x, y, z) instanceof BlockBush) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            } else if (world.func_147439_a(x, y, z) instanceof BlockLeaves) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            } else if (world.func_147439_a(x, y, z) instanceof BlockVine) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
        }
    }

    public static void burn(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isFlammable((IBlockAccess)world, x, y, z, ForgeDirection.UP) && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a && world.func_72972_b(EnumSkyBlock.Sky, x, y + 1, z) >= 7) {
            if (b instanceof BlockLeaves || b instanceof BlockBush) {
                world.func_147468_f(x, y, z);
            }
            world.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
        } else if (!(b != Blocks.field_150349_c && b != Blocks.field_150391_bh && b != ModBlocks.waste_earth && b != ModBlocks.frozen_grass && b != ModBlocks.waste_mycelium || world.func_72951_B(x, y, z) || world.func_72972_b(EnumSkyBlock.Sky, x, y + 1, z) < 7)) {
            world.func_147449_b(x, y, z, ModBlocks.burning_earth);
        } else if (b == ModBlocks.frozen_dirt && world.func_72972_b(EnumSkyBlock.Sky, x, y + 1, z) >= 7) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static float getFireForClient(World world) {
        if (world != lastSyncWorld) {
            return 0.0f;
        }
        return fire;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getDustForClient(World world) {
        if (world != lastSyncWorld) {
            return 0.0f;
        }
        return dust;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getImpactForClient(World world) {
        if (world != lastSyncWorld) {
            return false;
        }
        return impact;
    }

    @SideOnly(value=Side.CLIENT)
    public static long getTimeForClient(World world) {
        if (world != lastSyncWorld) {
            return 0L;
        }
        return time;
    }
}

