/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBedrockOre;
import com.hbm.main.MainRegistry;
import com.hbm.util.Compat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShredderRecipes
extends SerializableRecipe {
    public static HashMap<RecipesCommon.ComparableStack, ItemStack> shredderRecipes = new HashMap();
    public static HashMap<Object, Object> neiShredderRecipes;

    @Override
    public void registerPost() {
        String[] names = OreDictionary.getOreNames();
        for (int i = 0; i < names.length; ++i) {
            ItemStack dust;
            ArrayList matches;
            String name = names[i];
            if (name == null || name.isEmpty() || name.contains("Any") || (matches = OreDictionary.getOres((String)name)) == null || matches.isEmpty()) continue;
            ShredderRecipes.generateRecipes("ingot", name, matches, 1);
            ShredderRecipes.generateRecipes("plate", name, matches, 1);
            ShredderRecipes.generateRecipes("gem", name, matches, 1);
            ShredderRecipes.generateRecipes("crystal", name, matches, 1);
            ShredderRecipes.generateRecipes("ore", name, matches, 2);
            if (name.length() > 5 && name.substring(0, 5).equals("block") && (dust = ShredderRecipes.getDustByName(name.substring(5))) != null && dust.func_77973_b() != ModItems.scrap) {
                dust.field_77994_a = 9;
                if (ShredderRecipes.getIngotOrGemByName(name.substring(5)) == null) {
                    dust.field_77994_a = 4;
                }
                for (ItemStack stack : matches) {
                    ShredderRecipes.putIfValid(stack, dust, name);
                }
            }
            if (name.length() > 7 && name.substring(0, 8).equals("dustTiny")) {
                for (ItemStack stack : matches) {
                    ShredderRecipes.putIfValid(stack, new ItemStack(ModItems.dust_tiny), name);
                }
                continue;
            }
            if (name.length() <= 3 || !name.substring(0, 4).equals("dust")) continue;
            for (ItemStack stack : matches) {
                ShredderRecipes.putIfValid(stack, new ItemStack(ModItems.dust), name);
            }
        }
    }

    @Untested
    private static void generateRecipes(String prefix, String name, List<ItemStack> matches, int outCount) {
        String matName;
        ItemStack dust;
        int len = prefix.length();
        if (name.length() > len && name.substring(0, len).equals(prefix) && (dust = ShredderRecipes.getDustByName(matName = name.substring(len))) != null && dust.func_77973_b() != ModItems.scrap) {
            dust.field_77994_a = outCount;
            for (ItemStack stack : matches) {
                ShredderRecipes.putIfValid(stack, dust, name);
            }
        }
    }

    private static void putIfValid(ItemStack in, ItemStack dust, String name) {
        if (in != null) {
            if (in.func_77973_b() != null) {
                ShredderRecipes.setRecipe(new RecipesCommon.ComparableStack(in), dust);
            } else {
                MainRegistry.logger.error("Ore dict entry '" + name + "' has a null item in its stack! How does that even happen?");
                Thread.currentThread();
                Thread.dumpStack();
            }
        } else {
            MainRegistry.logger.error("Ore dict entry '" + name + "' has a null stack!");
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    @Override
    public void registerDefaults() {
        Block arMoonTurfDark;
        Block arMoonTurf;
        int i;
        ShredderRecipes.setRecipe(Items.field_151015_O, new ItemStack(ModItems.flour));
        ShredderRecipes.setRecipe(ModItems.scrap, new ItemStack(ModItems.dust));
        ShredderRecipes.setRecipe(ModItems.dust, new ItemStack(ModItems.dust));
        ShredderRecipes.setRecipe(ModItems.dust_tiny, new ItemStack(ModItems.dust_tiny));
        ShredderRecipes.setRecipe(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO, 4));
        ShredderRecipes.setRecipe(ModBlocks.reinforced_light, new ItemStack(Items.field_151114_aO, 4));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_glowstone, 1, Short.MAX_VALUE), new ItemStack(Items.field_151114_aO, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 0), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 1), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 2), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(Blocks.field_150370_cb, new ItemStack(ModItems.powder_quartz, 3));
        ShredderRecipes.setRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 7), new ItemStack(ModItems.powder_quartz, 2));
        ShredderRecipes.setRecipe(Items.field_151128_bU, new ItemStack(ModItems.powder_quartz));
        ShredderRecipes.setRecipe(Blocks.field_150449_bY, new ItemStack(ModItems.powder_quartz, 2));
        ShredderRecipes.setRecipe(ModBlocks.ore_quartz, new ItemStack(ModItems.powder_quartz, 2));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_fire, 1, Short.MAX_VALUE), new ItemStack(ModItems.powder_fire, 6));
        ShredderRecipes.setRecipe(ModBlocks.ore_fire, new ItemStack(ModItems.powder_fire, 6));
        ShredderRecipes.setRecipe(Blocks.field_150403_cj, new ItemStack(ModItems.powder_ice, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_light, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(ModBlocks.concrete, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.concrete_smooth, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_mossy, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_cracked, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_broken, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_obsidian, new ItemStack(ModBlocks.gravel_obsidian, 1));
        ShredderRecipes.setRecipe(Blocks.field_150343_Z, new ItemStack(ModBlocks.gravel_obsidian, 1));
        ShredderRecipes.setRecipe(ModBlocks.ore_oil_empty, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.ore_gas_empty, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150347_e, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150417_aV, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150351_n, new ItemStack((Block)Blocks.field_150354_m, 1));
        ShredderRecipes.setRecipe(Blocks.field_150336_V, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150389_bf, new ItemStack(Items.field_151119_aD, 3));
        ShredderRecipes.setRecipe(Items.field_151162_bE, new ItemStack(Items.field_151119_aD, 3));
        ShredderRecipes.setRecipe(Items.field_151118_aC, new ItemStack(Items.field_151119_aD, 1));
        ShredderRecipes.setRecipe(Blocks.field_150322_A, new ItemStack((Block)Blocks.field_150354_m, 4));
        ShredderRecipes.setRecipe(Blocks.field_150372_bz, new ItemStack((Block)Blocks.field_150354_m, 6));
        ShredderRecipes.setRecipe(Blocks.field_150435_aG, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150405_ch, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150335_W, new ItemStack(Items.field_151016_H, Compat.isModLoaded("gregtech") ? 4 : 5));
        ShredderRecipes.setRecipe(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.LIMESTONE), new ItemStack(ModItems.powder_limestone, 4));
        ShredderRecipes.setRecipe(ModBlocks.stone_gneiss, new ItemStack(ModItems.powder_lithium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.powder_lapis, new ItemStack(ModItems.powder_cobalt_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_neodymium, new ItemStack(ModItems.powder_neodymium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_cobalt, new ItemStack(ModItems.powder_cobalt_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_niobium, new ItemStack(ModItems.powder_niobium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_cerium, new ItemStack(ModItems.powder_cerium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_lanthanium, new ItemStack(ModItems.powder_lanthanium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_actinium, new ItemStack(ModItems.powder_actinium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_boron, new ItemStack(ModItems.powder_boron_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_meteorite, new ItemStack(ModItems.powder_meteorite_tiny, 1));
        ShredderRecipes.setRecipe(ModBlocks.block_meteor, new ItemStack(ModItems.powder_meteorite, 10));
        ShredderRecipes.setRecipe((Item)Items.field_151134_bR, new ItemStack(ModItems.powder_magic, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_polished, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_mossy, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_cracked, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_chiseled, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_pillar, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_rare, 1, Short.MAX_VALUE), new ItemStack(ModItems.powder_desh_mix, 1));
        ShredderRecipes.setRecipe(Blocks.field_150482_ag, new ItemStack(ModBlocks.gravel_diamond, 2));
        ShredderRecipes.setRecipe(ModBlocks.ore_sellafield_diamond, new ItemStack(ModBlocks.gravel_diamond, 2));
        ShredderRecipes.setRecipe(ModBlocks.boxcar, new ItemStack(ModItems.powder_steel, 32));
        ShredderRecipes.setRecipe(ModItems.ingot_schrabidate, new ItemStack(ModItems.powder_schrabidate, 1));
        ShredderRecipes.setRecipe(ModBlocks.block_schrabidate, new ItemStack(ModItems.powder_schrabidate, 9));
        ShredderRecipes.setRecipe(ModItems.coal_infernal, new ItemStack(ModItems.powder_coal, 2));
        ShredderRecipes.setRecipe(Items.field_151071_bq, new ItemStack(ModItems.powder_poison, 3));
        ShredderRecipes.setRecipe(Items.field_151170_bI, new ItemStack(ModItems.powder_poison, 1));
        ShredderRecipes.setRecipe(ModBlocks.ore_tektite_osmiridium, new ItemStack(ModItems.powder_tektite, 1));
        ShredderRecipes.setRecipe(Blocks.field_150346_d, new ItemStack(ModItems.dust, 1));
        ShredderRecipes.setRecipe(Items.field_151120_aE, new ItemStack(Items.field_151102_aT, 3));
        ShredderRecipes.setRecipe(Items.field_151034_e, new ItemStack(Items.field_151102_aT, 1));
        ShredderRecipes.setRecipe(Items.field_151172_bF, new ItemStack(Items.field_151102_aT, 1));
        ShredderRecipes.setRecipe(ModItems.crystal_cleaned, new ItemStack(ModItems.mineral_dust, 4));
        ShredderRecipes.setRecipe(ModBlocks.laythe_coral_block, new ItemStack(ModItems.powder_calcium, 4));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_mineral, 1, Short.MAX_VALUE), new ItemStack(ModItems.mineral_dust, 1));
        ShredderRecipes.setRecipe(ModItems.bean_roast, new ItemStack(ModItems.powder_coffee, 1));
        ShredderRecipes.setRecipe(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.LIMESTONE), new ItemStack(ModItems.powder_calcium, 4));
        ShredderRecipes.setRecipe(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.CALCIUM), new ItemStack(ModItems.powder_calcium, 6));
        ShredderRecipes.setRecipe(ModItems.can_empty, new ItemStack(ModItems.powder_aluminium, 2));
        ShredderRecipes.setRecipe(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.RARE), new ItemStack(ModItems.powder_desh_mix));
        ShredderRecipes.setRecipe((Block)Blocks.field_150354_m, new ItemStack(ModItems.dust, 2));
        ShredderRecipes.setRecipe(ModBlocks.block_slag, new ItemStack(ModItems.powder_cement, 4));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_aluminium, 1, Short.MAX_VALUE), OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.CRYOLITE, 2));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.ore_nickel, 1, Short.MAX_VALUE), OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.PENTLANDITE, 2));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.vinyl_log), new ItemStack(ModItems.powder_rubber, 4));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.pvc_log), new ItemStack(ModItems.powder_pvc, 4));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.vinyl_planks), new ItemStack(ModItems.powder_rubber, 1));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.pvc_planks), new ItemStack(ModItems.powder_pvc, 1));
        ArrayList logs = OreDictionary.getOres((String)"logWood");
        ArrayList planks = OreDictionary.getOres((String)"plankWood");
        ArrayList saplings = OreDictionary.getOres((String)"treeSapling");
        ArrayList stones = OreDictionary.getOres((String)"stone");
        ArrayList cobbles = OreDictionary.getOres((String)"cobblestone");
        ArrayList sands = OreDictionary.getOres((String)"sand");
        for (ItemStack log : logs) {
            ShredderRecipes.setRecipe(log, new ItemStack(ModItems.powder_sawdust, 4));
        }
        for (ItemStack plank : planks) {
            ShredderRecipes.setRecipe(plank, new ItemStack(ModItems.powder_sawdust, 1));
        }
        for (ItemStack sapling : saplings) {
            ShredderRecipes.setRecipe(sapling, new ItemStack(Items.field_151055_y, 1));
        }
        for (ItemStack stone : stones) {
            ShredderRecipes.setRecipe(stone, new ItemStack(Blocks.field_150351_n, 1));
        }
        for (ItemStack cobble : cobbles) {
            ShredderRecipes.setRecipe(cobble, new ItemStack(Blocks.field_150351_n, 1));
        }
        for (ItemStack sand : sands) {
            ShredderRecipes.setRecipe(sand, new ItemStack(ModItems.dust, 2));
        }
        for (ItemBedrockOre.EnumBedrockOre ore : ItemBedrockOre.EnumBedrockOre.values()) {
            int i2 = ore.ordinal();
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_bedrock, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_centrifuged, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_cleaned, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_separated, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_purified, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_nitrated, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_nitrocrystalline, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_deepcleaned, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
            ShredderRecipes.setRecipe(new ItemStack(ModItems.ore_seared, 1, i2), new ItemStack(ModItems.ore_enriched, 1, i2));
        }
        for (i = 0; i < 5; ++i) {
            ShredderRecipes.setRecipe(new ItemStack(Items.field_151144_bL, 1, i), new ItemStack(ModItems.biomass, 4));
        }
        ShredderRecipes.setRecipe(ModItems.ingot_schraranium, new ItemStack(ModItems.nugget_schrabidium, 2));
        ShredderRecipes.setRecipe(ModItems.crystal_coal, new ItemStack(ModItems.powder_coal, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_iron, new ItemStack(ModItems.powder_iron, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_gold, new ItemStack(ModItems.powder_gold, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_redstone, new ItemStack(Items.field_151137_ax, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_lapis, new ItemStack(ModItems.powder_lapis, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_diamond, new ItemStack(ModItems.powder_diamond, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_uranium, new ItemStack(ModItems.powder_uranium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_plutonium, new ItemStack(ModItems.powder_plutonium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_thorium, new ItemStack(ModItems.powder_thorium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_titanium, new ItemStack(ModItems.powder_titanium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_sulfur, new ItemStack(ModItems.sulfur, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_niter, new ItemStack(ModItems.niter, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_copper, new ItemStack(ModItems.powder_copper, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_tungsten, new ItemStack(ModItems.powder_tungsten, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_aluminium, new ItemStack(ModItems.powder_aluminium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_fluorite, new ItemStack(ModItems.fluorite, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_beryllium, new ItemStack(ModItems.powder_beryllium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_lead, new ItemStack(ModItems.powder_lead, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_schraranium, new ItemStack(ModItems.nugget_schrabidium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_schrabidium, new ItemStack(ModItems.powder_schrabidium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_rare, new ItemStack(ModItems.powder_desh_mix, 2));
        ShredderRecipes.setRecipe(ModItems.crystal_phosphorus, new ItemStack(ModItems.powder_fire, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_trixite, new ItemStack(ModItems.powder_plutonium, 6));
        ShredderRecipes.setRecipe(ModItems.crystal_lithium, new ItemStack(ModItems.powder_lithium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_starmetal, new ItemStack(ModItems.powder_dura_steel, 6));
        ShredderRecipes.setRecipe(ModItems.crystal_cobalt, new ItemStack(ModItems.powder_cobalt, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_nickel, new ItemStack(ModItems.powder_nickel, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_niobium, new ItemStack(ModItems.powder_niobium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_zinc, new ItemStack(ModItems.powder_zinc, 3));
        ShredderRecipes.setRecipe(ModBlocks.steel_poles, new ItemStack(ModItems.powder_steel_tiny, 2));
        ShredderRecipes.setRecipe(ModBlocks.steel_roof, new ItemStack(ModItems.powder_steel_tiny, 9));
        ShredderRecipes.setRecipe(ModBlocks.steel_wall, new ItemStack(ModItems.powder_steel_tiny, 9));
        ShredderRecipes.setRecipe(ModBlocks.steel_corner, new ItemStack(ModItems.powder_steel_tiny, 18));
        ShredderRecipes.setRecipe(ModBlocks.steel_beam, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.steel_scaffold, 1, Short.MAX_VALUE), new ItemStack(ModItems.powder_steel_tiny, 4));
        ShredderRecipes.setRecipe(ModItems.coil_copper, new ItemStack(ModItems.powder_red_copper, 1));
        ShredderRecipes.setRecipe(ModItems.coil_copper_torus, new ItemStack(ModItems.powder_red_copper, 2));
        ShredderRecipes.setRecipe(ModItems.coil_advanced_alloy, new ItemStack(ModItems.powder_advanced_alloy, 1));
        ShredderRecipes.setRecipe(ModItems.coil_advanced_torus, new ItemStack(ModItems.powder_advanced_alloy, 2));
        ShredderRecipes.setRecipe(ModItems.coil_gold, new ItemStack(ModItems.powder_gold, 1));
        ShredderRecipes.setRecipe(ModItems.coil_gold_torus, new ItemStack(ModItems.powder_gold, 2));
        ShredderRecipes.setRecipe(ModItems.coil_tungsten, new ItemStack(ModItems.powder_tungsten, 1));
        ShredderRecipes.setRecipe(ModItems.coil_magnetized_tungsten, new ItemStack(ModItems.powder_magnetized_tungsten, 1));
        ShredderRecipes.setRecipe(ModBlocks.crate_iron, new ItemStack(ModItems.powder_iron, 8));
        ShredderRecipes.setRecipe(ModBlocks.crate_steel, new ItemStack(ModItems.powder_steel, 8));
        ShredderRecipes.setRecipe(ModBlocks.crate_tungsten, new ItemStack(ModItems.powder_tungsten, 36));
        ShredderRecipes.setRecipe(Blocks.field_150467_bQ, new ItemStack(ModItems.powder_iron, 31));
        ShredderRecipes.setRecipe(ModBlocks.chain, new ItemStack(ModItems.powder_steel_tiny, 1));
        ShredderRecipes.setRecipe(ModBlocks.steel_grate, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(ModItems.pipes_steel, new ItemStack(ModItems.powder_steel, 27));
        ShredderRecipes.setRecipe(new ItemStack(ModItems.bedrock_ore, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150351_n));
        ShredderRecipes.setRecipe(ModBlocks.sellafield_slaked, new ItemStack(Blocks.field_150351_n));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 0), new ItemStack(ModItems.scrap_nuclear, 1));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 1), new ItemStack(ModItems.scrap_nuclear, 2));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 2), new ItemStack(ModItems.scrap_nuclear, 3));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 3), new ItemStack(ModItems.scrap_nuclear, 5));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 4), new ItemStack(ModItems.scrap_nuclear, 7));
        ShredderRecipes.setRecipe(new ItemStack(ModBlocks.sellafield, 1, 5), new ItemStack(ModItems.scrap_nuclear, 15));
        ShredderRecipes.setRecipe(ModBlocks.dirt_dead, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.dirt_oily, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.sand_dirty, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.sand_dirty_red, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.stone_cracked, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.stone_porous, new ItemStack(ModItems.scrap_oil, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_marked, new ItemStack(ModItems.powder_steel, 1));
        for (i = 0; i < 16; ++i) {
            ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150406_ce, 1, i), new ItemStack(Items.field_151119_aD, 4));
            ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150325_L, 1, i), new ItemStack(Items.field_151007_F, 4));
        }
        for (i = 0; i < BlockBobble.BobbleType.values().length; ++i) {
            BlockBobble.BobbleType type = BlockBobble.BobbleType.values()[i];
            ShredderRecipes.setRecipe(new ItemStack(ModBlocks.bobblehead, 1, i), new ItemStack(ModItems.scrap_plastic, 1, type.scrap.ordinal()));
        }
        ShredderRecipes.setRecipe(ModItems.debris_concrete, new ItemStack(ModItems.scrap_nuclear, 2));
        ShredderRecipes.setRecipe(ModItems.debris_shrapnel, new ItemStack(ModItems.powder_steel_tiny, 5));
        ShredderRecipes.setRecipe(ModItems.debris_exchanger, new ItemStack(ModItems.powder_steel, 3));
        ShredderRecipes.setRecipe(ModItems.debris_element, new ItemStack(ModItems.scrap_nuclear, 4));
        ShredderRecipes.setRecipe(ModItems.debris_metal, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(ModItems.debris_graphite, new ItemStack(ModItems.powder_coal, 1));
        Block gcMoonBlock = Compat.tryLoadBlock("GalacticraftCore", "moonBlock");
        if (gcMoonBlock != null && gcMoonBlock != Blocks.field_150350_a) {
            ShredderRecipes.setRecipe(new ItemStack(gcMoonBlock, 1, 3), new ItemStack(ModBlocks.moon_turf));
            ShredderRecipes.setRecipe(new ItemStack(gcMoonBlock, 1, 5), new ItemStack(ModBlocks.moon_turf));
        }
        if ((arMoonTurf = Compat.tryLoadBlock("advancedrocketry", "turf")) != null && arMoonTurf != Blocks.field_150350_a) {
            ShredderRecipes.setRecipe(arMoonTurf, new ItemStack(ModBlocks.moon_turf));
        }
        if ((arMoonTurfDark = Compat.tryLoadBlock("advancedrocketry", "turfDark")) != null && arMoonTurfDark != Blocks.field_150350_a) {
            ShredderRecipes.setRecipe(arMoonTurfDark, new ItemStack(ModBlocks.moon_turf));
        }
    }

    public static ItemStack getDustByName(String name) {
        ArrayList matches = OreDictionary.getOres((String)("dust" + name));
        if (matches != null && !matches.isEmpty()) {
            return Compat.getPreferredOreOutput(matches);
        }
        return new ItemStack(ModItems.scrap);
    }

    public static ItemStack getIngotOrGemByName(String name) {
        ArrayList matches = OreDictionary.getOres((String)("ingot" + name));
        if (matches != null && !matches.isEmpty()) {
            return ((ItemStack)matches.get(0)).func_77946_l();
        }
        matches = OreDictionary.getOres((String)("gem" + name));
        if (matches != null && !matches.isEmpty()) {
            return ((ItemStack)matches.get(0)).func_77946_l();
        }
        return null;
    }

    public static void setRecipe(Item in, ItemStack out) {
        ShredderRecipes.setRecipe(new RecipesCommon.ComparableStack(in), out);
    }

    public static void setRecipe(Block in, ItemStack out) {
        ShredderRecipes.setRecipe(new RecipesCommon.ComparableStack(in), out);
    }

    public static void setRecipe(ItemStack in, ItemStack out) {
        ShredderRecipes.setRecipe(new RecipesCommon.ComparableStack(in), out);
    }

    public static void setRecipe(RecipesCommon.ComparableStack in, ItemStack out) {
        if (!shredderRecipes.containsKey(in)) {
            shredderRecipes.put(in, out);
        }
    }

    public static Map<Object, Object> getShredderRecipes() {
        if (neiShredderRecipes == null) {
            neiShredderRecipes = new HashMap<RecipesCommon.ComparableStack, ItemStack>(shredderRecipes);
        }
        return neiShredderRecipes;
    }

    public static ItemStack getShredderResult(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return new ItemStack(ModItems.scrap);
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        ItemStack sta = shredderRecipes.get(comp);
        if (sta == null) {
            comp.meta = Short.MAX_VALUE;
            sta = shredderRecipes.get(comp);
        }
        return sta == null ? new ItemStack(ModItems.scrap) : sta;
    }

    @Override
    public String getFileName() {
        return "hbmShredder.json";
    }

    @Override
    public Object getRecipeObject() {
        return shredderRecipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        ItemStack stack = ShredderRecipes.readItemStack(obj.get("input").getAsJsonArray());
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        ItemStack out = ShredderRecipes.readItemStack(obj.get("output").getAsJsonArray());
        shredderRecipes.put(comp, out);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry entry = (Map.Entry)recipe;
        writer.name("input");
        ShredderRecipes.writeItemStack(((RecipesCommon.ComparableStack)entry.getKey()).toStack(), writer);
        writer.name("output");
        ShredderRecipes.writeItemStack((ItemStack)entry.getValue(), writer);
    }

    @Override
    public void deleteRecipes() {
        shredderRecipes.clear();
        neiShredderRecipes = null;
    }

    @Override
    public String getComment() {
        return "Ingot/block/ore -> dust recipes are generated in post and can therefore not be changed with the config. Non-auto recipes do not use ore dict.";
    }
}

