/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block;

import com.hbm.blocks.BlockCoral;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderCoral
implements ISimpleBlockRenderingHandler {
    private static final ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.DOWN};

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tess = Tessellator.field_78398_a;
        int colorMult = block.func_149720_d(world, x, y, z);
        float r = (float)(colorMult >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorMult >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorMult & 0xFF) / 255.0f;
        tess.func_78386_a(r, g, b);
        int brightness = block.func_149677_c(world, x, y, z);
        tess.func_78380_c(brightness);
        IIcon icon = block.func_149673_e(world, x, y, z, 0);
        this.renderCrossedSquares(icon, x, y, z, 1.0, this.getAttachment(world, x, y, z));
        return true;
    }

    private ForgeDirection getAttachment(IBlockAccess world, int x, int y, int z) {
        for (ForgeDirection dir : directions) {
            int ox = x + dir.offsetX;
            int oy = y + dir.offsetY;
            int oz = z + dir.offsetZ;
            if (!world.func_147439_a(ox, oy, oz).func_149747_d(world, ox, oy, oz, dir.ordinal())) continue;
            return dir;
        }
        return ForgeDirection.DOWN;
    }

    private void renderCrossedSquares(IIcon icon, double x, double y, double z, double height, ForgeDirection dir) {
        Tessellator tess = Tessellator.field_78398_a;
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        double factor = 0.45 * height;
        double minY = 0.0;
        double maxY = height;
        double minX = 0.5 - factor;
        double maxX = 0.5 + factor;
        double minZ = 0.5 - factor;
        double maxZ = 0.5 + factor;
        double x0 = minX;
        double x1 = minX;
        double x2 = maxX;
        double x3 = maxX;
        double y0 = minY;
        double y1 = maxY;
        double y2 = maxY;
        double y3 = minY;
        double z0 = minZ;
        double z1 = minZ;
        double z2 = maxZ;
        double z3 = maxZ;
        double x4 = maxX;
        double x5 = maxX;
        double x6 = minX;
        double x7 = minX;
        double y4 = minY;
        double y5 = maxY;
        double y6 = maxY;
        double y7 = minY;
        double z4 = minZ;
        double z5 = minZ;
        double z6 = maxZ;
        double z7 = maxZ;
        switch (dir) {
            case UP: {
                y0 = 1.0 - y0;
                y1 = 1.0 - y1;
                y2 = 1.0 - y2;
                y3 = 1.0 - y3;
                y4 = 1.0 - y4;
                y5 = 1.0 - y5;
                y6 = 1.0 - y6;
                y7 = 1.0 - y7;
                break;
            }
            case NORTH: {
                y0 = minZ;
                y1 = minZ;
                y2 = maxZ;
                y3 = maxZ;
                z0 = minY;
                z1 = maxY;
                z2 = maxY;
                z3 = minY;
                y4 = minZ;
                y5 = minZ;
                y6 = maxZ;
                y7 = maxZ;
                z4 = minY;
                z5 = maxY;
                z6 = maxY;
                z7 = minY;
                break;
            }
            case SOUTH: {
                y0 = minZ;
                y1 = minZ;
                y2 = maxZ;
                y3 = maxZ;
                z0 = 1.0 - minY;
                z1 = 1.0 - maxY;
                z2 = 1.0 - maxY;
                z3 = 1.0 - minY;
                y4 = minZ;
                y5 = minZ;
                y6 = maxZ;
                y7 = maxZ;
                z4 = 1.0 - minY;
                z5 = 1.0 - maxY;
                z6 = 1.0 - maxY;
                z7 = 1.0 - minY;
                break;
            }
            case WEST: {
                y0 = minX;
                y1 = minX;
                y2 = maxX;
                y3 = maxX;
                x0 = minY;
                x1 = maxY;
                x2 = maxY;
                x3 = minY;
                y4 = maxX;
                y5 = maxX;
                y6 = minX;
                y7 = minX;
                x4 = minY;
                x5 = maxY;
                x6 = maxY;
                x7 = minY;
                break;
            }
            case EAST: {
                y0 = minX;
                y1 = minX;
                y2 = maxX;
                y3 = maxX;
                x0 = 1.0 - minY;
                x1 = 1.0 - maxY;
                x2 = 1.0 - maxY;
                x3 = 1.0 - minY;
                y4 = maxX;
                y5 = maxX;
                y6 = minX;
                y7 = minX;
                x4 = 1.0 - minY;
                x5 = 1.0 - maxY;
                x6 = 1.0 - maxY;
                x7 = 1.0 - minY;
                break;
            }
        }
        tess.func_78374_a(x + x0, y + y0, z + z0, maxU, maxV);
        tess.func_78374_a(x + x1, y + y1, z + z1, maxU, minV);
        tess.func_78374_a(x + x2, y + y2, z + z2, minU, minV);
        tess.func_78374_a(x + x3, y + y3, z + z3, minU, maxV);
        tess.func_78374_a(x + x3, y + y3, z + z3, maxU, maxV);
        tess.func_78374_a(x + x2, y + y2, z + z2, maxU, minV);
        tess.func_78374_a(x + x1, y + y1, z + z1, minU, minV);
        tess.func_78374_a(x + x0, y + y0, z + z0, minU, maxV);
        tess.func_78374_a(x + x4, y + y4, z + z4, maxU, maxV);
        tess.func_78374_a(x + x5, y + y5, z + z5, maxU, minV);
        tess.func_78374_a(x + x6, y + y6, z + z6, minU, minV);
        tess.func_78374_a(x + x7, y + y7, z + z7, minU, maxV);
        tess.func_78374_a(x + x7, y + y7, z + z7, maxU, maxV);
        tess.func_78374_a(x + x6, y + y6, z + z6, maxU, minV);
        tess.func_78374_a(x + x5, y + y5, z + z5, minU, minV);
        tess.func_78374_a(x + x4, y + y4, z + z4, minU, maxV);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return BlockCoral.renderID;
    }
}

