/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.inventory.container.ContainerNukeAntimatter;
import com.hbm.inventory.gui.GUINukeAntimatter;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityAntimatter
extends TileEntityMachineBase
implements IGUIProvider {
    public boolean loaded;
    public boolean started;
    public int timer = 18000;

    public TileEntityAntimatter() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.nukeAntimatter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLoaded()) {
                this.started = false;
            }
            if (this.started) {
                --this.timer;
                if (this.timer % 20 == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.fstbmbPing", 5.0f, 1.0f);
                }
            }
            if (this.timer <= 0) {
                this.explode();
            }
            this.networkPackNT(250);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.timer);
        buf.writeBoolean(this.isLoaded());
        buf.writeBoolean(this.started);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.timer = buf.readInt();
        this.loaded = buf.readBoolean();
        this.started = buf.readBoolean();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0 && this.isLoaded()) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.fstbmbStart", 5.0f, 1.0f);
            this.started = true;
        }
        if (meta == 1) {
            this.timer = value * 20;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.hasAmatCore() && this.hasRest();
    }

    public boolean hasAmatCore() {
        return this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.pellet_antimatter;
    }

    public boolean hasRest() {
        return this.getRest() > 0;
    }

    public int getRest() {
        if (this.slots[0] != null && this.slots[1] != null && this.slots[3] != null && this.slots[4] != null && this.slots[1].func_77973_b() == ModItems.particle_lead && this.slots[0].func_77973_b() == ModItems.particle_lead && this.slots[3].func_77973_b() == ModItems.ingot_hafnium && this.slots[4].func_77973_b() == ModItems.ingot_hafnium) {
            return 1;
        }
        return 0;
    }

    public void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        EntityBalefire bf = new EntityBalefire(this.field_145850_b);
        bf.antimatter();
        bf.field_70165_t = (double)this.field_145851_c + 0.5;
        bf.field_70163_u = (double)this.field_145848_d + 0.5;
        bf.field_70161_v = (double)this.field_145849_e + 0.5;
        bf.destructionRange = 150;
        this.field_145850_b.func_72838_d((Entity)bf);
        EntityNukeTorex.startFacAnti(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 5, (double)this.field_145849_e + 0.5, 1000.0f);
    }

    public String getMinutes() {
        String mins = "" + this.timer / 1200;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    public String getSeconds() {
        String mins = "" + this.timer / 20 % 60;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.started = nbt.func_74767_n("started");
        this.timer = nbt.func_74762_e("timer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("started", this.started);
        nbt.func_74768_a("timer", this.timer);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerNukeAntimatter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUINukeAntimatter(player.field_71071_by, this);
    }
}

