/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IPropulsion;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Rocket;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineHTR3
extends TileEntityMachineBase
implements IPropulsion,
IFluidStandardReceiver {
    public FluidTank[] tanks = new FluidTank[1];
    private boolean isOn;
    private float speed;
    public double lastTime;
    public double time;
    private float soundtime;
    private AudioWrapper audio;
    private boolean hasRegistered;
    private int fuelCost;
    AxisAlignedBB bb = null;

    public TileEntityMachineHTR3() {
        super(0);
        this.tanks[0] = new FluidTank(Fluids.SUPERHEATED_HYDROGEN, 1280000);
    }

    @Override
    public void func_145845_h() {
        if (!CelestialBody.inOrbit(this.field_145850_b)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hasRegistered) {
                if (this.isFacingPrograde()) {
                    this.registerPropulsion();
                }
                this.hasRegistered = true;
                this.isOn = false;
            }
            for (DirPos pos : this.getConPos()) {
                for (FluidTank tank : this.tanks) {
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            if (this.isOn) {
                this.soundtime += 1.0f;
                if (this.soundtime == 1.0f) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:misc.htrstart", 1.5f, 1.0f);
                } else if (this.soundtime > 20.0f) {
                    this.soundtime = 20.0f;
                }
            } else {
                this.soundtime -= 1.0f;
                if (this.soundtime == 19.0f) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:misc.htrstop", 2.0f, 1.0f);
                } else if (this.soundtime <= 0.0f) {
                    this.soundtime = 0.0f;
                }
            }
            this.networkPackNT(250);
        } else if (this.isOn) {
            this.speed = (float)((double)this.speed + 0.05);
            if (this.speed > 1.0f) {
                this.speed = 1.0f;
            }
            if (this.soundtime > 18.0f) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.keepAlive();
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74780_a("posX", (double)(this.field_145851_c + dir.offsetX * 7));
                data.func_74780_a("posY", (double)(this.field_145848_d + 1));
                data.func_74780_a("posZ", (double)(this.field_145849_e + dir.offsetZ * 7));
                data.func_74778_a("type", this.getContrailType(this.tanks[0].getTankType()));
                data.func_74776_a("scale", 3.0f);
                data.func_74780_a("moX", (double)(dir.offsetX * 10));
                data.func_74780_a("moY", 0.0);
                data.func_74780_a("moZ", (double)(dir.offsetZ * 10));
                data.func_74768_a("maxAge", 40 + this.field_145850_b.field_73012_v.nextInt(40));
                MainRegistry.proxy.effectNT(data);
            }
        } else {
            this.speed = (float)((double)this.speed - 0.05);
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
        this.lastTime = this.time;
        this.time += (double)this.speed;
    }

    private String getContrailType(FluidType type) {
        if (type == Fluids.GAS_WATZ || type == Fluids.WASTEGAS || type == Fluids.GASEOUS_THORIUM_BROMIDE) {
            return "missileContrailMUD";
        }
        if (type == Fluids.GASEOUS_SCHRABIDIUM_BROMIDE) {
            return "missileContrailSCH";
        }
        if (type == Fluids.GASEOUS_URANIUM_BROMIDE || type == Fluids.GASEOUS_PLUTONIUM_BROMIDE) {
            return "missileContrailUP";
        }
        return "missileContrail";
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 6, this.field_145848_d, this.field_145849_e - dir.offsetZ * 6, dir)};
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:misc.htrloop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 27.5f, 1.0f, 20);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isOn);
        buf.writeFloat(this.soundtime);
        buf.writeInt(this.fuelCost);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isOn = buf.readBoolean();
        this.soundtime = buf.readFloat();
        this.fuelCost = buf.readInt();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("on", this.isOn);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOn = nbt.func_74767_n("on");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    public boolean isFacingPrograde() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)) == ForgeDirection.SOUTH;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 11), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 11));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean canPerformBurn(int shipMass, double deltaV) {
        FT_Rocket trait = this.tanks[0].getTankType().getTrait(FT_Rocket.class);
        int isp = trait != null ? trait.getISP() : 300;
        this.fuelCost = SolarSystem.getFuelCost(deltaV, shipMass, isp);
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() >= this.fuelCost) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addErrors(List<String> errors) {
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() >= this.fuelCost) continue;
            errors.add(EnumChatFormatting.RED + I18nUtil.resolveKey(this.func_145838_q().func_149739_a() + ".name", new Object[0]) + " - Insufficient fuel: needs " + this.fuelCost + "mB");
        }
    }

    @Override
    public float getThrust() {
        return 8.0E8f;
    }

    @Override
    public int startBurn() {
        this.isOn = true;
        for (FluidTank tank : this.tanks) {
            tank.setFill(tank.getFill() - this.fuelCost);
        }
        return 80;
    }

    @Override
    public int endBurn() {
        this.isOn = false;
        return 80;
    }

    @Override
    public String getName() {
        return "container.htr";
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }
}

