/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import api.hbm.tile.IPropulsion;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PlasmaNetwork;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineHTRNeo
extends TileEntityMachineBase
implements IPropulsion,
IFluidStandardTransceiverMK2,
IFluidStandardReceiver,
IEnergyReceiverMK2,
IFusionPowerReceiver {
    protected GenNode plasmaNode;
    public long plasmaEnergy;
    public long plasmaEnergySync;
    public long power;
    private boolean hasRegistered;
    public static long maxPower = 1000000000L;
    public static final int COOLANT_USE = 50;
    public static final double PLASMA_EFFICIENCY = 1.35;
    public static long MINIMUM_PLASMA = 5000000L;
    private float speed;
    public double lastTime;
    public double time;
    private float soundtime;
    private AudioWrapper audio;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(Fluids.PERFLUOROMETHYL_COLD, 4000), new FluidTank(Fluids.PERFLUOROMETHYL, 4000)};
    public boolean isOn;
    public int fuelCost;
    AxisAlignedBB bb = null;

    public TileEntityMachineHTRNeo() {
        super(0);
    }

    public boolean hasMinimumPlasma() {
        return this.plasmaEnergy >= MINIMUM_PLASMA;
    }

    public boolean isCool() {
        return this.tanks[0].getFill() >= 50 && this.tanks[1].getFill() + 50 <= this.tanks[1].getMaxFill();
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir;
            if (!this.hasRegistered) {
                if (this.isFacingPrograde()) {
                    this.registerPropulsion();
                }
                this.hasRegistered = true;
                this.isOn = false;
            }
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
            }
            this.plasmaEnergySync = this.plasmaEnergy;
            if (this.plasmaNode == null || this.plasmaNode.expired) {
                dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                this.plasmaNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * -10, this.field_145848_d, this.field_145849_e + dir.offsetZ * -10, PlasmaNetworkProvider.THE_PROVIDER);
                if (this.plasmaNode == null) {
                    this.plasmaNode = new GenNode<PlasmaNetwork>(PlasmaNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * -10, this.field_145848_d, this.field_145849_e + dir.offsetZ * -10)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * -11, this.field_145848_d, this.field_145849_e + dir.offsetZ * -11, dir));
                    UniNodespace.createNode(this.field_145850_b, this.plasmaNode);
                }
            }
            if (this.plasmaNode != null && this.plasmaNode.hasValidNet()) {
                ((NodeNet)this.plasmaNode.net).addReceiver((TileEntityMachineHTRNeo)this);
            }
            dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            this.networkPackNT(200);
            this.plasmaEnergy = 0L;
        } else if (this.isOn) {
            this.speed = (float)((double)this.speed + 0.05);
            if (this.speed > 1.0f) {
                this.speed = 1.0f;
            }
            if (this.soundtime > 18.0f) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.keepAlive();
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74780_a("posX", (double)(this.field_145851_c + dir.offsetX * 12));
                data.func_74780_a("posY", (double)(this.field_145848_d + 1));
                data.func_74780_a("posZ", (double)(this.field_145849_e + dir.offsetZ * 12));
                data.func_74778_a("type", this.tanks[0].getTankType() == Fluids.PLASMA_BF ? "missileContrailbf" : "missileContrailf");
                data.func_74776_a("scale", 3.0f);
                data.func_74780_a("moX", (double)(dir.offsetX * 10));
                data.func_74780_a("moY", 0.0);
                data.func_74780_a("moZ", (double)(dir.offsetZ * 10));
                data.func_74768_a("maxAge", 40 + this.field_145850_b.field_73012_v.nextInt(40));
                MainRegistry.proxy.effectNT(data);
            }
        } else {
            this.speed = (float)((double)this.speed - 0.05);
            if (this.speed < 0.0f) {
                this.speed = 0.0f;
            }
            if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
        this.lastTime = this.time;
        this.time += (double)this.speed;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
        if (!this.field_145850_b.field_72995_K && this.plasmaNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.plasmaNode);
        }
    }

    @Override
    public boolean receivesFusionPower() {
        return true;
    }

    @Override
    public void receiveFusionPower(long fusionPower, double neutronPower) {
        this.plasmaEnergy = fusionPower;
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - rot.offsetX * 5 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 0 - dir.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * -1 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 0 - dir.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 5 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 0 - dir.offsetZ * -3, rot), new DirPos(this.field_145851_c - rot.offsetX * -1 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 0 - dir.offsetZ * -3, rot)};
    }

    @Override
    public boolean canPerformBurn(int shipMass, double deltaV) {
        this.fuelCost = SolarSystem.getFuelCost(deltaV, shipMass, 100);
        if (this.plasmaEnergySync < (long)this.fuelCost) {
            System.out.println("false");
            System.out.println(this.plasmaEnergySync);
            System.out.println(this.fuelCost);
            return false;
        }
        return true;
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.plasmaEnergySync < (long)this.fuelCost) {
            errors.add(EnumChatFormatting.RED + "Insufficient power: needs " + BobMathUtil.getShortNumber(this.fuelCost) + " HE");
        }
        if (!this.isCool()) {
            errors.add(EnumChatFormatting.RED + "Coolant loop not operational!");
        }
    }

    @Override
    public float getThrust() {
        return 1.6E9f;
    }

    @Override
    public int startBurn() {
        this.isOn = true;
        this.plasmaEnergy -= (long)this.fuelCost;
        if (this.isCool()) {
            this.tanks[0].setFill(-50);
            this.tanks[1].setFill(50);
        }
        return 180;
    }

    @Override
    public int endBurn() {
        this.isOn = false;
        return 180;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long p) {
        this.power = p;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.plasmaEnergySync);
        buf.writeBoolean(this.isOn);
        buf.writeInt(this.fuelCost);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.plasmaEnergy = buf.readLong();
        this.isOn = buf.readBoolean();
        this.fuelCost = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("plasma", this.plasmaEnergy);
        nbt.func_74757_a("on", this.isOn);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.plasmaEnergy = nbt.func_74763_f("plasma");
        this.isOn = nbt.func_74767_n("on");
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 11), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 11), (double)(this.field_145851_c + 12), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 12));
        }
        return this.bb;
    }

    @Override
    public String getName() {
        return "container.htrfneo";
    }

    public boolean isFacingPrograde() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)) == ForgeDirection.SOUTH;
    }
}

