/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.inventory.container.ContainerTransporterRocket;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Rocket;
import com.hbm.inventory.gui.GUITransporterRocket;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.tileentity.machine.TileEntityTransporterBase;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransporterRocket
extends TileEntityTransporterBase {
    public boolean hasRocket = true;
    public int launchTicks = 0;
    public int threshold = 0;
    private final int MASS_MULT = 100;
    AxisAlignedBB bb = null;

    public TileEntityTransporterRocket() {
        super(16, 8, 128000, 0, 2, 64000);
        this.tanks[8].setTankType(Fluids.HYDROGEN);
        this.tanks[9].setTankType(Fluids.OXYGEN);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.linkedTransporter != null && this.linkedTransporter instanceof TileEntityTransporterRocket && this.hasRocket == ((TileEntityTransporterRocket)this.linkedTransporter).hasRocket) {
            this.hasRocket = !this.hasRocket;
        }
        this.launchTicks = MathHelper.func_76125_a((int)(this.launchTicks + (this.hasRocket ? -1 : 1)), (int)(this.hasRocket ? -20 : 0), (int)100);
        if (this.field_145850_b.field_72995_K && this.launchTicks > 0 && this.launchTicks < 100) {
            ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5 + (double)this.launchTicks, (double)this.field_145849_e + 0.5, 0.0, -1.0, 0.0);
            if (this.launchTicks < 10) {
                ExplosionLarge.spawnShock(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, 1 + this.field_145850_b.field_73012_v.nextInt(3), 1.0 + this.field_145850_b.field_73012_v.nextGaussian());
            }
        }
    }

    public int getThreshold() {
        return this.threshold == 0 ? 0 : (int)Math.pow(2.0, this.threshold - 1);
    }

    @Override
    protected boolean canSend(TileEntityTransporterBase linkedTransporter) {
        if (this.launchTicks > -20) {
            return false;
        }
        if (((TileEntityTransporterRocket)linkedTransporter).launchTicks < 100) {
            return false;
        }
        if (!this.hasRocket) {
            return false;
        }
        int mass = this.itemCount();
        if (mass < this.getThreshold()) {
            return false;
        }
        FT_Rocket fuelStats = this.tanks[8].getTankType().getTrait(FT_Rocket.class);
        if (fuelStats == null) {
            fuelStats = this.tanks[9].getTankType().getTrait(FT_Rocket.class);
        }
        if (fuelStats == null) {
            return false;
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = CelestialBody.getTarget(linkedTransporter.func_145831_w(), linkedTransporter.field_145851_c, linkedTransporter.field_145849_e);
        int sendCost = Math.min(64000, SolarSystem.getCostBetween(from.body, to.body, mass * 100, (int)fuelStats.getThrust(), fuelStats.getISP(), from.inOrbit, to.inOrbit));
        return this.tanks[8].getFill() >= sendCost && this.tanks[9].getFill() >= sendCost;
    }

    @Override
    protected void hasSent(TileEntityTransporterBase linkedTransporter, int quantitySent) {
        FT_Rocket fuelStats = this.tanks[8].getTankType().getTrait(FT_Rocket.class);
        if (fuelStats == null) {
            fuelStats = this.tanks[9].getTankType().getTrait(FT_Rocket.class);
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = CelestialBody.getTarget(linkedTransporter.func_145831_w(), linkedTransporter.field_145851_c, linkedTransporter.field_145849_e);
        int sendCost = Math.min(64000, SolarSystem.getCostBetween(from.body, to.body, quantitySent * 100, (int)fuelStats.getThrust(), fuelStats.getISP(), from.inOrbit, to.inOrbit));
        this.tanks[8].setFill(this.tanks[8].getFill() - sendCost);
        this.tanks[9].setFill(this.tanks[9].getFill() - sendCost);
        this.hasRocket = false;
        ((TileEntityTransporterRocket)linkedTransporter).hasRocket = true;
    }

    @Override
    protected void hasConnected(TileEntityTransporterBase linkedTransporter) {
        this.hasRocket = true;
        ((TileEntityTransporterRocket)linkedTransporter).hasRocket = false;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTransporterRocket(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITransporterRocket(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.hasRocket);
        buf.writeInt(this.threshold);
        super.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.hasRocket = buf.readBoolean();
        this.threshold = buf.readInt();
        super.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasRocket = nbt.func_74767_n("rocket");
        this.threshold = nbt.func_74762_e("threshold");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("rocket", this.hasRocket);
        nbt.func_74768_a("threshold", this.threshold);
    }

    @Override
    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX - rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ - rot.offsetZ, ForgeDirection.UP), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ + rot.offsetZ, ForgeDirection.UP), new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ - rot.offsetZ, ForgeDirection.UP), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX, this.field_145848_d + 1, this.field_145849_e - dir.offsetZ + rot.offsetZ, ForgeDirection.UP)};
    }

    @Override
    protected DirPos[] getTankPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ * 3, rot)};
    }

    @Override
    protected DirPos[] getInsertPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir)};
    }

    @Override
    protected DirPos[] getExtractPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir.getOpposite())};
    }

    @Override
    public void receiveControl(NBTTagCompound nbt) {
        super.receiveControl(nbt);
        if (nbt.func_74764_b("threshold")) {
            this.threshold = nbt.func_74762_e("threshold");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

