/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PlasmaNetwork;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityFusionBoiler
extends TileEntityLoadedBase
implements IFluidStandardTransceiverMK2,
IFusionPowerReceiver,
SimpleComponent,
CompatHandler.OCComponent {
    protected GenNode plasmaNode;
    public long plasmaEnergy;
    public long plasmaEnergySync;
    public FluidTank[] tanks = new FluidTank[2];
    AxisAlignedBB bb = null;

    public TileEntityFusionBoiler() {
        this.tanks[0] = new FluidTank(Fluids.WATER, 32000);
        this.tanks[1] = new FluidTank(Fluids.SUPERHOTSTEAM, 32000);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.plasmaEnergySync = this.plasmaEnergy;
            this.plasmaEnergy = 0L;
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[0].getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.tryProvide(this.tanks[1], this.field_145850_b, pos);
            }
            if (this.plasmaNode == null || this.plasmaNode.expired) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                this.plasmaNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4, PlasmaNetworkProvider.THE_PROVIDER);
                if (this.plasmaNode == null) {
                    this.plasmaNode = new GenNode<PlasmaNetwork>(PlasmaNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * 5, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 5, dir));
                    UniNodespace.createNode(this.field_145850_b, this.plasmaNode);
                }
            }
            if (this.plasmaNode != null && this.plasmaNode.hasValidNet()) {
                ((NodeNet)this.plasmaNode.net).addReceiver((TileEntityFusionBoiler)this);
            }
            this.networkPackNT(50);
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 1 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - dir.offsetX * 1 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 2, rot.getOpposite())};
    }

    @Override
    public boolean receivesFusionPower() {
        return true;
    }

    @Override
    public void receiveFusionPower(long fusionPower, double neutronPower) {
        this.plasmaEnergy = fusionPower;
        int waterCycles = Math.min(this.tanks[0].getFill(), this.tanks[1].getMaxFill() - this.tanks[1].getFill());
        int steamCycles = (int)Math.min(fusionPower / (long)this.tanks[0].getTankType().getTrait(FT_Heatable.class).getFirstStep().heatReq, (long)waterCycles);
        if (steamCycles > 0) {
            this.tanks[0].setFill(this.tanks[0].getFill() - steamCycles);
            this.tanks[1].setFill(this.tanks[1].getFill() + steamCycles);
            if (this.field_145850_b.field_73012_v.nextInt(200) == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, "hbm:block.boilerGroan", 2.5f, 1.0f);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.plasmaEnergySync);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.plasmaEnergy = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.plasmaNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.plasmaNode);
        }
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)this.field_145848_d, (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fusion_boiler";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPlasmaEnergy(Context context, Arguments args) {
        return new Object[]{this.plasmaEnergySync};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.plasmaEnergySync, this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getPlasmaEnergy", "getFluid", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getPlasmaEnergy": {
                return this.getPlasmaEnergy(context, args);
            }
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

