/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerMachineHydrotreater;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineHydrotreater;
import com.hbm.inventory.recipes.HydrotreatingRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineHydrotreater
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IPersistentNBT,
IGUIProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[4];
    AxisAlignedBB bb = null;

    public TileEntityMachineHydrotreater() {
        super(11);
        this.tanks[0] = new FluidTank(Fluids.OIL, 64000);
        this.tanks[1] = new FluidTank(Fluids.HYDROGEN, 64000).withPressure(1);
        this.tanks[2] = new FluidTank(Fluids.OIL_DS, 24000);
        this.tanks[3] = new FluidTank(Fluids.SOURGAS, 24000);
    }

    @Override
    public String getName() {
        return "container.hydrotreater";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000000L);
            this.tanks[0].setType(9, this.slots);
            this.tanks[0].loadTank(1, 2, this.slots);
            this.tanks[1].loadTank(3, 4, this.slots);
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                this.reform();
            }
            this.tanks[2].unloadTank(5, 6, this.slots);
            this.tanks[3].unloadTank(7, 8, this.slots);
            for (DirPos pos : this.getConPos()) {
                for (int i = 2; i < 4; ++i) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void reform() {
        Tuple.Triplet<FluidStack, FluidStack, FluidStack> out = HydrotreatingRecipes.getOutput(this.tanks[0].getTankType());
        if (out == null) {
            this.tanks[2].setTankType(Fluids.NONE);
            this.tanks[3].setTankType(Fluids.NONE);
            return;
        }
        this.tanks[1].withPressure(out.getX().pressure).setTankType(out.getX().type);
        this.tanks[2].setTankType(out.getY().type);
        this.tanks[3].setTankType(out.getZ().type);
        if (this.power < 20000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        if (this.tanks[1].getFill() < out.getX().fill) {
            return;
        }
        if (this.slots[10] == null || this.slots[10].func_77973_b() != ModItems.catalytic_converter) {
            return;
        }
        if (this.tanks[2].getFill() + out.getY().fill > this.tanks[2].getMaxFill()) {
            return;
        }
        if (this.tanks[3].getFill() + out.getZ().fill > this.tanks[3].getMaxFill()) {
            return;
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        this.tanks[1].setFill(this.tanks[1].getFill() - out.getX().fill);
        this.tanks[2].setFill(this.tanks[2].getFill() + out.getY().fill);
        this.tanks[3].setFill(this.tanks[3].getFill() + out.getZ().fill);
        this.power -= 20000L;
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.tanks[2].readFromNBT(nbt, "t2");
        this.tanks[3].readFromNBT(nbt, "t3");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        this.tanks[2].writeToNBT(nbt, "t2");
        this.tanks[3].writeToNBT(nbt, "t3");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].writeToNBT(data, "" + i);
        }
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].readFromNBT(data, "" + i);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineHydrotreater(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineHydrotreater(player.field_71071_by, this);
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tanks[0];
    }
}

