/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.container.ContainerBatterySocket;
import com.hbm.inventory.gui.GUIBatterySocket;
import com.hbm.items.ModItems;
import com.hbm.tileentity.machine.storage.TileEntityBatteryBase;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBatterySocket
extends TileEntityBatteryBase
implements IRORValueProvider,
IRORInteractive,
IInfoProviderEC {
    public long[] log = new long[20];
    public long delta = 0L;
    public int renderPack = -1;
    AxisAlignedBB bb = null;

    public TileEntityBatterySocket() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.batterySocket";
    }

    @Override
    public void func_145845_h() {
        long prevPower = this.getPower();
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            long avg = (this.getPower() + prevPower) / 2L;
            this.delta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        int renderPack = -1;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.battery_pack) {
            renderPack = this.slots[0].func_77960_j();
        }
        buf.writeInt(renderPack);
        buf.writeLong(this.delta);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.renderPack = buf.readInt();
        this.delta = buf.readLong();
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (stack.func_77973_b() instanceof IBatteryItem) {
            if (i == 0 && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == 0L) {
                return true;
            }
            if (i == 2 && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == ((IBatteryItem)stack.func_77973_b()).getMaxCharge(stack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public long getPower() {
        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IBatteryItem)) {
            return 0L;
        }
        return ((IBatteryItem)this.slots[0].func_77973_b()).getCharge(this.slots[0]);
    }

    @Override
    public void setPower(long power) {
        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IBatteryItem)) {
            return;
        }
        ((IBatteryItem)this.slots[0].func_77973_b()).setCharge(this.slots[0], power);
    }

    @Override
    public long getMaxPower() {
        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IBatteryItem)) {
            return 0L;
        }
        return ((IBatteryItem)this.slots[0].func_77973_b()).getMaxCharge(this.slots[0]);
    }

    @Override
    public long getProviderSpeed() {
        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IBatteryItem)) {
            return 0L;
        }
        short mode = this.getRelevantMode(true);
        return mode == 2 || mode == 1 ? ((IBatteryItem)this.slots[0].func_77973_b()).getDischargeRate(this.slots[0]) : 0L;
    }

    @Override
    public long getReceiverSpeed() {
        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IBatteryItem)) {
            return 0L;
        }
        short mode = this.getRelevantMode(true);
        return mode == 0 || mode == 1 ? ((IBatteryItem)this.slots[0].func_77973_b()).getChargeRate(this.slots[0]) : 0L;
    }

    @Override
    public BlockPos[] getPortPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new BlockPos[]{new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e), new BlockPos(this.field_145851_c - dir.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ), new BlockPos(this.field_145851_c + rot.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ), new BlockPos(this.field_145851_c - dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ)};
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerBatterySocket(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIBatterySocket(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:fill", "VAL:fillpercent", "VAL:delta", "FUN:setmode!mode", "FUN:setmode!mode:fallback", "FUN:setredmode!mode", "FUN:setredmode!mode:fallback", "FUN:setpriority!priority"};
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:fill".equals(name)) {
            return "" + this.getPower();
        }
        if ("VAL:fillpercent".equals(name)) {
            return "" + this.getPower() * 100L / Math.min(this.getMaxPower(), 1L);
        }
        if ("VAL:delta".equals(name)) {
            return "" + this.delta;
        }
        return null;
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if ("FUN:setmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.redLow) {
                this.redLow = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.redLow = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        if ("FUN:setredmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.redHigh) {
                this.redHigh = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.redHigh = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        if ("FUN:setpriority".equals(name) && params.length > 0) {
            IEnergyReceiverMK2.ConnectionPriority p;
            int priority = IRORInteractive.parseInt(params[0], 0, 2) + 1;
            this.priority = p = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, priority));
            this.markChanged();
            return null;
        }
        return null;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74772_a("diff", (this.log[0] - this.log[19]) / 20L);
    }
}

