# 前言

📒 📒 维护此成长路线的原因很简单，如下两点👇

第一，本人喜欢写写博客，整理一些技术知识点，不但可以加深自己的理解，在编写博客的时候还可以锻炼自己的写作能力和表达能力。

第二，知识体系化，把技术栈的知识架构体系化，方便我们有一个全局的认知，也会增强我们对每个部分的理解，每部分之间的联系会看的更加清楚，因为有很多东西道理都是相同的。

文章基本都是自己整理的，也有借鉴别人的地方，都已经加了声明，欢迎大家一起学习，如果发现有**BUG**，望不吝指教！🙏

![image](https://user-images.githubusercontent.com/39233027/173985022-05356609-234a-446f-8297-7612e5fa3171.png)


下面分了几个大的模块 一起来看看吧

# 🐟编程语言

编程语言是我们程序员吃饭的家伙。后端现在比较流行的语言有C语言，C++，Java，Golang，Python等。语言的语法稍有不同，但是原理都是相同的，这些高级语言都是和底层语言或者说是和机器沟通的，只要掌握好任意一门语言，其他的语言学习来会很简单。

## 1. Java语言

### 1.1 Java基础

[Java-为什么禁止把SimpleDateFormat定义成static变量?](https://geekibli.github.io/wiki/Java-为什么禁止把SimpleDateFormat定义成static变量/)  
[Java反射](https://geekibli.github.io/wiki/Java反射/)  
[Java泛型概述](https://geekibli.github.io/wiki/Java泛型/)  
[Java注解概述](https://geekibli.github.io/wiki/Java注解/)  
[hutool导出excel 快速使用](https://geekibli.github.io/wiki/hutool导出excel/)  
[为什么禁止开发人员修改 serialVersionUID 字段的值?](https://geekibli.github.io/wiki/为什么禁止开发人员修改-serialVersionUID-字段的值/)  
[基础面试题目](https://geekibli.github.io/wiki/基础面试题目/)  
[面向对象特征](https://geekibli.github.io/wiki/面向对象特征/)  
[Java位运算你知道多少](https://geekibli.github.io/wiki/Java位运算/)  

### 1.2 Java集合

[极尽HashMap底层原理](https://geekibli.github.io/wiki/极尽HashMap底层原理/)  

### 1.3 Java IO

[Java-NIO技术概述](https://geekibli.github.io/wiki/Java-NIO/)  
[Java-NIO核心组件--buffer](https://geekibli.github.io/wiki/Java-NIO核心组件-buffer/)  
[Java-NIO核心组件--channel](https://geekibli.github.io/wiki/Java-NIO核心组件-channel/)  
[Java-NIO核心组件--selector](https://geekibli.github.io/wiki/Java-NIO核心组件-selector/)  
[Java-传统的BIO](https://geekibli.github.io/wiki/Java-传统的BIO/)  
[netty实现简易RPC调用](https://geekibli.github.io/wiki/netty实现简易RPC调用/)  
[netty实现简易tomcat](https://geekibli.github.io/wiki/netty实现简易tomcat/)  
[基于BIO实现简易tomcat](https://geekibli.github.io/wiki/基于BIO实现简易tomcat/)  

### 1.4 多线程与并发

[Java-CAS原理和底层实现](https://geekibli.github.io/wiki/Java-CAS原理和底层实现/)  
[Java-FutureTask原理](https://geekibli.github.io/wiki/Java-FutureTask原理/)  
[Java-join方法原理解析](https://geekibli.github.io/wiki/Java-join方法原理解析/)  
[Java-synchronized关键字剖析](https://geekibli.github.io/wiki/Java-synchronized关键字剖析/)  
[Java-synchronzied底层原理](https://geekibli.github.io/wiki/Java-synchronzied底层原理/)  
[Java-锁升级过程](https://geekibli.github.io/wiki/Java-锁升级过程/)  
[Java-锁消除和锁膨胀](https://geekibli.github.io/wiki/Java-锁消除和锁膨胀/)  
[Java内存模型](https://geekibli.github.io/wiki/Java内存模型/)  
[Java多线程之ThreadLocal](https://geekibli.github.io/wiki/Java多线程之ThreadLocal/)  
[Java对象头](https://geekibli.github.io/wiki/Java对象头/)  
[Java并发编程-多线程的发展和意义](https://geekibli.github.io/wiki/Java并发编程-多线程的发展和意义/)  
[Java并发编程-深入理解volatile](https://geekibli.github.io/wiki/Java并发编程-深入理解volatile/)  
[Java并发编程之Blocking Queue](https://geekibli.github.io/wiki/Java并发编程之Blocking-Queue/)  
[Java并发编程之Condition机制底层](https://geekibli.github.io/wiki/Java并发编程之Condition机制底层/)  
[Java并发编程之中断机制](https://geekibli.github.io/wiki/Java并发编程之中断机制/)  
[Java并发编程之同步锁](https://geekibli.github.io/wiki/Java并发编程之同步锁/)  
[Java并发编程系列合集](https://geekibli.github.io/wiki/Java并发编程系列合集/)  
[Java并发编程之AQS底层实现与原理](https://geekibli.github.io/wiki/Java并发编程之AQS底层实现与原理/)  
[Java并发编程之深入理解ReentrantLock](https://geekibli.github.io/wiki/Java并发编程之深入理解ReetrantLock/)  
[Java并发编程之CountDownLatch工具](https://geekibli.github.io/wiki/Java并发编程之CountDownLatch工具/)  
[Java并发编程之搞懂线程池](https://geekibli.github.io/wiki/Java并发编程之搞懂线程池-1/)  
[Java并发编程之ConcurrentHashMap实现原理](https://geekibli.github.io/wiki/Java并发编程之ConcurrentHashMap实现原理/)  

### 1.5 深入理解虚拟机

[JVM-Xms,Xmx和Xss](https://geekibli.github.io/wiki/JVM-Xms-Xmx和Xss/)  
[JVM-jmap](https://geekibli.github.io/wiki/JVM-jmap/)  
[JVM-jstack](https://geekibli.github.io/wiki/JVM-jstack/)  
[JVM-jstat](https://geekibli.github.io/wiki/JVM-jstat/)  
[JVM-strace](https://geekibli.github.io/wiki/JVM-strace/)  
[JVM-内存结构](https://geekibli.github.io/wiki/JVM-内存结构/)  
[JVM-垃圾回收机制](https://geekibli.github.io/wiki/JVM-垃圾回收机制/)  
[JVM-深入理解Java虚拟机](https://geekibli.github.io/wiki/JVM-深入理解Java虚拟机/)  
[JVM-对象创建](https://geekibli.github.io/wiki/JVM-对象创建/)  
[JVM-类加载机制](https://geekibli.github.io/wiki/JVM-类加载机制/)  
[JVM-自定义类加载器](https://geekibli.github.io/wiki/JVM-自定义类加载器/)  
[Java内存模型](https://geekibli.github.io/wiki/Java内存模型/)  
[JVM-垃圾收集器](https://geekibli.github.io/wiki/JVM-垃圾收集器/)  


# 🧮计算机网络

**iso七层模型** 👉【物理层】=> 【数据链路层】=> 【网络层】=> 【传输层】=> 【会话层】=> 【表示层】=> 【应用层】  

## TCP协议

这部分学习是按照《极客时间-Web协议详解与抓包实战》陶辉老师的课程学习的，[【课程链接🔗】](https://time.geekbang.org/course/intro/100026801)  

[TCP协议](https://geekibli.github.io/wiki/TCP协议/)  
[TCP-RTO重传计数器的计算](https://geekibli.github.io/wiki/TCP-RTO重传计数器的计算/)   
[TCP-四次挥手/断开连接](https://geekibli.github.io/wiki/TCP-四次挥手-断开连接/)  
[TCP-如何减少小报文提升网络效率](https://geekibli.github.io/wiki/TCP-如何减少小报文提升网络效率/)  
[TCP-拥塞控制之慢启动](https://geekibli.github.io/wiki/TCP-拥塞控制之慢启动/)  
[TCP-滑动窗口](https://geekibli.github.io/wiki/TCP-滑动窗口/)  
[TCP三次握手](https://geekibli.github.io/wiki/TCP三次握手/)  
[TCP头部](https://geekibli.github.io/wiki/TCP头部/)  
[TCP最大报文段（MSS）](https://geekibli.github.io/wiki/TCP最大报文段（MSS）/)  
[TCP超时与重传](https://geekibli.github.io/wiki/TCP超时与重传/)  
[快速重传/快速恢复](https://geekibli.github.io/wiki/快速重传-快速恢复/)  
[拥塞避免](https://geekibli.github.io/wiki/拥塞避免/)  

## HTTP协议

[Http状态码及含义](https://geekibli.github.io/wiki/Http状态码及含义/)  
[https协议](https://geekibli.github.io/wiki/https协议/)  


# 💻操作系统

[Linux常用命令](https://geekibli.github.io/wiki/Linux常用命令/)  
[操作系统-死锁](https://geekibli.github.io/wiki/操作系统-死锁/)  
[操作系统进程调度策略](https://geekibli.github.io/wiki/操作系统进程调度策略/)  
[进程间通信IPC](https://geekibli.github.io/wiki/进程间通信IPC/)  


# 🏠数据库

### MySQL

[Mysql-MVCC多版本并发控制](https://geekibli.github.io/wiki/Mysql-MVCC多版本并发控制/)  
[Mysql-事务特性与实现原理](https://geekibli.github.io/wiki/Mysql-事务特性与实现原理/)  
[mysql配置binlog](https://geekibli.github.io/wiki/binlog配置/)  
[mysql乐观锁实现分布式锁](https://geekibli.github.io/wiki/mysql乐观锁实现分布式锁/)  
[mysql常用命令](https://geekibli.github.io/wiki/mysql常用命令/)  
[修改mysql表创建时间](https://geekibli.github.io/wiki/修改mysql表创建时间/)  
[2021年后端大厂-MySQL](https://geekibli.github.io/wiki/2021年后端大厂-MySQL/)  

### MongoDB

[docker-compost安装mongodb](https://geekibli.github.io/wiki/docker-compost安装mongodb/)  


# 🔍搜索引擎

### elasticsearch

[Parameter index out of range (1 > number of parameters, which is 0).](https://geekibli.github.io/wiki/Parameter-index-out-of-range-1-number-of-parameters-which-is-0/)  
[canal同步es后部分字段为null](https://geekibli.github.io/wiki/canal同步es后部分字段为null/)  
[canal同步mysql数据到elasticsearch](https://geekibli.github.io/wiki/canal同步mysql数据到elasticsearch/)  
[copy_to参数](https://geekibli.github.io/wiki/copy-to参数/)  
[cross-fields跨字段查询](https://geekibli.github.io/wiki/cross-fields跨字段查询/)  
[dis_max查询](https://geekibli.github.io/wiki/dis-max查询/)  
[elasticsearch-analyzer](https://geekibli.github.io/wiki/elasticsearch-analyzer/)  
[elasticsearch-overview](https://geekibli.github.io/wiki/elasticsearch-overview/)  
[elasticsearch 查询值前缀不包含某个字符串](https://geekibli.github.io/wiki/elasticsearch-查询值前缀不包含某个字符串/)  
[elasticsearch分页查询](https://geekibli.github.io/wiki/elasticsearch分页查询/)  
[elasticsearch基础api](https://geekibli.github.io/wiki/elasticsearch基础cat_api/)  
[elasticsearch字符串查询汇总](https://geekibli.github.io/wiki/elasticsearch字符串查询汇总/)  
[elasticsearch操作索引](https://geekibli.github.io/wiki/elasticsearch操作索引/)  
[elasticsearch映射](https://geekibli.github.io/wiki/elasticsearch映射/)  
[elasticsearch稳定性调优](https://geekibli.github.io/wiki/elasticsearch稳定性调优/)  
[elasticsearch统计每年每小时访问量](https://geekibli.github.io/wiki/elasticsearch统计每年每小时访问量/)  
[elasticsearch被破坏的相似度](https://geekibli.github.io/wiki/elasticsearch被破坏的相似度/)  
[elasticsearch调优实践](https://geekibli.github.io/wiki/elasticsearch调优实践-0/)  
[elasticsearch踩坑](https://geekibli.github.io/wiki/elasticsearch踩坑/)  
[elasticsearch重要配置](https://geekibli.github.io/wiki/elasticsearch重要配置/)  
[field name is null or empty](https://geekibli.github.io/wiki/field-name-is-null-or-empty/)  
[most_fields类型](https://geekibli.github.io/wiki/most-fields类型/)  
[kibana添加用户及控制权限](https://geekibli.github.io/wiki/kibana添加用户及控制权限/)  
[multi_match 查询](https://geekibli.github.io/wiki/multi-match-查询/)  
[倒排索引](https://geekibli.github.io/wiki/倒排索引/)  
[关于 Elasticsearch 内存占用及分配](https://geekibli.github.io/wiki/关于-Elasticsearch-内存占用及分配/)  
[分析与分析器](https://geekibli.github.io/wiki/分析与分析器/)  
[启动ELK脚本命令](https://geekibli.github.io/wiki/启动ELK脚本命令/)  
[多桶排序](https://geekibli.github.io/wiki/多桶排序/)  
[多索引多类型搜索](https://geekibli.github.io/wiki/多索引多类型搜索/)  
[字符串排序与多字段](https://geekibli.github.io/wiki/字符串排序与多字段/)  
[嵌套桶](https://geekibli.github.io/wiki/嵌套桶/)  
[段合并](https://geekibli.github.io/wiki/段合并/)  
[统计去重数据 (近似度量)](https://geekibli.github.io/wiki/统计去重数据/)  
[聚合 条形图](https://geekibli.github.io/wiki/聚合-条形图/)  
[聚合 高级概念](https://geekibli.github.io/wiki/聚合-高级概念/)  
[过滤和聚合](https://geekibli.github.io/wiki/过滤和聚合/)  
[elasticsearch-reindex](https://geekibli.github.io/wiki/elasticsearch-reindex/)  


# 🔥NoSQL-Redis

[Redis-overview](https://geekibli.github.io/wiki/Redis-overview/)  
[Redis-list底层实现](https://geekibli.github.io/wiki/Redis-list底层实现/)  
[Redis-哈希表实现](https://geekibli.github.io/wiki/Redis-哈希表实现/)  
[Redis-字符串底层原理](https://geekibli.github.io/wiki/Redis-字符串底层原理/)  
[Redis-缓存穿透、击穿和雪崩](https://geekibli.github.io/wiki/Redis-缓存穿透、击穿和雪崩/)  


# 🍃Spring

## Spring Framework

[SpringBean循环依赖](https://geekibli.github.io/wiki/SpringBean循环依赖/)  
[Spring梳理启动脉络](https://geekibli.github.io/wiki/Spring梳理启动脉络/)  
[Spring加载配置文件原理](https://geekibli.github.io/wiki/Spring加载配置文件原理/)  

## Mybatis

[mybatis-工作原理](https://geekibli.github.io/wiki/mybatis-工作原理/)  



# 🔜 Apache Flink

[apache-flink-overview](https://geekibli.github.io/wiki/apache-flink-overview/)  
[flink 提交任务](https://geekibli.github.io/wiki/flink-提交任务/)  
[Apache Flink](https://geekibli.github.io/wiki/flink简介/)  
[flink简单上手](https://geekibli.github.io/wiki/flink简单上手/)  
[Flink 运行时架构](https://geekibli.github.io/wiki/flink运行时架构/)   



# 🀄️ 消息中间件-Kafka

### kafka

[kafka-overview](https://geekibli.github.io/wiki/kafka-overview/)  
[kafka安装与初体验](https://geekibli.github.io/wiki/kafka安装与初体验/)  



# 🔧开发工具

## Docker

[docker常用手册](https://geekibli.github.io/wiki/docker常用手册/)  
[docker整体架构图](https://geekibli.github.io/wiki/docker整体架构图/)  

## Git

[git常用命令](https://geekibli.github.io/wiki/git常用命令/)    



# 分布式

[分布式-CAP理论](https://geekibli.github.io/wiki/分布式-CAP理论/)  
[分布式-一致性哈希算法](https://geekibli.github.io/wiki/分布式-一致性哈希算法/)  
[分布式-秒杀系统设计](https://geekibli.github.io/wiki/分布式-秒杀系统设计/)  

## 分布式事务
[什么是事务？](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/1.%E4%BB%80%E4%B9%88%E6%98%AF%E4%BA%8B%E5%8A%A1.md)。
[分布式事务解决方案-2PC（两阶段提交）](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/2.%E4%B8%A4%E9%98%B6%E6%AE%B5%E6%8F%90%E4%BA%A42pc%E6%96%B9%E6%A1%88.md)  
[分布式事务解决方案-XA](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/3.XA%E6%96%B9%E6%A1%88.md)  
[Seata方案解决分布式事务](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/4.Seata%E6%96%B9%E6%A1%88.md)  
[Seata两阶段提交方案执行流程](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/5.Seata%E4%B8%A4%E9%98%B6%E6%AE%B5%E6%8F%90%E4%BA%A4%E6%96%B9%E6%A1%88%E6%89%A7%E8%A1%8C%E6%B5%81%E7%A8%8B.md)  
[分布式事务TCC解决方案](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/6.TCC%E4%BA%8B%E5%8A%A1%E8%A7%A3%E5%86%B3%E6%96%B9%E6%A1%88.md)  
[可靠消息最终一致性](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/7.%E5%8F%AF%E9%9D%A0%E6%B6%88%E6%81%AF%E6%9C%80%E7%BB%88%E4%B8%80%E8%87%B4%E6%80%A7%E6%96%B9%E6%A1%88.md)  
[最大努力通知方案](https://github.com/geekibli/distributed-study/blob/main/%E5%88%86%E5%B8%83%E5%BC%8F%E4%BA%8B%E5%8A%A1/8.%E6%9C%80%E5%A4%A7%E5%8A%AA%E5%8A%9B%E9%80%9A%E7%9F%A5%E6%96%B9%E6%A1%88.md)  


# 🍎微服务技术体系

## 微服务安全-OAuth2

- [微服务架构技术栈预览](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/0.%20%E5%BE%AE%E6%9C%8D%E5%8A%A1%E6%9E%B6%E6%9E%84%E6%8A%80%E6%9C%AF%E6%A0%88%E9%A2%84%E8%A7%88.md)
- [微服务安全概述](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/1.%20%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8%E6%A6%82%E8%BF%B0.md)
- [微服务安全要解决哪些问题](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/2.%20%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8%E8%A6%81%E8%A7%A3%E5%86%B3%E5%93%AA%E4%BA%9B%E9%97%AE%E9%A2%98.md)
- [OAuth2最简向导](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/3.%20OAuth2%E6%9C%80%E7%AE%80%E5%90%91%E5%AF%BC.md)
- [OAuth2介绍](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/4.%20OAuth2%E4%BB%8B%E7%BB%8D.md)
- [OAuth2.0有哪些经典的模式](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/5.%20OAuth2.0%E6%9C%89%E5%93%AA%E4%BA%9B%E7%BB%8F%E5%85%B8%E7%9A%84%E6%A8%A1%E5%BC%8F.md)
- [OAuth 2.0模式改如何选型](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/6.%20OAuth%202.0%E6%A8%A1%E5%BC%8F%E6%94%B9%E5%A6%82%E4%BD%95%E9%80%89%E5%9E%8B.md)
- [Spring Security OAuth 2.0介绍](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/7.%20Spring%20Security%20OAuth%202.0%E4%BB%8B%E7%BB%8D.md)
- [OAuth 2.0 代码实操样例](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/8.%20OAuth%202.0%20%E4%BB%A3%E7%A0%81%E5%AE%9E%E6%93%8D%E6%A0%B7%E4%BE%8B.md)
- [Web应用端接入授权服务器](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/9.%20Web%E5%BA%94%E7%94%A8%E7%AB%AF%E6%8E%A5%E5%85%A5%E6%8E%88%E6%9D%83%E6%9C%8D%E5%8A%A1%E5%99%A8.md)
- [JWT令牌原理和实操](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/10.%20JWT%E4%BB%A4%E7%89%8C%E5%8E%9F%E7%90%86%E5%92%8C%E5%AE%9E%E6%93%8D.md)
- [Github社交登录代码实操](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/11.%20Github%E7%A4%BE%E4%BA%A4%E7%99%BB%E5%BD%95%E4%BB%A3%E7%A0%81%E5%AE%9E%E6%93%8D.md)
- [OAuth2 跨站点请求伪造](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/12.%20OAuth2%20%E8%B7%A8%E7%AB%99%E7%82%B9%E8%AF%B7%E6%B1%82%E4%BC%AA%E9%80%A0.md)
- [Openid connect简介](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/13.%20Openid%20connect%E7%AE%80%E4%BB%8B.md)
- [几种微服务安全架构](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8-OAuth2/14.%20%E5%87%A0%E7%A7%8D%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%89%E5%85%A8%E6%9E%B6%E6%9E%84.md)

## 微服务网关Zuul

- [Zuul网关概念和使用场景](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/1.Zuul%E7%BD%91%E5%85%B3%E6%A6%82%E5%BF%B5%E5%92%8C%E5%BA%94%E7%94%A8.md)
- [Zuul网关高级应用场景](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/2.Zuul%E7%BD%91%E5%85%B3%E7%9A%84%E9%AB%98%E7%BA%A7%E5%BA%94%E7%94%A8%E5%9C%BA%E6%99%AF.md)
- [Zuul网关的架构剖析](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/3.Zuul%E7%BD%91%E5%85%B3%E7%9A%84%E6%9E%B6%E6%9E%84%E5%89%96%E6%9E%90.md#zuul%E7%BD%91%E5%85%B3%E7%9A%84%E6%9E%B6%E6%9E%84%E5%89%96%E6%9E%90)
- [Zuul网关代码解析](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/4.Zuul%E7%BD%91%E5%85%B3%E4%BB%A3%E7%A0%81%E8%A7%A3%E6%9E%90.md#zuul%E7%BD%91%E5%85%B3%E4%BB%A3%E7%A0%81%E8%A7%A3%E6%9E%90)
- [前置过滤器测试](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/5.%E5%89%8D%E7%BD%AE%E8%BF%87%E6%BB%A4%E5%99%A8%E6%B5%8B%E8%AF%95.md)
- [路由过滤器实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/6.%E8%B7%AF%E7%94%B1%E8%BF%87%E6%BB%A4%E5%99%A8%E6%B5%8B%E8%AF%95.md)
- [后置过滤器实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/7.%E5%90%8E%E7%BD%AE%E8%BF%87%E6%BB%A4%E5%99%A8%E6%B5%8B%E8%AF%95.md)
- [Zuul网关生产环境部署架构](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/8.%E7%94%9F%E4%BA%A7%E7%8E%AF%E5%A2%83%E9%83%A8%E7%BD%B2%E6%8E%A8%E8%8D%90.md)
- [Zuul路由管理实践](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/9.Zuul%E8%B7%AF%E7%94%B1%E7%AE%A1%E7%90%86%E5%AE%9E%E8%B7%B5.md)
- [基于网关的两层路由体系](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/10.%E5%9F%BA%E4%BA%8E%E7%BD%91%E5%85%B3%E7%9A%84%E4%B8%A4%E5%B1%82%E8%B7%AF%E7%94%B1%E4%BD%93%E7%B3%BB.md)
- [Zuul 2.x介绍](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/11.Zuul%202.x%E4%BB%8B%E7%BB%8D.md)
- [Zuul生产环境最佳实践](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/12.Zuul%E7%94%9F%E4%BA%A7%E7%8E%AF%E5%A2%83%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.md)
- [Zuul网关相关资料](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%BE%AE%E6%9C%8D%E5%8A%A1%E7%BD%91%E5%85%B3-Zuul/13.Zuul%E7%BD%91%E5%85%B3%E7%9B%B8%E5%85%B3%E8%B5%84%E6%96%99.md)

## 调用链监控-Cat

- [调用链监控的需求背景](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/1.%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7%E7%9A%84%E9%9C%80%E6%B1%82%E8%83%8C%E6%99%AF.md)
- [调用链监控的原理](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/2.%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7%E7%9A%84%E5%8E%9F%E7%90%86.md)
- [主流开源调用链监控产品对比](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/3.%E4%B8%BB%E6%B5%81%E5%BC%80%E6%BA%90%E4%BA%A7%E5%93%81%E5%AF%B9%E6%AF%94.md)
- [Cat简介](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/4.Cat%E9%A1%B9%E7%9B%AE%E7%AE%80%E4%BB%8B.md)
- [Cat架构设计](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/5.Cat%E6%9E%B6%E6%9E%84%E8%AE%BE%E8%AE%A1.md)
- [CAT本地部署](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E8%B0%83%E7%94%A8%E9%93%BE%E7%9B%91%E6%8E%A7-Cat/6.Cat%E7%9A%84%E6%9C%AC%E5%9C%B0%E5%AE%89%E8%A3%85.md)

## 配置中心-Apollo
- [配置中心业务需求](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E9%85%8D%E7%BD%AE%E4%B8%AD%E5%BF%83-Apollo/1.%20%E9%85%8D%E7%BD%AE%E4%B8%AD%E5%BF%83%E4%B8%9A%E5%8A%A1%E9%9C%80%E6%B1%82.md)
- [配置的定义和场景](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E9%85%8D%E7%BD%AE%E4%B8%AD%E5%BF%83-Apollo/2.%20%E9%85%8D%E7%BD%AE%E7%9A%84%E5%AE%9A%E4%B9%89%E5%92%8C%E5%9C%BA%E6%99%AF.md)
- [Feature Flagging to Mitigate Risk in Database Migrations](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E9%85%8D%E7%BD%AE%E4%B8%AD%E5%BF%83-Apollo/3.Feature%20Flagging%20to%20Mitigate%20Risk%20in%20Database%20Migrations.md)
- [开关驱动开发的原理和实践](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E9%85%8D%E7%BD%AE%E4%B8%AD%E5%BF%83-Apollo/4.%20%E5%BC%80%E5%85%B3%E9%A9%B1%E5%8A%A8%E5%BC%80%E5%8F%91%E7%9A%84%E5%8E%9F%E7%90%86%E5%92%8C%E5%AE%9E%E8%B7%B5.md)

## 容错与限流-Hystrix

- [容错限流背后的需求](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/1.%E5%AE%B9%E9%94%99%E9%99%90%E6%B5%81%E7%9A%84%E8%83%8C%E6%99%AF%E9%9C%80%E6%B1%82.md)
- [容错限流的原理](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/2.%E5%AE%B9%E9%94%99%E9%99%90%E6%B5%81%E7%9A%84%E5%8E%9F%E7%90%86.md)
- [Netflix Hystrix背景介绍](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/3.hystrix%E8%83%8C%E6%99%AF%E4%BB%8B%E7%BB%8D.md)
- [Hystrix设计原理](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/4.Hystrix%E8%AE%BE%E8%AE%A1%E5%8E%9F%E7%90%86.md)
- [Hystrix的主要概念](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/5.Hystrix%E7%9A%84%E4%B8%BB%E8%A6%81%E6%A6%82%E5%BF%B5.md)
- [信号量隔离和线程池隔离](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/6.%E4%BF%A1%E5%8F%B7%E9%87%8F%E5%92%8C%E7%BA%BF%E7%A8%8B%E6%B1%A0%E9%9A%94%E7%A6%BB.md)
- [Hystrix主要配置项](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/7.Hystrix%E4%B8%BB%E8%A6%81%E9%85%8D%E7%BD%AE%E9%A1%B9.md)
- [Hystrix基础实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/8.Hystrix%E5%9F%BA%E7%A1%80%E5%AE%9E%E9%AA%8C.md)
- [Hystrix模拟案例分析](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/9.Hystrix%E6%A8%A1%E6%8B%9F%E6%A1%88%E4%BE%8B%E5%88%86%E6%9E%90.md)
- [网关集成Hystrix](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/10.%E7%BD%91%E5%85%B3%E9%9B%86%E6%88%90Hystrix.md)
- [Spring Cloud Hystrix实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/11.SpringCloud%20Hystrix.md)
- [Hystrix生产最佳实践](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E5%AE%B9%E9%94%99%E4%B8%8E%E9%99%90%E6%B5%81-hystrix/13.Hystrix%E7%94%9F%E4%BA%A7%E7%8E%AF%E5%A2%83%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.md)

## 服务发现Eureka&负载均衡Ribbon
- [服务发现的背景](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/1.%E6%9C%8D%E5%8A%A1%E5%8F%91%E7%8E%B0%E7%9A%84%E9%9C%80%E6%B1%82.md)
- [Netflix Eureka 和 Ribbon的背景介绍](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/2.Eureka%E5%92%8CRibbon%E7%9A%84%E8%83%8C%E6%99%AF%E4%BB%8B%E7%BB%8D.md)
- [Eureka架构设计](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/3.Eureka%E5%92%8CRibbon%E6%9E%B6%E6%9E%84%E5%8E%9F%E7%90%86.md)
- [Ribbon架构设计](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/4.Ribbon%E6%9E%B6%E6%9E%84%E5%8E%9F%E7%90%86.md)
- [Eureka和Ribbon高级实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/5.Eureka%E5%92%8CRibbon%E9%AB%98%E7%BA%A7%E5%AE%9E%E9%AA%8C.md)
- [Eureka和Ribbon的主要配置项](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/6.Eureka%E5%92%8CRibbon%E7%9A%84%E4%B8%BB%E8%A6%81%E9%85%8D%E7%BD%AE%E9%A1%B9.md)
- [Eureka自保护模式](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/7.Eureka%E8%87%AA%E4%BF%9D%E6%8A%A4%E6%A8%A1%E5%BC%8F.md)
- [Eureka进阶之健康检查和蓝绿发布](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/8.Eureka%E8%BF%9B%E9%98%B6%E4%B9%8B%E5%81%A5%E5%BA%B7%E6%A3%80%E6%9F%A5%E5%92%8C%E8%93%9D%E7%BB%BF%E5%8F%91%E5%B8%83.md)
- [SpringCloud Zuul/Eurela/Ribbon集成实验](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/9.SpringCloud%20Zuul:Eureka:Ribbon%E9%9B%86%E6%88%90%E5%AE%9E%E9%AA%8C.md)
- [常用服务发现组件比较](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/10.%E5%B8%B8%E7%94%A8%E6%9C%8D%E5%8A%A1%E5%8F%91%E7%8E%B0%E7%BB%84%E4%BB%B6%E6%AF%94%E8%BE%83.md)
- [Service Mesh 和 Istio](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/11.ServiceMesh%E5%92%8CIstio%E7%AE%80%E4%BB%8B.md)
- [基于Eureka+Zuul+容器云的持续交付架构](https://github.com/geekibli/soa_study/blob/main/%E6%9E%81%E5%AE%A2%E6%97%B6%E9%97%B4-%E5%BE%AE%E6%9C%8D%E5%8A%A1%E5%AE%9E%E6%88%98160%E8%AE%B2/%E6%B3%A8%E5%86%8C%E5%8F%91%E7%8E%B0-Eureka/12.%E5%9F%BA%E4%BA%8EEureka%2BZuul%2B%E5%AE%B9%E5%99%A8%E4%BA%91%E7%9A%84%E6%8C%81%E7%BB%AD%E4%BA%A4%E4%BB%98%E6%9E%B6%E6%9E%84.md)


## 监控模块-Prometheus
- [监控模式的分类](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/1.监控模式的分类.md)
- [BusDevOps和测量驱动开发MDD](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/2.BusDevOps和测量驱动开发MDD.md)
- [Prometheus简介](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/3.Prometheus简介.md)
- [Prometheus起步查询实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/4.Prometheus起步查询实验.md)
- [Prometheus+grafana实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/5.prometheus%2Bgrafana实验.md)
- [Prometheus+Alertmanager告警实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/6.Prometheus%2BAlertmanager告警实验.md)
- [Java应用埋点和监控实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/7.Java应用埋点和监控实验.md)
- [NodeExports系统监控实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/8.NodeExports系统监控实验.md)
- [SpringBoot Actuator监控实验](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/9.Spring%20Boot%20Actuator%20监控实验.md)
- [Prometheus生产最佳实践](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/10.Prometheus生产最佳实践.md)
- [主流开源时序数据库对比](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/11.主流开源时序数据库对比.md)
- [微服务监控体系总结](https://github.com/geekibli/soa_study/blob/main/极客时间-微服务实战160讲/监控模块-Prometheus/12.微服务监控体系总结.md)


# 🤔 设计模式

[设计模式之美-享元模式](https://geekibli.github.io/wiki/设计模式之美-享元模式/)  
[设计模式之美-单例模式](https://geekibli.github.io/wiki/设计模式之美-单例模式/)  
[设计模式之美-原型模式](https://geekibli.github.io/wiki/设计模式之美-原型模式/)  
[设计模式之美-工厂模式](https://geekibli.github.io/wiki/设计模式之美-工厂模式/)  
[设计模式之美-建造者模式](https://geekibli.github.io/wiki/设计模式之美-建造者模式/)  
[设计模式之美-桥接模式](https://geekibli.github.io/wiki/设计模式之美-桥接模式/)  
[设计模式之美-策略模式](https://geekibli.github.io/wiki/设计模式之美-策略模式/)  
[设计模式之美-装饰器模式](https://geekibli.github.io/wiki/设计模式之美-装饰器模式/)  
[设计模式之美-观察者模式](https://geekibli.github.io/wiki/设计模式之美-观察者模式/)  
[设计模式之美-责任链模式](https://geekibli.github.io/wiki/设计模式之美-责任链模式/)  
[设计模式之美-适配器模式](https://geekibli.github.io/wiki/设计模式之美-适配器模式/)  
[设计模式之美-门面模式](https://geekibli.github.io/wiki/设计模式之美-门面模式/)  



# 👩‍🏫 面试题

[2021年后端大厂-MySQL](https://geekibli.github.io/wiki/2021年后端大厂-MySQL/)  
[2021年后端大厂-算法面试合集](https://geekibli.github.io/wiki/2021年后端大厂-算法面试合集/)  
[2021年后端大厂-计算机网络](https://geekibli.github.io/wiki/2021年后端大厂-计算机网络/)  





<p align=center><b>两年学说话 一生学闭嘴</b></p>
