---
title: Spring-面试官问题什么是IOC
toc: true
date: 2021-09-03 13:56:20
tags:
categories:
---



## 1、思路

1、首先明确什么是IOC，明确什么是DI，IOC和DI有什么关系

2、说明什么是IOC之后，明确为什么需要 IOC，或者IOC的优点

3、然后是IOC是如何实现的

---

### 2、概述

### 什么是IOC

Spring IOC 解决的是 **对象管理和对象依赖的问题**。Spring AOP 解决的是 **非业务代码抽取的问题**。

> Spring IOC 解决的是**对象管理和对象依赖的问题**。本来我们的对象都是`new`出来的，而我们如果使用`Spring` 则把对象交给「**IOC容器**」来管理。

「IOC容器」是什么？我们可以理解为是一个「**工厂**」，我们把对象都交由这个「工厂」来管理，包括对象的创建和对象之间的依赖关系等等。等我们要用到对象的时候，就从这个「工厂」里边取出来。

「控制反转」指的就是：本来是「**由我们自己**」`new`出来的对象，现在交给了IOC容器。把这个对象的「控制权」给「他方」了。「控制反转」更多的是一种**思想**或者说是**设计模式**，把原有由自己掌控的事交给「别人」来处理。

「依赖注入」更多指的是「控制反转」这个思想的**实现方式**：对象**无需自行创建或管理它们的依赖关系**，依赖关系将被**「自动注入」**到需要它们的对象当中去。

最简单理解「依赖注入」和「控制反转」：本来我们的对象都是「**由我们自己**」`new`出来的，现在我们把这个对象的创建权限和对象之间的依赖关系交由「IOC容器」来管理。

### 使用IOC有什么好处

- **将对象集中统一管理，便于修改**
- 降低耦合度（调用方无需自己组装，也无需关心对象的实现，直接从「IOC容器」取就好了）

### IOC如何设计实现的

既然已经说到，IOC可以帮助我们管理对象，那么我们的对象是如何交给IOC的呢？

Spring提供了四种方式：

- 注解
- XML
- JavaConfig
- 基于Groovy DSL配置

我们以XML配置+注解来装配Bean比较多，其中**注解这种方式占大部分。**



## 依赖注入

**Spring使用依赖注入来实现对象之间的依赖关系, 在创建完对象之后，对象的关系处理就是依赖注入**

Spring提供了好几种的方式来给属性赋值

- **1) 通过构造函数**
- **2) 通过set方法给属性注入值**
- **3) p名称空间**
- **4) 自动装配**
- **5) 注解**







## 参考资料

[三歪讲Spring](https://mp.weixin.qq.com/s?__biz=MzI4Njg5MDA5NA==&mid=2247487013&idx=1&sn=f0d8c292738eb49bcd09cb2f6458dc69&chksm=ebd74f24dca0c632fa3ef8f205a2dd5c96531f78a68eae805e15b84de0b59774196a188aed14&token=306734573&lang=zh_CN#rd)

[工厂模式理解了没有](https://mp.weixin.qq.com/s?__biz=MzI4Njg5MDA5NA==&mid=2247484243&idx=1&sn=972cbe6cdb578256e4d4771e7ca25de3&chksm=ebd74252dca0cb44419903758e8ca52d9ab287562f80be9365e305d6dcc2deaa45b40f9fd2e9&scene=21###wechat_redirect)

[Spring依赖注入就是这么简单](https://mp.weixin.qq.com/s?__biz=MzI4Njg5MDA5NA==&mid=2247483946&idx=1&sn=bb21dfd83cf51214b2789c9ae214410f&chksm=ebd7432bdca0ca3ded6ad9b50128d29267f1204bf5722e5a0501a1d38af995c1ee8e37ae27e7&scene=21###wechat_redirect)

