# 8.MapperScan后置处理器

[**课程地址**](https://www.bilibili.com/video/BV1P44y1N7QG/?p=25&spm_id_from=pageDriver&vd_source=3ff1db20d26ee8426355e893ae553d51)

下面是自定义的后置处理器，实现的功能是将mapper的beanDefinition注册到bean工厂。

## 8.1目录结构

![](https://oscimg.oschina.net/oscnet/up-e7b044aadd0e4dee2b9c399ef265a7729ed.png)

## 8.2 配置文件

```java
@Configuration
@ComponentScan("com.example.testspring.a05.Component")
public class Config {

    @Bean
    public Bean1 bean1() {
        return new Bean1();
    }

    public Bean2 bean2() {
        return new Bean2();
    }

//    @Bean(initMethod = "init")
//    public Bean3 bean3(Bean1 bean1) {
//        return new Bean3();
//    }

    @Bean
    public SqlSessionFactoryBean sqlSessionFactoryBean (DataSource dataSource) {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        return sqlSessionFactoryBean;
    }


    @Bean
    public DataSource dataSource(){
        DruidDataSource dataSource = new DruidDataSource();
        return dataSource;
    }

//    @Bean
//    MapperFactoryBean<Mapper1> mapper1 (SqlSessionFactory sqlSessionFactory) {
//        MapperFactoryBean<Mapper1> factoryBean = new MapperFactoryBean<>();
//        factoryBean.setSqlSessionFactory(sqlSessionFactory);
//        return factoryBean;
//    }
//
//    @Bean
//    MapperFactoryBean<Mapper2> mapper2 (SqlSessionFactory sqlSessionFactory) {
//        MapperFactoryBean<Mapper2> factoryBean = new MapperFactoryBean<>();
//        factoryBean.setSqlSessionFactory(sqlSessionFactory);
//        return factoryBean;
//    }


}
```

## 8.3自定义后置处理器

```java
public class MapperPostProcessor implements BeanDefinitionRegistryPostProcessor {

    @SneakyThrows
    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanFactory) throws BeansException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resourcePatternResolver.getResources("com/example/testspring/a05/mapper/**/*.class");
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory();

        AnnotationBeanNameGenerator generator = new AnnotationBeanNameGenerator();

        for (Resource resource :  resources) {
            MetadataReader reader = factory.getMetadataReader(resource);
            ClassMetadata classMetadata = reader.getClassMetadata();
            if (classMetadata.isInterface()) {

                // 定义beanDefinition

                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(MapperFactoryBean.class)
                        .addConstructorArgValue(classMetadata.getClassName())
                        .setAutowireMode(AbstractBeanDefinition.AUTOWIRE_BY_TYPE)
                        .getBeanDefinition();
							
              // 这个地方需要注意
                AbstractBeanDefinition nameBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(classMetadata.getClassName()).getBeanDefinition();

                String beanName = generator.generateBeanName(nameBeanDefinition, beanFactory);
                beanFactory.registerBeanDefinition(beanName, beanDefinition);
            }
        }

    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {

    }
}
```

## 8.4后置处理器测试

https://github.com/geekibli/demo-spring/blob/54eb8789b7584847263493e1ee70045085aa3fef/src/main/java/com/example/testspring/a05/A05Application1.java

```java
public class A05Application1 {
    @SneakyThrows
    public static void main(String[] args) {
        GenericApplicationContext context = new GenericApplicationContext();
        context.registerBean("config", Config.class);

        context.registerBean(AtBeanPostProcessor.class);
        context.registerBean(MapperPostProcessor.class);

        context.refresh();

        for (String name : context.getBeanDefinitionNames()) {
            System.out.println("name : " + name);
        }

        context.close();
    }
}
```

**执行结果：**

```
name : config
name : com.example.testspring.a05.AtBeanPostProcessor
name : com.example.testspring.a05.MapperPostProcessor
name : mapper1
name : mapper2
name : bean1
name : sqlSessionFactoryBean
name : dataSource
```



执行结果