---
title: 聚合 高级概念
toc: true
date: 2021-07-08 14:52:35
tags: elasticsearch
categories: [Elasticsearch, Aggregations]
---


## 桶

`桶` 简单来说就是满足特定条件的文档的集合：

- 一个雇员属于 男性 桶或者 女性 桶
- 奥尔巴尼属于 纽约 桶
- 日期2014-10-28属于 十月 桶
当聚合开始被执行，每个文档里面的值通过计算来决定符合哪个桶的条件。如果匹配到，文档将放入相应的桶并接着进行聚合操作。

桶也可以被嵌套在其他桶里面，提供层次化的或者有条件的划分方案。例如，辛辛那提会被放入俄亥俄州这个桶，而 整个 俄亥俄州桶会被放入美国这个桶。

Elasticsearch 有很多种类型的桶，能让你通过很多种方式来划分文档（`时间`、`最受欢迎的词`、`年龄区间`、`地理位置` 等等）。其实根本上都是通过同样的原理进行操作：基于条件来划分文档。


## 指标

桶能让我们划分文档到有意义的集合，但是最终我们需要的是对这些桶内的文档进行一些指标的计算。分桶是一种达到目的的手段：它提供了一种给文档分组的方法来让我们可以计算感兴趣的指标。

大多数 `指标` 是简单的数学运算（例如最小值、平均值、最大值，还有汇总），这些是通过文档的值来计算。在实践中，指标能让你计算像平均薪资、最高出售价格、95%的查询延迟这样的数据。



## 桶和指标的组合

`聚合` 是由桶和指标组成的。 聚合可能只有一个桶，可能只有一个指标，或者可能两个都有。也有可能有一些桶嵌套在其他桶里面。例如，我们可以通过所属国家来划分文档（桶），然后计算每个国家的平均薪酬（指标）。

由于桶可以被嵌套，我们可以实现非常多并且非常复杂的聚合：

1.通过国家划分文档（桶）

2.然后通过性别划分每个国家（桶）

3.然后通过年龄区间划分每种性别（桶）

4.最后，为每个年龄区间计算平均薪酬（指标）

最后将告诉你每个 <国家, 性别, 年龄> 组合的平均薪酬。所有的这些都在一个请求内完成并且只遍历一次数据！