---
title: Java-synchronized关键字剖析
toc: true
date: 2021-07-29 13:37:27
tags: 多线程
categories:
---

之前写过一篇关于synchronized关键字的文章，是当时听马士兵老师的公开课时记录的一些关键笔记📒 [链接🔗](https://geekibli.github.io/wiki/Java-synchronzied%E5%BA%95%E5%B1%82%E5%8E%9F%E7%90%86/)

下面我们还是要学习和总结一下synchronized

## synchronized 特性

- 有序性
`as-if-serial`

不管编译器和CPU如何重排序，必须保证在单线程情况下程序的结果是正确的，还有就是有数据依赖的也是不能重排序的。

```java
int a = 1;
int b = a;
```
这两段是怎么都不能重排序的，b的值依赖a的值，a如果不先赋值，那就为空了。

- 可见性
  主要依靠Java内存模型实现
- 原子性
  通过汇编指令控制
- 可重入
  synchronized锁对象的时候有个计数器，他会记录下线程获取锁的次数，在执行完对应的代码块之后，计数器就会-1，直到计数器清零，就释放锁了
- 不可中断
  不可中断就是指，一个线程获取锁之后，另外一个线程处于阻塞或者等待状态，前一个不释放，后一个也一直会阻塞或者等待，不可以被中断。
  值得一提的是，Lock的tryLock方法是可以被中断的。

## 了解对象头

**Mark Word**：默认存储对象的HashCode，分代年龄和锁标志位信息。这些信息都是与对象自身定义无关的数据，所以Mark Word被设计成一个非固定的数据结构以便在极小的空间内存存储尽量多的数据。它会根据对象的状态复用自己的存储空间，也就是说在运行期间Mark Word里存储的数据会随着锁标志位的变化而变化。

**在64位的虚拟机中：**

![image-20210729145750638](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210729145750638.png)

**32位虚拟机中：**

![image-20210729145831606](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210729145831606.png)

**可以参见之前的文章**  👉  [Java对象头](https://geekibli.github.io/wiki/Java%E5%AF%B9%E8%B1%A1%E5%A4%B4/)

## synchronized实现

之前的文章已经在 `Java代码`、`字节码`、`JVM级别`和`汇编指令`四个级别介绍了synchronzied的实现。
JDK对synchronzied不断的优化，大家熟悉的锁升级过程，其实就是在源码里面，调用了不同的实现去获取获取锁，失败就调用更高级的实现，最后升级完成。

![image-20210729144552761](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210729144552761.png)



升级方向：【 无锁 】 -> 【 偏向锁 】-> 【 轻量级锁 】-> 【 重量级锁 】

Tip：<font color=red>切记这个升级过程是不可逆的</font>；

### 无锁

无锁是指没有对资源进行锁定，所有的线程都能访问并修改同一个资源，但同时只有一个线程能修改成功。

无锁的特点是修改操作会在循环内进行，线程会不断的尝试修改共享资源。如果没有冲突就修改成功并退出，否则就会继续循环尝试。如果有多个线程修改同一个值，必定会有一个线程能修改成功，而其他修改失败的线程会不断重试直到修改成功。

### 偏向锁

对象头是由 Mark Word 和 Class pointer 组成，锁争夺也就是对象头指向的Monitor对象的争夺，一旦有线程持有了这个对象，标志位修改为1，就进入偏向模式，同时会把这个线程的ID记录在对象的Mark Word中。

这个过程是采用了`CAS`乐观锁操作的，每次同一线程进入，虚拟机就不进行任何同步的操作了，对标志位+1就好了，不同线程过来，CAS会失败，也就意味着获取锁失败。

偏向锁在1.6之后是默认开启的，1.5中是关闭的，需要手动开启参数是xx:-UseBiasedLocking=false。

初次执行到synchronized代码块的时候，锁对象变成偏向锁（通过CAS修改对象头里的锁标志位），字面意思是“偏向于第一个获得它的线程”的锁。执行完同步代码块后，线程并不会主动释放偏向锁。

当第二次到达同步代码块时，线程会判断此时持有锁的线程是否就是自己（持有锁的线程ID也在对象头里），如果是则正常往下执行。由于之前没有释放锁，这里也就不需要重新加锁。`如果自始至终使用锁的线程只有一个，很明显偏向锁几乎没有额外开销，性能极高。`

偏向锁是指当一段同步代码**一直被同一个线程所访问**时，即不存在多个线程的竞争时，那么该线程在后续访问时便会自动获得锁，从而降低获取锁带来的消耗，即提高性能。

当一个线程访问同步代码块并获取锁时，会在 Mark Word 里存储锁偏向的线程 ID。在线程进入和退出同步块时不再通过 CAS 操作来加锁和解锁，而是检测 Mark Word 里是否存储着指向当前线程的偏向锁。`轻量级锁的获取及释放依赖多次 CAS 原子指令`，而`偏向锁只需要在置换 ThreadID 的时候依赖一次 CAS 原子指令`即可。

偏向锁只有遇到其他线程尝试竞争偏向锁时，持有偏向锁的线程才会释放锁，`线程是不会主动释放偏向锁的。`

关于偏向锁的撤销，需要等待全局安全点，即在某个时间点上没有字节码正在执行时，它会先暂停拥有偏向锁的线程，然后判断锁对象是否处于被锁定状态。如果`线程不处于活动状态`，则将对象头设置成无锁状态，并撤销偏向锁，恢复到无锁（标志位为01）或轻量级锁（标志位为00）的状态。

**偏向锁关闭，或者多个线程竞争偏向锁怎么办呢？**

### 轻量级锁

还是跟Mark Work 相关，如果这个对象是无锁的，jvm就会在当前线程的栈帧中建立一个叫`锁记录（Lock Record）`的空间，用来存储锁对象的Mark Word 拷贝，然后把Lock Record中的owner指向当前对象。

JVM接下来会利用CAS尝试把对象原本的Mark Word 更新会Lock Record的指针，成功就说明加锁成功，改变锁标志位，执行相关同步操作。

如果失败了，就会判断当前对象的Mark Word是否指向了当前线程的栈帧，是则表示当前的线程已经持有了这个对象的锁，否则说明被其他线程持有了，继续锁升级，修改锁的状态，之后等待的线程也阻塞。

轻量级锁是指当锁是偏向锁的时候，却被另外的线程所访问，此时偏向锁就会升级为轻量级锁，其他线程会通过自旋的形式尝试获取锁，线程不会阻塞，从而提高性能。

轻量级锁的获取主要由两种情况：
① 当关闭偏向锁功能时；
② 由于多个线程竞争偏向锁导致偏向锁升级为轻量级锁。

一旦有第二个线程加入锁竞争，偏向锁就升级为轻量级锁（自旋锁）。这里要明确一下什么是锁竞争：

> 如果多个线程轮流获取一个锁，但是每次获取锁的时候都很顺利，没有发生阻塞，那么就不存在锁竞争。只有当某线程尝试获取锁的时候，发现该锁已经被占用，只能等待其释放，这才发生了锁竞争。



<img src='https://img-blog.csdnimg.cn/20200606123648335.png' width=600 height=650>

在轻量级锁状态下继续锁竞争，没有抢到锁的线程将自旋，即不停地循环判断锁是否能够被成功获取。获取锁的操作，其实就是通过CAS修改对象头里的锁标志位。先比较当前锁标志位是否为“释放”，如果是则将其设置为“锁定”，比较并设置是原子性发生的。这就算抢到锁了，然后线程将当前锁的持有者信息修改为自己。

长时间的自旋操作是非常消耗资源的，一个线程持有锁，其他线程就只能在原地空耗CPU，执行不了任何有效的任务，这种现象叫做忙等（busy-waiting）。如果多个线程用一个锁，但是没有发生锁竞争，或者发生了很轻微的锁竞争，那么synchronized就用轻量级锁，允许短时间的忙等现象。这是一种折衷的想法，短时间的忙等，换取线程在用户态和内核态之间切换的开销。

### 自旋锁

我不是在上面提到了Linux系统的用户态和内核态的切换很耗资源，其实就是线程的等待唤起过程，那怎么才能减少这种消耗呢？

自旋，过来的现在就不断自旋，防止线程被挂起，一旦可以获取资源，就直接尝试成功，直到超出阈值，自旋锁的默认大小是10次，-XX：PreBlockSpin可以修改。

自旋都失败了，那就升级为重量级的锁，像1.5的一样，等待唤起咯。

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210729151704773.png" alt="image-20210729151704773" style="zoom:33%;" />

### 自适应自旋锁

自适应意味着自旋的时间不再固定了，而是由前一次在同一个锁上的自旋时间及锁的拥有者的状态来决定：

- 如果在同一个锁对象上，自旋等待之前成功获得过的锁，并且持有锁的线程正在运行中，那么虚拟机就会认为这次自旋也很有可能再次成功，因此允许自旋等待持续相对更长的时间。
- 相反的，如果对于某个锁，自旋很少成功获得过，那么以后要获取这个锁时将可能减少自旋时间甚至省略自旋过程，以避免浪费处理器资源。

**自适应自旋解决的是“锁竞争时间不确定”的问题**。JVM很难感知确切的锁竞争时间，而交给用户分析就违反了JVM的设计初衷。自适应自旋假定不同线程持有同一个锁对象的时间基本相当，竞争程度趋于稳定。因此，可以根据上一次自旋的时间与结果调整下一次自旋的时间。

### 重量级锁

如果锁竞争情况严重，某个达到最大自旋次数的线程，会将轻量级锁升级为重量级锁（依然是CAS修改锁标志位，但不修改持有锁的线程ID）。当后续线程尝试获取锁时，发现被占用的锁是重量级锁，则直接将自己挂起（而不是忙等），等待将来被唤醒。

重量级锁是指当有一个线程获取锁之后，其余所有等待获取该锁的线程都会处于阻塞状态。

简言之，就是所有的控制权都交给了操作系统，由操作系统来负责线程间的调度和线程的状态变更。而这样会出现频繁地对线程运行状态的切换，线程的挂起和唤醒，从而消耗大量的系统资

大家在看ObjectMonitor源码的时候，会发现Atomic::cmpxchg_ptr，Atomic::inc_ptr等内核函数，对应的线程就是park()和upark()。
这个操作涉及用户态和内核态的转换了，这种切换是很耗资源的，所以知道为啥有自旋锁这样的操作了吧，按道理类似死循环的操作更费资源才是对吧？其实不是，大家了解一下就知道了。

> 那用户态和内核态又是啥呢？

<img src='https://oscimg.oschina.net/oscnet/up-3d168748d90e18da228ce8f55a9cc4a6cc4.png' width=300 height=300>

Linux系统的体系结构分为用户空间（应用程序的活动空间）和内核。我们所有的程序都在用户空间运行，进入用户运行状态也就是（用户态），但是很多操作可能涉及内核运行，比如涉及到I/O，我们就会进入内核运行状态（内核态）。

这个过程是很复杂的，也涉及很多值的传递，我简单概括下流程：
- 用户态把一些数据放到寄存器，或者创建对应的堆栈，表明需要操作系统提供的服务。
- 用户态执行系统调用（系统调用是操作系统的最小功能单位）。
- CPU切换到内核态，跳到对应的内存指定的位置执行指令。
- 系统调用处理器去读取我们先前放到内存的数据参数，执行程序的请求。
- 调用完成，操作系统重置CPU为用户态返回结果，并执行下个指令。

所以大家一直说，1.6之前是重量级锁，没错，但是他重量的本质，是ObjectMonitor调用的过程，以及Linux内核的复杂运行机制决定的，大量的系统资源消耗，所以效率才低。
还有两种情况也会发生内核态和用户态的切换：异常事件和外围设备的中断 大家也可以了解下。

> 普通的IO读写也会涉及到用户态和内核的切换，但是为了提升IO 的性能，操作系统可以通过 `零拷贝` 来实现，Redis和Kafka,还有netty的底层IO模型都存在零拷贝。

### 锁对比

![image-20210729150936860](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210729150936860.png)

## synchronized和Lock对比

我们先看看他们的区别：

- synchronized是关键字，是JVM层面的底层啥都帮我们做了，而Lock是一个接口，是JDK层面的有丰富的API。
- synchronized会自动释放锁，而Lock必须手动释放锁。
- synchronized是不可中断的，Lock可以中断也可以不中断。
- 通过Lock可以知道线程有没有拿到锁，而synchronized不能。
- synchronized能锁住方法和代码块，而Lock只能锁住代码块。
- Lock可以使用读锁提高多线程读效率。
- synchronized是非公平锁，ReentrantLock可以控制是否是公平锁。

两者一个是JDK层面的一个是JVM层面的，我觉得最大的区别其实在，我们是否需要丰富的api，还有一个我们的场景。

> **比如我现在是滴滴，我早上有打车高峰，我代码使用了大量的synchronized，有什么问题？锁升级过程是不可逆的，过了高峰我们还是重量级的锁，那效率是不是大打折扣了？这个时候你用Lock是不是很好？**



## synchronized使用注意事项

synchronized是通过软件(JVM)实现的，简单易用，即使在JDK5之后有了Lock，仍然被广泛地使用。

>  **使用Synchronized有哪些要注意的？**

- 锁对象不能为空，因为锁的信息都保存在对象头里
- 作用域不宜过大，影响程序执行的速度，控制范围过大，编写代码也容易出错
- 避免死锁
- 在能选择的情况下，既不要用Lock也不要用synchronized关键字，用java.util.concurrent包中的各种各样的类，如果不用该包下的类，在满足业务的情况下，可以使用synchronized关键，因为代码量少，避免出错

> **synchronized是公平锁吗？**

synchronized实际上是非公平的，新来的线程有可能立即获得监视器，而在等待区中等候已久的线程可能再次等待，不过这种抢占的方式可以预防饥饿。

## 参考文档

[Linux探秘之用户态与内核态](https://www.cnblogs.com/bakari/p/5520860.html)

[傻瓜三歪让我教他「零拷贝」](https://mp.weixin.qq.com/s/FgBCop2zFfcX5ZszE0NoCQ)

[偏向锁、轻量级锁、重量级锁、自旋锁、自适应自旋锁](https://www.jianshu.com/p/8c255b942535)

[关于 锁的四种状态与锁升级过程 图文详解](https://www.cnblogs.com/mingyueyy/p/13054296.html)

[死磕Synchronized底层实现](https://mp.weixin.qq.com/s/2ka1cDTRyjsAGk_-ii4ngw)



