---
title: 一文搞懂高并发性能指标：QPS、TPS、RT、吞吐量
toc: true
date: 2021-08-26 19:41:56
tags: 
- 高并发
- 性能指标
categories:
---

## QPS

Queries Per Second意思是“每秒查询率”，是一台服务器每秒能够相应的查询次数，是对一个特定的查询服务器在规定时间内所处理流量多少的衡量标准。

互联网中，作为域名系统服务器的机器的性能经常用每秒查询率来衡量。

原理：每天80%的访问集中在20%的时间里，这20%时间叫做峰值时间。

公式：( 总PV数 * 80% ) / ( 每天秒数 * 20% ) = 峰值时间每秒请求数(QPS) 。

PV（page view）即页面浏览量，通常是衡量一个网络新闻频道或网站甚至一条网络新闻的主要指标。网页浏览数是评价网站流量最常用的指标之一，简称为PV。

机器：峰值时间每秒QPS / 单台机器的QPS = 需要的机器 。

每天300w PV 的在单台机器上，这台机器需要多少QPS？

`( 3000000 * 0.8 ) / (86400 * 0.2 ) = 139 (QPS)。`

一般需要达到139QPS，因为是峰值。(200万pv才有100峰值qps)

## TPS

TPS：Transactions Per Second（每秒传输的事务处理个数），即服务器每秒处理的事务数。

TPS包括一条消息入和一条消息出，加上一次用户数据库访问。（业务TPS = CAPS × 每个呼叫平均TPS）

一个事务是指一个客户机向服务器发送请求然后服务器做出反应的过程。客户机在发送请求时开始计时，收到服务器响应后结束计时，以此来计算使用的时间和完成的事务个数。

一般的，评价系统性能均以每秒钟完成的技术交易的数量来衡量。系统整体处理能力取决于处理能力最低模块的TPS值。

## RT（响应时长）

响应时间：执行一个请求从开始到最后收到响应数据所花费的总体时间,即从客户端发起请求到收到服务器响应结果的时间。

响应时间RT(Response-time)，是一个系统最重要的指标之一，它的数值大小直接反应了系统的快慢。

直观上看，这个指标与人对软件性能的主观感受是非常一致的，因为它完整地记录了整个计算机系统处理请求的时间。

由于一个系统通常会提供许多功能，而不同功能的处理逻辑也千差万别，因而不同功能的响应时间也不尽相同，甚至同一功能在不同输入数据的情况下响应时间也不相同。

所以，在讨论一个系统的响应时间时，人们通常是指该系统所有功能的平均时间或者所有功能的最大响应时间。当然，往往也需要对每个或每组功能讨论其平均响应时间和最大响应时间。

对于单机的没有并发操作的应用系统而言，人们普遍认为响应时间是一个合理且准确的性能指标。需要指出的是，响应时间的绝对值并不能直接反映软件的性能的高低，软件性能的高低实际上取决于用户对该响应时间的接受程度。

对于一个游戏软件来说，响应时间小于100毫秒应该是不错的，响应时间在1秒左右可能属于勉强可以接受，如果响应时间达到3秒就完全难以接受了。而对于编译系统来说，完整编译一个较大规模软件的源代码可能需要几十分钟甚至更长时间，但这些响应时间对于用户来说都是可以接受的



## Load（系统负载）

Linux的Load(系统负载)，是一个让新手不太容易了解的概念。load的就是一定时间内计算机有多少个active_tasks，也就是说是计算机的任务执行队列的长度，cpu计算的队列。

top/uptime等工具默认会显示1分钟、5分钟、15分钟的平均Load。

具体来说，平均Load是指，在特定的一段时间内统计的正在CPU中运行的(R状态)、正在等待CPU运行的、处于不可中断睡眠的(D状态)的任务数量的平均值。

最后，说一下CPU使用率和Load的关系吧。如果主要是CPU密集型的程序在运行(If CPU utilization is near 100 percent (user + nice + system), the workload sampled is CPU-bound.)，

那么CPU利用率高，Load一般也会比较高。而I/O密集型的程序在运行，

可能看到CPU的%user, %system都不高，%iowait可能会有点高，这时的Load通常比较高。

同理，程序读写慢速I/O设备(如磁盘、NFS)比较多时，Load可能会比较高，而CPU利用率不一定高。这种情况，还经常发生在系统内存不足并开始使用swap的时候，Load一般会比较高，而CPU使用率并不高。

## PV

页面访问次数：Page View

### UV

访客数（去重复）：Unique Visitor

## 并发数

并发数是指系统同时能处理的请求数量，这个也是反应了系统的负载能力。

## 吞吐量

系统的吞吐量（承压能力）与request对CPU的消耗、外部接口、IO等等紧密关联。单个request 对CPU消耗越高，外部系统接口、IO速度越慢，系统吞吐能力越低，反之越高。

系统吞吐量几个重要参数：QPS（TPS）、并发数、响应时间。

1. QPS（TPS）：（Query Per Second）每秒钟request/事务 数量
2. 并发数： 系统同时处理的request/事务数
3. 响应时间： 一般取平均响应时间

理解了上面三个要素的意义之后，就能推算出它们之间的关系：

- **QPS（TPS）= 并发数/平均响应时间**
- **并发数 = QPS\*平均响应时间**

## 最佳线程数、QPS、RT

**1、单线程QPS公式：QPS=1000ms/RT**
对同一个系统而言，支持的线程数越多，QPS越高。假设一个RT是80ms,则可以很容易的计算出QPS,QPS = 1000/80 = 12.5
多线程场景，如果把服务端的线程数提升到2，那么整个系统的QPS则为 2*（1000/80） = 25, 可见QPS随着线程的增加而线性增长，那QPS上不去就加线程呗，听起来很有道理，公司也说的通，但是往往现实并非如此。

**2、最佳线程数量**
刚好消耗完服务器的瓶颈资源的临界线程数，公式如下
最佳线程数量=（（线程等待时间+线程cpu时间）/ 线程cpu时间）* cpu数量
特性：

- 在达到最佳线程数的时候，线程数量继续递增，则QPS不变，而响应时间变长，持续递增线程数量，则QPS开始下降。
- 每个系统都有其最佳线程数量，但是不同状态下，最佳线程数量是会变化的。
- 瓶颈资源可以是CPU,可以是内存，可以是锁资源，IO资源：超过最佳线程数-导致资源的竞争，超过最佳线程数-响应时间递增。
