---
title: Http状态码及含义
toc: true
date: 2021-07-20 11:31:58
tags: http
categories: [Computer Network, HTTP]
---

> http状态码由3个十进制数字组成。第一个数字表示状态码的分类，后面的两位表示该分类下不同的状态。
分为5个大类。



## 分类

- 1**	信息。服务器收到请求，请继续执行请求
- 2**	成功。请求被成功接收并处理
- 3**	重定向。需要进一步操作来完成请求
- 4**	客户端错误。无法完成请求，或请求包含语法错误
- 5**	服务器错误。服务器在处理请求的过程中发成错误


## 各个状态说明

- 100： 继续请求者应当继续提出请求。服务器已收到请求的一部分，正在等待其余部分。
- 101： 切换协议请求者已要求服务器切换协议，服务器已确认并准备切换。
- 200： 成功服务器已成功处理了请求。
- 201： 已创建请求成功并且服务器创建了新的资源。
- 202： 已接受服务器已接受请求，但尚未处理。
- 203： 非授权信息服务器已成功处理了请求，但返回的信息可能来自另一来源。
- 204： 无内容服务器成功处理了请求，但没有返回任何内容。
- 205： 重置内容服务器成功处理了请求，内容被重置。
- 206： 部分内容服务器成功处理了部分请求。
- 300： 多种选择针对请求，服务器可执行多种操作。
- 301： 永久移动请求的网页已永久移动到新位置，即永久重定向。
- 302： 临时移动请求的网页暂时跳转到其他页面，即暂时重定向。
- 303： 查看其他位置如果原来的请求是 POST，重定向目标文档应该通过 GET 提取。
- 304： 未修改此次请求返回的网页未修改，继续使用上次的资源。
- 305： 使用代理请求者应该使用代理访问该网页。
- 307： 临时重定向请求的资源临时从其他位置响应。
- 400： 错误请求服务器无法解析该请求。
- 401： 未授权请求没有进行身份验证或验证未通过。
- 403： 禁止访问服务器拒绝此请求。
- 404： 未找到服务器找不到请求的网页。
- 405： 方法禁用服务器禁用了请求中指定的方法。
- 406： 不接受无法使用请求的内容响应请求的网页。
- 407： 需要代理授权请求者需要使用代理授权。
- 408： 请求超时服务器请求超时。
- 409： 冲突服务器在完成请求时发生冲突。
- 410： 已删除请求的资源已永久删除。
- 411： 需要有效长度服务器不接受不含有效内容长度标头字段的请求。
- 412： 未满足前提条件服务器未满足请求者在请求中设置的其中一个前提条件。
- 413： 请求实体过大请求实体过大，超出服务器的处理能力。
- 414： 请求 URI 过长请求网址过长，服务器无法处理。
- 415： 不支持类型请求的格式不受请求页面的支持。
- 416： 请求范围不符页面无法提供请求的范围。
- 417： 未满足期望值服务器未满足期望请求标头字段的要求。
- 500： 服务器内部错误服务器遇到错误，无法完成请求。
- 501： 未实现服务器不具备完成请求的功能。
- 502： 错误网关服务器作为网关或代理，从上游服务器收到无效响应。
- 503： 服务不可用服务器目前无法使用。
- 504： 网关超时服务器作为网关或代理，但是没有及时从上游服务器收到请求。
- 505： HTTP 版本不支持服务器不支持请求中所用的 HTTP 协议版本。
