---
title: 设计模式之美-建造者模式
toc: true
date: 2021-08-07 19:55:36
tags: 设计模式
categories:
---

# 建造者模式
 建造者模式（Builder Pattern）将一个复杂的对象的构建过程与它的表示，使得同样的构建过程可以创建出不同的表示。
 建造者模式属于创建型模式；

对于用户而言，使用建造者模式只需要指定需要创建的类型就可以获取对象，创建的过程以及细节不需要了解，根据建造者模式的定义，可以简单的理解
为两层含义：
1、构建与表示分离；构建代表对象创建，表示代表对象行为，方法，也就是将对象的创建与行为分离；（对应到Java代码，其实就是使用接口规范行为，
然后由具体的实现进行构建）
2、创建不同的表示；也就是具备同样的行为，但是却由于构建的行为顺序不同或其他原因可以创建出不同的表示；

### Course
```java
@Data
@Getter
@Setter
public class Course {
    private String name;
    private String ppt;
    private String video;
    private String note;
    private String homework;
    
}
```
### CourseBuilder

```java
public class CourseBuilder {

    private Course course = new Course();

    public CourseBuilder addName(String name){
        course.setName(name);
        return this;
    }
    public CourseBuilder addHomework(String homework){
        course.setHomework(homework);
        return this;
    }
    public CourseBuilder addVideo(String video){
        course.setVideo(video);
        return this;
    }
    public CourseBuilder addPpt(String ppt){
        course.setPpt(ppt);
        return this;
    }
    public CourseBuilder addNote(String note){
        course.setNote(note);
        return this;
    }

    public Course builder(){
        return course;
    }
    
}
```

### DomoTest 测试
```java
public class DomoTest {
    public static void main(String[] args) {
        CourseBuilder courseBuilder = new CourseBuilder();
        courseBuilder.addHomework("课后作业111")
        .addName("设计模式")
        .addNote("课堂笔记");
        System.out.println("courseBuilder = " + courseBuilder.builder());
    }
}
```
输出结果：
```text
courseBuilder = Course(name=设计模式, ppt=null, video=null, note=课堂笔记, homework=课后作业111)
```


## 建造者在JDK中的应用
### StringBuilder
<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/up-2381a159db921a2ce7d6b78fac5d7260ffd.png" style="zoom:50%;" />

```java
public final class StringBuilder
    extends AbstractStringBuilder
    implements java.io.Serializable, CharSequence{}
```
### java.lang.StringBuilder.append(java.lang.CharSequence)
```java
    @Override
    public StringBuilder append(CharSequence s) {
        super.append(s);
        return this;
    }
```
这里的StringBuilder就是一个实现构造器，只不过它的上级还有一个抽象的构造器AbstractStringBuilder;  
看到这源码是不是和我们上面举的例子类似呢，这就是JDK源码中很典型的建造者模式的应用；  
处理上面的StringBuilder之外，还有像Mybatis框架中的CacheBuilder缓存构造器，还有像SqlSessionFactory装载时的openSession方法都是建造者模式；

## 建造者模式的使用场景
- **适用于创建对象需要很多步骤，但是步骤的顺序不一定是固定的**
- **如果一个对象有非常复杂的内部结构（有很多的成员变量或属性）**
- **把复杂对象的创建和使用分离**

## 建造者模式的优点

- **封装行很好，使得创建过程和使用分离开**
- **扩展性好，建造类之间独立，一定程度上解耦**
- **便于控制细节，建造者可以对创建过程逐步细化，而不对其他模块产生任何影响** 

## 建造者模式的缺点
- **产生了对于的Builder对象，造成了类的冗余**
- **如果产品内部发生变化，建造者都要修改，维护成本比较大；不适合经常变动的对象，这样也是不符合开闭原则的**


## 建造者模式和工厂模式的对比
- **建造者模式更加注重方法的调用顺序，工厂模式注重于对象的创建**
- **创建对象的力度不同，建造者模式创建复杂的对象，由各种复杂的组件组成，工厂模式创建出来对象的都一样**
- **关注点不同，工厂模式只需要吧对象创建出来就可以了，而建造者模式中不仅要创建出这个对象，还要知道这个对象由那些组件组成**
- **建造者模式根据建造过程中的顺序不一样，最终的对象不见组成也不一样，对象的每个部件的设置都是很灵活的**



