---
title: 设计模式之美-桥接模式
toc: true
date: 2021-08-07 19:59:32
tags: 设计模式
categories:
---

# 桥接模式（Bridge Pattern）

桥接模式也称为桥梁模式，接口（Integer）模式或者柄体（Handle and Body）模式，是将抽象部分和它的具体实现部分分离，是它们都可以独立地变化；

通过组合的方式建立两个类之间的联系，而不是继承； 桥接模式属于结构型模式；  

继承一般来作为多继承的备用方案；  

## 桥接模式的结构
<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/up-0d535d57f31a3116d90f4022b039595b8cd.png" style="zoom:50%;" />  

**桥接模式主要包括一下几个角色：**  

1、**抽象角色（Abstraction）：** 定义抽象类，并包含一个对实现化对象的引用，正是这个引用，起着桥梁性的作用； 
2、**扩展抽象化（Refined Abstraction）角色**：

### Abstraction

```java
public abstract class Abstraction {

    protected IImplementor iImplementor;

    public Abstraction(IImplementor iImplementor) {
        this.iImplementor = iImplementor;
    }

    public void operation(){
        this.iImplementor.operation();
    }
}
```

### IImplementor

```java
public interface IImplementor {
    void operation();
}
```

### ConcreteImplementA

```java

public class ConcreteImplementA implements IImplementor{
    @Override
    public void operation() {

    }
}
```

### ConcreteImplementB

```java
public class ConcreteImplementB implements IImplementor{
    @Override
    public void operation() {

    }
}

```

### RefinedAbstraction

```java
public class RefinedAbstraction extends Abstraction{

    public RefinedAbstraction(IImplementor iImplementor) {
        super(iImplementor);
    }

    @Override
    public void operation() {
        super.operation();
    }
}
```


## 举个例子

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/up-e5443bab7294cf3d4213da30e87e593a889.png" style="zoom:50%;" />  

### AbstractMessage

```java

public abstract class AbstractMessage {
 private IMessage message;

    public AbstractMessage(IMessage message) {
        this.message = message;
    }

    void sendMsg(String msg,String toUser){
        this.message.send(msg,toUser);
    }
}
```
### IMessage

```java
public interface IMessage {
    void send(String msg,String toUser);
}
```
### SmsMessage

```java
public class SmsMessage implements IMessage{
    @Override
    public void send(String msg, String toUser) {
        System.err.println("使用短信消息发送 " + msg + " 发送给 " + toUser);
    }
}
```
### EmailMessage

```java
public class EmailMessage implements IMessage{
    @Override
    public void send(String msg, String toUser) {
        System.err.println("使用邮件消息发送 " + msg + " 发送给 " + toUser);
    }
}
```
### NormalMessage

```java
public class NormalMessage extends AbstractMessage{

    public NormalMessage(IMessage message) {
        super(message);
    }

    @Override
    void sendMsg(String msg, String toUser) {
        super.sendMsg(msg, toUser);
    }
}
```
### UegencyMessage

```java
public class UegencyMessage extends AbstractMessage{
    void sendMsg(String msg,String toUser){
        msg = "[ 加急]" + msg;
        super.sendMsg(msg,toUser);
    }

    public UegencyMessage(IMessage message) {
        super(message);
    }
}
```
### DemoTest

```java
public class DemoTest {
    public static void main(String[] args) {
        IMessage message = new SmsMessage();
        AbstractMessage abstractMessage = new NormalMessage(message);
        abstractMessage.sendMsg("加班申请","老大");

        message = new EmailMessage();
        abstractMessage = new UegencyMessage(message);
        abstractMessage.sendMsg("调休申请","老总");

    }
}
```
```text
使用短信消息发送 加班申请 发送给 老大
使用邮件消息发送 [ 加急]调休申请 发送给 老总
```


## 桥接模式的适用场景
1、在抽象和具体实现之间需要增加更多的灵活性的场景；   
2、一个类在两个或者多个独立变化的维度，而这两个或多个维度都需要独立的进行拓展    
3、不希望使用继承，或者因为多层继承导致系统类的个数剧增；  

![](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/up-e40c001a6bb521fdb429fd7436df93981f8.png)  

## 桥接模式的优点
1、遵循软件设计原则，分离抽象部分和具体实现部分  
2、提高了系统的扩展性  
3、符合开闭原则  
4、符合合成复用原则  不使用继承而使用组合  

## 桥接模式
1、增加了系统代码可读性和复杂性  
2、需要正确识别交接的不同维度    

