---
title: 2021年后端大厂-计算机网络
toc: true
date: 2021-01-01 14:17:33
tags: 面试题
categories:
---

# 计算机网络



![image-20210807142215672](https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210807142215672.png)



## 面试合集链接

[优秀简历模板及计算机网络八股文](https://www.nowcoder.com/discuss/682094?source_id=profile_create_nctrack&channel=-1)



## 面试题目

### **为什么需要TCP协议？**

TCP 是**面向连接的、可靠的、基于字节流**的传输层通信协议。

`IP` 层是「不可靠」的，它不保证网络包的交付、不保证网络包的按序交付、也不保证网络包中的数据的完整性。

因为 TCP 是一个工作在**传输层**的**可靠**数据传输的服务，它能确保接收端接收的网络包是**无损坏、无间隔、非冗余和按序的。**

### **URI和URL的区别**

URI(Uniform Resource Identifier)：中文全称为统一资源标志符，主要作用是唯一标识一个资源。

URL(Uniform Resource Location)：中文全称为统一资源定位符，主要作用是提供资源的路径。

### DNS的工作流程

> domain name system   集群式运行（高可用）

**主机向本地域名服务器的查询一般是采用递归查询，而本地域名服务器向根域名的查询一般是采用迭代查询。**

详情参见https://www.nowcoder.com/discuss/682094?source_id=profile_create_nctrack&channel=-1

### 键入网址后，期间发生了什么？

[三歪问我：键入网址后，期间发生了什么？](https://mp.weixin.qq.com/s/I6BLwbIpfGEJnxjDcPXc1A)

### 了解ARP协议吗?

ARP协议属于网络层的协议，主要作用是实现从IP地址转换为MAC地址。在每个主机或者路由器中都建有一个ARP缓存表，表中有IP地址及IP地址对应的MAC地址。

### 有了IP地址，为什么还要用MAC地址？

简单来说，标识网络中的一台计算机，比较常用的就是IP地址和MAC地址，但计算机的IP地址可由用户自行更改，管理起来相对困难，而MAC地址不可更改，所以一般会把IP地址和MAC地址组合起来使用。

### 说一下ping的过程

ping是ICMP(网际控制报文协议)中的一个重要应用，ICMP是网络层的协议。ping的作用是测试两个主机的连通性。

ping的工作过程：

1. 向目的主机发送多个ICMP回送请求报文
2. 根据目的主机返回的回送报文的时间和成功响应的次数估算出数据包往返时间及丢包率。

### 路由器和交换机的区别？

| 交换机 | 数据链库层 | 识别MAC地址并根据MAC地址转发数据帧                           |
| ------ | ---------- | ------------------------------------------------------------ |
| 路由器 | 网络层     | 识别IP地址并根据IP地址转发数据包，维护数据表并基于数据表进行最佳路径选择 |

### TCP和UDP协议的区别

TCP建立连接，可靠传输，一对一，流量控制

UDP无需创建连接，尽量交付传输，支持一对多，没有流量控制，首部开销小

#### TCP协议如何保证可靠传输

> 主要有校验和、序列号、超时重传、流量控制及拥塞避免等几种方法。

#### 三次握手和四次挥手

[敖丙用近 40 张图解被问千百遍的 TCP 三次握手和四次挥手面试题](https://mp.weixin.qq.com/s/NL7Jzh0lYoA395yzaGxBHw)

##### 为什么不是握手不是两次

- 三次握手才可以阻止历史重复连接的初始化（主要原因）
- 三次握手才可以同步双方的初始序列号
- 三次握手才可以避免资源浪费（避免建立多余的连接）

##### 为什么是四次握手

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210807155955575.png" alt="image-20210807155955575" style="zoom:25%;" />

1、被断开连接一方的ACK（响应主动断开连接的FIN）报文和自己的FIN报文要分开发送，因为中间报处理可能为处理完的数据，所以不能两个报文同时发送或者不能合并成一个报文发送

##### 为什么需要TIME_WAIT

- 防止具有相同「四元组」的「旧」数据包被收到；

- 保证「被动关闭连接」的一方能被正确的关闭，即保证最后的 ACK 能让被动关闭方接收，从而帮助其正常关闭；

  这个比较好理解，就是为了确保被断开连接的一方能收到断开连接相应自己FIN报文的ACK报文，上图👆中的最后一个ACK报文。

##### 为什么要等待两个MSL

`只有主动断开连接的一方在连接断开后要进行TIME_WAIT` ， 那TIME_WAIT的时间为什么是2个MSL（Maximum Segment Lifetime 报文最大生存时间）。

##### TIME_WAIT 过多有什么危害？

- 第一是内存资源占用；
- 第二是对端口资源的占用，一个 TCP 连接至少消耗一个本地端口；

#### 如何计算TCP数据长度

IP报长度-IP首部长度-TCP首部长度

### Socket编程

https://mp.weixin.qq.com/s/rX3A_FA19n4pI9HicIEsXg

#### 建立一个 socket 连接要经过哪些步骤

<img src="https://xcu-oss.oss-cn-beijing.aliyuncs.com/image/gao/image-20210807173748974.png" alt="image-20210807173748974" style="zoom:33%;" />

- 服务端和客户端初始化 `socket`，得到文件描述符；
- 服务端调用 `bind`，将绑定在 IP 地址和端口;
- 服务端调用 `listen`，进行监听；
- 服务端调用 `accept`，等待客户端连接；
- 客户端调用 `connect`，向服务器端的地址和端口发起连接请求；
- 服务端 `accept` 返回用于传输的 `socket` 的文件描述符；
- 客户端调用 `write` 写入数据；服务端调用 `read` 读取数据；
- 客户端断开连接时，会调用 `close`，那么服务端 `read` 读取数据的时候，就会读取到了 `EOF`，待处理完数据后，服务端调用 `close`，表示连接关闭。

这里需要注意的是，服务端调用 `accept` 时，连接成功了会返回一个已完成连接的 socket，后续用来传输数据。

所以，监听的 socket 和真正用来传送数据的 socket，是「两个」 socket，一个叫作**监听 socket**，一个叫作**已完成连接 socket**。

成功连接建立之后，双方开始通过 read 和 write 函数来读写数据，就像往一个文件流里面写东西一样。

### 301 和 302区别

**301适合永久重定向**

301比较常用的场景是使用域名跳转。

比如，我们访问 **http**://www.baidu.com 会跳转到 **https**://www.baidu.com，发送请求之后，就会返回301状态码，然后返回一个location，提示新的地址，浏览器就会拿着这个新的地址去访问。 

注意： 301请求是可以缓存的， 即通过看status code，可以发现后面写着from cache。 或者你把你的网页的名称从php修改为了html，这个过程中，也会发生永久重定向。 

**302用来做临时跳转**

比如未登陆的用户访问用户中心重定向到登录页面。访问404页面会重新定向到首页。 

### [服务器500，501，502，503，504，505](https://segmentfault.com/a/1190000010269520)





