<p data-nodeid="657" class="">线程（Thread）是并发编程的基础，也是程序执行的最小单元，它依托进程而存在。一个进程中可以包含多个线程，多线程可以共享一块内存空间和一组系统资源，因此线程之间的切换更加节省资源、更加轻量化，也因此被称为轻量级的进程。</p>
<p data-nodeid="658">当然，线程也是面试中常被问到的一个知识点，是程序员必备的基础技能，使用它可以有效地提高程序的整体运行速度。</p>
<p data-nodeid="659">本课时的面试问题是，线程的状态有哪些？它是如何工作的？</p>
<h3 data-nodeid="660">典型回答</h3>
<p data-nodeid="661">线程的状态在 JDK 1.5 之后以枚举的方式被定义在 Thread 的源码中，它总共包含以下 6 个状态：</p>
<ul data-nodeid="662">
<li data-nodeid="663">
<p data-nodeid="664"><strong data-nodeid="742">NEW</strong>，新建状态，线程被创建出来，但尚未启动时的线程状态；</p>
</li>
<li data-nodeid="665">
<p data-nodeid="666"><strong data-nodeid="747">RUNNABLE</strong>，就绪状态，表示可以运行的线程状态，它可能正在运行，或者是在排队等待操作系统给它分配 CPU 资源；</p>
</li>
<li data-nodeid="667">
<p data-nodeid="668"><strong data-nodeid="752">BLOCKED</strong>，阻塞等待锁的线程状态，表示处于阻塞状态的线程正在等待监视器锁，比如等待执行 synchronized 代码块或者使用 synchronized 标记的方法；</p>
</li>
<li data-nodeid="669">
<p data-nodeid="670"><strong data-nodeid="757">WAITING</strong>，等待状态，一个处于等待状态的线程正在等待另一个线程执行某个特定的动作，比如，一个线程调用了 Object.wait() 方法，那它就在等待另一个线程调用 Object.notify() 或 Object.notifyAll() 方法；</p>
</li>
<li data-nodeid="671">
<p data-nodeid="672"><strong data-nodeid="764">TIMED_WAITING</strong>，计时等待状态，和等待状态（WAITING）类似，它只是多了超时时间，比如调用了有超时时间设置的方法 Object.wait(long timeout) 和 Thread.join(long timeout) 等这些方法时，它才会进入此状态；</p>
</li>
<li data-nodeid="673">
<p data-nodeid="674"><strong data-nodeid="769">TERMINATED</strong>，终止状态，表示线程已经执行完成。</p>
</li>
</ul>
<p data-nodeid="675">线程状态的源代码如下：</p>
<pre class="lang-java" data-nodeid="676"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">enum</span>&nbsp;State&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;新建状态，线程被创建出来，但尚未启动时的线程状态
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;NEW,

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;就绪状态，表示可以运行的线程状态，但它在排队等待来自操作系统的&nbsp;CPU&nbsp;资源
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;RUNNABLE,

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;阻塞等待锁的线程状态，表示正在处于阻塞状态的线程
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;正在等待监视器锁，比如等待执行&nbsp;synchronized&nbsp;代码块或者
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;使用&nbsp;synchronized&nbsp;标记的方法
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;BLOCKED,

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;等待状态，一个处于等待状态的线程正在等待另一个线程执行某个特定的动作。
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;例如，一个线程调用了&nbsp;Object.wait()&nbsp;它在等待另一个线程调用
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;Object.notify()&nbsp;或&nbsp;Object.notifyAll()
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;WAITING,

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;计时等待状态，和等待状态&nbsp;(WAITING)&nbsp;类似，只是多了超时时间，比如
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;调用了有超时时间设置的方法&nbsp;Object.wait(long&nbsp;timeout)&nbsp;和&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;Thread.join(long&nbsp;timeout)&nbsp;就会进入此状态
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;TIMED_WAITING,

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;终止状态，表示线程已经执行完成
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
}
</code></pre>
<p data-nodeid="677">线程的工作模式是，首先先要创建线程并指定线程需要执行的业务方法，然后再调用线程的 start() 方法，此时线程就从 NEW（新建）状态变成了 RUNNABLE（就绪）状态，此时线程会判断要执行的方法中有没有 synchronized 同步代码块，如果有并且其他线程也在使用此锁，那么线程就会变为 BLOCKED（阻塞等待）状态，当其他线程使用完此锁之后，线程会继续执行剩余的方法。</p>
<p data-nodeid="678">当遇到 Object.wait() 或 Thread.join() 方法时，线程会变为 WAITING（等待状态）状态，如果是带了超时时间的等待方法，那么线程会进入 TIMED_WAITING（计时等待）状态，当有其他线程执行了 notify() 或 notifyAll() 方法之后，线程被唤醒继续执行剩余的业务方法，直到方法执行完成为止，此时整个线程的流程就执行完了，执行流程如下图所示：</p>
<p data-nodeid="679"><img src="https://s0.lgstatic.com/i/image/M00/91/D1/Ciqc1GAPxD-ASC1FAADCb4kEBek322.png" alt="Lark20210126-152601.png" data-nodeid="777"></p>
<h3 data-nodeid="680">考点分析</h3>
<p data-nodeid="681">线程一般会作为并发编程的起始问题，用于引出更多的关于并发编程的面试问题。当然对于线程的掌握程度也决定了你对并发编程的掌握程度，通常面试官还会问：</p>
<ul data-nodeid="682">
<li data-nodeid="683">
<p data-nodeid="684">BLOCKED（阻塞等待）和 WAITING（等待）有什么区别？</p>
</li>
<li data-nodeid="685">
<p data-nodeid="686">start() 方法和 run() 方法有什么区别？</p>
</li>
<li data-nodeid="687">
<p data-nodeid="688">线程的优先级有什么用？该如何设置？</p>
</li>
<li data-nodeid="689">
<p data-nodeid="690">线程的常用方法有哪些？</p>
</li>
</ul>
<p data-nodeid="691">接下来我们一起来看这些问题的答案。</p>
<h3 data-nodeid="692">知识扩展</h3>
<h4 data-nodeid="693">1.BLOCKED 和 WAITING 的区别</h4>
<p data-nodeid="694">虽然 BLOCKED 和 WAITING 都有等待的含义，但二者有着本质的区别，首先它们状态形成的调用方法不同，其次 BLOCKED 可以理解为当前线程还处于活跃状态，只是在阻塞等待其他线程使用完某个锁资源；而 WAITING 则是因为自身调用了 Object.wait() 或着是 Thread.join() 又或者是 LockSupport.park() 而进入等待状态，只能等待其他线程执行某个特定的动作才能被继续唤醒，比如当线程因为调用了 Object.wait() 而进入 WAITING 状态之后，则需要等待另一个线程执行 Object.notify() 或 Object.notifyAll() 才能被唤醒。</p>
<h4 data-nodeid="695">2.start() 和 run() 的区别</h4>
<p data-nodeid="696">首先从 Thread 源码来看，start() 方法属于 Thread 自身的方法，并且使用了 synchronized 来保证线程安全，源码如下：</p>
<pre class="lang-java" data-nodeid="697"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">start</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;状态验证，不等于&nbsp;NEW&nbsp;的状态会抛出异常</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(threadStatus&nbsp;!=&nbsp;<span class="hljs-number">0</span>)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">throw</span>&nbsp;<span class="hljs-keyword">new</span>&nbsp;IllegalThreadStateException();
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;通知线程组，此线程即将启动</span>

&nbsp;&nbsp;&nbsp;&nbsp;group.add(<span class="hljs-keyword">this</span>);
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">boolean</span>&nbsp;started&nbsp;=&nbsp;<span class="hljs-keyword">false</span>;
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;start0();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;started&nbsp;=&nbsp;<span class="hljs-keyword">true</span>;
&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">finally</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(!started)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;group.threadStartFailed(<span class="hljs-keyword">this</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(Throwable&nbsp;ignore)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;不处理任何异常，如果&nbsp;start0&nbsp;抛出异常，则它将被传递到调用堆栈上</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="698">run() 方法为 Runnable 的抽象方法，必须由调用类重写此方法，重写的 run() 方法其实就是此线程要执行的业务方法，源码如下：</p>
<pre class="lang-java" data-nodeid="699"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">Thread</span>&nbsp;<span class="hljs-keyword">implements</span>&nbsp;<span class="hljs-title">Runnable</span>&nbsp;</span>{
&nbsp;<span class="hljs-comment">//&nbsp;忽略其他方法......</span>
&nbsp;&nbsp;<span class="hljs-keyword">private</span>&nbsp;Runnable&nbsp;target;
&nbsp;&nbsp;<span class="hljs-meta">@Override</span>
&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">run</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(target&nbsp;!=&nbsp;<span class="hljs-keyword">null</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;target.run();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;}
}
<span class="hljs-meta">@FunctionalInterface</span>
<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">interface</span>&nbsp;<span class="hljs-title">Runnable</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">abstract</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">run</span><span class="hljs-params">()</span></span>;
}
</code></pre>
<p data-nodeid="700">从执行的效果来说，start() 方法可以开启多线程，让线程从 NEW 状态转换成 RUNNABLE 状态，而 run() 方法只是一个普通的方法。</p>
<p data-nodeid="701">其次，它们可调用的次数不同，start() 方法不能被多次调用，否则会抛出 java.lang.IllegalStateException；而 run() 方法可以进行多次调用，因为它只是一个普通的方法而已。</p>
<h4 data-nodeid="702">3.线程优先级</h4>
<p data-nodeid="703">在 Thread 源码中和线程优先级相关的属性有 3 个：</p>
<pre class="lang-java" data-nodeid="704"><code data-language="java"><span class="hljs-comment">//&nbsp;线程可以拥有的最小优先级</span>
<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">int</span>&nbsp;MIN_PRIORITY&nbsp;=&nbsp;<span class="hljs-number">1</span>;

<span class="hljs-comment">//&nbsp;线程默认优先级</span>
<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">int</span>&nbsp;NORM_PRIORITY&nbsp;=&nbsp;<span class="hljs-number">5</span>;

<span class="hljs-comment">//&nbsp;线程可以拥有的最大优先级</span>
<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">int</span>&nbsp;MAX_PRIORITY&nbsp;=&nbsp;<span class="hljs-number">10</span>
</code></pre>
<p data-nodeid="705">线程的优先级可以理解为线程抢占 CPU 时间片的概率，优先级越高的线程优先执行的概率就越大，但并不能保证优先级高的线程一定先执行。</p>
<p data-nodeid="706">在程序中我们可以通过 Thread.setPriority() 来设置优先级，setPriority() 源码如下：</p>
<pre class="lang-java" data-nodeid="707"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">setPriority</span><span class="hljs-params">(<span class="hljs-keyword">int</span>&nbsp;newPriority)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;ThreadGroup&nbsp;g;
&nbsp;&nbsp;&nbsp;&nbsp;checkAccess();
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;先验证优先级的合理性</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(newPriority&nbsp;&gt;&nbsp;MAX_PRIORITY&nbsp;||&nbsp;newPriority&nbsp;&lt;&nbsp;MIN_PRIORITY)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">throw</span>&nbsp;<span class="hljs-keyword">new</span>&nbsp;IllegalArgumentException();
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>((g&nbsp;=&nbsp;getThreadGroup())&nbsp;!=&nbsp;<span class="hljs-keyword">null</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;优先级如果超过线程组的最高优先级，则把优先级设置为线程组的最高优先级</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(newPriority&nbsp;&gt;&nbsp;g.getMaxPriority())&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;newPriority&nbsp;=&nbsp;g.getMaxPriority();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;setPriority0(priority&nbsp;=&nbsp;newPriority);
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<h4 data-nodeid="708">4.线程的常用方法</h4>
<p data-nodeid="709">线程的常用方法有以下几个。</p>
<p data-nodeid="710"><strong data-nodeid="802">（1）join()</strong></p>
<p data-nodeid="711">在一个线程中调用 other.join() ，这时候当前线程会让出执行权给 other 线程，直到 other 线程执行完或者过了超时时间之后再继续执行当前线程，join() 源码如下：</p>
<pre class="lang-java" data-nodeid="712"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">final</span>&nbsp;<span class="hljs-keyword">synchronized</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">join</span><span class="hljs-params">(<span class="hljs-keyword">long</span>&nbsp;millis)</span>
<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">long</span>&nbsp;base&nbsp;=&nbsp;System.currentTimeMillis();
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">long</span>&nbsp;now&nbsp;=&nbsp;<span class="hljs-number">0</span>;
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;超时时间不能小于&nbsp;0</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(millis&nbsp;&lt;&nbsp;<span class="hljs-number">0</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">throw</span>&nbsp;<span class="hljs-keyword">new</span>&nbsp;IllegalArgumentException(<span class="hljs-string">"timeout&nbsp;value&nbsp;is&nbsp;negative"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;等于&nbsp;0&nbsp;表示无限等待，直到线程执行完为之</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(millis&nbsp;==&nbsp;<span class="hljs-number">0</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;判断子线程&nbsp;(其他线程)&nbsp;为活跃线程，则一直等待</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">while</span>&nbsp;(isAlive())&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;wait(<span class="hljs-number">0</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">else</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;循环判断</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">while</span>&nbsp;(isAlive())&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">long</span>&nbsp;delay&nbsp;=&nbsp;millis&nbsp;-&nbsp;now;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(delay&nbsp;&lt;=&nbsp;<span class="hljs-number">0</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">break</span>;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;wait(delay);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;now&nbsp;=&nbsp;System.currentTimeMillis()&nbsp;-&nbsp;base;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="713">从源码中可以看出 join() 方法底层还是通过 wait() 方法来实现的。</p>
<p data-nodeid="714">例如，在未使用 join() 时，代码如下：</p>
<pre class="lang-java" data-nodeid="715"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">ThreadExample</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread&nbsp;thread&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(()&nbsp;-&gt;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">for</span>&nbsp;(<span class="hljs-keyword">int</span>&nbsp;i&nbsp;=&nbsp;<span class="hljs-number">1</span>;&nbsp;i&nbsp;&lt;&nbsp;<span class="hljs-number">6</span>;&nbsp;i++)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.sleep(<span class="hljs-number">1000</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"子线程睡眠："</span>&nbsp;+&nbsp;i&nbsp;+&nbsp;<span class="hljs-string">"秒。"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;});
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;thread.start();&nbsp;<span class="hljs-comment">//&nbsp;开启线程</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;主线程执行</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">for</span>&nbsp;(<span class="hljs-keyword">int</span>&nbsp;i&nbsp;=&nbsp;<span class="hljs-number">1</span>;&nbsp;i&nbsp;&lt;&nbsp;<span class="hljs-number">4</span>;&nbsp;i++)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.sleep(<span class="hljs-number">1000</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"主线程睡眠："</span>&nbsp;+&nbsp;i&nbsp;+&nbsp;<span class="hljs-string">"秒。"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="716">程序执行结果为：</p>
<pre class="lang-java" data-nodeid="717"><code data-language="java">主线程睡眠：<span class="hljs-number">1</span>秒。
子线程睡眠：<span class="hljs-number">1</span>秒。
主线程睡眠：<span class="hljs-number">2</span>秒。
子线程睡眠：<span class="hljs-number">2</span>秒。
主线程睡眠：<span class="hljs-number">3</span>秒。
子线程睡眠：<span class="hljs-number">3</span>秒。
子线程睡眠：<span class="hljs-number">4</span>秒。
子线程睡眠：<span class="hljs-number">5</span>秒。
</code></pre>
<p data-nodeid="718">从结果可以看出，在未使用 join() 时主子线程会交替执行。</p>
<p data-nodeid="719">然后我们再把 join() 方法加入到代码中，代码如下：</p>
<pre class="lang-java" data-nodeid="720"><code data-language="java"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">ThreadExample</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread&nbsp;thread&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(()&nbsp;-&gt;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">for</span>&nbsp;(<span class="hljs-keyword">int</span>&nbsp;i&nbsp;=&nbsp;<span class="hljs-number">1</span>;&nbsp;i&nbsp;&lt;&nbsp;<span class="hljs-number">6</span>;&nbsp;i++)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.sleep(<span class="hljs-number">1000</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"子线程睡眠："</span>&nbsp;+&nbsp;i&nbsp;+&nbsp;<span class="hljs-string">"秒。"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;});
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;thread.start();&nbsp;<span class="hljs-comment">//&nbsp;开启线程</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;thread.join(<span class="hljs-number">2000</span>);&nbsp;<span class="hljs-comment">//&nbsp;等待子线程先执行&nbsp;2&nbsp;秒钟</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;主线程执行</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">for</span>&nbsp;(<span class="hljs-keyword">int</span>&nbsp;i&nbsp;=&nbsp;<span class="hljs-number">1</span>;&nbsp;i&nbsp;&lt;&nbsp;<span class="hljs-number">4</span>;&nbsp;i++)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">try</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.sleep(<span class="hljs-number">1000</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">catch</span>&nbsp;(InterruptedException&nbsp;e)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;e.printStackTrace();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"主线程睡眠："</span>&nbsp;+&nbsp;i&nbsp;+&nbsp;<span class="hljs-string">"秒。"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="721">程序执行结果为：</p>
<pre class="lang-java" data-nodeid="722"><code data-language="java">子线程睡眠：<span class="hljs-number">1</span>秒。
子线程睡眠：<span class="hljs-number">2</span>秒。
主线程睡眠：<span class="hljs-number">1</span>秒。&nbsp;
<span class="hljs-comment">//&nbsp;thread.join(2000);&nbsp;等待&nbsp;2&nbsp;秒之后，主线程和子线程再交替执行</span>
子线程睡眠：<span class="hljs-number">3</span>秒。
主线程睡眠：<span class="hljs-number">2</span>秒。
子线程睡眠：<span class="hljs-number">4</span>秒。
子线程睡眠：<span class="hljs-number">5</span>秒。
主线程睡眠：<span class="hljs-number">3</span>秒。
</code></pre>
<p data-nodeid="723">从执行结果可以看出，添加 join() 方法之后，主线程会先等子线程执行 2 秒之后才继续执行。</p>
<p data-nodeid="724"><strong data-nodeid="814">（2）yield()</strong></p>
<p data-nodeid="725">看 Thread 的源码可以知道 yield() 为本地方法，也就是说 yield() 是由 C 或 C++ 实现的，源码如下：</p>
<pre class="lang-java" data-nodeid="726"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">native</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">yield</span><span class="hljs-params">()</span></span>;
</code></pre>
<p data-nodeid="727">yield() 方法表示给线程调度器一个当前线程愿意出让 CPU 使用权的暗示，但是线程调度器可能会忽略这个暗示。</p>
<p data-nodeid="728">比如我们执行这段包含了 yield() 方法的代码，如下所示：</p>
<pre class="lang-java" data-nodeid="729"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;Runnable&nbsp;runnable&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Runnable()&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Override</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">run</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">for</span>&nbsp;(<span class="hljs-keyword">int</span>&nbsp;i&nbsp;=&nbsp;<span class="hljs-number">0</span>;&nbsp;i&nbsp;&lt;&nbsp;<span class="hljs-number">10</span>;&nbsp;i++)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"线程："</span>&nbsp;+
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.currentThread().getName()&nbsp;+&nbsp;<span class="hljs-string">"&nbsp;I："</span>&nbsp;+&nbsp;i);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(i&nbsp;==&nbsp;<span class="hljs-number">5</span>)&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Thread.yield();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;};
&nbsp;&nbsp;&nbsp;&nbsp;Thread&nbsp;t1&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(runnable,&nbsp;<span class="hljs-string">"T1"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;Thread&nbsp;t2&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;Thread(runnable,&nbsp;<span class="hljs-string">"T2"</span>);
&nbsp;&nbsp;&nbsp;&nbsp;t1.start();
&nbsp;&nbsp;&nbsp;&nbsp;t2.start();
}
</code></pre>
<p data-nodeid="821" class="te-preview-highlight">当我们把这段代码执行多次之后会发现，每次执行的结果都不相同，这是因为 yield() 执行非常不稳定，线程调度器不一定会采纳 yield() 出让 CPU 使用权的建议，从而导致了这样的结果。</p>

<h3 data-nodeid="731">小结</h3>
<p data-nodeid="732" class="">本课时我们介绍了线程的 6 种状态以及线程的执行流程，还介绍了 BLOCKED（阻塞等待）和 WAITING（等待）的区别，start() 方法和 run() 方法的区别，以及 join() 方法和 yield() 方法的作用，但我们不能死记硬背，要多动手实践才能真正的理解这些知识点。</p>

---

### 精选评论

##### *仁：
> 虽然是一块钱买的，但是大佬还可以更深入点啊😟😟😟

##### *俊：
> <div>sleep()和yield()方法的区别</div><div>sleep()和yield()都是Thread类中的静态方法，都会使得当前处于运行状态的线程放弃CPU，但是两者的区别还是有比较大的：</div><div>1：sleep使当前线程（即调用sleep方法的线程暂停一段时间），给其它的线程运行的机会，而且是不考虑其它线程的优先级的，而且不释放资源锁，也就是说如果有synchronized同步块，其它线程仍然是不能访问共享数据的；yeild只会让位给优先级一样或者比它优先级高的线程，而且不能由用户指定暂停多长时间</div><div>&nbsp;2：当线程执行了sleep方法之后，线程将转入到睡眠状态，直到时间结束，而执行yield方法，直接转入到就绪状态。这些对线程的生命周期会造成影响的。</div><div>&nbsp;3：sleep方法需要抛出或者捕获异常，因为线程在睡眠中可能被打断，而yield方法则没异常。</div><div><br></div>

##### *康：
> 还有wait，sleep等方法

##### *康：
> join里的wait是怎么唤醒的？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 使用 notify 或 notifyAll 都可以。

##### *越：
> yield既然不稳定，那么开发中有什么实际应用？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; yield 的设计个人觉得比较鸡肋，一般工作中几乎找不到合适的应用场景，只要当一个线程不那么重要，又怕它占用了太多的 CPU 资源时，可以适当的调用一下 yield 方法。

##### *炜：
> 内容很不错。

##### Fourous：
> 线程的状态是否为Block跟使用的锁有关，如果锁为Synchronized，那么在进入同步队列时候，线程状态为Block，进入等待队列时候，线程状态为waiting或者waiting_timeout，其余基于AQS锁或者其他方式实现锁，都跟Block无关，基于JDK8使用IDEA的jstack验证<div>参考资料：<a href="https://mp.weixin.qq.com/s?__biz=Mzg2ODA0ODM0Nw==&amp;mid=2247484033&amp;idx=1&amp;sn=120be33ad39d8e52389e0d40ce498aac&amp;scene=21#wechat_redirect" style="font-size: 0.427rem; background-color: rgb(255, 255, 255);">https://mp.weixin.qq.com/s?__biz=Mzg2ODA0ODM0Nw==&amp;mid=2247484033&amp;idx=1&amp;sn=120be33ad39d8e52389e0d40ce498aac&amp;scene=21#wechat_redirect</a></div>

##### **伟：
> 有个问题，既然设置优先级，还有调用yield()方法，线程调度器不一定采纳。那这两个有什么用呢？<br>

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 文中有说哦。

##### **告：
> join里面是调用了wait的，那么是什么时候唤醒的呢？ &nbsp;java的线程跟操作系统的线程区别是什么？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 这要看你具体代码是怎么写的了，参数设置还有实际的业务处理时间了，可以自己动手一下。

