<p data-nodeid="961" class="">第一次听到“消息队列”这个词时，不知你是不是和我反应一样，感觉很高阶很厉害的样子，其实当我们了解了消息队列之后，发现它与普通的技术类似，当我们熟悉之后，也能很快地上手并使用。</p>
<p data-nodeid="962">我们本课时的面试题是，消息队列的使用场景有哪些？如何手动实现一个消息队列和延迟消息队列？</p>
<h3 data-nodeid="963">典型回答</h3>
<p data-nodeid="964">消息队列的使用场景有很多，最常见的使用场景有以下几个。</p>
<p data-nodeid="965"><strong data-nodeid="1069">1.商品秒杀</strong></p>
<p data-nodeid="966">比如，我们在做秒杀活动时，会发生短时间内出现爆发式的用户请求，如果不采取相关的措施，会导致服务器忙不过来，响应超时的问题，轻则会导致服务假死，重则会让服务器直接宕机，给用户带来的体验也非常不好。如果这个时候加上了消息队列，服务器接收到用户的所有请求后，先把这些请求全部写入到消息队列中再排队处理，这样就不会导致同时处理多个请求的情况；如果消息队列长度超过可以承载的最大数量，那么我们可以抛弃当前用户的请求，通知前台用户“页面出错啦，请重新刷新”等提示，这样就会有更好的交互体验。</p>
<p data-nodeid="967"><strong data-nodeid="1074">2.系统解耦</strong></p>
<p data-nodeid="968">使用了消息队列之后，我们可以把系统的业务功能模块化，实现系统的解耦。例如，在没有使用消息队列之前，当前台用户完善了个人信息之后，首先我们需要更新用户的资料，再添加一条用户信息修改日志。但突然有一天产品经理提了一个需求，在前台用户信息更新之后，需要给此用户的增加一定的积分奖励，然后没过几天产品经理又提了一个需求，在前台用户信息更新之后，不但要增加积分奖励，还要增加用户的经验值，但没过几天产品经理的需求又变了，他要求完善资料无需增加用户的积分了，这样反反复复、来来回回的折腾，我想研发的同学一定受不了，但这是互联网公司的常态，那我们有没有一劳永逸的办法呢？</p>
<p data-nodeid="969">没错，这个时候我们想到了使用消息队列来实现系统的解耦，每个功能的实现独立开，只需要一个订阅或者取消订阅的开关就可以了，当需要增加功能时，只需要打开订阅“用户信息完善”的队列就行，如果过两天不用了，再把订阅的开关关掉就行了，这样我们就不用来来回回的改业务代码了，也就轻松的实现了系统模块间的解耦。</p>
<p data-nodeid="970"><strong data-nodeid="1080">3.日志记录</strong></p>
<p data-nodeid="5057" class="te-preview-highlight">我们大部分的日志记录行为其实是和前台用户操作的主业务没有直接关系的，只是我们的运营人和经营人员需要拿到这部分用户操作的日志信息，来进行用户行为分析或行为监控。在我们没有使用消息队列之前，笼统的做法是当有用户请求时，先处理用户的请求再记录日志，这两个操作是放在一起的，而前台用户也需要等待日志添加完成之后才能拿到后台的响应信息，这样其实浪费了前台用户的部分时间。此时我们可以使用消息队列，当响应完用户请求之后，只需要把这个操作信息放入消息队列之后，就可以直接返回结果给前台用户了，无须等待日志处理和日志添加完成，从而缩短了前台用户的等待时间。</p>









<p data-nodeid="972">我们可以通过 JDK 提供的 Queue 来实现自定义消息队列，使用 DelayQueue 实现延迟消息队列。</p>
<h3 data-nodeid="973">考点分析</h3>
<p data-nodeid="974">对于消息队列的考察更侧重于消息队列的核心思想，因为只有理解了什么是消息队列？以及什么情况下要用消息队列？才能解决我们日常工作中遇到的问题，而消息队列的具体实现，只需要掌握一个消息中间件的使用即可，因为消息队列中间件的核心实现思路是一致的，不但如此，消息队列中间件的使用也大致类似，只要掌握了一个就能触类旁通的用好其他消息中间件。</p>
<p data-nodeid="975">和本课时相关的面试题，还有以下这两个：</p>
<ul data-nodeid="976">
<li data-nodeid="977">
<p data-nodeid="978">介绍一个你熟悉的消息中间件？</p>
</li>
<li data-nodeid="979">
<p data-nodeid="980">如何手动实现消息队列？</p>
</li>
</ul>
<h3 data-nodeid="981">知识扩展</h3>
<h4 data-nodeid="982">1.常用消息中间件 RabbitMQ</h4>
<p data-nodeid="983">目前市面上比较常用的 MQ（Message Queue，消息队列）中间件有 RabbitMQ、Kafka、RocketMQ，如果是轻量级的消息队列可以使用 Redis 提供的消息队列，本课时我们先来介绍一下 RabbitMQ，其他消息中间件将会在第 15 课时中单独介绍。</p>
<p data-nodeid="984">RabbitMQ 是一个老牌开源的消息中间件，它实现了标准的 AMQP（Advanced Message Queuing Protocol，高级消息队列协议）消息中间件，使用 Erlang 语言开发，支持集群部署，和多种客户端语言混合调用，它支持的主流开发语言有以下这些：</p>
<ul data-nodeid="985">
<li data-nodeid="986">
<p data-nodeid="987">Java and Spring</p>
</li>
<li data-nodeid="988">
<p data-nodeid="989">.NET</p>
</li>
<li data-nodeid="990">
<p data-nodeid="991">Ruby</p>
</li>
<li data-nodeid="992">
<p data-nodeid="993">Python</p>
</li>
<li data-nodeid="994">
<p data-nodeid="995">PHP</p>
</li>
<li data-nodeid="996">
<p data-nodeid="997">JavaScript and Node</p>
</li>
<li data-nodeid="998">
<p data-nodeid="999">Objective-C and Swift</p>
</li>
<li data-nodeid="1000">
<p data-nodeid="1001">Rust</p>
</li>
<li data-nodeid="1002">
<p data-nodeid="1003">Scala</p>
</li>
<li data-nodeid="1004">
<p data-nodeid="1005">Go</p>
</li>
</ul>
<p data-nodeid="1006">更多支持语言，<a href="https://www.rabbitmq.com/devtools.html" data-nodeid="1105">请点击这里访问官网</a>查看。</p>
<p data-nodeid="1007">RabbitMQ 中有 3 个重要的概念：生产者、消费者和代理。</p>
<ul data-nodeid="1008">
<li data-nodeid="1009">
<p data-nodeid="1010">生产者：消息的创建者，负责创建和推送数据到消息服务器。</p>
</li>
<li data-nodeid="1011">
<p data-nodeid="1012">消费者：消息的接收方，用于处理数据和确认消息。</p>
</li>
<li data-nodeid="1013">
<p data-nodeid="1014">代理：也就是 RabbitMQ 服务本身，它用于扮演“快递”的角色，因为它本身并不生产消息，只是扮演了“快递”的角色，把消息进行暂存和传递。</p>
</li>
</ul>
<p data-nodeid="1015">它们的运行流程，如下图所示：<br>
<img src="https://s0.lgstatic.com/i/image3/M01/0D/84/Ciqah16QOkmAX3_TAABZ5pEPvmQ772.png" alt="" data-nodeid="1114"></p>
<p data-nodeid="1016">RabbitMQ 具备以下几个优点：</p>
<ul data-nodeid="1017">
<li data-nodeid="1018">
<p data-nodeid="1019"><strong data-nodeid="1120">支持持久化</strong>，RabbitMQ 支持磁盘持久化功能，保证了消息不会丢失；</p>
</li>
<li data-nodeid="1020">
<p data-nodeid="1021"><strong data-nodeid="1125">高并发</strong>，RabbitMQ 使用了 Erlang 开发语言，Erlang 是为电话交换机开发的语言，天生自带高并发光环和高可用特性；</p>
</li>
<li data-nodeid="1022">
<p data-nodeid="1023"><strong data-nodeid="1130">支持分布式集群</strong>，正是因为 Erlang 语言实现的，因此 RabbitMQ 集群部署也非常简单，只需要启动每个节点并使用 --link 把节点加入到集群中即可，并且 RabbitMQ 支持自动选主和自动容灾；</p>
</li>
<li data-nodeid="1024">
<p data-nodeid="1025"><strong data-nodeid="1135">支持多种语言</strong>，比如 Java、.NET、PHP、Python、JavaScript、Ruby、Go 等；</p>
</li>
<li data-nodeid="1026">
<p data-nodeid="1027"><strong data-nodeid="1140">支持消息确认</strong>，支持消息消费确认（ack）保证了每条消息可以被正常消费；</p>
</li>
<li data-nodeid="1028">
<p data-nodeid="1029"><strong data-nodeid="1145">它支持很多插件</strong>，比如网页控制台消息管理插件、消息延迟插件等，RabbitMQ 的插件很多并且使用都很方便。</p>
</li>
</ul>
<p data-nodeid="1030">RabbitMQ 的消息类型，分为以下四种：</p>
<ul data-nodeid="1031">
<li data-nodeid="1032">
<p data-nodeid="1033"><strong data-nodeid="1151">direct</strong>（默认类型）模式，此模式为一对一的发送方式，也就是一条消息只会发送给一个消费者；</p>
</li>
<li data-nodeid="1034">
<p data-nodeid="1035"><strong data-nodeid="1156">headers</strong> 模式，允许你匹配消息的 header 而非路由键（RoutingKey），除此之外 headers 和 direct 的使用完全一致，但因为 headers 匹配的性能很差，几乎不会被用到；</p>
</li>
<li data-nodeid="1036">
<p data-nodeid="1037"><strong data-nodeid="1161">fanout</strong> 模式，为多播的方式，会把一个消息分发给所有的订阅者；</p>
</li>
<li data-nodeid="1038">
<p data-nodeid="1039"><strong data-nodeid="1168">topic</strong> 模式，为主题订阅模式，允许使用通配符（#、*）匹配一个或者多个消息，我可以使用“cn.mq.#”匹配到多个前缀是“cn.mq.xxx”的消息，比如可以匹配到“cn.mq.rabbit”、“cn.mq.kafka”等消息。</p>
</li>
</ul>
<h4 data-nodeid="1040">2.自定义消息队列</h4>
<p data-nodeid="1041">我们可使用 Queue 来实现消息队列，Queue 大体可分为以下三类：</p>
<ul data-nodeid="1042">
<li data-nodeid="1043">
<p data-nodeid="1044">**双端队列（Deque）**是 Queue 的子类也是 Queue 的补充类，头部和尾部都支持元素插入和获取；</p>
</li>
<li data-nodeid="1045">
<p data-nodeid="1046"><strong data-nodeid="1181">阻塞队列</strong>指的是在元素操作时（添加或删除），如果没有成功，会阻塞等待执行，比如当添加元素时，如果队列元素已满，队列则会阻塞等待直到有空位时再插入；</p>
</li>
<li data-nodeid="1047">
<p data-nodeid="1048"><strong data-nodeid="1186">非阻塞队列</strong>，和阻塞队列相反，它会直接返回操作的结果，而非阻塞等待操作，双端队列也属于非阻塞队列。</p>
</li>
</ul>
<p data-nodeid="1049">自定义消息队列的实现代码如下：</p>
<pre class="lang-java" data-nodeid="1050"><code data-language="java"><span class="hljs-keyword">import</span>&nbsp;java.util.LinkedList;
<span class="hljs-keyword">import</span>&nbsp;java.util.Queue;

<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">CustomQueue</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;定义消息队列</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;Queue&lt;String&gt;&nbsp;queue&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;LinkedList&lt;&gt;();

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;producer();&nbsp;<span class="hljs-comment">//&nbsp;调用生产者</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;consumer();&nbsp;<span class="hljs-comment">//&nbsp;调用消费者</span>
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;生产者</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">producer</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;添加消息</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;queue.add(<span class="hljs-string">"first&nbsp;message."</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;queue.add(<span class="hljs-string">"second&nbsp;message."</span>);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;queue.add(<span class="hljs-string">"third&nbsp;message."</span>);
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;消费者</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">consumer</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">while</span>&nbsp;(!queue.isEmpty())&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;消费消息</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(queue.poll());
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="1051">以上程序的执行结果是：</p>
<pre class="lang-java" data-nodeid="1052"><code data-language="java">first&nbsp;message.
second&nbsp;message.
third&nbsp;message.
</code></pre>
<p data-nodeid="1053">可以看出消息是以先进先出顺序进行消费的。</p>
<p data-nodeid="1054">实现自定义延迟队列需要实现 Delayed 接口，重写 getDelay() 方法，延迟队列完整实现代码如下：</p>
<pre class="lang-java" data-nodeid="1055"><code data-language="java"><span class="hljs-keyword">import</span>&nbsp;lombok.Getter;
<span class="hljs-keyword">import</span>&nbsp;lombok.Setter;

<span class="hljs-keyword">import</span>&nbsp;java.text.DateFormat;
<span class="hljs-keyword">import</span>&nbsp;java.util.Date;
<span class="hljs-keyword">import</span>&nbsp;java.util.concurrent.DelayQueue;
<span class="hljs-keyword">import</span>&nbsp;java.util.concurrent.Delayed;
<span class="hljs-keyword">import</span>&nbsp;java.util.concurrent.TimeUnit;

<span class="hljs-comment">/**
&nbsp;*&nbsp;自定义延迟队列
&nbsp;*/</span>
<span class="hljs-keyword">public</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">CustomDelayQueue</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;延迟消息队列</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">private</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;DelayQueue&nbsp;delayQueue&nbsp;=&nbsp;<span class="hljs-keyword">new</span>&nbsp;DelayQueue();

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">main</span><span class="hljs-params">(String[]&nbsp;args)</span>&nbsp;<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;producer();&nbsp;<span class="hljs-comment">//&nbsp;调用生产者</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;consumer();&nbsp;<span class="hljs-comment">//&nbsp;调用消费者</span>
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;生产者</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">producer</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;添加消息</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;delayQueue.put(<span class="hljs-keyword">new</span>&nbsp;MyDelay(<span class="hljs-number">1000</span>,&nbsp;<span class="hljs-string">"消息1"</span>));
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;delayQueue.put(<span class="hljs-keyword">new</span>&nbsp;MyDelay(<span class="hljs-number">3000</span>,&nbsp;<span class="hljs-string">"消息2"</span>));
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;消费者</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-keyword">void</span>&nbsp;<span class="hljs-title">consumer</span><span class="hljs-params">()</span>&nbsp;<span class="hljs-keyword">throws</span>&nbsp;InterruptedException&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"开始执行时间："</span>&nbsp;+
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;DateFormat.getDateTimeInstance().format(<span class="hljs-keyword">new</span>&nbsp;Date()));
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">while</span>&nbsp;(!delayQueue.isEmpty())&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(delayQueue.take());
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class="hljs-string">"结束执行时间："</span>&nbsp;+
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;DateFormat.getDateTimeInstance().format(<span class="hljs-keyword">new</span>&nbsp;Date()));
&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;自定义延迟队列
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">static</span>&nbsp;<span class="hljs-class"><span class="hljs-keyword">class</span>&nbsp;<span class="hljs-title">MyDelay</span>&nbsp;<span class="hljs-keyword">implements</span>&nbsp;<span class="hljs-title">Delayed</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;延迟截止时间（单位：毫秒）</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">long</span>&nbsp;delayTime&nbsp;=&nbsp;System.currentTimeMillis();

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;借助&nbsp;lombok&nbsp;实现</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Getter</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Setter</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">private</span>&nbsp;String&nbsp;msg;

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">/**
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;初始化
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;<span class="hljs-doctag">@param</span>&nbsp;delayTime&nbsp;设置延迟执行时间
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;<span class="hljs-doctag">@param</span>&nbsp;msg&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;执行的消息
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*/</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-title">MyDelay</span><span class="hljs-params">(<span class="hljs-keyword">long</span>&nbsp;delayTime,&nbsp;String&nbsp;msg)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">this</span>.delayTime&nbsp;=&nbsp;(<span class="hljs-keyword">this</span>.delayTime&nbsp;+&nbsp;delayTime);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">this</span>.msg&nbsp;=&nbsp;msg;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;获取剩余时间</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Override</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">long</span>&nbsp;<span class="hljs-title">getDelay</span><span class="hljs-params">(TimeUnit&nbsp;unit)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;unit.convert(delayTime&nbsp;-&nbsp;System.currentTimeMillis(),&nbsp;TimeUnit.MILLISECONDS);
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-comment">//&nbsp;队列里元素的排序依据</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Override</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;<span class="hljs-keyword">int</span>&nbsp;<span class="hljs-title">compareTo</span><span class="hljs-params">(Delayed&nbsp;o)</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">if</span>&nbsp;(<span class="hljs-keyword">this</span>.getDelay(TimeUnit.MILLISECONDS)&nbsp;&gt;&nbsp;o.getDelay(TimeUnit.MILLISECONDS))&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;<span class="hljs-number">1</span>;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">else</span>&nbsp;<span class="hljs-keyword">if</span>&nbsp;(<span class="hljs-keyword">this</span>.getDelay(TimeUnit.MILLISECONDS)&nbsp;&lt;&nbsp;o.getDelay(TimeUnit.MILLISECONDS))&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;-<span class="hljs-number">1</span>;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;<span class="hljs-keyword">else</span>&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;<span class="hljs-number">0</span>;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-meta">@Override</span>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-function"><span class="hljs-keyword">public</span>&nbsp;String&nbsp;<span class="hljs-title">toString</span><span class="hljs-params">()</span>&nbsp;</span>{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="hljs-keyword">return</span>&nbsp;<span class="hljs-keyword">this</span>.msg;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
&nbsp;&nbsp;&nbsp;&nbsp;}
}
</code></pre>
<p data-nodeid="1056">以上程序的执行结果是：</p>
<pre class="lang-java" data-nodeid="1057"><code data-language="java">开始执行时间：<span class="hljs-number">2020</span>-<span class="hljs-number">4</span>-<span class="hljs-number">2</span>&nbsp;<span class="hljs-number">16</span>:<span class="hljs-number">17</span>:<span class="hljs-number">28</span>
消息<span class="hljs-number">1</span>
消息<span class="hljs-number">2</span>
结束执行时间：<span class="hljs-number">2020</span>-<span class="hljs-number">4</span>-<span class="hljs-number">2</span>&nbsp;<span class="hljs-number">16</span>:<span class="hljs-number">17</span>:<span class="hljs-number">31</span>
</code></pre>
<p data-nodeid="1058"><span style="color:#3f3f3f"><span class="font" style="font-family:微软雅黑, &quot;Microsoft YaHei&quot;"><span class="size" style="font-size:16px"></span></span></span></p>
<p data-nodeid="1059">可以看出，消息 1 和消息 2 都实现了延迟执行的功能。</p>
<h3 data-nodeid="1060">小结</h3>
<p data-nodeid="1061" class="">本课时讲了消息队列的使用场景：商品秒杀、系统解耦和日志记录，我们还介绍了 RabbitMQ 以及它的消息类型和它的特点等内容，同时还使用 Queue 的子类 LinkedList 实现了自定义消息队列，使用 DelayQueue 实现了自定义延迟消息队列。</p>

---

### 精选评论

##### **威：
> 老师，讲得真好，比市面上泛泛而谈的java书籍好多了

##### *镇：
> 收货很大

##### **庆：
> <div>学习知识要善于思考，思考，在思考。—爱因斯坦</div>

