<p data-nodeid="2292" class="">说到 Java 虚拟机不得不提的一个词就是 <strong data-nodeid="2298">“垃圾回收”（GC，Garbage Collection）</strong>，而垃圾回收的执行速度则影响着整个程序的执行效率，所以我们需要知道更多关于垃圾回收的具体执行细节，以便为我们选择合适的垃圾回收器提供理论支持。</p>









<p data-nodeid="2">我们本课时的面试题是，如何判断一个对象是否“死亡”？垃圾回收的算法有哪些？</p>
<h3 data-nodeid="3">典型回答</h3>
<p data-nodeid="4">垃圾回收器首先要做的就是，判断一个对象是存活状态还是死亡状态，死亡的对象将会被标识为垃圾数据并等待收集器进行清除。</p>
<p data-nodeid="5">判断一个对象是否为死亡状态的常用算法有两个：引用计数器算法和可达性分析算法。</p>
<p data-nodeid="6"><strong data-nodeid="75">引用计数算法（Reference Counting）</strong> 属于垃圾收集器最早的实现算法了，它是指在创建对象时关联一个与之相对应的计数器，当此对象被使用时加 1，相反销毁时 -1。当此计数器为 0 时，则表示此对象未使用，可以被垃圾收集器回收。</p>
<p data-nodeid="7">引用计数算法的优缺点很明显，其优点是垃圾回收比较及时，实时性比较高，只要对象计数器为 0，则可以直接进行回收操作；而缺点是无法解决循环引用的问题，比如以下代码：</p>
<pre class="lang-java" data-nodeid="8"><code data-language="java"><span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">CustomOne</span> </span>{
&nbsp; &nbsp; <span class="hljs-keyword">private</span> CustomTwo two;
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> CustomTwo <span class="hljs-title">getCustomTwo</span><span class="hljs-params">()</span> </span>{
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">return</span> two;
&nbsp; &nbsp; }
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">setCustomTwo</span><span class="hljs-params">(CustomTwo two)</span> </span>{
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">this</span>.two = two;
&nbsp; &nbsp; }
}
<span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">CustomTwo</span> </span>{
&nbsp; &nbsp; <span class="hljs-keyword">private</span> CustomOne one;
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> CustomOne <span class="hljs-title">getCustomOne</span><span class="hljs-params">()</span> </span>{
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">return</span> one;
&nbsp; &nbsp; }
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">void</span> <span class="hljs-title">setCustomOne</span><span class="hljs-params">(CustomOne one)</span> </span>{
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">this</span>.one = one;
&nbsp; &nbsp; }
}
<span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">RefCountingTest</span> </span>{
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
&nbsp; &nbsp; &nbsp; &nbsp; CustomOne one = <span class="hljs-keyword">new</span> CustomOne();
&nbsp; &nbsp; &nbsp; &nbsp; CustomTwo two = <span class="hljs-keyword">new</span> CustomTwo();
&nbsp; &nbsp; &nbsp; &nbsp; one.setCustomTwo(two);
&nbsp; &nbsp; &nbsp; &nbsp; two.setCustomOne(one);
&nbsp; &nbsp; &nbsp; &nbsp; one = <span class="hljs-keyword">null</span>;
&nbsp; &nbsp; &nbsp; &nbsp; two = <span class="hljs-keyword">null</span>;
    }
}
</code></pre>
<p data-nodeid="9">即使 one 和 two 都为 null，但因为循环引用的问题，两个对象都不能被垃圾收集器所回收。</p>
<p data-nodeid="10"><strong data-nodeid="82">可达性分析算法（Reachability Analysis）</strong> 是目前商业系统中所采用的判断对象死亡的常用算法，它是指从对象的起点（GC Roots）开始向下搜索，如果对象到 GC Roots 没有任何引用链相连时，也就是说此对象到 GC Roots 不可达时，则表示此对象可以被垃圾回收器所回收，如下图所示：</p>
<p data-nodeid="11"><img src="https://s0.lgstatic.com/i/image/M00/14/70/Ciqc1F7Q3giAKu5UAAClt3UMheE300.png" alt="image (4).png" data-nodeid="85"></p>
<p data-nodeid="12">当确定了对象的状态之后（存活还是死亡）接下来就是进行垃圾回收了，垃圾回收的常见算法有以下几个：</p>
<ul data-nodeid="13">
<li data-nodeid="14">
<p data-nodeid="15">标记-清除算法；</p>
</li>
<li data-nodeid="16">
<p data-nodeid="17">标记-复制算法；</p>
</li>
<li data-nodeid="18">
<p data-nodeid="19">标记-整理算法。</p>
</li>
</ul>
<p data-nodeid="20"><strong data-nodeid="94">标记-清除（Mark-Sweep）算法</strong>属于最早的垃圾回收算法，它是由标记阶段和清除阶段构成的。标记阶段会给所有的存活对象做上标记，而清除阶段会把没有被标记的死亡对象进行回收。而标记的判断方法就是前面讲的引用计数算法和可达性分析算法。</p>
<p data-nodeid="21">标记-清除算法的执行流程如下图所示：</p>
<p data-nodeid="22"><img src="https://s0.lgstatic.com/i/image/M00/14/7B/CgqCHl7Q3hOAHBq0AABM8DvzlGU761.png" alt="image (5).png" data-nodeid="98"></p>
<p data-nodeid="23">从上图可以看出，标记-清除算法有一个最大的问题就是会产生内存空间的碎片化问题，也就是说标记-清除算法执行完成之后会产生大量的不连续内存，这样当程序需要分配一个大对象时，因为没有足够的连续内存而导致需要提前触发一次垃圾回收动作。</p>
<p data-nodeid="24"><strong data-nodeid="104">标记-复制算法</strong>是标记-清除算法的一个升级，使用它可以有效地解决内存碎片化的问题。它是指将内存分为大小相同的两块区域，每次只使用其中的一块区域，这样在进行垃圾回收时就可以直接将存活的东西复制到新的内存上，然后再把另一块内存全部清理掉。这样就不会产生内存碎片的问题了，其执行流程如下图所示：</p>
<p data-nodeid="25"><img src="https://s0.lgstatic.com/i/image/M00/14/7B/CgqCHl7Q3h6ATzDEAABQETkptLk639.png" alt="image (6).png" data-nodeid="107"></p>
<p data-nodeid="26">标记-复制的算法虽然可以解决内存碎片的问题，但同时也带来了新的问题。因为需要将内存分为大小相同的两块内存，那么内存的实际可用量其实只有原来的一半，这样此算法导致了内存的可用率大幅降低了。</p>
<p data-nodeid="27"><strong data-nodeid="113">标记-整理算法</strong>的诞生晚于标记-清除算法和标记-复制算法，它也是由两个阶段组成的：标记阶段和整理阶段。其中标记阶段和标记-清除算法的标记阶段一样，不同的是后面的一个阶段，标记-整理算法的后一个阶段不是直接对内存进行清除，而是把所有存活的对象移动到内存的一端，然后把另一端的所有死亡对象全部清除，执行流程图如下图所示：</p>
<p data-nodeid="28"><img src="https://s0.lgstatic.com/i/image/M00/14/7B/CgqCHl7Q3ieAYV5FAABLfGQH4UE403.png" alt="image (7).png" data-nodeid="116"></p>
<h3 data-nodeid="29">考点分析</h3>
<p data-nodeid="30">本题目考察的是关于垃圾收集的一些理论算法问题，都属于概念性的问题，只要深入理解之后还是挺容易记忆的。和此知识点相关的面试题还有这些：</p>
<ul data-nodeid="2726">
<li data-nodeid="2727">
<p data-nodeid="2728" class="">Java 中可作为 GC Roots 的对象有哪些？</p>
</li>
<li data-nodeid="2729">
<p data-nodeid="2730">说一下死亡对象的判断细节？</p>
</li>
</ul>


<h3 data-nodeid="36">知识扩展</h3>
<h4 data-nodeid="3155" class="">GC Roots</h4>


<p data-nodeid="3579" class="te-preview-highlight">在 Java 中可以作为 GC Roots 的对象，主要包含以下几个：</p>


<ul data-nodeid="39">
<li data-nodeid="40">
<p data-nodeid="41">所有被同步锁持有的对象，比如被 synchronize 持有的对象；</p>
</li>
<li data-nodeid="42">
<p data-nodeid="43">字符串常量池里的引用（String Table）；</p>
</li>
<li data-nodeid="44">
<p data-nodeid="45">类型为引用类型的静态变量；</p>
</li>
<li data-nodeid="46">
<p data-nodeid="47">虚拟机栈中引用对象；</p>
</li>
<li data-nodeid="48">
<p data-nodeid="49">本地方法栈中的引用对象。</p>
</li>
</ul>
<h4 data-nodeid="50">死亡对象判断</h4>
<p data-nodeid="51">当使用可达性分析判断一个对象不可达时，并不会直接标识这个对象为死亡状态，而是先将它标记为“待死亡”状态再进行一次校验。校验的内容就是此对象是否重写了 finalize() 方法，如果该对象重写了 finalize() 方法，那么这个对象将会被存入到 F-Queue 队列中，等待 JVM 的 Finalizer 线程去执行重写的 finalize() 方法，在这个方法中如果此对象将自己赋值给某个类变量时，则表示此对象已经被引用了。因此不能被标识为死亡状态，其他情况则会被标识为死亡状态。</p>
<p data-nodeid="52">以上流程对应的示例代码如下：</p>
<pre class="lang-java" data-nodeid="53"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">FinalizeTest</span> </span>{
&nbsp; &nbsp; <span class="hljs-comment">// 需要状态判断的对象</span>
&nbsp; &nbsp; <span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> FinalizeTest Hook = <span class="hljs-keyword">null</span>;
&nbsp; &nbsp; <span class="hljs-meta">@Override</span>
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">protected</span> <span class="hljs-keyword">void</span> <span class="hljs-title">finalize</span><span class="hljs-params">()</span> <span class="hljs-keyword">throws</span> Throwable </span>{
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">super</span>.finalize();
&nbsp; &nbsp; &nbsp; &nbsp; System.out.println(<span class="hljs-string">"执行了 finalize 方法"</span>);
&nbsp; &nbsp; &nbsp; &nbsp; FinalizeTest.Hook = <span class="hljs-keyword">this</span>;
&nbsp; &nbsp; }
&nbsp; &nbsp; <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> <span class="hljs-keyword">throws</span> InterruptedException </span>{
&nbsp; &nbsp; &nbsp; &nbsp; Hook = <span class="hljs-keyword">new</span> FinalizeTest();
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-comment">// 卸载对象，第一次执行 finalize()</span>
&nbsp; &nbsp; &nbsp; &nbsp; Hook = <span class="hljs-keyword">null</span>;
&nbsp; &nbsp; &nbsp; &nbsp; System.gc();
&nbsp; &nbsp; &nbsp; &nbsp; Thread.sleep(<span class="hljs-number">500</span>); <span class="hljs-comment">// 等待 finalize() 执行</span>
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">if</span> (Hook != <span class="hljs-keyword">null</span>) {
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; System.out.println(<span class="hljs-string">"存活状态"</span>);
&nbsp; &nbsp; &nbsp; &nbsp; } <span class="hljs-keyword">else</span> {
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; System.out.println(<span class="hljs-string">"死亡状态"</span>);
&nbsp; &nbsp; &nbsp; &nbsp; }
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-comment">// 卸载对象，与上一次代码完全相同</span>
&nbsp; &nbsp; &nbsp; &nbsp; Hook = <span class="hljs-keyword">null</span>;
&nbsp; &nbsp; &nbsp; &nbsp; System.gc();
&nbsp; &nbsp; &nbsp; &nbsp; Thread.sleep(<span class="hljs-number">500</span>); <span class="hljs-comment">// 等待 finalize() 执行</span>
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">if</span> (Hook != <span class="hljs-keyword">null</span>) {
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; System.out.println(<span class="hljs-string">"存活状态"</span>);
&nbsp; &nbsp; &nbsp; &nbsp; } <span class="hljs-keyword">else</span> {
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; System.out.println(<span class="hljs-string">"死亡状态"</span>);
&nbsp; &nbsp; &nbsp; &nbsp; }
&nbsp; &nbsp; }
}
</code></pre>
<p data-nodeid="54">上述代码的执行结果为：</p>
<pre class="lang-java" data-nodeid="55"><code data-language="java">执行了 finalize 方法
存活状态
死亡状态
</code></pre>
<p data-nodeid="56">从结果可以看出，卸载了两次对象，第一次执行了 finalize() 方法，成功地把自己从待死亡状态拉了回来；而第二次同样的代码却没有执行 finalize() 方法，从而被确认为了死亡状态，这是因为<strong data-nodeid="138">任何对象的 finalize() 方法都只会被系统调用一次</strong>。</p>
<p data-nodeid="57">虽然可以从 finalize() 方法中把自己从死亡状态“拯救”出来，但是不建议这样做，因为所有对象的 finalize() 方法只会执行一次。因此同样的代码可能产生的结果是不同的，这样就给程序的执行带来了很大的不确定性。</p>
<h3 data-nodeid="58">小结</h3>
<p data-nodeid="59">本课时讲了对象状态判断的两种算法：引用计数算法和可达性分析算法。其中引用计数算法无法解决循环引用的问题，因此对于绝大多数的商业系统来说使用的都是可达性分析算法；同时还讲了垃圾回收的三种算法：标记-清除算法、标记-复制算法、标记-整理算法，其中，标记-清除算法会带来内存碎片的问题，而标记-复制算法会降低内存的利用率。所以，标记-整理算法算是一个不错的方案。</p>

---

### 精选评论

##### *新：
> 这个文档是不是有点问题？上面说的GC roots,在知识扩展，哪些可以作为GC roots对象时，却是CG root

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 检查了，文稿写的是 GC Roots

##### **春：
> <span style="font-size: 16.0125px;">之前只是了解到finalize不一定执行，但不清楚为什么。</span><div><span style="font-size: 16.0125px;">1、如果一个对象</span><span style="font-size: 16.0125px;">GC Roots为空，有可能在finalize被执行前就被GC回收了。</span></div><div><span style="font-size: 16.0125px;">2、如果finalize有机会被执行，一个对象只会执行一次，执行结果存在不确定性。</span></div><div><span style="font-size: 16.0125px;">这下算是了解清楚了</span></div>

##### **瑞：
> CG root？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 检查了，文稿写的是 GC Roots

##### *俊：
> 引用计数法，可以解决循环引用导致无法被回收的问题，麻烦一些。

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 严格意义来说应该是引用计数法存在循环引用的问题。

##### **生：
> 补充一下 成员变量也可作为Gc 可达性分析入口。

##### *杰：
> GC Roots 的对象： 字符串常量池里的引用     这个怎么理解？字符串常量池不都是一些字符串常量吗？垃圾回收算法 为什么没有讲到 分代垃圾回收算法呢？

 ###### &nbsp;&nbsp;&nbsp; 编辑回复：
> &nbsp;&nbsp;&nbsp; Java 中有两个不常用的概念——字面量和符号引用，可以配合其他资料看看哈。本专栏会讲一些比较常见的知识点，但整个 Java 体系还有很多的内容，可以配合其他资料一起看哦。

##### **强：
> <span style="font-size: 16.0125px;">讲师你好，</span><div><span style="font-size: 16.0125px;">1、怎样判断对象到 GC Roots 没有任何引用链相连呢？在代码中是怎样体现呢？</span><div><span style="font-size: 16.0125px;">2、垃圾回收的·fullGc是否是判断没有相连后才进行回收，而Mingor GC只是用来标记GC的次数吗？还是？</span></div></div><div><span style="font-size: 16.0125px;">3、强弱软虚四种引用在分别是怎样判断和</span><span style="font-size: 0.427rem;">GC Roots判断没有任何相连</span>的呢？</div><div>困扰了很多，但是看书没看懂，期待回复</div>

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 目前主流的虚拟机都是采用 GC Roots Tracing 的算法来实现跟引用查找的，该算法的核心算法是从 GC Roots 对象作为起始点，利用数学中图论知识，图中可达对象便是存活对象，而不可达对象则是需要回收的垃圾内存，这个不做 JVM 开发建议了解就可以了。
垃圾回收要看具体的垃圾回收器，可以看下 25 课时回收的执行流程，那个里面有答案哦。

