<p data-nodeid="1273">数据结构属于理解一些源码和技术所必备的知识，比如要读懂 Java 语言中 TreeMap 和 TreeSet 的源码就要懂红黑树的数据结构，不然是无法理解源码中关于红黑树数据的操作代码的，比如左旋、右旋、添加和删除操作等。因此本课时我们就来学习一下数据结构的基础知识，方便看懂源码或者是防止面试中被问到。</p>


<p data-nodeid="3">我们本课时的面试题是，红黑树和二叉树有什么区别？</p>
<h3 data-nodeid="4">典型回答</h3>
<p data-nodeid="5">要回答这个问题之前，我们先要弄清什么是二叉树？什么是红黑树？</p>
<p data-nodeid="903">二叉树（Binary Tree）是指每个节点最多只有两个分支的树结构，即不存在分支大于 2 的节点，二叉树的数据结构如下图所示：</p>
<p data-nodeid="904" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/37/CgqCHl7p1giALPJdAAA9HlzQhz8713.png" alt="image" data-nodeid="908"></p>


<p data-nodeid="8">这是一棵拥有 6 个节点深度为 2（深度从 0 开始），并且根节点为 3 的二叉树。</p>
<p data-nodeid="9">二叉树有两个分支通常被称作“左子树”和“右子树”，而且这些分支具有左右次序不能随意地颠倒。</p>
<p data-nodeid="10">一棵空树或者满足以下性质的二叉树被称之为<strong data-nodeid="100">二叉查找树</strong>：</p>
<ul data-nodeid="11">
<li data-nodeid="12">
<p data-nodeid="13">若任意节点的左子树不为空，则左子树上所有节点的值均小于它的根节点的值；</p>
</li>
<li data-nodeid="14">
<p data-nodeid="15">若任意节点的右子树不为空，则右子树上所有节点的值均大于或等于它的根节点的值；</p>
</li>
<li data-nodeid="16">
<p data-nodeid="17">任意节点的左、右子树分别为二叉查找树。</p>
</li>
</ul>
<p data-nodeid="1987">如下图所示，这就是一个标准的二叉查找树：</p>
<p data-nodeid="1988" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/38/CgqCHl7p1o2AD2B1AABAMGFwUAs699.png" alt="image" data-nodeid="1992"></p>


<p data-nodeid="20">二叉查找树（Binary Search Tree）也被称为二叉搜索树、有序二叉树（Ordered Binary Tree）或排序二叉树（Sorted Binary Tree）等。</p>
<p data-nodeid="21">红黑树（Red Black Tree）是一种自平衡二叉查找树，它最早被称之为“对称二叉 B 树”，它现在的名字源于 1978 年的一篇论文，之后便被称之为红黑树了。</p>
<p data-nodeid="22">所谓的平衡树是指一种改进的二叉查找树，顾名思义平衡树就是将二叉查找树平衡均匀地分布，这样的好处就是可以减少二叉查找树的深度。</p>
<p data-nodeid="23">一般情况下二叉查找树的查询复杂度取决于目标节点到树根的距离（即深度），当节点的深度普遍较大时，查询的平均复杂度就会上升，因此为了实现更高效的查询就有了平衡树。</p>
<p data-nodeid="2705">非平衡二叉树如下图所示：</p>
<p data-nodeid="2706" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/2C/Ciqc1F7p1piAYHGAAABOcycxnUY851.png" alt="image" data-nodeid="2710"></p>


<p data-nodeid="3423">平衡二叉树如下图所示：</p>
<p data-nodeid="3424" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/38/CgqCHl7p1qCAYIL5AABORFVaJ_E571.png" alt="image" data-nodeid="3428"></p>


<p data-nodeid="28">可以看出使用平衡二叉树可以有效的减少二叉树的深度，从而提高了查询的效率。</p>
<p data-nodeid="29">红黑树除了具备二叉查找树的基本特性之外，还具备以下特性：</p>
<ul data-nodeid="30">
<li data-nodeid="31">
<p data-nodeid="32">节点是红色或黑色；</p>
</li>
<li data-nodeid="33">
<p data-nodeid="34">根节点是黑色；</p>
</li>
<li data-nodeid="35">
<p data-nodeid="36">所有叶子都是黑色的空节点（NIL 节点）；</p>
</li>
<li data-nodeid="37">
<p data-nodeid="38">每个红色节点必须有两个黑色的子节点，也就是说从每个叶子到根的所有路径上，不能有两个连续的红色节点；</p>
</li>
<li data-nodeid="39">
<p data-nodeid="40">从一个节点到该节点的子孙节点的所有路径上包含相同数目的黑色节点。</p>
</li>
</ul>
<p data-nodeid="4141">红黑树结构如下图所示：</p>
<p data-nodeid="4142" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/38/CgqCHl7p1q2ANRAbAADvqVSROHE030.png" alt="image" data-nodeid="4146"></p>


<h3 data-nodeid="43">考点分析</h3>
<p data-nodeid="44">红黑树是一个较为复杂的数据结构，尤其是对于增加和删除操作来说，一般面试官不会让你直接手写红黑树的具体实现。如果你只有很短的时间准备面试的话，那么我建议你不要死磕这些概念，要学会有的放矢，因为即使你花费很多的时间来背这些概念，一转眼的功夫就会彻底忘掉，所以你只需要大概地了解其中的一些概念和明白大致的原理就足够了。</p>
<p data-nodeid="45">和此知识点相关的面试题还有以下这些：</p>
<ul data-nodeid="46">
<li data-nodeid="47">
<p data-nodeid="48">为什么工程中喜欢使用红黑树而不是其他二叉查找树？</p>
</li>
<li data-nodeid="49">
<p data-nodeid="50">红黑树是如何保证自平衡的？</p>
</li>
</ul>
<h3 data-nodeid="51">知识扩展</h3>
<h4 data-nodeid="52">红黑树的优势</h4>
<p data-nodeid="4859">红黑树的优势在于它是一个平衡二叉查找树，对于普通的二叉查找树（非平衡二叉查找树）在极端情况下可能会退化为链表的结构，例如，当我们依次插入 3、4、5、6、7、8 这些数据时，二叉树会退化为如下链表结构：</p>
<p data-nodeid="4860" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/2C/Ciqc1F7p1raAA54FAABNRmDFu94908.png" alt="image" data-nodeid="4864"></p>


<p data-nodeid="55">当二叉查找树退化为链表数据结构后，再进行元素的添加、删除以及查询时，它的时间复杂度就会退化为 O(n)；而如果使用红黑树的话，它就会将以上数据转化为平衡二叉查找树，这样就可以更加高效的添加、删除以及查询数据了，这就是红黑树的优势。</p>
<blockquote data-nodeid="56">
<p data-nodeid="57">小贴士：红黑树的高度近似 log2n，它的添加、删除以及查询数据的时间复杂度为 O(logn)。</p>
</blockquote>
<p data-nodeid="58">我们在表示算法的执行时间时，通常会使用大 O 表示法，常见的标识类型有以下这些：</p>
<ul data-nodeid="59">
<li data-nodeid="60">
<p data-nodeid="61">O(1)：常量时间，计算时间与数据量大小没关系；</p>
</li>
<li data-nodeid="62">
<p data-nodeid="63">O(n)：计算时间与数据量成线性正比关系；</p>
</li>
<li data-nodeid="64">
<p data-nodeid="65">O(logn)：计算时间与数据量成对数关系；</p>
</li>
</ul>
<h4 data-nodeid="66">自平衡的红黑树</h4>
<p data-nodeid="67">红黑树能够实现自平衡和保持红黑树特征的主要手段是：<strong data-nodeid="154">变色、左旋和右旋</strong>。</p>
<p data-nodeid="5577"><strong data-nodeid="5583">左旋</strong>指的是围绕某个节点向左旋转，也就是逆时针旋转某个节点，使得父节点被自己的右子节点所替代，如下图所示：</p>
<p data-nodeid="5578" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/2D/Ciqc1F7p1sCAAVsAAACkC6fB4TE240.png" alt="image" data-nodeid="5586"></p>


<p data-nodeid="70">在 TreeMap 源码中左旋的实现源码如下：</p>
<pre class="lang-java" data-nodeid="71"><code data-language="java"><span class="hljs-comment">// 源码基于 JDK 1.8</span>
<span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">void</span> <span class="hljs-title">rotateLeft</span><span class="hljs-params">(Entry&lt;K,V&gt; p)</span> </span>{
    <span class="hljs-keyword">if</span> (p != <span class="hljs-keyword">null</span>) {
        <span class="hljs-comment">// 右子节点</span>
        Entry&lt;K,V&gt; r = p.right; 
        <span class="hljs-comment">// p 节点的右子节点为 r 的左子节点</span>
        p.right = r.left;
        <span class="hljs-comment">// r 左子节点如果非空，r 左子节点的父节点设置为 p 节点</span>
        <span class="hljs-keyword">if</span> (r.left != <span class="hljs-keyword">null</span>) 
            r.left.parent = p; 
        r.parent = p.parent; <span class="hljs-comment">// r 父节点等于 p 父节点</span>
        <span class="hljs-comment">// p 父节点如果为空，那么讲根节点设置为 r 节点</span>
        <span class="hljs-keyword">if</span> (p.parent == <span class="hljs-keyword">null</span>)
            root = r;
        <span class="hljs-comment">// p 父节点的左子节点如果等于 p 节点，那么 p 父节点的左子节点设置 r 节点</span>
        <span class="hljs-keyword">else</span> <span class="hljs-keyword">if</span> (p.parent.left == p)
            p.parent.left = r;
        <span class="hljs-keyword">else</span>
            p.parent.right = r;
        r.left = p; 
        p.parent = r;
    }
}
</code></pre>
<p data-nodeid="72">左旋代码说明：在刚开始时，p 为父节点，r 为子节点，在左旋操作后，r 节点代替 p 节点的位置，p 节点成为 r 节点的左孩子，而 r 节点的左孩子成为 p 节点的右孩子。</p>
<p data-nodeid="6299"><strong data-nodeid="6305">右旋</strong>指的是围绕某个节点向右旋转，也就是顺时针旋转某个节点，此时父节点会被自己的左子节点取代，如下图所示：</p>
<p data-nodeid="6300" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/2D/Ciqc1F7p1suAH4G9AACoLoWsW64383.png" alt="image" data-nodeid="6308"></p>


<p data-nodeid="75">在 TreeMap 源码中右旋的实现源码如下：</p>
<pre class="lang-java" data-nodeid="76"><code data-language="java"><span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">void</span> <span class="hljs-title">rotateRight</span><span class="hljs-params">(Entry&lt;K,V&gt; p)</span> </span>{
&nbsp; &nbsp; <span class="hljs-keyword">if</span> (p != <span class="hljs-keyword">null</span>) {
&nbsp; &nbsp; &nbsp; &nbsp; Entry&lt;K,V&gt; l = p.left;
        <span class="hljs-comment">// p 节点的左子节点为 l 的右子节点</span>
&nbsp; &nbsp; &nbsp; &nbsp; p.left = l.right;
        <span class="hljs-comment">// l 节点的右子节点非空时，设置 l 的右子节点的父节点为 p</span>
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">if</span> (l.right != <span class="hljs-keyword">null</span>) l.right.parent = p;
&nbsp; &nbsp; &nbsp; &nbsp; l.parent = p.parent;
        <span class="hljs-comment">// p 节点的父节点为空时，根节点设置成 l 节点</span>
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">if</span> (p.parent == <span class="hljs-keyword">null</span>)
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; root = l;
        <span class="hljs-comment">// p 节点的父节点的右子节点等于 p 节点时，p 的父节点的右子节点设置为 l</span>
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">else</span> <span class="hljs-keyword">if</span> (p.parent.right == p)
&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; p.parent.right = l;
&nbsp; &nbsp; &nbsp; &nbsp; <span class="hljs-keyword">else</span> p.parent.left = l;
&nbsp; &nbsp; &nbsp; &nbsp; l.right = p;
&nbsp; &nbsp; &nbsp; &nbsp; p.parent = l;
&nbsp; &nbsp; }
}
</code></pre>
<p data-nodeid="77">右旋代码说明：在刚开始时，p 为父节点 l 为子节点，在右旋操作后，l 节点代替 p 节点，p 节点成为 l 节点的右孩子，l 节点的右孩子成为 p 节点的左孩子。</p>
<p data-nodeid="7021">对于红黑树来说，如果当前节点的左、右子节点均为红色时，因为需要满足红黑树定义的第四条特征，所以需要执行变色操作，如下图所示：</p>
<p data-nodeid="7022" class=""><img src="https://s0.lgstatic.com/i/image/M00/21/38/CgqCHl7p1tOAGG5hAABjt5_gQjg041.png" alt="image" data-nodeid="7026"></p>


<p data-nodeid="80" class="">由于篇幅有限，我这里只能带你简单地了解一下红黑树和二叉树的基本概念，想要深入地学习更多的内容，推荐查阅《算法》（第四版）和《算法导论》等书籍。</p>
<h3 data-nodeid="81">小结</h3>
<p data-nodeid="82">我们本课时介绍了二叉树、二叉查找树及红黑树的概念，还有红黑树的五个特性。普通二叉查找树在特殊情况下会退化成链表的数据结构，因此操作和查询的时间复杂度变成了 O(n)，而红黑树可以实现自平衡，因此它的操作（插入、删除）和查找的时间复杂度都是 O(logn)，效率更高更稳定，红黑树保证平衡的手段有三个：变色、左旋和右旋。</p>

---

### 精选评论

##### **天使：
> 为什么HashMap使用红黑树而不使用其他树结构，比如B树，B+树，或者AVL树？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 我考虑是处于业务场景考虑，比如AVL树比红黑树保持更加严格的平衡规则，在AVL树中查找通常更快，但这是以更多旋转操作导致更慢的插入和删除为代价的，因此如果希望查找次数主导树的更新次数，那么应该使用AVL树，而HashMap最初是数组和链表，只有在频繁的插入导致冲突之后才会升级为红黑树，因此可以大概率判断HashMap如果发生了升级则添加和删除应该是比较频繁的，因此红黑树更合适一些。

##### *杰：
> 1、红黑树，为什么要有红色和黑色？2、执行变色操作的目的是？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 红黑树本质上是一种平衡树，执行变色是为了维持节点的平衡。

##### **根：
> 红黑树的高度最多是 2log（n），这个可以怎么理解？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 红黑树的高度取决于节点的个数哦~

##### **峰：
> 红黑树比AVL树的优点是什么？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; AVL属于早期的平衡树，红黑树可以简单的理解为包含了 AVL 的特性，同时有新增了颜色的属性用于存储更多的信息。

##### **宸：
> 红黑树目的是为了提高查找效率。hashmap原来是数组加链表。Java8增加红黑树，本质都是提高效率

