<p data-nodeid="439">上一课时我们介绍了数据结构的知识，数据结构属于计算机存储的基础，有了它才能更好地将数据进行存储。而算法可以这样理解：它是为数据结构服务的，使用合适的算法可以更快地操作和查询这些数据。</p>



<p data-nodeid="4">算法的内容有很多，随随便便一本算法书有个 700 页到 1500 页也是很平常的事，因此我们在这里不能把所有的算法问题全部讲到，即使专门再开设一个算法专栏，也只能挑重点的讲。那么我们好钢就要用在刀刃上，本课时会把面试中经常出现的和平常工作中使用频率最高的算法，拿出来给大家分享。</p>
<p data-nodeid="5">我们本课时的面试题是，你知道哪些算法？讲一下它的内部实现？</p>
<h3 data-nodeid="725" class="">典型回答</h3>

<p data-nodeid="7">最常见、最基础的算法是<strong data-nodeid="75">二分法</strong>，它是二分查找算法的简称（Binary Search Algorithm），也叫折半搜索算法或对数搜索算法。它是一种在有序数组中查找某一特定元素的搜索算法，顾名思义，是将一组有序元素中的数据划分为两组，通过判断中间值来确认要查找值的大致位置，然后重复此过程进行元素查询。</p>
<p data-nodeid="1279">例如，我们要查询 1~100 中的某个数值，比如我们要查询的数值为 75，如果按照顺序从 1 开始一直往后排序对比的话，需要经历 75 次，才能查询到我们想要的数据；而如果使用二分法，则会先判断 50（1~100 的中间值）和 75 哪个大，然后就能确定要查询的值是在 50~100 之间，最后再进行二分，用 75 和 75 进行比较，结果发现此值就是我们想要找的那个值，于是我们只用了两步就找到了要查询的值，这就是算法的“魔力”。</p>
<p data-nodeid="1851"><img src="https://s0.lgstatic.com/i/image/M00/22/B9/CgqCHl7sZNCAT9rMAAAl1q40uyk767.png" alt="1.png" data-nodeid="1855"></p>
<p data-nodeid="1852" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/B9/CgqCHl7sZNaAEXzcAAAe930v434950.png" alt="2.png" data-nodeid="1858"></p>






<p data-nodeid="11">二分查找算法的实现代码如下：</p>
<pre class="lang-java" data-nodeid="12"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">AlgorithmExample</span> </span>{
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
        <span class="hljs-comment">// 要查询的数组</span>
        <span class="hljs-keyword">int</span>[] binaryNums = <span class="hljs-keyword">new</span> <span class="hljs-keyword">int</span>[<span class="hljs-number">100</span>];
        <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> i = <span class="hljs-number">0</span>; i &lt; <span class="hljs-number">100</span>; i++) {
            <span class="hljs-comment">// 初始化数组（存入 100 个数据）</span>
            binaryNums[i] = (i + <span class="hljs-number">1</span>);
        }
        <span class="hljs-comment">// 要查询的数值</span>
        <span class="hljs-keyword">int</span> findValue = <span class="hljs-number">75</span>;
        <span class="hljs-comment">// 调用二分查找算法</span>
        <span class="hljs-keyword">int</span> binaryResult = binarySearch(binaryNums, <span class="hljs-number">0</span>, binaryNums.length - <span class="hljs-number">1</span>, findValue);
        <span class="hljs-comment">// 打印结果</span>
        System.out.println(<span class="hljs-string">"元素的位置是："</span> + (binaryResult + <span class="hljs-number">1</span>));
    }
    <span class="hljs-comment">/**
     * 二分查找算法（返回该值第一次出现的位置）
     * <span class="hljs-doctag">@param</span> nums      查询数组
     * <span class="hljs-doctag">@param</span> start     开始下标
     * <span class="hljs-doctag">@param</span> end       结束下标
     * <span class="hljs-doctag">@param</span> findValue 要查找的值
     * <span class="hljs-doctag">@return</span> int
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">int</span> <span class="hljs-title">binarySearch</span><span class="hljs-params">(<span class="hljs-keyword">int</span>[] nums, <span class="hljs-keyword">int</span> start, <span class="hljs-keyword">int</span> end, <span class="hljs-keyword">int</span> findValue)</span> </span>{
        <span class="hljs-keyword">if</span> (start &lt;= end) {
            <span class="hljs-comment">// 中间位置</span>
            <span class="hljs-keyword">int</span> middle = (start + end) / <span class="hljs-number">2</span>;
            <span class="hljs-comment">// 中间的值</span>
            <span class="hljs-keyword">int</span> middleValue = nums[middle];
            <span class="hljs-keyword">if</span> (findValue == middleValue) {
                <span class="hljs-comment">// 等于中值直接返回</span>
                <span class="hljs-keyword">return</span> middle;
            } <span class="hljs-keyword">else</span> <span class="hljs-keyword">if</span> (findValue &lt; middleValue) {
                <span class="hljs-comment">// 小于中值，在中值之前的数据中查找</span>
                <span class="hljs-keyword">return</span> binarySearch(nums, start, middle - <span class="hljs-number">1</span>, findValue);
            } <span class="hljs-keyword">else</span> {
                <span class="hljs-comment">// 大于中值，在中值之后的数据中查找</span>
                <span class="hljs-keyword">return</span> binarySearch(nums, middle + <span class="hljs-number">1</span>, end, findValue);
            }
        }
        <span class="hljs-keyword">return</span> -<span class="hljs-number">1</span>;
    }
}
</code></pre>
<p data-nodeid="13">以上程序的执行结果为：</p>
<pre class="lang-java" data-nodeid="14"><code data-language="java">元素的位置是：<span class="hljs-number">75</span>
</code></pre>
<p data-nodeid="15">从上面的内容我们可以看出二分法虽然简单，但是也要满足一个特定的条件才行，那就是要使用二分法必须是有序排列的数值才行，不然是没办法实现二分法的。</p>
<p data-nodeid="16">除了二分法之外还有另一个比较常用的排序算法：冒泡排序。</p>
<p data-nodeid="2143" class="">冒泡排序（Bubble Sort）又被称为<strong data-nodeid="2149">泡式排序</strong>，它是指重复走访要排序的数列，每次比较两个元素，如果顺序不对就进行交换，直到没有被交换的元素为止，这样就完成了一次冒泡排序。</p>

<p data-nodeid="2710">为了让大家更好地理解冒泡排序，我录制了一个 gif 图片用于展示冒泡排序的执行过程，如下图所示：</p>
<p data-nodeid="2711" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/BA/CgqCHl7sZQKAUy0oAAXcTvUGdQI328.gif" alt="3.gif" data-nodeid="2715"></p>


<p data-nodeid="20">由上图可以看出，冒泡排序的关键执行流程是：依次对比相邻的两个数字，如果前面的数字大于后面的数字，那么就将前、后两个数字进行位置交换；这样每次对比完一轮数据之后，能找出此轮最大的数字并放置到尾部，如此重复，直到没有可以交换的数据为止，这样就完成了冒泡排序。</p>
<p data-nodeid="21">接下来我们就使用 Java 代码来实现一个冒泡排序算法，实现代码如下：</p>
<pre class="lang-java" data-nodeid="22"><code data-language="java"><span class="hljs-keyword">import</span> java.util.Arrays;
<span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">AlgorithmExample</span> </span>{
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
        <span class="hljs-comment">// 待排序数组</span>
        <span class="hljs-keyword">int</span>[] nums = {<span class="hljs-number">33</span>, <span class="hljs-number">45</span>, <span class="hljs-number">11</span>, <span class="hljs-number">22</span>, <span class="hljs-number">12</span>, <span class="hljs-number">39</span>, <span class="hljs-number">27</span>};
        bubbleSort(nums);
        <span class="hljs-comment">// 打印排序完数组</span>
        System.out.println(Arrays.toString(nums));
    }
    <span class="hljs-comment">/**
     * 冒泡排序
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">bubbleSort</span><span class="hljs-params">(<span class="hljs-keyword">int</span>[] nums)</span> </span>{
        <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> i = <span class="hljs-number">1</span>; i &lt; nums.length; i++) {
            <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> j = <span class="hljs-number">0</span>; j &lt; nums.length - i; j++) {
                <span class="hljs-keyword">if</span> (nums[j] &gt; nums[j + <span class="hljs-number">1</span>]) {
                    <span class="hljs-comment">// 前面数字大于后面的数字，执行位置交换</span>
                    <span class="hljs-keyword">int</span> temp = nums[j];
                    nums[j] = nums[j + <span class="hljs-number">1</span>];
                    nums[j + <span class="hljs-number">1</span>] = temp;
                }
            }
        }
    }
}
</code></pre>
<p data-nodeid="23">以上程序的执行结果为：</p>
<pre class="lang-java" data-nodeid="24"><code data-language="java">[<span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">22</span>, <span class="hljs-number">27</span>, <span class="hljs-number">33</span>, <span class="hljs-number">39</span>, <span class="hljs-number">45</span>]
</code></pre>
<p data-nodeid="25">从以上结果可以看出，冒泡排序算法的执行成功了，结果也符合我们的预期。</p>
<h3 data-nodeid="3000" class="">考点分析</h3>

<p data-nodeid="27">冒泡排序和二分法属于程序员必须掌握的两种最基础的算法了，如果连这两个算法都不知道或者都不能手写这两种算法的话，可能会给面试官留下非常不好的印象。因为二者都属于基础中的基础了，其实只要理解了两种算法的核心思想，再手写代码也不是什么难事，如果实在写不出具体的代码，最起码要做到能写出伪代码的程度。</p>
<p data-nodeid="28">和此知识点相关的面试题，还有以下这些：</p>
<ul data-nodeid="29">
<li data-nodeid="30">
<p data-nodeid="31">如何优化冒泡排序算法？</p>
</li>
<li data-nodeid="32">
<p data-nodeid="33">是否还知道更多的算法？</p>
</li>
</ul>
<h3 data-nodeid="3286" class="">知识扩展</h3>

<h4 data-nodeid="3572" class="">冒泡排序优化</h4>

<p data-nodeid="4134">从上面冒泡排序的 gif 图片可以看出，在最后一轮对比之前，数组的排序如下图所示：</p>
<p data-nodeid="4135" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/AE/Ciqc1F7sZRmAPW8eAAAzs1PEQbE845.png" alt="4.png" data-nodeid="4139"></p>


<p data-nodeid="4700">从图片可以看出，此时数组已经完全排序好了，但是即使这样，冒泡排序还是又执行了一次遍历对比，如下图所示：</p>
<p data-nodeid="4701" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/AE/Ciqc1F7sZSCAGa-sAAQoQzOns9o694.gif" alt="5.gif" data-nodeid="4705"></p>


<p data-nodeid="40">因此我们就可以想办法去掉无效的遍历，这样就可以优化冒泡排序的执行效率了。</p>
<p data-nodeid="41">我们可以在第一层循环内加一个判断标识，每次赋值为 true，假如在第二层循环（内层循环）时执行了位置交换，也就是 if 中的代码之后，我们把此值设置成 false；如果执行完内层循环判断之后，变量依然为 true，这就说明没有可以移动的元素了，冒泡排序可以结束执行了，优化后的代码如下所示：</p>
<pre class="lang-java" data-nodeid="42"><code data-language="java"><span class="hljs-keyword">import</span> java.util.Arrays;
<span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">AlgorithmExample</span> </span>{
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
        <span class="hljs-comment">// 待排序数组</span>
        <span class="hljs-keyword">int</span>[] nums = {<span class="hljs-number">33</span>, <span class="hljs-number">45</span>, <span class="hljs-number">11</span>, <span class="hljs-number">22</span>, <span class="hljs-number">12</span>, <span class="hljs-number">39</span>, <span class="hljs-number">27</span>};
        bubbleSort(nums);
        <span class="hljs-comment">// 打印排序完数组</span>
        System.out.println(Arrays.toString(nums));
    }
    <span class="hljs-comment">/**
     * 冒泡排序
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">bubbleSort</span><span class="hljs-params">(<span class="hljs-keyword">int</span>[] nums)</span> </span>{
        <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> i = <span class="hljs-number">1</span>; i &lt; nums.length; i++) {
            <span class="hljs-comment">// 判断标识</span>
            <span class="hljs-keyword">boolean</span> flag = <span class="hljs-keyword">true</span>;
            <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> j = <span class="hljs-number">0</span>; j &lt; nums.length - i; j++) {
                <span class="hljs-keyword">if</span> (nums[j] &gt; nums[j + <span class="hljs-number">1</span>]) {
                    <span class="hljs-comment">// 前面数字大于后面的数字，执行位置交换</span>
                    <span class="hljs-keyword">int</span> temp = nums[j];
                    nums[j] = nums[j + <span class="hljs-number">1</span>];
                    nums[j + <span class="hljs-number">1</span>] = temp;
                    <span class="hljs-comment">// 执行了位置交换，更改标识</span>
                    flag = <span class="hljs-keyword">false</span>;
                }
            }
            <span class="hljs-keyword">if</span> (flag) {
                <span class="hljs-comment">// 没有可以移动的元素了，跳出循环</span>
                <span class="hljs-keyword">break</span>;
            }
        }
    }
}
</code></pre>
<p data-nodeid="43">以上程序的执行结果为：</p>
<pre class="lang-java" data-nodeid="44"><code data-language="java">[<span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">22</span>, <span class="hljs-number">27</span>, <span class="hljs-number">33</span>, <span class="hljs-number">39</span>, <span class="hljs-number">45</span>]
</code></pre>
<p data-nodeid="45">此结果说明，冒泡排序的执行符合我们的预期，执行成功。</p>
<h4 data-nodeid="4990" class="">插入排序</h4>

<p data-nodeid="5552">插入排序（Insertion Sort）算法是指依次循环当前的列表，通过对比将每个元素插入到合适的位置，它的具体执行过程，如下图所示：</p>
<p data-nodeid="5553" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/BA/CgqCHl7sZS-ACg-PAAdMJPx9y3w961.gif" alt="6.gif" data-nodeid="5557"></p>


<p data-nodeid="49">插入算法的具体实现代码如下：</p>
<pre class="lang-java" data-nodeid="50"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">AlgorithmExample</span> </span>{
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
        <span class="hljs-keyword">int</span>[] insertNums = {<span class="hljs-number">4</span>, <span class="hljs-number">33</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">8</span>};
        <span class="hljs-comment">// 插入排序调用</span>
        insertSort(insertNums);
        System.out.println(<span class="hljs-string">"插入排序后："</span> + Arrays.toString(insertNums));
    }
    <span class="hljs-comment">/**
     * 插入排序
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">insertSort</span><span class="hljs-params">(<span class="hljs-keyword">int</span>[] nums)</span> </span>{
        <span class="hljs-keyword">int</span> i, j, k;
        <span class="hljs-keyword">for</span> (i = <span class="hljs-number">1</span>; i &lt; nums.length; i++) {
            k = nums[i];
            j = i - <span class="hljs-number">1</span>;
            <span class="hljs-comment">// 对 i 之前的数据，给当前元素找到合适的位置</span>
            <span class="hljs-keyword">while</span> (j &gt;= <span class="hljs-number">0</span> &amp;&amp; k &lt; nums[j]) {
                nums[j + <span class="hljs-number">1</span>] = nums[j];
                <span class="hljs-comment">// j-- 继续往前寻找</span>
                j--;
            }
            nums[j + <span class="hljs-number">1</span>] = k;
        }
    }
}
</code></pre>
<p data-nodeid="51">以上程序的执行结果为：</p>
<blockquote data-nodeid="52">
<p data-nodeid="53">插入排序后：[4, 8, 10, 13, 20, 33, 49]</p>
</blockquote>
<h4 data-nodeid="5842" class="">选择排序</h4>

<p data-nodeid="6404">选择排序（Selection Sort）算法是指依次循环数组，每轮找出最小的值放到数组的最前面，直到循环结束就能得到一个有序数组，它的执行过程如下图所示：</p>
<p data-nodeid="6405" class=""><img src="https://s0.lgstatic.com/i/image/M00/22/AE/Ciqc1F7sZT-ANau-AAgb92up-Iw047.gif" alt="7.gif" data-nodeid="6409"></p>


<p data-nodeid="57">选择排序的具体实现代码如下：</p>
<pre class="lang-java" data-nodeid="58"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">AlgorithmExample</span> </span>{
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">main</span><span class="hljs-params">(String[] args)</span> </span>{
        <span class="hljs-keyword">int</span>[] insertNums = {<span class="hljs-number">4</span>, <span class="hljs-number">33</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">8</span>};
        <span class="hljs-comment">// 调用选择排序</span>
        selectSort(insertNums);
        System.out.println(<span class="hljs-string">"选择排序后结果："</span> + Arrays.toString(insertNums));
    }
    <span class="hljs-comment">/**
     * 选择排序
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">selectSort</span><span class="hljs-params">(<span class="hljs-keyword">int</span>[] nums)</span> </span>{
        <span class="hljs-keyword">int</span> index;
        <span class="hljs-keyword">int</span> temp;
        <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> i = <span class="hljs-number">0</span>; i &lt; nums.length - <span class="hljs-number">1</span>; i++) {
            index = i;
            <span class="hljs-keyword">for</span> (<span class="hljs-keyword">int</span> j = i + <span class="hljs-number">1</span>; j &lt; nums.length; j++) {
                <span class="hljs-keyword">if</span> (nums[j] &lt; nums[index]) {
                    index = j;
                }
            }
            <span class="hljs-keyword">if</span> (index != i) {
                temp = nums[i];
                nums[i] = nums[index];
                nums[index] = temp;
            }
            System.out.print(<span class="hljs-string">"第"</span> + i + <span class="hljs-string">"次排序："</span>);
            System.out.println(Arrays.toString(nums));
        }
    }
}
</code></pre>
<p data-nodeid="59">以上程序的执行结果为：</p>
<pre class="lang-java" data-nodeid="60"><code data-language="java">第<span class="hljs-number">0</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">33</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">8</span>]
第<span class="hljs-number">1</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">33</span>]
第<span class="hljs-number">2</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">33</span>]
第<span class="hljs-number">3</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">49</span>, <span class="hljs-number">20</span>, <span class="hljs-number">33</span>]
第<span class="hljs-number">4</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>, <span class="hljs-number">49</span>, <span class="hljs-number">33</span>]
第<span class="hljs-number">5</span>次排序：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>, <span class="hljs-number">33</span>, <span class="hljs-number">49</span>]
选择排序后结果：[<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">10</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>, <span class="hljs-number">33</span>, <span class="hljs-number">49</span>]
</code></pre>
<h3 data-nodeid="6694" class="">小结</h3>

<p data-nodeid="7826" class="te-preview-highlight">本着将一个知识点吃透的原则，本课时我们总共介绍了四种算法：冒泡排序算法、二分法、插入排序算法、选择排序算法等，并且还讲了冒泡排序算法的优化。但由于篇幅的原因，这些只能介绍一些常用的算法，如果想要更加深入地学习算法，还需要你投入更多的时间来学习，推荐阅读《算法》（第 4 版）的内容。</p>

---

### 精选评论

##### **财：
> 基础算法讲的透彻

##### *阁：
> 老师，冒泡排序和选择排序有什么区别？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 可以看下这篇文章的动图展示效果：https://zhuanlan.zhihu.com/p/130937981，二者最主要的区别是交换成本不同，冒泡排序一轮可能会交换 N 次，而选择排序每轮之后交换一次。

##### **鑫：
> 给力

##### **波：
> 可以，学到了不少算法思想！

