<p data-nodeid="34974" class="">幂等性问题是面试中常见的面试问题，也是分布式系统最常遇到的问题之一。在说幂等性之前，我们先来看一种情况，假如老王在某电商平台进行购物，付款的时候不小心手抖了一下，连续点击了两次支付，但此时服务器没做任何验证，于是老王账户里面的钱被扣了两次，这显然对当事人造成了一定的经济损失，并且还会让用户丧失对平台的信任。而<strong data-nodeid="35081">幂等性问题</strong>说的就是如何防止接口的重复无效请求。</p>
<p data-nodeid="34975">我们本课时的面试题是，什么是幂等性？如何保证接口的幂等性？</p>
<h3 data-nodeid="34976">典型回答</h3>
<p data-nodeid="34977">幂等性最早是数学里面的一个概念，后来被用于计算机领域，用于表示任意多次请求均与一次请求执行的结果相同，也就是说对于一个接口而言，无论调用了多少次，最终得到的结果都是一样的。比如以下代码：</p>
<pre class="lang-java" data-nodeid="34978"><code data-language="java"><span class="hljs-keyword">public</span> <span class="hljs-class"><span class="hljs-keyword">class</span> <span class="hljs-title">IdempotentExample</span> </span>{
    <span class="hljs-comment">// 变量</span>
    <span class="hljs-keyword">private</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">int</span> count = <span class="hljs-number">0</span>;
    <span class="hljs-comment">/**
     * 非幂等性方法
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">addCount</span><span class="hljs-params">()</span> </span>{
        count++;
    }
    <span class="hljs-comment">/**
     * 幂等性方法
     */</span>
    <span class="hljs-function"><span class="hljs-keyword">public</span> <span class="hljs-keyword">static</span> <span class="hljs-keyword">void</span> <span class="hljs-title">printCount</span><span class="hljs-params">()</span> </span>{
        System.out.println(count);
    }
}
</code></pre>
<p data-nodeid="34979">对于变量 count 来说，如果重复调用 addCount() 方法的话，会一直累加 count 的值，因为 addCount() 方法就是非幂等性方法；而 printCount() 方法只是用来打印控制台信息的。因此，它无论调用多少次结果都是一样的，所以它是幂等性方法。</p>
<p data-nodeid="34980">知道了幂等性的概念，那如何保证幂等性呢？</p>
<p data-nodeid="34981">幂等性的实现方案通常分为以下几类：</p>
<ul data-nodeid="34982">
<li data-nodeid="34983">
<p data-nodeid="34984">前端拦截</p>
</li>
<li data-nodeid="34985">
<p data-nodeid="34986">使用数据库实现幂等性</p>
</li>
<li data-nodeid="34987">
<p data-nodeid="34988">使用 JVM 锁实现幂等性</p>
</li>
<li data-nodeid="34989">
<p data-nodeid="34990">使用分布式锁实现幂等性</p>
</li>
</ul>
<p data-nodeid="34991">下面我们分别来看它们的具体实现过程。</p>
<h4 data-nodeid="34992">1. 前端拦截</h4>
<p data-nodeid="34993">前端拦截是指通过 Web 站点的页面进行请求拦截，比如在用户点击完“提交”按钮后，我们可以把按钮设置为不可用或者隐藏状态，避免用户重复点击。</p>
<p data-nodeid="34994">执行效果如下图所示：</p>
<p data-nodeid="34995"><img src="https://s0.lgstatic.com/i/image/M00/26/CC/CgqCHl7y9-yAHTg2AAICT3yhluA522.gif" alt="11111111111111111111.gif" data-nodeid="35100"><br>
按钮点击效果图</p>
<p data-nodeid="34996">核心的实现代码如下：</p>
<pre class="lang-xml" data-nodeid="34997"><code data-language="xml"><span class="hljs-tag">&lt;<span class="hljs-name">script</span>&gt;</span><span class="javascript">
    <span class="hljs-function"><span class="hljs-keyword">function</span> <span class="hljs-title">subCli</span>(<span class="hljs-params"></span>)</span>{
        <span class="hljs-comment">// 按钮设置为不可用</span>
        <span class="hljs-built_in">document</span>.getElementById(<span class="hljs-string">"btn_sub"</span>).disabled=<span class="hljs-string">"disabled"</span>;
        <span class="hljs-built_in">document</span>.getElementById(<span class="hljs-string">"dv1"</span>).innerText = <span class="hljs-string">"按钮被点击了~"</span>;
    }
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>
<span class="hljs-tag">&lt;<span class="hljs-name">body</span> <span class="hljs-attr">style</span>=<span class="hljs-string">"margin-top: 100px;margin-left: 100px;"</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">input</span> <span class="hljs-attr">id</span>=<span class="hljs-string">"btn_sub"</span> <span class="hljs-attr">type</span>=<span class="hljs-string">"button"</span>  <span class="hljs-attr">value</span>=<span class="hljs-string">" 提 交 "</span>  <span class="hljs-attr">onclick</span>=<span class="hljs-string">"subCli()"</span>&gt;</span>
    <span class="hljs-tag">&lt;<span class="hljs-name">div</span> <span class="hljs-attr">id</span>=<span class="hljs-string">"dv1"</span> <span class="hljs-attr">style</span>=<span class="hljs-string">"margin-top: 80px;"</span>&gt;</span><span class="hljs-tag">&lt;/<span class="hljs-name">div</span>&gt;</span>
<span class="hljs-tag">&lt;/<span class="hljs-name">body</span>&gt;</span>
</code></pre>
<p data-nodeid="34998">但前端拦截有一个致命的问题，如果是懂行的程序员或者黑客可以直接绕过页面的 JS 执行，直接模拟请求后端的接口，这样的话，我们前端的这些拦截就不能生效了。因此除了前端拦截一部分正常的误操作之外，后端的验证必不可少。</p>
<h4 data-nodeid="34999">2. 数据库实现</h4>
<p data-nodeid="35000">数据库实现幂等性的方案有三个：</p>
<ul data-nodeid="35001">
<li data-nodeid="35002">
<p data-nodeid="35003">通过悲观锁来实现幂等性</p>
</li>
<li data-nodeid="35004">
<p data-nodeid="35005">通过唯一索引来实现幂等性</p>
</li>
<li data-nodeid="35006">
<p data-nodeid="35007">通过乐观锁来实现幂等性</p>
</li>
</ul>
<h4 data-nodeid="35008">3. JVM 锁实现</h4>
<p data-nodeid="36234">JVM 锁实现是指通过 JVM 提供的内置锁如 Lock 或者是 synchronized 来实现幂等性。使用 JVM 锁来实现幂等性的一般流程为：首先通过 Lock 对代码段进行加锁操作，然后再判断此订单是否已经被处理过，如果未处理则开启事务执行订单处理，处理完成之后提交事务并释放锁，执行流程如下图所示：</p>
<p data-nodeid="36235" class=""><img src="https://s0.lgstatic.com/i/image/M00/26/CF/CgqCHl7y-zKACO1KAADpJreXpQQ297.png" alt="2.png" data-nodeid="36239"><br>
JVM 锁执行流程图</p>



<p data-nodeid="35011">JVM 锁存在的最大问题在于，它只能应用于单机环境，因为 Lock 本身为单机锁，所以它就不适应于分布式多机环境。</p>
<h4 data-nodeid="35012">4. 分布式锁实现</h4>
<p data-nodeid="37080">分布式锁实现幂等性的逻辑是，在每次执行方法之前先判断是否可以获取到分布式锁，如果可以，则表示为第一次执行方法，否则直接舍弃请求即可，执行流程如下图所示：</p>
<p data-nodeid="37081" class="te-preview-highlight"><img src="https://s0.lgstatic.com/i/image/M00/26/C3/Ciqc1F7y-z6AVFbTAAB5lCnzVDg343.png" alt="1.png" data-nodeid="37085"><br>
分布式锁执行流程图</p>



<p data-nodeid="35015">需要注意的是分布式锁的 key 必须为业务的唯一标识，我们通常使用 Redis 或者 ZooKeeper 来实现分布式锁；如果使用 Redis 的话，则用 set 命令来创建和获取分布式锁，执行示例如下：</p>
<pre class="lang-powershell" data-nodeid="35016"><code data-language="powershell"><span class="hljs-number">127.0</span>.<span class="hljs-number">0.1</span>:<span class="hljs-number">6379</span>&gt; <span class="hljs-built_in">set</span> lock true ex <span class="hljs-number">30</span> nx
OK <span class="hljs-comment"># 创建锁成功</span>
</code></pre>
<p data-nodeid="35017">其中，ex 是用来设置超时时间的；而 nx 是 not exists 的意思，用来判断键是否存在。如果返回的结果为“OK”，则表示创建锁成功，否则表示重复请求，应该舍弃。更多关于 Reids 实现分布式的内容可以查看第 20 课时的内容。</p>
<h3 data-nodeid="35018">考点分析</h3>
<p data-nodeid="35019">幂等性问题看似“高大上”其实说白了就是如何避免重复请求提交的问题，出于安全性的考虑，我们必须在前后端都进行幂等性验证，同时幂等性问题在日常工作中又特别常见，解决的方案也有很多，但考虑到分布式系统情况，我们应该优先使用分布式锁来实现。</p>
<p data-nodeid="35020">和此知识点相关的面试题还有以下这些：</p>
<ul data-nodeid="35021">
<li data-nodeid="35022">
<p data-nodeid="35023">幂等性需要注意什么问题？</p>
</li>
<li data-nodeid="35024">
<p data-nodeid="35025">实现幂等性的关键步骤有哪些？</p>
</li>
<li data-nodeid="35026">
<p data-nodeid="35027">说一说数据库实现幂等性的执行细节？</p>
</li>
</ul>
<h3 data-nodeid="35028">知识扩展</h3>
<h4 data-nodeid="35029">1. 幂等性注意事项</h4>
<p data-nodeid="35030">幂等性的实现与判断需要消耗一定的资源，因此不应该给每个接口都增加幂等性判断，要根据实际的业务情况和操作类型来进行区分。例如，我们在进行查询操作和删除操作时就无须进行幂等性判断。查询操作查一次和查多次的结果都是一致的，因此我们无须进行幂等性判断。删除操作也是一样，删除一次和删除多次都是把相关的数据进行删除（这里的删除指的是条件删除而不是删除所有数据），因此也无须进行幂等性判断。</p>
<h4 data-nodeid="35031">2. 幂等性的关键步骤</h4>
<p data-nodeid="35032">实现幂等性的关键步骤分为以下三个：</p>
<ul data-nodeid="35033">
<li data-nodeid="35034">
<p data-nodeid="35035">每个请求操作必须有唯一的 ID，而这个 ID 就是用来表示此业务是否被执行过的关键凭证，例如，订单支付业务的请求，就要使用订单的 ID 作为幂等性验证的 Key；</p>
</li>
<li data-nodeid="35036">
<p data-nodeid="35037">每次执行业务之前必须要先判断此业务是否已经被处理过；</p>
</li>
<li data-nodeid="35038">
<p data-nodeid="35039">第一次业务处理完成之后，要把此业务处理的状态进行保存，比如存储到 Redis 中或者是数据库中，这样才能防止业务被重复处理。</p>
</li>
</ul>
<h4 data-nodeid="35040">3. 数据库实现幂等性</h4>
<p data-nodeid="35041">使用数据库实现幂等性的方法有三种：</p>
<ul data-nodeid="35042">
<li data-nodeid="35043">
<p data-nodeid="35044">通过悲观锁来实现幂等性</p>
</li>
<li data-nodeid="35045">
<p data-nodeid="35046">通过唯一索引来实现幂等性</p>
</li>
<li data-nodeid="35047">
<p data-nodeid="35048">通过乐观锁来实现幂等性</p>
</li>
</ul>
<p data-nodeid="35049">接下来我们分别来看这些实现方式的具体执行过程。</p>
<p data-nodeid="35050"><strong data-nodeid="35162">① 悲观锁</strong></p>
<p data-nodeid="35051">使用悲观锁实现幂等性，一般是配合事务一起来实现，在没有使用悲观锁时，我们通常的执行过程是这样的，首先来判断数据的状态，执行 SQL 如下：</p>
<pre class="lang-sql" data-nodeid="35052"><code data-language="sql"><span class="hljs-keyword">select</span> <span class="hljs-keyword">status</span> <span class="hljs-keyword">from</span> table_name <span class="hljs-keyword">where</span> <span class="hljs-keyword">id</span>=<span class="hljs-string">'xxx'</span>;
</code></pre>
<p data-nodeid="35053">然后再进行添加操作：</p>
<pre class="lang-sql" data-nodeid="35054"><code data-language="sql"><span class="hljs-keyword">insert</span> <span class="hljs-keyword">into</span> table_name (<span class="hljs-keyword">id</span>) <span class="hljs-keyword">values</span> (<span class="hljs-string">'xxx'</span>);
</code></pre>
<p data-nodeid="35055">最后再进行状态的修改：</p>
<pre class="lang-sql" data-nodeid="35056"><code data-language="sql"><span class="hljs-keyword">update</span> table_name <span class="hljs-keyword">set</span> <span class="hljs-keyword">status</span>=<span class="hljs-string">'xxx'</span>;
</code></pre>
<p data-nodeid="35057">但这种情况因为是非原子操作，所以在高并发环境下可能会造成一个业务被执行两次的问题，当一个程序在执行中时，而另一个程序也开始状态判断的操作。因为第一个程序还未来得及更改状态，所以第二个程序也能执行成功，这就导致一个业务被执行了两次。</p>
<p data-nodeid="35058">在这种情况下我们就可以使用悲观锁来避免问题的产生，实现 SQL 如下所示：</p>
<pre class="lang-sql" data-nodeid="35059"><code data-language="sql"><span class="hljs-keyword">begin</span>;  <span class="hljs-comment"># 1.开始事务</span>
<span class="hljs-keyword">select</span> * <span class="hljs-keyword">from</span> table_name <span class="hljs-keyword">where</span> <span class="hljs-keyword">id</span>=<span class="hljs-string">'xxx'</span> <span class="hljs-keyword">for</span> <span class="hljs-keyword">update</span>; <span class="hljs-comment"># 2.查询状态</span>
<span class="hljs-keyword">insert</span> <span class="hljs-keyword">into</span> table_name (<span class="hljs-keyword">id</span>) <span class="hljs-keyword">values</span> (<span class="hljs-string">'xxx'</span>); <span class="hljs-comment"># 3.添加操作</span>
<span class="hljs-keyword">update</span> table_name <span class="hljs-keyword">set</span> <span class="hljs-keyword">status</span>=<span class="hljs-string">'xxx'</span>; <span class="hljs-comment"># 4.更改操作</span>
<span class="hljs-keyword">commit</span>; <span class="hljs-comment"># 5.提交事务</span>
</code></pre>
<p data-nodeid="35060">在实现的过程中需要注意以下两个问题：</p>
<ul data-nodeid="35061">
<li data-nodeid="35062">
<p data-nodeid="35063">如果使用的是 MySQL 数据库，必须选用 innodb 存储引擎，因为 innodb 支持事务；</p>
</li>
<li data-nodeid="35064">
<p data-nodeid="35065">id 字段一定要是主键或者是唯一索引，不然会锁表，影响其他业务执行。</p>
</li>
</ul>
<p data-nodeid="35066"><strong data-nodeid="35174">② 唯一索引</strong></p>
<p data-nodeid="35067">我们可以创建一个唯一索引的表来实现幂等性，在每次执行业务之前，先执行插入操作，因为唯一字段就是业务的 ID，因此如果重复插入的话会触发唯一约束而导致插入失败。在这种情况下（插入失败）我们就可以判定它为重复提交的请求。</p>
<p data-nodeid="35068">唯一索引表的创建示例如下：</p>
<pre class="lang-sql" data-nodeid="35069"><code data-language="sql"><span class="hljs-keyword">CREATE</span> <span class="hljs-keyword">TABLE</span> <span class="hljs-string">`table_name`</span> (
&nbsp; <span class="hljs-string">`id`</span> <span class="hljs-built_in">int</span> <span class="hljs-keyword">NOT</span> <span class="hljs-literal">NULL</span> AUTO_INCREMENT,
&nbsp; <span class="hljs-string">`orderid`</span> <span class="hljs-built_in">varchar</span>(<span class="hljs-number">32</span>) <span class="hljs-keyword">NOT</span> <span class="hljs-literal">NULL</span> <span class="hljs-keyword">DEFAULT</span> <span class="hljs-string">''</span> <span class="hljs-keyword">COMMENT</span> <span class="hljs-string">'唯一id'</span>,
&nbsp; PRIMARY <span class="hljs-keyword">KEY</span> (<span class="hljs-string">`id`</span>),
&nbsp; <span class="hljs-keyword">UNIQUE</span> <span class="hljs-keyword">KEY</span> <span class="hljs-string">`uq_orderid`</span> (<span class="hljs-string">`orderid`</span>) <span class="hljs-keyword">COMMENT</span> <span class="hljs-string">'唯一约束'</span>
) <span class="hljs-keyword">ENGINE</span>=<span class="hljs-keyword">InnoDB</span>;
</code></pre>
<p data-nodeid="35070"><strong data-nodeid="35180">③ 乐观锁</strong></p>
<p data-nodeid="35071">乐观锁是指在执行数据操作时（更改或添加）进行加锁操作，其他时间不加锁，因此相比于整个执行过程都加锁的悲观锁来说，它的执行效率要高很多。</p>
<p data-nodeid="35072">乐观锁可以通过版本号来实现，例如以下 SQL：</p>
<pre class="lang-sql" data-nodeid="35073"><code data-language="sql"><span class="hljs-keyword">update</span> table_name <span class="hljs-keyword">set</span> <span class="hljs-keyword">version</span>=<span class="hljs-keyword">version</span>+<span class="hljs-number">1</span> <span class="hljs-keyword">where</span> <span class="hljs-keyword">version</span>=<span class="hljs-number">0</span>;
</code></pre>
<h3 data-nodeid="35074">小结</h3>
<p data-nodeid="35075">幂等性不但可以保证程序正常执行，还可以杜绝一些垃圾数据以及无效请求对系统资源的消耗。本课时我们讲了幂等性的 6 种实现方式，包括前端拦截、数据库悲观锁实现、数据唯一索引实现、数据库乐观锁实现、JVM 锁实现，以及分布式锁的实现等方案，其中前端拦截无法防止懂行的人直接绕过前端进行模拟请求的操作。因此后端一定要实现幂等性处理，推荐的做法是使用分布式锁来实现，这样的解决方案更加通用。</p>

---

### 精选评论

##### **虎：
> 老师讲的真好，谢谢您，辛苦了

##### **彬：
> 生成订单操作怎么保证？每次的订单号本来就是不同的

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 订单号不同就说明不是重复提交，只需要处理订单号相同的请求即可。

##### *磊：
> 本质上来说还是用业务来判断，和锁有什么关系呢？是不是说锁只是保证每次执行的原子性

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 这相当于用唯一锁的概念来实现了幂等性的业务。

##### *阁：
> 数据库乐观锁的方式没看懂，通过版本号怎么就实现了幂等性呢？

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 建议整体看下正文，通过版本号可以实现乐观锁；通过加锁来解决幂等性问题。

##### **伟：
> redis天然支持幂等性，key的过期时间怎么设置比较合理

##### **华：
> 老师，删除也是需要考虑幂等性的吧，删除一次和多次删除都是把数据删除。(注意可能返回结果不一样，删除的数据不存在，返回0，删除的数据多条，返回结果多个,在不考虑返回结果的情况下,删除操作也是具有幂等性的)

 ###### &nbsp;&nbsp;&nbsp; 讲师回复：
> &nbsp;&nbsp;&nbsp; 一般来说对于大多数删除操作是无需关注幂等性的，因为通常我们删除不会删除一批数据，而是删除一条数据，比如 id = 10 的数据，那么无论调用多少，最终的结果都是删除了一条 id 为 10 的数据，因此删除通常情况下是无需考虑幂等性问题的，当然也有特殊的情况下，因此我们需要结合具体的业务场景来看。

