/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.internal.mylyn.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.internal.mylyn.ui.Messages;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class CommitHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final Pattern PATTERN_COMMIT_ID = Pattern.compile("(?<!\\w)([0-9a-f]{8}([0-9a-f]{32})?)");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int index;
        String content;
        int contentOffset;
        IDocument document = textViewer.getDocument();
        if (document == null || document.getLength() == 0) {
            return null;
        }
        try {
            if (region.getLength() == 0) {
                int regionLength;
                IRegion lineInfo = document.getLineInformationOfOffset(region.getOffset());
                int lineLength = lineInfo.getLength();
                int lineOffset = lineInfo.getOffset();
                int lineEnd = lineOffset + lineLength;
                int regionEnd = region.getOffset() + region.getLength();
                if (lineOffset < region.getOffset()) {
                    regionLength = Math.max(regionEnd, lineEnd) - lineOffset;
                    contentOffset = lineOffset;
                    content = document.get(lineOffset, regionLength);
                    index = region.getOffset() - lineOffset;
                } else {
                    regionLength = Math.max(regionEnd, lineEnd) - region.getOffset();
                    contentOffset = region.getOffset();
                    content = document.get(contentOffset, regionLength);
                    index = 0;
                }
            } else {
                content = document.get(region.getOffset(), region.getLength());
                contentOffset = region.getOffset();
                index = -1;
            }
        }
        catch (BadLocationException ex) {
            return null;
        }
        List<IHyperlink> hyperlinks = this.detectHyperlinks(textViewer, content, index, contentOffset);
        if (hyperlinks == null) {
            return null;
        }
        if (region.getLength() == 0) {
            Iterator<IHyperlink> it = hyperlinks.iterator();
            while (it.hasNext()) {
                IHyperlink hyperlink = it.next();
                IRegion hyperlinkRegion = hyperlink.getHyperlinkRegion();
                if (this.isInRegion(region, hyperlinkRegion)) continue;
                it.remove();
            }
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private List<IHyperlink> detectHyperlinks(ITextViewer textViewer, String content, int index, int contentOffset) {
        Shell shell = textViewer.getTextWidget().getShell();
        ArrayList<CommitHyperlink> links = null;
        Matcher matcher = PATTERN_COMMIT_ID.matcher(content);
        while (matcher.find()) {
            if (index != -1 && (index < matcher.start() || index > matcher.end())) continue;
            if (links == null) {
                links = new ArrayList<CommitHyperlink>();
            }
            int start = matcher.start(1);
            Region region = new Region(contentOffset + start, matcher.end(1) - start);
            CommitHyperlink hyperlink = new CommitHyperlink((IRegion)region, matcher.group(1), shell);
            links.add(hyperlink);
        }
        return links;
    }

    private boolean isInRegion(IRegion detectInRegion, IRegion hyperlinkRegion) {
        return detectInRegion.getOffset() >= hyperlinkRegion.getOffset() && detectInRegion.getOffset() <= hyperlinkRegion.getOffset() + hyperlinkRegion.getLength();
    }

    private static class CommitHyperlink
    implements IHyperlink {
        private IRegion region;
        private String objectId;
        private final Shell shell;

        public CommitHyperlink(IRegion region, String objectId, Shell shell) {
            this.shell = shell;
            Assert.isNotNull((Object)objectId);
            Assert.isNotNull((Object)region);
            Assert.isNotNull((Object)shell);
            this.region = region;
            this.objectId = objectId;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.objectId;
        }

        public void open() {
            try {
                RepositoryCommit commit = this.searchCommit();
                if (commit != null) {
                    CommitEditor.openQuiet((RepositoryCommit)commit);
                } else {
                    this.informCommitNotFound();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void informCommitNotFound() {
            MessageDialog.openWarning((Shell)this.shell, (String)Messages.CommitHyperlinkDetector_CommitNotFound, (String)NLS.bind((String)Messages.CommitHyperlinkDetector_CommitNotFoundInRepositories, (Object)this.objectId));
        }

        private RepositoryCommit searchCommit() throws IOException {
            RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
            List configuredRepositories = repositoryUtil.getConfiguredRepositories();
            RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
            for (String repoDir : configuredRepositories) {
                Repository repository = repositoryCache.lookupRepository(new File(repoDir));
                RevCommit commit = this.getCommit(repository);
                if (commit == null) continue;
                return new RepositoryCommit(repository, commit);
            }
            return null;
        }

        private RevCommit getCommit(Repository repository) throws IOException {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (RevWalk revWalk = new RevWalk(repository);){
                    return revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)this.objectId));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (MissingObjectException e) {
                return null;
            }
            catch (IncorrectObjectTypeException e) {
                return null;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CommitHyperlink [region=");
            builder.append(this.region);
            builder.append(", objectId=");
            builder.append(this.objectId);
            builder.append("]");
            return builder.toString();
        }
    }
}

