/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ExtendedDialogWindow
extends TrayDialog
implements IRunnableContext {
    private Control fContents;
    private Button fCancelButton;
    private List<Button> fActionButtons = new ArrayList<Button>();
    private long fActiveRunningOperations;
    private boolean fUseEmbeddedProgressMonitorPart;
    private ProgressMonitorPart fProgressMonitorPart;
    private MessageDialog fWindowClosingDialog;
    private static final String FOCUS_CONTROL = "focusControl";

    public ExtendedDialogWindow(Shell shell) {
        super(shell);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setUseEmbeddedProgressMonitorPart(boolean enable) {
        this.fUseEmbeddedProgressMonitorPart = enable;
    }

    protected boolean performAction(int buttonId) {
        return true;
    }

    protected boolean performCancel() {
        return true;
    }

    protected abstract Control createPageArea(Composite var1);

    protected void createButtonsForButtonBar(Composite parent) {
        this.fCancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Button createActionButton(Composite parent, int id, String label, boolean defaultButton) {
        Button actionButton = this.createButton(parent, id, label, defaultButton);
        this.fActionButtons.add(actionButton);
        return actionButton;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.fContents = this.createPageArea(result);
        this.fContents.setLayoutData((Object)new GridData(1808));
        if (this.fUseEmbeddedProgressMonitorPart) {
            this.fProgressMonitorPart = new ProgressMonitorPart(result, (Layout)new GridLayout(), -1);
            this.fProgressMonitorPart.setLayoutData((Object)new GridData(768));
            this.fProgressMonitorPart.setVisible(false);
            ExtendedDialogWindow.applyDialogFont((Control)this.fProgressMonitorPart);
        }
        Label separator = new Label(result, 258);
        separator.setLayoutData((Object)new GridData(768));
        return result;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                if (this.fActiveRunningOperations != 0L) break;
                this.close();
                break;
            }
            default: {
                if (!this.performAction(buttonId)) break;
                this.close();
            }
        }
    }

    public void setPerformActionEnabled(boolean state) {
        for (Button element : this.fActionButtons) {
            element.setEnabled(state);
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        try {
            ++this.fActiveRunningOperations;
            state = this.aboutToStart(fork && cancelable);
            if (this.fUseEmbeddedProgressMonitorPart) {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
            } else {
                new ProgressMonitorDialog(this.getShell()).run(fork, cancelable, runnable);
            }
        }
        catch (Throwable throwable) {
            if (state != null) {
                this.stopped(state);
            }
            --this.fActiveRunningOperations;
            throw throwable;
        }
        if (state != null) {
            this.stopped(state);
        }
        --this.fActiveRunningOperations;
    }

    protected synchronized Object aboutToStart(boolean enableCancelButton) {
        HashMap<Object, Object> savedState = null;
        Shell shell = this.getShell();
        if (shell != null) {
            Display d = shell.getDisplay();
            Control focusControl = d.getFocusControl();
            if (focusControl != null && focusControl.getShell() != shell) {
                focusControl = null;
            }
            this.setDisplayCursor(d, d.getSystemCursor(1));
            this.fCancelButton.setCursor(d.getSystemCursor(0));
            savedState = this.saveUIState(enableCancelButton);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            if (this.fUseEmbeddedProgressMonitorPart) {
                this.fProgressMonitorPart.attachToCancelComponent((Control)this.fCancelButton);
                this.fProgressMonitorPart.setVisible(true);
            }
        }
        return savedState;
    }

    protected synchronized void stopped(Object savedState) {
        Assert.isTrue((boolean)(savedState instanceof HashMap));
        Shell shell = this.getShell();
        if (shell != null) {
            if (this.fUseEmbeddedProgressMonitorPart) {
                this.fProgressMonitorPart.setVisible(false);
                this.fProgressMonitorPart.removeFromCancelComponent((Control)this.fCancelButton);
            }
            HashMap state = (HashMap)savedState;
            this.restoreUIState(state);
            this.setDisplayCursor(shell.getDisplay(), null);
            this.fCancelButton.setCursor(null);
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null && !focusControl.isDisposed()) {
                focusControl.setFocus();
            }
        }
    }

    private void setDisplayCursor(Display d, Cursor c) {
        Shell[] shells = d.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private void restoreUIState(HashMap<Object, Object> state) {
        this.restoreEnableState((Control)this.fCancelButton, state);
        for (Button button : this.fActionButtons) {
            this.restoreEnableState((Control)button, state);
        }
        ControlEnableState pageState = (ControlEnableState)state.get("tabForm");
        pageState.restore();
    }

    protected void restoreEnableState(Control w, HashMap<Object, Object> h) {
        Boolean b;
        if (!w.isDisposed() && (b = (Boolean)h.get(w)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private HashMap<Object, Object> saveUIState(boolean keepCancelEnabled) {
        HashMap<Object, Object> savedState = new HashMap<Object, Object>(10);
        this.saveEnableStateAndSet((Control)this.fCancelButton, savedState, keepCancelEnabled);
        for (Button button : this.fActionButtons) {
            this.saveEnableStateAndSet((Control)button, savedState, false);
        }
        savedState.put("tabForm", ControlEnableState.disable((Control)this.fContents));
        return savedState;
    }

    private void saveEnableStateAndSet(Control w, HashMap<Object, Object> h, boolean enabled) {
        if (!w.isDisposed()) {
            h.put(w, w.isEnabled());
            w.setEnabled(enabled);
        }
    }

    protected void handleShellCloseEvent() {
        if (this.okToClose()) {
            super.handleShellCloseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean okToClose() {
        if (this.fActiveRunningOperations > 0L) {
            ExtendedDialogWindow extendedDialogWindow = this;
            synchronized (extendedDialogWindow) {
                this.fWindowClosingDialog = this.createClosingDialog();
            }
            this.fWindowClosingDialog.open();
            extendedDialogWindow = this;
            synchronized (extendedDialogWindow) {
                this.fWindowClosingDialog = null;
            }
            return false;
        }
        return true;
    }

    private MessageDialog createClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), SearchMessages.SearchDialogClosingDialog_title, null, SearchMessages.SearchDialogClosingDialog_message, 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    protected Control getCancelComponent() {
        return this.fCancelButton;
    }
}

