/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.op.FeatureCheckoutOperation;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.dialogs.FeatureBranchSelectionDialog;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureCheckoutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return Activator.error(UIText.Handlers_noGitflowRepositoryFound);
        }
        Repository repository = gfRepo.getRepository();
        List refs = gfRepo.getFeatureBranches();
        FeatureBranchSelectionDialog dialog = new FeatureBranchSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), refs, UIText.FeatureCheckoutHandler_selectFeature, UIText.FeatureCheckoutHandler_localFeatures, "refs/heads/" + gfRepo.getConfig().getFeaturePrefix(), gfRepo);
        if (dialog.open() != 0) {
            return null;
        }
        Ref ref = dialog.getSelectedNode();
        try {
            String featureName = gfRepo.getFeatureBranchName(ref);
            FeatureCheckoutOperation checkoutOperation = new FeatureCheckoutOperation(gfRepo, featureName);
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)checkoutOperation, (String)UIText.FeatureCheckoutHandler_checkingOutFeature, (Object)JobFamilies.GITFLOW_FAMILY);
            IJobManager jobMan = Job.getJobManager();
            try {
                jobMan.join(JobFamilies.GITFLOW_FAMILY, null);
            }
            catch (InterruptedException | OperationCanceledException e) {
                return Activator.error(e.getMessage(), e);
            }
            CheckoutResult result = checkoutOperation.getResult();
            if (!CheckoutResult.Status.OK.equals((Object)result.getStatus())) {
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                if (!this.handleUncommittedFiles(gfRepo.getRepository(), shell, repository.getWorkTree().getName())) {
                    return Status.CANCEL_STATUS;
                }
                JobUtil.scheduleUserWorkspaceJob((IEGitOperation)checkoutOperation, (String)UIText.FeatureCheckoutHandler_checkingOutFeature, (Object)JobFamilies.GITFLOW_FAMILY);
            }
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleUncommittedFiles(Repository repo, Shell shell, String repoName) throws GitAPIException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = new Git(repo);){
            org.eclipse.jgit.api.Status status = git.status().call();
            if (status.hasUncommittedChanges()) {
                ArrayList files = new ArrayList(status.getUncommittedChanges());
                Collections.sort(files);
                CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, MessageFormat.format(UIText.FeatureCheckoutHandler_cleanupDialog_title, repoName), UIText.FeatureCheckoutHandler_cleanupDialog_text, repo, files);
                cleanupUncomittedChangesDialog.open();
                return cleanupUncomittedChangesDialog.shouldContinue();
            }
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

