/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ModificationVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.ArrayDeque;

public class TemplateTypeMapReplacer
extends ModificationVisitor {
    private final TemplateTypeMap replacements;
    private ArrayDeque<TemplateType> visitedTypes;

    public TemplateTypeMapReplacer(JSTypeRegistry registry, TemplateTypeMap replacements) {
        super(registry, false);
        this.replacements = replacements;
        this.visitedTypes = new ArrayDeque();
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        if (this.replacements.hasTemplateKey(type)) {
            if (this.hasVisitedType(type) || !this.replacements.hasTemplateType(type)) {
                return type;
            }
            JSType replacement = this.replacements.getUnresolvedOriginalTemplateType(type);
            if (this.isRecursive(type, replacement)) {
                return type;
            }
            this.visitedTypes.push(type);
            JSType visitedReplacement = replacement.visit(this);
            this.visitedTypes.pop();
            return visitedReplacement;
        }
        return type;
    }

    private boolean isRecursive(TemplateType currentType, JSType replacementType) {
        TemplatizedType replacementTemplatizedType = replacementType.restrictByNotNullOrUndefined().toMaybeTemplatizedType();
        if (replacementTemplatizedType == null) {
            return false;
        }
        ImmutableList<JSType> replacementTemplateTypes = replacementTemplatizedType.getTemplateTypes();
        for (JSType replacementTemplateType : replacementTemplateTypes) {
            if (!replacementTemplateType.isTemplateType() || !this.isSameType(currentType, replacementTemplateType.toMaybeTemplateType())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameType(TemplateType currentType, TemplateType replacementType) {
        return currentType == replacementType || currentType == this.replacements.getUnresolvedOriginalTemplateType(replacementType);
    }

    private boolean hasVisitedType(TemplateType type) {
        for (TemplateType visitedType : this.visitedTypes) {
            if (visitedType != type) continue;
            return true;
        }
        return false;
    }
}

