# 沃伦姆德的薄暮 剧情总览

- 文档目的：按关卡/文本顺序，对《沃伦姆德的薄暮》剧情进行结构化要点化总结，便于检索、补充与分析。
- 当前覆盖范围（已处理）：TW-ST-1、TW-1（行动前/后）、TW-2（行动前/后）、TW-3（行动前/后）、TW-4（行动前/后）、TW-5（行动前/后）、TW-6（行动前/后）、TW-7（行动前/后）、TW-8（月光沉沦 行动前/后）、TW-ST-2、TW-S-1（三座巨像 行动后）、TW-S-2（一束哀悼 行动后）

## 目录
- 概述
- 主要角色与阵营（动态更新）
- 时间线总览（至当前进度）
- 分章详述（逐关卡）
  - TW-ST-1 老栎树下
  - TW-1 缄默不言（行动前）
  - TW-1 缄默不言（行动后）
  - TW-2 叛乱前哨（行动前/后）
  - TW-3 高塔烟火（行动前/后）
  - TW-4 复仇之魂（行动前/后）
  - TW-5 冬灵挽歌（行动前/后）
  - TW-6 怒意漫延（行动前/后）
  - TW-7 群峦崩塌（行动前/后）
  - TW-8 月光沉沦（行动前/后）
  - TW-ST-2 余烬之上
  - TW-S-1 三座巨像（行动后）
  - TW-S-2 一束哀悼（行动后）
- 关键设定与物件
- 主题与冲突
- 关系与立场变化
- 伏笔与未解
- 结局状态快照（占位，待完结后汇总）
- 附：关卡要点速查

---

## 概述
沃伦姆德在“偏离航线”与“大裂谷”天灾后陷入半孤立、补给紧张与社会结构紧绷的状态：
1. 内部：镇民（含感染者）就火灾、安葬、资源与秩序产生高度不信任；安托医生失踪形成心理裂痕。
2. 外围：一支身份暧昧的武装感染者（含萨卡兹）潜伏/徘徊，可能借机影响或渗透本地感染者群体。
3. 触发事件：安托建立的临时医疗营地遭火灾后失踪；四具遗体的安置与“感染风险”政治化；罗德岛（亚叶、铃兰）为同伴下落抵达调查。
4. 情绪底色：哀悼被推迟、真相被稀释、权威（塞弗林）自责与功能化，基层感染者情绪被煽动走向激进化的前夜。

## 主要角色与阵营（当前阶段）
- 塞弗林（宪兵/镇上最高长官，丧子后情绪压抑、咳嗽严重，理性与情感拉扯）
- 塔佳娜（塞弗林侄女/辅助角色，传话人；对托尔之死反应“过于平静”——潜在异常点）
- 托尔（已故，塞弗林之子，火灾受害者之一，遗体处理争议核心之一）
- 镇民代表（趋利/保守维稳，担忧外部追责）
- 亚叶（罗德岛干员，安托同学，情绪驱动强→逐渐转理性调查）
- 铃兰（罗德岛见习干员/同伴，调和情绪、提供敏感观察）
- 安托（失踪的罗德岛感染者医生：曾是“英雄”式资源/医疗枢纽）
- 感染者居民（被集中于“十二音街道”，生活表面“正常”但实为半监禁/停摆）
- 叛乱/被煽动镇民（火灾与歧视背景下激化，持械冲突）
- 外围武装感染者团体（含萨卡兹与“武装的感染者队长”，动机：求生/报复/更大图谋未明）
- 大鲍勃（未出现，仅通信缺失；赏金猎人背景→或与外部武装线相关）
- 疑似组织：整合运动（亚叶提出可能性，尚未证实）

## 原作顺序与介绍
1. TW-ST-1 老栎树下:火灾夺走了无辜者的生命，神秘的感染者正伺机待发。亚叶与铃兰两位干员苦苦等待于莱塔尼亚失踪的干员安托的回音，得到的却是当地天灾的消息。
2. TW-1 缄默不言(行动前/后):抵达莱塔尼亚城镇沃伦姆德后，亚叶与铃兰遭遇了当地的宪兵队长塞弗林。然而后者显然有什么隐瞒着罗德岛。交谈之际，城镇中竟然出现了感染者发起了暴乱。在解决了暴乱的感染者后，罗德岛一行得到了沃伦姆德的接待。但各怀心思的隐瞒似乎成为了隔阂，亚叶开始心生疑虑，希望赶紧去寻找干员安托的下落。
3. TW-2 叛乱前哨(行动前/后):在寻访沃伦姆德街道的途中，亚叶询问着当地少女塔佳娜有关安托的事情，但众人却不小心撞入了感染者集会的现场引起了感染者的攻击。潜入沃伦姆德的外来者煽动了叛乱，在罗德岛的帮助下，叛乱暂且平息。消除了双方的隔阂，塔佳娜决定将二人带往安托设立的医疗点进行探查。
4. TW-3 高塔烟火(行动前/后):没想到的是，医疗点不久前被人烧毁，种种表现意味着安托凶多吉少。失落的亚叶想要回去确认安托的遗体，却在这时遭遇了正在进攻城市的泥岩小队的感染者。塞弗林一度想要对感染者痛下杀手，却因为亚叶等人的归来而中断。众人以为可以松一口气的时候，城镇的动力炉却遭到了敌人的破坏。城镇的移动受到了严重的影响，天灾的威胁近在眼前。
5. TW-4 复仇之魂(行动前/后):塞弗林在亚叶的逼问之下，答应带众人去往临时停尸房。在那里，老友得以相见。与此同时，在市民中发现了冬灵人的身影，很有可能他们就是煽动暴乱的真凶。得知安托之死而陷入焦虑的亚叶，被铃兰说服，两人开始为了寻找冬灵人相关的线索东奔西走。与此同时，灰喉等人也遭遇了武装感染者的领袖：整合运动，泥岩。
6. TW-5 冬灵挽歌(行动前/后):落日中的街道忽然回响起歌声，塞弗林认为这是敌人串通的信号而展开搜捕。到底是应该阻止战斗展开救援，还是继续寻找真凶，铃兰和亚叶此时也产生了分歧。为了掩护民众，塔佳娜冒着生命危险冲入暴乱正中。所幸灰喉与断崖及时加入，但暴乱依然在失控边缘。
7. TW-6 怒意漫延(行动前/后):灰喉救出了陷入危机的塔佳娜。亚叶在审问一名叛乱者后得知了沃伦姆德骚乱的部分真相，也得知了“整合运动”的存在。泥岩对事态感到不安，铃兰也遇见了自称“最后一个冬灵人”的老人，灰喉发现线索对不上号。群情激奋，冲突似乎已经难以避免。
8. TW-7 群峦崩塌(行动前/后):铃兰将新的线索分享给众人。在众人思考之际，愤怒的民众擅自包围了十二音街道。同样受到民众威胁的泥岩小队开始向城镇出动，事态进一步恶化。三方在城镇中展开混战，塞弗林因为自身的病症倒下。灰喉找到的嫌疑人也已死去，线索已断，这也动摇了亚叶的内心。泥岩下定了决心，准备展现真正的实力。
9. TW-8 月光沉沦(行动前/后):被烧死的镇民触动了塔佳娜的神经，因为嫌疑人之死感到迷茫的亚叶被迫走上战场。罗德岛面对整合运动的萨卡兹，泥岩小队。苦战以塞弗林的突入终结，塞弗林试图以死平息动乱，却被罗德岛制止。泥岩改变了自己的想法，平息了战斗。
10. TW-ST-2 余烬之上:暴乱结束后，众人意识到真相已经遥不可及。为了城镇的安宁，只能任其深藏。城镇的人们重新团结起来，通过迁移逃离天灾。
11. TW-S-1 三座巨像(行动后):毕德曼看着门外，恐慌的感觉自内心溢出。那不是纵火犯，那只是一个可怕的提案。
12. TW-S-2 一束哀悼(行动后):在火灾现场，亚叶与铃兰遇见了同样前来献花的泥岩。所有人都希望能阻止什么，所有人都没能做到。

## 时间线总览（至当前处理）
1. 【TW-ST-1】火灾后时期：塞弗林与塔佳娜争论遗体安葬；外部武装感染者补给；罗德岛内部（亚叶、铃兰）确认安托失联并决意出发。
2. 【TW-1 行动前】罗德岛抵达；镇内议事厅关于火灾/抗议应对与是否接纳罗德岛的犹豫；感染者抗议升级→罗德岛被卷入。
3. 【TW-1 行动后】冲突平息；塞弗林披露：安托在火灾后“离开/失踪”；外部武装感染者与火灾真相未明；罗德岛获调查自由。
4. 【TW-2 行动前】深入十二音街道：表面宽容/实质停摆与封闭的感染者社区；塔佳娜陪同；人群被萨卡兹身影暗中煽动，冲突临界。
5. 【TW-2 行动后】煽动诉求显性化（物资、解除隔离、火灾真相）；叛乱镇民指控“谋杀”与全面欺骗；罗德岛与塔佳娜建立初步互信，确认现场调查必要性。
6. 【TW-3 行动前】火灾现场勘查：瞬时高温/施术痕迹→意外说被推翻；遗体数量与构成揭示（1非感+7感染者）；泥岩小队初曝光（命名）。
7. 【TW-3 行动后】议事厅防御战与内部权威危机；塞弗林以“谈判-突袭”稳局；动力炉被破坏（潜入/地下通道）；泥岩与其下属双线：克制复仇与聚焦“凶手”。
8. 【TW-4 行动前】饥荒/航线/冬季倒计时→结构性生存危机显性化；谋杀属性被正面交锋；安托等八具遗体冷藏室公开；“留声机”自律施术核心=凶器；亚叶确立“追凶+复仇”动机；冬灵人势力线索出现。
9. 【TW-4 行动后】亚叶童年与母亲复仇缺席回忆→当前复仇心态对照；与铃兰侦查外缘；泥岩与灰喉初次正式对峙（力量落差+克制态度）；泥岩确认人祸判断但拒透露更多；冬灵人词汇在镇内探查中被紧张回避。
10. 【TW-5 行动前】夕照街空+冬灵歌谣法术笼罩→文化/历史层面冲突显性；塞弗林下令搜捕歌者（戒严前奏）；冬灵历史被压缩成“简化冲突”叙述；亚叶与塞弗林在“求援 vs 政治忌惮”上矛盾激化；爆炸/城防装置被夺。
11. 【TW-5 行动后】街区局部战火：自律施术单元被粗暴操控；塔佳娜为救顽固镇民受伤；塞弗林批准罗德岛自由行动（精力耗散）；灰喉、断崖抵达协调救援；叛乱结构化（人质/火力节点）趋势出现。
12. 【TW-6 行动前】塔佳娜获救（灰喉干预）→与亚叶、灰喉、塞弗林“三角”信任重组；叛乱者口供指向：宪兵调离=贵族婚礼荒诞、制度性失能→感染者议题复合阶层怨恨；“整合运动”标签被俘虏主动宣称以争取合法性；作战方针需在“开战/控损”间决策。
13. 【TW-6 行动后】会议上灰喉提出“4（感染者陈述） vs 8（镇方统计）”遗体数矛盾；塞弗林务实回避深挖；群众口号“我们要战斗”形成节奏化情绪放大；老冬灵人自首回顾失败复仇史→“冬灵”成借口；透露毕德曼曾现场指挥破坏动力炉；亚叶复仇情绪被再次触发与压制。
14. 【TW-7 行动前】老冬灵人证言引发“毕德曼或存活”追索；塞弗林补述其被迁怒与安托援助历史；镇民擅自包围十二音街道（指挥权旁落）；泥岩评估继续卷入风险（撤/毁灭两难）；岩石巨像/萨卡兹压迫前兆出现。
15. 【TW-7 行动后】毕德曼尸体被发现（后脑击杀+冻裂痕迹，已死数小时）→ 复仇对象缺位；塞弗林矿石病身份曝露并欲隐瞒，拟“自认纵火”止暴；危机合约文件揭示毕德曼签约天灾信使属性；岩石巨像与萨卡兹逼近，防御失衡加剧。
16. 【TW-8 行动前】最后“留声机”被毁→防线技术资本归零；火势蔓延与民兵指挥链断裂；塔佳娜目睹烧伤触发托尔死亡创伤回闪；铃兰与激进感染者“生存功利 vs 道德底线”争辩；亚叶失去目标感短暂失措→灰喉情绪支点；泥岩决定亲自出手提供“决斗式”收束窗口。
17. 【TW-8 行动后】泥岩以生命代价维持岩石巨像威慑迫使暴徒撤退；萨卡兹战士与激进感染者话语对峙转向“生/死”选择；泥岩共享生命术式（古老巫术）加速自损；暴乱者惧与疲于无序战斗选择撤离；塞弗林与泥岩短暂非敌对交流→泥岩宣布与沃伦姆德切割；巨像瓦解象征“武力极点”后退场。
18. 【TW-ST-2】危机合约极端派“功利-牺牲”逻辑被断崖/灰喉/塞弗林多视角拆解；毕德曼被动卷入的可信度上升（凶手不确定性保留）；塞弗林确认缺乏决定性证据→选择“放下真相优先活下去”；塔佳娜心理弦断裂后缓慢修复；镇内秩序转向“疲惫维持”。
19. 【TW-S-1 行动后】（回溯/补叙）毕德曼与托尔瓦尔德（托尔）早期接触：托尔提出以“可控暴乱”引爆关注逻辑；危机合约平台被滥用的伦理黑区展示；毕德曼在“赎罪/冷漠”间摇摆；核心施术单元获得来源暗示托尔提前布局；“更多生命 vs 直接牺牲”道德计算确立。
20. 【TW-S-2 行动后】余波收束：泥岩为死者献花→与亚叶、灰喉进行“和解/仍为敌人”界面对话；萨卡兹队伍计划撤往卡兹戴尔（流亡归宿）；亚叶接受“无法伸张完全正义”现实性虚无→决定带安托遗体/记忆回罗德岛；“复仇-调查”议程正式转入“善后/迁离”。

## 分章详述（逐关卡）

### TW-ST-1 老栎树下
- 场景：
  - 老栎树下——塞弗林与塔佳娜；火灾后残骸/野草；哀悼与政治决定冲突。
  - 外围武装感染者营地——资源短缺与“等待援助”氛围。
  - 罗德岛通讯室——亚叶焦虑守候，确定前往莱塔尼亚。
- 冲突：是否立即体面下葬（安全防疫 vs 人道尊重）；镇方拖延 vs 亲属情感；武装感染者信任缺失；安托失联危机。
- 发展：塞弗林被迫同意将遗体外埋（延后处理）；外部武装与本地感染者合作但互不信任；罗德岛准备干预。
- 结果：定调“缺席的安托”与“火灾/裂谷”双重创伤；多线悬念（外部武装、大鲍勃、塞弗林健康、遗体处理）建立。
- 对白摘要：
  - 塞弗林拒绝轻易“抛弃”死者，强调他们曾为小镇做出贡献。
  - “他们让你来”折射镇内权力推诿。
  - 武装感染者质疑本地人的动机与“名号”意义。
  - 亚叶对安托 27 天失联表现焦急，确立行动动因。

### TW-1 缄默不言（行动前）
- 场景：议事厅 → 镇街道 → 与塞弗林初遭遇 → 抗议冲突现场。
- 冲突：镇民代表怕追责想信息控制；感染者抗议火灾及死者处理；罗德岛要求透明；塞弗林的“公务 / 私情”分裂。
- 发展：罗德岛被允许进入；塞弗林态度疏离但暗示尊重安托；抗议升级出现“持械”迹象。
- 结果：罗德岛卷入现场治理，为后续信任与调查权铺路。
- 对白摘要：
  - “那在你们决定我儿子命运的时候，我在场吗？” → 塞弗林的哀恸与疏离。
  - 感染者抗议被指“遭煽动”。
  - 塞弗林提醒“不要靠近十二音街道”。
  - 罗德岛自我定位：“感染者问题对策专家”。

### TW-1 缄默不言（行动后）
- 场景：冲突后街区 → 议事厅谈判室。
- 冲突：安托下落披露与“火灾=意外？”的可信度对峙；外部武装感染者成因解释权争夺；是否存在更大组织（整合运动）。
- 发展：塞弗林以“轻描淡写”方式公布失踪事实；亚叶情绪爆发后转向专业判断；取得自由调查许可；塔佳娜被派尾随（监视/保护双重）。
- 结果：调查合法化 + 信任脆弱联盟；新增悬疑：塔佳娜缺悲伤反应；火灾责任与“意外说”遭质疑。
- 对白摘要：
  - “她失踪了。”（塞弗林直接揭示）
  - “真相就是轻浮的。”（价值观与态度）
  - 亚叶提出“整合运动”潜在关联。
  - “我更相信我们自己的判断。”（罗德岛立场）

### TW-2 叛乱前哨（行动前）
- 场景：十二音街道（感染者聚居区）→ 秋千广场前巷道 → 聚集人群外围。
- 冲突：表面宽容（自由行走）与实质禁锢（街区停摆）矛盾；安托被神化后留下权力真空；萨卡兹人物暗中煽动 vs 镇方监控不足。
- 发展：罗德岛观察“停业/荒废”征象推断社区管理失灵；塔佳娜叙述安托贡献；情绪缓和期短暂→ 发现人群集会与萨卡兹身影；局势即将暴力化。
- 结果：确认外部煽动因素存在；下一阶段冲突（行动后）将爆发的铺垫完成。
- 对白摘要：
  - “这条街没有在正常运作。”（亚叶分析）
  - “她被当做感染者们的英雄。”（安托影响力）
  - 铃兰持续情绪调节，防止亚叶失衡。
  - “那是个萨卡兹吗……？”（潜在敌对身份锁定）

### TW-2 叛乱前哨（行动后）
- 场景：街巷对峙 & 被捕闹事者审讯语境；并行视角：塞弗林与代表讨论监控失效与渗透。
- 冲突：诉求公开（物资/解除隔离/火灾真相）；“事故 vs 谋杀”叙事冲突；镇方探测罗德岛立场。
- 发展：煽动组织化被确认；“无人逃出帐篷”证词→否定“安托离开”；罗德岛与塔佳娜互信发芽；塞弗林现实主义立场强化。
- 结果：谋杀概率上升；罗德岛调查授权深一层；情绪性抗议上升为结构性叙事之争。
- 对白摘要：
  - “要求恢复物资供应……撤销隔离……”
  - “那才不是什么事故，那是纵火，是谋杀！”
  - “火灾那一天，根本没有一个人逃出来！”
  - “罗德岛不会抛下你们。”

### TW-3 高塔烟火（行动前）
- 场景：焚毁医疗营地遗址 → 归途中爆炸回声 → 遭遇泥岩小队前锋。
- 冲突：火灾成因技术化（瞬时高温） vs 既定“意外”说；遗体草率处理风险；外部武装身份界定。
- 发展：锁定“源石技艺瞬时高温”机制；确认8遗体构成；安托工作牌遗留；泥岩小队名称首现。
- 结果：谋杀获物证支撑；调查范围扩展至技术/装置来源；外部武装组织化标签明确。
- 对白摘要：
  - “受害者几乎没能离开帐篷……瞬间高温。”
  - “八具遗体……他只是去帮忙。”
  - “这是她的工作牌。”
  - “他们自称——‘泥岩小队’。”

### TW-3 高塔烟火（行动后）
- 场景：议事厅塔楼战线；街区恐慌；地下动力系统破坏；泥岩阵营外部观察。
- 冲突：武装诉求（凶手/成见） vs 当局秩序；动力炉破坏引发迁移危机；“被抛弃”叙事放大。
- 发展：塞弗林“谈判+突袭”保核心；罗德岛救治缓冲激化；地下通道防线被识破；泥岩内部克制 vs 激进辩论。
- 结果：动力炉瘫痪→饥荒时钟加速；塞弗林与罗德岛协作改善；泥岩哲学（限定复仇）浮出。
- 对白摘要：
  - “我要你们交出凶手，我要你们抛弃成见。”
  - “现在呢！？我们只是被关起来等死！”
  - “这里没有宪兵驻扎”秘密扩散。
  - “我们要毁掉的，只是一个凶手……”

### TW-4 复仇之魂（行动前）
- 场景：外围罗德岛增援（灰喉/断崖/卡达）勘察 → 议事厅危机会谈 → 地下冷藏室 → 指挥层再聚 → 冲突再起前兆。
- 冲突：饥荒/冬季/动力瘫痪的系统性生存危机；谋杀公开与政治风险；亚叶“复仇 vs 干员职责”；冬灵人线索提出。
- 发展：凶器 = L-44“留声机”自律施术核心过载；遗体冷藏透明化换取信任；亚叶情绪阶段完成转折（悲痛→行动）；塞弗林健康隐患被铃兰察觉；冬灵人可能为新势力变量。
- 结果：技术调查线确立；罗德岛外-内双层力量成型；多维威胁并发（饥荒/武装/冬灵人/内部信任）。
- 对白摘要：
  - “饥荒会毁了所有人。”
  - “城防法术发生装置……这就是凶器。”
  - “那个人必须接受审判！”
  - “冬灵人……又来纠缠沃伦姆德了。”

### TW-4 复仇之魂（行动后）
- 场景：亚叶童年独白 → 山地外围勘察 → 灰喉小队与泥岩墓祭对峙 → 镇内“冬灵”词汇排斥访谈。
- 冲突：亚叶复仇动机的情绪还原 vs 铃兰劝阻调节；泥岩“限定复仇/克制”理念 vs 灰喉试探性武力；镇民对“冬灵”词回避与寒蝉。
- 发展：泥岩确认火灾系人祸（不指名）；灰喉评估泥岩战力后战略退让；亚叶对“冬灵”线产生追索；镇内情绪层层加压（歌谣/禁忌话题）。
- 结果：外部武装（泥岩）暂不敌对；调查焦点从“凶器”拓展到“历史/族群伤痕”；信息落差（冬灵背景）成为后续议题主轴。
- 对白摘要：
  - “我是来献一束花。”
  - “至少……我可以断定，这是人祸。”
  - “冬灵？你们从哪儿听说这个词的？”
  - “沃伦姆德早就没有冬灵人了。”

### TW-5 冬灵挽歌（行动前）
- 场景：傍晚空街 → 冬灵歌谣回响 → 塞弗林临场指挥与拘捕指令 → 歌声触发的广域心理压迫。
- 冲突：文化/悼念仪式（歌谣） vs 安全/政治恐慌（塞弗林认定信号）；亚叶追问历史真相 vs 塞弗林政治风险守口；铃兰调解失败。
- 发展：冬灵人被定性为“挑拨者/破坏者”；塞弗林权威转向强制（搜捕、戒严）；亚叶愤怒与理性并置；城防装置被叛乱力量夺取升级局势。
- 结果：历史隐患实体化为现实安全事件；“调查凶手”议程被“平息街道”竞争；结构性冲突从潜流跃升公开。
- 对白摘要：
  - “这是冬灵的歌谣，只在古老的祭典和葬礼上出现。”
  - “安托为了帮你们牺牲了！现在还是讲面子的时候吗！？”
  - “沃伦姆德进入戒严状态，让所有民兵集合。”
  - “冬灵人……已经没有了。”

### TW-5 冬灵挽歌（行动后）
- 场景：十二音街道火力区段 → 平民疏散走廊 → 自律施术单元失控射击点 → 镇中心救治临时线。
- 冲突：叛乱者夺取城防单元（低技术熟练+高破坏） vs 罗德岛/镇方有限机动；塔佳娜冒险救人 vs 顽固镇民指责（身份偏见）；亚叶“追凶优先” vs 铃兰“救援优先”。
- 发展：塔佳娜受伤赢得部分同情；塞弗林资源/注意力被迫转向应急；灰喉/断崖加入形成专业火力控制；叛乱组织度被验证仍不足（无系统人质管理）。
- 结果：罗德岛现场合法性增强；“救援—调查”议程权重短暂倾向救援；局势从爆发向拉锯阶段过渡。
- 对白摘要：
  - “我们好不容易才抢下这玩意……”
  - “感染者！蛀虫！”（极化辱骂）
  - “全部撤离了吗？”
  - “正面冲突不是好选择。”

### TW-6 怒意漫延（行动前）
- 场景：塔佳娜临时救护醒来 → 灰喉护送 → 前线俘虏审讯点 → 镇中心再集结战略讨论。
- 冲突：是否立即“开战” vs 控制损失；亚叶复仇/愤怒与医疗职责定位冲突；“整合运动”名义正当化尝试 vs 罗德岛经验质疑；制度性失能（贵族婚礼调离宪兵）成为新矛盾源。
- 发展：俘虏叙事把阶层/制度怨恨嫁接进当前事件；亚叶在铃兰与灰喉劝导下暂缓前线参与；塞弗林寻求协同制订作战/救援双轨；“火灾=导火索”与“火灾=曝光器”两种因果框架被讨论。
- 结果：决策转入议事厅正式化流程前的情报收束；冲突多维因果被显性列举；罗德岛角色定位细化（医疗保障+情报评估+有限战斗）。
- 对白摘要：
  - “因为一场婚礼。”
  - “我怎么会信他们一个字！”
  - “你应当优先保护无辜的民众。”
  - “这将是敲定沃伦姆德命运的选择。”

### TW-6 怒意漫延（行动后）
- 场景：议事厅战术会商 → 镇民聚集街口口号 → 铃兰巡诊俘虏 → 老冬灵人自首长谈。
- 冲突：尸体数量可信度（4 vs 8）争议；“追真相/复仇”与“先稳局势”优先级冲突；群众情绪被口号节奏放大；历史复仇叙事被拆解为借口。
- 发展：提出遗体数字矛盾→火灾鉴定可信度下调；老冬灵人证词重构“冬灵=被耗散身份”；指出毕德曼现场指挥；亚叶情绪波动但暂压。
- 结果：新增调查疑点（人数差、毕德曼真实动机链）；暴乱自组织化加速；罗德岛需并行医救与情报斡旋。
- 对白摘要：
  - “四名” vs “八具遗体”
  - “我们要战斗！”
  - “我是最后的冬灵族人。”
  - “发号施令的人是他。”

### TW-7 群峦崩塌（行动前）
- 场景：议事厅询证毕德曼资料 → 镇民私自武装集结 → 萨卡兹营地内部讨论 → 岩石巨像前兆。
- 冲突：是否调整策略承认毕德曼存活线索；镇民越权军事化 vs 官方失控；泥岩队“继续隐忍/离场/毁灭”价值抉择。
- 发展：毕德曼被描绘为被迁怒的天灾信使（潜在报复动机模型形成）；镇民火攻意图被情报化；泥岩评估风险（若出手将遭城邦追捕）。
- 结果：冲突升级进入“群众-武装-佣兵”三层耦合；罗德岛任务边界被动扩大。
- 对白摘要：
  - “制止了七次针对他的暴力事件。”
  - “他们打算烧死我们。”
  - “只要你下令，月亮将永远停留……”

### TW-7 群峦崩塌（行动后）
- 场景：室内巷战勘验毕德曼尸体 → 塞弗林救护室 → 搜屋得危机合约文件 → 街区岩石巨像压境。
- 冲突：复仇标的消失→亚叶目标真空；塞弗林“自我牺牲式替罪” vs 真相完整性；危机合约被误当幕后组织。
- 发展：毕德曼实际已死→ 暴乱驱动力转结构与情绪惯性；塞弗林确认感染者身份并请求隐瞒；危机合约文件说明其专业性质；岩石巨像迫近压制普通防御。
- 结果：行动重心转“止损/控暴”而非“追凶”；权威合法性岌岌可危；泥岩保持限定介入姿态。
- 对白摘要：
  - “他已经死了。”
  - “请，隐瞒我的感染者身份。”
  - “我会承认我是火灾的凶手。”
  - “这是危机合约的行动协议……”

### TW-8 月光沉沦（行动前）
- 场景：前线留声机尽毁战线 → 火势蔓延救援断层 → 塔佳娜指挥点心理崩裂边缘 → 铃兰单线阻截 → 亚叶/灰喉战术室情绪对话 → 泥岩决意出手。
- 冲突：技术防御体系归零（留声机全毁）；“生存功利论” vs 道德底线（铃兰对激进感染者）；复仇逻辑支点坍塌后亚叶行动意义空窗。
- 发展：火攻造成非选择性伤亡提升；“整合运动”口号惯性传播；铃兰展现减速/控制技艺形成临时防线；泥岩准备以“决斗式”强干预。
- 结果：局势进入“高风险决战”过渡；依赖高技能个体（罗德岛+泥岩）维持继续存在的可能。
- 对白摘要：
  - “最后一个‘留声机’被破坏了！”
  - “你也一起被烧死吧！”
  - “失去了主心骨，这场暴乱自会瓦解！”
  - “战士，已经走上了战场。”

### TW-8 月光沉沦（行动后）
- 场景：岩石巨像对峙广场→ 暴徒后撤街区 → 废墟余烬→ 余威消散。
- 冲突：泥岩“自耗生命威慑” vs 暴徒群体非理性攻击惯性；萨卡兹战士言语框架重置（“不是为了杀人而战，是为了活下去”）；罗德岛保持克制旁侧观察。
- 发展：巨像由废墟凝聚→ 威慑强弩之末（灰喉识别崩解迹象）；泥岩转述“离开是最后机会”→ 将继续攻击者定义为集体灭亡风险来源；暴徒组织度崩塌转逃散。
- 结果：大规模暴力曲线被强行扭折；泥岩阵营选择抽身；塞弗林获得喘息窗口（仍隐匿感染者身份）；公共秩序进入“惧怕/疲惫”临时稳定。
- 对白摘要：
  - “站起来。”（泥岩凝聚巨像）
  - “你把生命分享给了你的造物。”
  - “离开这里。”
  - “先来打败我！”

### TW-ST-2 余烬之上
- 场景：议事厅临时客房会谈 → 塞弗林、灰喉、断崖对案件再评估 → 塞弗林私下回忆/梦境段。
- 冲突：“继续追凶”理性必要性 vs 资源枯竭与社会承受力；危机合约机制（平台 vs 极端信使）伦理评价分歧；是否告知亚叶“推理虚无化”真相。
- 发展：断崖提出毕德曼“工具化”概率；灰喉指出极端信使功利范式；塞弗林以“无法证明他能掌握复杂源石技艺”反驳单一凶手锁定；镇内物资与监狱管理进入紧张通告；塞弗林个人创伤（丧子+矿石病）在梦境象征释放。
- 结果：官方话语采取“信息冻结”策略（不再深究→ 防再度激化）；真相议程从显性公共诉求退回少数知情者内心困惑；情绪焦点转向生存与撤离路径规划。
- 对白摘要：
  - “我们一无所得。”
  - “他不是莱塔尼亚人……掌握不了过载。”
  - “真相很遥远。”
  - “在我儿的葬礼被否决的时候，我就放弃追寻了。”

### TW-S-1 三座巨像（行动后 / 回溯）
- 场景：托尔（托尔瓦尔德）与塞弗林早期对话客房 → 未来七日片段 → 危机合约接触与匿名来信 → 夜间神秘来访者（托尔）对毕德曼策动。
- 冲突：托尔“制造有限灾难以换取关注”功利逻辑 vs 毕德曼专业伦理/愧疚 → 是否介入暴乱；施术单元核心可能滥用；“更多生命 vs 直接牺牲”道德量化拉扯。
- 发展：毕德曼被暴力袭击后社会关系断裂；安托与塞弗林尝试修复名誉；托尔以“必然内讧”预期操控毕德曼心理；危机合约信件 & 留声机核心潜在获取链出现；毕德曼陷入“袖手旁观=罪”道德绑架框架。
- 结果：火灾与后续暴乱背后有人为“加速”与放任；毕德曼角色被重新定位为被裹挟的失控变量而非单核主谋；“三座巨像”隐喻（经济价值/婚礼仪式/暴乱烈焰）折射价值排序错位。
- 对白摘要：
  - “这是你赎罪的机会。”
  - “这一切……都是为了更多的生命。”
  - “你不会的，你甚至会帮他们。”
  - “我一定会死在这场暴乱里。”

### TW-S-2 一束哀悼（行动后）
- 场景：萨卡兹撤离筹划地带 → 废墟献花点（安托/死者之地）→ 亚叶与灰喉安静对谈 → 泥岩告别。
- 冲突：继续抗争（战士身份） vs 生存撤离（回归卡兹戴尔）；亚叶“未伸张正义”自责 vs 灰喉“实践限度”现实主义；泥岩“战斗是唯一工具” vs 罗德岛“多元路径”价值观。
- 发展：萨卡兹重新定义“家/归宿”→ 卡兹戴尔被描述为“流亡者之地”；泥岩提出同伴非战士属性→ 必须退出消耗性前线；亚叶心理从“复仇执念”转向“保存记忆/带回遗体”；灰喉传递“悲痛被动结束=妥协”生存经验。
- 结果：双方形成“敌对身份+局部尊重”并存结构；沃伦姆德事件正式进入善后期（撤离/补给/叙事定稿）；未解真相成为长期历史阴影；罗德岛任务从调查转护理/运送。
- 对白摘要：
  - “我们回家——卡兹戴尔。”
  - “八名感染者……现在死伤多几百倍。”
  - “我们只能战斗。”
  - “这样就……结束了。”

## 关键设定与物件（阶段性）
- 大裂谷：异常规模天灾形成的地理/资源/灾后心理隔离核心。
- 临时医疗营地（已焚毁）：安托组织感染者救治与安置的关键节点，火灾成谜。
- 十二音街道：名义上宽容、实则半封闭“社区监禁”结构；生活功能停摆。
- 武装感染者营地：外部势力补给点，态度暧昧；可能与整合运动或独立赏金/佣兵团相关。
- 未下葬遗体（含托尔）：道德压力与政治风险焦点。
- L-44“留声机”自律施术单元：可被篡夺过载制造瞬时高温（疑似凶器）。
- 地下动力炉：城镇迁移/能源核心，被破坏触发生存倒计时。
- 冷藏地下室：延迟哀悼 + 证据保存的象征性设施。
- 冬灵歌谣：古老祭典/葬礼法术载体，引发政治敏感与搜捕争议。
- 戒严态势：塞弗林下令民兵集合与街区包围的非常规治理模式。
- 城防自律施术单元滥用：低熟练叛乱者粗暴操控→平民区二次伤害。
- 宪兵调离事件：贵族婚礼占用防务资源导致长期防御真空。
- “冬灵人”历史：本地卡普里尼原住群体与现政权冲突残影（被刻意淡化）。
- 尸体数矛盾：4 vs 8 → 火灾遗体鉴定与身份确认待复核。
- 危机合约行动协议文件：毕德曼签约天灾信使身份凭据（动机复杂化）。
- 岩石巨像：萨卡兹高阶术式/小队协同输出象征，普通民兵术式难破。
- 留声机全毁：城镇自律施术防御体系崩溃→转入高技能个体防线阶段。
- 塞弗林矿石病（感染者）身份（隐匿中）：指挥合法性潜在脆弱点。
- 塔佳娜心理创伤再激活：火焰场景→托尔死亡记忆联动影响指挥连续性。
- 岩石巨像（生命共享形态）：确认为泥岩以自耗式萨卡兹古巫术维持的临时威慑构造（非稳定武力资产）。
- 危机合约极端派：以“控制牺牲换取更大利益”功利伦理为核心的小部分信使或支持者网络。
- 托尔（托尔瓦尔德）策动要素：提早筹划“引火”议程（通过婚礼/防务空窗 + 施术单元瓶颈）。
- 记忆与梦境：塞弗林梦段象征“理想化重建”与现实不可达落差。
- 卡兹戴尔：被再定义为“流亡者与无根者的土地”→ 提供萨卡兹/异乡感染者短暂避难叙事。

## 主题与冲突（阶段性提炼）
- 体面与恐惧：体面安葬 vs 感染恐慌的政策化。
- 透明与遮蔽：真相（火灾、失踪）被“轻描淡写”处理；谁拥有叙事权。
- 悲痛与功能：塞弗林的悲痛被“长官角色”压制；情感工具化。
- 温和幻象与结构压迫：表面宽容掩盖结构性自由剥夺；“街道即监禁”。
- 煽动与主体性：感染者诉求被外部力量可能利用；内部辨识与信任危机。
- 生存倒计时与伦理让渡：饥荒压力推动资源零和化。
- 技术反噬：防御技术（留声机核心）被转化为杀人手段。
- 复仇与正义：亚叶个人情感 vs 干员职业规范。
- 叙事争夺：事故/谋杀/自保/革命/限定复仇多重话语竞争。
- 制度性缺位与机会主义：上层仪式（婚礼）消耗公共安全资本放大基层脆弱。
- 仪式与暴力：悼念歌谣被再语境化为动员信号。
- 情绪治理：复仇冲动需要被专业角色职责框架化。
- 标签抢夺：叛乱者借“整合运动”标签寻求正统性 vs 过往战斗经验反驳。
- 替罪止暴策略：塞弗林拟“自认纵火”试图快速冻结报复链。
- 结构性失调 vs 个体凶手：毕德曼已死仍未止暴→真实驱动转为结构/惯性仇恨。
- 复仇目标坍塌后的意义再建：亚叶面临行动目的重构。
- 生存功利主义冲突：激进感染者“活下去即合理” vs 铃兰坚持伦理约束。
- 毁灭阈值管理：泥岩在“毁灭/克制”间维持压制与条件化介入。
- 证据脆弱性：遗体统计差异凸显灾后信息失真侵蚀政策判断。
- 权威合法性与隐匿：塞弗林感染者身份公开风险。
- 技术资本耗尽后的人力决战阶段：留声机失去→进入“个体技艺主导”模式。
- 威慑与自损：泥岩以自耗生命术式作为非杀戮收束手段的伦理代价。
- 功利牺牲悖论：托尔/极端信使“少数必死→多数或生”的计算与其道德自我赦免。
- 真相虚无化：证据链不闭合→ 管理层有意冻结调查避免次生冲突。
- 敌对与尊重的边界：罗德岛与泥岩阵营“价值观对立 + 行动目标阶段性一致”形成灰区协作样本。
- 悲痛处理模式：压制（塞弗林）/外化复仇（亚叶）/理性重构（灰喉）/仪式化献花（泥岩）。
- 归宿与流亡：卡兹戴尔被视作“非乌托邦的最后栖息地”，折射结构性排斥。
- 未竟正义：凶手悬而未决→ 事件历史叙事权开放给多种政治再利用。

## 关系与立场变化（至当前）
- 塞弗林 ↔ 镇民代表：合作维稳但互相推责。
- 塞弗林 ↔ 罗德岛：从疏离防范 → 勉强合作（信息仍留缺口）。
- 亚叶 ↔ 塔佳娜：功能性合作；塔佳娜信息选择性披露。
- 感染者居民 ↔ 镇当局：由“紧张”转向“爆发前夕”。
- 外围武装 ↔ 本地感染者：互不信任但存在资源链条。
- 塞弗林 ↔ 亚叶：对抗→共识（追凶协作）。
- 罗德岛前线 ↔ 增援小队：形成调查/战力潜在分工。
- 塞弗林 ↔ 塔佳娜：职责功利化引发亲属情感张力。
- 泥岩小队 ↔ 激进抗议者：战略目标差异（限定打击 vs 泛化报复）。
- 灰喉 ↔ 泥岩：力量差距→克制试探→形成“暂不敌对”默契。
- 亚叶 ↔ 灰喉：责任定位冲突（前线 vs 医疗）→沟通后暂时调适。
- 塔佳娜 ↔ 镇民（顽固派）：救援行为削弱偏见（身份标签松动）。
- 叛乱俘虏 ↔ 罗德岛：信息交换以“标签”（整合运动）试探可信度。
- 塞弗林 ↔ 公共群体：感染事实需隐匿以维系统帅权威。
- 亚叶 ↔ 复仇对象（毕德曼）：目标消失→情绪支点断裂。
- 灰喉 ↔ 亚叶：战术协作延伸为情绪稳定支持。
- 断崖/卡达 ↔ 调查线：危机合约文件发现强化侦察价值。
- 塔佳娜 ↔ 指挥职责：临时指挥+创伤干扰。
- 泥岩 ↔ 沃伦姆德：由旁观至“有限干预防毁灭”微转。
- 镇民 ↔ 标签政治：继续借“整合运动”维系对抗叙事。
- 萨卡兹小队 ↔ 暴乱者：潜在强力压制但克制使用。
- 铃兰 ↔ 激进感染者：伦理劝阻与生存功利论直接碰撞。
- 泥岩 ↔ 暴乱者：由潜在利用关系→ 公开切割（拒绝继续成为无序暴力工具）。
- 萨卡兹小队 ↔ 罗德岛：形成“互不追击”短期默契；保留未来战场潜在敌对。
- 亚叶 ↔ 正义议程：从“复仇=正义”向“保存记忆/带回同伴”转化。
- 塞弗林 ↔ 真相追索：主动放弃深挖 → 转向资源/秩序再分配（现实主义极化）。
- 毕德曼（死者定位） ↔ 舆论：从“核心元凶”向“被利用的失控变量”再评价。
- 罗德岛 ↔ 事件使命：从“寻找/营救安托 + 追凶”转“善后、心理支持、撤离路线评估”。

## 伏笔与未解（按出现顺序）
1. 火灾真实成因（意外 / 蓄意 / 外部势力渗透）。
2. 安托去向与是否仍存活。
3. 塔佳娜“情绪缺位”与潜在认知/立场问题。
4. 外围武装感染者真实组织属性（整合运动？赏金团？独立细胞？）。
5. 大鲍勃及其团队失联原因（通信中断 vs 战略撤离）。
6. 未下葬遗体后续处理与感染风险是否被夸大。
7. 萨卡兹煽动者身份层级与目标（单纯煽动 vs 情报搜集 vs 借壳夺权）。
8. 塞弗林健康（咳嗽）是否象征矿石病或其他风险→影响指挥稳定性。
9. 留声机核心具体篡夺者身份与操作手法。
10. 动力炉破坏与火灾是否同源行动链。
11. 冬灵人介入真实目的（求生/掠夺/政治复仇）。
12. 塞弗林潜在感染与指挥延续性影响。
13. 泥岩内部路线冲突未来走向。
14. 安托遗体辨识是否还有极低概率误认（待进一步证据排除）。
15. 冬灵歌谣施术主体身份与发布动机（纪念/动员/挑拨）。
16. 泥岩掌握火灾真相程度（是否知情凶手）。
17. 叛乱者能否系统化利用城防单元（技能学习 vs 破坏性误触）。
18. 贵族婚礼调离宪兵背后是否存在利益交换或掩盖动机。
19. “整合运动”自称是否为策略性冒名（缺乏其成熟战术特征）。
20. 冬灵历史细节（冲突性质/赔偿/遗址）是否与当前凶案动机相关。
21. 遗体数量差异（4 vs 8）真实性与是否误认。
22. 毕德曼完整行动链与死因（谁杀/为何提前死亡）。
23. 危机合约后续外部信使是否介入。
24. 岩石巨像操控方式（单体高阶 vs 多人协同 vs 装置）。
25. 塞弗林“自认纵火”策略是否实施及副作用。
26. 罗德岛任务权限是否获总部追认扩展。
27. 塔佳娜创伤后指挥稳定性。
28. 暴乱是否生成新象征性敌人（替代毕德曼）。
29. “最后的冬灵人”证言取证/存档与生命状态后续。
30. 留声机全毁后备用防御/迁移方案是否存在。
31. 施术单元核心真实转移路径与托尔参与程度（回溯仍缺直接链条）。
32. 托尔死亡时间线与其策动计划推进阶段的精准交叉点。
33. 危机合约平台内部极端派规模与是否继续暗中操作。
34. 塞弗林放弃调查决策的长期治理代价（信任蚀变潜伏期）。
35. 亚叶后续心理恢复与是否重启独立调查（带回罗德岛后线）。
36. 泥岩队伍前往卡兹戴尔途中生存风险与潜在再遭追捕。
37. 卡兹戴尔是否具备吸纳大量“非萨卡兹感染者”现实能力（资源/政治排斥）。
38. 冬灵人历史档案是否会被重新整理（记忆政治走向）。
39. 留声机技术脆弱性是否促成后续防御体系设计改进（技术教训）。
40. “功利牺牲”框架是否会在危机合约体系中被制度化或遏制。

（未解条目说明：31-40 为补充长尾问题，属潜在延展研究方向；本地事件即时战术阶段已结束，多数将转入外部结构层面。）

## 结局状态快照
（一）秩序与安全：
- 暴乱解除方式：非全面清剿，而是“威慑（岩石巨像）+ 情绪衰竭 + 指挥替罪意向”多因素叠加自然式退潮。
- 防御资产：留声机体系全毁 → 城镇短期防御极度脆弱，需外援或撤离路径。
- 动力与物资：动力炉破坏仍待重建；物资管制与十二音街道安置问题未系统解决。

（二）政治与治理：
- 塞弗林策略：冻结追凶议程，优先维持最低可运作秩序；感染者身份继续隐匿（未来潜在信任债务）。
- 叙事框架：官方将趋向“灾后复建 + 控损”话语，谋杀案元素被下沉为未决档案。

（三）角色命运：
- 亚叶：放下单点复仇行动逻辑，转向带回同伴记忆与遗体的守护性目标；心理进入“功能恢复/哀悼内化”阶段。
- 灰喉：完成战术与情绪支撑双角色，维持理性与安全底线基调。
- 塞弗林：身体（矿石病）与心理（丧子/挫败）双重消耗，治理能力未来走向不确定。
- 塔佳娜：创伤后压力暂获缓解，指挥角色可能被重新界定为辅佐。
- 泥岩及萨卡兹队伍：战略撤离，计划前往卡兹戴尔；保持与罗德岛“尊重+潜在敌对”双态。
- 毕德曼：死后形象再框定为“被裹挟的信使”，未被司法定性 → 留下道德模糊。 
- 安托：死亡确定（遗体在八具之一），其“英雄”与调和作用缺位成为事件升级重要前提。

（四）主题收束：
- “未竟正义” > “破案真相”：结构性裂缝与治理失灵成为主叙事核心。
- 功利牺牲伦理的反噬显性化（托尔/极端信使）→ 未得到道德正当化。
- 暴力并未产出“更清晰的政治未来”，只留下更脆弱的秩序与更分裂的记忆。

（五）悬而未决清单映射：核心凶案（火灾直接纵火者、施术单元操作链）未闭合；危机合约与托尔角色参与证据链断裂点保留；“4 vs 8”遗体统计差异需二次法医学核验；长官隐匿感染者身份的治理风险中长期效应未显现。

（六）后续建议（分析立场）：
- 技术侧：针对留声机/城防法术的防盗用与过载机制改进评估。
- 法医侧：补做遗体身份、死亡方式复核以解决“4 vs 8”矛盾。
- 治理侧：建立灾后透明化发布与哀悼仪式加速机制（降低信息真空）。
- 心理侧：对指挥层（塞弗林/塔佳娜）与关键见证人（亚叶）实施结构化创伤干预。
- 外交侧：早期申请外部中立调停或罗德岛更高权限介入，防“功利牺牲”逻辑扩散。

## 附：关卡要点速查（滚动补充）
- TW-ST-1：火灾余绪；遗体安葬争议；安托失联；外部武装现身；罗德岛准备出发。
- TW-1 前：罗德岛抵达；镇内权责推诿；感染者抗议升温；卷入冲突。
- TW-1 后：披露安托“失踪”与火灾背景；调查授权；整合运动可能性首次提出。
- TW-2 前：十二音街道“表宽容实停摆”；安托被神化；萨卡兹煽动影浮出；冲突临界。
 - TW-2 后：诉求清单化；“无人逃出”证词；谋杀叙事上升；罗德岛互信深化。
 - TW-3 前：现场勘查→瞬时高温证据；泥岩小队命名；工作牌遗留。
 - TW-3 后：议事厅攻防；动力炉被破坏；泥岩限定复仇理念。
 - TW-4 前：饥荒危机显性；凶器确认；遗体公开；复仇动机明朗；冬灵人线浮现。
 - TW-4 后：泥岩墓祭；人祸确认；冬灵调查受阻；外部武装暂不敌对。
 - TW-5 前：冬灵歌谣回荡；戒严启动；历史话题政治化；城防装置失控前兆。
 - TW-5 后：施术单元滥用；塔佳娜负伤救人；罗德岛救援合法性增强。
 - TW-6 前：制度性失能（宪兵调离）曝光；“整合运动”标签争夺；作战决策临界。
 - TW-6 后：遗体数矛盾；群众口号激化；老冬灵人证言→毕德曼指挥线索；复仇/职责再冲突。
 - TW-7 前：毕德曼存活调查；镇民越权包围；泥岩风险评估；全面冲突倒计时。
 - TW-7 后：毕德曼已死确认；塞弗林感染身份+替罪策略；危机合约文件；岩石巨像迫近。
 - TW-8 前：留声机尽毁；火攻蔓延；塔佳娜创伤；铃兰对抗生存功利论；泥岩准备出手。
  - TW-8 后：泥岩巨像威慑→ 暴徒撤散；萨卡兹宣布抽离；塞弗林获缓冲窗口。
  - TW-ST-2：追凶意志转虚无；毕德曼主谋存疑；生存优先级凌驾正义；塞弗林梦境象征性宣泄。
  - TW-S-1 后（回溯）：托尔功利策动；危机合约极端逻辑；毕德曼被裹挟；施术单元获取链伏笔。
  - TW-S-2 后：萨卡兹撤往卡兹戴尔；亚叶接受“未竟正义”；泥岩献花告别；事件转善后。

---
（状态：首轮全量整合完成；若需二次精炼或对比官方设定，可开新修订段落保留原版本快照。）
