import { Client, handle_file } from "./dist/index.js";

async function generate(image_url) {
	const client = await Client.connect("TencentARC/InstantMesh", {
		events: ["status", "data"]
	});

	const image = await fetch(image_url);
	const image_blob = await image.blob();

	// This is working fine
	const result_mvs_image = await client.predict("/generate_mvs", [
		handle_file(image_blob),
		50,
		10000
	]);

	console.log(result_mvs_image);

	// This is returning empty data object
	const job = client.submit("/make3d", []);

	for await (const message of job) {
		if (message.type === "data") {
			console.log(message);
		}
	}
}

generate(
	"https://raw.githubusercontent.com/gradio-app/gradio/main/test/test_files/bus.png"
);
