// SPDX-License-Identifier: GPL-2.0
/*!
 * @brief     SPI Register Definition Header File, automatically generated file at 1/20/2020 6:24:25 AM.
 *
 * @copyright copyright(c) 2018 - Analog Devices Inc.All Rights Reserved.
 *            This software is proprietary to Analog Devices, Inc. and its
 *            licensor. By using this software you agree to the terms of the
 *            associated analog devices software license agreement.
 */

/*!
 * @addtogroup AD9081_BF
 * @{
 */
#ifndef __ADI_AD9081_BF_JRXA_DES_H__
#define __ADI_AD9081_BF_JRXA_DES_H__

/*============= I N C L U D E S ============*/
#include "adi_ad9081_config.h"

/*============= D E F I N E S ==============*/
#define REG_MASTER_PD_ADDR 0x00000400
#define BF_PD_MASTER_RC_INFO 0x00000100
#define BF_PD_MASTER_RC(val) (val & 0x00000001)
#define BF_PD_MASTER_RC_GET(val) (val & 0x00000001)

#define REG_PHY_PD_ADDR 0x00000401
#define BF_PD_DES_RC_CH_INFO 0x00000800
#define BF_PD_DES_RC_CH(val) (val & 0x000000FF)
#define BF_PD_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_GENERIC_PD_ADDR 0x00000402
#define BF_PD_SYNCB_RC_INFO 0x00000100
#define BF_PD_SYNCB_RC(val) (val & 0x00000001)
#define BF_PD_SYNCB_RC_GET(val) (val & 0x00000001)
#define BF_PD_SYNCA_RC_INFO 0x00000101
#define BF_PD_SYNCA_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_PD_SYNCA_RC_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_CENTRAL_BIAS_ADDR 0x00000403
#define BF_PD_CENTRAL_BIASDIST_DES_RC_INFO 0x00000100
#define BF_PD_CENTRAL_BIASDIST_DES_RC(val) (val & 0x00000001)
#define BF_PD_CENTRAL_BIASDIST_DES_RC_GET(val) (val & 0x00000001)
#define BF_SEL_CENTRAL_BIASDIST_BG_DES_RC_INFO 0x00000101
#define BF_SEL_CENTRAL_BIASDIST_BG_DES_RC(val) \
	((val & 0x00000001) << 0x00000001)
#define BF_SEL_CENTRAL_BIASDIST_BG_DES_RC_GET(val) \
	((val >> 0x00000001) & 0x00000001)
#define BF_PDB_BIAS_DES_VDD1P0_INFO 0x00000102
#define BF_PDB_BIAS_DES_VDD1P0(val) ((val & 0x00000001) << 0x00000002)
#define BF_PDB_BIAS_DES_VDD1P0_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_TRIM_CENTRAL_BIASDIST_DES_RC_INFO 0x00000204
#define BF_TRIM_CENTRAL_BIASDIST_DES_RC(val) ((val & 0x00000003) << 0x00000004)
#define BF_TRIM_CENTRAL_BIASDIST_DES_RC_GET(val) \
	((val >> 0x00000004) & 0x00000003)

#define REG_CDR_RESET_ADDR 0x00000405
#define BF_RSTB_DES_RC_INFO 0x00000100
#define BF_RSTB_DES_RC(val) (val & 0x00000001)
#define BF_RSTB_DES_RC_GET(val) (val & 0x00000001)

#define REG_CBUS_ADDR_JRX_ADDR 0x00000406
#define BF_CBUS_ADDR_DES_RC_INFO 0x00000800
#define BF_CBUS_ADDR_DES_RC(val) (val & 0x000000FF)
#define BF_CBUS_ADDR_DES_RC_GET(val) (val & 0x000000FF)

#define REG_CBUS_WRSTROBE_PHY_ADDR 0x00000407
#define BF_CBUS_WSTROBE_DES_RC_CH_INFO 0x00000800
#define BF_CBUS_WSTROBE_DES_RC_CH(val) (val & 0x000000FF)
#define BF_CBUS_WSTROBE_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_CBUS_WDATA_JRX_ADDR 0x00000408
#define BF_CBUS_WDATA_DES_RC_INFO 0x00000800
#define BF_CBUS_WDATA_DES_RC(val) (val & 0x000000FF)
#define BF_CBUS_WDATA_DES_RC_GET(val) (val & 0x000000FF)

#define REG_CBUS_REN_PHY_ADDR 0x00000409
#define BF_CBUS_REN_DES_RC_CH_INFO 0x00000800
#define BF_CBUS_REN_DES_RC_CH(val) (val & 0x000000FF)
#define BF_CBUS_REN_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_CBUS_RDATA_JRX_ADDR 0x0000040A
#define BF_CBUS_RDATA_DES_RS_INFO 0x00000800
#define BF_CBUS_RDATA_DES_RS(val) (val & 0x000000FF)
#define BF_CBUS_RDATA_DES_RS_GET(val) (val & 0x000000FF)

#define REG_EYEM_EN_ADDR 0x0000040B
#define BF_EN_EYEM_DES_RC_CH_INFO 0x00000800
#define BF_EN_EYEM_DES_RC_CH(val) (val & 0x000000FF)
#define BF_EN_EYEM_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_FSM_ADDR 0x0000040C
#define BF_EN_EYEM_FSM_DES_RC_CH_INFO 0x00000800
#define BF_EN_EYEM_FSM_DES_RC_CH(val) (val & 0x000000FF)
#define BF_EN_EYEM_FSM_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_CLEAR_ADDR 0x0000040D
#define BF_EYEM_CLEAR_EYEMON_REGS_DES_RC_CH_INFO 0x00000800
#define BF_EYEM_CLEAR_EYEMON_REGS_DES_RC_CH(val) (val & 0x000000FF)
#define BF_EYEM_CLEAR_EYEMON_REGS_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_MODE_CH0_1_ADDR 0x0000040E
#define BF_SEL_EYEM_MODE_DES_RC_CH0_INFO 0x00000300
#define BF_SEL_EYEM_MODE_DES_RC_CH0(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH0_GET(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH1_INFO 0x00000304
#define BF_SEL_EYEM_MODE_DES_RC_CH1(val) ((val & 0x00000007) << 0x00000004)
#define BF_SEL_EYEM_MODE_DES_RC_CH1_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_EYEM_MODE_CH2_3_ADDR 0x0000040F
#define BF_SEL_EYEM_MODE_DES_RC_CH2_INFO 0x00000300
#define BF_SEL_EYEM_MODE_DES_RC_CH2(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH2_GET(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH3_INFO 0x00000304
#define BF_SEL_EYEM_MODE_DES_RC_CH3(val) ((val & 0x00000007) << 0x00000004)
#define BF_SEL_EYEM_MODE_DES_RC_CH3_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_EYEM_MODE_CH4_5_ADDR 0x00000410
#define BF_SEL_EYEM_MODE_DES_RC_CH4_INFO 0x00000300
#define BF_SEL_EYEM_MODE_DES_RC_CH4(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH4_GET(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH5_INFO 0x00000304
#define BF_SEL_EYEM_MODE_DES_RC_CH5(val) ((val & 0x00000007) << 0x00000004)
#define BF_SEL_EYEM_MODE_DES_RC_CH5_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_EYEM_MODE_CH6_7_ADDR 0x00000411
#define BF_SEL_EYEM_MODE_DES_RC_CH6_INFO 0x00000300
#define BF_SEL_EYEM_MODE_DES_RC_CH6(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH6_GET(val) (val & 0x00000007)
#define BF_SEL_EYEM_MODE_DES_RC_CH7_INFO 0x00000304
#define BF_SEL_EYEM_MODE_DES_RC_CH7(val) ((val & 0x00000007) << 0x00000004)
#define BF_SEL_EYEM_MODE_DES_RC_CH7_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_EYEM_STARTMEAS_ADDR 0x00000413
#define BF_SEL_EYEM_STARTMEAS_DES_RC_CH_INFO 0x00000800
#define BF_SEL_EYEM_STARTMEAS_DES_RC_CH(val) (val & 0x000000FF)
#define BF_SEL_EYEM_STARTMEAS_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_EQSWEEP_DONE_ADDR 0x00000414
#define BF_EYEM_EQSWEEPDONE_DES_RS_CH_INFO 0x00000800
#define BF_EYEM_EQSWEEPDONE_DES_RS_CH(val) (val & 0x000000FF)
#define BF_EYEM_EQSWEEPDONE_DES_RS_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_HORZ_ALARM_ADDR 0x00000415
#define BF_EYEM_HORZEYEALARM_DES_RS_CH_INFO 0x00000800
#define BF_EYEM_HORZEYEALARM_DES_RS_CH(val) (val & 0x000000FF)
#define BF_EYEM_HORZEYEALARM_DES_RS_CH_GET(val) (val & 0x000000FF)

#define REG_EYEM_HORZ_DONE_ADDR 0x00000416
#define BF_EYEM_HORZEYEDONE_DES_RS_CH_INFO 0x00000800
#define BF_EYEM_HORZEYEDONE_DES_RS_CH(val) (val & 0x000000FF)
#define BF_EYEM_HORZEYEDONE_DES_RS_CH_GET(val) (val & 0x000000FF)

#define REG_CDR_OPERATING_MODE_REG_2_ADDR 0x00000417
#define BF_SEL_LF_PARCKEDGE_DES_RC_CH_INFO 0x00000800
#define BF_SEL_LF_PARCKEDGE_DES_RC_CH(val) (val & 0x000000FF)
#define BF_SEL_LF_PARCKEDGE_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_CDR_BITINVERSE_ADDR 0x00000419
#define BF_SEL_LF_PARDATAINV_DES_RC_CH_INFO 0x00000800
#define BF_SEL_LF_PARDATAINV_DES_RC_CH(val) (val & 0x000000FF)
#define BF_SEL_LF_PARDATAINV_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_EQ_BOOST_PHY_3_0_ADDR 0x0000041B
#define BF_SEL_EQ_PEQ_DES_RC_CH0_INFO 0x00000200
#define BF_SEL_EQ_PEQ_DES_RC_CH0(val) (val & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH0_GET(val) (val & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH1_INFO 0x00000202
#define BF_SEL_EQ_PEQ_DES_RC_CH1(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_EQ_PEQ_DES_RC_CH1_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH2_INFO 0x00000204
#define BF_SEL_EQ_PEQ_DES_RC_CH2(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_EQ_PEQ_DES_RC_CH2_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH3_INFO 0x00000206
#define BF_SEL_EQ_PEQ_DES_RC_CH3(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_EQ_PEQ_DES_RC_CH3_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_EQ_BOOST_PHY_7_4_ADDR 0x0000041C
#define BF_SEL_EQ_PEQ_DES_RC_CH4_INFO 0x00000200
#define BF_SEL_EQ_PEQ_DES_RC_CH4(val) (val & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH4_GET(val) (val & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH5_INFO 0x00000202
#define BF_SEL_EQ_PEQ_DES_RC_CH5(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_EQ_PEQ_DES_RC_CH5_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH6_INFO 0x00000204
#define BF_SEL_EQ_PEQ_DES_RC_CH6(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_EQ_PEQ_DES_RC_CH6_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_SEL_EQ_PEQ_DES_RC_CH7_INFO 0x00000206
#define BF_SEL_EQ_PEQ_DES_RC_CH7(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_EQ_PEQ_DES_RC_CH7_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_EQ_GAIN_PHY_3_0_ADDR 0x0000041D
#define BF_SEL_EQ_GAIN_DES_RC_CH0_INFO 0x00000200
#define BF_SEL_EQ_GAIN_DES_RC_CH0(val) (val & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH0_GET(val) (val & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH1_INFO 0x00000202
#define BF_SEL_EQ_GAIN_DES_RC_CH1(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_EQ_GAIN_DES_RC_CH1_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH2_INFO 0x00000204
#define BF_SEL_EQ_GAIN_DES_RC_CH2(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_EQ_GAIN_DES_RC_CH2_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH3_INFO 0x00000206
#define BF_SEL_EQ_GAIN_DES_RC_CH3(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_EQ_GAIN_DES_RC_CH3_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_EQ_GAIN_PHY_7_4_ADDR 0x0000041E
#define BF_SEL_EQ_GAIN_DES_RC_CH4_INFO 0x00000200
#define BF_SEL_EQ_GAIN_DES_RC_CH4(val) (val & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH4_GET(val) (val & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH5_INFO 0x00000202
#define BF_SEL_EQ_GAIN_DES_RC_CH5(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_EQ_GAIN_DES_RC_CH5_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH6_INFO 0x00000204
#define BF_SEL_EQ_GAIN_DES_RC_CH6(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_EQ_GAIN_DES_RC_CH6_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_SEL_EQ_GAIN_DES_RC_CH7_INFO 0x00000206
#define BF_SEL_EQ_GAIN_DES_RC_CH7(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_EQ_GAIN_DES_RC_CH7_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_EQ_FB_PHY_0_ADDR 0x0000041F
#define BF_SEL_EQ_FB_DES_RC_CH0_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH0(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH0_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_1_ADDR 0x00000420
#define BF_SEL_EQ_FB_DES_RC_CH1_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH1(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH1_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_2_ADDR 0x00000421
#define BF_SEL_EQ_FB_DES_RC_CH2_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH2(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH2_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_3_ADDR 0x00000422
#define BF_SEL_EQ_FB_DES_RC_CH3_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH3(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH3_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_4_ADDR 0x00000423
#define BF_SEL_EQ_FB_DES_RC_CH4_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH4(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH4_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_5_ADDR 0x00000424
#define BF_SEL_EQ_FB_DES_RC_CH5_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH5(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH5_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_6_ADDR 0x00000425
#define BF_SEL_EQ_FB_DES_RC_CH6_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH6(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH6_GET(val) (val & 0x0000001F)

#define REG_EQ_FB_PHY_7_ADDR 0x00000426
#define BF_SEL_EQ_FB_DES_RC_CH7_INFO 0x00000500
#define BF_SEL_EQ_FB_DES_RC_CH7(val) (val & 0x0000001F)
#define BF_SEL_EQ_FB_DES_RC_CH7_GET(val) (val & 0x0000001F)

#define REG_LBT_REG_CNTRL_1_ADDR 0x00000428
#define BF_EN_LBT_HALFRATE_DES_RC_INFO 0x00000101
#define BF_EN_LBT_HALFRATE_DES_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_LBT_HALFRATE_DES_RC_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_SYNCA_ADDR 0x00000429
#define BF_SEL_SYNCA_MODE_RC_INFO 0x00000100
#define BF_SEL_SYNCA_MODE_RC(val) (val & 0x00000001)
#define BF_SEL_SYNCA_MODE_RC_GET(val) (val & 0x00000001)

#define REG_SYNCB_ADDR 0x0000042A
#define BF_SEL_SYNCB_MODE_RC_INFO 0x00000100
#define BF_SEL_SYNCB_MODE_RC(val) (val & 0x00000001)
#define BF_SEL_SYNCB_MODE_RC_GET(val) (val & 0x00000001)

#define REG_PHFWD_EN_ADDR 0x0000042B
#define BF_EN_PHFWD_DES_RC_CH_INFO 0x00000800
#define BF_EN_PHFWD_DES_RC_CH(val) (val & 0x000000FF)
#define BF_EN_PHFWD_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_PHFWD_MASTERMODE_ADDR 0x0000042C
#define BF_EN_PHFWD_MASTERMODE_DES_RC_CH_INFO 0x00000800
#define BF_EN_PHFWD_MASTERMODE_DES_RC_CH(val) (val & 0x000000FF)
#define BF_EN_PHFWD_MASTERMODE_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_PHFWD_R_PHY_0_3_ADDR 0x00000431
#define BF_EN_PHFWD_R_DES_RC_CH0_INFO 0x00000200
#define BF_EN_PHFWD_R_DES_RC_CH0(val) (val & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH0_GET(val) (val & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH1_INFO 0x00000202
#define BF_EN_PHFWD_R_DES_RC_CH1(val) ((val & 0x00000003) << 0x00000002)
#define BF_EN_PHFWD_R_DES_RC_CH1_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH2_INFO 0x00000204
#define BF_EN_PHFWD_R_DES_RC_CH2(val) ((val & 0x00000003) << 0x00000004)
#define BF_EN_PHFWD_R_DES_RC_CH2_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH3_INFO 0x00000206
#define BF_EN_PHFWD_R_DES_RC_CH3(val) ((val & 0x00000003) << 0x00000006)
#define BF_EN_PHFWD_R_DES_RC_CH3_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_PHFWD_R_PHY_4_7_ADDR 0x00000432
#define BF_EN_PHFWD_R_DES_RC_CH4_INFO 0x00000200
#define BF_EN_PHFWD_R_DES_RC_CH4(val) (val & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH4_GET(val) (val & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH5_INFO 0x00000202
#define BF_EN_PHFWD_R_DES_RC_CH5(val) ((val & 0x00000003) << 0x00000002)
#define BF_EN_PHFWD_R_DES_RC_CH5_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH6_INFO 0x00000204
#define BF_EN_PHFWD_R_DES_RC_CH6(val) ((val & 0x00000003) << 0x00000004)
#define BF_EN_PHFWD_R_DES_RC_CH6_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_EN_PHFWD_R_DES_RC_CH7_INFO 0x00000206
#define BF_EN_PHFWD_R_DES_RC_CH7(val) ((val & 0x00000003) << 0x00000006)
#define BF_EN_PHFWD_R_DES_RC_CH7_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_PHFWD_L_PHY_0_3_ADDR 0x00000433
#define BF_EN_PHFWD_L_DES_RC_CH0_INFO 0x00000200
#define BF_EN_PHFWD_L_DES_RC_CH0(val) (val & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH0_GET(val) (val & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH1_INFO 0x00000202
#define BF_EN_PHFWD_L_DES_RC_CH1(val) ((val & 0x00000003) << 0x00000002)
#define BF_EN_PHFWD_L_DES_RC_CH1_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH2_INFO 0x00000204
#define BF_EN_PHFWD_L_DES_RC_CH2(val) ((val & 0x00000003) << 0x00000004)
#define BF_EN_PHFWD_L_DES_RC_CH2_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH3_INFO 0x00000206
#define BF_EN_PHFWD_L_DES_RC_CH3(val) ((val & 0x00000003) << 0x00000006)
#define BF_EN_PHFWD_L_DES_RC_CH3_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_PHFWD_L_PHY_4_7_ADDR 0x00000434
#define BF_EN_PHFWD_L_DES_RC_CH4_INFO 0x00000200
#define BF_EN_PHFWD_L_DES_RC_CH4(val) (val & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH4_GET(val) (val & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH5_INFO 0x00000202
#define BF_EN_PHFWD_L_DES_RC_CH5(val) ((val & 0x00000003) << 0x00000002)
#define BF_EN_PHFWD_L_DES_RC_CH5_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH6_INFO 0x00000204
#define BF_EN_PHFWD_L_DES_RC_CH6(val) ((val & 0x00000003) << 0x00000004)
#define BF_EN_PHFWD_L_DES_RC_CH6_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_EN_PHFWD_L_DES_RC_CH7_INFO 0x00000206
#define BF_EN_PHFWD_L_DES_RC_CH7(val) ((val & 0x00000003) << 0x00000006)
#define BF_EN_PHFWD_L_DES_RC_CH7_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_PHFWD_INITERRFLAG_RB_ADDR 0x00000435
#define BF_PHFWD_INITERRFLAG_DES_RS_CH_INFO 0x00000800
#define BF_PHFWD_INITERRFLAG_DES_RS_CH(val) (val & 0x000000FF)
#define BF_PHFWD_INITERRFLAG_DES_RS_CH_GET(val) (val & 0x000000FF)

#define REG_PHFWD_INITERRFLAG_STICKY_ADDR 0x00000436
#define BF_PHFWD_INITERRFLAG_STICKY_DES_RS_CH_INFO 0x00000800
#define BF_PHFWD_INITERRFLAG_STICKY_DES_RS_CH(val) (val & 0x000000FF)
#define BF_PHFWD_INITERRFLAG_STICKY_DES_RS_CH_GET(val) (val & 0x000000FF)

#define REG_PHFWD_CLR_INITERRFLAG_STICKY_ADDR 0x00000437
#define BF_CLR_PHFWD_INITERRFLAGSTICKY_DES_RC_CH_INFO 0x00000800
#define BF_CLR_PHFWD_INITERRFLAGSTICKY_DES_RC_CH(val) (val & 0x000000FF)
#define BF_CLR_PHFWD_INITERRFLAGSTICKY_DES_RC_CH_GET(val) (val & 0x000000FF)

#define REG_DATA_PN_SWAP_ADDR 0x00000440
#define BF_DATA_PN_SWAP_CORR_DES_RC_INFO 0x00000800
#define BF_DATA_PN_SWAP_CORR_DES_RC(val) (val & 0x000000FF)
#define BF_DATA_PN_SWAP_CORR_DES_RC_GET(val) (val & 0x000000FF)

#define REG_TERM_FLOAT_ADDR 0x00000446
#define BF_EN_TERM_FLOATVTT_DES_RC_INFO 0x00000100
#define BF_EN_TERM_FLOATVTT_DES_RC(val) (val & 0x00000001)
#define BF_EN_TERM_FLOATVTT_DES_RC_GET(val) (val & 0x00000001)

#define REG_TERMCAL_0_ADDR 0x00000447
#define BF_EN_TERMCAL_RHOFSM_DES_RC_INFO 0x00000100
#define BF_EN_TERMCAL_RHOFSM_DES_RC(val) (val & 0x00000001)
#define BF_EN_TERMCAL_RHOFSM_DES_RC_GET(val) (val & 0x00000001)
#define BF_EN_TERMCAL_RHOBYPASS_DES_RC_INFO 0x00000102
#define BF_EN_TERMCAL_RHOBYPASS_DES_RC(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_TERMCAL_RHOBYPASS_DES_RC_GET(val) \
	((val >> 0x00000002) & 0x00000001)
#define BF_CK_TERMCAL_RHOBYPASS_DES_RC_INFO 0x00000103
#define BF_CK_TERMCAL_RHOBYPASS_DES_RC(val) ((val & 0x00000001) << 0x00000003)
#define BF_CK_TERMCAL_RHOBYPASS_DES_RC_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_TRIM_TERMCAL_RHOBYPASSVAL_DES_RC_INFO 0x00000404
#define BF_TRIM_TERMCAL_RHOBYPASSVAL_DES_RC(val) \
	((val & 0x0000000F) << 0x00000004)
#define BF_TRIM_TERMCAL_RHOBYPASSVAL_DES_RC_GET(val) \
	((val >> 0x00000004) & 0x0000000F)

#define REG_TERMCAL_1_ADDR 0x00000448
#define BF_TRIM_TERMCAL_RHO_DES_RS_INFO 0x00000400
#define BF_TRIM_TERMCAL_RHO_DES_RS(val) (val & 0x0000000F)
#define BF_TRIM_TERMCAL_RHO_DES_RS_GET(val) (val & 0x0000000F)
#define BF_TRIM_TERMCAL_CMPOUT_DES_RS_INFO 0x00000104
#define BF_TRIM_TERMCAL_CMPOUT_DES_RS(val) ((val & 0x00000001) << 0x00000004)
#define BF_TRIM_TERMCAL_CMPOUT_DES_RS_GET(val) \
	((val >> 0x00000004) & 0x00000001)

#define REG_LF_PARDATAMODE_DES_RC0_ADDR 0x00000457
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH0_INFO 0x00000200
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH0(val) (val & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH0_GET(val) (val & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH1_INFO 0x00000202
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH1(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH1_GET(val) \
	((val >> 0x00000002) & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH2_INFO 0x00000204
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH2(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH2_GET(val) \
	((val >> 0x00000004) & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH3_INFO 0x00000206
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH3(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH3_GET(val) \
	((val >> 0x00000006) & 0x00000003)

#define REG_LF_PARDATAMODE_DES_RC1_ADDR 0x00000458
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH4_INFO 0x00000200
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH4(val) (val & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH4_GET(val) (val & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH5_INFO 0x00000202
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH5(val) ((val & 0x00000003) << 0x00000002)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH5_GET(val) \
	((val >> 0x00000002) & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH6_INFO 0x00000204
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH6(val) ((val & 0x00000003) << 0x00000004)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH6_GET(val) \
	((val >> 0x00000004) & 0x00000003)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH7_INFO 0x00000206
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH7(val) ((val & 0x00000003) << 0x00000006)
#define BF_SEL_LF_PARDATAMODE_DES_RC_CH7_GET(val) \
	((val >> 0x00000006) & 0x00000003)

#define REG_LF_QUARTERRATE_DES_RC_ADDR 0x00000459
#define BF_SEL_LF_QUARTERRATE_DES_RC_INFO 0x00000800
#define BF_SEL_LF_QUARTERRATE_DES_RC(val) (val & 0x000000FF)
#define BF_SEL_LF_QUARTERRATE_DES_RC_GET(val) (val & 0x000000FF)

#endif /* __ADI_AD9081_BF_JRXA_DES_H__ */
/*! @} */