// SPDX-License-Identifier: GPL-2.0
/*!
 * @brief     SPI Register Definition Header File, automatically generated file at 1/20/2020 6:24:26 AM.
 *
 * @copyright copyright(c) 2018 - Analog Devices Inc.All Rights Reserved.
 *            This software is proprietary to Analog Devices, Inc. and its
 *            licensor. By using this software you agree to the terms of the
 *            associated analog devices software license agreement.
 */

/*!
 * @addtogroup AD9081_BF
 * @{
 */
#ifndef __ADI_AD9081_BF_LCPLL_28NM_R1_H__
#define __ADI_AD9081_BF_LCPLL_28NM_R1_H__

/*============= I N C L U D E S ============*/
#include "adi_ad9081_config.h"

/*============= D E F I N E S ==============*/
#define REG_LCPLL_RST_ADDR 0x00000720
#define BF_RSTB_LCPLL_RC_INFO 0x00000100
#define BF_RSTB_LCPLL_RC(val) (val & 0x00000001)
#define BF_RSTB_LCPLL_RC_GET(val) (val & 0x00000001)

#define REG_PLL_ENABLE_CTRL_ADDR 0x00000721
#define BF_PWRUP_LCPLL_INFO 0x00000100
#define BF_PWRUP_LCPLL(val) (val & 0x00000001)
#define BF_PWRUP_LCPLL_GET(val) (val & 0x00000001)
#define BF_LDSYNTH_FORCE_LCPLL_ADC_INFO 0x00000101
#define BF_LDSYNTH_FORCE_LCPLL_ADC(val) ((val & 0x00000001) << 0x00000001)
#define BF_LDSYNTH_FORCE_LCPLL_ADC_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_LOLSTICKYCLEAR_FORCE_LCPLL_RC_INFO 0x00000103
#define BF_LOLSTICKYCLEAR_FORCE_LCPLL_RC(val) ((val & 0x00000001) << 0x00000003)
#define BF_LOLSTICKYCLEAR_FORCE_LCPLL_RC_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_LCPLL_JTX_PLL_BYPASS_LOCK_INFO 0x00000105
#define BF_LCPLL_JTX_PLL_BYPASS_LOCK(val) ((val & 0x00000001) << 0x00000005)
#define BF_LCPLL_JTX_PLL_BYPASS_LOCK_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_PLL_LOCKED_BYPASS_INFO 0x00000106
#define BF_PLL_LOCKED_BYPASS(val) ((val & 0x00000001) << 0x00000006)
#define BF_PLL_LOCKED_BYPASS_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_PLL_LOCKED_BYPASS_VAL_INFO 0x00000107
#define BF_PLL_LOCKED_BYPASS_VAL(val) ((val & 0x00000001) << 0x00000007)
#define BF_PLL_LOCKED_BYPASS_VAL_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PLL_STATUS_LCPLL_ADDR 0x00000722
#define BF_LCPLLLOCK_LCPLL_RS_INFO 0x00000100
#define BF_LCPLLLOCK_LCPLL_RS(val) (val & 0x00000001)
#define BF_LCPLLLOCK_LCPLL_RS_GET(val) (val & 0x00000001)
#define BF_REGULATORRDY_LCPLL_RS_INFO 0x00000101
#define BF_REGULATORRDY_LCPLL_RS(val) ((val & 0x00000001) << 0x00000001)
#define BF_REGULATORRDY_LCPLL_RS_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_VCOCALINPROG_LCPLL_RS_INFO 0x00000102
#define BF_VCOCALINPROG_LCPLL_RS(val) ((val & 0x00000001) << 0x00000002)
#define BF_VCOCALINPROG_LCPLL_RS_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_RFPLLLOCK_LCPLL_RS_INFO 0x00000103
#define BF_RFPLLLOCK_LCPLL_RS(val) ((val & 0x00000001) << 0x00000003)
#define BF_RFPLLLOCK_LCPLL_RS_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_LOSSLOCK_LCPLL_RS_INFO 0x00000104
#define BF_LOSSLOCK_LCPLL_RS(val) ((val & 0x00000001) << 0x00000004)
#define BF_LOSSLOCK_LCPLL_RS_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_PLL_PWR_UP1_ADDR 0x00000723
#define BF_PWRUP_ADC_LCPLL_RC_INFO 0x00000101
#define BF_PWRUP_ADC_LCPLL_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_PWRUP_ADC_LCPLL_RC_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PWRUP_CP_LCPLL_RC_INFO 0x00000102
#define BF_PWRUP_CP_LCPLL_RC(val) ((val & 0x00000001) << 0x00000002)
#define BF_PWRUP_CP_LCPLL_RC_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PWRUP_DIV_LCPLL_RC_INFO 0x00000103
#define BF_PWRUP_DIV_LCPLL_RC(val) ((val & 0x00000001) << 0x00000003)
#define BF_PWRUP_DIV_LCPLL_RC_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PWRUP_PEAKDET_LCPLL_RC_INFO 0x00000104
#define BF_PWRUP_PEAKDET_LCPLL_RC(val) ((val & 0x00000001) << 0x00000004)
#define BF_PWRUP_PEAKDET_LCPLL_RC_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_PWRUP_PLLBIAS_LCPLL_RC_INFO 0x00000105
#define BF_PWRUP_PLLBIAS_LCPLL_RC(val) ((val & 0x00000001) << 0x00000005)
#define BF_PWRUP_PLLBIAS_LCPLL_RC_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_PWRUP_VCO_LCPLL_RC_INFO 0x00000106
#define BF_PWRUP_VCO_LCPLL_RC(val) ((val & 0x00000001) << 0x00000006)
#define BF_PWRUP_VCO_LCPLL_RC_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_PWRUP_REG_LCPLL_RC_INFO 0x00000107
#define BF_PWRUP_REG_LCPLL_RC(val) ((val & 0x00000001) << 0x00000007)
#define BF_PWRUP_REG_LCPLL_RC_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PLL_PWR_UP2_ADDR 0x00000724
#define BF_PWRUP_REFCLK_LCPLL_RC_INFO 0x00000100
#define BF_PWRUP_REFCLK_LCPLL_RC(val) (val & 0x00000001)
#define BF_PWRUP_REFCLK_LCPLL_RC_GET(val) (val & 0x00000001)
#define BF_PWRUP_VCOVAR_LCPLL_RC_INFO 0x00000101
#define BF_PWRUP_VCOVAR_LCPLL_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_PWRUP_VCOVAR_LCPLL_RC_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PWRUP_VCOBUF_LCPLL_RC_INFO 0x00000102
#define BF_PWRUP_VCOBUF_LCPLL_RC(val) ((val & 0x00000001) << 0x00000002)
#define BF_PWRUP_VCOBUF_LCPLL_RC_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PWRUP_VCOVARBIAS_LCPLL_RC_INFO 0x00000103
#define BF_PWRUP_VCOVARBIAS_LCPLL_RC(val) ((val & 0x00000001) << 0x00000003)
#define BF_PWRUP_VCOVARBIAS_LCPLL_RC_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PWRUP_ADCAUX_LCPLL_RC_INFO 0x00000106
#define BF_PWRUP_ADCAUX_LCPLL_RC(val) ((val & 0x00000001) << 0x00000006)
#define BF_PWRUP_ADCAUX_LCPLL_RC_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_PLL_PWR_UP3_ADDR 0x00000725
#define BF_PWRUP_VCOBIAS_LCPLL_RC_INFO 0x00000400
#define BF_PWRUP_VCOBIAS_LCPLL_RC(val) (val & 0x0000000F)
#define BF_PWRUP_VCOBIAS_LCPLL_RC_GET(val) (val & 0x0000000F)

#define REG_PLL_ENCAL_ADDR 0x00000726
#define BF_FIXED_SERDES_PLL_INFO 0x00000100
#define BF_FIXED_SERDES_PLL(val) (val & 0x00000001)
#define BF_FIXED_SERDES_PLL_GET(val) (val & 0x00000001)
#define BF_EN_TX_ONLY_LCPLL_RC_INFO 0x00000101
#define BF_EN_TX_ONLY_LCPLL_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_TX_ONLY_LCPLL_RC_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PD_RXCLK_DIST_RC_INFO 0x00000103
#define BF_PD_RXCLK_DIST_RC(val) ((val & 0x00000001) << 0x00000003)
#define BF_PD_RXCLK_DIST_RC_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PD_TXCLK_DIST_RC_INFO 0x00000104
#define BF_PD_TXCLK_DIST_RC(val) ((val & 0x00000001) << 0x00000004)
#define BF_PD_TXCLK_DIST_RC_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_LCPLL_REF_CLK_DIV1_REG_ADDR 0x00000727
#define BF_SERDES_PLL_BF_0_INFO 0x00000300
#define BF_SERDES_PLL_BF_0(val) (val & 0x00000007)
#define BF_SERDES_PLL_BF_0_GET(val) (val & 0x00000007)
#define BF_DIVM_LCPLL_RC_INFO 0x00000204
#define BF_DIVM_LCPLL_RC(val) ((val & 0x00000003) << 0x00000004)
#define BF_DIVM_LCPLL_RC_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_SERDES_PLL_BF_1_INFO 0x00000106
#define BF_SERDES_PLL_BF_1(val) ((val & 0x00000001) << 0x00000006)
#define BF_SERDES_PLL_BF_1_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_REFCK_DIV40BDIV120_LCPLL_INFO 0x00000107
#define BF_REFCK_DIV40BDIV120_LCPLL(val) ((val & 0x00000001) << 0x00000007)
#define BF_REFCK_DIV40BDIV120_LCPLL_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PLL_DIV2_ADDR 0x00000728
#define BF_SERDES_PLL_BF_9_INFO 0x00000800
#define BF_SERDES_PLL_BF_9(val) (val & 0x000000FF)
#define BF_SERDES_PLL_BF_9_GET(val) (val & 0x000000FF)

#define REG_PLL_RXDIVRATE_STATUS_ADDR 0x00000729
#define BF_RXDIVRATE_LCPLL_RS_INFO 0x00000400
#define BF_RXDIVRATE_LCPLL_RS(val) (val & 0x0000000F)
#define BF_RXDIVRATE_LCPLL_RS_GET(val) (val & 0x0000000F)
#define BF_DIVM_LCPLL_RS_INFO 0x00000204
#define BF_DIVM_LCPLL_RS(val) ((val & 0x00000003) << 0x00000004)
#define BF_DIVM_LCPLL_RS_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_PLL_DIVOVD_ADDR 0x0000072A
#define BF_SERDES_PLL_BF_3_INFO 0x00000100
#define BF_SERDES_PLL_BF_3(val) (val & 0x00000001)
#define BF_SERDES_PLL_BF_3_GET(val) (val & 0x00000001)
#define BF_SERDES_PLL_BF_4_INFO 0x00000101
#define BF_SERDES_PLL_BF_4(val) ((val & 0x00000001) << 0x00000001)
#define BF_SERDES_PLL_BF_4_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_SERDES_PLL_BF_5_INFO 0x00000102
#define BF_SERDES_PLL_BF_5(val) ((val & 0x00000001) << 0x00000002)
#define BF_SERDES_PLL_BF_5_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SERDES_PLL_BF_6_INFO 0x00000103
#define BF_SERDES_PLL_BF_6(val) ((val & 0x00000001) << 0x00000003)
#define BF_SERDES_PLL_BF_6_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_PLL_RXDIVRATE_ADDR 0x0000072B
#define BF_SERDES_PLL_BF_7_INFO 0x00000400
#define BF_SERDES_PLL_BF_7(val) (val & 0x0000000F)
#define BF_SERDES_PLL_BF_7_GET(val) (val & 0x0000000F)

#define REG_PLL_VCO_TRIM_ADDR 0x0000072C
#define BF_VCORTRIM_LCPLL_RC_INFO 0x00000600
#define BF_VCORTRIM_LCPLL_RC(val) (val & 0x0000003F)
#define BF_VCORTRIM_LCPLL_RC_GET(val) (val & 0x0000003F)

#define REG_PLL_REFCLK_CPL_ADDR 0x0000072D
#define BF_SEL_REFCKDCACB_LCPLL_RC_INFO 0x00000100
#define BF_SEL_REFCKDCACB_LCPLL_RC(val) (val & 0x00000001)
#define BF_SEL_REFCKDCACB_LCPLL_RC_GET(val) (val & 0x00000001)
#define BF_SERDES_PLL_BF_8_INFO 0x00000101
#define BF_SERDES_PLL_BF_8(val) ((val & 0x00000001) << 0x00000001)
#define BF_SERDES_PLL_BF_8_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DIGCLK_REFIN_DIV_RC_INFO 0x00000304
#define BF_DIGCLK_REFIN_DIV_RC(val) ((val & 0x00000007) << 0x00000004)
#define BF_DIGCLK_REFIN_DIV_RC_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_CBUS_REN_LCPLL_ADDR 0x0000072E
#define BF_LCPLL_CBUS_REN_LCPLL_RC_INFO 0x00000100
#define BF_LCPLL_CBUS_REN_LCPLL_RC(val) (val & 0x00000001)
#define BF_LCPLL_CBUS_REN_LCPLL_RC_GET(val) (val & 0x00000001)

#define REG_CBUS_WSTROBE_LCPLL_ADDR 0x0000072F
#define BF_LCPLL_CBUS_WSTROBE_LCPLL_RC_INFO 0x00000100
#define BF_LCPLL_CBUS_WSTROBE_LCPLL_RC(val) (val & 0x00000001)
#define BF_LCPLL_CBUS_WSTROBE_LCPLL_RC_GET(val) (val & 0x00000001)

#define REG_CKDIST_PD_ADDR 0x00000730
#define BF_PD_PPF_DES_RC_INFO 0x00000100
#define BF_PD_PPF_DES_RC(val) (val & 0x00000001)
#define BF_PD_PPF_DES_RC_GET(val) (val & 0x00000001)
#define BF_IDIST_PD_RC_INFO 0x00000101
#define BF_IDIST_PD_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_IDIST_PD_RC_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_POLYPHASE_CTRL_ADDR 0x00000731
#define BF_TRIM_POLYPHASE_DES_RC_INFO 0x00000800
#define BF_TRIM_POLYPHASE_DES_RC(val) (val & 0x000000FF)
#define BF_TRIM_POLYPHASE_DES_RC_GET(val) (val & 0x000000FF)

#define REG_PLL_READ_FREQ4_ADDR 0x00000732
#define BF_VCOFREQBAND_LCPLL_RS_INFO 0x00000B00
#define BF_VCOFREQBAND_LCPLL_RS(val) (val & 0x000007FF)
#define BF_VCOFREQBAND_LCPLL_RS_GET(val) (val & 0x000007FF)

#define REG_PLL_READ_FREQ5_ADDR 0x00000733

#define REG_PLL_PTAT_STARTUP_ADDR 0x00000734
#define BF_PTAT_STARTUP_LCPLL_RC_INFO 0x00000800
#define BF_PTAT_STARTUP_LCPLL_RC(val) (val & 0x000000FF)
#define BF_PTAT_STARTUP_LCPLL_RC_GET(val) (val & 0x000000FF)

#define REG_PLL_PTAT_STARTUP_STATUS1_ADDR 0x00000735
#define BF_PTAT_STARTUP_STATUS_RS1_INFO 0x00000100
#define BF_PTAT_STARTUP_STATUS_RS1(val) (val & 0x00000001)
#define BF_PTAT_STARTUP_STATUS_RS1_GET(val) (val & 0x00000001)

#define REG_PLL_PTAT_STARTUP_STATUS2_ADDR 0x00000736
#define BF_PTAT_STARTUP_STATUS_RS2_INFO 0x00000100
#define BF_PTAT_STARTUP_STATUS_RS2(val) (val & 0x00000001)
#define BF_PTAT_STARTUP_STATUS_RS2_GET(val) (val & 0x00000001)

#define REG_PLL_TEMP_ADDR 0x00000737
#define BF_TDEGCINIT_LCPLL_RC_INFO 0x00000100
#define BF_TDEGCINIT_LCPLL_RC(val) (val & 0x00000001)
#define BF_TDEGCINIT_LCPLL_RC_GET(val) (val & 0x00000001)

#define REG_PLL_READ_TEMP1_ADDR 0x0000073A
#define BF_TDEGC_LCPLL_RS_INFO 0x00000C00
#define BF_TDEGC_LCPLL_RS(val) (val & 0x00000FFF)
#define BF_TDEGC_LCPLL_RS_GET(val) (val & 0x00000FFF)

#define REG_PLL_READ_TEMP2_ADDR 0x0000073B

#define REG_PLL_LDSYNTH_DELAY_ADDR 0x0000073D
#define BF_LDSYNTH_LCPLL_HIGH_INFO 0x00000400
#define BF_LDSYNTH_LCPLL_HIGH(val) (val & 0x0000000F)
#define BF_LDSYNTH_LCPLL_HIGH_GET(val) (val & 0x0000000F)
#define BF_LDSYNTH_LCPLL_WARMUP_INFO 0x00000404
#define BF_LDSYNTH_LCPLL_WARMUP(val) ((val & 0x0000000F) << 0x00000004)
#define BF_LDSYNTH_LCPLL_WARMUP_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_PLL_LOCK_CTL1_ADDR 0x0000073E
#define BF_LCPLL_LOCK_SEL_INFO 0x00000100
#define BF_LCPLL_LOCK_SEL(val) (val & 0x00000001)
#define BF_LCPLL_LOCK_SEL_GET(val) (val & 0x00000001)
#define BF_LCPLL_LOCK_DIVIDER_INFO 0x00000A04
#define BF_LCPLL_LOCK_DIVIDER(val) ((val & 0x000003FF) << 0x00000004)
#define BF_LCPLL_LOCK_DIVIDER_GET(val) ((val >> 0x00000004) & 0x000003FF)

#define REG_PLL_LOCK_CTL2_ADDR 0x0000073F

#define REG_CBUS_ADDR_LCPLL_ADDR 0x00000740
#define BF_LCPLL_CBUS_ADDR_LCPLL_RC_INFO 0x00000800
#define BF_LCPLL_CBUS_ADDR_LCPLL_RC(val) (val & 0x000000FF)
#define BF_LCPLL_CBUS_ADDR_LCPLL_RC_GET(val) (val & 0x000000FF)

#define REG_CBUS_WDATA_LCPLL_ADDR 0x00000741
#define BF_LCPLL_CBUS_WDATA_LCPLL_RC_INFO 0x00000800
#define BF_LCPLL_CBUS_WDATA_LCPLL_RC(val) (val & 0x000000FF)
#define BF_LCPLL_CBUS_WDATA_LCPLL_RC_GET(val) (val & 0x000000FF)

#define REG_CBUS_RDATA_LCPLL_ADDR 0x00000742
#define BF_LCPLL_CBUS_RDATA_LCPLL_RS_INFO 0x00000800
#define BF_LCPLL_CBUS_RDATA_LCPLL_RS(val) (val & 0x000000FF)
#define BF_LCPLL_CBUS_RDATA_LCPLL_RS_GET(val) (val & 0x000000FF)

#define REG_REFCLK_CTRL_ADDR 0x00000743
#define BF_EN_REFCLK_RCVR_RC_INFO 0x00000100
#define BF_EN_REFCLK_RCVR_RC(val) (val & 0x00000001)
#define BF_EN_REFCLK_RCVR_RC_GET(val) (val & 0x00000001)
#define BF_SEL_SYNCA_FOR_REFCLK_RC_INFO 0x00000101
#define BF_SEL_SYNCA_FOR_REFCLK_RC(val) ((val & 0x00000001) << 0x00000001)
#define BF_SEL_SYNCA_FOR_REFCLK_RC_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_SEL_REFCLK_RCVR_LP_MODE_RC_INFO 0x00000102
#define BF_SEL_REFCLK_RCVR_LP_MODE_RC(val) ((val & 0x00000001) << 0x00000002)
#define BF_SEL_REFCLK_RCVR_LP_MODE_RC_GET(val) \
	((val >> 0x00000002) & 0x00000001)
#define BF_SEL_REFCLK_RCVR_CM_CTRL_INFO 0x00000403
#define BF_SEL_REFCLK_RCVR_CM_CTRL(val) ((val & 0x0000000F) << 0x00000003)
#define BF_SEL_REFCLK_RCVR_CM_CTRL_GET(val) ((val >> 0x00000003) & 0x0000000F)

#define REG_SERDES_REV_ID_RS_LCPLL_ADDR 0x00000744
#define BF_LCPLL_SERDES_REV_ID_RS_INFO 0x00000800
#define BF_LCPLL_SERDES_REV_ID_RS(val) (val & 0x000000FF)
#define BF_LCPLL_SERDES_REV_ID_RS_GET(val) (val & 0x000000FF)

#define REG_SPARE0_ADDR 0x00000745
#define BF_LCPLL_SPARE0_INFO 0x00000800
#define BF_LCPLL_SPARE0(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE0_GET(val) (val & 0x000000FF)

#define REG_SPARE1_ADDR 0x00000746
#define BF_LCPLL_SPARE1_INFO 0x00000800
#define BF_LCPLL_SPARE1(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE1_GET(val) (val & 0x000000FF)

#define REG_SPARE2_ADDR 0x00000747
#define BF_LCPLL_SPARE2_INFO 0x00000800
#define BF_LCPLL_SPARE2(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE2_GET(val) (val & 0x000000FF)

#define REG_SPARE3_ADDR 0x00000748
#define BF_LCPLL_SPARE3_INFO 0x00000800
#define BF_LCPLL_SPARE3(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE3_GET(val) (val & 0x000000FF)

#define REG_SPARE4_ADDR 0x00000749
#define BF_LCPLL_SPARE4_INFO 0x00000800
#define BF_LCPLL_SPARE4(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE4_GET(val) (val & 0x000000FF)

#define REG_SPARE5_ADDR 0x0000074A
#define BF_LCPLL_SPARE5_INFO 0x00000800
#define BF_LCPLL_SPARE5(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE5_GET(val) (val & 0x000000FF)

#define REG_SPARE6_ADDR 0x0000074B
#define BF_LCPLL_SPARE6_INFO 0x00000800
#define BF_LCPLL_SPARE6(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE6_GET(val) (val & 0x000000FF)

#define REG_SPARE7_ADDR 0x0000074C
#define BF_LCPLL_SPARE7_INFO 0x00000800
#define BF_LCPLL_SPARE7(val) (val & 0x000000FF)
#define BF_LCPLL_SPARE7_GET(val) (val & 0x000000FF)

#endif /* __ADI_AD9081_BF_LCPLL_28NM_R1_H__ */
/*! @} */