/* SPDX-License-Identifier: GPL-2.0 */
/**
* \file adrv9025_reg_addr_macros.h
* \brief Contains ADRV9025 API miscellaneous macro definitions
*        Use these register Address only for initialize and before MCS.
*        Should use Bitfield function after MCS.
*
* ADRV9025 API Version: 7.0.0.14
*/

/**
* Copyright 2015 - 2020 Analog Devices Inc.
* Released under the ADRV9025 API license, for more information
* see the "LICENSE.pdf" file in this zip file.
*/

#ifndef _ADRV9025_REG_ADDR_MACROS_H
#define _ADRV9025_REG_ADDR_MACROS_H

#ifdef __cplusplus
extern "C" {
#endif

#define ADRV9025_BF_ENCODE(value, mask, shift) (((value) << (shift)) & (mask))
#define ADRV9025_BF_DECODE(value, mask, shift) (((value) & (mask)) >> (shift))
#define ADRV9025_BF_CLEAR(result, mask)  (result = ((result) & ~(mask)))
#define ADRV9025_BF_SET(result, mask) (result = (result) | (mask))
#define ADRV9025_BF_UPDATE(result, value, mask, shift)  (result = ((result) & ~(mask)) | ( ((value) << (shift)) & (mask)))
#define ADRV9025_BF_EQUAL(value, mask) ((mask) == ((value) & (mask)))

#define ADRV9025_ADDR_SPI_INTERFACE_CONFIG_A     0x0000
#define ADRV9025_CONFIG_A_SPI_LSB_FIRST          0x42
#define ADRV9025_CONFIG_A_SPI_ADDR_ASCENSION     0x24
#define ADRV9025_CONFIG_A_SPI_SDO_ACTIVE         0x18

#define ADRV9025_ADDR_SPI_INTERFACE_CONFIG_B     0x0001
#define ADRV9025_CONFIG_B_SINGLE_INSTRUCTION     0x80

#define ADRV9025_ADDR_PRODUCT_ID_0               0x0004
#define ADRV9025_ADDR_PRODUCT_ID_1               0x0005
#define ADRV9025_ADDR_SCRATCH_PAD                0x000A
#define ADRV9025_ADDR_VENDOR_ID_0                0x000C
#define ADRV9025_ADDR_VENDOR_ID_1                0x000D
#define ADRV9025_ADDR_SCRATCH_PAD_UPPER_ADDRESS_SPACE                0x7217 /* JTX_LINK Converter select */

#define ADRV9025_ADDR_DIGITAL_IO_CONTROL         0x0010
#define ADRV9025_IO_CONTROL_SPI2_OUTS_DRV_SEL    0x02
#define ADRV9025_IO_CONTROL_SPI_OUTS_DRV_SEL     0x01

#define ADRV9025_ADDR_SPI2_CONFIG                0x0011
/* Same as CoreSpiInterfaceConfigA */
#define ADRV9025_ADDR_SPI2_CONFIG2               0x0012
#define ADRV9025_SPI2_CONFIG2_SPI_2_EN           0x1

#define ADRV9025_ADDR_CLOCK_CONTROL_0            0x0013
#define ADRV9025_CC0_DIG_REF_CLK_DIV_RATIO_MASK  0xE0
#define ADRV9025_CC0_DIG_REF_CLK_DIV_RATIO_SHIFT 5
#define ADRV9025_CC0_REG_CLK_DIVIDE_RATIO_MASK   0x18
#define ADRV9025_CC0_REG_CLK_DIVIDE_RATIO_SHIFT  3
#define ADRV9025_CC0_CPU_CLK_ENABLE              0x04
#define ADRV9025_CC0_CPU_CLK_DIVIDE_RATIO_MASK   0x03
#define ADRV9025_CC0_CPU_CLK_DIVIDE_RATIO_SHIFT  0

#define ADRV9025_ADDR_CLOCK_CONTROL_7            0x001A
#define ADRV9025_CC7_DIGITAL_CLOCK_POWER_UP      0x40
#define ADRV9025_CC7_USE_DEVICE_CLK_AS_HSDIGCLK            0x80
#define ADRV9025_CC7_USE_DEVICE_CLK_AS_HSDIGCLK_UNTIL_MCS  0x20

#define ADRV9025_ADDR_REFERENCE_CLOCK_CYCLE      0x0025
#define ADRV9025_ADDR_AHB_SPI_BRIDGE             0x0026
#define ADRV9025_AHB_SPI_BRIDGE_RESET            0x0E
#define ADRV9025_AHB_SPI_BRIDGE_EN               0x01

#define ADRV9025_ADDR_SYSREF_PAD_CONFIG          0x0047
#define ADRV9025_SYSREF_PAD_LVDS_MODE            0x2
#define ADRV9025_SYSREF_PAD_PD                   0x1

#define ADRV9025_ADDR_SYSREF_CONTROL_1           0x0048
#define ADRV9025_SYSREF_BUFFER_ENABLE            0x40
#define ADRV9025_SYSREF_SAMPLE_ENABLE            0x10
#define ADRV9025_SYSREF_REGISTER_ENABLE          0x08

#define ADRV9025_ADDR_DEVICE_CLK_CONTROL_1       0x004A
#define ADRV9025_ADDR_REFCLK_CORE_0              0x0178
#define ADRV9025_ADDR_REFCLK_CORE_2              0x017A
#define ADRV9025_DCC1_RESETB_TFLASH              0x80
#define ADRV9025_DCC1_DEVCLK_DIVIDER_MCS_RESETB  0x10
#define ADRV9025_DCC1_DEVICE_CLK_DIVIDE_RATIO_MASK         0x0C
#define ADRV9025_DCC1_DEVICE_CLK_DIVIDE_RATIO_SHIFT        2
#define ADRV9025_DCC1_DEVICE_CLK_BUFFER_ENABLE   0x02
#define ADRV9025_DCC1_DEV_CLKBUF_OFFSET_EN       0x01

#define ADRV9025_DCC1_REFCLK_PLL_DRVR_STRENGTH   0x18
#define ADRV9025_DCC1_REFCLK_ROOT_DRVR_STRENGTH  0x18
#define ADRV9025_DCC1_REFCLK_DIGCORE_DRVR_STRENGTH  0xC0

#define ADRV9025_ADDR_TX_SYNC_PAD_CONFIG         0x0051
#define ADRV9025_TX_SYNC_DRV_SELECT_MASK         0xC0
#define ADRV9025_TX_SYNC_DRV_SELECT_SHIFT        6
#define ADRV9025_TX_SYNC2_PAD_LVSD_PN_INV        0x20
#define ADRV9025_TX_SYNC2_PAD_LVDS_MODE          0x10
#define ADRV9025_TX_SYNC2_PAD_PD                 0x08
#define ADRV9025_TX_SYNC1_PAD_LVSD_PN_INV        0x04
#define ADRV9025_TX_SYNC1_PAD_LVDS_MODE          0x02
#define ADRV9025_TX_SYNC1_PAD_PD                 0x01

#define ADRV9025_ADDR_RX_SYNC12_PAD_CONFIG       0x0052
#define ADRV9025_RX_SYNC2_PAD_ONCHIP_TERM        0x80
#define ADRV9025_RX_SYNC2_PAD_LVSD_PN_INV        0x40
#define ADRV9025_RX_SYNC2_PAD_LVDS_MODE          0x20
#define ADRV9025_RX_SYNC2_PAD_PD                 0x10
#define ADRV9025_RX_SYNC1_PAD_ONCHIP_TERM        0x08
#define ADRV9025_RX_SYNC1_PAD_LVSD_PN_INV        0x04
#define ADRV9025_RX_SYNC1_PAD_LVDS_MODE          0x02
#define ADRV9025_RX_SYNC1_PAD_PD                 0x01

#define ADRV9025_ADDR_RX_SYNC3_PAD_CONFIG        0x0053
#define ADRV9025_RX_SYNC3_PAD_ONCHIP_TERM        0x08
#define ADRV9025_RX_SYNC3_PAD_LVSD_PN_INV        0x04
#define ADRV9025_RX_SYNC3_PAD_LVDS_MODE          0x02
#define ADRV9025_RX_SYNC3_PAD_PD                 0x01

/* CPU-C subsystem register */
#define ADRV9025_CPU_C_ADDR_CTL_1                0x008C
#define ADRV9025_CPU_C_ADDR_BOOT_ADDR_BYTE0      0x0096
#define ADRV9025_CPU_C_ADDR_BOOT_ADDR_BYTE1      0x0097
#define ADRV9025_CPU_C_ADDR_BOOT_ADDR_BYTE2      0x0098
#define ADRV9025_CPU_C_ADDR_BOOT_ADDR_BYTE3      0x0099
#define ADRV9025_CPU_C_ADDR_STACK_PTR_BYTE0      0x009a
#define ADRV9025_CPU_C_ADDR_STACK_PTR_BYTE1      0x009b
#define ADRV9025_CPU_C_ADDR_STACK_PTR_BYTE2      0x009c
#define ADRV9025_CPU_C_ADDR_STACK_PTR_BYTE3      0x009d

/* CPU-D subsystem register */
# define ADRV9025_CPU_D_ADDR_CTL_1               0x015f
# define ADRV9025_CPU_D_ADDR_BOOT_ADDR_BYTE0     0x0160
# define ADRV9025_CPU_D_ADDR_BOOT_ADDR_BYTE1     0x0161
# define ADRV9025_CPU_D_ADDR_BOOT_ADDR_BYTE2     0x0162
# define ADRV9025_CPU_D_ADDR_BOOT_ADDR_BYTE3     0x0163
# define ADRV9025_CPU_D_ADDR_STACK_PTR_BYTE0     0x0164
# define ADRV9025_CPU_D_ADDR_STACK_PTR_BYTE1     0x0165
# define ADRV9025_CPU_D_ADDR_STACK_PTR_BYTE2     0x0166
# define ADRV9025_CPU_D_ADDR_STACK_PTR_BYTE3     0x0167

/* CPU subsystem mask */
#define ADRV9025_CPU_MASK_CTL1_DEBUG_ENABLE      0x80
#define ADRV9025_CPU_MASK_CTL1_MEM_HRESP         0x08
#define ADRV9025_CPU_MASK_CTL1_ERROR             0x02
#define ADRV9025_CPU_MASK_CTL1_M3_RUN            0x01
#define ADRV9025_CPU_MASK_DMA_CTL_RD_WRB         0x80
#define ADRV9025_CPU_MASK_DMA_CTL_SYS_CODEB      0x40
#define ADRV9025_CPU_MASK_DMA_CTL_BUS_WAITING    0x20
#define ADRV9025_CPU_MASK_DMA_CTL_BUS_RESPONSE   0x10
#define ADRV9025_CPU_MASK_DMA_CTL_BUS_SIZE       0x0C
#define ADRV9025_CPU_SHIFT_DMA_CTL_BUS_SIZE      0x2
#define ADRV9025_CPU_MASK_DMA_CTL_AUTO_INCR      0x02
#define ADRV9025_CPU_MASK_DMA_CTL_BUS_SELECT     0x01 /* write 1 for CPU-D, 0 for CPU-C */

/* DMA registers*/
#define ADRV9025_CPU_ADDR_DMA_CTL                0x00ba
#define ADRV9025_CPU_ADDR_DMA_ADDR0              0x00be  /* BUS_ADDR */
#define ADRV9025_CPU_ADDR_DMA_ADDR1              0x00bd
#define ADRV9025_CPU_ADDR_DMA_ADDR2              0x00bc
#define ADRV9025_CPU_ADDR_DMA_ADDR3              0x00bb
#define ADRV9025_CPU_ADDR_DMA_DATA0              0x00c2 /* MEM_WRITE_DATA */
#define ADRV9025_CPU_ADDR_DMA_DATA1              0x00c1
#define ADRV9025_CPU_ADDR_DMA_DATA2              0x00c0
#define ADRV9025_CPU_ADDR_DMA_DATA3              0x00bf

/* CPU-C mailbox registers */
#define ADRV9025_CPU_C_ADDR_COMMAND              0x00c3
#define ADRV9025_CPU_C_ADDR_EXT_CMD_BYTE_1       0x00c4
#define ADRV9025_CPU_C_ADDR_EXT_CMD_BYTE_2       0x00c5
#define ADRV9025_CPU_C_ADDR_EXT_CMD_BYTE_3       0x00c6
#define ADRV9025_CPU_C_ADDR_EXT_CMD_BYTE_4       0x00c7
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_0         0x00cb
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_1         0x00cc
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_2         0x00cd
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_3         0x00ce
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_4         0x00cf
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_5         0x00d0
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_6         0x00d1
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_7         0x00d2
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_8         0x00d3
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_9         0x00d4
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_10        0x00d5
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_11        0x00d6
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_12        0x00d7
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_13        0x00d8
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_14        0x00d9
#define ADRV9025_CPU_C_ADDR_CMD_STATUS_15        0x00da

/* CPU-D mailbox registers */
#define ADRV9025_CPU_D_ADDR_COMMAND              0x0147
#define ADRV9025_CPU_D_ADDR_EXT_CMD_BYTE_1       0x0148
#define ADRV9025_CPU_D_ADDR_EXT_CMD_BYTE_2       0x0149
#define ADRV9025_CPU_D_ADDR_EXT_CMD_BYTE_3       0x014a
#define ADRV9025_CPU_D_ADDR_EXT_CMD_BYTE_4       0x014b
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_0         0x014f
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_1         0x0150
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_2         0x0151
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_3         0x0152
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_4         0x0153
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_5         0x0154
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_6         0x0155
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_7         0x0156
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_8         0x0157
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_9         0x0158
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_10        0x0159
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_11        0x015a
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_12        0x015b
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_13        0x015c
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_14        0x015d
#define ADRV9025_CPU_D_ADDR_CMD_STATUS_15        0x015e

#define ADRV9025_ADDR_MASTERBIAS_CONFIG_0        0x0111
#define ADRV9025_CONFIG_0_PD_MASTERBIAS          0x80
#define ADRV9025_CONFIG_0_TRM_VBG_ABS            0x08

#define ADRV9025_ADDR_MASTERBIAS_CONFIG_1        0x0112
#define ADRV9025_CONFIG_1_TRM_VBG_TEMPCO         0x28

#define ADRV9025_ADDR_GP_LDO_BYTE1N              0x0120
#define ADRV9025_ADDR_DEV_CLK_LDO_BYTE1          0x0124
#define ADRV9025_ADDR_DEV_CLK_LDO_BYTE2          0x0125
#define ADRV9025_DEV_CLK_LDO_PD                  0x04

#define ADRV9025_ADDR_MCS_CONTROL_OFFSET         0x45
#define ADRV9025_ADDR_MCS_CONTROL_3_OFFSET       0x47

#define ADRV9025_ADDR_ALL_RX                     0x0200
#define ADRV9025_ADDR_ALL_TX                     0x0400
#define ADRV9025_ADDR_ALL_ORX                    0x0600
#define ADRV9025_ADDR_ALL_PLLS                   0x0800

#define ADRV9025_ADDR_CH0_RX                     0x1200
#define ADRV9025_ADDR_CH1_RX                     0x1400
#define ADRV9025_ADDR_CH2_RX                     0x1600
#define ADRV9025_ADDR_CH3_RX                     0x1800
#define ADRV9025_ADDR_CH0_ORX                    0x1A00
#define ADRV9025_ADDR_CH1_ORX                    0x1C00
#define ADRV9025_ADDR_CH0_TX                     0x1E00
#define ADRV9025_ADDR_CH1_TX                     0x2000
#define ADRV9025_ADDR_CH2_TX                     0x2200
#define ADRV9025_ADDR_CH3_TX                     0x2400
#define ADRV9025_ADDR_AUX_PLL                    0x2600
#define ADRV9025_ADDR_CLK_PLL                    0x2800
#define ADRV9025_ADDR_RF1_PLL                    0x2A00
#define ADRV9025_ADDR_RF2_PLL                    0x6400

#define ADRV9025_ADDR_RX_CLOCK_CONFIG_0_OFFSET   0x0001
#define ADRV9025_RCC0_CPU_CLK_ENABLE             0x80
#define ADRV9025_RCC0_CLKGEN_OUTPUT_BUFFER_EN    0x40
#define ADRV9025_RCC0_AGC_CLK_DIVIDE_RATIO_MASK  0x30
#define ADRV9025_RCC0_AGC_CLK_DIVIDE_RATIO_SHIFT 4
#define ADRV9025_RCC0_REG_CLK_DIVIDE_RATIO_MASK  0x0C
#define ADRV9025_RCC0_REG_CLK_DIVIDE_RATIO_SHIFT 2
#define ADRV9025_RCC0_CPU_CLK_DIVIDE_RATIO_MASK  0x03
#define ADRV9025_RCC0_CPU_CLK_DIVIDE_RATIO_SHIFT 0

#define ADRV9025_ADDR_RX_CLOCK_CONFIG_6_OFFSET   0x0007
#define ADRV9025_RCC6_RPFIR_CLK_DIVIDE_RATIO_MASK          0x03
#define ADRV9025_RCC6_RPFIR_CLK_DIVIDE_RATIO_SHIFT         0

#define ADRV9025_ADDR_RX_REFERENCE_CLOCK_CYCLE_OFFSET      0x000A
#define ADRV9025_ADDR_ORX_REFERENCE_CLOCK_CYCLE_OFFSET     0x000C
#define ADRV9025_ADDR_TX_REFERENCE_CLOCK_CYCLE_OFFSET      0x0008

#define ADRV9025_ADDR_TX_CLOCK_CONTROL_0_OFFSET  0x0003
#define ADRV9025_TCC0_CPU_CLK_ENABLE             0x80
#define ADRV9025_TCC0_TX_ENABLE_CG_GATES_CFR_CLOCKS        0x40
#define ADRV9025_TCC0_TX_ATTEN_CLK_DIVIDE_RATIO_MASK       0x30
#define ADRV9025_TCC0_TX_ATTEN_CLK_DIVIDE_RATIO_SHIFT      4
#define ADRV9025_TCC0_REG_CLK_DIVIDE_RATIO_MASK            0x0C
#define ADRV9025_TCC0_REG_CLK_DIVIDE_RATIO_SHIFT           2
#define ADRV9025_TCC0_CPU_CLK_DIVIDE_RATIO_MASK            0x03
#define ADRV9025_TCC0_CPU_CLK_DIVIDE_RATIO_SHIFT           0

#define ADRV9025_ADDR_TX_CLOCK_CONTROL_2_OFFSET  0x0005
#define ADRV9025_TCC2_TPFIR_CLK_DIVIDE_RATIO_MASK          0x03
#define ADRV9025_TCC2_TPFIR_CLK_DIVIDE_RATIO_SHIFT         0

#define ADRV9025_ADDR_TX_CLOCK_CONTROL_3_OFFSET  0x0006
#define ADRV9025_TCC3_TX_ATTEN_CLK_ENABLE_MASK             0x80
#define ADRV9025_TCC3_TX_ATTEN_CLK_ENABLE_SHIFT            7

#define ADRV9025_ADDR_TX_FILTER_CONFIG_OFFSET    0x0020
#define ADRV9025_TX_PFIR_TAPS_MASK               0x60
#define ADRV9025_TX_PFIR_TAPS_SHIFT              5
#define ADRV9025_TX_PFIR_GAIN_MASK               0x03
#define ADRV9025_TX_PFIR_GAIN_SHIFT              0

#define ADRV9025_ADDR_TX_PFIR_COEFF_CTL_OFFSET   0x0021
#define ADRV9025_PFIR_COEFF_PROG_CLK_EN          0x80
#define ADRV9025_PFIR_COEFF_WR_ENABLE            0x40
#define ADRV9025_PFIR_COEFF_AUTO_INCR            0x20
#define ADRV9025_ADDR_TX_PFIR_COEFF_DATA_OFFSET  0x0022
#define ADRV9025_ADDR_TX_PFIR_COEFF_ADDR_OFFSET  0x0023

#define ADRV9025_ADDR_RX_PFIR_SETTINGS_OFFSET    0x003a
#define ADRV9025_RX_PFIR_TAPS_MASK               0x30
#define ADRV9025_RX_PFIR_TAPS_SHIFT              4
#define ADRV9025_RX_PFIR_GAIN_MASK               0x0C
#define ADRV9025_RX_PFIR_GAIN_SHIFT              2
#define ADRV9025_RX_PFIR_DECIMATION_MASK         0x03
#define ADRV9025_RX_PFIR_DECIMATION_SHIFT        0

#define ADRV9025_ADDR_RX_PFIR_COEFF_CTL_OFFSET   0x003b
#define ADRV9025_ADDR_RX_PFIR_COEFF_DATA_OFFSET  0x003c
#define ADRV9025_ADDR_RX_PFIR_COEFF_ADDR_OFFSET  0x003d

#define ADRV9025_ADDR_ORX_PFIR_COEFF_CTL_OFFSET  0x0013
#define ADRV9025_ADDR_ORX_PFIR_COEFF_DATA_OFFSET 0x0014
#define ADRV9025_ADDR_ORX_PFIR_COEFF_ADDR_OFFSET 0x0015
#define ADRV9025_PFIR_COEFF_RX_C_SEL             0x04
#define ADRV9025_PFIR_COEFF_RX_B_SEL             0x02
#define ADRV9025_PFIR_COEFF_RX_A_SEL             0x01

#define ADRV9025_ADDR_RX_PFIR_CONFIG_SETTINGSN_OFFSET      0x001a

#define ADRV9025_ADDR_RX_PFIR_BANK_SEL_OFFSET    0x0019
#define ADRV9025_PFIR_CONFIG_FOR_ORX_2_MASK      0xC0
#define ADRV9025_PFIR_CONFIG_FOR_ORX_2_SHIFT     6
#define ADRV9025_PFIR_CONFIG_FOR_ORX_1_MASK      0x30
#define ADRV9025_PFIR_CONFIG_FOR_ORX_1_SHIFT     4
#define ADRV9025_PFIR_CONFIG_FOR_LOOPBACK_2_MASK 0x0C
#define ADRV9025_PFIR_CONFIG_FOR_LOOPBACK_2_SHIFT 2
#define ADRV9025_PFIR_CONFIG_FOR_LOOPBACK_1_MASK 0x03
#define ADRV9025_PFIR_CONFIG_FOR_LOOPBACK_1_SHIFT 0

#define ADRV9025_ADDR_PLL_POWER_DOWNS            0x0050

#define ADRV9025_ADDR_MAIN_STREAM_CTL_OFFSET     0x00DB
#define ADRV9025_ADDR_TX0_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH0_TX+0x00AD
#define ADRV9025_ADDR_TX1_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH1_TX+0x00AD
#define ADRV9025_ADDR_TX2_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH2_TX+0x00AD
#define ADRV9025_ADDR_TX3_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH3_TX+0x00AD
#define ADRV9025_ADDR_RX0_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH0_RX+0x01A8
#define ADRV9025_ADDR_RX1_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH1_RX+0x01A8
#define ADRV9025_ADDR_RX2_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH2_RX+0x01A8
#define ADRV9025_ADDR_RX3_STREAM_CTL_OFFSET      ADRV9025_ADDR_CH3_RX+0x01A8
#define ADRV9025_ADDR_ORX0_STREAM_CTL_OFFSET     ADRV9025_ADDR_CH0_ORX+0x0173
#define ADRV9025_ADDR_ORX1_STREAM_CTL_OFFSET     ADRV9025_ADDR_CH1_ORX+0x0173
#define ADRV9025_STREAM_RESET                    0x01
#define ADRV9025_STREAM_BASE_BYTE0_OFFSET        1
#define ADRV9025_STREAM_BASE_BYTE1_OFFSET        2
#define ADRV9025_LAST_STREAM_NUMBER_OFFSET       3

#define ADRV9025_ADDR_PLL_REF_CLK_REG            0x28D0
#define ADRV9025_REF_CLK_DIVIDE_RATIO_MASK       0x03
#define ADRV9025_REF_CLK_DIVIDE_RATIO_SHIFT      0

#define ADRV9025_ADDR_SYSREF_DES_MASTER_PD       0x6800
#define ADRV9025_ADDR_SYSREF_DES_PHY_PD          0x6801

#define ADRV9025_ADDR_JTX_COMMON_0               0x00006689
#define ADRV9025_ADDR_JRX_COMMON_0               0x0000667C

#define ADRV9025_ADDR_RXALL_BBIC_ENABLE             0x03BD
#define ADRV9025_ADDR_TXALL_BBIC_ENABLE             0x04E8
#define ADRV9025_ADDR_RXALL_DEC_OVERLOAD_CONFIG2    0x02F5
#define ADRV9025_ADDR_DEC_OVERLOAD_CONFIG2_OFFSET   0x00F5

#define ADRV9025_ADDR_RX_DECIMATED_PWR_OFFSET       0x00C1
#define ADRV9025_ADDR_ORX_DECIMATED_PWR_OFFSET      0x0034

#define ADRV9025_ADDR_RX_DIGITAL_GAIN_CONFIG2_OFFSET       0x00C8
#define ADRV9025_ADDR_ORX_DIGITAL_GAIN_CONFIG2_OFFSET      0x0039

#define ADRV9025_ADDR_RX_DEC_POWER_CONFIG1_OFFSET   0x00B2
#define ADRV9025_ADDR_ORX_DEC_POWER_CONFIG1_OFFSET  0x002D

#define ADRV9025_ADDR_DPD_ADP_MMR_ADP_INT           0x6200C10CU
#define ADRV9025_ADDR_DPD_ACT_MMR_CAP_STAT_TX1      0xA082011CU
#define ADRV9025_ADDR_DPD_ACT_MMR_CAP_STAT_TX2      0xA882011CU
#define ADRV9025_ADDR_DPD_ACT_MMR_CAP_STAT_TX3      0xB082011CU
#define ADRV9025_ADDR_DPD_ACT_MMR_CAP_STAT_TX4      0xB882011CU
#define ADRV9025_ADDR_DPD_ACT_MMR_STAT_TX1          0xA08200F0U
#define ADRV9025_ADDR_DPD_ACT_MMR_STAT_TX2          0xA88200F0U
#define ADRV9025_ADDR_DPD_ACT_MMR_STAT_TX3          0xB08200F0U
#define ADRV9025_ADDR_DPD_ACT_MMR_STAT_TX4          0xB88200F0U
#define ADRV9025_ADDR_DPD_TX_CAPTURE_DATA           0x62000000U
#define ADRV9025_ADDR_DPD_ALT_TX_CAPTURE_DATA       0x62008000U

#define ADRV9025_ADDR_DPD_ORX_CAPTURE_DATA          0x62004000U

#define ADRV9025_ADDR_DPD_ACT_MMR_LUT_OFF_TX1       0xA0820088U
#define ADRV9025_ADDR_DPD_ACT_MMR_LUT_OFF_TX2       0xA8820088U
#define ADRV9025_ADDR_DPD_ACT_MMR_LUT_OFF_TX3       0xB0820088U
#define ADRV9025_ADDR_DPD_ACT_MMR_LUT_OFF_TX4       0xB8820088U

#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_CFG_TX1       0xA0820000U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_CFG_TX2       0xA8820000U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_CFG_TX3       0xB0820000U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_CFG_TX4       0xB8820000U

#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_MOD_TX1       0xA0820004U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_MOD_TX2       0xA8820004U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_MOD_TX3       0xB0820004U
#define ADRV9025_ADDR_DPD_ACT_MMR_DPD_MOD_TX4       0xB8820004U

#define ADRV9025_EXT_DPD_ACTUATOR_TX1_LUT_BASEADDR  0xA0800000U
#define ADRV9025_EXT_DPD_ACTUATOR_TX2_LUT_BASEADDR  0xA8800000U
#define ADRV9025_EXT_DPD_ACTUATOR_TX3_LUT_BASEADDR  0xB0800000U
#define ADRV9025_EXT_DPD_ACTUATOR_TX4_LUT_BASEADDR  0xB8800000U

#define ADRV9025_DES_CBUS_CONTROL_ADDRESS       0x6805
#define ADRV9025_DES_CBUS_PHY_WSTROBE           0x6806
#define ADRV9025_DES_CBUS_DATA_WRITE            0x6808
#define ADRV9025_DES_CBUS_CONTROL_CHANNEL       0x6809
#define ADRV9025_DES_CBUS_PLL_SELECT            0x680A
#define ADRV9025_DES_CBUS_DATA_READBACK         0x680B

#ifdef __cplusplus
}
#endif

#endif
