// SPDX-License-Identifier: GPL-2.0
/**
 * \file mykonos_macros.h
 * \brief Contains address and miscellaneous macro definitions for Mykonos API
 *
 * Mykonos API version: 1.5.2.3566
 */

/**
* \page Disclaimer Legal Disclaimer
* Copyright 2015-2017 Analog Devices Inc.
* Released under the AD9371 API license, for more information see the "LICENSE.txt" file in this zip file.
*
*/

#ifndef CLEMENTE_TDD_MACROS_H
#define CLEMENTE_TDD_MACROS_H

#ifdef __cplusplus
extern "C" {
#endif

#define MYKONOS_ADDR_CONFIGURATION_CONTROL_0                0x000
#define MYKONOS_ADDR_SPI_CONFIGURATION_CONTROL_1            0x001
#define MYKONOS_ADDR_PRODUCT_ID                             0x004
#define MYKONOS_GPIO_DRV_CTL_0                              0x020
#define MYKONOS_GPIO_DRV_CTL_1                              0x021
#define MYKONOS_GPIO_SLEW_CTL_0                             0x022
#define MYKONOS_GPIO_SLEW_CTL_1                             0x023
#define MYKONOS_GPIO_SLEW_CTL_2                             0x024
#define MYKONOS_GPIO_SLEW_CTL_3                             0x025

#define MYKONOS_ADDR_DIGITAL_IO_CONTROL                     0x028

#define MYKONOS_ADDR_SYSREF_PAD_CONFIG                      0x040
#define MYKONOS_ADDR_TX1_SYNC_PAD_CONFIG                    0x041
#define MYKONOS_ADDR_TX2_SYNC_PAD_CONFIG                    0x042
#define MYKONOS_ADDR_RX1_SYNC_CONFIG                        0x043
#define MYKONOS_ADDR_RX2_SYNC_CONFIG                        0x044

/* Mykonos Framer Registers */
#define MYKONOS_ADDR_FRAMER_RESET                           0x059
#define MYKONOS_ADDR_FRAMER_CLK_EN                          0x05A
#define MYKONOS_ADDR_FRAMER_ADDR                            0x05B
#define MYKONOS_ADDR_FRAMER_DATA                            0x05C
#define MYKONOS_ADDR_FRAMER_WRITE_EN                        0x05D
#define MYKONOS_ADDR_FRAMER_SYSREF_FIFO_EN                  0x05E
#define MYKONOS_ADDR_FRAMER_CONFIG_F                        0x05F
#define MYKONOS_ADDR_FRAMER_LANE_CTL                        0x060
#define MYKONOS_ADDR_FRAMER_ADC_XBAR_SEL                    0x061
#define MYKONOS_ADDR_FRAMER_LANE_XBAR_SEL                   0x062
#define MYKONOS_ADDR_FRAMER_CONFIG_LOOPBACK_XBAR_REV        0x063
#define MYKONOS_ADDR_FRAMER_SYNCN_FILT                      0x064
#define MYKONOS_ADDR_FRAMER_LMFC_F_OFFSET                   0x065
#define MYKONOS_ADDR_FRAMER_LMFC_K_OFFSET                   0x066
#define MYKONOS_ADDR_FRAMER_TEST_CNTR_CTL                   0x067
#define MYKONOS_ADDR_FRAMER_STATUS_STRB                     0x068
#define MYKONOS_ADDR_FRAMER_STATUS                          0x069
#define MYKONOS_ADDR_FRAMER_SYSREF_TO_LMFC_CNTR_STAT        0x06A
#define MYKONOS_ADDR_FRAMER_SYSREF_TO_LMFC_ERR_MARGIN       0x06B
#define MYKONOS_ADDR_FRAMER_LANE_FIFO_STRB                  0x06C
#define MYKONOS_ADDR_FRAMER_LANE0_FIFO_RDWR_ADDR            0x06D
#define MYKONOS_ADDR_FRAMER_LANE1_FIFO_RDWR_ADDR            0x06E
#define MYKONOS_ADDR_FRAMER_LANE2_FIFO_RDWR_ADDR            0x06F
#define MYKONOS_ADDR_FRAMER_LANE3_FIFO_RDWR_ADDR            0x070
#define MYKONOS_ADDR_FRAMER_PRBS10_CTL                      0x071
#define MYKONOS_ADDR_FRAMER_PRBS20_CTL                      0x072
#define MYKONOS_ADDR_FRAMER_PATTERN_GEN_EN                  0x073
#define MYKONOS_ADDR_FRAMER_PATTERN_GEN_7_TO_0              0x074
#define MYKONOS_ADDR_FRAMER_PATTERN_GEN_15_TO_8             0x075
#define MYKONOS_ADDR_FRAMER_PATTERN_GEN_19_TO_16            0x076
#define MYKONOS_ADDR_FRAMER_CONFIG_JTX_GEN                  0x077
#define MYKONOS_ADDR_FRAMER_LANE_DATA_CTL                   0x078
#define MYKONOS_ADDR_FRAMER_DATA_SAMPLE_CTL                 0x079

/* Mykonos Deframer Sub Address Map */
#define MYKONOS_SUBADDR_DEFRAMER_LANE0_ILAS_RECVD           0x00
#define MYKONOS_SUBADDR_DEFRAMER_LANE0_ILAS_CFG             0x50

/* Mykonos Deframer Registers */
#define MYKONOS_ADDR_DEFRAMER_RESET                         0x07A
#define MYKONOS_ADDR_DEFRAMER_CLK_EN                        0x07B
#define MYKONOS_ADDR_DEFRAMER_ADDR                          0x07C
#define MYKONOS_ADDR_DEFRAMER_DATA                          0x07D
#define MYKONOS_ADDR_DEFRAMER_WR_EN                         0x07E
#define MYKONOS_ADDR_DEFRAMER_SYSREF_FIFO_EN                0x07F
#define MYKONOS_ADDR_DEFRAMER_CONFIG_F                      0x080
#define MYKONOS_ADDR_DEFRAMER_LANE_FIFO_CTL                 0x081
#define MYKONOS_ADDR_DEFRAMER_DAC_XBAR_SEL                  0x082
#define MYKONOS_ADDR_DEFRAMER_LANE_XBAR_SEL                 0x083
#define MYKONOS_ADDR_DEFRAMER_LMFC_F_OFFSET                 0x084
#define MYKONOS_ADDR_DEFRAMER_LMFC_K_OFFSET                 0x085
#define MYKONOS_ADDR_DEFRAMER_CONFIG_SYNC_USER_DATA_CTL     0x086
#define MYKONOS_ADDR_DEFRAMER_SYNC_REQ_RETIME               0x087
#define MYKONOS_ADDR_DEFRAMER_TEST                          0x088
#define MYKONOS_ADDR_DEFRAMER_DET_FIFO_WR_STRT_DAC_XBAR_REV 0x089
#define MYKONOS_ADDR_DEFRAMER_STAT_STRB                     0x08A
#define MYKONOS_ADDR_DEFRAMER_STAT                          0x08B
#define MYKONOS_ADDR_DEFRAMER_TEST_ERR_CNT_STAT             0x08C
#define MYKONOS_ADDR_DEFRAMER_DET_FIFO_RD_ADDR              0x08D
#define MYKONOS_ADDR_DEFRAMER_DET_FIFO_WR_ADDR              0x08E
#define MYKONOS_ADDR_DEFRAMER_QBLMFC_VS_EXTLMFC_CNTR_STAT   0x08F
#define MYKONOS_ADDR_DEFRAMER_DET_FIFO_STAT                 0x090
#define MYKONOS_ADDR_DEFRAMER_STRT_RD_DEL_STOP_WR           0x091
#define MYKONOS_ADDR_DEFRAMER_FIFO_SAMPLE_SPI_ADDR_RD       0x092
#define MYKONOS_ADDR_DEFRAMER_FIFO_BYTE_SPI_ADDR_RD         0x093
#define MYKONOS_ADDR_DEFRAMER_FIFO_BYTE_SPI_DATA_RD         0x094
#define MYKONOS_ADDR_DEFRAMER_SAMPLE0_7_TO_0                0x095
#define MYKONOS_ADDR_DEFRAMER_SAMPLE0_15_TO_8               0x096
#define MYKONOS_ADDR_DEFRAMER_SAMPLE1_7_TO_0                0x097
#define MYKONOS_ADDR_DEFRAMER_SAMPLE1_15_TO_8               0x098
#define MYKONOS_ADDR_DEFRAMER_SAMPLE2_7_TO_0                0x099
#define MYKONOS_ADDR_DEFRAMER_SAMPLE2_15_TO_8               0x09A
#define MYKONOS_ADDR_DEFRAMER_SAMPLE3_7_TO_0                0x09B
#define MYKONOS_ADDR_DEFRAMER_SAMPLE3_15_TO_8               0x09C
#define MYKONOS_ADDR_DEFRAMER_LANE_FIFO_STRB                0x09D
#define MYKONOS_ADDR_DEFRAMER_LANE0_FIFO_RDWR_ADDR          0x09E
#define MYKONOS_ADDR_DEFRAMER_LANE1_FIFO_RDWR_ADDR          0x09F
#define MYKONOS_ADDR_DEFRAMER_LANE2_FIFO_RDWR_ADDR          0x0A0
#define MYKONOS_ADDR_DEFRAMER_LANE3_FIFO_RDWR_ADDR          0x0A1
#define MYKONOS_ADDR_DEFRAMER_SYSREF_TO_LMFC_CNTR_STAT      0x0A2
#define MYKONOS_ADDR_DEFRAMER_SYSREF_TO_LMFC_ERR_MARGIN     0x0A3
#define MYKONOS_ADDR_DEFRAMER_PRBS10_CTL                    0x0A4
#define MYKONOS_ADDR_DEFRAMER_PRBS20_CTL                    0x0A5
#define MYKONOS_ADDR_DEFRAMER_PRBS20_STRB_CHKSUM_TYPE       0x0A6
#define MYKONOS_ADDR_DEFRAMER_PRBS20_ERR_CNTR_7_TO_0        0x0A7
#define MYKONOS_ADDR_DEFRAMER_PRBS20_ERR_CNTR_15_TO_8       0x0A8
#define MYKONOS_ADDR_DEFRAMER_PRBS20_ERR_CNTR_23_TO_16      0x0A9
#define MYKONOS_ADDR_DEFRAMER_LANE_DATA_CTL                 0x0AA
#define MYKONOS_ADDR_DEFRAMER_STATUS_2                      0x0AB
#define MYKONOS_ADDR_DEFRAMER_DET_FIFO_PHASE                0x0AC

/* Mykonos Serializer Registers */
#define MYKONOS_ADDR_SERIALIZER_CTL_0                       0x0B0
#define MYKONOS_ADDR_SERIALIZER_CTL_1                       0x0B1
#define MYKONOS_ADDR_SERIALIZER_CTL_2                       0x0B2
#define MYKONOS_ADDR_SERIALIZER_CTL_3                       0x0B3
#define MYKONOS_ADDR_SERIALIZER_HS_DIV_TXSER_CLK_EN         0x0B4
#define MYKONOS_ADDR_SERIALIZER_SPECIAL                     0x0B5

/* Mykonos Deserializer Registers */
#define MYKONOS_ADDR_DESERIALIZER_PDET_CTL                  0x0BC
#define MYKONOS_ADDR_DESERIALIZER_CTL_0                     0x0BD
#define MYKONOS_ADDR_DESERIALIZER_SIN_SHAPE_0               0x0BE
#define MYKONOS_ADDR_DESERIALIZER_SIN_SHAPE_1               0x0BF
#define MYKONOS_ADDR_DESERIALIZER_EQ_CTL_0                  0x0C1
#define MYKONOS_ADDR_DESERIALIZER_EQ_CTL_1                  0x0C2
#define MYKONOS_ADDR_DESERIALIZER_MISC_CTL                  0x0C3
#define MYKONOS_ADDR_DESERIALIZER_EQ_HP_EN                  0x0C4
#define MYKONOS_ADDR_DESERIALIZER_EQ_CTL_1_TO_0             0x0C5
#define MYKONOS_ADDR_DESERIALIZER_EQ_CTL_3_TO_2             0x0C6
#define MYKONOS_ADDR_DESERIALIZER_HS_DIV_RXCDR_CLK_EN       0x0CD
#define MYKONOS_ADDR_DESERIALIZER_SPECIAL                   0x0CE
#define MYKONOS_ADDR_DESERIALIZER_CDR_CAL_CTL               0x0D0

#define MYKONOS_ADDR_CONFIGURATION_CONTROL_1                0x100
#define MYKONOS_ADDR_CONFIGURATION_CONTROL_2                0x101
#define MYKONOS_ADDR_CONFIGURATION_CONTROL_4                0x102
#define MYKONOS_ADDR_CONFIGURATION_CONTROL_5                0x103
#define MYKONOS_ADDR_DPD_SNIFFER_CONFIGURATION_CONTROL_1    0x104
#define MYKONOS_ADDR_DPD_SNIFFER_CONFIGURATION_CONTROL_2    0x105
#define MYKONOS_ADDR_DPD_SNIFFER_GPIO_SELECT                0x106
#define MYKONOS_ADDR_SNIFFER_CONFIGURATION_CONTROL          0x107
#define MYKONOS_ADDR_DPD_CONFIGURATION_CONTROL              0x108
#define MYKONOS_ADDR_LOOPBACK_CONFIGURATION_CONTROL         0x109

#define MYKONOS_ADDR_CLOCK_CONTROL_0						0x117
#define MYKONOS_ADDR_CLOCK_CONTROL_1						0x118
#define MYKONOS_ADDR_CLOCK_CONTROL_2						0x119
#define MYKONOS_ADDR_CLOCK_CONTROL_3						0x11A
#define MYKONOS_ADDR_CLOCK_CONTROL_4						0x11B
#define MYKONOS_ADDR_CLOCK_CONTROL_5                        0x11C

#define MYKONOS_ADDR_MCS_CONTROL                            0x120
#define MYKONOS_ADDR_MCS_STATUS                             0x121

/* CLK PLL Registers */
#define MYKONOS_ADDR_CLK_SYNTH_DIVIDER_INT_BYTE0            0x141
#define MYKONOS_ADDR_CLK_SYNTH_DIVIDER_INT_BYTE1            0x142
#define MYKONOS_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE0           0x143
#define MYKONOS_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE1           0x144
#define MYKONOS_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE2           0x145
#define MYKONOS_ADDR_CLK_SYNTH_F_VCOTN_BYTE1                0x148
#define MYKONOS_ADDR_CLK_SYNTH_BYTE1                        0x149
#define MYKONOS_ADDR_CLK_SYNTH_BYTE2                        0x14A
#define MYKONOS_ADDR_CLK_SYNTH_BYTE3                        0x14B
#define MYKONOS_ADDR_CLK_SYNTH_BYTE5                        0x14D
#define MYKONOS_ADDR_CLK_SYNTH_BYTE6                        0x14E
#define MYKONOS_ADDR_CLK_SYNTH_BYTE7                        0x14F
#define MYKONOS_ADDR_CLK_SYNTH_LF_R3                        0x150
#define MYKONOS_ADDR_CLK_SYNTH_BYTE9                        0x152
#define MYKONOS_ADDR_CLK_SYNTH_CAL_STAT                     0x154
#define MYKONOS_ADDR_CLK_SYNTH_VCO_CAL_REF                  0x155
#define MYKONOS_ADDR_CLK_SYNTH_VCO_BAND_BYTE1               0x157
#define MYKONOS_ADDR_CLK_SYNTH_CAL_CONTROL                  0x159
#define MYKONOS_ADDR_CLK_SYNTH_VCO_VAR_CTL1                 0x15E
#define MYKONOS_ADDR_CLK_SYNTH_VCO_VAR_CTL2                 0x15F

/* DPD Registers */
#define MYKONOS_ADDR_TX1_DPD_MODEL_INDIRECT_PTR             0x178
#define MYKONOS_ADDR_TX2_DPD_MODEL_INDIRECT_PTR             0x17C
#define MYKONOS_ADDR_DPD_RMS_BUF_SIZE                       0x180
#define MYKONOS_ADDR_TX1_DPD_MODEL_WORKING_PTR              0x188
#define MYKONOS_ADDR_TX2_DPD_MODEL_WORKING_PTR              0x18C

/* Rx NCO Control registers */
#define MYKONOS_ADDR_CALPLL_SDM_CONTROL                     0x17F
#define MYKONOS_ADDR_RX_NCO_CONTROL                         0x190
#define MYKONOS_ADDR_RX_NCO_CH1_FTW_BYTE_3                  0x191
#define MYKONOS_ADDR_RX_NCO_CH1_FTW_BYTE_2                  0x192
#define MYKONOS_ADDR_RX_NCO_CH1_FTW_BYTE_1                  0x193
#define MYKONOS_ADDR_RX_NCO_CH2_FTW_BYTE_3                  0x194
#define MYKONOS_ADDR_RX_NCO_CH2_FTW_BYTE_2                  0x195
#define MYKONOS_ADDR_RX_NCO_CH2_FTW_BYTE_1                  0x196
#define MYKONOS_ADDR_RX_NCO_DPD_SNIFFER_FTW_BYTE_3          0x197
#define MYKONOS_ADDR_RX_NCO_DPD_SNIFFER_FTW_BYTE_2          0x198
#define MYKONOS_ADDR_RX_NCO_DPD_SNIFFER_FTW_BYTE_1          0x199

#define MYKONOS_ADDR_ENSM_CONFIG_7_0                        0x1B0
#define MYKONOS_ADDR_CALIBRATION_CONTROL                    0x1B2
#define MYKONOS_ADDR_ENSM_MANUAL_GAIN_LOCK_GPIO_SELECT      0x1B5
#define MYKONOS_ADDR_REFERENCE_CLOCK_CYCLES                 0x1C0
#define MYKONOS_ADDR_TX_PD_OVERIDE_7_0                      0x209
#define MYKONOS_ADDR_RCAL_CONTROL                           0x224
#define MYKONOS_ADDR_REF_PAD_CONFIG1                        0x230
#define MYKONOS_ADDR_REF_PAD_CONFIG2                        0x231

#define MYKONOS_ADDR_RXSYNTH_CP_CAL_STAT                    0x254
#define MYKONOS_ADDR_RXSYNTH_VCO_BAND_BYTE1                 0x257
#define MYKONOS_ADDR_TXSYNTH_CP_CAL_STAT                    0x2C4
#define MYKONOS_ADDR_TXSYNTH_VCO_BAND_BYTE1                 0x2C7
#define MYKONOS_ADDR_SNIFF_RXSYNTH_CP_CAL_STAT              0x354
#define MYKONOS_ADDR_SNIFF_RXSYNTH_VCO_BAND_BYTE1           0x357
#define MYKONOS_ADDR_SNIFF_RXLOGEN_BYTE1                    0x380

#define MYKONOS_ADDR_RX_FILTER_CONFIGURATION                0x410
#define MYKONOS_ADDR_RX_FILTER_GAIN                         0x411
#define MYKONOS_ADDR_DPD_SNIFFER_RX_FILTER_GAIN             0x412

/* Mykonos Temperature Gain Compensation Registers */
#define MYKONOS_ADDR_RX1_TEMP_GAIN_COMP                     0x420
#define MYKONOS_ADDR_RX2_TEMP_GAIN_COMP                     0x421
#define MYKONOS_ADDR_OBS_TEMP_GAIN_COMP                     0x422

/* Mykonos AGC General Registers */
#define MYKONOS_ADDR_AGC_CFG_1                              0x42E
#define MYKONOS_ADDR_AGC_CFG_2                              0x42F
#define MYKONOS_ADDR_AGC_GAIN_CHANGE_GPIO_SEL               0x430
#define MYKONOS_ADDR_AGC_RX1_MAX_GAIN_INDEX                 0x431
#define MYKONOS_ADDR_AGC_RX1_MIN_GAIN_INDEX                 0x432
#define MYKONOS_ADDR_AGC_MANUAL_GAIN_CFG                    0x433
#define MYKONOS_ADDR_AGC_MANUAL_GAIN_GPIO_SEL               0x434
#define MYKONOS_ADDR_AGC_MANUAL_GAIN_INDEX_CH_1             0x435
#define MYKONOS_ADDR_AGC_MANUAL_GAIN_INDEX_CH_2             0x436
#define MYKONOS_ADDR_AGC_LOCK_LEVEL                         0x437
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_1                   0x438
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_2                   0x439
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_3                   0x43A
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_4                   0x43B
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_5                   0x43C
#define MYKONOS_ADDR_AGC_OVRG_GAIN_STEP_6                   0x43D
#define MYKONOS_ADDR_AGC_RX1_GAIN_LOCK_DELAY                0x43E
#define MYKONOS_ADDR_AGC_RX2_GAIN_LOCK_DELAY                0x43F
#define MYKONOS_ADDR_AGC_RX1_ATTACK_DELAY                   0x440
#define MYKONOS_ADDR_AGC_RX2_ATTACK_DELAY                   0x441
#define MYKONOS_ADDR_AGC_ULB_THRSH                          0x442
#define MYKONOS_ADDR_AGC_LLB_THRSH                          0x443
#define MYKONOS_ADDR_AGC_RX_BLOCK_DET_DECAY                 0x444
#define MYKONOS_ADDR_AGC_RESET_PD_HIGH_CNT                  0x445
#define MYKONOS_ADDR_AGC_RX2_MAX_GAIN_INDEX                 0x446
#define MYKONOS_ADDR_AGC_RX2_MIN_GAIN_INDEX                 0x447
#define MYKONOS_ADDR_AGC_ORX_SNRX_CFG_1                     0x448
#define MYKONOS_ADDR_AGC_ORX_SNRX_CFG_2                     0x449
#define MYKONOS_ADDR_AGC_ORX_SNRX_MAX_GAIN_INDEX            0x44A
#define MYKONOS_ADDR_AGC_ORX_SNRX_MIN_GAIN_INDEX            0x44B
#define MYKONOS_ADDR_AGC_ORX_SNRX_MANUAL_GAIN_CFG           0x44C
#define MYKONOS_ADDR_AGC_ORX_SNRX_GPIO_SEL                  0x44D
#define MYKONOS_ADDR_AGC_ORX_SNRX_LOCK_LEVEL                0x44E
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_1          0x44F
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_2          0x450
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_3          0x451
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_4          0x452
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_5          0x453
#define MYKONOS_ADDR_AGC_ORX_SNRX_OVRG_GAIN_STEP_6          0x454
#define MYKONOS_ADDR_AGC_ORX_SNRX_GAIN_LOCK_DELAY           0x455
#define MYKONOS_ADDR_AGC_ORX_SNRX_ATTACK_DELAY              0x456
#define MYKONOS_ADDR_AGC_ORX_SNRX_ULB_THRSH                 0x457
#define MYKONOS_ADDR_AGC_ORX_SNRX_LLB_THRSH                 0x458
#define MYKONOS_ADDR_AGC_ORX_SNRX_BLOCK_DET_DECAY           0x459
#define MYKONOS_ADDR_AGC_ORX_SNRX_RESET_PD_HIGH_CNT         0x45A
#define MYKONOS_ADDR_AGC_ORX1_MANUAL_GAIN_INDEX             0x45B
#define MYKONOS_ADDR_AGC_ORX2_MANUAL_GAIN_INDEX             0x45C
#define MYKONOS_ADDR_AGC_SNRX_MANUAL_GAIN_INDEX             0x45D
#define MYKONOS_ADDR_AGC_LOOPBACK1_MANUAL_GAIN_INDEX        0x45E
#define MYKONOS_ADDR_AGC_LOOPBACK2_MANUAL_GAIN_INDEX        0x45F
#define MYKONOS_ADDR_AGC_ORX_SNRX_ACTIVE                    0x460

/* Mykonos Fast Attack AGC Registers */
#define MYKONOS_ADDR_AGC_FAST_CFG_1                         0x468
#define MYKONOS_ADDR_AGC_FAST_CFG_2                         0x469
#define MYKONOS_ADDR_AGC_FAST_ENRGY_LOST_THRSH              0x46A
#define MYKONOS_ADDR_AGC_FAST_STRONG_SIG_THRSH              0x46B
#define MYKONOS_ADDR_AGC_FAST_SETTING_DELAY                 0x46C
#define MYKONOS_ADDR_AGC_FAST_OPT_MAX_GAIN                  0x46D
#define MYKONOS_ADDR_AGC_FAST_ENRGY_DET_CNT                 0x46E
#define MYKONOS_ADDR_AGC_FAST_AGCLL_UPPER_LIMIT             0x46F
#define MYKONOS_ADDR_AGC_FAST_GAIN_LOCK_EXIT_CNT            0x470
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_CFG_1                0x471
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_CFG_2                0x472
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_ENRGY_LOST_THRSH     0x473
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_STRONG_SIG_THRSH     0x474
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_SET_DELAY            0x475
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_OPT_MAX_GAIN         0x476
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_ENRGY_DET_CNT        0x477
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_AGCLL_UPPER_LIMIT    0x478
#define MYKONOS_ADDR_AGC_FAST_ORX_SNRX_GAIN_LOCK_EXIT_CNT   0x479

/* Mykonos Slow Loop - Hybrid AGC Registers */
#define MYKONOS_ADDR_AGC_SLOW_LOCK_LEV_THRSH                    0x480
#define MYKONOS_ADDR_AGC_SLOW_ULB_CNT_THRSH                     0x481
#define MYKONOS_ADDR_AGC_SLOW_LLB_CNT_THRSH                     0x482
#define MYKONOS_ADDR_AGC_SLOW_HIGH_OVRG_CNT_THRSH               0x483
#define MYKONOS_ADDR_AGC_SLOW_LOW_OVRG_CNT_THRSH                0x484
#define MYKONOS_ADDR_AGC_SLOW_VERYLOW_OVRG_CNT_THRSH            0x485
#define MYKONOS_ADDR_AGC_SLOW_DIG_SAT_CNT_THRSH                 0x486
#define MYKONOS_ADDR_AGC_SLOW_UPPER0_THRSH_GAIN_STEP            0x487
#define MYKONOS_ADDR_AGC_SLOW_LOWER0_THRSH_GAIN_STEP            0x488
#define MYKONOS_ADDR_AGC_SLOW_UPPER1_THRSH_GAIN_STEP            0x489
#define MYKONOS_ADDR_AGC_SLOW_LOWER1_THRSH_GAIN_STEP            0x48A
#define MYKONOS_ADDR_AGC_SLOW_GAIN_UPDATE_CNT_1                 0x48B
#define MYKONOS_ADDR_AGC_SLOW_GAIN_UPDATE_CNT_2                 0x48C
#define MYKONOS_ADDR_AGC_SLOW_GAIN_UPDATE_CNT_3                 0x48D
#define MYKONOS_ADDR_AGC_SLOW_LOOP_CFG                          0x48E
#define MYKONOS_ADDR_AGC_SLOW_POWER_THRSH                       0x48F
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_LOCK_LEV_THRSH           0x490

#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_ULB_CNT_THRSH                0x491
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_LLB_CNT_THRSH                0x492
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_ADC_HIGH_OVRG_CNT_THRSH      0x493
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_ADC_LOW_OVRG_CNT_THRSH       0x494
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_ADC_VERYLOW_OVRG_CNT_THRSH   0x495

#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_DIG_SAT_CNT_THRSH        0x496
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UPPER0_THRSH_GAIN_STEP   0x497
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_LOWER0_THRSH_GAIN_STEP   0x498
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UPPER1_THRSH_GAIN_STEP   0x499
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_LOWER1_THRSH_GAIN_STEP   0x49A
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_GAIN_UPDATE_CTR_1        0x49B
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_GAIN_UPDATE_CTR_2        0x49C
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_GAIN_UPDATE_CTR_3        0x49D
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_LOOP_CFG                 0x49E
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_POWER_THRSH              0x49F
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UL_SIG_POW_MEAS_DEL_1    0x4A0
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UL_SIG_POW_MEAS_DEL_2    0x4A1
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UL_SIG_POW_MEAS_DUR_1    0x4A2
#define MYKONOS_ADDR_AGC_SLOW_ORX_SNRX_UL_SIG_POW_MEAS_DUR_2    0x4A3

/* Mykonos Gain Control Read Registers */
#define MYKONOS_ADDR_GAIN_CTL_CHANNEL_1                         0x4B0
#define MYKONOS_ADDR_GAIN_CTL_FAST_ATTK_STATE                   0x4B1
#define MYKONOS_ADDR_GAIN_CTL_SLOW_LOOP_STATE                   0x4B2
#define MYKONOS_ADDR_GAIN_CTL_CHANNEL_2                         0x4B3
#define MYKONOS_ADDR_GAIN_CTL_OVRG_SIGS_CHANNEL_1               0x4B4
#define MYKONOS_ADDR_GAIN_CTL_OVRG_SIGS_CHANNEL_2               0x4B5
#define MYKONOS_ADDR_GAIN_CTL_ORX_SNRX_GAIN                     0x4B6
#define MYKONOS_ADDR_GAIN_CTL_ORX_SNRX_LOOP_STATE               0x4B7
#define MYKONOS_ADDR_GAIN_CTL_ORX_SNRX_OVRG_SIGS                0x4B8

/* Mykonos Rx Data Path Overrange Registers */
#define MYKONOS_ADDR_RX_OVRG_DATAPATH_OVRFLW                    0x4B9
#define MYKONOS_ADDR_RX_OVRG_ORX_SNRX_DATAPATH_OVRFLW           0x4BA

/* Mykonos RSSI Measurement Registers and Dec Power Measurement Registers*/
#define MYKONOS_ADDR_RSSI_MEAS_DURATION_0_1                     0x4C0
#define MYKONOS_ADDR_RSSI_MEAS_DURATION_2_3                     0x4C1
#define MYKONOS_ADDR_RSSI_CFG                                   0x4C6
#define MYKONOS_DEC_POWER_CONFIG_1                              0x4C7
#define MYKONOS_DEC_POWER_CONFIG_2								0x4C8
#define MYKONOS_ADDR_DPD_SNF_RSSI_CFG                           0x4CF
#define MYKONOS_ADDR_DPD_RSSI_CFG                               0x4D6
#define MYKONOS_SNIFFER_DEC_POWER_CONFIG_1						0x4D7
#define MYKONOS_SNIFFER_DEC_POWER_CONFIG_2						0x4D8
#define MYKONOS_CH1_DECIMATED_PWR								0x4DE
#define MYKONOS_CH2_DECIMATED_PWR								0x4DF
#define MYKONOS_SNIFFER_DECIMATED_PWR							0x4E6

#define MYKONOS_ADDR_DIGITAL_GAIN_CONFIG                    0x4F0
#define MYKONOS_ADDR_DPD_SNIFFER_DIGITAL_GAIN_CONFIG        0x4F1
#define MYKONOS_ADDR_GAIN_TABLE_ADDR						0x500
#define MYKONOS_ADDR_GAIN_TABLE_RX1_FE_GAIN					0x501
#define MYKONOS_ADDR_GAIN_TABLE_RX1_EXT_CTL					0x502
#define MYKONOS_ADDR_GAIN_TABLE_RX1_DIG_GAIN				0x503
#define MYKONOS_ADDR_GAIN_TABLE_RX2_FE_GAIN					0x504
#define MYKONOS_ADDR_GAIN_TABLE_RX2_EXT_CTL					0x505
#define MYKONOS_ADDR_GAIN_TABLE_RX2_DIG_GAIN				0x506
#define MYKONOS_ADDR_GAIN_TABLE_RX3_FE_GAIN					0x507
#define MYKONOS_ADDR_GAIN_TABLE_RX3_LNA_ENAB				0x508
#define MYKONOS_ADDR_GAIN_TABLE_RX3_DIG_GAIN				0x509
#define MYKONOS_ADDR_GAIN_TABLE_CONFIGURATION               0x516
#define MYKONOS_ADDR_CH3_GAIN_TABLE_CONFIGURATION           0x517
#define MYKONOS_ADDR_RXFE1_LOCM                             0x520
#define MYKONOS_ADDR_RXFE2_LOCM                             0x521
#define MYKONOS_ADDR_RXLOOPBACK1_CNTRL_1                    0x540
#define MYKONOS_ADDR_RXLOOPBACK2_CNTRL_1                    0x541
#define MYKONOS_ADDR_RX_LOOPBACK1_CNTRL_4                   0x546
#define MYKONOS_ADDR_RX_LOOPBACK2_CNTRL_4                   0x547

/* Mykonos Overload/Peak Detection Registers */
#define MYKONOS_ADDR_OVRLD_ADC_OVRLD_CFG                    0x580
#define MYKONOS_ADDR_OVRLD_ADC_OVRLD_UPPER_THRSH            0x581
#define MYKONOS_ADDR_OVRLD_ADC_OVRLD_LOWER_THRSH            0x582

#define MYKONOS_ADDR_OVRLD_PD_DEC_OVRLD_CFG                 0x583
#define MYKONOS_ADDR_OVRLD_PD_DEC_OVRLD_UPPER_THRSH         0x584
#define MYKONOS_ADDR_OVRLD_PD_DEC_OVRLD_LOWER_THRSH         0x585
#define MYKONOS_ADDR_OVRLD_PD_DEC_VERYLOW_THRSH             0x586
#define MYKONOS_ADDR_ORX_SNRX_OVRLD_ADC_OVRLD_CFG           0x587
#define MYKONOS_ADDR_ORX_SNRX_OVRLD_PD_DEC_OVRLD_CFG        0x58A
#define MYKONOS_ADDR_ORX_SNRX_OVRLD_PD_DEC_OVRLD_UPPER_THRSH    0x58B
#define MYKONOS_ADDR_ORX_SNRX_OVRLD_PD_DEC_OVRLD_LOWER_THRSH    0x58C
#define MYKONOS_ADDR_ORX_SNRX_OVRLD_PD_DEC_OVRLD_VERYLOW_THRSH  0x58D

#define MYKONOS_ADDR_RX_ADC_FLASH_DELAY                     0x5B6
#define MYKONOS_ADDR_RX_ADC_FLASH_CTRL                      0x5B7
#define MYKONOS_ADDR_RX_ADC1_PRFL                           0x5DD
#define MYKONOS_ADDR_RX_ADC2_PRFL                           0x5DE
#define MYKONOS_ADDR_ORX_ADC_PRFL                           0x5DF

#define MYKONOS_ADDR_RFDC_MEASURE_COUNT_1                   0x631
#define MYKONOS_ADDR_RFDC_MEASURE_COUNT_2                   0x632
#define MYKONOS_ADDR_RFDC_PROGRAM_SHIFT                     0x635
#define MYKONOS_ADDR_RFDC_CONFIG2                           0x636
#define MYKONOS_DPD_Sniffer_RFDC_CAL_TRACK_EN               0x642
#define MYKONOS_ADDR_RFDC_SNF_MEASURE_COUNT_1               0x644
#define MYKONOS_ADDR_RFDC_SNF_MEASURE_COUNT_2               0x645
#define MYKONOS_ADDR_RFDC_ORX_MEASURE_COUNT_1               0x650
#define MYKONOS_ADDR_RFDC_ORX_MEASURE_COUNT_2               0x651
#define MYKONOS_ADDR_DIGITAL_DC_MIN_CAL_IDX                 0x63A
#define MYKONOS_ADDR_DIGITAL_DC_OFFSET_SHIFT                0x674
#define MYKONOS_ADDR_DIGITAL_DC_OFFSET_CONFIG               0x676
#define MYKONOS_DIGITAL_DC_OFFSET_CH3_TRACKING              0x67A
#define MYKONOS_ADDR_DIGITAL_DC_OFFSET_SNF                  0x67C
#define MYKONOS_ADDR_DIGITAL_DC_OFFSET_CH3_DPD_M_SHIFT      0x67D

#define MYKONOS_ADDR_RX_GAIN_COMP_DELAY                     0x710
#define MYKONOS_ADDR_RX1_GAIN_COMP_OFFSET                   0x711
#define MYKONOS_ADDR_RX2_GAIN_COMP_OFFSET                   0x712
#define MYKONOS_ADDR_RX_GAIN_COMP_CFG                       0x713
#define MYKONOS_ADDR_RX_SLCR_PIN_CFG                        0x714
#define MYKONOS_ADDR_DPD_SNF_RX_GAIN_COMP_DELAY             0x715
#define MYKONOS_ADDR_DPD_SNF_RX_GAIN_COMP_OFFSET            0x716
#define MYKONOS_ADDR_DPD_SNF_RX_GAIN_COMP_CFG               0x717
#define MYKONOS_ADDR_DPD_SNF_RX_SLCR_PIN_CFG                0x718

#define MYKONOS_ADDR_FLOATING_POINT_CFG                     0x750
#define MYKONOS_ADDR_FLOATING_POINT_RX_CTRL                 0x751
#define MYKONOS_ADDR_FLOATING_POINT_ORX_CTRL                0x752


#define MYKONOS_ADDR_SNRX_LNA_BIAS_C                        0x81B


#define MYKONOS_ADDR_ORX_ADC_FLASH_DELAY                     0x846
#define MYKONOS_ADDR_ORX_ADC_FLASH_CTRL                      0x847

#define MYKONOS_ADDR_TX_FILTER_CONFIGURATION                0x910
#define MYKONOS_ADDR_TX1_ATTENUATION_0_READBACK             0x940
#define MYKONOS_ADDR_TX1_ATTENUATION_1_READBACK             0x941
#define MYKONOS_ADDR_TX2_ATTENUATION_0_READBACK             0x942
#define MYKONOS_ADDR_TX2_ATTENUATION_1_READBACK             0x943
#define MYKONOS_ADDR_TX_FILTER_OVERFLOW 					0x950

/* Mykonos PA Protection Block Registers */
#define MYKONOS_ADDR_PA_PROTECTION_CONFIGURATION            0x955
#define MYKONOS_ADDR_PA_PROTECTION_ATTEN_CONTROL            0x956
#define MYKONOS_ADDR_PA_PROTECTION_THRESHOLD_LSB            0x957
#define MYKONOS_ADDR_PA_PROTECTION_THRESHOLD_MSB            0x958
#define MYKONOS_ADDR_PA_PROTECTION_POWER_READBACK_LSB       0x959
#define MYKONOS_ADDR_PA_PROTECTION_POWER_READBACK_MSB       0x95A
#define MYKONOS_ADDR_TX1_ATTENUATION_0                      0x960
#define MYKONOS_ADDR_TX1_ATTENUATION_1                      0x961
#define MYKONOS_ADDR_TX2_ATTENUATION_0                      0x962
#define MYKONOS_ADDR_TX2_ATTENUATION_1                      0x963
#define MYKONOS_ADDR_TX1_GAIN_0                             0x967
#define MYKONOS_ADDR_TX1_GAIN_1                             0x968
#define MYKONOS_ADDR_TX1_GAIN_2                             0x969
#define MYKONOS_ADDR_TX2_GAIN_0                             0x96A
#define MYKONOS_ADDR_TX2_GAIN_1                             0x96B
#define MYKONOS_ADDR_TX2_GAIN_2                             0x96C
#define MYKONOS_ADDR_TX_INCR_DECR_WORD                      0x96D
#define MYKONOS_ADDR_TX_TPC_CONFIG                          0x96E
#define MYKONOS_ADDR_TX_TPC_GPIO_CFG                        0x96F

#define MYKONOS_ADDR_TX_ABBF_FREQ_CAL_NCO_I_MSB             0x9CB
#define MYKONOS_ADDR_TX_ABBF_FREQ_CAL_NCO_I_LSB             0x9CC
#define MYKONOS_ADDR_TX_ABBF_FREQ_CAL_NCO_Q_MSB             0x9CD
#define MYKONOS_ADDR_TX_ABBF_FREQ_CAL_NCO_Q_LSB             0x9CE

/* Mykonos GPIO Registers */
#define MYKONOS_ADDR_GPIO_3V3_DIR_CTL_7_0					0xB00
#define MYKONOS_ADDR_GPIO_3V3_DIR_CTL_15_8					0xB01
#define MYKONOS_ADDR_GPIO_3V3_SPI_SRC_7_0					0xB02
#define MYKONOS_ADDR_GPIO_3V3_SPI_SRC_15_8					0xB03
#define MYKONOS_ADDR_GPIO_3V3_SPI_READ_7_0					0xB04
#define MYKONOS_ADDR_GPIO_3V3_SPI_READ_15_8					0xB05
#define MYKONOS_ADDR_GPIO_3V3_LSB_SRC_CTL					0xB06
#define MYKONOS_ADDR_GPIO_3V3_MSB_SRC_CTL					0xB07

#define MYKONOS_ADDR_GPIO_DIR_CTL_7_0					    0xB20
#define MYKONOS_ADDR_GPIO_DIR_CTL_15_8					    0xB21
#define MYKONOS_ADDR_GPIO_DIR_CTL_18_16					    0xB22
#define MYKONOS_ADDR_GPIO_SPI_SRC_7_0					    0xB23
#define MYKONOS_ADDR_GPIO_SPI_SRC_15_8					    0xB24
#define MYKONOS_ADDR_GPIO_SPI_SRC_18_16					    0xB25
#define MYKONOS_ADDR_GPIO_SPI_READ_7_0					    0xB26
#define MYKONOS_ADDR_GPIO_SPI_READ_15_8					    0xB27
#define MYKONOS_ADDR_GPIO_SPI_READ_18_16				    0xB28
#define MYKONOS_ADDR_SOURCE_CONTROL_LOWER_BYTE              0xB29
#define MYKONOS_ADDR_SOURCE_CONTROL_UPPER_BYTE              0xB2A
#define MYKONOS_ADDR_SOURCE_CONTROL_EXTRA_BITS              0xB2B

#define MYKONOS_ADDR_GPIO_MONITOR_INDEX                     0xB40
#define MYKONOS_ADDR_GPIO_MONITOR_ENABLE                    0xB41

#define MYKONOS_ADDR_GP_INTERRUPT_MASK_1                    0xB42
#define MYKONOS_ADDR_GP_INTERRUPT_MASK_0                    0xB43
#define MYKONOS_ADDR_GP_INTERRUPT_READ_1                    0xB44
#define MYKONOS_ADDR_GP_INTERRUPT_READ_0                    0xB45

#define MYKONOS_ADDR_PDAUXDAC_MANUAL_CONTROL_5_0            0xB73
#define MYKONOS_ADDR_PDAUXDAC_MANUAL_CONTROL_9_6            0xB74
#define MYKONOS_ADDR_PDAUXDAC_MANUAL_IN_5_0                 0xB75
#define MYKONOS_ADDR_PDAUXDAC_MANUAL_IN_9_6                 0xB76
#define MYKONOS_ADDR_AUX_DAC_LATCH_CONTROL                  0xB9F
#define MYKONOS_ADDR_AUXDAC_0_WORD_MSB                      0xBA0

#define MYKONOS_ADR_AUX_ADC_CLOCK_DIVIDE                    0xBC0
#define MYKONOS_ADDR_AUX_ADC_CFG                            0xBC1
#define MYKONOS_ADDR_AUX_ADC_READ_MSB                       0xBC2
#define MYKONOS_ADDR_AUX_ADC_READ_LSB                       0xBC3
#define MYKONOS_ADDR_AUX_ADC_SEL                            0xBC4
#define MYKONOS_ADDR_AUX_ADC_BUFFER_CONFIG_0                0xBC5
#define MYKONOS_ADDR_AUX_ADC_BUFFER_CONFIG_1                0xBC6

#define MYKONOS_ADDR_TEMP_SENSOR_OFFSET                     0xBE0
#define MYKONOS_ADDR_TEMP_SENSOR_CONTROL_LSB                0xBE1
#define MYKONOS_ADDR_TEMP_SENSOR_CONTROL_MSB                0xBE2
#define MYKONOS_ADDR_TEMP_SENSOR_READ                       0xBE3
#define MYKONOS_ADDR_TEMP_SENSOR_CONFIG                     0xBE4

#define MYKONOS_ADDR_DIGITAL_TEST_BYTE_0                    0xC40

/* ARM subsystem registers */
#define MYKONOS_ADDR_ARM_CTL_1								0xD00
#define MYKONOS_ADDR_ARM_CTL_2								0xD01
#define MYKONOS_ADDR_ARM_ADDR_BYTE_0						0xD02
#define MYKONOS_ADDR_ARM_ADDR_BYTE_1						0xD03
#define MYKONOS_ADDR_ARM_DATA_BYTE_0						0xD04
#define MYKONOS_ADDR_ARM_DATA_BYTE_1						0xD05
#define MYKONOS_ADDR_ARM_DATA_BYTE_2						0xD06
#define MYKONOS_ADDR_ARM_DATA_BYTE_3						0xD07
#define MYKONOS_ADDR_ARM_CLK_CTL							0xD08
#define MYKONOS_ADDR_AHB_SPI_BRIDGE							0xD09
#define MYKONOS_ADDR_ARM_BOOT_ADDR_BYTE_0					0xD0A
#define MYKONOS_ADDR_ARM_BOOT_ADDR_BYTE_1					0xD0B
#define MYKONOS_ADDR_ARM_BOOT_ADDR_BYTE_2					0xD0C
#define MYKONOS_ADDR_ARM_BOOT_ADDR_BYTE_3					0xD0D
#define MYKONOS_ADDR_ARM_STACK_PTR_BYTE_0					0xD0E
#define MYKONOS_ADDR_ARM_STACK_PTR_BYTE_1					0xD0F
#define MYKONOS_ADDR_ARM_STACK_PTR_BYTE_2					0xD10
#define MYKONOS_ADDR_ARM_STACK_PTR_BYTE_3					0xD11
#define MYKONOS_ADDR_ARM_BRIDGE_CLK_CTL						0xD14

/* ARM mailbox registers */
#define MYKONOS_ADDR_ARM_CMD								0xD30
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_1						0xD31
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_2						0xD32
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_3						0xD33
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_4						0xD34
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_5						0xD35
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_6						0xD36
#define MYKONOS_ADDR_ARM_EXT_CMD_BYTE_7						0xD37
#define MYKONOS_ADDR_ARM_CMD_STATUS_0						0xD38
#define MYKONOS_ADDR_ARM_CMD_STATUS_1						0xD39
#define MYKONOS_ADDR_ARM_CMD_STATUS_2						0xD3A
#define MYKONOS_ADDR_ARM_CMD_STATUS_3						0xD3B
#define MYKONOS_ADDR_ARM_CMD_STATUS_4						0xD3C
#define MYKONOS_ADDR_ARM_CMD_STATUS_5						0xD3D
#define MYKONOS_ADDR_ARM_CMD_STATUS_6						0xD3E
#define MYKONOS_ADDR_ARM_CMD_STATUS_7						0xD3F

#define MYKONOS_ADDR_ARM_OPCODE_STATE_0						0xD40
#define MYKONOS_ADDR_ARM_OPCODE_STATE_1						0xD41
#define MYKONOS_ADDR_ARM_OPCODE_STATE_2						0xD42
#define MYKONOS_ADDR_ARM_OPCODE_STATE_3						0xD43
#define MYKONOS_ADDR_ARM_OPCODE_STATE_4						0xD44
#define MYKONOS_ADDR_ARM_OPCODE_STATE_5						0xD45
#define MYKONOS_ADDR_ARM_OPCODE_STATE_6						0xD46
#define MYKONOS_ADDR_ARM_OPCODE_STATE_7						0xD47

/* Mykonos Power-Down Override Control Registers */
#define MYKONOS_ADDR_TX_PD_OVERRIDE_CONTROL_7_0             0xD89

/* Mykonos Observation Framer Registers */
#define MYKONOS_ADDR_OBS_FRAMER_RESET						0xDC0
#define MYKONOS_ADDR_OBS_FRAMER_CLK_EN						0xDC1
#define MYKONOS_ADDR_OBS_FRAMER_ADDR						0xDC2
#define MYKONOS_ADDR_OBS_FRAMER_DATA						0xDC3
#define MYKONOS_ADDR_OBS_FRAMER_WRITE_EN					0xDC4
#define MYKONOS_ADDR_OBS_FRAMER_SYSREF_FIFO_EN				0xDC5
#define MYKONOS_ADDR_OBS_FRAMER_CONFIG_F					0xDC6
#define MYKONOS_ADDR_OBS_FRAMER_LANE_CTL					0xDC7
#define MYKONOS_ADDR_OBS_FRAMER_ADC_XBAR_SEL				0xDC8
#define MYKONOS_ADDR_OBS_FRAMER_LANE_XBAR_SEL				0xDC9
#define MYKONOS_ADDR_OBS_FRAMER_CONFIG_LOOPBACK_XBAR_REV	0xDCA
#define MYKONOS_ADDR_OBS_FRAMER_SYNCN_FILT					0xDCB
#define MYKONOS_ADDR_OBS_FRAMER_LMFC_F_OFFSET				0xDCC
#define MYKONOS_ADDR_OBS_FRAMER_LMFC_K_OFFSET				0xDCD
#define MYKONOS_ADDR_OBS_FRAMER_TEST_CNTR_CTL				0xDCE
#define MYKONOS_ADDR_OBS_FRAMER_STATUS_STRB					0xDCF
#define MYKONOS_ADDR_OBS_FRAMER_STATUS						0xDD0
#define MYKONOS_ADDR_OBS_FRAMER_SYSREF_TO_LMFC_CNTR_STAT	0xDD1
#define MYKONOS_ADDR_OBS_FRAMER_SYSREF_TO_LMFC_ERR_MARGIN	0xDD2
#define MYKONOS_ADDR_OBS_FRAMER_LANE_FIFO_STRB				0xDD3
#define MYKONOS_ADDR_OBS_FRAMER_LANE0_FIFO_RDWR_ADDR		0xDD4
#define MYKONOS_ADDR_OBS_FRAMER_LANE1_FIFO_RDWR_ADDR		0xDD5
#define MYKONOS_ADDR_OBS_FRAMER_LANE2_FIFO_RDWR_ADDR		0xDD6
#define MYKONOS_ADDR_OBS_FRAMER_LANE3_FIFO_RDWR_ADDR		0xDD7
#define MYKONOS_ADDR_OBS_FRAMER_PRBS10_CTL					0xDD8
#define MYKONOS_ADDR_OBS_FRAMER_PRBS20_CTL					0xDD9
#define MYKONOS_ADDR_OBS_FRAMER_PATTERN_GEN_EN				0xDDA
#define MYKONOS_ADDR_OBS_FRAMER_PATTERN_GEN_7_TO_0			0xDDB
#define MYKONOS_ADDR_OBS_FRAMER_PATTERN_GEN_15_TO_8			0xDDC
#define MYKONOS_ADDR_OBS_FRAMER_PATTERN_GEN_19_TO_16		0xDDD
#define MYKONOS_ADDR_OBS_FRAMER_CONFIG_JTX_GEN				0xDDE
#define MYKONOS_ADDR_OBS_FRAMER_LANE_DATA_CTL				0xDDF
#define MYKONOS_ADDR_OBS_FRAMER_DATA_SAMPLE_CTL				0xDE0

#define MYKONOS_ADDR_PFIR_COEFF_CTL                         0xDFF
#define MYKONOS_ADDR_PFIR_COEFF_DATA                        0xE00
#define MYKONOS_ADDR_PFIR_COEFF_ADDR                        0xE01

/* ARM memory */
#define MYKONOS_ADDR_ARM_START_PROG_ADDR					0x01000000
#define MYKONOS_ADDR_ARM_END_PROG_ADDR						0x01017FFF
#define MYKONOS_ADDR_ARM_START_DATA_ADDR					0x20000000
#define MYKONOS_ADDR_ARM_END_DATA_ADDR						0x2000FFFF
#define MYKONOS_ADDR_ARM_BUILD_CHKSUM_ADDR					0x01017FE0
#define MYKONOS_ADDR_ARM_CALC_CHKSUM_ADDR					0x01017FE4
#define MYKONOS_ADDR_ARM_VERSION                            0x01000128
#define MYKONOS_ARM_ABORT_OPCODE                            0x00
#define MYKONOS_ARM_RUNINIT_OPCODE                          0x02
#define MYKONOS_ARM_RADIOON_OPCODE                          0x04
#define MYKONOS_ARM_WRITECFG_OPCODE                         0x06
#define MYKONOS_ARM_READCFG_OPCODE                          0x08
#define MYKONOS_ARM_SET_OPCODE                              0x0A
#define MYKONOS_ARM_GET_OPCODE                              0x0C

#define MYKONOS_ARM_OBJECTID_DPDINIT_CONFIG                 0x0F
#define MYKONOS_ARM_OBJECTID_CLGCINIT_CONFIG                0x10
#define MYKONOS_ARM_OBJECTID_VSWRINIT_CONFIG                0x11
#define MYKONOS_ARM_OBJECTID_DPDCONFIG                      0x24
#define MYKONOS_ARM_DPD_RESET                               0x02
#define MYKONOS_ARM_OBJECTID_GS_TRACKCALS                   0x66
#define MYKONOS_ARM_OBJECTID_RXQEC_TRACKING                 0x20
#define MYKONOS_ARM_OBJECTID_ORXQEC_TRACKING                0x21
#define MYKONOS_ARM_OBJECTID_TXLOL_TRACKING                 0x22
#define MYKONOS_ARM_OBJECTID_TXQEC_TRACKING                 0x23
#define MYKONOS_ARM_OBJECTID_CLGCCONFIG                     0x25
#define MYKONOS_ARM_OBJECTID_VSWRCONFIG                     0x26
#define MYKONOS_ARM_OBJECTID_CAL_STATUS                     0x42
#define MYKONOS_ARM_OBJECTID_INIT_CAL_DONE                  0x43
#define MYKONOS_ARM_OBJECTID_ORX_MODE                       0x61
#define MYKONOS_ARM_OBJECTID_TRACKING_CAL_SUSPEND_RESUME    0x65
#define MYKONOS_ARM_OBJECTID_TRACKING_CAL_CONTROL           0x66
#define MYKONOS_ARM_OBJECTID_TRACKING_CAL_PENDING           0x67
#define MYKONOS_ARM_OBJECTID_RADIO_CONTROL                  0x81
#define MYKONOS_ARM_OBJECTID_CALSCHEDULER                   0x83

#define MYKONOS_ARM_SYSTEMSTATE_POWERUP                     0x00
#define MYKONOS_ARM_SYSTEMSTATE_READY                       0x01
#define MYKONOS_ARM_SYSTEMSTATE_IDLE                        0x02
#define MYKONOS_ARM_SYSTEMSTATE_RADIO_ON                    0x03

#define ORX_TRIGGER_SIGNALID      0x00
#define ORX_MODE_0_SIGNALID       0x01
#define ORX_MODE_1_SIGNALID       0x02
#define ORX_MODE_2_SIGNALID       0x03
#define RX1_ENABLE_ACK_SIGNALID   0x04
#define RX2_ENABLE_ACK_SIGNALID   0x05
#define TX1_ENABLE_ACK_SIGNALID   0x06
#define TX2_ENABLE_ACK_SIGNALID   0x07
#define ORX1_ENABLE_ACK_SIGNALID  0x08
#define ORX2_ENABLE_ACK_SIGNALID  0x09
#define SRX_ENABLE_ACK_SIGNALID   0x0A
#define TX_OBS_SELECT_SIGNALID    0x0B

#define DISABLE_DPD_ACTUATOR      0x03
#define ENABLE_DPD_ACTUATOR       0x04
#define SET_CLGC_DESIRED_GAIN_1   0x05
#define SET_CLGC_DESIRED_GAIN_2   0x06
#define SET_PATH_DELAY            0x08

#ifdef __cplusplus
}
#endif

#endif
