// SPDX-License-Identifier: GPL-2.0
/**
 * \file talise_reg_addr_macros.h
 * \brief Contains Talise API address macro definitions
 *
 * Talise API version: 3.6.2.1
 *
 * Copyright 2015-2017 Analog Devices Inc.
 * Released under the AD9378-AD9379 API license, for more information see the "LICENSE.txt" file in this zip file.
 */

#ifndef _TALISE_ADDR_MACROS_H
#define _TALISE_ADDR_MACROS_H

#ifdef __cplusplus
extern "C" {
#endif

#define TALISE_ADDR_SPI_INTERFACE_CONFIG_A                         0x0000
#define TALISE_ADDR_SPI_INTERFACE_CONFIG_B                         0x0001
#define TALISE_ADDR_PRODUCT_ID_0                                   0x0004
#define TALISE_ADDR_PRODUCT_ID_1                                   0x0005
#define TALISE_ADDR_SCRATCH_PAD                                    0x000A
#define TALISE_ADDR_VENDOR_ID_0                                    0x000C
#define TALISE_ADDR_VENDOR_ID_1                                    0x000D
#define TALISE_ADDR_GPIO_SLEW_CONTROL_BYTE3                        0x0045
#define TALISE_ADDR_DIGITAL_IO_CONTROL                             0x0048
#define TALISE_ADDR_TX_RX_DATAPATH_INVERSION                       0x004A
#define TALISE_ADDR_SPI2_CONFIGURATION                             0x004B
#define TALISE_ADDR_SPI2_CONFIGURATION2                            0x004C
#define TALISE_ADDR_SYSREF_PAD_CONFIG                              0x0080
#define TALISE_ADDR_TX1_SYNC_PAD_CONFIG                            0x0081
#define TALISE_ADDR_TX2_SYNC_PAD_CONFIG                            0x0082
#define TALISE_ADDR_RX1_SYNC_PAD_CONFIG                            0x0083
#define TALISE_ADDR_RX2_SYNC_PAD_CONFIG                            0x0084
#define TALISE_ADDR_PFIR_COEFF_CTL                                 0x00C0
#define TALISE_ADDR_PFIR_COEFF_DATA                                0x00C2
#define TALISE_ADDR_PFIR_COEFF_ADDR                                0x00C3
#define TALISE_ADDR_CONFIGURATION_CONTROL_1                        0x0100
#define TALISE_ADDR_CONFIGURATION_CONTROL_2                        0x0101
#define TALISE_ADDR_CONFIGURATION_CONTROL_4                        0x0102
#define TALISE_ADDR_CONFIGURATION_CONTROL_ORX                      0x0103
#define TALISE_ADDR_CLOCK_CONTROL_0                                0x0140
#define TALISE_ADDR_CLOCK_CONTROL_1                                0x0141
#define TALISE_ADDR_CLOCK_CONTROL_2                                0x0142
#define TALISE_ADDR_CLOCK_CONTROL_3                                0x0143
#define TALISE_ADDR_CLOCK_CONTROL_4                                0x0144
#define TALISE_ADDR_CLOCK_CONTROL_5                                0x0145
#define TALISE_ADDR_CLOCK_CONTROL_6                                0x0146
#define TALISE_ADDR_CLOCK_CONTROL_7                                0x0147
#define TALISE_ADDR_MCS_CONTROL                                    0x0180
#define TALISE_ADDR_MCS_STATUS                                     0x0181
#define TALISE_ADDR_MCS_CONTROL_2                                  0x0182
#define TALISE_ADDR_CLK_SYNTH_BYTE1                                0x0201
#define TALISE_ADDR_CLK_SYNTH_BYTE2                                0x0202
#define TALISE_ADDR_CLK_SYNTH_BYTE3                                0x0203
#define TALISE_ADDR_CLK_SYNTH_BYTE5                                0x0205
#define TALISE_ADDR_CLK_SYNTH_BYTE6                                0x0206
#define TALISE_ADDR_CLK_SYNTH_BYTE7                                0x0207
#define TALISE_ADDR_CLK_SYNTH_BYTE9                                0x0209
#define TALISE_ADDR_CLK_SYNTH_VCO_VAR_CTR1                         0x020E
#define TALISE_ADDR_CLK_SYNTH_VCO_VAR_CTR2                         0x020F
#define TALISE_ADDR_CLK_SYNTH_DIVIDER_INT_BYTE0                    0x0210
#define TALISE_ADDR_CLK_SYNTH_DIVIDER_INT_BYTE1                    0x0211
#define TALISE_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE0                   0x0212
#define TALISE_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE1                   0x0213
#define TALISE_ADDR_CLK_SYNTH_DIVIDER_FRAC_BYTE2                   0x0214
#define TALISE_ADDR_CLK_SYNTH_F_VCOTN_BYTE1                        0x0217
#define TALISE_ADDR_CLK_SYNTH_LF_R3                                0x0218
#define TALISE_ADDR_CLK_SYNTH_CAL                                  0x0219
#define TALISE_ADDR_CLK_SYNTH_VCO_CAL_REF                          0x021A
#define TALISE_ADDR_CLK_SYNTH_VCO_BAND_BYTE1                       0x021C
#define TALISE_ADDR_CLK_SYNTH_CAL_CONTROL                          0x021E
#define TALISE_ADDR_RX_NCO_CONTROL_0                               0x0240
#define TALISE_ADDR_RX_NCO_CH1_FTW_BYTE4                           0x0241
#define TALISE_ADDR_RX_NCO_CH1_FTW_BYTE3                           0x0242
#define TALISE_ADDR_RX_NCO_CH1_FTW_BYTE2                           0x0243
#define TALISE_ADDR_RX_NCO_CH1_FTW_BYTE1                           0x0244
#define TALISE_ADDR_RX_NCO_CH2_FTW_BYTE4                           0x0247
#define TALISE_ADDR_RX_NCO_CH2_FTW_BYTE3                           0x0248
#define TALISE_ADDR_RX_NCO_CH2_FTW_BYTE2                           0x0249
#define TALISE_ADDR_RX_NCO_CH2_FTW_BYTE1                           0x024A
#define TALISE_ADDR_RX1_BAND_A_NCO2_FTW_BYTE4                      0x024E
#define TALISE_ADDR_RX1_BAND_A_NCO2_FTW_BYTE3                      0x024F
#define TALISE_ADDR_RX1_BAND_A_NCO2_FTW_BYTE2                      0x0250
#define TALISE_ADDR_RX1_BAND_A_NCO2_FTW_BYTE1                      0x0251
#define TALISE_ADDR_RX1_BAND_B_NCO1_FTW_BYTE4                      0x0254
#define TALISE_ADDR_RX1_BAND_B_NCO1_FTW_BYTE3                      0x0255
#define TALISE_ADDR_RX1_BAND_B_NCO1_FTW_BYTE2                      0x0256
#define TALISE_ADDR_RX1_BAND_B_NCO1_FTW_BYTE1                      0x0257
#define TALISE_ADDR_RX1_BAND_B_NCO2_FTW_BYTE4                      0x025A
#define TALISE_ADDR_RX1_BAND_B_NCO2_FTW_BYTE3                      0x025B
#define TALISE_ADDR_RX1_BAND_B_NCO2_FTW_BYTE2                      0x025C
#define TALISE_ADDR_RX1_BAND_B_NCO2_FTW_BYTE1                      0x025D
#define TALISE_ADDR_RX2_BAND_A_NCO2_FTW_BYTE4                      0x0260
#define TALISE_ADDR_RX2_BAND_A_NCO2_FTW_BYTE3                      0x0261
#define TALISE_ADDR_RX2_BAND_A_NCO2_FTW_BYTE2                      0x0262
#define TALISE_ADDR_RX2_BAND_A_NCO2_FTW_BYTE1                      0x0263
#define TALISE_ADDR_RX2_BAND_B_NCO1_FTW_BYTE4                      0x0266
#define TALISE_ADDR_RX2_BAND_B_NCO1_FTW_BYTE3                      0x0267
#define TALISE_ADDR_RX2_BAND_B_NCO1_FTW_BYTE2                      0x0268
#define TALISE_ADDR_RX2_BAND_B_NCO1_FTW_BYTE1                      0x0269
#define TALISE_ADDR_RX2_BAND_B_NCO2_FTW_BYTE4                      0x026C
#define TALISE_ADDR_RX2_BAND_B_NCO2_FTW_BYTE3                      0x026D
#define TALISE_ADDR_RX2_BAND_B_NCO2_FTW_BYTE2                      0x026E
#define TALISE_ADDR_RX2_BAND_B_NCO2_FTW_BYTE1                      0x026F
#define TALISE_ADDR_RX_BAND_CONTROL                                0x0272
#define TALISE_ADDR_RX_NCO_FTW_UPDATE_CONTROL                      0x027C
#define TALISE_ADDR_BBIC_ENABLES                                   0x0284
#define TALISE_ADDR_RADIO_CONTROL_CONFIG1                          0x028A
#define TALISE_ADDR_RADIO_CONTROL_CONFIG2                          0x028B
#define TALISE_ADDR_TX_DP_MASK_CH1                                 0x028E
#define TALISE_ADDR_TX_DP_MASK_CH2                                 0x028F
#define TALISE_ADDR_REFERENCE_CLOCK_CYCLES                         0x02C0
#define TALISE_ADDR_RF_SYNTHESIZER_POWER_DOWN                      0x0301
#define TALISE_ADDR_CLK_SYNTHESIZER_POWER_DOWN                     0x0302
#define TALISE_ADDR_TX1_PD                                         0x0309
#define TALISE_ADDR_TX2_PD                                         0x030A
#define TALISE_ADDR_MASTERBIAS_CONFIG0                             0x0340
#define TALISE_ADDR_MASTERBIAS_CONFIG1                             0x0341
#define TALISE_ADDR_RCAL_CONTROL                                   0x0384
#define TALISE_ADDR_REF_PAD_CONFIG2                                0x03C1
#define TALISE_ADDR_RF_SYNTH_CAL                                   0x0414
#define TALISE_ADDR_RF_SYNTH_VCO_BAND_BYTE1                        0x0417
#define TALISE_ADDR_EXT_LO_BYTE0                                   0x04C0
#define TALISE_ADDR_EXTLOGEN_BYTE1                                 0x04C1
#define TALISE_ADDR_EXTLOGEN_CONTROL_1                             0x04C2
#define TALISE_ADDR_EXTLO_DIVMODE                                  0x04C3
#define TALISE_ADDR_RX_PFIR_MODE_MAPPING1                          0x0540
#define TALISE_ADDR_RX_PFIR_MODE_MAPPING2                          0x0541
#define TALISE_ADDR_RX_PFIR_BANK_A_SETTINGS                        0x0542
#define TALISE_ADDR_RX_PFIR_BANK_B_SETTINGS                        0x0543
#define TALISE_ADDR_RX_PFIR_BANK_C_SETTINGS                        0x0544
#define TALISE_ADDR_AGC_CONFIG1                                    0x05C0
#define TALISE_ADDR_AGC_CONFIG2                                    0x05C1
#define TALISE_ADDR_MANUAL_GAIN_CONFIG                             0x05C2
#define TALISE_ADDR_AGC_LOCK_LEVEL                                 0x05C3
#define TALISE_ADDR_AGC_OVRG_GAIN_STEP1                            0x05C4
#define TALISE_ADDR_AGC_OVRG_GAIN_STEP2                            0x05C5
#define TALISE_ADDR_AGC_OVRG_GAIN_STEP4                            0x05C7
#define TALISE_ADDR_AGC_OVRG_GAIN_STEP5                            0x05C8
#define TALISE_ADDR_UPPER_LEVEL_BLOCKER_THRESHOLD                  0x05C9
#define TALISE_ADDR_UPPER_LEVEL_BLOCKER_THRESHOLD2                 0x05CA
#define TALISE_ADDR_LOWER_LEVEL_BLOCKER_THRESHOLD                  0x05CB
#define TALISE_ADDR_LOWER_LEVEL_BLOCKER_THRESHOLD2                 0x05CC
#define TALISE_ADDR_AGC_CONFIG_RX1                                 0x05D0
#define TALISE_ADDR_AGC_MANUAL_GAIN_CONTROL_CONFIG_RX1             0x05D1
#define TALISE_ADDR_MANUAL_GAIN_INDEX_RX1                          0x05D2
#define TALISE_ADDR_MANUAL_GAIN_INDEX_ORX_RX1                      0x05D3
#define TALISE_ADDR_AGC_ATTACK_DELAY_RX1                           0x05D6
#define TALISE_ADDR_MAX_GAIN_INDEX_RX1                             0x05D7
#define TALISE_ADDR_MIN_GAIN_INDEX_RX1                             0x05D8
#define TALISE_ADDR_AGC_CONFIG_RX2                                 0x05E0
#define TALISE_ADDR_AGC_MANUAL_GAIN_CONTROL_CONFIG_RX2             0x05E1
#define TALISE_ADDR_MANUAL_GAIN_INDEX_RX2                          0x05E2
#define TALISE_ADDR_MANUAL_GAIN_INDEX_ORX_RX2                      0x05E3
#define TALISE_ADDR_AGC_ATTACK_DELAY_RX2                           0x05E6
#define TALISE_ADDR_MAX_GAIN_INDEX_RX2                             0x05E7
#define TALISE_ADDR_MIN_GAIN_INDEX_RX2                             0x05E8
#define TALISE_ADDR_GAIN_VALID_OVERRIDES                           0x05E9
#define TALISE_ADDR_AGC_LOCK_LEVEL_THRESHOLDS                      0x0640
#define TALISE_ADDR_ULB_COUNT_THRESHOLD                            0x0641
#define TALISE_ADDR_LLB_COUNT_THRESHOLD                            0x0642
#define TALISE_ADDR_ADC_HIGH_OVRG_COUNT_THRESHOLD                  0x0643
#define TALISE_ADDR_ADC_LOW_OVRG_COUNT_THRESHOLD                   0x0644
#define TALISE_ADDR_UPPER0_THRESHOLD_GAIN_STEP                     0x0646
#define TALISE_ADDR_UPPER1_THRESHOLD_GAIN_STEP                     0x0648
#define TALISE_ADDR_LOWER0_THRESHOLD_GAIN_STEP                     0x0647
#define TALISE_ADDR_LOWER1_THRESHOLD_GAIN_STEP                     0x0649
#define TALISE_ADDR_GAIN_UPDATE_COUNTER1                           0x064A
#define TALISE_ADDR_GAIN_UPDATE_COUNTER2                           0x064B
#define TALISE_ADDR_GAIN_UPDATE_COUNTER3                           0x064C
#define TALISE_ADDR_SLOWLOOP_CONFIG                                0x064D
#define TALISE_ADDR_SLOWLOOP_SETTLING_DELAY                        0x064E
#define TALISE_ADDR_POWER_THRESHOLDS                               0x064F
#define TALISE_ADDR_RX1_UL_SIG_POWER_MEAS_DELAY1                   0x0650
#define TALISE_ADDR_RX1_UL_SIG_POWER_MEAS_DELAY2                   0x0651
#define TALISE_ADDR_RX1_UL_SIG_POWER_MEAS_DURATION1                0x0652
#define TALISE_ADDR_RX1_UL_SIG_POWER_MEAS_DURATION2                0x0653
#define TALISE_ADDR_RX2_UL_SIG_POWER_MEAS_DELAY1                   0x0654
#define TALISE_ADDR_RX2_UL_SIG_POWER_MEAS_DELAY2                   0x0655
#define TALISE_ADDR_RX2_UL_SIG_POWER_MEAS_DURATION1                0x0656
#define TALISE_ADDR_RX2_UL_SIG_POWER_MEAS_DURATION2                0x0657
#define TALISE_ADDR_AGC_UNDERRANGE0_0                              0x0658
#define TALISE_ADDR_AGC_UNDERRANGE0_1                              0x0659
#define TALISE_ADDR_AGC_UNDERRANGE1                                0x065A
#define TALISE_ADDR_AGC_UNDERRANGE2                                0x065B
#define TALISE_ADDR_AGC_IP3_OVERRANGE_THRESHOLD                    0x065C
#define TALISE_ADDR_AGC_ADCOVRG_IP3_HIGH_COUNTER                   0x065D
#define TALISE_ADDR_AGC_ADCOVRG_LOW_INT0_COUNTER                   0X065E
#define TALISE_ADDR_AGC_ADCOVRG_LOW_INT1_COUNTER                   0X065F
#define TALISE_ADDR_AGC_OVRG_LOW_INT0_GAIN_STEP                    0x0660
#define TALISE_ADDR_AGC_OVRG_LOW_INT1_GAIN_STEP                    0x0661
#define TALISE_ADDR_SLOWLOOP_CONFIG2                               0x0662
#define TALISE_ADDR_RX1_AGC_DUALBAND_INDEX_X                       0x0663
#define TALISE_ADDR_RX1_AGC_DUALBAND_INDEX_Y                       0x0664
#define TALISE_ADDR_RX1_SLOWLOOP_CONFIG                            0x0665
#define TALISE_ADDR_RX2_AGC_DUALBAND_INDEX_X                       0x0666
#define TALISE_ADDR_RX2_AGC_DUALBAND_INDEX_Y                       0x0667
#define TALISE_ADDR_RX2_SLOWLOOP_CONFIG                            0x0668
#define TALISE_ADDR_AGC_DUALBAND_TOTAL_PWR_MARGIN                  0x066A
#define TALISE_ADDR_AGC_DUALBAND_BAND_PWR_MARGIN                   0x066B
#define TALISE_ADDR_AGC_UPPER_POWER_THRESHOLD                      0x066C
#define TALISE_ADDR_AGC_DUALBAND_HIGH_LNA_THRESHOLD                0x066D
#define TALISE_ADDR_AGC_DUALBAND_LOW_LNA_THRESHOLD                 0x066E
#define TALISE_ADDR_RX1_GAIN_INDEX                                 0x0686
#define TALISE_ADDR_ORX1_GAIN_INDEX                                0x0687
#define TALISE_ADDR_RX2_GAIN_INDEX                                 0x0688
#define TALISE_ADDR_ORX2_GAIN_INDEX                                0x0689
#define TALISE_ADDR_DEC_POWER_CONFIG_1                             0x070B
#define TALISE_ADDR_DEC_POWER_DURATION                             0x070C
#define TALISE_ADDR_DDC_DEC_POWER_CONFIG                           0x0720
#define TALISE_ADDR_DDC_DEC_POWER_MEAS                             0x0721
#define TALISE_ADDR_DEC_POWER_CH1                                  0x0745
#define TALISE_ADDR_DEC_POWER_CH2                                  0x0746
#define TALISE_ADDR_DIGITAL_GAIN_CONFIG                            0x0780
#define TALISE_ADDR_GAIN_COMPENATION_AND_SLICER_CONFIG             0x0781
#define TALISE_ADDR_RX1_SLICER_GPIO_CONFIG                         0x0782
#define TALISE_ADDR_RX2_SLICER_GPIO_CONFIG                         0x0783
#define TALISE_ADDR_RXDP_SLICER_READBACK                           0x0784
#define TALISE_ADDR_GAIN_COMPENSATION_AND_SLICER_CONFIG2           0x0785
#define TALISE_ADDR_GAIN_TABLE_WORD_ADDRESS                        0x07C0
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_RXFE                      0x07C1
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_EXT                       0x07C2
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_DIG                       0x07C3
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_DIG2                      0x07C4
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_DUALBAND                  0x07C5
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_PHASE_OFFSET              0x07C6
#define TALISE_ADDR_GAIN_TABLE_WORD_DATA_PHASE_OFFSET2             0x07C7
#define TALISE_ADDR_GAIN_TABLE_DATA_OUTPUT_DUALBAND_CH1_BAND_A     0x07CD
#define TALISE_ADDR_GAIN_TABLE_DATA_OUTPUT_DUALBAND_CH1_BAND_B     0x07CE
#define TALISE_ADDR_GAIN_TABLE_DATA_OUTPUT_DUALBAND_CH2_BAND_A     0x07D6
#define TALISE_ADDR_GAIN_TABLE_DATA_OUTPUT_DUALBAND_CH2_BAND_B     0x07D7
#define TALISE_ADDR_GAIN_TABLE_CONFIGURATION                       0x07DA
#define TALISE_ADDR_RXFE1_LOCM                                     0x0800
#define TALISE_ADDR_RXFE2_LOCM                                     0x0801
#define TALISE_ADDR_LO_MUX_CONFIG                                  0x0880
#define TALISE_ADDR_DEC_OVERLOAD_CONFIG1                           0x0943
#define TALISE_ADDR_DEC_OVERLOAD_CONFIG2                           0x0944
#define TALISE_ADDR_DEC_OVERLOAD_UPPER_THRESHOLD                   0x0945
#define TALISE_ADDR_DEC_OVERLOAD_LOWER_THRESHOLD                   0x0946
#define TALISE_ADDR_DEC_UNDERRANGE_INTERVAL0_THRESHOLD             0x0947
#define TALISE_ADDR_DEC_UNDERRANGE_INTERVAL1_THRESHOLD             0x0948
#define TALISE_ADDR_DEC_IP3_OVERRANGE_THRESHOLD                    0x0949
#define TALISE_ADDR_ADC_BIAS_FLASH_VISB                            0x09C4
#define TALISE_ADDR_DIGITAL_DC_OFFSET_SHIFT                        0x0B01
#define TALISE_ADDR_DIGITAL_DC_OFFSET_ORX_SHIFT                    0x0B43
#define TALISE_ADDR_DIGITAL_DC_OFFSET_CONFIG                       0x0B02
#define TALISE_DIGITAL_DC_OFFSET_ORX_LOOPBACK_CONFIG               0x0B40
#define TALISE_ADDR_TX_FILTER_CONFIGURATION                        0x0D45
#define TALISE_ADDR_TX1_ATTENUATION_0_READBACK                     0x0E00
#define TALISE_ADDR_TX1_ATTENUATION_1_READBACK                     0x0E01
#define TALISE_ADDR_TX2_ATTENUATION_0_READBACK                     0x0E03
#define TALISE_ADDR_TX2_ATTENUATION_1_READBACK                     0x0E04
#define TALISE_ADDR_TX1_ATTENUATION_0                              0x0E80
#define TALISE_ADDR_TX1_ATTENUATION_1                              0x0E81
#define TALISE_ADDR_TX2_ATTENUATION_0                              0x0E82
#define TALISE_ADDR_TX2_ATTENUATION_1                              0x0E83
#define TALISE_ADDR_TX1_GAIN_0                                     0x0E87
#define TALISE_ADDR_TX1_GAIN_1                                     0x0E88
#define TALISE_ADDR_TX1_GAIN_2                                     0x0E89
#define TALISE_ADDR_TX2_GAIN_0                                     0x0E8A
#define TALISE_ADDR_TX2_GAIN_1                                     0x0E8B
#define TALISE_ADDR_TX2_GAIN_2                                     0x0E8C
#define TALISE_ADDR_TX_INCR_DECR_WORD                              0x0E8D
#define TALISE_ADDR_TX_TPC_CONFIG                                  0x0E8E
#define TALISE_ADDR_TDD_RAMP_TX1                                   0x0E92
#define TALISE_ADDR_TDD_RAMP_TX2                                   0x0E93
#define TALISE_ADDR_TX_TPC_GPIO_CONFIG                             0x0E96
#define TALISE_ADDR_TXDAC1_GAIN_I                                  0x0EC6
#define TALISE_ADDR_TXDAC1_GAIN_Q                                  0x0EC7
#define TALISE_ADDR_TXDAC2_GAIN_I                                  0x0EC8
#define TALISE_ADDR_TXDAC2_GAIN_Q                                  0x0EC9
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_I_UPPER_NIBBLE             0x0F1B
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_I_MSBS                     0x0F1C
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_I_LSBS                     0x0F1D
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_Q_UPPER_NIBBLE             0x0F1E
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_Q_MSBS                     0x0F1F
#define TALISE_ADDR_TX_ABBF_FREQCAL_NCO_Q_LSBS                     0x0F20
#define TALISE_ADDR_TX_NCO_CH1_CTRL                                0x1020
#define TALISE_ADDR_TX_NCO_CH1_FREQ_TUNE_BYTE_4                    0x1021
#define TALISE_ADDR_TX_NCO_CH1_FREQ_TUNE_BYTE_3                    0x1022
#define TALISE_ADDR_TX_NCO_CH1_FREQ_TUNE_BYTE_2                    0x1023
#define TALISE_ADDR_TX_NCO_CH1_FREQ_TUNE_BYTE_1                    0x1024
#define TALISE_ADDR_TX_NCO_CH1_PHASE_OFFSET_BYTE_2                 0x1025
#define TALISE_ADDR_TX_NCO_CH1_PHASE_OFFSET_BYTE_1                 0x1026
#define TALISE_ADDR_TX_NCO_CH2_CTRL                                0x1027
#define TALISE_ADDR_TX_NCO_CH2_FREQ_TUNE_BYTE_4                    0x1028
#define TALISE_ADDR_TX_NCO_CH2_FREQ_TUNE_BYTE_3                    0x1029
#define TALISE_ADDR_TX_NCO_CH2_FREQ_TUNE_BYTE_2                    0x102A
#define TALISE_ADDR_TX_NCO_CH2_FREQ_TUNE_BYTE_1                    0x102B
#define TALISE_ADDR_TX_NCO_CH2_PHASE_OFFSET_BYTE_2                 0x102C
#define TALISE_ADDR_TX_NCO_CH2_PHASE_OFFSET_BYTE_1                 0x102D
#define TALISE_ADDR_TX_NCO_FREQ_UPDATE                             0x102E
#define TALISE_ADDR_GPIO_3P3V_DIRECTION_CONTROL_0                  0x1080
#define TALISE_ADDR_GPIO_3P3V_DIRECTION_CONTROL_1                  0x1081
#define TALISE_ADDR_GPIO_3P3V_SPI_SOURCE_0                         0x1082
#define TALISE_ADDR_GPIO_3P3V_SPI_SOURCE_1                         0x1083
#define TALISE_ADDR_GPIO_3P3V_SPI_READ_0                           0x1084
#define TALISE_ADDR_GPIO_3P3V_SPI_READ_1                           0x1085
#define TALISE_ADDR_GPIO_3P3V_LOWER_BYTE_SOURCE_CONTROL            0x1086
#define TALISE_ADDR_GPIO_3P3V_UPPER_BYTE_SOURCE_CONTROL            0x1087
#define TALISE_ADDR_GPIO_DIRECTION_CONTROL_7DOWNTO0                0x10C0
#define TALISE_ADDR_GPIO_DIRECTION_CONTROL_15DOWNTO8               0x10C1
#define TALISE_ADDR_GPIO_DIRECTION_CONTROL_18DOWNTO16              0x10C2
#define TALISE_ADDR_GPIO_SPI_SOURCE_7DOWNTO0                       0x10C3
#define TALISE_ADDR_GPIO_SPI_SOURCE_15DOWNTO8                      0x10C4
#define TALISE_ADDR_GPIO_SPI_SOURCE_18DOWNTO16                     0x10C5
#define TALISE_ADDR_GPIO_SPI_READ_7DOWNTO0                         0x10C6
#define TALISE_ADDR_GPIO_SPI_READ_15DOWNTO8                        0x10C7
#define TALISE_ADDR_GPIO_SPI_READ_18DOWNTO16                       0x10C8
#define TALISE_ADDR_GPIO_LOWER_BYTE_SOURCE_CONTROL                 0x10C9
#define TALISE_ADDR_GPIO_UPPER_BYTE_SOURCE_CONTROL                 0x10CA
#define TALISE_ADDR_GPIO_EXTRA_BITS_SOURCE_CONTROL                 0x10CB
#define TALISE_ADDR_MONITOR_0                                      0x1140
#define TALISE_ADDR_MONITOR_1                                      0x1141
#define TALISE_ADDR_PDAUXDAC_MANUAL_IN_MSB                         0x11A5
#define TALISE_ADDR_PDAUXDAC_MANUAL_IN_LSB                         0x11A6
#define TALISE_ADDR_AUX_DAC_0_WORD_MSB                             0x11D0
#define TALISE_ADDR_AUX_DAC_0_WORD_LSB                             0x11D1
#define TALISE_ADDR_AUX_DAC_12B_0_MSB                              0x11E4
#define TALISE_ADDR_AUX_DAC_12B_0_LSB                              0x11E5
#define TALISE_ADDR_AUX_DAC_LATCH_CONTROL                          0x11E8
#define TALISE_ADDR_DIGITAL_TEST_BYTE                              0x1382
#define TALISE_ADDR_ARM_CTL_1                                      0x13C0
#define TALISE_ADDR_ARM_CLOCK_CONTROL                              0x13C8
#define TALISE_ADDR_AHB_SPI_BRIDGE                                 0x13C9
#define TALISE_ADDR_ARM_BOOT_ADDR_BYTE0                            0x13CA
#define TALISE_ADDR_ARM_BOOT_ADDR_BYTE1                            0x13CB
#define TALISE_ADDR_ARM_BOOT_ADDR_BYTE2                            0x13CC
#define TALISE_ADDR_ARM_BOOT_ADDR_BYTE3                            0x13CD
#define TALISE_ADDR_ARM_STACK_PTR_BYTE_0                           0x13CE
#define TALISE_ADDR_ARM_STACK_PTR_BYTE_1                           0x13CF
#define TALISE_ADDR_ARM_STACK_PTR_BYTE_2                           0x13D0
#define TALISE_ADDR_ARM_STACK_PTR_BYTE_3                           0x13D1
#define TALISE_ADDR_BRIDGE_CLOCK_CONTROL                           0x13D5
#define TALISE_ADDR_ARM_ECC_DATA_READBACK                          0x13D9
#define TALISE_ADDR_ARM_ECC_PROG_READBACK                          0x13E1
#define TALISE_ADDR_ARM_DMA_CTL                                    0x13EE
#define TALISE_ADDR_ARM_DMA_ADDR0                                  0x13EF
#define TALISE_ADDR_ARM_DMA_ADDR1                                  0x13F0
#define TALISE_ADDR_ARM_DMA_DATA0                                  0x13F3
#define TALISE_ADDR_ARM_DMA_DATA3                                  0x13F6
#define TALISE_ADDR_ARM_COMMAND                                    0x1400
#define TALISE_ADDR_ARM_EXT_CMD_BYTE_1                             0x1401
#define TALISE_ADDR_ARM_CMD_STATUS_0                               0x1408
#define TALISE_ADDR_ARM_CMD_STATUS_8                               0x1410
#define TALISE_ADDR_ARM_CMD_STATUS_11                              0x1413
#define TALISE_ADDR_ARM_CMD_STATUS_12                              0x1414
#define TALISE_ADDR_STREAM_CONTROL                                 0x14C0
#define TALISE_ADDR_STREAM_BASE_BYTE0                              0x14C1
#define TALISE_ADDR_STREAM_BASE_BYTE1                              0x14C2
#define TALISE_ADDR_LAST_STREAM_NUM                                0x14C4
#define TALISE_ADDR_TX_RX_EN_READBACK                              0x14D6
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG0                         0x14F5
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG1                         0x14F6
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG2                         0x14F7
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG3                         0x14F8
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG4                         0x14F9
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG5                         0x14FA
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG6                         0x14FB
#define TALISE_ADDR_STREAM_PROC_DEBUG_REG7                         0x14FC
#define TALISE_ADDR_STREAM_GPIO_TRIGGER_PIN_SELECT_BYTE1           0x14FE
#define TALISE_ADDR_JESD_FRAMER_L0_CFG0_0                          0x1520
#define TALISE_ADDR_JESD_FRAMER_L0_CFG1_0                          0x1521
#define TALISE_ADDR_JESD_FRAMER_L0_CFG2_0                          0x1522
#define TALISE_ADDR_JESD_FRAMER_L0_CFG3_0                          0x1523
#define TALISE_ADDR_JESD_FRAMER_L0_CFG4_0                          0x1524
#define TALISE_ADDR_JESD_FRAMER_L0_CFG5_0                          0x1525
#define TALISE_ADDR_JESD_FRAMER_L0_CFG6_0                          0x1526
#define TALISE_ADDR_JESD_FRAMER_L0_CFG7_0                          0x1527
#define TALISE_ADDR_JESD_FRAMER_L0_CFG8_0                          0x1528
#define TALISE_ADDR_JESD_FRAMER_L0_CFG9_0                          0x1529
#define TALISE_ADDR_JESD_FRAMER_L0_CFG10_0                         0x152A
#define TALISE_ADDR_JESD_FRAMER_ILAS_MF_COUNT_0                    0x152B
#define TALISE_ADDR_JESD_FRAMER_ASYNC_PTR_DBG_0                    0x152C
#define TALISE_ADDR_JESD_FRAMER_LANE_XBAR_0                        0x152E
#define TALISE_ADDR_JESD_FRAMER_CFG_0                              0x152F
#define TALISE_ADDR_JESD_FRAMER_CFG2_0                             0x1530
#define TALISE_ADDR_JESD_FRAMER_CFG3_0                             0x1531
#define TALISE_ADDR_JESD_FRAMER_CFG4_0                             0x1532
#define TALISE_ADDR_JESD_FRAMER_CFG5_0                             0x1533
#define TALISE_ADDR_JESD_FRAMER_TEST_CFG_0                         0x1534
#define TALISE_ADDR_JESD_FRAMER_SYSREF_CFG_0                       0x1536
#define TALISE_ADDR_JESD_FRAMER_SYSREF_CFG2_0                      0x1537
#define TALISE_ADDR_JESD_FRAMER_SYSREF_CFG3_0                      0x1538
#define TALISE_ADDR_JESD_FRAMER_SAMPLE_XBAR_01_0                   0x1540
#define TALISE_ADDR_JESD_FRAMER_SAMPLE_XBAR_23_0                   0x1541
#define TALISE_ADDR_JESD_FRAMER_SAMPLE_XBAR_45_0                   0x1542
#define TALISE_ADDR_JESD_FRAMER_SAMPLE_XBAR_67_0                   0x1543
#define TALISE_ADDR_JESD_FRAMER_ILAS_MF_COUNT_1                    0x1553
#define TALISE_ADDR_JESD_FRAMER_ASYNC_PTR_DBG_1                    0x1554
#define TALISE_ADDR_JESD_FRAMER_SRST_CFG                           0x1570
#define TALISE_ADDR_JESD_FRAMER_COMMON_CFG                         0x1579
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG0_0                        0x1580
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG1_0                        0x1581
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG2_0                        0x1582
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG3_0                        0x1583
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG4_0                        0x1584
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG5_0                        0x1585
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG6_0                        0x1586
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG7_0                        0x1587
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG8_0                        0x1588
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG9_0                        0x1589
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG10_0                       0x158A
#define TALISE_ADDR_JESD_DEFRAMER_ILAS_MF_COUNT_0                  0x158B
#define TALISE_ADDR_JESD_DEFRAMER_EVENT_OBS_0                      0x158C
#define TALISE_ADDR_JESD_DEFRAMER_LANE_XBAR_0                      0x158D
#define TALISE_ADDR_JESD_DEFRAMER_CFG_0                            0x158F
#define TALISE_ADDR_JESD_DEFRAMER_CFG2_0                           0x1590
#define TALISE_ADDR_JESD_DEFRAMER_CFG3_0                           0x1591
#define TALISE_ADDR_JESD_DEFRAMER_CFG4_0                           0x1592
#define TALISE_ADDR_JESD_DEFRAMER_SYSREF_CFG_0                     0x1593
#define TALISE_ADDR_JESD_DEFRAMER_SYSREF_CFG2_0                    0x1594
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_DET_LAT_BUF_0            0x1596
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG2_0                        0x1598
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG3_0                        0x1599
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG4_0                        0x159A
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG5_0                        0x159B
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG6_0                        0x159C
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS0_0                        0x15A0
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS13_0                       0x15AD
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS14_0                       0x15AE
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS15_0                       0x15AF
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS20_0                       0x15B4
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS21_0                       0x15B5
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS22_0                       0x15B6
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS23_0                       0x15B7
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS24_0                       0x15B8
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS25_0                       0x15B9
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS35_0                       0x15C3
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS36_0                       0x15C4
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS37_0                       0x15C5
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS38_0                       0x15C6
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS39_0                       0x15C7
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS40_0                       0x15C8
#define TALISE_ADDR_JESD_DEFRAMER_L0_CFG0_1                        0x15D0
#define TALISE_ADDR_JESD_DEFRAMER_CFG_1                            0x15DF
#define TALISE_ADDR_JESD_DEFRAMER_SYSREF_CFG2_1                    0x15E4
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_DET_LAT_BUF_1            0x15E6
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG2_1                        0x15E8
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG3_1                        0x15E9
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG5_1                        0x15EB
#define TALISE_ADDR_JESD_DEFRAMER_IP_CFG6_1                        0x15EC
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS0_1                        0x15F0
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS13_1                       0x15FD
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS14_1                       0x15FE
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS15_1                       0x15FF
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS20_1                       0x1604
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS21_1                       0x1605
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS22_1                       0x1606
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS23_1                       0x1607
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS24_1                       0x1608
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS25_1                       0x1609
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS35_1                       0x1613
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS36_1                       0x1614
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS37_1                       0x1615
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS38_1                       0x1616
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS39_1                       0x1617
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS40_1                       0x1618
#define TALISE_ADDR_JESD_DEFRAMER_IP_OBS42_1                       0x161A
#define TALISE_ADDR_JESD_DEFRAMER_CH1_SAMPLE_XBAR                  0x1620
#define TALISE_ADDR_JESD_DEFRAMER_CH2_SAMPLE_XBAR                  0x1621
#define TALISE_ADDR_JESD_DEFRAMER_COMMON_CFG                       0x1623
#define TALISE_ADDR_JESD_DEFRAMER_COMMON_CFG3                      0x1625
#define TALISE_ADDR_JESD_DEFRAMER_SAMPLE_DISABLE_CH1               0x1628
#define TALISE_ADDR_JESD_DEFRAMER_SAMPLE_DISABLE_CH2               0x1629
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_LANE0                    0x162A
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_LANE1                    0x162B
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_LANE2                    0x162C
#define TALISE_ADDR_JESD_DEFRAMER_PTR_DBG_LANE3                    0x162D
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_CFG                         0x162E
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_ERROR_FLAG                  0x162F
#define TALISE_ADDR_JESD_DEFRAMER_SAMPLE_PRBS_ERROR_COUNT          0x1630
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_ERROR_COUNT0                0x1631
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_ERROR_COUNT1                0x1632
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_ERROR_COUNT2                0x1633
#define TALISE_ADDR_JESD_DEFRAMER_PRBS_ERROR_COUNT3                0x1634
#define TALISE_ADDR_PA_PROTECTION_CONFIGURATION                    0x1660
#define TALISE_ADDR_PA_PROTECTION_ATTEN_CONTROL                    0x1661
#define TALISE_ADDR_PA_PROTECTION_THRESHOLD_0                      0x1662
#define TALISE_ADDR_PA_PROTECTION_THRESHOLD_1                      0x1663
#define TALISE_ADDR_PA_PROTECTION_THRESHOLD_2                      0x1664
#define TALISE_ADDR_PA_PROTECTION_THRESHOLD_3                      0x1665
#define TALISE_ADDR_PA_PROTECTION_PEAK_COUNT                       0x1666
#define TALISE_ADDR_PA_PROTECTION_PEAK_THRESHOLD_CH1               0x1667
#define TALISE_ADDR_PA_PROTECTION_PEAK_THRESHOLD_CH2               0x1668
#define TALISE_ADDR_PA_PROTECTION_POWER_0                          0x1669
#define TALISE_ADDR_PA_PROTECTION_POWER_1                          0x166A
#define TALISE_ADDR_PA_PROTECTION_ERROR                            0x166B
#define TALISE_ADDR_FLOATING_POINT_CONFIG                          0x16C0
#define TALISE_ADDR_FLOATING_POINT_CONTROL                         0x16C1
#define TALISE_ADDR_FLOATING_POINT_ENABLE                          0x16C2
#define TALISE_ADDR_INTEGER_FORMAT_CONFIG                          0x16C3
#define TALISE_ADDR_GP_INTERRUPT_MASK_1                            0x1700
#define TALISE_ADDR_GP_INTERRUPT_MASK_0                            0x1701
#define TALISE_ADDR_GP_INTERRUPT_READ_1                            0x1702
#define TALISE_ADDR_GP_INTERRUPT_READ_0                            0x1703
#define TALISE_ADDR_AUX_SYNTH_VCO_BAND_BYTE1                       0x1792
#define TALISE_ADDR_AUX_SYNTH_CAL                                  0x1798
#define TALISE_ADDR_SER_PHY_TXCTRL_0                               0x1850
#define TALISE_ADDR_SER_PHY_TXCTRL_1                               0x1851
#define TALISE_ADDR_SER_PHY_PD                                     0x1853
#define TALISE_ADDR_SER_PHY_ENABLES                                0x1854
#define TALISE_ADDR_SER_PREEMPH_CTRL                               0x1855
#define TALISE_ADDR_DES_PHY_PWR_DWN_0                              0x1869
#define TALISE_ADDR_DES_PHY_PWR_DWN_4                              0x186D
#define TALISE_ADDR_DES_PHY_CLK_CTL_0                              0x1878
#define TALISE_ADDR_DES_PHY_CLK_CTL_1                              0x1879
#define TALISE_ADDR_DES_PHY_GENERAL_CTL_0                          0x187D
#define TALISE_ADDR_DES_PHY_GENERAL_CTL_1                          0x187E
#define TALISE_ADDR_DES_PHY_EQ_CONTROL2                            0x18B0
#define TALISE_ADDR_PHM_CNTRL                                      0x18C0 /* C0 Only */
#define TALISE_ADDR_PHM_PERIOD_BYTE0                               0x18C1 /* C0 Only */
#define TALISE_ADDR_PHM_PERIOD_BYTE1                               0x18C2 /* C0 Only */
#define TALISE_ADDR_PHM_PERIOD_BYTE2                               0x18C3 /* C0 Only */
#define TALISE_ADDR_FOVR_CNTRL                                     0x18CC /* C0 Only */
#define TALISE_ADDR_FOVR_RX_UP_THRESH_BYTE0                        0x18CD /* C0 Only */
#define TALISE_ADDR_FOVR_RX_UP_THRESH_BYTE1                        0x18CE /* C0 Only */
#define TALISE_ADDR_FOVR_RX_LOW_THRESH_BYTE0                       0x18CF /* C0 Only */
#define TALISE_ADDR_FOVR_RX_LOW_THRESH_BYTE1                       0x18D0 /* C0 Only */
#define TALISE_ADDR_FOVR_RX_DWELL_THRESH_BYTE0                     0x18D1 /* C0 Only */
#define TALISE_ADDR_FOVR_RX_DWELL_THRESH_BYTE1                     0x18D2 /* C0 Only */
#define TALISE_ADDR_PHM_FOVR_ON_JESD                               0x18D3 /* C0 Only */
#define TALISE_ADDR_PCA_CNTRL                                      0x18D4 /* C0 Only */
#define TALISE_ADDR_PCA_RX1_GAIN_INDEX_OFFSET                      0x18D5 /* C0 Only */
#define TALISE_ADDR_PCA_RX2_GAIN_INDEX_OFFSET                      0x18D6 /* C0 Only */
#define TALISE_ADDR_PCA_RX1_GAIN_STEP                              0x18D7 /* C0 Only */
#define TALISE_ADDR_PCA_RX2_GAIN_STEP                              0x18D8 /* C0 Only */
#define TALISE_ADDR_SCRATCH_PAD_UPPER_ADDRESS_SPACE                0x3EE0
#define TALISE_ADDR_SCRATCH_PAD_READ_ONLY_UPPER_ADDRESS_SPACE      0x3EE1

#ifdef __cplusplus
}
#endif

#endif
