// SPDX-License-Identifier: GPL-2.0
#ifndef __API_ERRORS_H__
#define __API_ERRORS_H__

#include "api_config.h"

#ifdef __linux__ 
#include <linux/kernel.h>
#include <linux/errno.h>

/*! No Error */
#define API_ERROR_OK 0
#define API_ERROR_SPI_SDO (-EINVAL)
#define API_ERROR_INVALID_HANDLE_PTR (-ENODEV)
#define API_ERROR_INVALID_XFER_PTR (-ENODEV)
#define API_ERROR_INVALID_DELAYUS_PTR (-ENODEV)
#define API_ERROR_INVALID_PARAM (-ENODEV)
#define API_ERROR_NOT_SUPPORTED (-EPERM)

#define API_ERROR_VCO_OUT_OF_RANGE (-ENODEV)
#define API_ERROR_FTW_LOAD_ACK (-ENODEV)
#define API_ERROR_NCO_NOT_ENABLED (-ENODEV)
#define API_ERROR_INIT_SEQ_FAIL (-ENODEV)
#define API_ERROR_TEST_FAILED -(ENODEV)
#define API_ERROR_SPI_XFER	-(ENODEV)
#define API_ERROR_US_DELAY	-(ENODEV)
#define API_ERROR_TX_EN_PIN_CTRL -(ENODEV)
#define API_ERROR_RESET_PIN_CTRL -(ENODEV) 
#define API_ERROR_EVENT_HNDL  -(ENODEV)
#define API_ERROR_HW_OPEN  -(ENODEV)
#define API_ERROR_HW_CLOSE  -(ENODEV)
#else

/*! No Error */
#define API_ERROR_OK 0
#define API_ERROR_SPI_SDO -10
#define API_ERROR_INVALID_HANDLE_PTR -11
#define API_ERROR_INVALID_XFER_PTR -12
#define API_ERROR_INVALID_DELAYUS_PTR -13
#define API_ERROR_INVALID_PARAM -14
#define API_ERROR_NOT_SUPPORTED -15
#define API_ERROR_VCO_OUT_OF_RANGE -20
#define API_ERROR_FTW_LOAD_ACK -30
#define API_ERROR_NCO_NOT_ENABLED -31
#define API_ERROR_INIT_SEQ_FAIL -40
#define API_ERROR_TEST_FAILED -50
#define API_ERROR_SPI_XFER	-60
#define API_ERROR_US_DELAY	-61
#define API_ERROR_TX_EN_PIN_CTRL -62
#define API_ERROR_RESET_PIN_CTRL -63
#define API_ERROR_EVENT_HNDL  -64
#define API_ERROR_HW_OPEN  -65
#define API_ERROR_HW_CLOSE  -66
#endif

ADI_API char *adi_api_get_error_string(int error_code);

#endif /* !__API_ERRORS_H__ */
