/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Xilinx Gamma Correction IP
 *
 * Copyright (C) 2017 Xilinx, Inc.
 */

#ifndef __XILINX_GAMMA_COEFF_H__
#define __XILINX_GAMMA_COEFF_H__

#define GAMMA_CURVE_LENGTH	(40)

#define GAMMA_BPC_8			(8)
#define GAMMA8_TABLE_LENGTH		BIT(GAMMA_BPC_8)
static const u16 xgamma8_01[GAMMA8_TABLE_LENGTH] = {
	0, 147, 157, 164, 168, 172, 175, 178,
	180, 183, 184, 186, 188, 189, 191, 192,
	193, 195, 196, 197, 198, 199, 200, 200,
	201, 202, 203, 204, 204, 205, 206, 207,
	207, 208, 208, 209, 210, 210, 211, 211,
	212, 212, 213, 213, 214, 214, 215, 215,
	216, 216, 217, 217, 218, 218, 218, 219,
	219, 220, 220, 220, 221, 221, 221, 222,
	222, 222, 223, 223, 223, 224, 224, 224,
	225, 225, 225, 226, 226, 226, 227, 227,
	227, 227, 228, 228, 228, 228, 229, 229,
	229, 230, 230, 230, 230, 231, 231, 231,
	231, 232, 232, 232, 232, 232, 233, 233,
	233, 233, 234, 234, 234, 234, 234, 235,
	235, 235, 235, 235, 236, 236, 236, 236,
	236, 237, 237, 237, 237, 237, 238, 238,
	238, 238, 238, 239, 239, 239, 239, 239,
	239, 240, 240, 240, 240, 240, 240, 241,
	241, 241, 241, 241, 241, 242, 242, 242,
	242, 242, 242, 243, 243, 243, 243, 243,
	243, 244, 244, 244, 244, 244, 244, 244,
	245, 245, 245, 245, 245, 245, 245, 246,
	246, 246, 246, 246, 246, 246, 247, 247,
	247, 247, 247, 247, 247, 247, 248, 248,
	248, 248, 248, 248, 248, 249, 249, 249,
	249, 249, 249, 249, 249, 249, 250, 250,
	250, 250, 250, 250, 250, 250, 251, 251,
	251, 251, 251, 251, 251, 251, 251, 252,
	252, 252, 252, 252, 252, 252, 252, 252,
	253, 253, 253, 253, 253, 253, 253, 253,
	253, 254, 254, 254, 254, 254, 254, 254,
	254, 254, 254, 255, 255, 255, 255, 255,
};

static const u16 xgamma8_02[GAMMA8_TABLE_LENGTH] = {
	0, 84, 97, 105, 111, 116, 120, 124,
	128, 131, 133, 136, 138, 141, 143, 145,
	147, 148, 150, 152, 153, 155, 156, 158,
	159, 160, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 179, 180, 181, 182,
	183, 183, 184, 185, 186, 186, 187, 188,
	188, 189, 190, 190, 191, 192, 192, 193,
	193, 194, 195, 195, 196, 196, 197, 197,
	198, 199, 199, 200, 200, 201, 201, 202,
	202, 203, 203, 204, 204, 205, 205, 206,
	206, 207, 207, 208, 208, 208, 209, 209,
	210, 210, 211, 211, 211, 212, 212, 213,
	213, 214, 214, 214, 215, 215, 216, 216,
	216, 217, 217, 217, 218, 218, 219, 219,
	219, 220, 220, 220, 221, 221, 221, 222,
	222, 223, 223, 223, 224, 224, 224, 225,
	225, 225, 226, 226, 226, 227, 227, 227,
	227, 228, 228, 228, 229, 229, 229, 230,
	230, 230, 231, 231, 231, 231, 232, 232,
	232, 233, 233, 233, 233, 234, 234, 234,
	235, 235, 235, 235, 236, 236, 236, 237,
	237, 237, 237, 238, 238, 238, 238, 239,
	239, 239, 239, 240, 240, 240, 240, 241,
	241, 241, 241, 242, 242, 242, 242, 243,
	243, 243, 243, 244, 244, 244, 244, 245,
	245, 245, 245, 246, 246, 246, 246, 246,
	247, 247, 247, 247, 248, 248, 248, 248,
	248, 249, 249, 249, 249, 250, 250, 250,
	250, 250, 251, 251, 251, 251, 252, 252,
	252, 252, 252, 253, 253, 253, 253, 253,
	254, 254, 254, 254, 254, 255, 255, 255,
};

static const u16 xgamma8_03[GAMMA8_TABLE_LENGTH] = {
	0, 48, 60, 67, 73, 78, 83, 87,
	90, 94, 97, 99, 102, 104, 107, 109,
	111, 113, 115, 117, 119, 121, 122, 124,
	125, 127, 129, 130, 131, 133, 134, 136,
	137, 138, 139, 141, 142, 143, 144, 145,
	146, 147, 148, 149, 151, 152, 153, 154,
	155, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 164, 165, 166, 167, 168,
	168, 169, 170, 171, 172, 172, 173, 174,
	174, 175, 176, 177, 177, 178, 179, 179,
	180, 181, 181, 182, 183, 183, 184, 185,
	185, 186, 187, 187, 188, 188, 189, 190,
	190, 191, 191, 192, 193, 193, 194, 194,
	195, 195, 196, 197, 197, 198, 198, 199,
	199, 200, 200, 201, 201, 202, 202, 203,
	203, 204, 204, 205, 205, 206, 206, 207,
	207, 208, 208, 209, 209, 210, 210, 211,
	211, 212, 212, 213, 213, 213, 214, 214,
	215, 215, 216, 216, 217, 217, 217, 218,
	218, 219, 219, 220, 220, 220, 221, 221,
	222, 222, 223, 223, 223, 224, 224, 225,
	225, 225, 226, 226, 227, 227, 227, 228,
	228, 229, 229, 229, 230, 230, 230, 231,
	231, 232, 232, 232, 233, 233, 233, 234,
	234, 235, 235, 235, 236, 236, 236, 237,
	237, 237, 238, 238, 238, 239, 239, 240,
	240, 240, 241, 241, 241, 242, 242, 242,
	243, 243, 243, 244, 244, 244, 245, 245,
	245, 246, 246, 246, 247, 247, 247, 248,
	248, 248, 249, 249, 249, 249, 250, 250,
	250, 251, 251, 251, 252, 252, 252, 253,
	253, 253, 253, 254, 254, 254, 255, 255,
};

static const u16 xgamma8_04[GAMMA8_TABLE_LENGTH] = {
	0, 28, 37, 43, 48, 53, 57, 61,
	64, 67, 70, 73, 75, 78, 80, 82,
	84, 86, 88, 90, 92, 94, 96, 97,
	99, 101, 102, 104, 105, 107, 108, 110,
	111, 113, 114, 115, 117, 118, 119, 120,
	122, 123, 124, 125, 126, 127, 129, 130,
	131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146,
	147, 148, 149, 149, 150, 151, 152, 153,
	154, 155, 155, 156, 157, 158, 159, 160,
	160, 161, 162, 163, 164, 164, 165, 166,
	167, 167, 168, 169, 170, 170, 171, 172,
	173, 173, 174, 175, 175, 176, 177, 177,
	178, 179, 179, 180, 181, 182, 182, 183,
	183, 184, 185, 185, 186, 187, 187, 188,
	189, 189, 190, 190, 191, 192, 192, 193,
	194, 194, 195, 195, 196, 197, 197, 198,
	198, 199, 199, 200, 201, 201, 202, 202,
	203, 203, 204, 205, 205, 206, 206, 207,
	207, 208, 208, 209, 209, 210, 211, 211,
	212, 212, 213, 213, 214, 214, 215, 215,
	216, 216, 217, 217, 218, 218, 219, 219,
	220, 220, 221, 221, 222, 222, 223, 223,
	224, 224, 225, 225, 226, 226, 227, 227,
	228, 228, 229, 229, 230, 230, 230, 231,
	231, 232, 232, 233, 233, 234, 234, 235,
	235, 235, 236, 236, 237, 237, 238, 238,
	239, 239, 240, 240, 240, 241, 241, 242,
	242, 243, 243, 243, 244, 244, 245, 245,
	246, 246, 246, 247, 247, 248, 248, 248,
	249, 249, 250, 250, 251, 251, 251, 252,
	252, 253, 253, 253, 254, 254, 255, 255,
};

static const u16 xgamma8_05[GAMMA8_TABLE_LENGTH] = {
	0, 16, 23, 28, 32, 36, 39, 42,
	45, 48, 50, 53, 55, 58, 60, 62,
	64, 66, 68, 70, 71, 73, 75, 77,
	78, 80, 81, 83, 84, 86, 87, 89,
	90, 92, 93, 94, 96, 97, 98, 100,
	101, 102, 103, 105, 106, 107, 108, 109,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	135, 136, 137, 138, 139, 140, 141, 142,
	143, 144, 145, 145, 146, 147, 148, 149,
	150, 151, 151, 152, 153, 154, 155, 156,
	156, 157, 158, 159, 160, 160, 161, 162,
	163, 164, 164, 165, 166, 167, 167, 168,
	169, 170, 170, 171, 172, 173, 173, 174,
	175, 176, 176, 177, 178, 179, 179, 180,
	181, 181, 182, 183, 183, 184, 185, 186,
	186, 187, 188, 188, 189, 190, 190, 191,
	192, 192, 193, 194, 194, 195, 196, 196,
	197, 198, 198, 199, 199, 200, 201, 201,
	202, 203, 203, 204, 204, 205, 206, 206,
	207, 208, 208, 209, 209, 210, 211, 211,
	212, 212, 213, 214, 214, 215, 215, 216,
	217, 217, 218, 218, 219, 220, 220, 221,
	221, 222, 222, 223, 224, 224, 225, 225,
	226, 226, 227, 228, 228, 229, 229, 230,
	230, 231, 231, 232, 233, 233, 234, 234,
	235, 235, 236, 236, 237, 237, 238, 238,
	239, 240, 240, 241, 241, 242, 242, 243,
	243, 244, 244, 245, 245, 246, 246, 247,
	247, 248, 248, 249, 249, 250, 250, 251,
	251, 252, 252, 253, 253, 254, 254, 255,
};

static const u16 xgamma8_06[GAMMA8_TABLE_LENGTH] = {
	0, 9, 14, 18, 21, 24, 27, 29,
	32, 34, 37, 39, 41, 43, 45, 47,
	48, 50, 52, 54, 55, 57, 59, 60,
	62, 63, 65, 66, 68, 69, 71, 72,
	73, 75, 76, 77, 79, 80, 81, 83,
	84, 85, 86, 88, 89, 90, 91, 92,
	94, 95, 96, 97, 98, 99, 100, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 120, 121, 122, 123, 124, 125, 126,
	127, 128, 129, 130, 131, 132, 133, 134,
	135, 136, 137, 137, 138, 139, 140, 141,
	142, 143, 144, 145, 145, 146, 147, 148,
	149, 150, 151, 151, 152, 153, 154, 155,
	156, 156, 157, 158, 159, 160, 161, 161,
	162, 163, 164, 165, 165, 166, 167, 168,
	169, 169, 170, 171, 172, 173, 173, 174,
	175, 176, 176, 177, 178, 179, 179, 180,
	181, 182, 182, 183, 184, 185, 185, 186,
	187, 188, 188, 189, 190, 191, 191, 192,
	193, 194, 194, 195, 196, 196, 197, 198,
	199, 199, 200, 201, 201, 202, 203, 203,
	204, 205, 206, 206, 207, 208, 208, 209,
	210, 210, 211, 212, 212, 213, 214, 214,
	215, 216, 216, 217, 218, 218, 219, 220,
	220, 221, 222, 222, 223, 224, 224, 225,
	226, 226, 227, 228, 228, 229, 230, 230,
	231, 231, 232, 233, 233, 234, 235, 235,
	236, 237, 237, 238, 238, 239, 240, 240,
	241, 242, 242, 243, 243, 244, 245, 245,
	246, 247, 247, 248, 248, 249, 250, 250,
	251, 251, 252, 253, 253, 254, 254, 255,
};

static const u16 xgamma8_07[GAMMA8_TABLE_LENGTH] = {
	0, 5, 9, 11, 14, 16, 18, 21,
	23, 25, 26, 28, 30, 32, 33, 35,
	37, 38, 40, 41, 43, 44, 46, 47,
	49, 50, 52, 53, 54, 56, 57, 58,
	60, 61, 62, 64, 65, 66, 67, 69,
	70, 71, 72, 73, 75, 76, 77, 78,
	79, 80, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 102, 103, 104,
	105, 106, 107, 108, 109, 110, 111, 112,
	113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 142,
	143, 144, 145, 146, 147, 148, 149, 150,
	150, 151, 152, 153, 154, 155, 156, 157,
	157, 158, 159, 160, 161, 162, 163, 163,
	164, 165, 166, 167, 168, 168, 169, 170,
	171, 172, 173, 173, 174, 175, 176, 177,
	178, 178, 179, 180, 181, 182, 182, 183,
	184, 185, 186, 186, 187, 188, 189, 190,
	190, 191, 192, 193, 194, 194, 195, 196,
	197, 197, 198, 199, 200, 201, 201, 202,
	203, 204, 204, 205, 206, 207, 208, 208,
	209, 210, 211, 211, 212, 213, 214, 214,
	215, 216, 217, 217, 218, 219, 220, 220,
	221, 222, 223, 223, 224, 225, 226, 226,
	227, 228, 228, 229, 230, 231, 231, 232,
	233, 234, 234, 235, 236, 237, 237, 238,
	239, 239, 240, 241, 242, 242, 243, 244,
	244, 245, 246, 247, 247, 248, 249, 249,
	250, 251, 251, 252, 253, 254, 254, 255,
};

static const u16 xgamma8_08[GAMMA8_TABLE_LENGTH] = {
	0, 3, 5, 7, 9, 11, 13, 14,
	16, 18, 19, 21, 22, 24, 25, 26,
	28, 29, 31, 32, 33, 35, 36, 37,
	39, 40, 41, 42, 44, 45, 46, 47,
	48, 50, 51, 52, 53, 54, 56, 57,
	58, 59, 60, 61, 63, 64, 65, 66,
	67, 68, 69, 70, 71, 73, 74, 75,
	76, 77, 78, 79, 80, 81, 82, 83,
	84, 85, 86, 88, 89, 90, 91, 92,
	93, 94, 95, 96, 97, 98, 99, 100,
	101, 102, 103, 104, 105, 106, 107, 108,
	109, 110, 111, 112, 113, 114, 115, 116,
	117, 118, 119, 120, 121, 122, 123, 123,
	124, 125, 126, 127, 128, 129, 130, 131,
	132, 133, 134, 135, 136, 137, 138, 139,
	140, 140, 141, 142, 143, 144, 145, 146,
	147, 148, 149, 150, 151, 151, 152, 153,
	154, 155, 156, 157, 158, 159, 160, 161,
	161, 162, 163, 164, 165, 166, 167, 168,
	169, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 177, 178, 179, 180, 181, 182,
	183, 183, 184, 185, 186, 187, 188, 189,
	190, 190, 191, 192, 193, 194, 195, 196,
	196, 197, 198, 199, 200, 201, 202, 202,
	203, 204, 205, 206, 207, 207, 208, 209,
	210, 211, 212, 212, 213, 214, 215, 216,
	217, 217, 218, 219, 220, 221, 222, 222,
	223, 224, 225, 226, 227, 227, 228, 229,
	230, 231, 232, 232, 233, 234, 235, 236,
	236, 237, 238, 239, 240, 240, 241, 242,
	243, 244, 245, 245, 246, 247, 248, 249,
	249, 250, 251, 252, 253, 253, 254, 255,
};

static const u16 xgamma8_09[GAMMA8_TABLE_LENGTH] = {
	0, 2, 3, 5, 6, 7, 9, 10,
	11, 13, 14, 15, 16, 18, 19, 20,
	21, 22, 23, 25, 26, 27, 28, 29,
	30, 32, 33, 34, 35, 36, 37, 38,
	39, 40, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72,
	73, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89,
	90, 91, 92, 93, 94, 95, 96, 97,
	98, 99, 100, 101, 102, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113,
	114, 115, 116, 117, 118, 119, 120, 121,
	122, 123, 124, 125, 126, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136,
	137, 138, 139, 140, 141, 142, 143, 144,
	145, 146, 147, 148, 149, 150, 151, 152,
	152, 153, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 170, 171, 172, 173, 174,
	175, 176, 177, 178, 179, 180, 181, 182,
	183, 184, 185, 185, 186, 187, 188, 189,
	190, 191, 192, 193, 194, 195, 196, 197,
	198, 198, 199, 200, 201, 202, 203, 204,
	205, 206, 207, 208, 209, 210, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 221, 222, 223, 224, 225, 226,
	227, 228, 229, 230, 231, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241,
	241, 242, 243, 244, 245, 246, 247, 248,
	249, 250, 250, 251, 252, 253, 254, 255,
};

static const u16 xgamma8_10[GAMMA8_TABLE_LENGTH] = {
	0, 1, 2, 3, 4, 5, 6, 7,
	8, 9, 10, 11, 12, 13, 14, 15,
	16, 17, 18, 19, 20, 21, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 77, 78, 79,
	80, 81, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 111,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 143,
	144, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 154, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183,
	184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207,
	208, 209, 210, 211, 212, 213, 214, 215,
	216, 217, 218, 219, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 245, 246, 247,
	248, 249, 250, 251, 252, 253, 254, 255,
};

static const u16 xgamma8_11[GAMMA8_TABLE_LENGTH] = {
	0, 1, 1, 2, 3, 3, 4, 5,
	6, 6, 7, 8, 9, 10, 10, 11,
	12, 13, 14, 15, 16, 16, 17, 18,
	19, 20, 21, 22, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 31, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40,
	41, 42, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 90, 91, 92, 93, 94,
	95, 96, 97, 98, 99, 100, 101, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	111, 112, 113, 114, 115, 116, 117, 118,
	119, 121, 122, 123, 124, 125, 126, 127,
	128, 129, 130, 131, 132, 133, 134, 135,
	136, 137, 138, 139, 140, 141, 142, 143,
	144, 145, 146, 147, 149, 150, 151, 152,
	153, 154, 155, 156, 157, 158, 159, 160,
	161, 162, 163, 164, 165, 166, 167, 169,
	170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 181, 182, 183, 184, 186,
	187, 188, 189, 190, 191, 192, 193, 194,
	195, 196, 197, 198, 199, 201, 202, 203,
	204, 205, 206, 207, 208, 209, 210, 211,
	212, 214, 215, 216, 217, 218, 219, 220,
	221, 222, 223, 224, 225, 227, 228, 229,
	230, 231, 232, 233, 234, 235, 236, 237,
	239, 240, 241, 242, 243, 244, 245, 246,
	247, 248, 250, 251, 252, 253, 254, 255,
};

static const u16 xgamma8_12[GAMMA8_TABLE_LENGTH] = {
	0, 0, 1, 1, 2, 2, 3, 3,
	4, 5, 5, 6, 7, 7, 8, 9,
	9, 10, 11, 11, 12, 13, 13, 14,
	15, 16, 16, 17, 18, 19, 20, 20,
	21, 22, 23, 24, 24, 25, 26, 27,
	28, 28, 29, 30, 31, 32, 33, 34,
	34, 35, 36, 37, 38, 39, 40, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	87, 88, 89, 90, 91, 92, 93, 94,
	95, 96, 97, 98, 99, 100, 101, 102,
	103, 104, 105, 106, 107, 108, 109, 110,
	112, 113, 114, 115, 116, 117, 118, 119,
	120, 121, 122, 123, 124, 125, 126, 127,
	128, 130, 131, 132, 133, 134, 135, 136,
	137, 138, 139, 140, 141, 142, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 153,
	155, 156, 157, 158, 159, 160, 161, 162,
	163, 165, 166, 167, 168, 169, 170, 171,
	172, 173, 175, 176, 177, 178, 179, 180,
	181, 183, 184, 185, 186, 187, 188, 189,
	191, 192, 193, 194, 195, 196, 197, 199,
	200, 201, 202, 203, 204, 205, 207, 208,
	209, 210, 211, 212, 214, 215, 216, 217,
	218, 219, 221, 222, 223, 224, 225, 226,
	228, 229, 230, 231, 232, 234, 235, 236,
	237, 238, 239, 241, 242, 243, 244, 245,
	247, 248, 249, 250, 251, 253, 254, 255,
};

static const u16 xgamma8_13[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 1, 1, 2, 2, 2,
	3, 3, 4, 4, 5, 5, 6, 6,
	7, 8, 8, 9, 9, 10, 11, 11,
	12, 12, 13, 14, 14, 15, 16, 16,
	17, 18, 19, 19, 20, 21, 21, 22,
	23, 24, 24, 25, 26, 27, 28, 28,
	29, 30, 31, 31, 32, 33, 34, 35,
	36, 36, 37, 38, 39, 40, 41, 41,
	42, 43, 44, 45, 46, 47, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	72, 73, 74, 75, 76, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	88, 89, 90, 91, 92, 93, 94, 95,
	96, 97, 98, 99, 100, 101, 102, 103,
	104, 105, 106, 107, 108, 109, 110, 112,
	113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 124, 125, 126, 127, 128, 129,
	130, 131, 132, 133, 135, 136, 137, 138,
	139, 140, 141, 143, 144, 145, 146, 147,
	148, 149, 151, 152, 153, 154, 155, 156,
	157, 159, 160, 161, 162, 163, 164, 166,
	167, 168, 169, 170, 172, 173, 174, 175,
	176, 178, 179, 180, 181, 182, 184, 185,
	186, 187, 188, 190, 191, 192, 193, 194,
	196, 197, 198, 199, 201, 202, 203, 204,
	206, 207, 208, 209, 210, 212, 213, 214,
	215, 217, 218, 219, 220, 222, 223, 224,
	226, 227, 228, 229, 231, 232, 233, 234,
	236, 237, 238, 240, 241, 242, 243, 245,
	246, 247, 249, 250, 251, 252, 254, 255,
};

static const u16 xgamma8_14[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 1, 1, 1, 1, 2,
	2, 2, 3, 3, 4, 4, 4, 5,
	5, 6, 6, 7, 7, 8, 8, 9,
	9, 10, 10, 11, 12, 12, 13, 13,
	14, 15, 15, 16, 16, 17, 18, 18,
	19, 20, 20, 21, 22, 22, 23, 24,
	25, 25, 26, 27, 28, 28, 29, 30,
	31, 31, 32, 33, 34, 34, 35, 36,
	37, 38, 38, 39, 40, 41, 42, 43,
	43, 44, 45, 46, 47, 48, 49, 49,
	50, 51, 52, 53, 54, 55, 56, 57,
	57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 85, 86, 87, 88,
	89, 90, 91, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 103, 104, 105,
	106, 107, 108, 109, 110, 111, 112, 113,
	115, 116, 117, 118, 119, 120, 121, 122,
	124, 125, 126, 127, 128, 129, 130, 132,
	133, 134, 135, 136, 137, 139, 140, 141,
	142, 143, 145, 146, 147, 148, 149, 151,
	152, 153, 154, 155, 157, 158, 159, 160,
	161, 163, 164, 165, 166, 168, 169, 170,
	171, 173, 174, 175, 176, 178, 179, 180,
	181, 183, 184, 185, 187, 188, 189, 190,
	192, 193, 194, 196, 197, 198, 200, 201,
	202, 203, 205, 206, 207, 209, 210, 211,
	213, 214, 215, 217, 218, 219, 221, 222,
	223, 225, 226, 227, 229, 230, 232, 233,
	234, 236, 237, 238, 240, 241, 242, 244,
	245, 247, 248, 249, 251, 252, 254, 255,
};

static const u16 xgamma8_15[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 2, 2, 2, 3, 3, 3, 4,
	4, 4, 5, 5, 6, 6, 6, 7,
	7, 8, 8, 9, 9, 10, 10, 11,
	11, 12, 12, 13, 14, 14, 15, 15,
	16, 16, 17, 18, 18, 19, 20, 20,
	21, 21, 22, 23, 23, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 31, 31,
	32, 33, 34, 34, 35, 36, 37, 37,
	38, 39, 40, 41, 41, 42, 43, 44,
	45, 46, 46, 47, 48, 49, 50, 51,
	52, 53, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 63, 64, 65, 65,
	66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 88, 89, 90,
	91, 92, 93, 94, 95, 96, 97, 98,
	99, 100, 102, 103, 104, 105, 106, 107,
	108, 109, 110, 112, 113, 114, 115, 116,
	117, 119, 120, 121, 122, 123, 124, 126,
	127, 128, 129, 130, 132, 133, 134, 135,
	136, 138, 139, 140, 141, 142, 144, 145,
	146, 147, 149, 150, 151, 152, 154, 155,
	156, 158, 159, 160, 161, 163, 164, 165,
	167, 168, 169, 171, 172, 173, 174, 176,
	177, 178, 180, 181, 182, 184, 185, 187,
	188, 189, 191, 192, 193, 195, 196, 197,
	199, 200, 202, 203, 204, 206, 207, 209,
	210, 211, 213, 214, 216, 217, 218, 220,
	221, 223, 224, 226, 227, 228, 230, 231,
	233, 234, 236, 237, 239, 240, 242, 243,
	245, 246, 248, 249, 251, 252, 254, 255,
};

static const u16 xgamma8_16[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 3,
	3, 3, 4, 4, 4, 5, 5, 5,
	6, 6, 7, 7, 7, 8, 8, 9,
	9, 10, 10, 11, 11, 12, 12, 13,
	13, 14, 14, 15, 15, 16, 16, 17,
	18, 18, 19, 19, 20, 21, 21, 22,
	23, 23, 24, 25, 25, 26, 27, 27,
	28, 29, 29, 30, 31, 31, 32, 33,
	34, 34, 35, 36, 37, 38, 38, 39,
	40, 41, 42, 42, 43, 44, 45, 46,
	46, 47, 48, 49, 50, 51, 52, 53,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75,
	76, 77, 78, 79, 80, 81, 83, 84,
	85, 86, 87, 88, 89, 90, 91, 92,
	93, 94, 95, 97, 98, 99, 100, 101,
	102, 103, 104, 106, 107, 108, 109, 110,
	111, 113, 114, 115, 116, 117, 119, 120,
	121, 122, 123, 125, 126, 127, 128, 130,
	131, 132, 133, 135, 136, 137, 138, 140,
	141, 142, 143, 145, 146, 147, 149, 150,
	151, 153, 154, 155, 157, 158, 159, 161,
	162, 163, 165, 166, 167, 169, 170, 171,
	173, 174, 176, 177, 178, 180, 181, 183,
	184, 185, 187, 188, 190, 191, 193, 194,
	196, 197, 198, 200, 201, 203, 204, 206,
	207, 209, 210, 212, 213, 215, 216, 218,
	219, 221, 222, 224, 225, 227, 228, 230,
	231, 233, 235, 236, 238, 239, 241, 242,
	244, 245, 247, 249, 250, 252, 253, 255,
};

static const u16 xgamma8_17[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 2, 2, 2,
	2, 3, 3, 3, 3, 4, 4, 4,
	5, 5, 5, 6, 6, 6, 7, 7,
	7, 8, 8, 9, 9, 10, 10, 10,
	11, 11, 12, 12, 13, 13, 14, 14,
	15, 15, 16, 17, 17, 18, 18, 19,
	19, 20, 21, 21, 22, 22, 23, 24,
	24, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 33, 33, 34, 35,
	36, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	48, 49, 50, 51, 52, 53, 54, 55,
	56, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 81, 82, 83, 84, 85, 86,
	88, 89, 90, 91, 92, 93, 94, 95,
	97, 98, 99, 100, 101, 102, 103, 105,
	106, 107, 108, 109, 111, 112, 113, 114,
	115, 117, 118, 119, 120, 122, 123, 124,
	125, 127, 128, 129, 131, 132, 133, 134,
	136, 137, 138, 140, 141, 142, 144, 145,
	146, 148, 149, 151, 152, 153, 155, 156,
	157, 159, 160, 162, 163, 164, 166, 167,
	169, 170, 172, 173, 174, 176, 177, 179,
	180, 182, 183, 185, 186, 188, 189, 191,
	192, 194, 195, 197, 198, 200, 201, 203,
	205, 206, 208, 209, 211, 212, 214, 216,
	217, 219, 220, 222, 224, 225, 227, 228,
	230, 232, 233, 235, 237, 238, 240, 242,
	243, 245, 247, 248, 250, 252, 253, 255,
};

static const u16 xgamma8_18[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	4, 4, 4, 4, 5, 5, 5, 6,
	6, 6, 7, 7, 8, 8, 8, 9,
	9, 10, 10, 10, 11, 11, 12, 12,
	13, 13, 14, 14, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 21,
	21, 22, 22, 23, 24, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 30, 31,
	32, 32, 33, 34, 35, 35, 36, 37,
	38, 38, 39, 40, 41, 41, 42, 43,
	44, 45, 46, 46, 47, 48, 49, 50,
	51, 52, 53, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65,
	66, 67, 68, 69, 70, 71, 72, 73,
	74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 86, 87, 88, 89, 90,
	91, 92, 93, 95, 96, 97, 98, 99,
	100, 102, 103, 104, 105, 107, 108, 109,
	110, 111, 113, 114, 115, 116, 118, 119,
	120, 122, 123, 124, 126, 127, 128, 129,
	131, 132, 134, 135, 136, 138, 139, 140,
	142, 143, 145, 146, 147, 149, 150, 152,
	153, 154, 156, 157, 159, 160, 162, 163,
	165, 166, 168, 169, 171, 172, 174, 175,
	177, 178, 180, 181, 183, 184, 186, 188,
	189, 191, 192, 194, 195, 197, 199, 200,
	202, 204, 205, 207, 208, 210, 212, 213,
	215, 217, 218, 220, 222, 224, 225, 227,
	229, 230, 232, 234, 236, 237, 239, 241,
	243, 244, 246, 248, 250, 251, 253, 255,
};

static const u16 xgamma8_19[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 4, 4, 4, 4, 5,
	5, 5, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	11, 11, 12, 12, 12, 13, 13, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 20, 20, 21, 21, 22, 22,
	23, 24, 24, 25, 26, 26, 27, 28,
	28, 29, 30, 30, 31, 32, 32, 33,
	34, 35, 35, 36, 37, 38, 38, 39,
	40, 41, 41, 42, 43, 44, 45, 46,
	46, 47, 48, 49, 50, 51, 52, 53,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 81, 82, 83, 84, 85,
	86, 87, 88, 90, 91, 92, 93, 94,
	95, 97, 98, 99, 100, 101, 103, 104,
	105, 106, 108, 109, 110, 112, 113, 114,
	115, 117, 118, 119, 121, 122, 123, 125,
	126, 127, 129, 130, 132, 133, 134, 136,
	137, 139, 140, 141, 143, 144, 146, 147,
	149, 150, 152, 153, 155, 156, 158, 159,
	161, 162, 164, 165, 167, 168, 170, 172,
	173, 175, 176, 178, 180, 181, 183, 184,
	186, 188, 189, 191, 193, 194, 196, 198,
	199, 201, 203, 204, 206, 208, 210, 211,
	213, 215, 217, 218, 220, 222, 224, 225,
	227, 229, 231, 233, 235, 236, 238, 240,
	242, 244, 246, 247, 249, 251, 253, 255,
};

static const u16 xgamma8_20[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 4, 4,
	4, 4, 5, 5, 5, 5, 6, 6,
	6, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	20, 21, 21, 22, 23, 23, 24, 24,
	25, 26, 26, 27, 28, 28, 29, 30,
	30, 31, 32, 32, 33, 34, 35, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	42, 43, 44, 45, 46, 47, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 84, 85, 86, 87, 88, 89,
	91, 92, 93, 94, 95, 97, 98, 99,
	100, 102, 103, 104, 105, 107, 108, 109,
	111, 112, 113, 115, 116, 117, 119, 120,
	121, 123, 124, 126, 127, 128, 130, 131,
	133, 134, 136, 137, 139, 140, 142, 143,
	145, 146, 148, 149, 151, 152, 154, 155,
	157, 158, 160, 162, 163, 165, 166, 168,
	170, 171, 173, 175, 176, 178, 180, 181,
	183, 185, 186, 188, 190, 192, 193, 195,
	197, 199, 200, 202, 204, 206, 207, 209,
	211, 213, 215, 217, 218, 220, 222, 224,
	226, 228, 230, 232, 233, 235, 237, 239,
	241, 243, 245, 247, 249, 251, 253, 255,
};

static const u16 xgamma8_21[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 5, 5,
	5, 5, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	11, 11, 11, 12, 12, 13, 13, 14,
	14, 14, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 20, 20, 21, 21, 22,
	22, 23, 24, 24, 25, 25, 26, 27,
	27, 28, 29, 29, 30, 31, 31, 32,
	33, 33, 34, 35, 36, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 44,
	45, 46, 47, 48, 49, 50, 51, 51,
	52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 75, 76,
	77, 78, 79, 80, 81, 83, 84, 85,
	86, 87, 88, 90, 91, 92, 93, 95,
	96, 97, 98, 100, 101, 102, 104, 105,
	106, 107, 109, 110, 112, 113, 114, 116,
	117, 118, 120, 121, 123, 124, 126, 127,
	129, 130, 131, 133, 134, 136, 137, 139,
	141, 142, 144, 145, 147, 148, 150, 151,
	153, 155, 156, 158, 160, 161, 163, 165,
	166, 168, 170, 171, 173, 175, 176, 178,
	180, 182, 183, 185, 187, 189, 191, 192,
	194, 196, 198, 200, 202, 203, 205, 207,
	209, 211, 213, 215, 217, 219, 221, 223,
	225, 226, 228, 230, 232, 234, 236, 238,
	241, 243, 245, 247, 249, 251, 253, 255,
};

static const u16 xgamma8_22[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	25, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 33, 33, 34, 35,
	35, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	49, 49, 50, 51, 52, 53, 54, 55,
	56, 57, 58, 59, 60, 61, 62, 63,
	64, 65, 66, 67, 68, 69, 70, 71,
	73, 74, 75, 76, 77, 78, 79, 81,
	82, 83, 84, 85, 87, 88, 89, 90,
	91, 93, 94, 95, 97, 98, 99, 100,
	102, 103, 105, 106, 107, 109, 110, 111,
	113, 114, 116, 117, 119, 120, 121, 123,
	124, 126, 127, 129, 130, 132, 133, 135,
	137, 138, 140, 141, 143, 145, 146, 148,
	149, 151, 153, 154, 156, 158, 159, 161,
	163, 165, 166, 168, 170, 172, 173, 175,
	177, 179, 181, 182, 184, 186, 188, 190,
	192, 194, 196, 197, 199, 201, 203, 205,
	207, 209, 211, 213, 215, 217, 219, 221,
	223, 225, 227, 229, 231, 234, 236, 238,
	240, 242, 244, 246, 248, 251, 253, 255,
};

static const u16 xgamma8_23[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 10, 10, 10,
	11, 11, 11, 12, 12, 13, 13, 13,
	14, 14, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 19, 20, 20, 21, 21,
	22, 23, 23, 24, 24, 25, 26, 26,
	27, 28, 28, 29, 30, 30, 31, 32,
	32, 33, 34, 35, 35, 36, 37, 38,
	38, 39, 40, 41, 42, 42, 43, 44,
	45, 46, 47, 48, 49, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 65, 66, 67,
	69, 70, 71, 72, 73, 74, 75, 76,
	78, 79, 80, 81, 82, 84, 85, 86,
	87, 89, 90, 91, 92, 94, 95, 96,
	98, 99, 100, 102, 103, 104, 106, 107,
	109, 110, 112, 113, 114, 116, 117, 119,
	120, 122, 123, 125, 126, 128, 130, 131,
	133, 134, 136, 138, 139, 141, 143, 144,
	146, 148, 149, 151, 153, 154, 156, 158,
	160, 161, 163, 165, 167, 169, 170, 172,
	174, 176, 178, 180, 182, 183, 185, 187,
	189, 191, 193, 195, 197, 199, 201, 203,
	205, 207, 209, 211, 213, 215, 218, 220,
	222, 224, 226, 228, 230, 233, 235, 237,
	239, 241, 244, 246, 248, 250, 253, 255,
};

static const u16 xgamma8_24[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 6, 6, 6, 6,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 14, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	24, 25, 26, 26, 27, 28, 28, 29,
	30, 30, 31, 32, 32, 33, 34, 35,
	35, 36, 37, 38, 39, 39, 40, 41,
	42, 43, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 53, 54, 55,
	56, 57, 58, 59, 60, 62, 63, 64,
	65, 66, 67, 68, 69, 70, 71, 73,
	74, 75, 76, 77, 78, 80, 81, 82,
	83, 85, 86, 87, 88, 90, 91, 92,
	94, 95, 96, 98, 99, 100, 102, 103,
	105, 106, 108, 109, 111, 112, 114, 115,
	117, 118, 120, 121, 123, 124, 126, 127,
	129, 131, 132, 134, 136, 137, 139, 141,
	142, 144, 146, 148, 149, 151, 153, 155,
	156, 158, 160, 162, 164, 166, 167, 169,
	171, 173, 175, 177, 179, 181, 183, 185,
	187, 189, 191, 193, 195, 197, 199, 201,
	203, 205, 207, 210, 212, 214, 216, 218,
	220, 223, 225, 227, 229, 232, 234, 236,
	239, 241, 243, 246, 248, 250, 253, 255,
};

static const u16 xgamma8_25[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 6,
	6, 6, 6, 7, 7, 7, 7, 8,
	8, 8, 9, 9, 9, 10, 10, 10,
	11, 11, 12, 12, 12, 13, 13, 14,
	14, 15, 15, 15, 16, 16, 17, 17,
	18, 18, 19, 19, 20, 20, 21, 22,
	22, 23, 23, 24, 25, 25, 26, 26,
	27, 28, 28, 29, 30, 30, 31, 32,
	33, 33, 34, 35, 36, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 46, 47, 48, 49, 50, 51, 52,
	53, 54, 55, 56, 57, 58, 59, 60,
	61, 62, 63, 64, 65, 67, 68, 69,
	70, 71, 72, 73, 75, 76, 77, 78,
	80, 81, 82, 83, 85, 86, 87, 89,
	90, 91, 93, 94, 95, 97, 98, 99,
	101, 102, 104, 105, 107, 108, 110, 111,
	113, 114, 116, 117, 119, 121, 122, 124,
	125, 127, 129, 130, 132, 134, 135, 137,
	139, 141, 142, 144, 146, 148, 150, 151,
	153, 155, 157, 159, 161, 163, 165, 166,
	168, 170, 172, 174, 176, 178, 180, 182,
	184, 186, 189, 191, 193, 195, 197, 199,
	201, 204, 206, 208, 210, 212, 215, 217,
	219, 221, 224, 226, 228, 231, 233, 235,
	238, 240, 243, 245, 248, 250, 253, 255,
};

static const u16 xgamma8_26[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 8, 8, 8, 9, 9, 9,
	10, 10, 10, 11, 11, 11, 12, 12,
	13, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	20, 21, 21, 22, 22, 23, 24, 24,
	25, 25, 26, 27, 27, 28, 29, 29,
	30, 31, 31, 32, 33, 34, 34, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 55, 56, 57,
	58, 59, 60, 61, 62, 63, 64, 65,
	66, 68, 69, 70, 71, 72, 73, 75,
	76, 77, 78, 80, 81, 82, 84, 85,
	86, 88, 89, 90, 92, 93, 94, 96,
	97, 99, 100, 102, 103, 105, 106, 108,
	109, 111, 112, 114, 115, 117, 119, 120,
	122, 124, 125, 127, 129, 130, 132, 134,
	136, 137, 139, 141, 143, 145, 146, 148,
	150, 152, 154, 156, 158, 160, 162, 164,
	166, 168, 170, 172, 174, 176, 178, 180,
	182, 184, 186, 188, 191, 193, 195, 197,
	199, 202, 204, 206, 209, 211, 213, 215,
	218, 220, 223, 225, 227, 230, 232, 235,
	237, 240, 242, 245, 247, 250, 252, 255,
};

static const u16 xgamma8_27[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 6, 6,
	6, 6, 7, 7, 7, 7, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 20, 21, 21, 22,
	23, 23, 24, 24, 25, 26, 26, 27,
	28, 28, 29, 30, 30, 31, 32, 33,
	33, 34, 35, 36, 36, 37, 38, 39,
	40, 41, 41, 42, 43, 44, 45, 46,
	47, 48, 49, 50, 51, 51, 52, 53,
	55, 56, 57, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 68, 69, 70, 71,
	72, 74, 75, 76, 77, 79, 80, 81,
	83, 84, 85, 87, 88, 89, 91, 92,
	94, 95, 97, 98, 100, 101, 103, 104,
	106, 107, 109, 110, 112, 114, 115, 117,
	119, 120, 122, 124, 125, 127, 129, 131,
	132, 134, 136, 138, 140, 141, 143, 145,
	147, 149, 151, 153, 155, 157, 159, 161,
	163, 165, 167, 169, 171, 173, 175, 178,
	180, 182, 184, 186, 188, 191, 193, 195,
	198, 200, 202, 205, 207, 209, 212, 214,
	216, 219, 221, 224, 226, 229, 231, 234,
	237, 239, 242, 244, 247, 250, 252, 255,
};

static const u16 xgamma8_28[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 6, 6, 6, 6, 7, 7, 7,
	7, 8, 8, 8, 9, 9, 9, 10,
	10, 10, 11, 11, 11, 12, 12, 13,
	13, 13, 14, 14, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 20,
	21, 21, 22, 22, 23, 24, 24, 25,
	25, 26, 27, 27, 28, 29, 29, 30,
	31, 32, 32, 33, 34, 35, 35, 36,
	37, 38, 39, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 50,
	51, 52, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 63, 64, 66, 67, 68,
	69, 70, 72, 73, 74, 75, 77, 78,
	79, 81, 82, 83, 85, 86, 87, 89,
	90, 92, 93, 95, 96, 98, 99, 101,
	102, 104, 105, 107, 109, 110, 112, 114,
	115, 117, 119, 120, 122, 124, 126, 127,
	129, 131, 133, 135, 137, 138, 140, 142,
	144, 146, 148, 150, 152, 154, 156, 158,
	160, 162, 164, 167, 169, 171, 173, 175,
	177, 180, 182, 184, 186, 189, 191, 193,
	196, 198, 200, 203, 205, 208, 210, 213,
	215, 218, 220, 223, 225, 228, 231, 233,
	236, 239, 241, 244, 247, 249, 252, 255,
};

static const u16 xgamma8_29[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 6, 6, 6, 6,
	7, 7, 7, 7, 8, 8, 8, 9,
	9, 9, 9, 10, 10, 11, 11, 11,
	12, 12, 12, 13, 13, 14, 14, 15,
	15, 15, 16, 16, 17, 17, 18, 18,
	19, 19, 20, 21, 21, 22, 22, 23,
	23, 24, 25, 25, 26, 27, 27, 28,
	29, 29, 30, 31, 32, 32, 33, 34,
	35, 35, 36, 37, 38, 39, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 60, 61, 62, 64, 65,
	66, 67, 68, 70, 71, 72, 73, 75,
	76, 77, 79, 80, 81, 83, 84, 86,
	87, 88, 90, 91, 93, 94, 96, 97,
	99, 101, 102, 104, 105, 107, 109, 110,
	112, 114, 115, 117, 119, 121, 122, 124,
	126, 128, 130, 132, 134, 135, 137, 139,
	141, 143, 145, 147, 149, 151, 153, 155,
	158, 160, 162, 164, 166, 168, 171, 173,
	175, 177, 180, 182, 184, 187, 189, 191,
	194, 196, 199, 201, 204, 206, 209, 211,
	214, 216, 219, 222, 224, 227, 230, 232,
	235, 238, 241, 244, 246, 249, 252, 255,
};

static const u16 xgamma8_30[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 6,
	6, 6, 6, 6, 7, 7, 7, 8,
	8, 8, 8, 9, 9, 9, 10, 10,
	10, 11, 11, 12, 12, 12, 13, 13,
	14, 14, 14, 15, 15, 16, 16, 17,
	17, 18, 18, 19, 19, 20, 20, 21,
	22, 22, 23, 23, 24, 25, 25, 26,
	27, 27, 28, 29, 29, 30, 31, 32,
	32, 33, 34, 35, 35, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, 51, 52, 53,
	54, 55, 56, 57, 58, 60, 61, 62,
	63, 64, 65, 67, 68, 69, 70, 72,
	73, 74, 76, 77, 78, 80, 81, 82,
	84, 85, 87, 88, 90, 91, 93, 94,
	96, 97, 99, 101, 102, 104, 105, 107,
	109, 111, 112, 114, 116, 118, 119, 121,
	123, 125, 127, 129, 131, 132, 134, 136,
	138, 140, 142, 144, 147, 149, 151, 153,
	155, 157, 159, 162, 164, 166, 168, 171,
	173, 175, 178, 180, 182, 185, 187, 190,
	192, 195, 197, 200, 202, 205, 207, 210,
	213, 215, 218, 221, 223, 226, 229, 232,
	235, 237, 240, 243, 246, 249, 252, 255,
};

static const u16 xgamma8_31[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 7,
	7, 7, 8, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 12, 12,
	12, 13, 13, 14, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 23, 24,
	25, 25, 26, 27, 27, 28, 29, 29,
	30, 31, 32, 32, 33, 34, 35, 36,
	36, 37, 38, 39, 40, 41, 42, 42,
	43, 44, 45, 46, 47, 48, 49, 50,
	51, 52, 53, 54, 56, 57, 58, 59,
	60, 61, 62, 64, 65, 66, 67, 69,
	70, 71, 73, 74, 75, 77, 78, 79,
	81, 82, 84, 85, 87, 88, 90, 91,
	93, 94, 96, 97, 99, 101, 102, 104,
	106, 108, 109, 111, 113, 115, 116, 118,
	120, 122, 124, 126, 128, 130, 132, 134,
	136, 138, 140, 142, 144, 146, 148, 150,
	152, 155, 157, 159, 161, 164, 166, 168,
	171, 173, 175, 178, 180, 183, 185, 188,
	190, 193, 195, 198, 201, 203, 206, 209,
	211, 214, 217, 220, 222, 225, 228, 231,
	234, 237, 240, 243, 246, 249, 252, 255,
};

static const u16 xgamma8_32[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 7, 7, 7, 8, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 21, 21, 22, 22,
	23, 23, 24, 25, 25, 26, 27, 27,
	28, 29, 30, 30, 31, 32, 33, 33,
	34, 35, 36, 37, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 59, 60, 61, 62, 63, 65, 66,
	67, 68, 70, 71, 72, 74, 75, 76,
	78, 79, 81, 82, 84, 85, 87, 88,
	90, 91, 93, 95, 96, 98, 99, 101,
	103, 105, 106, 108, 110, 112, 113, 115,
	117, 119, 121, 123, 125, 127, 129, 131,
	133, 135, 137, 139, 141, 143, 146, 148,
	150, 152, 154, 157, 159, 161, 164, 166,
	168, 171, 173, 176, 178, 181, 183, 186,
	188, 191, 194, 196, 199, 202, 204, 207,
	210, 213, 216, 219, 221, 224, 227, 230,
	233, 236, 239, 242, 246, 249, 252, 255,
};

static const u16 xgamma8_33[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5,
	6, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 9, 10,
	10, 11, 11, 11, 12, 12, 12, 13,
	13, 14, 14, 15, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 19, 20, 21,
	21, 22, 22, 23, 24, 24, 25, 26,
	26, 27, 28, 28, 29, 30, 31, 31,
	32, 33, 34, 34, 35, 36, 37, 38,
	39, 40, 40, 41, 42, 43, 44, 45,
	46, 47, 48, 49, 50, 51, 53, 54,
	55, 56, 57, 58, 59, 61, 62, 63,
	64, 66, 67, 68, 70, 71, 72, 74,
	75, 76, 78, 79, 81, 82, 84, 85,
	87, 88, 90, 92, 93, 95, 97, 98,
	100, 102, 103, 105, 107, 109, 111, 113,
	114, 116, 118, 120, 122, 124, 126, 128,
	130, 132, 134, 136, 139, 141, 143, 145,
	147, 150, 152, 154, 157, 159, 161, 164,
	166, 169, 171, 174, 176, 179, 181, 184,
	187, 189, 192, 195, 198, 200, 203, 206,
	209, 212, 215, 217, 220, 223, 226, 230,
	233, 236, 239, 242, 245, 248, 252, 255,
};

static const u16 xgamma8_34[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 12, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 21, 22, 23, 23, 24,
	24, 25, 26, 26, 27, 28, 29, 29,
	30, 31, 32, 32, 33, 34, 35, 36,
	37, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 55, 56, 57, 58, 59, 60,
	62, 63, 64, 66, 67, 68, 70, 71,
	72, 74, 75, 77, 78, 80, 81, 83,
	84, 86, 87, 89, 90, 92, 94, 95,
	97, 99, 101, 102, 104, 106, 108, 110,
	112, 114, 115, 117, 119, 121, 123, 125,
	128, 130, 132, 134, 136, 138, 141, 143,
	145, 147, 150, 152, 154, 157, 159, 162,
	164, 167, 169, 172, 174, 177, 180, 182,
	185, 188, 190, 193, 196, 199, 202, 205,
	208, 210, 213, 216, 219, 223, 226, 229,
	232, 235, 238, 242, 245, 248, 252, 255,
};

static const u16 xgamma8_35[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 5, 6, 6,
	6, 6, 7, 7, 7, 7, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 11, 12, 12, 13, 13, 13, 14,
	14, 15, 15, 16, 16, 17, 17, 18,
	18, 19, 19, 20, 20, 21, 22, 22,
	23, 23, 24, 25, 25, 26, 27, 28,
	28, 29, 30, 30, 31, 32, 33, 34,
	35, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49,
	50, 51, 52, 53, 54, 56, 57, 58,
	59, 60, 62, 63, 64, 66, 67, 68,
	70, 71, 72, 74, 75, 77, 78, 80,
	81, 83, 85, 86, 88, 89, 91, 93,
	94, 96, 98, 100, 102, 103, 105, 107,
	109, 111, 113, 115, 117, 119, 121, 123,
	125, 127, 129, 131, 134, 136, 138, 140,
	143, 145, 147, 150, 152, 155, 157, 159,
	162, 165, 167, 170, 172, 175, 178, 180,
	183, 186, 189, 192, 194, 197, 200, 203,
	206, 209, 212, 215, 219, 222, 225, 228,
	231, 235, 238, 241, 245, 248, 252, 255,
};

static const u16 xgamma8_36[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 7, 7, 7,
	8, 8, 8, 8, 9, 9, 9, 10,
	10, 10, 11, 11, 12, 12, 12, 13,
	13, 14, 14, 15, 15, 15, 16, 16,
	17, 17, 18, 18, 19, 20, 20, 21,
	21, 22, 23, 23, 24, 24, 25, 26,
	27, 27, 28, 29, 29, 30, 31, 32,
	33, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 42, 43, 44, 46, 47,
	48, 49, 50, 51, 52, 53, 54, 56,
	57, 58, 59, 61, 62, 63, 64, 66,
	67, 69, 70, 71, 73, 74, 76, 77,
	79, 80, 82, 83, 85, 87, 88, 90,
	92, 94, 95, 97, 99, 101, 103, 104,
	106, 108, 110, 112, 114, 116, 118, 120,
	122, 125, 127, 129, 131, 133, 136, 138,
	140, 143, 145, 147, 150, 152, 155, 157,
	160, 162, 165, 168, 170, 173, 176, 179,
	181, 184, 187, 190, 193, 196, 199, 202,
	205, 208, 211, 214, 218, 221, 224, 227,
	231, 234, 237, 241, 244, 248, 251, 255,
};

static const u16 xgamma8_37[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 7,
	7, 7, 7, 8, 8, 8, 9, 9,
	9, 10, 10, 10, 11, 11, 11, 12,
	12, 13, 13, 13, 14, 14, 15, 15,
	16, 16, 17, 17, 18, 18, 19, 19,
	20, 20, 21, 22, 22, 23, 24, 24,
	25, 26, 26, 27, 28, 28, 29, 30,
	31, 32, 32, 33, 34, 35, 36, 37,
	38, 39, 39, 40, 41, 42, 43, 44,
	45, 47, 48, 49, 50, 51, 52, 53,
	54, 56, 57, 58, 59, 61, 62, 63,
	65, 66, 67, 69, 70, 72, 73, 75,
	76, 78, 79, 81, 83, 84, 86, 88,
	89, 91, 93, 95, 96, 98, 100, 102,
	104, 106, 108, 110, 112, 114, 116, 118,
	120, 122, 124, 127, 129, 131, 133, 136,
	138, 140, 143, 145, 148, 150, 153, 155,
	158, 160, 163, 166, 169, 171, 174, 177,
	180, 183, 186, 188, 191, 194, 198, 201,
	204, 207, 210, 213, 217, 220, 223, 227,
	230, 233, 237, 241, 244, 248, 251, 255,
};

static const u16 xgamma8_38[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 7, 7, 7, 8, 8, 8,
	8, 9, 9, 9, 10, 10, 10, 11,
	11, 12, 12, 12, 13, 13, 14, 14,
	15, 15, 15, 16, 16, 17, 18, 18,
	19, 19, 20, 20, 21, 21, 22, 23,
	23, 24, 25, 25, 26, 27, 28, 28,
	29, 30, 31, 31, 32, 33, 34, 35,
	36, 37, 38, 38, 39, 40, 41, 42,
	43, 44, 45, 47, 48, 49, 50, 51,
	52, 53, 55, 56, 57, 58, 60, 61,
	62, 64, 65, 66, 68, 69, 71, 72,
	74, 75, 77, 78, 80, 82, 83, 85,
	87, 88, 90, 92, 94, 96, 98, 99,
	101, 103, 105, 107, 109, 111, 113, 115,
	118, 120, 122, 124, 126, 129, 131, 133,
	136, 138, 141, 143, 146, 148, 151, 153,
	156, 158, 161, 164, 167, 169, 172, 175,
	178, 181, 184, 187, 190, 193, 196, 199,
	203, 206, 209, 212, 216, 219, 222, 226,
	229, 233, 237, 240, 244, 247, 251, 255,
};

static const u16 xgamma8_39[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 7, 7, 7, 7,
	8, 8, 8, 9, 9, 9, 10, 10,
	10, 11, 11, 11, 12, 12, 13, 13,
	13, 14, 14, 15, 15, 16, 16, 17,
	17, 18, 18, 19, 20, 20, 21, 21,
	22, 23, 23, 24, 25, 25, 26, 27,
	27, 28, 29, 30, 31, 31, 32, 33,
	34, 35, 36, 37, 38, 38, 39, 40,
	41, 42, 43, 45, 46, 47, 48, 49,
	50, 51, 52, 54, 55, 56, 57, 59,
	60, 61, 63, 64, 66, 67, 68, 70,
	71, 73, 74, 76, 78, 79, 81, 83,
	84, 86, 88, 90, 91, 93, 95, 97,
	99, 101, 103, 105, 107, 109, 111, 113,
	115, 117, 120, 122, 124, 126, 129, 131,
	133, 136, 138, 141, 143, 146, 149, 151,
	154, 157, 159, 162, 165, 168, 171, 173,
	176, 179, 182, 185, 189, 192, 195, 198,
	201, 205, 208, 211, 215, 218, 222, 225,
	229, 232, 236, 240, 243, 247, 251, 255,
};

static const u16 xgamma8_40[GAMMA8_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 5, 5, 5,
	5, 5, 6, 6, 6, 6, 7, 7,
	7, 7, 8, 8, 8, 9, 9, 9,
	9, 10, 10, 11, 11, 11, 12, 12,
	13, 13, 13, 14, 14, 15, 15, 16,
	16, 17, 17, 18, 18, 19, 19, 20,
	21, 21, 22, 23, 23, 24, 25, 25,
	26, 27, 27, 28, 29, 30, 31, 31,
	32, 33, 34, 35, 36, 37, 38, 39,
	40, 41, 42, 43, 44, 45, 46, 47,
	48, 49, 50, 52, 53, 54, 55, 57,
	58, 59, 61, 62, 63, 65, 66, 68,
	69, 71, 72, 74, 75, 77, 79, 80,
	82, 84, 85, 87, 89, 91, 93, 95,
	96, 98, 100, 102, 104, 107, 109, 111,
	113, 115, 117, 120, 122, 124, 126, 129,
	131, 134, 136, 139, 141, 144, 146, 149,
	152, 155, 157, 160, 163, 166, 169, 172,
	175, 178, 181, 184, 187, 190, 194, 197,
	200, 203, 207, 210, 214, 217, 221, 224,
	228, 232, 236, 239, 243, 247, 251, 255,
};

static const u16 *xgamma8_curves[GAMMA_CURVE_LENGTH] =  {
	&xgamma8_01[0],
	&xgamma8_02[0],
	&xgamma8_03[0],
	&xgamma8_04[0],
	&xgamma8_05[0],
	&xgamma8_06[0],
	&xgamma8_07[0],
	&xgamma8_08[0],
	&xgamma8_09[0],
	&xgamma8_10[0],
	&xgamma8_11[0],
	&xgamma8_12[0],
	&xgamma8_13[0],
	&xgamma8_14[0],
	&xgamma8_15[0],
	&xgamma8_16[0],
	&xgamma8_17[0],
	&xgamma8_18[0],
	&xgamma8_19[0],
	&xgamma8_20[0],
	&xgamma8_21[0],
	&xgamma8_22[0],
	&xgamma8_23[0],
	&xgamma8_24[0],
	&xgamma8_25[0],
	&xgamma8_26[0],
	&xgamma8_27[0],
	&xgamma8_28[0],
	&xgamma8_29[0],
	&xgamma8_30[0],
	&xgamma8_31[0],
	&xgamma8_32[0],
	&xgamma8_33[0],
	&xgamma8_34[0],
	&xgamma8_35[0],
	&xgamma8_36[0],
	&xgamma8_37[0],
	&xgamma8_38[0],
	&xgamma8_39[0],
	&xgamma8_40[0],
};

#define GAMMA_BPC_10		(10)
#define GAMMA10_TABLE_LENGTH	BIT(GAMMA_BPC_10)
static const u16 xgamma10_01[GAMMA10_TABLE_LENGTH] = {
	0, 512, 548, 571, 588, 601, 612, 621, 630, 637, 644,
	650, 656, 661, 666, 671, 675, 679, 683, 687, 690, 694,
	697, 700, 703, 706, 709, 711, 714, 716, 719, 721, 723,
	726, 728, 730, 732, 734, 736, 738, 740, 742, 743, 745,
	747, 749, 750, 752, 753, 755, 756, 758, 759, 761, 762,
	764, 765, 766, 768, 769, 770, 772, 773, 774, 775, 777,
	778, 779, 780, 781, 782, 783, 785, 786, 787, 788, 789,
	790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800,
	800, 801, 802, 803, 804, 805, 806, 807, 807, 808, 809,
	810, 811, 812, 812, 813, 814, 815, 815, 816, 817, 818,
	819, 819, 820, 821, 821, 822, 823, 824, 824, 825, 826,
	826, 827, 828, 828, 829, 830, 830, 831, 832, 832, 833,
	834, 834, 835, 835, 836, 837, 837, 838, 838, 839, 840,
	840, 841, 841, 842, 843, 843, 844, 844, 845, 845, 846,
	847, 847, 848, 848, 849, 849, 850, 850, 851, 851, 852,
	852, 853, 853, 854, 854, 855, 855, 856, 856, 857, 857,
	858, 858, 859, 859, 860, 860, 861, 861, 862, 862, 863,
	863, 864, 864, 864, 865, 865, 866, 866, 867, 867, 868,
	868, 869, 869, 869, 870, 870, 871, 871, 872, 872, 872,
	873, 873, 874, 874, 874, 875, 875, 876, 876, 876, 877,
	877, 878, 878, 878, 879, 879, 880, 880, 880, 881, 881,
	882, 882, 882, 883, 883, 883, 884, 884, 885, 885, 885,
	886, 886, 886, 887, 887, 887, 888, 888, 889, 889, 889,
	890, 890, 890, 891, 891, 891, 892, 892, 892, 893, 893,
	893, 894, 894, 894, 895, 895, 895, 896, 896, 896, 897,
	897, 897, 898, 898, 898, 899, 899, 899, 900, 900, 900,
	901, 901, 901, 902, 902, 902, 902, 903, 903, 903, 904,
	904, 904, 905, 905, 905, 906, 906, 906, 906, 907, 907,
	907, 908, 908, 908, 908, 909, 909, 909, 910, 910, 910,
	910, 911, 911, 911, 912, 912, 912, 912, 913, 913, 913,
	914, 914, 914, 914, 915, 915, 915, 915, 916, 916, 916,
	917, 917, 917, 917, 918, 918, 918, 918, 919, 919, 919,
	919, 920, 920, 920, 921, 921, 921, 921, 922, 922, 922,
	922, 923, 923, 923, 923, 924, 924, 924, 924, 925, 925,
	925, 925, 926, 926, 926, 926, 927, 927, 927, 927, 928,
	928, 928, 928, 928, 929, 929, 929, 929, 930, 930, 930,
	930, 931, 931, 931, 931, 932, 932, 932, 932, 932, 933,
	933, 933, 933, 934, 934, 934, 934, 935, 935, 935, 935,
	935, 936, 936, 936, 936, 937, 937, 937, 937, 937, 938,
	938, 938, 938, 939, 939, 939, 939, 939, 940, 940, 940,
	940, 940, 941, 941, 941, 941, 942, 942, 942, 942, 942,
	943, 943, 943, 943, 943, 944, 944, 944, 944, 944, 945,
	945, 945, 945, 945, 946, 946, 946, 946, 946, 947, 947,
	947, 947, 947, 948, 948, 948, 948, 948, 949, 949, 949,
	949, 949, 950, 950, 950, 950, 950, 951, 951, 951, 951,
	951, 952, 952, 952, 952, 952, 953, 953, 953, 953, 953,
	953, 954, 954, 954, 954, 954, 955, 955, 955, 955, 955,
	956, 956, 956, 956, 956, 956, 957, 957, 957, 957, 957,
	958, 958, 958, 958, 958, 958, 959, 959, 959, 959, 959,
	960, 960, 960, 960, 960, 960, 961, 961, 961, 961, 961,
	961, 962, 962, 962, 962, 962, 962, 963, 963, 963, 963,
	963, 964, 964, 964, 964, 964, 964, 965, 965, 965, 965,
	965, 965, 966, 966, 966, 966, 966, 966, 967, 967, 967,
	967, 967, 967, 968, 968, 968, 968, 968, 968, 969, 969,
	969, 969, 969, 969, 970, 970, 970, 970, 970, 970, 970,
	971, 971, 971, 971, 971, 971, 972, 972, 972, 972, 972,
	972, 973, 973, 973, 973, 973, 973, 974, 974, 974, 974,
	974, 974, 974, 975, 975, 975, 975, 975, 975, 976, 976,
	976, 976, 976, 976, 976, 977, 977, 977, 977, 977, 977,
	977, 978, 978, 978, 978, 978, 978, 979, 979, 979, 979,
	979, 979, 979, 980, 980, 980, 980, 980, 980, 980, 981,
	981, 981, 981, 981, 981, 981, 982, 982, 982, 982, 982,
	982, 982, 983, 983, 983, 983, 983, 983, 983, 984, 984,
	984, 984, 984, 984, 984, 985, 985, 985, 985, 985, 985,
	985, 986, 986, 986, 986, 986, 986, 986, 987, 987, 987,
	987, 987, 987, 987, 988, 988, 988, 988, 988, 988, 988,
	989, 989, 989, 989, 989, 989, 989, 989, 990, 990, 990,
	990, 990, 990, 990, 991, 991, 991, 991, 991, 991, 991,
	991, 992, 992, 992, 992, 992, 992, 992, 993, 993, 993,
	993, 993, 993, 993, 993, 994, 994, 994, 994, 994, 994,
	994, 994, 995, 995, 995, 995, 995, 995, 995, 996, 996,
	996, 996, 996, 996, 996, 996, 997, 997, 997, 997, 997,
	997, 997, 997, 998, 998, 998, 998, 998, 998, 998, 998,
	999, 999, 999, 999, 999, 999, 999, 999, 1000, 1000, 1000,
	1000, 1000, 1000, 1000, 1000, 1000, 1001, 1001, 1001, 1001, 1001,
	1001, 1001, 1001, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
	1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1004, 1004, 1004,
	1004, 1004, 1004, 1004, 1004, 1004, 1005, 1005, 1005, 1005, 1005,
	1005, 1005, 1005, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
	1006, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1008,
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1009, 1009, 1009, 1009,
	1009, 1009, 1009, 1009, 1009, 1010, 1010, 1010, 1010, 1010, 1010,
	1010, 1010, 1010, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
	1011, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1013,
	1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1014, 1014, 1014,
	1014, 1014, 1014, 1014, 1014, 1014, 1014, 1015, 1015, 1015, 1015,
	1015, 1015, 1015, 1015, 1015, 1016, 1016, 1016, 1016, 1016, 1016,
	1016, 1016, 1016, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
	1017, 1017, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1020,
	1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1021, 1021,
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022, 1022, 1022,
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023, 1023, 1023,
	1023,
};

static const u16 xgamma10_02[GAMMA10_TABLE_LENGTH] = {
	0, 256, 294, 319, 338, 353, 366, 378, 388, 397, 405,
	413, 420, 427, 434, 440, 445, 451, 456, 461, 466, 470,
	475, 479, 483, 487, 491, 495, 498, 502, 505, 508, 512,
	515, 518, 521, 524, 527, 529, 532, 535, 538, 540, 543,
	545, 548, 550, 552, 555, 557, 559, 562, 564, 566, 568,
	570, 572, 574, 576, 578, 580, 582, 584, 586, 588, 589,
	591, 593, 595, 597, 598, 600, 602, 603, 605, 607, 608,
	610, 611, 613, 614, 616, 618, 619, 621, 622, 623, 625,
	626, 628, 629, 631, 632, 633, 635, 636, 637, 639, 640,
	641, 643, 644, 645, 646, 648, 649, 650, 651, 653, 654,
	655, 656, 657, 658, 660, 661, 662, 663, 664, 665, 666,
	668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678,
	679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689,
	690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700,
	700, 701, 702, 703, 704, 705, 706, 707, 708, 708, 709,
	710, 711, 712, 713, 714, 714, 715, 716, 717, 718, 719,
	719, 720, 721, 722, 723, 723, 724, 725, 726, 727, 727,
	728, 729, 730, 731, 731, 732, 733, 734, 734, 735, 736,
	737, 737, 738, 739, 740, 740, 741, 742, 742, 743, 744,
	745, 745, 746, 747, 747, 748, 749, 750, 750, 751, 752,
	752, 753, 754, 754, 755, 756, 756, 757, 758, 758, 759,
	760, 760, 761, 762, 762, 763, 764, 764, 765, 765, 766,
	767, 767, 768, 769, 769, 770, 771, 771, 772, 772, 773,
	774, 774, 775, 775, 776, 777, 777, 778, 778, 779, 780,
	780, 781, 781, 782, 783, 783, 784, 784, 785, 785, 786,
	787, 787, 788, 788, 789, 789, 790, 791, 791, 792, 792,
	793, 793, 794, 794, 795, 796, 796, 797, 797, 798, 798,
	799, 799, 800, 800, 801, 801, 802, 803, 803, 804, 804,
	805, 805, 806, 806, 807, 807, 808, 808, 809, 809, 810,
	810, 811, 811, 812, 812, 813, 813, 814, 814, 815, 815,
	816, 816, 817, 817, 818, 818, 819, 819, 820, 820, 821,
	821, 822, 822, 823, 823, 824, 824, 825, 825, 825, 826,
	826, 827, 827, 828, 828, 829, 829, 830, 830, 831, 831,
	832, 832, 832, 833, 833, 834, 834, 835, 835, 836, 836,
	837, 837, 837, 838, 838, 839, 839, 840, 840, 841, 841,
	841, 842, 842, 843, 843, 844, 844, 844, 845, 845, 846,
	846, 847, 847, 847, 848, 848, 849, 849, 850, 850, 850,
	851, 851, 852, 852, 852, 853, 853, 854, 854, 855, 855,
	855, 856, 856, 857, 857, 857, 858, 858, 859, 859, 859,
	860, 860, 861, 861, 861, 862, 862, 863, 863, 863, 864,
	864, 865, 865, 865, 866, 866, 866, 867, 867, 868, 868,
	868, 869, 869, 870, 870, 870, 871, 871, 871, 872, 872,
	873, 873, 873, 874, 874, 875, 875, 875, 876, 876, 876,
	877, 877, 877, 878, 878, 879, 879, 879, 880, 880, 880,
	881, 881, 882, 882, 882, 883, 883, 883, 884, 884, 884,
	885, 885, 885, 886, 886, 887, 887, 887, 888, 888, 888,
	889, 889, 889, 890, 890, 890, 891, 891, 891, 892, 892,
	892, 893, 893, 894, 894, 894, 895, 895, 895, 896, 896,
	896, 897, 897, 897, 898, 898, 898, 899, 899, 899, 900,
	900, 900, 901, 901, 901, 902, 902, 902, 903, 903, 903,
	904, 904, 904, 905, 905, 905, 906, 906, 906, 907, 907,
	907, 908, 908, 908, 908, 909, 909, 909, 910, 910, 910,
	911, 911, 911, 912, 912, 912, 913, 913, 913, 914, 914,
	914, 914, 915, 915, 915, 916, 916, 916, 917, 917, 917,
	918, 918, 918, 919, 919, 919, 919, 920, 920, 920, 921,
	921, 921, 922, 922, 922, 923, 923, 923, 923, 924, 924,
	924, 925, 925, 925, 926, 926, 926, 926, 927, 927, 927,
	928, 928, 928, 928, 929, 929, 929, 930, 930, 930, 931,
	931, 931, 931, 932, 932, 932, 933, 933, 933, 933, 934,
	934, 934, 935, 935, 935, 935, 936, 936, 936, 937, 937,
	937, 937, 938, 938, 938, 939, 939, 939, 939, 940, 940,
	940, 941, 941, 941, 941, 942, 942, 942, 942, 943, 943,
	943, 944, 944, 944, 944, 945, 945, 945, 946, 946, 946,
	946, 947, 947, 947, 947, 948, 948, 948, 949, 949, 949,
	949, 950, 950, 950, 950, 951, 951, 951, 951, 952, 952,
	952, 953, 953, 953, 953, 954, 954, 954, 954, 955, 955,
	955, 955, 956, 956, 956, 956, 957, 957, 957, 958, 958,
	958, 958, 959, 959, 959, 959, 960, 960, 960, 960, 961,
	961, 961, 961, 962, 962, 962, 962, 963, 963, 963, 963,
	964, 964, 964, 964, 965, 965, 965, 965, 966, 966, 966,
	966, 967, 967, 967, 967, 968, 968, 968, 968, 969, 969,
	969, 969, 970, 970, 970, 970, 971, 971, 971, 971, 972,
	972, 972, 972, 973, 973, 973, 973, 974, 974, 974, 974,
	975, 975, 975, 975, 976, 976, 976, 976, 977, 977, 977,
	977, 978, 978, 978, 978, 978, 979, 979, 979, 979, 980,
	980, 980, 980, 981, 981, 981, 981, 982, 982, 982, 982,
	983, 983, 983, 983, 983, 984, 984, 984, 984, 985, 985,
	985, 985, 986, 986, 986, 986, 986, 987, 987, 987, 987,
	988, 988, 988, 988, 989, 989, 989, 989, 989, 990, 990,
	990, 990, 991, 991, 991, 991, 992, 992, 992, 992, 992,
	993, 993, 993, 993, 994, 994, 994, 994, 994, 995, 995,
	995, 995, 996, 996, 996, 996, 996, 997, 997, 997, 997,
	998, 998, 998, 998, 998, 999, 999, 999, 999, 1000, 1000,
	1000, 1000, 1000, 1001, 1001, 1001, 1001, 1002, 1002, 1002, 1002,
	1002, 1003, 1003, 1003, 1003, 1003, 1004, 1004, 1004, 1004, 1005,
	1005, 1005, 1005, 1005, 1006, 1006, 1006, 1006, 1006, 1007, 1007,
	1007, 1007, 1008, 1008, 1008, 1008, 1008, 1009, 1009, 1009, 1009,
	1009, 1010, 1010, 1010, 1010, 1010, 1011, 1011, 1011, 1011, 1012,
	1012, 1012, 1012, 1012, 1013, 1013, 1013, 1013, 1013, 1014, 1014,
	1014, 1014, 1014, 1015, 1015, 1015, 1015, 1015, 1016, 1016, 1016,
	1016, 1017, 1017, 1017, 1017, 1017, 1018, 1018, 1018, 1018, 1018,
	1019, 1019, 1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020, 1021,
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
	1023,
};

static const u16 xgamma10_03[GAMMA10_TABLE_LENGTH] = {
	0, 128, 157, 178, 194, 207, 219, 229, 239, 247, 255,
	263, 270, 276, 282, 288, 294, 299, 304, 309, 314, 319,
	323, 328, 332, 336, 340, 344, 348, 351, 355, 358, 362,
	365, 368, 372, 375, 378, 381, 384, 387, 390, 393, 395,
	398, 401, 403, 406, 409, 411, 414, 416, 419, 421, 423,
	426, 428, 430, 432, 435, 437, 439, 441, 443, 445, 447,
	450, 452, 454, 456, 458, 460, 461, 463, 465, 467, 469,
	471, 473, 474, 476, 478, 480, 482, 483, 485, 487, 488,
	490, 492, 493, 495, 497, 498, 500, 501, 503, 505, 506,
	508, 509, 511, 512, 514, 515, 517, 518, 520, 521, 523,
	524, 525, 527, 528, 530, 531, 532, 534, 535, 537, 538,
	539, 541, 542, 543, 544, 546, 547, 548, 550, 551, 552,
	553, 555, 556, 557, 558, 560, 561, 562, 563, 565, 566,
	567, 568, 569, 570, 572, 573, 574, 575, 576, 577, 579,
	580, 581, 582, 583, 584, 585, 586, 587, 589, 590, 591,
	592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602,
	603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613,
	614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624,
	625, 626, 627, 628, 629, 630, 631, 632, 633, 633, 634,
	635, 636, 637, 638, 639, 640, 641, 642, 642, 643, 644,
	645, 646, 647, 648, 649, 649, 650, 651, 652, 653, 654,
	655, 655, 656, 657, 658, 659, 660, 661, 661, 662, 663,
	664, 665, 665, 666, 667, 668, 669, 670, 670, 671, 672,
	673, 674, 674, 675, 676, 677, 677, 678, 679, 680, 681,
	681, 682, 683, 684, 684, 685, 686, 687, 688, 688, 689,
	690, 691, 691, 692, 693, 694, 694, 695, 696, 696, 697,
	698, 699, 699, 700, 701, 702, 702, 703, 704, 704, 705,
	706, 707, 707, 708, 709, 709, 710, 711, 712, 712, 713,
	714, 714, 715, 716, 716, 717, 718, 718, 719, 720, 721,
	721, 722, 723, 723, 724, 725, 725, 726, 727, 727, 728,
	729, 729, 730, 731, 731, 732, 733, 733, 734, 734, 735,
	736, 736, 737, 738, 738, 739, 740, 740, 741, 742, 742,
	743, 743, 744, 745, 745, 746, 747, 747, 748, 748, 749,
	750, 750, 751, 752, 752, 753, 753, 754, 755, 755, 756,
	756, 757, 758, 758, 759, 759, 760, 761, 761, 762, 762,
	763, 764, 764, 765, 765, 766, 767, 767, 768, 768, 769,
	770, 770, 771, 771, 772, 772, 773, 774, 774, 775, 775,
	776, 776, 777, 778, 778, 779, 779, 780, 780, 781, 782,
	782, 783, 783, 784, 784, 785, 785, 786, 787, 787, 788,
	788, 789, 789, 790, 790, 791, 792, 792, 793, 793, 794,
	794, 795, 795, 796, 796, 797, 797, 798, 799, 799, 800,
	800, 801, 801, 802, 802, 803, 803, 804, 804, 805, 805,
	806, 806, 807, 808, 808, 809, 809, 810, 810, 811, 811,
	812, 812, 813, 813, 814, 814, 815, 815, 816, 816, 817,
	817, 818, 818, 819, 819, 820, 820, 821, 821, 822, 822,
	823, 823, 824, 824, 825, 825, 826, 826, 827, 827, 828,
	828, 829, 829, 830, 830, 831, 831, 832, 832, 833, 833,
	834, 834, 835, 835, 836, 836, 836, 837, 837, 838, 838,
	839, 839, 840, 840, 841, 841, 842, 842, 843, 843, 844,
	844, 845, 845, 845, 846, 846, 847, 847, 848, 848, 849,
	849, 850, 850, 851, 851, 852, 852, 852, 853, 853, 854,
	854, 855, 855, 856, 856, 857, 857, 857, 858, 858, 859,
	859, 860, 860, 861, 861, 862, 862, 862, 863, 863, 864,
	864, 865, 865, 866, 866, 866, 867, 867, 868, 868, 869,
	869, 869, 870, 870, 871, 871, 872, 872, 873, 873, 873,
	874, 874, 875, 875, 876, 876, 876, 877, 877, 878, 878,
	879, 879, 879, 880, 880, 881, 881, 882, 882, 882, 883,
	883, 884, 884, 885, 885, 885, 886, 886, 887, 887, 887,
	888, 888, 889, 889, 890, 890, 890, 891, 891, 892, 892,
	892, 893, 893, 894, 894, 895, 895, 895, 896, 896, 897,
	897, 897, 898, 898, 899, 899, 899, 900, 900, 901, 901,
	901, 902, 902, 903, 903, 903, 904, 904, 905, 905, 905,
	906, 906, 907, 907, 907, 908, 908, 909, 909, 909, 910,
	910, 911, 911, 911, 912, 912, 913, 913, 913, 914, 914,
	915, 915, 915, 916, 916, 916, 917, 917, 918, 918, 918,
	919, 919, 920, 920, 920, 921, 921, 921, 922, 922, 923,
	923, 923, 924, 924, 925, 925, 925, 926, 926, 926, 927,
	927, 928, 928, 928, 929, 929, 929, 930, 930, 931, 931,
	931, 932, 932, 932, 933, 933, 934, 934, 934, 935, 935,
	935, 936, 936, 936, 937, 937, 938, 938, 938, 939, 939,
	939, 940, 940, 941, 941, 941, 942, 942, 942, 943, 943,
	943, 944, 944, 945, 945, 945, 946, 946, 946, 947, 947,
	947, 948, 948, 948, 949, 949, 950, 950, 950, 951, 951,
	951, 952, 952, 952, 953, 953, 953, 954, 954, 955, 955,
	955, 956, 956, 956, 957, 957, 957, 958, 958, 958, 959,
	959, 959, 960, 960, 960, 961, 961, 962, 962, 962, 963,
	963, 963, 964, 964, 964, 965, 965, 965, 966, 966, 966,
	967, 967, 967, 968, 968, 968, 969, 969, 969, 970, 970,
	970, 971, 971, 971, 972, 972, 972, 973, 973, 973, 974,
	974, 974, 975, 975, 975, 976, 976, 976, 977, 977, 977,
	978, 978, 978, 979, 979, 979, 980, 980, 980, 981, 981,
	981, 982, 982, 982, 983, 983, 983, 984, 984, 984, 985,
	985, 985, 986, 986, 986, 987, 987, 987, 988, 988, 988,
	989, 989, 989, 990, 990, 990, 991, 991, 991, 992, 992,
	992, 993, 993, 993, 994, 994, 994, 994, 995, 995, 995,
	996, 996, 996, 997, 997, 997, 998, 998, 998, 999, 999,
	999, 1000, 1000, 1000, 1001, 1001, 1001, 1001, 1002, 1002, 1002,
	1003, 1003, 1003, 1004, 1004, 1004, 1005, 1005, 1005, 1006, 1006,
	1006, 1006, 1007, 1007, 1007, 1008, 1008, 1008, 1009, 1009, 1009,
	1010, 1010, 1010, 1011, 1011, 1011, 1011, 1012, 1012, 1012, 1013,
	1013, 1013, 1014, 1014, 1014, 1015, 1015, 1015, 1015, 1016, 1016,
	1016, 1017, 1017, 1017, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
	1020, 1020, 1020, 1021, 1021, 1021, 1021, 1022, 1022, 1022, 1023,
	1023,
};

static const u16 xgamma10_04[GAMMA10_TABLE_LENGTH] = {
	0, 64, 84, 99, 111, 122, 131, 139, 147, 154, 161,
	167, 173, 178, 184, 189, 194, 199, 203, 208, 212, 216,
	220, 224, 228, 232, 235, 239, 243, 246, 249, 253, 256,
	259, 262, 265, 268, 271, 274, 277, 280, 283, 285, 288,
	291, 293, 296, 298, 301, 303, 306, 308, 311, 313, 315,
	318, 320, 322, 325, 327, 329, 331, 333, 335, 338, 340,
	342, 344, 346, 348, 350, 352, 354, 356, 358, 360, 362,
	364, 365, 367, 369, 371, 373, 375, 376, 378, 380, 382,
	383, 385, 387, 389, 390, 392, 394, 395, 397, 399, 400,
	402, 404, 405, 407, 408, 410, 412, 413, 415, 416, 418,
	419, 421, 422, 424, 425, 427, 428, 430, 431, 433, 434,
	436, 437, 438, 440, 441, 443, 444, 445, 447, 448, 450,
	451, 452, 454, 455, 456, 458, 459, 460, 462, 463, 464,
	466, 467, 468, 470, 471, 472, 473, 475, 476, 477, 478,
	480, 481, 482, 483, 485, 486, 487, 488, 489, 491, 492,
	493, 494, 495, 497, 498, 499, 500, 501, 503, 504, 505,
	506, 507, 508, 509, 511, 512, 513, 514, 515, 516, 517,
	518, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529,
	530, 531, 533, 534, 535, 536, 537, 538, 539, 540, 541,
	542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552,
	553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563,
	564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574,
	575, 576, 577, 578, 578, 579, 580, 581, 582, 583, 584,
	585, 586, 587, 588, 589, 590, 591, 591, 592, 593, 594,
	595, 596, 597, 598, 599, 600, 600, 601, 602, 603, 604,
	605, 606, 607, 607, 608, 609, 610, 611, 612, 613, 614,
	614, 615, 616, 617, 618, 619, 620, 620, 621, 622, 623,
	624, 625, 625, 626, 627, 628, 629, 630, 630, 631, 632,
	633, 634, 635, 635, 636, 637, 638, 639, 639, 640, 641,
	642, 643, 643, 644, 645, 646, 647, 647, 648, 649, 650,
	651, 651, 652, 653, 654, 655, 655, 656, 657, 658, 658,
	659, 660, 661, 662, 662, 663, 664, 665, 665, 666, 667,
	668, 668, 669, 670, 671, 671, 672, 673, 674, 674, 675,
	676, 677, 677, 678, 679, 680, 680, 681, 682, 683, 683,
	684, 685, 685, 686, 687, 688, 688, 689, 690, 691, 691,
	692, 693, 693, 694, 695, 696, 696, 697, 698, 698, 699,
	700, 701, 701, 702, 703, 703, 704, 705, 705, 706, 707,
	708, 708, 709, 710, 710, 711, 712, 712, 713, 714, 714,
	715, 716, 717, 717, 718, 719, 719, 720, 721, 721, 722,
	723, 723, 724, 725, 725, 726, 727, 727, 728, 729, 729,
	730, 731, 731, 732, 733, 733, 734, 735, 735, 736, 737,
	737, 738, 739, 739, 740, 740, 741, 742, 742, 743, 744,
	744, 745, 746, 746, 747, 748, 748, 749, 749, 750, 751,
	751, 752, 753, 753, 754, 755, 755, 756, 756, 757, 758,
	758, 759, 760, 760, 761, 761, 762, 763, 763, 764, 765,
	765, 766, 766, 767, 768, 768, 769, 769, 770, 771, 771,
	772, 773, 773, 774, 774, 775, 776, 776, 777, 777, 778,
	779, 779, 780, 780, 781, 782, 782, 783, 783, 784, 785,
	785, 786, 786, 787, 788, 788, 789, 789, 790, 791, 791,
	792, 792, 793, 793, 794, 795, 795, 796, 796, 797, 798,
	798, 799, 799, 800, 800, 801, 802, 802, 803, 803, 804,
	804, 805, 806, 806, 807, 807, 808, 808, 809, 810, 810,
	811, 811, 812, 812, 813, 814, 814, 815, 815, 816, 816,
	817, 818, 818, 819, 819, 820, 820, 821, 821, 822, 823,
	823, 824, 824, 825, 825, 826, 826, 827, 827, 828, 829,
	829, 830, 830, 831, 831, 832, 832, 833, 834, 834, 835,
	835, 836, 836, 837, 837, 838, 838, 839, 839, 840, 841,
	841, 842, 842, 843, 843, 844, 844, 845, 845, 846, 846,
	847, 847, 848, 849, 849, 850, 850, 851, 851, 852, 852,
	853, 853, 854, 854, 855, 855, 856, 856, 857, 857, 858,
	859, 859, 860, 860, 861, 861, 862, 862, 863, 863, 864,
	864, 865, 865, 866, 866, 867, 867, 868, 868, 869, 869,
	870, 870, 871, 871, 872, 872, 873, 873, 874, 874, 875,
	875, 876, 876, 877, 877, 878, 878, 879, 879, 880, 880,
	881, 881, 882, 882, 883, 883, 884, 884, 885, 885, 886,
	886, 887, 887, 888, 888, 889, 889, 890, 890, 891, 891,
	892, 892, 893, 893, 894, 894, 895, 895, 896, 896, 897,
	897, 898, 898, 899, 899, 900, 900, 901, 901, 902, 902,
	903, 903, 904, 904, 905, 905, 905, 906, 906, 907, 907,
	908, 908, 909, 909, 910, 910, 911, 911, 912, 912, 913,
	913, 914, 914, 915, 915, 915, 916, 916, 917, 917, 918,
	918, 919, 919, 920, 920, 921, 921, 922, 922, 923, 923,
	923, 924, 924, 925, 925, 926, 926, 927, 927, 928, 928,
	929, 929, 929, 930, 930, 931, 931, 932, 932, 933, 933,
	934, 934, 935, 935, 935, 936, 936, 937, 937, 938, 938,
	939, 939, 940, 940, 940, 941, 941, 942, 942, 943, 943,
	944, 944, 945, 945, 945, 946, 946, 947, 947, 948, 948,
	949, 949, 949, 950, 950, 951, 951, 952, 952, 953, 953,
	953, 954, 954, 955, 955, 956, 956, 957, 957, 957, 958,
	958, 959, 959, 960, 960, 961, 961, 961, 962, 962, 963,
	963, 964, 964, 965, 965, 965, 966, 966, 967, 967, 968,
	968, 968, 969, 969, 970, 970, 971, 971, 971, 972, 972,
	973, 973, 974, 974, 974, 975, 975, 976, 976, 977, 977,
	977, 978, 978, 979, 979, 980, 980, 980, 981, 981, 982,
	982, 983, 983, 983, 984, 984, 985, 985, 986, 986, 986,
	987, 987, 988, 988, 989, 989, 989, 990, 990, 991, 991,
	991, 992, 992, 993, 993, 994, 994, 994, 995, 995, 996,
	996, 996, 997, 997, 998, 998, 999, 999, 999, 1000, 1000,
	1001, 1001, 1001, 1002, 1002, 1003, 1003, 1004, 1004, 1004, 1005,
	1005, 1006, 1006, 1006, 1007, 1007, 1008, 1008, 1008, 1009, 1009,
	1010, 1010, 1010, 1011, 1011, 1012, 1012, 1013, 1013, 1013, 1014,
	1014, 1015, 1015, 1015, 1016, 1016, 1017, 1017, 1017, 1018, 1018,
	1019, 1019, 1019, 1020, 1020, 1021, 1021, 1021, 1022, 1022, 1023,
	1023,
};

static const u16 xgamma10_05[GAMMA10_TABLE_LENGTH] = {
	0, 32, 45, 55, 64, 72, 78, 85, 90, 96, 101,
	106, 111, 115, 120, 124, 128, 132, 136, 139, 143, 147,
	150, 153, 157, 160, 163, 166, 169, 172, 175, 178, 181,
	184, 186, 189, 192, 195, 197, 200, 202, 205, 207, 210,
	212, 215, 217, 219, 222, 224, 226, 228, 231, 233, 235,
	237, 239, 241, 244, 246, 248, 250, 252, 254, 256, 258,
	260, 262, 264, 266, 268, 270, 271, 273, 275, 277, 279,
	281, 282, 284, 286, 288, 290, 291, 293, 295, 297, 298,
	300, 302, 303, 305, 307, 308, 310, 312, 313, 315, 317,
	318, 320, 321, 323, 325, 326, 328, 329, 331, 332, 334,
	335, 337, 338, 340, 341, 343, 344, 346, 347, 349, 350,
	352, 353, 355, 356, 358, 359, 360, 362, 363, 365, 366,
	367, 369, 370, 372, 373, 374, 376, 377, 378, 380, 381,
	382, 384, 385, 386, 388, 389, 390, 392, 393, 394, 396,
	397, 398, 399, 401, 402, 403, 405, 406, 407, 408, 410,
	411, 412, 413, 415, 416, 417, 418, 419, 421, 422, 423,
	424, 426, 427, 428, 429, 430, 431, 433, 434, 435, 436,
	437, 439, 440, 441, 442, 443, 444, 445, 447, 448, 449,
	450, 451, 452, 453, 455, 456, 457, 458, 459, 460, 461,
	462, 463, 465, 466, 467, 468, 469, 470, 471, 472, 473,
	474, 475, 477, 478, 479, 480, 481, 482, 483, 484, 485,
	486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 497,
	498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508,
	509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519,
	520, 521, 522, 523, 524, 525, 526, 527, 527, 528, 529,
	530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540,
	541, 542, 543, 544, 545, 546, 547, 547, 548, 549, 550,
	551, 552, 553, 554, 555, 556, 557, 558, 559, 559, 560,
	561, 562, 563, 564, 565, 566, 567, 568, 569, 569, 570,
	571, 572, 573, 574, 575, 576, 577, 577, 578, 579, 580,
	581, 582, 583, 584, 585, 585, 586, 587, 588, 589, 590,
	591, 591, 592, 593, 594, 595, 596, 597, 598, 598, 599,
	600, 601, 602, 603, 603, 604, 605, 606, 607, 608, 609,
	609, 610, 611, 612, 613, 614, 614, 615, 616, 617, 618,
	619, 619, 620, 621, 622, 623, 623, 624, 625, 626, 627,
	628, 628, 629, 630, 631, 632, 632, 633, 634, 635, 636,
	636, 637, 638, 639, 640, 640, 641, 642, 643, 644, 644,
	645, 646, 647, 648, 648, 649, 650, 651, 652, 652, 653,
	654, 655, 655, 656, 657, 658, 659, 659, 660, 661, 662,
	662, 663, 664, 665, 666, 666, 667, 668, 669, 669, 670,
	671, 672, 672, 673, 674, 675, 675, 676, 677, 678, 678,
	679, 680, 681, 681, 682, 683, 684, 684, 685, 686, 687,
	687, 688, 689, 690, 690, 691, 692, 693, 693, 694, 695,
	696, 696, 697, 698, 699, 699, 700, 701, 701, 702, 703,
	704, 704, 705, 706, 707, 707, 708, 709, 709, 710, 711,
	712, 712, 713, 714, 714, 715, 716, 717, 717, 718, 719,
	719, 720, 721, 722, 722, 723, 724, 724, 725, 726, 727,
	727, 728, 729, 729, 730, 731, 731, 732, 733, 734, 734,
	735, 736, 736, 737, 738, 738, 739, 740, 740, 741, 742,
	743, 743, 744, 745, 745, 746, 747, 747, 748, 749, 749,
	750, 751, 751, 752, 753, 754, 754, 755, 756, 756, 757,
	758, 758, 759, 760, 760, 761, 762, 762, 763, 764, 764,
	765, 766, 766, 767, 768, 768, 769, 770, 770, 771, 772,
	772, 773, 774, 774, 775, 776, 776, 777, 778, 778, 779,
	780, 780, 781, 781, 782, 783, 783, 784, 785, 785, 786,
	787, 787, 788, 789, 789, 790, 791, 791, 792, 793, 793,
	794, 794, 795, 796, 796, 797, 798, 798, 799, 800, 800,
	801, 802, 802, 803, 803, 804, 805, 805, 806, 807, 807,
	808, 809, 809, 810, 810, 811, 812, 812, 813, 814, 814,
	815, 815, 816, 817, 817, 818, 819, 819, 820, 820, 821,
	822, 822, 823, 824, 824, 825, 825, 826, 827, 827, 828,
	829, 829, 830, 830, 831, 832, 832, 833, 833, 834, 835,
	835, 836, 836, 837, 838, 838, 839, 840, 840, 841, 841,
	842, 843, 843, 844, 844, 845, 846, 846, 847, 847, 848,
	849, 849, 850, 850, 851, 852, 852, 853, 853, 854, 855,
	855, 856, 856, 857, 858, 858, 859, 859, 860, 861, 861,
	862, 862, 863, 864, 864, 865, 865, 866, 867, 867, 868,
	868, 869, 869, 870, 871, 871, 872, 872, 873, 874, 874,
	875, 875, 876, 877, 877, 878, 878, 879, 879, 880, 881,
	881, 882, 882, 883, 883, 884, 885, 885, 886, 886, 887,
	888, 888, 889, 889, 890, 890, 891, 892, 892, 893, 893,
	894, 894, 895, 896, 896, 897, 897, 898, 898, 899, 900,
	900, 901, 901, 902, 902, 903, 904, 904, 905, 905, 906,
	906, 907, 907, 908, 909, 909, 910, 910, 911, 911, 912,
	913, 913, 914, 914, 915, 915, 916, 916, 917, 918, 918,
	919, 919, 920, 920, 921, 921, 922, 923, 923, 924, 924,
	925, 925, 926, 926, 927, 928, 928, 929, 929, 930, 930,
	931, 931, 932, 932, 933, 934, 934, 935, 935, 936, 936,
	937, 937, 938, 939, 939, 940, 940, 941, 941, 942, 942,
	943, 943, 944, 944, 945, 946, 946, 947, 947, 948, 948,
	949, 949, 950, 950, 951, 952, 952, 953, 953, 954, 954,
	955, 955, 956, 956, 957, 957, 958, 958, 959, 960, 960,
	961, 961, 962, 962, 963, 963, 964, 964, 965, 965, 966,
	966, 967, 967, 968, 969, 969, 970, 970, 971, 971, 972,
	972, 973, 973, 974, 974, 975, 975, 976, 976, 977, 977,
	978, 979, 979, 980, 980, 981, 981, 982, 982, 983, 983,
	984, 984, 985, 985, 986, 986, 987, 987, 988, 988, 989,
	989, 990, 990, 991, 992, 992, 993, 993, 994, 994, 995,
	995, 996, 996, 997, 997, 998, 998, 999, 999, 1000, 1000,
	1001, 1001, 1002, 1002, 1003, 1003, 1004, 1004, 1005, 1005, 1006,
	1006, 1007, 1007, 1008, 1008, 1009, 1009, 1010, 1010, 1011, 1011,
	1012, 1012, 1013, 1013, 1014, 1014, 1015, 1015, 1016, 1016, 1017,
	1017, 1018, 1018, 1019, 1019, 1020, 1020, 1021, 1021, 1022, 1022,
	1023,
};

static const u16 xgamma10_06[GAMMA10_TABLE_LENGTH] = {
	0, 16, 24, 31, 37, 42, 47, 51, 56, 60, 64,
	67, 71, 75, 78, 81, 84, 88, 91, 94, 97, 99,
	102, 105, 108, 110, 113, 116, 118, 121, 123, 126, 128,
	130, 133, 135, 137, 140, 142, 144, 146, 148, 151, 153,
	155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175,
	177, 179, 181, 183, 185, 187, 188, 190, 192, 194, 196,
	198, 199, 201, 203, 205, 206, 208, 210, 212, 213, 215,
	217, 218, 220, 222, 223, 225, 227, 228, 230, 232, 233,
	235, 236, 238, 240, 241, 243, 244, 246, 247, 249, 250,
	252, 253, 255, 257, 258, 260, 261, 263, 264, 265, 267,
	268, 270, 271, 273, 274, 276, 277, 279, 280, 281, 283,
	284, 286, 287, 288, 290, 291, 293, 294, 295, 297, 298,
	299, 301, 302, 303, 305, 306, 308, 309, 310, 312, 313,
	314, 315, 317, 318, 319, 321, 322, 323, 325, 326, 327,
	328, 330, 331, 332, 334, 335, 336, 337, 339, 340, 341,
	342, 344, 345, 346, 347, 349, 350, 351, 352, 353, 355,
	356, 357, 358, 359, 361, 362, 363, 364, 365, 367, 368,
	369, 370, 371, 373, 374, 375, 376, 377, 378, 380, 381,
	382, 383, 384, 385, 387, 388, 389, 390, 391, 392, 393,
	394, 396, 397, 398, 399, 400, 401, 402, 403, 405, 406,
	407, 408, 409, 410, 411, 412, 413, 415, 416, 417, 418,
	419, 420, 421, 422, 423, 424, 425, 426, 428, 429, 430,
	431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441,
	442, 443, 445, 446, 447, 448, 449, 450, 451, 452, 453,
	454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
	465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475,
	476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486,
	487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497,
	498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 507,
	508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518,
	519, 520, 521, 522, 523, 524, 525, 525, 526, 527, 528,
	529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 538,
	539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 548,
	549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 558,
	559, 560, 561, 562, 563, 564, 565, 566, 566, 567, 568,
	569, 570, 571, 572, 573, 574, 574, 575, 576, 577, 578,
	579, 580, 581, 581, 582, 583, 584, 585, 586, 587, 588,
	588, 589, 590, 591, 592, 593, 594, 594, 595, 596, 597,
	598, 599, 600, 601, 601, 602, 603, 604, 605, 606, 606,
	607, 608, 609, 610, 611, 612, 612, 613, 614, 615, 616,
	617, 617, 618, 619, 620, 621, 622, 622, 623, 624, 625,
	626, 627, 627, 628, 629, 630, 631, 632, 632, 633, 634,
	635, 636, 637, 637, 638, 639, 640, 641, 642, 642, 643,
	644, 645, 646, 646, 647, 648, 649, 650, 650, 651, 652,
	653, 654, 655, 655, 656, 657, 658, 659, 659, 660, 661,
	662, 663, 663, 664, 665, 666, 667, 667, 668, 669, 670,
	671, 671, 672, 673, 674, 675, 675, 676, 677, 678, 678,
	679, 680, 681, 682, 682, 683, 684, 685, 686, 686, 687,
	688, 689, 689, 690, 691, 692, 693, 693, 694, 695, 696,
	696, 697, 698, 699, 700, 700, 701, 702, 703, 703, 704,
	705, 706, 707, 707, 708, 709, 710, 710, 711, 712, 713,
	713, 714, 715, 716, 716, 717, 718, 719, 719, 720, 721,
	722, 723, 723, 724, 725, 726, 726, 727, 728, 729, 729,
	730, 731, 732, 732, 733, 734, 735, 735, 736, 737, 738,
	738, 739, 740, 741, 741, 742, 743, 743, 744, 745, 746,
	746, 747, 748, 749, 749, 750, 751, 752, 752, 753, 754,
	755, 755, 756, 757, 758, 758, 759, 760, 760, 761, 762,
	763, 763, 764, 765, 766, 766, 767, 768, 768, 769, 770,
	771, 771, 772, 773, 774, 774, 775, 776, 776, 777, 778,
	779, 779, 780, 781, 781, 782, 783, 784, 784, 785, 786,
	786, 787, 788, 789, 789, 790, 791, 791, 792, 793, 794,
	794, 795, 796, 796, 797, 798, 799, 799, 800, 801, 801,
	802, 803, 803, 804, 805, 806, 806, 807, 808, 808, 809,
	810, 811, 811, 812, 813, 813, 814, 815, 815, 816, 817,
	818, 818, 819, 820, 820, 821, 822, 822, 823, 824, 824,
	825, 826, 827, 827, 828, 829, 829, 830, 831, 831, 832,
	833, 833, 834, 835, 835, 836, 837, 838, 838, 839, 840,
	840, 841, 842, 842, 843, 844, 844, 845, 846, 846, 847,
	848, 848, 849, 850, 851, 851, 852, 853, 853, 854, 855,
	855, 856, 857, 857, 858, 859, 859, 860, 861, 861, 862,
	863, 863, 864, 865, 865, 866, 867, 867, 868, 869, 869,
	870, 871, 871, 872, 873, 873, 874, 875, 875, 876, 877,
	877, 878, 879, 879, 880, 881, 881, 882, 883, 883, 884,
	885, 885, 886, 887, 887, 888, 889, 889, 890, 891, 891,
	892, 893, 893, 894, 895, 895, 896, 897, 897, 898, 898,
	899, 900, 900, 901, 902, 902, 903, 904, 904, 905, 906,
	906, 907, 908, 908, 909, 910, 910, 911, 911, 912, 913,
	913, 914, 915, 915, 916, 917, 917, 918, 919, 919, 920,
	921, 921, 922, 922, 923, 924, 924, 925, 926, 926, 927,
	928, 928, 929, 930, 930, 931, 931, 932, 933, 933, 934,
	935, 935, 936, 937, 937, 938, 938, 939, 940, 940, 941,
	942, 942, 943, 944, 944, 945, 945, 946, 947, 947, 948,
	949, 949, 950, 950, 951, 952, 952, 953, 954, 954, 955,
	956, 956, 957, 957, 958, 959, 959, 960, 961, 961, 962,
	962, 963, 964, 964, 965, 966, 966, 967, 967, 968, 969,
	969, 970, 970, 971, 972, 972, 973, 974, 974, 975, 975,
	976, 977, 977, 978, 979, 979, 980, 980, 981, 982, 982,
	983, 983, 984, 985, 985, 986, 987, 987, 988, 988, 989,
	990, 990, 991, 991, 992, 993, 993, 994, 995, 995, 996,
	996, 997, 998, 998, 999, 999, 1000, 1001, 1001, 1002, 1002,
	1003, 1004, 1004, 1005, 1006, 1006, 1007, 1007, 1008, 1009, 1009,
	1010, 1010, 1011, 1012, 1012, 1013, 1013, 1014, 1015, 1015, 1016,
	1016, 1017, 1018, 1018, 1019, 1019, 1020, 1021, 1021, 1022, 1022,
	1023,
};

static const u16 xgamma10_07[GAMMA10_TABLE_LENGTH] = {
	0, 8, 13, 17, 21, 25, 28, 31, 34, 37, 40,
	43, 46, 48, 51, 53, 56, 58, 60, 63, 65, 67,
	70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90,
	92, 94, 96, 98, 100, 102, 104, 106, 108, 109, 111,
	113, 115, 117, 118, 120, 122, 124, 125, 127, 129, 131,
	132, 134, 136, 137, 139, 140, 142, 144, 145, 147, 149,
	150, 152, 153, 155, 157, 158, 160, 161, 163, 164, 166,
	167, 169, 170, 172, 173, 175, 176, 178, 179, 181, 182,
	184, 185, 187, 188, 190, 191, 192, 194, 195, 197, 198,
	199, 201, 202, 204, 205, 206, 208, 209, 211, 212, 213,
	215, 216, 217, 219, 220, 222, 223, 224, 226, 227, 228,
	230, 231, 232, 234, 235, 236, 237, 239, 240, 241, 243,
	244, 245, 247, 248, 249, 250, 252, 253, 254, 256, 257,
	258, 259, 261, 262, 263, 264, 266, 267, 268, 269, 271,
	272, 273, 274, 275, 277, 278, 279, 280, 282, 283, 284,
	285, 286, 288, 289, 290, 291, 292, 294, 295, 296, 297,
	298, 300, 301, 302, 303, 304, 306, 307, 308, 309, 310,
	311, 313, 314, 315, 316, 317, 318, 319, 321, 322, 323,
	324, 325, 326, 327, 329, 330, 331, 332, 333, 334, 335,
	337, 338, 339, 340, 341, 342, 343, 344, 346, 347, 348,
	349, 350, 351, 352, 353, 354, 355, 357, 358, 359, 360,
	361, 362, 363, 364, 365, 366, 368, 369, 370, 371, 372,
	373, 374, 375, 376, 377, 378, 379, 380, 382, 383, 384,
	385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395,
	396, 397, 398, 400, 401, 402, 403, 404, 405, 406, 407,
	408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418,
	419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429,
	430, 431, 432, 433, 434, 435, 436, 437, 439, 440, 441,
	442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
	452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462,
	463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473,
	474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484,
	485, 486, 487, 488, 489, 490, 491, 492, 492, 493, 494,
	495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505,
	506, 507, 508, 509, 510, 511, 511, 512, 513, 514, 515,
	516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526,
	526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536,
	537, 538, 538, 539, 540, 541, 542, 543, 544, 545, 546,
	547, 548, 549, 549, 550, 551, 552, 553, 554, 555, 556,
	557, 558, 559, 560, 560, 561, 562, 563, 564, 565, 566,
	567, 568, 569, 569, 570, 571, 572, 573, 574, 575, 576,
	577, 578, 578, 579, 580, 581, 582, 583, 584, 585, 586,
	586, 587, 588, 589, 590, 591, 592, 593, 594, 594, 595,
	596, 597, 598, 599, 600, 601, 601, 602, 603, 604, 605,
	606, 607, 608, 608, 609, 610, 611, 612, 613, 614, 615,
	615, 616, 617, 618, 619, 620, 621, 622, 622, 623, 624,
	625, 626, 627, 628, 628, 629, 630, 631, 632, 633, 634,
	634, 635, 636, 637, 638, 639, 640, 640, 641, 642, 643,
	644, 645, 646, 646, 647, 648, 649, 650, 651, 652, 652,
	653, 654, 655, 656, 657, 657, 658, 659, 660, 661, 662,
	663, 663, 664, 665, 666, 667, 668, 668, 669, 670, 671,
	672, 673, 673, 674, 675, 676, 677, 678, 678, 679, 680,
	681, 682, 683, 683, 684, 685, 686, 687, 688, 688, 689,
	690, 691, 692, 693, 693, 694, 695, 696, 697, 698, 698,
	699, 700, 701, 702, 703, 703, 704, 705, 706, 707, 707,
	708, 709, 710, 711, 712, 712, 713, 714, 715, 716, 716,
	717, 718, 719, 720, 721, 721, 722, 723, 724, 725, 725,
	726, 727, 728, 729, 729, 730, 731, 732, 733, 733, 734,
	735, 736, 737, 738, 738, 739, 740, 741, 742, 742, 743,
	744, 745, 746, 746, 747, 748, 749, 750, 750, 751, 752,
	753, 754, 754, 755, 756, 757, 758, 758, 759, 760, 761,
	761, 762, 763, 764, 765, 765, 766, 767, 768, 769, 769,
	770, 771, 772, 773, 773, 774, 775, 776, 777, 777, 778,
	779, 780, 780, 781, 782, 783, 784, 784, 785, 786, 787,
	788, 788, 789, 790, 791, 791, 792, 793, 794, 795, 795,
	796, 797, 798, 798, 799, 800, 801, 802, 802, 803, 804,
	805, 805, 806, 807, 808, 809, 809, 810, 811, 812, 812,
	813, 814, 815, 816, 816, 817, 818, 819, 819, 820, 821,
	822, 822, 823, 824, 825, 826, 826, 827, 828, 829, 829,
	830, 831, 832, 832, 833, 834, 835, 835, 836, 837, 838,
	839, 839, 840, 841, 842, 842, 843, 844, 845, 845, 846,
	847, 848, 848, 849, 850, 851, 851, 852, 853, 854, 854,
	855, 856, 857, 857, 858, 859, 860, 860, 861, 862, 863,
	864, 864, 865, 866, 867, 867, 868, 869, 870, 870, 871,
	872, 873, 873, 874, 875, 876, 876, 877, 878, 879, 879,
	880, 881, 881, 882, 883, 884, 884, 885, 886, 887, 887,
	888, 889, 890, 890, 891, 892, 893, 893, 894, 895, 896,
	896, 897, 898, 899, 899, 900, 901, 902, 902, 903, 904,
	904, 905, 906, 907, 907, 908, 909, 910, 910, 911, 912,
	913, 913, 914, 915, 916, 916, 917, 918, 918, 919, 920,
	921, 921, 922, 923, 924, 924, 925, 926, 927, 927, 928,
	929, 929, 930, 931, 932, 932, 933, 934, 935, 935, 936,
	937, 937, 938, 939, 940, 940, 941, 942, 943, 943, 944,
	945, 945, 946, 947, 948, 948, 949, 950, 950, 951, 952,
	953, 953, 954, 955, 956, 956, 957, 958, 958, 959, 960,
	961, 961, 962, 963, 963, 964, 965, 966, 966, 967, 968,
	968, 969, 970, 971, 971, 972, 973, 973, 974, 975, 976,
	976, 977, 978, 978, 979, 980, 981, 981, 982, 983, 983,
	984, 985, 986, 986, 987, 988, 988, 989, 990, 991, 991,
	992, 993, 993, 994, 995, 996, 996, 997, 998, 998, 999,
	1000, 1000, 1001, 1002, 1003, 1003, 1004, 1005, 1005, 1006, 1007,
	1008, 1008, 1009, 1010, 1010, 1011, 1012, 1012, 1013, 1014, 1015,
	1015, 1016, 1017, 1017, 1018, 1019, 1019, 1020, 1021, 1022, 1022,
	1023,
};

static const u16 xgamma10_08[GAMMA10_TABLE_LENGTH] = {
	0, 4, 7, 10, 12, 14, 17, 19, 21, 23, 25,
	27, 29, 31, 33, 35, 37, 39, 40, 42, 44, 46,
	47, 49, 51, 53, 54, 56, 58, 59, 61, 62, 64,
	66, 67, 69, 70, 72, 73, 75, 76, 78, 80, 81,
	83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97,
	99, 100, 102, 103, 104, 106, 107, 109, 110, 111, 113,
	114, 116, 117, 118, 120, 121, 122, 124, 125, 126, 128,
	129, 131, 132, 133, 135, 136, 137, 138, 140, 141, 142,
	144, 145, 146, 148, 149, 150, 152, 153, 154, 155, 157,
	158, 159, 160, 162, 163, 164, 166, 167, 168, 169, 171,
	172, 173, 174, 176, 177, 178, 179, 181, 182, 183, 184,
	185, 187, 188, 189, 190, 192, 193, 194, 195, 196, 198,
	199, 200, 201, 202, 204, 205, 206, 207, 208, 210, 211,
	212, 213, 214, 216, 217, 218, 219, 220, 221, 223, 224,
	225, 226, 227, 228, 230, 231, 232, 233, 234, 235, 237,
	238, 239, 240, 241, 242, 243, 245, 246, 247, 248, 249,
	250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 262,
	263, 264, 265, 266, 267, 268, 269, 271, 272, 273, 274,
	275, 276, 277, 278, 279, 281, 282, 283, 284, 285, 286,
	287, 288, 289, 290, 292, 293, 294, 295, 296, 297, 298,
	299, 300, 301, 302, 304, 305, 306, 307, 308, 309, 310,
	311, 312, 313, 314, 315, 316, 318, 319, 320, 321, 322,
	323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
	335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345,
	346, 347, 348, 349, 350, 351, 352, 353, 355, 356, 357,
	358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368,
	369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379,
	380, 381, 382, 383, 384, 385, 386, 388, 389, 390, 391,
	392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402,
	403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413,
	414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424,
	425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435,
	436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446,
	447, 448, 449, 450, 451, 451, 452, 453, 454, 455, 456,
	457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467,
	468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478,
	479, 480, 481, 482, 483, 484, 485, 486, 486, 487, 488,
	489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499,
	500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 509,
	510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520,
	521, 522, 523, 524, 525, 526, 527, 527, 528, 529, 530,
	531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541,
	542, 543, 543, 544, 545, 546, 547, 548, 549, 550, 551,
	552, 553, 554, 555, 556, 557, 557, 558, 559, 560, 561,
	562, 563, 564, 565, 566, 567, 568, 569, 570, 570, 571,
	572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582,
	582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592,
	593, 594, 594, 595, 596, 597, 598, 599, 600, 601, 602,
	603, 604, 604, 605, 606, 607, 608, 609, 610, 611, 612,
	613, 614, 615, 615, 616, 617, 618, 619, 620, 621, 622,
	623, 624, 624, 625, 626, 627, 628, 629, 630, 631, 632,
	633, 634, 634, 635, 636, 637, 638, 639, 640, 641, 642,
	643, 643, 644, 645, 646, 647, 648, 649, 650, 651, 651,
	652, 653, 654, 655, 656, 657, 658, 659, 660, 660, 661,
	662, 663, 664, 665, 666, 667, 668, 668, 669, 670, 671,
	672, 673, 674, 675, 676, 676, 677, 678, 679, 680, 681,
	682, 683, 684, 684, 685, 686, 687, 688, 689, 690, 691,
	691, 692, 693, 694, 695, 696, 697, 698, 699, 699, 700,
	701, 702, 703, 704, 705, 706, 706, 707, 708, 709, 710,
	711, 712, 713, 713, 714, 715, 716, 717, 718, 719, 720,
	720, 721, 722, 723, 724, 725, 726, 727, 727, 728, 729,
	730, 731, 732, 733, 734, 734, 735, 736, 737, 738, 739,
	740, 740, 741, 742, 743, 744, 745, 746, 747, 747, 748,
	749, 750, 751, 752, 753, 753, 754, 755, 756, 757, 758,
	759, 759, 760, 761, 762, 763, 764, 765, 766, 766, 767,
	768, 769, 770, 771, 772, 772, 773, 774, 775, 776, 777,
	778, 778, 779, 780, 781, 782, 783, 784, 784, 785, 786,
	787, 788, 789, 790, 790, 791, 792, 793, 794, 795, 795,
	796, 797, 798, 799, 800, 801, 801, 802, 803, 804, 805,
	806, 807, 807, 808, 809, 810, 811, 812, 812, 813, 814,
	815, 816, 817, 818, 818, 819, 820, 821, 822, 823, 823,
	824, 825, 826, 827, 828, 829, 829, 830, 831, 832, 833,
	834, 834, 835, 836, 837, 838, 839, 839, 840, 841, 842,
	843, 844, 845, 845, 846, 847, 848, 849, 850, 850, 851,
	852, 853, 854, 855, 855, 856, 857, 858, 859, 860, 860,
	861, 862, 863, 864, 865, 865, 866, 867, 868, 869, 870,
	870, 871, 872, 873, 874, 875, 875, 876, 877, 878, 879,
	880, 880, 881, 882, 883, 884, 885, 885, 886, 887, 888,
	889, 890, 890, 891, 892, 893, 894, 895, 895, 896, 897,
	898, 899, 899, 900, 901, 902, 903, 904, 904, 905, 906,
	907, 908, 909, 909, 910, 911, 912, 913, 913, 914, 915,
	916, 917, 918, 918, 919, 920, 921, 922, 923, 923, 924,
	925, 926, 927, 927, 928, 929, 930, 931, 932, 932, 933,
	934, 935, 936, 936, 937, 938, 939, 940, 941, 941, 942,
	943, 944, 945, 945, 946, 947, 948, 949, 950, 950, 951,
	952, 953, 954, 954, 955, 956, 957, 958, 958, 959, 960,
	961, 962, 963, 963, 964, 965, 966, 967, 967, 968, 969,
	970, 971, 971, 972, 973, 974, 975, 976, 976, 977, 978,
	979, 980, 980, 981, 982, 983, 984, 984, 985, 986, 987,
	988, 988, 989, 990, 991, 992, 992, 993, 994, 995, 996,
	997, 997, 998, 999, 1000, 1001, 1001, 1002, 1003, 1004, 1005,
	1005, 1006, 1007, 1008, 1009, 1009, 1010, 1011, 1012, 1013, 1013,
	1014, 1015, 1016, 1017, 1017, 1018, 1019, 1020, 1021, 1021, 1022,
	1023,
};

static const u16 xgamma10_09[GAMMA10_TABLE_LENGTH] = {
	0, 2, 4, 5, 7, 9, 10, 12, 13, 14, 16,
	17, 19, 20, 22, 23, 24, 26, 27, 28, 30, 31,
	32, 34, 35, 36, 38, 39, 40, 41, 43, 44, 45,
	47, 48, 49, 50, 52, 53, 54, 55, 57, 58, 59,
	60, 62, 63, 64, 65, 66, 68, 69, 70, 71, 72,
	74, 75, 76, 77, 78, 80, 81, 82, 83, 84, 86,
	87, 88, 89, 90, 92, 93, 94, 95, 96, 97, 99,
	100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111,
	112, 114, 115, 116, 117, 118, 119, 120, 122, 123, 124,
	125, 126, 127, 128, 130, 131, 132, 133, 134, 135, 136,
	137, 139, 140, 141, 142, 143, 144, 145, 146, 148, 149,
	150, 151, 152, 153, 154, 155, 156, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 168, 169, 170, 171, 172, 173,
	174, 175, 176, 177, 178, 180, 181, 182, 183, 184, 185,
	186, 187, 188, 189, 190, 192, 193, 194, 195, 196, 197,
	198, 199, 200, 201, 202, 203, 204, 206, 207, 208, 209,
	210, 211, 212, 213, 214, 215, 216, 217, 218, 220, 221,
	222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232,
	233, 234, 235, 237, 238, 239, 240, 241, 242, 243, 244,
	245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
	257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267,
	268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278,
	280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
	291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301,
	302, 303, 304, 305, 306, 307, 308, 309, 311, 312, 313,
	314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
	325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335,
	336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346,
	347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357,
	358, 359, 360, 361, 362, 363, 364, 365, 367, 368, 369,
	370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380,
	381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391,
	392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402,
	403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413,
	414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424,
	425, 426, 427, 427, 428, 429, 430, 431, 432, 433, 434,
	435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445,
	446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456,
	457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467,
	468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478,
	479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489,
	489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499,
	500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510,
	511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521,
	522, 523, 524, 525, 525, 526, 527, 528, 529, 530, 531,
	532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542,
	543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553,
	554, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563,
	564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574,
	575, 576, 577, 578, 579, 579, 580, 581, 582, 583, 584,
	585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595,
	596, 597, 598, 599, 600, 601, 601, 602, 603, 604, 605,
	606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616,
	617, 618, 619, 620, 621, 621, 622, 623, 624, 625, 626,
	627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637,
	638, 639, 640, 640, 641, 642, 643, 644, 645, 646, 647,
	648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658,
	658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668,
	669, 670, 671, 672, 673, 674, 675, 675, 676, 677, 678,
	679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689,
	690, 691, 691, 692, 693, 694, 695, 696, 697, 698, 699,
	700, 701, 702, 703, 704, 705, 706, 706, 707, 708, 709,
	710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720,
	721, 721, 722, 723, 724, 725, 726, 727, 728, 729, 730,
	731, 732, 733, 734, 735, 735, 736, 737, 738, 739, 740,
	741, 742, 743, 744, 745, 746, 747, 748, 749, 749, 750,
	751, 752, 753, 754, 755, 756, 757, 758, 759, 760, 761,
	762, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771,
	772, 773, 774, 775, 776, 776, 777, 778, 779, 780, 781,
	782, 783, 784, 785, 786, 787, 788, 788, 789, 790, 791,
	792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 801,
	802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812,
	813, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822,
	823, 824, 825, 825, 826, 827, 828, 829, 830, 831, 832,
	833, 834, 835, 836, 836, 837, 838, 839, 840, 841, 842,
	843, 844, 845, 846, 847, 848, 848, 849, 850, 851, 852,
	853, 854, 855, 856, 857, 858, 859, 859, 860, 861, 862,
	863, 864, 865, 866, 867, 868, 869, 870, 870, 871, 872,
	873, 874, 875, 876, 877, 878, 879, 880, 881, 881, 882,
	883, 884, 885, 886, 887, 888, 889, 890, 891, 892, 892,
	893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 902,
	903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 913,
	913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923,
	923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933,
	933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943,
	943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953,
	953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 962,
	963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 972,
	973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 982,
	983, 984, 985, 986, 987, 988, 989, 990, 991, 991, 992,
	993, 994, 995, 996, 997, 998, 999, 1000, 1000, 1001, 1002,
	1003, 1004, 1005, 1006, 1007, 1008, 1009, 1009, 1010, 1011, 1012,
	1013, 1014, 1015, 1016, 1017, 1018, 1018, 1019, 1020, 1021, 1022,
	1023,
};

static const u16 xgamma10_10[GAMMA10_TABLE_LENGTH] = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
	44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
	66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
	77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
	88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
	99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
	110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
	132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
	143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
	154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
	165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
	187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197,
	198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208,
	209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
	231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263,
	264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274,
	275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285,
	286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296,
	297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307,
	308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
	319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
	330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
	341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351,
	352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
	363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373,
	374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384,
	385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395,
	396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406,
	407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417,
	418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428,
	429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439,
	440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450,
	451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461,
	462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472,
	473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483,
	484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
	495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505,
	506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516,
	517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527,
	528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538,
	539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549,
	550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560,
	561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571,
	572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582,
	583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593,
	594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604,
	605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615,
	616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626,
	627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637,
	638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648,
	649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659,
	660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670,
	671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681,
	682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692,
	693, 694, 695, 696, 697, 698, 699, 700, 701, 702, 703,
	704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714,
	715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725,
	726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736,
	737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747,
	748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 758,
	759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769,
	770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780,
	781, 782, 783, 784, 785, 786, 787, 788, 789, 790, 791,
	792, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802,
	803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813,
	814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824,
	825, 826, 827, 828, 829, 830, 831, 832, 833, 834, 835,
	836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846,
	847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857,
	858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868,
	869, 870, 871, 872, 873, 874, 875, 876, 877, 878, 879,
	880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890,
	891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901,
	902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912,
	913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923,
	924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934,
	935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945,
	946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956,
	957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967,
	968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978,
	979, 980, 981, 982, 983, 984, 985, 986, 987, 988, 989,
	990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000,
	1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011,
	1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022,
	1023,
};

static const u16 xgamma10_11[GAMMA10_TABLE_LENGTH] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6,
	7, 8, 8, 9, 10, 11, 11, 12, 13, 13, 14,
	15, 16, 16, 17, 18, 19, 20, 20, 21, 22, 23,
	23, 24, 25, 26, 27, 27, 28, 29, 30, 31, 31,
	32, 33, 34, 35, 35, 36, 37, 38, 39, 39, 40,
	41, 42, 43, 44, 44, 45, 46, 47, 48, 49, 49,
	50, 51, 52, 53, 54, 54, 55, 56, 57, 58, 59,
	59, 60, 61, 62, 63, 64, 65, 65, 66, 67, 68,
	69, 70, 71, 71, 72, 73, 74, 75, 76, 77, 78,
	78, 79, 80, 81, 82, 83, 84, 84, 85, 86, 87,
	88, 89, 90, 91, 92, 92, 93, 94, 95, 96, 97,
	98, 99, 100, 100, 101, 102, 103, 104, 105, 106, 107,
	108, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
	117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
	127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137,
	137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
	148, 149, 149, 150, 151, 152, 153, 154, 155, 156, 157,
	158, 159, 160, 161, 161, 162, 163, 164, 165, 166, 167,
	168, 169, 170, 171, 172, 173, 174, 175, 175, 176, 177,
	178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188,
	189, 190, 191, 191, 192, 193, 194, 195, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
	210, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
	231, 232, 232, 233, 234, 235, 236, 237, 238, 239, 240,
	241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
	252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 261,
	262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272,
	273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283,
	284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294,
	295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305,
	306, 307, 307, 308, 309, 310, 311, 312, 313, 314, 315,
	316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326,
	327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337,
	338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
	349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
	360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370,
	371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381,
	382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392,
	393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403,
	404, 405, 406, 407, 408, 409, 410, 411, 412, 414, 415,
	416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426,
	427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437,
	438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448,
	449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459,
	460, 461, 462, 463, 464, 465, 466, 468, 469, 470, 471,
	472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482,
	483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493,
	494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 505,
	506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516,
	517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527,
	528, 529, 530, 531, 532, 533, 535, 536, 537, 538, 539,
	540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550,
	551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 562,
	563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573,
	574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584,
	586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596,
	597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 608,
	609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619,
	620, 621, 622, 623, 624, 625, 626, 627, 629, 630, 631,
	632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642,
	643, 644, 645, 646, 648, 649, 650, 651, 652, 653, 654,
	655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665,
	667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677,
	678, 679, 680, 681, 682, 683, 685, 686, 687, 688, 689,
	690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700,
	702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712,
	713, 714, 715, 716, 717, 719, 720, 721, 722, 723, 724,
	725, 726, 727, 728, 729, 730, 731, 732, 733, 735, 736,
	737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747,
	748, 750, 751, 752, 753, 754, 755, 756, 757, 758, 759,
	760, 761, 762, 763, 764, 766, 767, 768, 769, 770, 771,
	772, 773, 774, 775, 776, 777, 778, 779, 781, 782, 783,
	784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 795,
	796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806,
	807, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818,
	819, 820, 821, 823, 824, 825, 826, 827, 828, 829, 830,
	831, 832, 833, 834, 835, 837, 838, 839, 840, 841, 842,
	843, 844, 845, 846, 847, 848, 850, 851, 852, 853, 854,
	855, 856, 857, 858, 859, 860, 861, 863, 864, 865, 866,
	867, 868, 869, 870, 871, 872, 873, 874, 876, 877, 878,
	879, 880, 881, 882, 883, 884, 885, 886, 887, 889, 890,
	891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 902,
	903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 914,
	915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 926,
	927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 938,
	939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 950,
	951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 962,
	963, 964, 965, 966, 967, 968, 969, 970, 971, 973, 974,
	975, 976, 977, 978, 979, 980, 981, 982, 983, 985, 986,
	987, 988, 989, 990, 991, 992, 993, 994, 996, 997, 998,
	999, 1000, 1001, 1002, 1003, 1004, 1005, 1007, 1008, 1009, 1010,
	1011, 1012, 1013, 1014, 1015, 1016, 1018, 1019, 1020, 1021, 1022,
	1023,
};

static const u16 xgamma10_12[GAMMA10_TABLE_LENGTH] = {
	0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4,
	4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10,
	10, 11, 11, 12, 12, 13, 14, 14, 15, 15, 16,
	17, 17, 18, 18, 19, 20, 20, 21, 22, 22, 23,
	23, 24, 25, 25, 26, 27, 27, 28, 29, 29, 30,
	31, 31, 32, 33, 33, 34, 35, 35, 36, 37, 37,
	38, 39, 40, 40, 41, 42, 42, 43, 44, 44, 45,
	46, 47, 47, 48, 49, 49, 50, 51, 52, 52, 53,
	54, 55, 55, 56, 57, 58, 58, 59, 60, 61, 61,
	62, 63, 64, 64, 65, 66, 67, 67, 68, 69, 70,
	70, 71, 72, 73, 74, 74, 75, 76, 77, 77, 78,
	79, 80, 81, 81, 82, 83, 84, 84, 85, 86, 87,
	88, 88, 89, 90, 91, 92, 92, 93, 94, 95, 96,
	96, 97, 98, 99, 100, 101, 101, 102, 103, 104, 105,
	105, 106, 107, 108, 109, 110, 110, 111, 112, 113, 114,
	115, 115, 116, 117, 118, 119, 120, 120, 121, 122, 123,
	124, 125, 125, 126, 127, 128, 129, 130, 131, 131, 132,
	133, 134, 135, 136, 137, 137, 138, 139, 140, 141, 142,
	143, 143, 144, 145, 146, 147, 148, 149, 150, 150, 151,
	152, 153, 154, 155, 156, 157, 157, 158, 159, 160, 161,
	162, 163, 164, 164, 165, 166, 167, 168, 169, 170, 171,
	172, 172, 173, 174, 175, 176, 177, 178, 179, 180, 180,
	181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 190,
	191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 200,
	201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
	211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221,
	222, 223, 224, 224, 225, 226, 227, 228, 229, 230, 231,
	232, 233, 234, 235, 236, 237, 238, 238, 239, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	253, 254, 255, 256, 256, 257, 258, 259, 260, 261, 262,
	263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
	274, 275, 276, 277, 278, 279, 280, 280, 281, 282, 283,
	284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294,
	295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305,
	306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316,
	317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327,
	328, 329, 330, 331, 332, 333, 334, 334, 335, 336, 337,
	338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
	349, 350, 351, 353, 354, 355, 356, 357, 358, 359, 360,
	361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371,
	372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382,
	383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393,
	394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
	405, 406, 407, 408, 409, 411, 412, 413, 414, 415, 416,
	417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427,
	428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 439,
	440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450,
	451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 462,
	463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473,
	474, 475, 476, 477, 478, 479, 481, 482, 483, 484, 485,
	486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496,
	497, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508,
	509, 510, 511, 512, 513, 515, 516, 517, 518, 519, 520,
	521, 522, 523, 524, 525, 526, 527, 529, 530, 531, 532,
	533, 534, 535, 536, 537, 538, 539, 540, 541, 543, 544,
	545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555,
	557, 558, 559, 560, 561, 562, 563, 564, 565, 566, 567,
	569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579,
	581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591,
	593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 604,
	605, 606, 607, 608, 609, 610, 611, 612, 613, 615, 616,
	617, 618, 619, 620, 621, 622, 623, 624, 626, 627, 628,
	629, 630, 631, 632, 633, 634, 636, 637, 638, 639, 640,
	641, 642, 643, 644, 646, 647, 648, 649, 650, 651, 652,
	653, 654, 656, 657, 658, 659, 660, 661, 662, 663, 664,
	666, 667, 668, 669, 670, 671, 672, 673, 675, 676, 677,
	678, 679, 680, 681, 682, 683, 685, 686, 687, 688, 689,
	690, 691, 692, 694, 695, 696, 697, 698, 699, 700, 701,
	703, 704, 705, 706, 707, 708, 709, 710, 712, 713, 714,
	715, 716, 717, 718, 720, 721, 722, 723, 724, 725, 726,
	727, 729, 730, 731, 732, 733, 734, 735, 737, 738, 739,
	740, 741, 742, 743, 745, 746, 747, 748, 749, 750, 751,
	752, 754, 755, 756, 757, 758, 759, 760, 762, 763, 764,
	765, 766, 767, 768, 770, 771, 772, 773, 774, 775, 776,
	778, 779, 780, 781, 782, 783, 785, 786, 787, 788, 789,
	790, 791, 793, 794, 795, 796, 797, 798, 799, 801, 802,
	803, 804, 805, 806, 808, 809, 810, 811, 812, 813, 814,
	816, 817, 818, 819, 820, 821, 823, 824, 825, 826, 827,
	828, 830, 831, 832, 833, 834, 835, 836, 838, 839, 840,
	841, 842, 843, 845, 846, 847, 848, 849, 850, 852, 853,
	854, 855, 856, 857, 859, 860, 861, 862, 863, 864, 866,
	867, 868, 869, 870, 871, 873, 874, 875, 876, 877, 878,
	880, 881, 882, 883, 884, 885, 887, 888, 889, 890, 891,
	892, 894, 895, 896, 897, 898, 900, 901, 902, 903, 904,
	905, 907, 908, 909, 910, 911, 912, 914, 915, 916, 917,
	918, 920, 921, 922, 923, 924, 925, 927, 928, 929, 930,
	931, 932, 934, 935, 936, 937, 938, 940, 941, 942, 943,
	944, 946, 947, 948, 949, 950, 951, 953, 954, 955, 956,
	957, 959, 960, 961, 962, 963, 964, 966, 967, 968, 969,
	970, 972, 973, 974, 975, 976, 978, 979, 980, 981, 982,
	984, 985, 986, 987, 988, 989, 991, 992, 993, 994, 995,
	997, 998, 999, 1000, 1001, 1003, 1004, 1005, 1006, 1007, 1009,
	1010, 1011, 1012, 1013, 1015, 1016, 1017, 1018, 1019, 1021, 1022,
	1023,
};

static const u16 xgamma10_13[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2,
	3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7,
	7, 7, 8, 8, 9, 9, 10, 10, 10, 11, 11,
	12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17,
	17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
	23, 23, 24, 25, 25, 26, 26, 27, 27, 28, 28,
	29, 30, 30, 31, 31, 32, 32, 33, 34, 34, 35,
	35, 36, 37, 37, 38, 38, 39, 40, 40, 41, 42,
	42, 43, 43, 44, 45, 45, 46, 47, 47, 48, 48,
	49, 50, 50, 51, 52, 52, 53, 54, 54, 55, 56,
	56, 57, 58, 58, 59, 60, 60, 61, 62, 62, 63,
	64, 64, 65, 66, 67, 67, 68, 69, 69, 70, 71,
	71, 72, 73, 74, 74, 75, 76, 76, 77, 78, 79,
	79, 80, 81, 81, 82, 83, 84, 84, 85, 86, 87,
	87, 88, 89, 89, 90, 91, 92, 92, 93, 94, 95,
	95, 96, 97, 98, 98, 99, 100, 101, 102, 102, 103,
	104, 105, 105, 106, 107, 108, 108, 109, 110, 111, 112,
	112, 113, 114, 115, 115, 116, 117, 118, 119, 119, 120,
	121, 122, 123, 123, 124, 125, 126, 127, 127, 128, 129,
	130, 131, 131, 132, 133, 134, 135, 135, 136, 137, 138,
	139, 140, 140, 141, 142, 143, 144, 145, 145, 146, 147,
	148, 149, 149, 150, 151, 152, 153, 154, 155, 155, 156,
	157, 158, 159, 160, 160, 161, 162, 163, 164, 165, 166,
	166, 167, 168, 169, 170, 171, 172, 172, 173, 174, 175,
	176, 177, 178, 178, 179, 180, 181, 182, 183, 184, 185,
	185, 186, 187, 188, 189, 190, 191, 192, 192, 193, 194,
	195, 196, 197, 198, 199, 200, 200, 201, 202, 203, 204,
	205, 206, 207, 208, 209, 209, 210, 211, 212, 213, 214,
	215, 216, 217, 218, 218, 219, 220, 221, 222, 223, 224,
	225, 226, 227, 228, 229, 229, 230, 231, 232, 233, 234,
	235, 236, 237, 238, 239, 240, 241, 242, 242, 243, 244,
	245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
	256, 257, 257, 258, 259, 260, 261, 262, 263, 264, 265,
	266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
	277, 278, 278, 279, 280, 281, 282, 283, 284, 285, 286,
	287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297,
	298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
	309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319,
	320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330,
	331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341,
	342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352,
	353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363,
	364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
	375, 376, 377, 378, 379, 380, 381, 383, 384, 385, 386,
	387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397,
	398, 399, 400, 401, 402, 403, 404, 405, 407, 408, 409,
	410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
	421, 422, 423, 424, 426, 427, 428, 429, 430, 431, 432,
	433, 434, 435, 436, 437, 438, 439, 440, 442, 443, 444,
	445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455,
	457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467,
	468, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
	480, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491,
	493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 504,
	505, 506, 507, 508, 509, 510, 511, 512, 513, 515, 516,
	517, 518, 519, 520, 521, 522, 523, 525, 526, 527, 528,
	529, 530, 531, 532, 534, 535, 536, 537, 538, 539, 540,
	541, 542, 544, 545, 546, 547, 548, 549, 550, 551, 553,
	554, 555, 556, 557, 558, 559, 561, 562, 563, 564, 565,
	566, 567, 568, 570, 571, 572, 573, 574, 575, 576, 578,
	579, 580, 581, 582, 583, 584, 586, 587, 588, 589, 590,
	591, 592, 594, 595, 596, 597, 598, 599, 600, 602, 603,
	604, 605, 606, 607, 608, 610, 611, 612, 613, 614, 615,
	617, 618, 619, 620, 621, 622, 624, 625, 626, 627, 628,
	629, 630, 632, 633, 634, 635, 636, 637, 639, 640, 641,
	642, 643, 644, 646, 647, 648, 649, 650, 652, 653, 654,
	655, 656, 657, 659, 660, 661, 662, 663, 664, 666, 667,
	668, 669, 670, 671, 673, 674, 675, 676, 677, 679, 680,
	681, 682, 683, 684, 686, 687, 688, 689, 690, 692, 693,
	694, 695, 696, 698, 699, 700, 701, 702, 704, 705, 706,
	707, 708, 709, 711, 712, 713, 714, 715, 717, 718, 719,
	720, 721, 723, 724, 725, 726, 727, 729, 730, 731, 732,
	733, 735, 736, 737, 738, 739, 741, 742, 743, 744, 746,
	747, 748, 749, 750, 752, 753, 754, 755, 756, 758, 759,
	760, 761, 762, 764, 765, 766, 767, 769, 770, 771, 772,
	773, 775, 776, 777, 778, 780, 781, 782, 783, 784, 786,
	787, 788, 789, 791, 792, 793, 794, 795, 797, 798, 799,
	800, 802, 803, 804, 805, 807, 808, 809, 810, 811, 813,
	814, 815, 816, 818, 819, 820, 821, 823, 824, 825, 826,
	827, 829, 830, 831, 832, 834, 835, 836, 837, 839, 840,
	841, 842, 844, 845, 846, 847, 849, 850, 851, 852, 854,
	855, 856, 857, 859, 860, 861, 862, 864, 865, 866, 867,
	869, 870, 871, 872, 874, 875, 876, 877, 879, 880, 881,
	882, 884, 885, 886, 887, 889, 890, 891, 892, 894, 895,
	896, 897, 899, 900, 901, 903, 904, 905, 906, 908, 909,
	910, 911, 913, 914, 915, 916, 918, 919, 920, 922, 923,
	924, 925, 927, 928, 929, 930, 932, 933, 934, 935, 937,
	938, 939, 941, 942, 943, 944, 946, 947, 948, 950, 951,
	952, 953, 955, 956, 957, 958, 960, 961, 962, 964, 965,
	966, 967, 969, 970, 971, 973, 974, 975, 976, 978, 979,
	980, 982, 983, 984, 985, 987, 988, 989, 991, 992, 993,
	994, 996, 997, 998, 1000, 1001, 1002, 1004, 1005, 1006, 1007,
	1009, 1010, 1011, 1013, 1014, 1015, 1017, 1018, 1019, 1020, 1022,
	1023,
};

static const u16 xgamma10_14[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
	5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8,
	8, 9, 9, 9, 10, 10, 11, 11, 11, 12, 12,
	12, 13, 13, 14, 14, 15, 15, 15, 16, 16, 17,
	17, 18, 18, 18, 19, 19, 20, 20, 21, 21, 22,
	22, 23, 23, 23, 24, 24, 25, 25, 26, 26, 27,
	27, 28, 28, 29, 29, 30, 30, 31, 31, 32, 32,
	33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38,
	39, 39, 40, 41, 41, 42, 42, 43, 43, 44, 45,
	45, 46, 46, 47, 47, 48, 49, 49, 50, 50, 51,
	52, 52, 53, 53, 54, 55, 55, 56, 56, 57, 58,
	58, 59, 59, 60, 61, 61, 62, 63, 63, 64, 64,
	65, 66, 66, 67, 68, 68, 69, 70, 70, 71, 72,
	72, 73, 74, 74, 75, 76, 76, 77, 78, 78, 79,
	80, 80, 81, 82, 82, 83, 84, 84, 85, 86, 86,
	87, 88, 88, 89, 90, 91, 91, 92, 93, 93, 94,
	95, 95, 96, 97, 98, 98, 99, 100, 100, 101, 102,
	103, 103, 104, 105, 106, 106, 107, 108, 109, 109, 110,
	111, 111, 112, 113, 114, 114, 115, 116, 117, 117, 118,
	119, 120, 120, 121, 122, 123, 124, 124, 125, 126, 127,
	127, 128, 129, 130, 130, 131, 132, 133, 134, 134, 135,
	136, 137, 138, 138, 139, 140, 141, 141, 142, 143, 144,
	145, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153,
	154, 154, 155, 156, 157, 158, 158, 159, 160, 161, 162,
	163, 163, 164, 165, 166, 167, 168, 168, 169, 170, 171,
	172, 173, 173, 174, 175, 176, 177, 178, 179, 179, 180,
	181, 182, 183, 184, 185, 185, 186, 187, 188, 189, 190,
	191, 191, 192, 193, 194, 195, 196, 197, 198, 198, 199,
	200, 201, 202, 203, 204, 205, 205, 206, 207, 208, 209,
	210, 211, 212, 213, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 222, 222, 223, 224, 225, 226, 227, 228, 229,
	230, 231, 232, 232, 233, 234, 235, 236, 237, 238, 239,
	240, 241, 242, 243, 244, 244, 245, 246, 247, 248, 249,
	250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 259,
	260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270,
	271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281,
	282, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291,
	292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302,
	303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313,
	314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
	325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335,
	336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346,
	347, 348, 349, 351, 352, 353, 354, 355, 356, 357, 358,
	359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369,
	370, 371, 372, 373, 374, 375, 377, 378, 379, 380, 381,
	382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392,
	393, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
	405, 406, 407, 408, 410, 411, 412, 413, 414, 415, 416,
	417, 418, 419, 420, 421, 423, 424, 425, 426, 427, 428,
	429, 430, 431, 432, 433, 435, 436, 437, 438, 439, 440,
	441, 442, 443, 444, 446, 447, 448, 449, 450, 451, 452,
	453, 454, 456, 457, 458, 459, 460, 461, 462, 463, 464,
	466, 467, 468, 469, 470, 471, 472, 473, 475, 476, 477,
	478, 479, 480, 481, 482, 484, 485, 486, 487, 488, 489,
	490, 491, 493, 494, 495, 496, 497, 498, 499, 501, 502,
	503, 504, 505, 506, 507, 509, 510, 511, 512, 513, 514,
	515, 517, 518, 519, 520, 521, 522, 524, 525, 526, 527,
	528, 529, 531, 532, 533, 534, 535, 536, 537, 539, 540,
	541, 542, 543, 544, 546, 547, 548, 549, 550, 552, 553,
	554, 555, 556, 557, 559, 560, 561, 562, 563, 564, 566,
	567, 568, 569, 570, 572, 573, 574, 575, 576, 578, 579,
	580, 581, 582, 583, 585, 586, 587, 588, 589, 591, 592,
	593, 594, 595, 597, 598, 599, 600, 601, 603, 604, 605,
	606, 607, 609, 610, 611, 612, 613, 615, 616, 617, 618,
	620, 621, 622, 623, 624, 626, 627, 628, 629, 630, 632,
	633, 634, 635, 637, 638, 639, 640, 641, 643, 644, 645,
	646, 648, 649, 650, 651, 653, 654, 655, 656, 657, 659,
	660, 661, 662, 664, 665, 666, 667, 669, 670, 671, 672,
	674, 675, 676, 677, 679, 680, 681, 682, 684, 685, 686,
	687, 689, 690, 691, 692, 694, 695, 696, 697, 699, 700,
	701, 702, 704, 705, 706, 707, 709, 710, 711, 712, 714,
	715, 716, 717, 719, 720, 721, 723, 724, 725, 726, 728,
	729, 730, 731, 733, 734, 735, 737, 738, 739, 740, 742,
	743, 744, 745, 747, 748, 749, 751, 752, 753, 754, 756,
	757, 758, 760, 761, 762, 763, 765, 766, 767, 769, 770,
	771, 772, 774, 775, 776, 778, 779, 780, 782, 783, 784,
	785, 787, 788, 789, 791, 792, 793, 794, 796, 797, 798,
	800, 801, 802, 804, 805, 806, 808, 809, 810, 811, 813,
	814, 815, 817, 818, 819, 821, 822, 823, 825, 826, 827,
	829, 830, 831, 833, 834, 835, 836, 838, 839, 840, 842,
	843, 844, 846, 847, 848, 850, 851, 852, 854, 855, 856,
	858, 859, 860, 862, 863, 864, 866, 867, 868, 870, 871,
	872, 874, 875, 876, 878, 879, 880, 882, 883, 884, 886,
	887, 888, 890, 891, 893, 894, 895, 897, 898, 899, 901,
	902, 903, 905, 906, 907, 909, 910, 911, 913, 914, 915,
	917, 918, 920, 921, 922, 924, 925, 926, 928, 929, 930,
	932, 933, 935, 936, 937, 939, 940, 941, 943, 944, 945,
	947, 948, 950, 951, 952, 954, 955, 956, 958, 959, 961,
	962, 963, 965, 966, 967, 969, 970, 972, 973, 974, 976,
	977, 978, 980, 981, 983, 984, 985, 987, 988, 990, 991,
	992, 994, 995, 996, 998, 999, 1001, 1002, 1003, 1005, 1006,
	1008, 1009, 1010, 1012, 1013, 1015, 1016, 1017, 1019, 1020, 1022,
	1023,
};

static const u16 xgamma10_15[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6,
	6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9,
	9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12,
	13, 13, 13, 14, 14, 15, 15, 15, 16, 16, 16,
	17, 17, 18, 18, 18, 19, 19, 20, 20, 20, 21,
	21, 22, 22, 22, 23, 23, 24, 24, 25, 25, 25,
	26, 26, 27, 27, 28, 28, 28, 29, 29, 30, 30,
	31, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36,
	36, 37, 37, 38, 38, 39, 39, 40, 40, 41, 41,
	42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47,
	47, 48, 48, 49, 50, 50, 51, 51, 52, 52, 53,
	53, 54, 55, 55, 56, 56, 57, 57, 58, 59, 59,
	60, 60, 61, 62, 62, 63, 63, 64, 64, 65, 66,
	66, 67, 67, 68, 69, 69, 70, 71, 71, 72, 72,
	73, 74, 74, 75, 76, 76, 77, 77, 78, 79, 79,
	80, 81, 81, 82, 83, 83, 84, 84, 85, 86, 86,
	87, 88, 88, 89, 90, 90, 91, 92, 92, 93, 94,
	94, 95, 96, 97, 97, 98, 99, 99, 100, 101, 101,
	102, 103, 103, 104, 105, 106, 106, 107, 108, 108, 109,
	110, 110, 111, 112, 113, 113, 114, 115, 116, 116, 117,
	118, 118, 119, 120, 121, 121, 122, 123, 124, 124, 125,
	126, 127, 127, 128, 129, 130, 130, 131, 132, 133, 133,
	134, 135, 136, 136, 137, 138, 139, 139, 140, 141, 142,
	143, 143, 144, 145, 146, 146, 147, 148, 149, 150, 150,
	151, 152, 153, 154, 154, 155, 156, 157, 158, 158, 159,
	160, 161, 162, 162, 163, 164, 165, 166, 167, 167, 168,
	169, 170, 171, 171, 172, 173, 174, 175, 176, 176, 177,
	178, 179, 180, 181, 181, 182, 183, 184, 185, 186, 187,
	187, 188, 189, 190, 191, 192, 193, 193, 194, 195, 196,
	197, 198, 199, 199, 200, 201, 202, 203, 204, 205, 206,
	206, 207, 208, 209, 210, 211, 212, 213, 214, 214, 215,
	216, 217, 218, 219, 220, 221, 222, 223, 223, 224, 225,
	226, 227, 228, 229, 230, 231, 232, 233, 233, 234, 235,
	236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 245,
	246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256,
	257, 258, 259, 260, 261, 261, 262, 263, 264, 265, 266,
	267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277,
	278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
	289, 290, 291, 292, 293, 293, 294, 295, 296, 297, 298,
	299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309,
	310, 311, 312, 314, 315, 316, 317, 318, 319, 320, 321,
	322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332,
	333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343,
	344, 345, 346, 347, 349, 350, 351, 352, 353, 354, 355,
	356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366,
	368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378,
	379, 380, 381, 383, 384, 385, 386, 387, 388, 389, 390,
	391, 392, 393, 395, 396, 397, 398, 399, 400, 401, 402,
	403, 404, 405, 407, 408, 409, 410, 411, 412, 413, 414,
	415, 417, 418, 419, 420, 421, 422, 423, 424, 425, 427,
	428, 429, 430, 431, 432, 433, 434, 436, 437, 438, 439,
	440, 441, 442, 444, 445, 446, 447, 448, 449, 450, 451,
	453, 454, 455, 456, 457, 458, 460, 461, 462, 463, 464,
	465, 466, 468, 469, 470, 471, 472, 473, 475, 476, 477,
	478, 479, 480, 482, 483, 484, 485, 486, 487, 489, 490,
	491, 492, 493, 494, 496, 497, 498, 499, 500, 501, 503,
	504, 505, 506, 507, 509, 510, 511, 512, 513, 515, 516,
	517, 518, 519, 521, 522, 523, 524, 525, 527, 528, 529,
	530, 531, 533, 534, 535, 536, 537, 539, 540, 541, 542,
	543, 545, 546, 547, 548, 550, 551, 552, 553, 554, 556,
	557, 558, 559, 561, 562, 563, 564, 565, 567, 568, 569,
	570, 572, 573, 574, 575, 577, 578, 579, 580, 582, 583,
	584, 585, 587, 588, 589, 590, 591, 593, 594, 595, 596,
	598, 599, 600, 602, 603, 604, 605, 607, 608, 609, 610,
	612, 613, 614, 615, 617, 618, 619, 620, 622, 623, 624,
	626, 627, 628, 629, 631, 632, 633, 634, 636, 637, 638,
	640, 641, 642, 643, 645, 646, 647, 649, 650, 651, 652,
	654, 655, 656, 658, 659, 660, 662, 663, 664, 665, 667,
	668, 669, 671, 672, 673, 675, 676, 677, 678, 680, 681,
	682, 684, 685, 686, 688, 689, 690, 692, 693, 694, 696,
	697, 698, 700, 701, 702, 703, 705, 706, 707, 709, 710,
	711, 713, 714, 715, 717, 718, 719, 721, 722, 723, 725,
	726, 727, 729, 730, 731, 733, 734, 735, 737, 738, 740,
	741, 742, 744, 745, 746, 748, 749, 750, 752, 753, 754,
	756, 757, 758, 760, 761, 763, 764, 765, 767, 768, 769,
	771, 772, 773, 775, 776, 778, 779, 780, 782, 783, 784,
	786, 787, 789, 790, 791, 793, 794, 795, 797, 798, 800,
	801, 802, 804, 805, 806, 808, 809, 811, 812, 813, 815,
	816, 818, 819, 820, 822, 823, 825, 826, 827, 829, 830,
	832, 833, 834, 836, 837, 839, 840, 841, 843, 844, 846,
	847, 848, 850, 851, 853, 854, 855, 857, 858, 860, 861,
	863, 864, 865, 867, 868, 870, 871, 872, 874, 875, 877,
	878, 880, 881, 882, 884, 885, 887, 888, 890, 891, 892,
	894, 895, 897, 898, 900, 901, 902, 904, 905, 907, 908,
	910, 911, 913, 914, 915, 917, 918, 920, 921, 923, 924,
	926, 927, 929, 930, 931, 933, 934, 936, 937, 939, 940,
	942, 943, 945, 946, 947, 949, 950, 952, 953, 955, 956,
	958, 959, 961, 962, 964, 965, 967, 968, 969, 971, 972,
	974, 975, 977, 978, 980, 981, 983, 984, 986, 987, 989,
	990, 992, 993, 995, 996, 998, 999, 1001, 1002, 1004, 1005,
	1007, 1008, 1010, 1011, 1013, 1014, 1016, 1017, 1019, 1020, 1022,
	1023,
};

static const u16 xgamma10_16[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6,
	7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9,
	10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12,
	13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16,
	16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20,
	20, 21, 21, 21, 22, 22, 22, 23, 23, 24, 24,
	24, 25, 25, 26, 26, 26, 27, 27, 28, 28, 28,
	29, 29, 30, 30, 31, 31, 31, 32, 32, 33, 33,
	34, 34, 35, 35, 35, 36, 36, 37, 37, 38, 38,
	39, 39, 40, 40, 41, 41, 41, 42, 42, 43, 43,
	44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49,
	49, 50, 50, 51, 52, 52, 53, 53, 54, 54, 55,
	55, 56, 56, 57, 57, 58, 58, 59, 60, 60, 61,
	61, 62, 62, 63, 63, 64, 65, 65, 66, 66, 67,
	67, 68, 69, 69, 70, 70, 71, 72, 72, 73, 73,
	74, 75, 75, 76, 76, 77, 78, 78, 79, 79, 80,
	81, 81, 82, 82, 83, 84, 84, 85, 86, 86, 87,
	87, 88, 89, 89, 90, 91, 91, 92, 93, 93, 94,
	95, 95, 96, 97, 97, 98, 99, 99, 100, 101, 101,
	102, 103, 103, 104, 105, 105, 106, 107, 107, 108, 109,
	109, 110, 111, 111, 112, 113, 114, 114, 115, 116, 116,
	117, 118, 119, 119, 120, 121, 121, 122, 123, 124, 124,
	125, 126, 126, 127, 128, 129, 129, 130, 131, 132, 132,
	133, 134, 135, 135, 136, 137, 138, 138, 139, 140, 141,
	141, 142, 143, 144, 144, 145, 146, 147, 148, 148, 149,
	150, 151, 151, 152, 153, 154, 155, 155, 156, 157, 158,
	159, 159, 160, 161, 162, 163, 163, 164, 165, 166, 167,
	167, 168, 169, 170, 171, 171, 172, 173, 174, 175, 176,
	176, 177, 178, 179, 180, 181, 181, 182, 183, 184, 185,
	186, 186, 187, 188, 189, 190, 191, 192, 192, 193, 194,
	195, 196, 197, 198, 198, 199, 200, 201, 202, 203, 204,
	204, 205, 206, 207, 208, 209, 210, 211, 212, 212, 213,
	214, 215, 216, 217, 218, 219, 220, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 230, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241, 242, 242, 243,
	244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
	255, 256, 257, 258, 258, 259, 260, 261, 262, 263, 264,
	265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275,
	276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286,
	287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297,
	298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
	309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319,
	320, 321, 322, 323, 324, 325, 326, 327, 329, 330, 331,
	332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342,
	343, 344, 345, 346, 348, 349, 350, 351, 352, 353, 354,
	355, 356, 357, 358, 359, 360, 362, 363, 364, 365, 366,
	367, 368, 369, 370, 371, 372, 374, 375, 376, 377, 378,
	379, 380, 381, 382, 383, 385, 386, 387, 388, 389, 390,
	391, 392, 393, 395, 396, 397, 398, 399, 400, 401, 402,
	404, 405, 406, 407, 408, 409, 410, 411, 413, 414, 415,
	416, 417, 418, 419, 421, 422, 423, 424, 425, 426, 428,
	429, 430, 431, 432, 433, 434, 436, 437, 438, 439, 440,
	441, 443, 444, 445, 446, 447, 448, 450, 451, 452, 453,
	454, 456, 457, 458, 459, 460, 461, 463, 464, 465, 466,
	467, 469, 470, 471, 472, 473, 475, 476, 477, 478, 479,
	481, 482, 483, 484, 485, 487, 488, 489, 490, 491, 493,
	494, 495, 496, 498, 499, 500, 501, 502, 504, 505, 506,
	507, 509, 510, 511, 512, 514, 515, 516, 517, 519, 520,
	521, 522, 523, 525, 526, 527, 528, 530, 531, 532, 533,
	535, 536, 537, 538, 540, 541, 542, 544, 545, 546, 547,
	549, 550, 551, 552, 554, 555, 556, 557, 559, 560, 561,
	563, 564, 565, 566, 568, 569, 570, 572, 573, 574, 575,
	577, 578, 579, 581, 582, 583, 584, 586, 587, 588, 590,
	591, 592, 594, 595, 596, 598, 599, 600, 601, 603, 604,
	605, 607, 608, 609, 611, 612, 613, 615, 616, 617, 619,
	620, 621, 623, 624, 625, 627, 628, 629, 631, 632, 633,
	635, 636, 637, 639, 640, 641, 643, 644, 645, 647, 648,
	649, 651, 652, 653, 655, 656, 657, 659, 660, 662, 663,
	664, 666, 667, 668, 670, 671, 672, 674, 675, 677, 678,
	679, 681, 682, 683, 685, 686, 688, 689, 690, 692, 693,
	694, 696, 697, 699, 700, 701, 703, 704, 706, 707, 708,
	710, 711, 712, 714, 715, 717, 718, 719, 721, 722, 724,
	725, 727, 728, 729, 731, 732, 734, 735, 736, 738, 739,
	741, 742, 743, 745, 746, 748, 749, 751, 752, 753, 755,
	756, 758, 759, 761, 762, 763, 765, 766, 768, 769, 771,
	772, 774, 775, 776, 778, 779, 781, 782, 784, 785, 787,
	788, 789, 791, 792, 794, 795, 797, 798, 800, 801, 803,
	804, 805, 807, 808, 810, 811, 813, 814, 816, 817, 819,
	820, 822, 823, 825, 826, 827, 829, 830, 832, 833, 835,
	836, 838, 839, 841, 842, 844, 845, 847, 848, 850, 851,
	853, 854, 856, 857, 859, 860, 862, 863, 865, 866, 868,
	869, 871, 872, 874, 875, 877, 878, 880, 881, 883, 884,
	886, 887, 889, 890, 892, 893, 895, 897, 898, 900, 901,
	903, 904, 906, 907, 909, 910, 912, 913, 915, 916, 918,
	919, 921, 923, 924, 926, 927, 929, 930, 932, 933, 935,
	936, 938, 940, 941, 943, 944, 946, 947, 949, 950, 952,
	954, 955, 957, 958, 960, 961, 963, 964, 966, 968, 969,
	971, 972, 974, 975, 977, 979, 980, 982, 983, 985, 986,
	988, 990, 991, 993, 994, 996, 998, 999, 1001, 1002, 1004,
	1005, 1007, 1009, 1010, 1012, 1013, 1015, 1017, 1018, 1020, 1021,
	1023,
};

static const u16 xgamma10_17[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5,
	5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7,
	7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9,
	10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12,
	13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15,
	16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19,
	19, 20, 20, 20, 21, 21, 21, 22, 22, 22, 23,
	23, 23, 24, 24, 25, 25, 25, 26, 26, 26, 27,
	27, 28, 28, 28, 29, 29, 29, 30, 30, 31, 31,
	31, 32, 32, 33, 33, 34, 34, 34, 35, 35, 36,
	36, 37, 37, 37, 38, 38, 39, 39, 40, 40, 40,
	41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46,
	46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51,
	51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56,
	57, 57, 58, 58, 59, 60, 60, 61, 61, 62, 62,
	63, 63, 64, 64, 65, 65, 66, 67, 67, 68, 68,
	69, 69, 70, 70, 71, 72, 72, 73, 73, 74, 74,
	75, 76, 76, 77, 77, 78, 79, 79, 80, 80, 81,
	82, 82, 83, 83, 84, 85, 85, 86, 86, 87, 88,
	88, 89, 89, 90, 91, 91, 92, 93, 93, 94, 95,
	95, 96, 96, 97, 98, 98, 99, 100, 100, 101, 102,
	102, 103, 104, 104, 105, 106, 106, 107, 108, 108, 109,
	110, 110, 111, 112, 112, 113, 114, 114, 115, 116, 116,
	117, 118, 119, 119, 120, 121, 121, 122, 123, 124, 124,
	125, 126, 126, 127, 128, 129, 129, 130, 131, 131, 132,
	133, 134, 134, 135, 136, 137, 137, 138, 139, 140, 140,
	141, 142, 143, 143, 144, 145, 146, 146, 147, 148, 149,
	149, 150, 151, 152, 153, 153, 154, 155, 156, 156, 157,
	158, 159, 160, 160, 161, 162, 163, 164, 164, 165, 166,
	167, 168, 168, 169, 170, 171, 172, 172, 173, 174, 175,
	176, 177, 177, 178, 179, 180, 181, 182, 182, 183, 184,
	185, 186, 187, 187, 188, 189, 190, 191, 192, 193, 193,
	194, 195, 196, 197, 198, 199, 199, 200, 201, 202, 203,
	204, 205, 206, 206, 207, 208, 209, 210, 211, 212, 213,
	213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 222,
	223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
	233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
	244, 245, 246, 247, 248, 248, 249, 250, 251, 252, 253,
	254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
	265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275,
	276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286,
	287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297,
	298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
	309, 310, 311, 312, 313, 314, 315, 316, 317, 319, 320,
	321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331,
	332, 333, 334, 336, 337, 338, 339, 340, 341, 342, 343,
	344, 345, 346, 347, 349, 350, 351, 352, 353, 354, 355,
	356, 357, 358, 360, 361, 362, 363, 364, 365, 366, 367,
	368, 370, 371, 372, 373, 374, 375, 376, 377, 379, 380,
	381, 382, 383, 384, 385, 386, 388, 389, 390, 391, 392,
	393, 394, 396, 397, 398, 399, 400, 401, 403, 404, 405,
	406, 407, 408, 409, 411, 412, 413, 414, 415, 417, 418,
	419, 420, 421, 422, 424, 425, 426, 427, 428, 430, 431,
	432, 433, 434, 435, 437, 438, 439, 440, 441, 443, 444,
	445, 446, 448, 449, 450, 451, 452, 454, 455, 456, 457,
	458, 460, 461, 462, 463, 465, 466, 467, 468, 469, 471,
	472, 473, 474, 476, 477, 478, 479, 481, 482, 483, 484,
	486, 487, 488, 489, 491, 492, 493, 494, 496, 497, 498,
	499, 501, 502, 503, 505, 506, 507, 508, 510, 511, 512,
	513, 515, 516, 517, 519, 520, 521, 522, 524, 525, 526,
	528, 529, 530, 532, 533, 534, 535, 537, 538, 539, 541,
	542, 543, 545, 546, 547, 549, 550, 551, 552, 554, 555,
	556, 558, 559, 560, 562, 563, 564, 566, 567, 568, 570,
	571, 572, 574, 575, 576, 578, 579, 580, 582, 583, 584,
	586, 587, 589, 590, 591, 593, 594, 595, 597, 598, 599,
	601, 602, 604, 605, 606, 608, 609, 610, 612, 613, 615,
	616, 617, 619, 620, 621, 623, 624, 626, 627, 628, 630,
	631, 633, 634, 635, 637, 638, 640, 641, 642, 644, 645,
	647, 648, 649, 651, 652, 654, 655, 656, 658, 659, 661,
	662, 664, 665, 666, 668, 669, 671, 672, 674, 675, 676,
	678, 679, 681, 682, 684, 685, 686, 688, 689, 691, 692,
	694, 695, 697, 698, 699, 701, 702, 704, 705, 707, 708,
	710, 711, 713, 714, 716, 717, 718, 720, 721, 723, 724,
	726, 727, 729, 730, 732, 733, 735, 736, 738, 739, 741,
	742, 744, 745, 747, 748, 750, 751, 753, 754, 756, 757,
	759, 760, 762, 763, 765, 766, 768, 769, 771, 772, 774,
	775, 777, 778, 780, 781, 783, 784, 786, 787, 789, 790,
	792, 793, 795, 797, 798, 800, 801, 803, 804, 806, 807,
	809, 810, 812, 814, 815, 817, 818, 820, 821, 823, 824,
	826, 827, 829, 831, 832, 834, 835, 837, 838, 840, 842,
	843, 845, 846, 848, 849, 851, 853, 854, 856, 857, 859,
	860, 862, 864, 865, 867, 868, 870, 872, 873, 875, 876,
	878, 880, 881, 883, 884, 886, 888, 889, 891, 892, 894,
	896, 897, 899, 900, 902, 904, 905, 907, 908, 910, 912,
	913, 915, 917, 918, 920, 921, 923, 925, 926, 928, 930,
	931, 933, 935, 936, 938, 939, 941, 943, 944, 946, 948,
	949, 951, 953, 954, 956, 958, 959, 961, 963, 964, 966,
	968, 969, 971, 973, 974, 976, 978, 979, 981, 983, 984,
	986, 988, 989, 991, 993, 994, 996, 998, 999, 1001, 1003,
	1004, 1006, 1008, 1009, 1011, 1013, 1015, 1016, 1018, 1020, 1021,
	1023,
};

static const u16 xgamma10_18[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
	4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12,
	12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15,
	15, 16, 16, 16, 16, 17, 17, 17, 18, 18, 18,
	18, 19, 19, 19, 20, 20, 20, 21, 21, 21, 22,
	22, 22, 23, 23, 23, 24, 24, 24, 25, 25, 25,
	26, 26, 26, 27, 27, 27, 28, 28, 29, 29, 29,
	30, 30, 30, 31, 31, 32, 32, 32, 33, 33, 33,
	34, 34, 35, 35, 35, 36, 36, 37, 37, 38, 38,
	38, 39, 39, 40, 40, 40, 41, 41, 42, 42, 43,
	43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48,
	48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53,
	53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58,
	59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64,
	64, 65, 65, 66, 66, 67, 68, 68, 69, 69, 70,
	70, 71, 71, 72, 72, 73, 74, 74, 75, 75, 76,
	76, 77, 78, 78, 79, 79, 80, 80, 81, 82, 82,
	83, 83, 84, 85, 85, 86, 86, 87, 88, 88, 89,
	89, 90, 91, 91, 92, 92, 93, 94, 94, 95, 96,
	96, 97, 97, 98, 99, 99, 100, 101, 101, 102, 103,
	103, 104, 104, 105, 106, 106, 107, 108, 108, 109, 110,
	110, 111, 112, 112, 113, 114, 114, 115, 116, 117, 117,
	118, 119, 119, 120, 121, 121, 122, 123, 123, 124, 125,
	126, 126, 127, 128, 128, 129, 130, 131, 131, 132, 133,
	133, 134, 135, 136, 136, 137, 138, 139, 139, 140, 141,
	142, 142, 143, 144, 145, 145, 146, 147, 148, 148, 149,
	150, 151, 151, 152, 153, 154, 155, 155, 156, 157, 158,
	158, 159, 160, 161, 162, 162, 163, 164, 165, 166, 166,
	167, 168, 169, 170, 170, 171, 172, 173, 174, 175, 175,
	176, 177, 178, 179, 179, 180, 181, 182, 183, 184, 184,
	185, 186, 187, 188, 189, 190, 190, 191, 192, 193, 194,
	195, 196, 196, 197, 198, 199, 200, 201, 202, 203, 203,
	204, 205, 206, 207, 208, 209, 210, 210, 211, 212, 213,
	214, 215, 216, 217, 218, 219, 219, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 230, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
	245, 246, 247, 247, 248, 249, 250, 251, 252, 253, 254,
	255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
	266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
	277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287,
	288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298,
	299, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
	311, 312, 313, 314, 315, 316, 317, 319, 320, 321, 322,
	323, 324, 325, 326, 327, 328, 329, 330, 331, 333, 334,
	335, 336, 337, 338, 339, 340, 341, 342, 344, 345, 346,
	347, 348, 349, 350, 351, 353, 354, 355, 356, 357, 358,
	359, 360, 362, 363, 364, 365, 366, 367, 368, 370, 371,
	372, 373, 374, 375, 376, 378, 379, 380, 381, 382, 383,
	385, 386, 387, 388, 389, 390, 392, 393, 394, 395, 396,
	397, 399, 400, 401, 402, 403, 405, 406, 407, 408, 409,
	411, 412, 413, 414, 415, 417, 418, 419, 420, 421, 423,
	424, 425, 426, 427, 429, 430, 431, 432, 434, 435, 436,
	437, 439, 440, 441, 442, 443, 445, 446, 447, 448, 450,
	451, 452, 453, 455, 456, 457, 458, 460, 461, 462, 464,
	465, 466, 467, 469, 470, 471, 472, 474, 475, 476, 478,
	479, 480, 481, 483, 484, 485, 487, 488, 489, 490, 492,
	493, 494, 496, 497, 498, 500, 501, 502, 504, 505, 506,
	507, 509, 510, 511, 513, 514, 515, 517, 518, 519, 521,
	522, 523, 525, 526, 527, 529, 530, 531, 533, 534, 535,
	537, 538, 540, 541, 542, 544, 545, 546, 548, 549, 550,
	552, 553, 555, 556, 557, 559, 560, 561, 563, 564, 566,
	567, 568, 570, 571, 572, 574, 575, 577, 578, 579, 581,
	582, 584, 585, 586, 588, 589, 591, 592, 594, 595, 596,
	598, 599, 601, 602, 603, 605, 606, 608, 609, 611, 612,
	613, 615, 616, 618, 619, 621, 622, 624, 625, 626, 628,
	629, 631, 632, 634, 635, 637, 638, 640, 641, 642, 644,
	645, 647, 648, 650, 651, 653, 654, 656, 657, 659, 660,
	662, 663, 665, 666, 668, 669, 671, 672, 673, 675, 676,
	678, 679, 681, 682, 684, 686, 687, 689, 690, 692, 693,
	695, 696, 698, 699, 701, 702, 704, 705, 707, 708, 710,
	711, 713, 714, 716, 717, 719, 721, 722, 724, 725, 727,
	728, 730, 731, 733, 734, 736, 738, 739, 741, 742, 744,
	745, 747, 749, 750, 752, 753, 755, 756, 758, 760, 761,
	763, 764, 766, 767, 769, 771, 772, 774, 775, 777, 779,
	780, 782, 783, 785, 787, 788, 790, 791, 793, 795, 796,
	798, 799, 801, 803, 804, 806, 807, 809, 811, 812, 814,
	816, 817, 819, 820, 822, 824, 825, 827, 829, 830, 832,
	834, 835, 837, 839, 840, 842, 843, 845, 847, 848, 850,
	852, 853, 855, 857, 858, 860, 862, 863, 865, 867, 868,
	870, 872, 873, 875, 877, 878, 880, 882, 884, 885, 887,
	889, 890, 892, 894, 895, 897, 899, 900, 902, 904, 906,
	907, 909, 911, 912, 914, 916, 918, 919, 921, 923, 924,
	926, 928, 930, 931, 933, 935, 936, 938, 940, 942, 943,
	945, 947, 949, 950, 952, 954, 956, 957, 959, 961, 963,
	964, 966, 968, 970, 971, 973, 975, 977, 978, 980, 982,
	984, 986, 987, 989, 991, 993, 994, 996, 998, 1000, 1002,
	1003, 1005, 1007, 1009, 1010, 1012, 1014, 1016, 1018, 1019, 1021,
	1023,
};

static const u16 xgamma10_19[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12,
	12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15,
	15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17,
	18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 21,
	21, 21, 22, 22, 22, 22, 23, 23, 23, 24, 24,
	24, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28,
	28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 32,
	32, 32, 33, 33, 33, 34, 34, 35, 35, 35, 36,
	36, 36, 37, 37, 38, 38, 38, 39, 39, 40, 40,
	41, 41, 41, 42, 42, 43, 43, 43, 44, 44, 45,
	45, 46, 46, 46, 47, 47, 48, 48, 49, 49, 50,
	50, 51, 51, 51, 52, 52, 53, 53, 54, 54, 55,
	55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60,
	61, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66,
	66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71,
	72, 72, 73, 74, 74, 75, 75, 76, 76, 77, 77,
	78, 79, 79, 80, 80, 81, 81, 82, 83, 83, 84,
	84, 85, 85, 86, 87, 87, 88, 88, 89, 90, 90,
	91, 91, 92, 93, 93, 94, 94, 95, 96, 96, 97,
	98, 98, 99, 99, 100, 101, 101, 102, 103, 103, 104,
	105, 105, 106, 107, 107, 108, 108, 109, 110, 110, 111,
	112, 112, 113, 114, 114, 115, 116, 116, 117, 118, 119,
	119, 120, 121, 121, 122, 123, 123, 124, 125, 125, 126,
	127, 128, 128, 129, 130, 130, 131, 132, 133, 133, 134,
	135, 135, 136, 137, 138, 138, 139, 140, 141, 141, 142,
	143, 144, 144, 145, 146, 147, 147, 148, 149, 150, 150,
	151, 152, 153, 154, 154, 155, 156, 157, 157, 158, 159,
	160, 161, 161, 162, 163, 164, 165, 165, 166, 167, 168,
	169, 169, 170, 171, 172, 173, 173, 174, 175, 176, 177,
	178, 178, 179, 180, 181, 182, 183, 183, 184, 185, 186,
	187, 188, 188, 189, 190, 191, 192, 193, 194, 195, 195,
	196, 197, 198, 199, 200, 201, 201, 202, 203, 204, 205,
	206, 207, 208, 209, 209, 210, 211, 212, 213, 214, 215,
	216, 217, 218, 219, 219, 220, 221, 222, 223, 224, 225,
	226, 227, 228, 229, 230, 231, 232, 232, 233, 234, 235,
	236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246,
	247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257,
	258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268,
	269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
	280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290,
	291, 292, 293, 294, 295, 296, 297, 299, 300, 301, 302,
	303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 314,
	315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 326,
	327, 328, 329, 330, 331, 332, 333, 334, 336, 337, 338,
	339, 340, 341, 342, 343, 345, 346, 347, 348, 349, 350,
	351, 353, 354, 355, 356, 357, 358, 360, 361, 362, 363,
	364, 365, 367, 368, 369, 370, 371, 372, 374, 375, 376,
	377, 378, 379, 381, 382, 383, 384, 385, 387, 388, 389,
	390, 391, 393, 394, 395, 396, 397, 399, 400, 401, 402,
	404, 405, 406, 407, 408, 410, 411, 412, 413, 415, 416,
	417, 418, 420, 421, 422, 423, 425, 426, 427, 428, 430,
	431, 432, 433, 435, 436, 437, 439, 440, 441, 442, 444,
	445, 446, 447, 449, 450, 451, 453, 454, 455, 456, 458,
	459, 460, 462, 463, 464, 466, 467, 468, 470, 471, 472,
	473, 475, 476, 477, 479, 480, 481, 483, 484, 485, 487,
	488, 489, 491, 492, 493, 495, 496, 498, 499, 500, 502,
	503, 504, 506, 507, 508, 510, 511, 512, 514, 515, 517,
	518, 519, 521, 522, 523, 525, 526, 528, 529, 530, 532,
	533, 535, 536, 537, 539, 540, 542, 543, 544, 546, 547,
	549, 550, 551, 553, 554, 556, 557, 559, 560, 561, 563,
	564, 566, 567, 569, 570, 572, 573, 574, 576, 577, 579,
	580, 582, 583, 585, 586, 587, 589, 590, 592, 593, 595,
	596, 598, 599, 601, 602, 604, 605, 607, 608, 610, 611,
	613, 614, 616, 617, 619, 620, 622, 623, 625, 626, 628,
	629, 631, 632, 634, 635, 637, 638, 640, 641, 643, 644,
	646, 647, 649, 650, 652, 653, 655, 656, 658, 660, 661,
	663, 664, 666, 667, 669, 670, 672, 674, 675, 677, 678,
	680, 681, 683, 684, 686, 688, 689, 691, 692, 694, 696,
	697, 699, 700, 702, 703, 705, 707, 708, 710, 711, 713,
	715, 716, 718, 719, 721, 723, 724, 726, 728, 729, 731,
	732, 734, 736, 737, 739, 741, 742, 744, 745, 747, 749,
	750, 752, 754, 755, 757, 759, 760, 762, 764, 765, 767,
	768, 770, 772, 773, 775, 777, 778, 780, 782, 783, 785,
	787, 789, 790, 792, 794, 795, 797, 799, 800, 802, 804,
	805, 807, 809, 810, 812, 814, 816, 817, 819, 821, 822,
	824, 826, 828, 829, 831, 833, 834, 836, 838, 840, 841,
	843, 845, 847, 848, 850, 852, 854, 855, 857, 859, 861,
	862, 864, 866, 868, 869, 871, 873, 875, 876, 878, 880,
	882, 883, 885, 887, 889, 891, 892, 894, 896, 898, 899,
	901, 903, 905, 907, 908, 910, 912, 914, 916, 917, 919,
	921, 923, 925, 926, 928, 930, 932, 934, 936, 937, 939,
	941, 943, 945, 947, 948, 950, 952, 954, 956, 958, 959,
	961, 963, 965, 967, 969, 970, 972, 974, 976, 978, 980,
	982, 983, 985, 987, 989, 991, 993, 995, 997, 998, 1000,
	1002, 1004, 1006, 1008, 1010, 1012, 1014, 1015, 1017, 1019, 1021,
	1023,
};

static const u16 xgamma10_20[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6,
	6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14,
	14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17,
	17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20,
	20, 20, 21, 21, 21, 21, 22, 22, 22, 23, 23,
	23, 23, 24, 24, 24, 25, 25, 25, 26, 26, 26,
	27, 27, 27, 28, 28, 28, 29, 29, 29, 30, 30,
	30, 31, 31, 31, 32, 32, 32, 33, 33, 33, 34,
	34, 35, 35, 35, 36, 36, 36, 37, 37, 38, 38,
	38, 39, 39, 39, 40, 40, 41, 41, 41, 42, 42,
	43, 43, 44, 44, 44, 45, 45, 46, 46, 46, 47,
	47, 48, 48, 49, 49, 49, 50, 50, 51, 51, 52,
	52, 53, 53, 54, 54, 54, 55, 55, 56, 56, 57,
	57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62,
	63, 63, 64, 64, 65, 65, 66, 66, 67, 67, 68,
	68, 69, 69, 70, 70, 71, 71, 72, 72, 73, 73,
	74, 74, 75, 76, 76, 77, 77, 78, 78, 79, 79,
	80, 81, 81, 82, 82, 83, 83, 84, 84, 85, 86,
	86, 87, 87, 88, 89, 89, 90, 90, 91, 92, 92,
	93, 93, 94, 95, 95, 96, 96, 97, 98, 98, 99,
	99, 100, 101, 101, 102, 103, 103, 104, 105, 105, 106,
	106, 107, 108, 108, 109, 110, 110, 111, 112, 112, 113,
	114, 114, 115, 116, 116, 117, 118, 118, 119, 120, 120,
	121, 122, 122, 123, 124, 125, 125, 126, 127, 127, 128,
	129, 130, 130, 131, 132, 132, 133, 134, 135, 135, 136,
	137, 137, 138, 139, 140, 140, 141, 142, 143, 143, 144,
	145, 146, 146, 147, 148, 149, 149, 150, 151, 152, 153,
	153, 154, 155, 156, 156, 157, 158, 159, 160, 160, 161,
	162, 163, 164, 164, 165, 166, 167, 168, 168, 169, 170,
	171, 172, 172, 173, 174, 175, 176, 177, 177, 178, 179,
	180, 181, 182, 182, 183, 184, 185, 186, 187, 188, 188,
	189, 190, 191, 192, 193, 194, 194, 195, 196, 197, 198,
	199, 200, 201, 201, 202, 203, 204, 205, 206, 207, 208,
	209, 210, 210, 211, 212, 213, 214, 215, 216, 217, 218,
	219, 220, 221, 221, 222, 223, 224, 225, 226, 227, 228,
	229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
	240, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
	250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
	261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271,
	273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283,
	284, 285, 286, 287, 288, 289, 290, 291, 292, 294, 295,
	296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 307,
	308, 309, 310, 311, 312, 313, 314, 315, 316, 318, 319,
	320, 321, 322, 323, 324, 325, 327, 328, 329, 330, 331,
	332, 333, 335, 336, 337, 338, 339, 340, 341, 343, 344,
	345, 346, 347, 348, 350, 351, 352, 353, 354, 355, 357,
	358, 359, 360, 361, 363, 364, 365, 366, 367, 369, 370,
	371, 372, 373, 375, 376, 377, 378, 379, 381, 382, 383,
	384, 386, 387, 388, 389, 390, 392, 393, 394, 395, 397,
	398, 399, 400, 402, 403, 404, 405, 407, 408, 409, 410,
	412, 413, 414, 416, 417, 418, 419, 421, 422, 423, 425,
	426, 427, 428, 430, 431, 432, 434, 435, 436, 437, 439,
	440, 441, 443, 444, 445, 447, 448, 449, 451, 452, 453,
	455, 456, 457, 459, 460, 461, 463, 464, 465, 467, 468,
	469, 471, 472, 474, 475, 476, 478, 479, 480, 482, 483,
	484, 486, 487, 489, 490, 491, 493, 494, 496, 497, 498,
	500, 501, 503, 504, 505, 507, 508, 510, 511, 512, 514,
	515, 517, 518, 519, 521, 522, 524, 525, 527, 528, 530,
	531, 532, 534, 535, 537, 538, 540, 541, 543, 544, 545,
	547, 548, 550, 551, 553, 554, 556, 557, 559, 560, 562,
	563, 565, 566, 568, 569, 571, 572, 574, 575, 577, 578,
	580, 581, 583, 584, 586, 587, 589, 590, 592, 593, 595,
	596, 598, 599, 601, 602, 604, 605, 607, 609, 610, 612,
	613, 615, 616, 618, 619, 621, 622, 624, 626, 627, 629,
	630, 632, 633, 635, 637, 638, 640, 641, 643, 645, 646,
	648, 649, 651, 652, 654, 656, 657, 659, 660, 662, 664,
	665, 667, 669, 670, 672, 673, 675, 677, 678, 680, 682,
	683, 685, 686, 688, 690, 691, 693, 695, 696, 698, 700,
	701, 703, 705, 706, 708, 710, 711, 713, 715, 716, 718,
	720, 721, 723, 725, 726, 728, 730, 731, 733, 735, 736,
	738, 740, 742, 743, 745, 747, 748, 750, 752, 754, 755,
	757, 759, 760, 762, 764, 766, 767, 769, 771, 773, 774,
	776, 778, 780, 781, 783, 785, 787, 788, 790, 792, 794,
	795, 797, 799, 801, 802, 804, 806, 808, 809, 811, 813,
	815, 817, 818, 820, 822, 824, 826, 827, 829, 831, 833,
	835, 836, 838, 840, 842, 844, 845, 847, 849, 851, 853,
	855, 856, 858, 860, 862, 864, 866, 867, 869, 871, 873,
	875, 877, 878, 880, 882, 884, 886, 888, 890, 892, 893,
	895, 897, 899, 901, 903, 905, 907, 908, 910, 912, 914,
	916, 918, 920, 922, 924, 925, 927, 929, 931, 933, 935,
	937, 939, 941, 943, 945, 946, 948, 950, 952, 954, 956,
	958, 960, 962, 964, 966, 968, 970, 972, 974, 976, 978,
	979, 981, 983, 985, 987, 989, 991, 993, 995, 997, 999,
	1001, 1003, 1005, 1007, 1009, 1011, 1013, 1015, 1017, 1019, 1021,
	1023,
};

static const u16 xgamma10_21[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
	12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 14,
	14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16,
	16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19,
	19, 19, 20, 20, 20, 21, 21, 21, 21, 22, 22,
	22, 22, 23, 23, 23, 24, 24, 24, 24, 25, 25,
	25, 26, 26, 26, 27, 27, 27, 28, 28, 28, 29,
	29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32,
	33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36,
	36, 37, 37, 38, 38, 38, 39, 39, 39, 40, 40,
	41, 41, 41, 42, 42, 43, 43, 43, 44, 44, 45,
	45, 45, 46, 46, 47, 47, 47, 48, 48, 49, 49,
	50, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54,
	54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59,
	59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64,
	65, 65, 66, 66, 67, 67, 68, 68, 69, 69, 70,
	70, 71, 71, 72, 72, 73, 74, 74, 75, 75, 76,
	76, 77, 77, 78, 78, 79, 79, 80, 81, 81, 82,
	82, 83, 83, 84, 85, 85, 86, 86, 87, 87, 88,
	89, 89, 90, 90, 91, 91, 92, 93, 93, 94, 94,
	95, 96, 96, 97, 97, 98, 99, 99, 100, 101, 101,
	102, 102, 103, 104, 104, 105, 106, 106, 107, 108, 108,
	109, 110, 110, 111, 111, 112, 113, 113, 114, 115, 115,
	116, 117, 117, 118, 119, 120, 120, 121, 122, 122, 123,
	124, 124, 125, 126, 126, 127, 128, 129, 129, 130, 131,
	131, 132, 133, 134, 134, 135, 136, 136, 137, 138, 139,
	139, 140, 141, 142, 142, 143, 144, 145, 145, 146, 147,
	148, 148, 149, 150, 151, 152, 152, 153, 154, 155, 155,
	156, 157, 158, 159, 159, 160, 161, 162, 163, 163, 164,
	165, 166, 167, 167, 168, 169, 170, 171, 171, 172, 173,
	174, 175, 176, 176, 177, 178, 179, 180, 181, 181, 182,
	183, 184, 185, 186, 187, 187, 188, 189, 190, 191, 192,
	193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202,
	202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
	212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222,
	223, 224, 225, 226, 227, 227, 228, 229, 230, 231, 232,
	233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
	244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
	255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
	266, 267, 268, 269, 271, 272, 273, 274, 275, 276, 277,
	278, 279, 280, 281, 282, 283, 284, 285, 286, 288, 289,
	290, 291, 292, 293, 294, 295, 296, 297, 298, 300, 301,
	302, 303, 304, 305, 306, 307, 308, 310, 311, 312, 313,
	314, 315, 316, 317, 319, 320, 321, 322, 323, 324, 326,
	327, 328, 329, 330, 331, 332, 334, 335, 336, 337, 338,
	339, 341, 342, 343, 344, 345, 347, 348, 349, 350, 351,
	353, 354, 355, 356, 357, 359, 360, 361, 362, 363, 365,
	366, 367, 368, 370, 371, 372, 373, 375, 376, 377, 378,
	380, 381, 382, 383, 385, 386, 387, 388, 390, 391, 392,
	393, 395, 396, 397, 399, 400, 401, 402, 404, 405, 406,
	408, 409, 410, 411, 413, 414, 415, 417, 418, 419, 421,
	422, 423, 425, 426, 427, 429, 430, 431, 433, 434, 435,
	437, 438, 439, 441, 442, 443, 445, 446, 447, 449, 450,
	452, 453, 454, 456, 457, 458, 460, 461, 463, 464, 465,
	467, 468, 469, 471, 472, 474, 475, 477, 478, 479, 481,
	482, 484, 485, 486, 488, 489, 491, 492, 494, 495, 496,
	498, 499, 501, 502, 504, 505, 507, 508, 509, 511, 512,
	514, 515, 517, 518, 520, 521, 523, 524, 526, 527, 529,
	530, 532, 533, 535, 536, 538, 539, 541, 542, 544, 545,
	547, 548, 550, 551, 553, 554, 556, 557, 559, 560, 562,
	563, 565, 566, 568, 569, 571, 573, 574, 576, 577, 579,
	580, 582, 583, 585, 587, 588, 590, 591, 593, 595, 596,
	598, 599, 601, 602, 604, 606, 607, 609, 610, 612, 614,
	615, 617, 618, 620, 622, 623, 625, 627, 628, 630, 631,
	633, 635, 636, 638, 640, 641, 643, 645, 646, 648, 650,
	651, 653, 654, 656, 658, 659, 661, 663, 664, 666, 668,
	670, 671, 673, 675, 676, 678, 680, 681, 683, 685, 686,
	688, 690, 692, 693, 695, 697, 698, 700, 702, 704, 705,
	707, 709, 711, 712, 714, 716, 717, 719, 721, 723, 724,
	726, 728, 730, 732, 733, 735, 737, 739, 740, 742, 744,
	746, 747, 749, 751, 753, 755, 756, 758, 760, 762, 764,
	765, 767, 769, 771, 773, 774, 776, 778, 780, 782, 784,
	785, 787, 789, 791, 793, 795, 796, 798, 800, 802, 804,
	806, 807, 809, 811, 813, 815, 817, 819, 821, 822, 824,
	826, 828, 830, 832, 834, 836, 837, 839, 841, 843, 845,
	847, 849, 851, 853, 855, 856, 858, 860, 862, 864, 866,
	868, 870, 872, 874, 876, 878, 880, 882, 883, 885, 887,
	889, 891, 893, 895, 897, 899, 901, 903, 905, 907, 909,
	911, 913, 915, 917, 919, 921, 923, 925, 927, 929, 931,
	933, 935, 937, 939, 941, 943, 945, 947, 949, 951, 953,
	955, 957, 959, 961, 963, 965, 967, 969, 971, 973, 975,
	977, 979, 981, 984, 986, 988, 990, 992, 994, 996, 998,
	1000, 1002, 1004, 1006, 1008, 1010, 1013, 1015, 1017, 1019, 1021,
	1023,
};

static const u16 xgamma10_22[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
	11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 15, 15, 15, 15, 15, 16,
	16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
	18, 19, 19, 19, 19, 20, 20, 20, 21, 21, 21,
	21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24,
	24, 25, 25, 25, 25, 26, 26, 26, 27, 27, 27,
	28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 31,
	31, 31, 32, 32, 32, 33, 33, 33, 34, 34, 34,
	35, 35, 35, 36, 36, 37, 37, 37, 38, 38, 38,
	39, 39, 39, 40, 40, 41, 41, 41, 42, 42, 43,
	43, 43, 44, 44, 44, 45, 45, 46, 46, 46, 47,
	47, 48, 48, 49, 49, 49, 50, 50, 51, 51, 52,
	52, 52, 53, 53, 54, 54, 55, 55, 55, 56, 56,
	57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 61,
	62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67,
	67, 68, 68, 69, 69, 70, 70, 71, 71, 72, 72,
	73, 73, 74, 75, 75, 76, 76, 77, 77, 78, 78,
	79, 79, 80, 80, 81, 82, 82, 83, 83, 84, 84,
	85, 85, 86, 87, 87, 88, 88, 89, 89, 90, 91,
	91, 92, 92, 93, 94, 94, 95, 95, 96, 97, 97,
	98, 98, 99, 100, 100, 101, 102, 102, 103, 103, 104,
	105, 105, 106, 107, 107, 108, 109, 109, 110, 110, 111,
	112, 112, 113, 114, 114, 115, 116, 116, 117, 118, 118,
	119, 120, 121, 121, 122, 123, 123, 124, 125, 125, 126,
	127, 127, 128, 129, 130, 130, 131, 132, 132, 133, 134,
	135, 135, 136, 137, 138, 138, 139, 140, 141, 141, 142,
	143, 144, 144, 145, 146, 147, 147, 148, 149, 150, 150,
	151, 152, 153, 154, 154, 155, 156, 157, 157, 158, 159,
	160, 161, 161, 162, 163, 164, 165, 166, 166, 167, 168,
	169, 170, 170, 171, 172, 173, 174, 175, 175, 176, 177,
	178, 179, 180, 181, 181, 182, 183, 184, 185, 186, 187,
	187, 188, 189, 190, 191, 192, 193, 194, 194, 195, 196,
	197, 198, 199, 200, 201, 202, 203, 203, 204, 205, 206,
	207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 216,
	217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227,
	228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238,
	239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
	250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
	261, 262, 263, 264, 265, 266, 267, 269, 270, 271, 272,
	273, 274, 275, 276, 277, 278, 279, 280, 281, 283, 284,
	285, 286, 287, 288, 289, 290, 291, 292, 294, 295, 296,
	297, 298, 299, 300, 301, 303, 304, 305, 306, 307, 308,
	309, 311, 312, 313, 314, 315, 316, 317, 319, 320, 321,
	322, 323, 324, 326, 327, 328, 329, 330, 332, 333, 334,
	335, 336, 338, 339, 340, 341, 342, 344, 345, 346, 347,
	348, 350, 351, 352, 353, 355, 356, 357, 358, 360, 361,
	362, 363, 365, 366, 367, 368, 370, 371, 372, 373, 375,
	376, 377, 378, 380, 381, 382, 384, 385, 386, 387, 389,
	390, 391, 393, 394, 395, 397, 398, 399, 401, 402, 403,
	405, 406, 407, 409, 410, 411, 413, 414, 415, 417, 418,
	419, 421, 422, 423, 425, 426, 427, 429, 430, 432, 433,
	434, 436, 437, 438, 440, 441, 443, 444, 445, 447, 448,
	450, 451, 452, 454, 455, 457, 458, 459, 461, 462, 464,
	465, 467, 468, 469, 471, 472, 474, 475, 477, 478, 480,
	481, 483, 484, 485, 487, 488, 490, 491, 493, 494, 496,
	497, 499, 500, 502, 503, 505, 506, 508, 509, 511, 512,
	514, 515, 517, 518, 520, 521, 523, 524, 526, 527, 529,
	530, 532, 534, 535, 537, 538, 540, 541, 543, 544, 546,
	548, 549, 551, 552, 554, 555, 557, 559, 560, 562, 563,
	565, 567, 568, 570, 571, 573, 575, 576, 578, 579, 581,
	583, 584, 586, 587, 589, 591, 592, 594, 596, 597, 599,
	601, 602, 604, 605, 607, 609, 610, 612, 614, 615, 617,
	619, 620, 622, 624, 625, 627, 629, 631, 632, 634, 636,
	637, 639, 641, 642, 644, 646, 648, 649, 651, 653, 654,
	656, 658, 660, 661, 663, 665, 667, 668, 670, 672, 674,
	675, 677, 679, 681, 682, 684, 686, 688, 689, 691, 693,
	695, 697, 698, 700, 702, 704, 705, 707, 709, 711, 713,
	714, 716, 718, 720, 722, 724, 725, 727, 729, 731, 733,
	735, 736, 738, 740, 742, 744, 746, 747, 749, 751, 753,
	755, 757, 759, 760, 762, 764, 766, 768, 770, 772, 774,
	776, 777, 779, 781, 783, 785, 787, 789, 791, 793, 795,
	796, 798, 800, 802, 804, 806, 808, 810, 812, 814, 816,
	818, 820, 822, 824, 826, 828, 829, 831, 833, 835, 837,
	839, 841, 843, 845, 847, 849, 851, 853, 855, 857, 859,
	861, 863, 865, 867, 869, 871, 873, 875, 877, 879, 881,
	883, 885, 887, 889, 892, 894, 896, 898, 900, 902, 904,
	906, 908, 910, 912, 914, 916, 918, 920, 922, 925, 927,
	929, 931, 933, 935, 937, 939, 941, 943, 945, 948, 950,
	952, 954, 956, 958, 960, 962, 965, 967, 969, 971, 973,
	975, 977, 980, 982, 984, 986, 988, 990, 992, 995, 997,
	999, 1001, 1003, 1005, 1008, 1010, 1012, 1014, 1016, 1019, 1021,
	1023,
};

static const u16 xgamma10_23[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9,
	9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11,
	11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13,
	13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18,
	18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20,
	21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23,
	23, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26,
	27, 27, 27, 27, 28, 28, 28, 29, 29, 29, 30,
	30, 30, 30, 31, 31, 31, 32, 32, 32, 33, 33,
	33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37,
	37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41,
	41, 42, 42, 42, 43, 43, 43, 44, 44, 45, 45,
	45, 46, 46, 47, 47, 47, 48, 48, 49, 49, 49,
	50, 50, 51, 51, 52, 52, 52, 53, 53, 54, 54,
	55, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59,
	59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64,
	65, 65, 66, 66, 67, 67, 68, 68, 69, 69, 70,
	70, 71, 71, 72, 72, 73, 73, 74, 74, 75, 75,
	76, 76, 77, 77, 78, 78, 79, 80, 80, 81, 81,
	82, 82, 83, 83, 84, 85, 85, 86, 86, 87, 87,
	88, 89, 89, 90, 90, 91, 91, 92, 93, 93, 94,
	94, 95, 96, 96, 97, 97, 98, 99, 99, 100, 100,
	101, 102, 102, 103, 104, 104, 105, 106, 106, 107, 107,
	108, 109, 109, 110, 111, 111, 112, 113, 113, 114, 115,
	115, 116, 117, 117, 118, 119, 119, 120, 121, 121, 122,
	123, 124, 124, 125, 126, 126, 127, 128, 128, 129, 130,
	131, 131, 132, 133, 133, 134, 135, 136, 136, 137, 138,
	139, 139, 140, 141, 142, 142, 143, 144, 145, 145, 146,
	147, 148, 148, 149, 150, 151, 152, 152, 153, 154, 155,
	156, 156, 157, 158, 159, 160, 160, 161, 162, 163, 164,
	164, 165, 166, 167, 168, 168, 169, 170, 171, 172, 173,
	174, 174, 175, 176, 177, 178, 179, 179, 180, 181, 182,
	183, 184, 185, 186, 186, 187, 188, 189, 190, 191, 192,
	193, 194, 194, 195, 196, 197, 198, 199, 200, 201, 202,
	203, 204, 204, 205, 206, 207, 208, 209, 210, 211, 212,
	213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 222,
	223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
	234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
	245, 246, 248, 249, 250, 251, 252, 253, 254, 255, 256,
	257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 268,
	269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 280,
	281, 282, 283, 284, 285, 286, 287, 288, 290, 291, 292,
	293, 294, 295, 296, 298, 299, 300, 301, 302, 303, 304,
	306, 307, 308, 309, 310, 311, 313, 314, 315, 316, 317,
	319, 320, 321, 322, 323, 325, 326, 327, 328, 329, 331,
	332, 333, 334, 335, 337, 338, 339, 340, 342, 343, 344,
	345, 347, 348, 349, 350, 352, 353, 354, 355, 357, 358,
	359, 360, 362, 363, 364, 366, 367, 368, 369, 371, 372,
	373, 375, 376, 377, 379, 380, 381, 383, 384, 385, 386,
	388, 389, 390, 392, 393, 394, 396, 397, 399, 400, 401,
	403, 404, 405, 407, 408, 409, 411, 412, 414, 415, 416,
	418, 419, 420, 422, 423, 425, 426, 427, 429, 430, 432,
	433, 435, 436, 437, 439, 440, 442, 443, 444, 446, 447,
	449, 450, 452, 453, 455, 456, 458, 459, 460, 462, 463,
	465, 466, 468, 469, 471, 472, 474, 475, 477, 478, 480,
	481, 483, 484, 486, 487, 489, 490, 492, 493, 495, 496,
	498, 499, 501, 502, 504, 506, 507, 509, 510, 512, 513,
	515, 516, 518, 520, 521, 523, 524, 526, 527, 529, 531,
	532, 534, 535, 537, 539, 540, 542, 543, 545, 547, 548,
	550, 551, 553, 555, 556, 558, 560, 561, 563, 565, 566,
	568, 569, 571, 573, 574, 576, 578, 579, 581, 583, 584,
	586, 588, 590, 591, 593, 595, 596, 598, 600, 601, 603,
	605, 606, 608, 610, 612, 613, 615, 617, 619, 620, 622,
	624, 625, 627, 629, 631, 632, 634, 636, 638, 640, 641,
	643, 645, 647, 648, 650, 652, 654, 655, 657, 659, 661,
	663, 664, 666, 668, 670, 672, 674, 675, 677, 679, 681,
	683, 684, 686, 688, 690, 692, 694, 696, 697, 699, 701,
	703, 705, 707, 709, 710, 712, 714, 716, 718, 720, 722,
	724, 725, 727, 729, 731, 733, 735, 737, 739, 741, 743,
	745, 746, 748, 750, 752, 754, 756, 758, 760, 762, 764,
	766, 768, 770, 772, 774, 776, 778, 780, 782, 784, 786,
	787, 789, 791, 793, 795, 797, 799, 801, 803, 805, 807,
	809, 811, 814, 816, 818, 820, 822, 824, 826, 828, 830,
	832, 834, 836, 838, 840, 842, 844, 846, 848, 850, 852,
	854, 857, 859, 861, 863, 865, 867, 869, 871, 873, 875,
	878, 880, 882, 884, 886, 888, 890, 892, 894, 897, 899,
	901, 903, 905, 907, 909, 912, 914, 916, 918, 920, 922,
	925, 927, 929, 931, 933, 936, 938, 940, 942, 944, 946,
	949, 951, 953, 955, 958, 960, 962, 964, 966, 969, 971,
	973, 975, 978, 980, 982, 984, 987, 989, 991, 993, 996,
	998, 1000, 1002, 1005, 1007, 1009, 1012, 1014, 1016, 1018, 1021,
	1023,
};

static const u16 xgamma10_24[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9,
	9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11,
	11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 13,
	13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15,
	15, 15, 15, 16, 16, 16, 16, 16, 17, 17, 17,
	17, 18, 18, 18, 18, 18, 19, 19, 19, 19, 20,
	20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22,
	23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25,
	26, 26, 26, 26, 27, 27, 27, 28, 28, 28, 28,
	29, 29, 29, 30, 30, 30, 31, 31, 31, 32, 32,
	32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 35,
	36, 36, 36, 37, 37, 38, 38, 38, 39, 39, 39,
	40, 40, 40, 41, 41, 41, 42, 42, 43, 43, 43,
	44, 44, 44, 45, 45, 46, 46, 46, 47, 47, 48,
	48, 48, 49, 49, 50, 50, 50, 51, 51, 52, 52,
	53, 53, 53, 54, 54, 55, 55, 56, 56, 56, 57,
	57, 58, 58, 59, 59, 60, 60, 61, 61, 61, 62,
	62, 63, 63, 64, 64, 65, 65, 66, 66, 67, 67,
	68, 68, 69, 69, 70, 70, 71, 71, 72, 72, 73,
	73, 74, 74, 75, 75, 76, 76, 77, 77, 78, 79,
	79, 80, 80, 81, 81, 82, 82, 83, 83, 84, 85,
	85, 86, 86, 87, 87, 88, 89, 89, 90, 90, 91,
	91, 92, 93, 93, 94, 94, 95, 96, 96, 97, 97,
	98, 99, 99, 100, 100, 101, 102, 102, 103, 104, 104,
	105, 106, 106, 107, 107, 108, 109, 109, 110, 111, 111,
	112, 113, 113, 114, 115, 115, 116, 117, 117, 118, 119,
	119, 120, 121, 121, 122, 123, 124, 124, 125, 126, 126,
	127, 128, 129, 129, 130, 131, 131, 132, 133, 134, 134,
	135, 136, 137, 137, 138, 139, 140, 140, 141, 142, 143,
	143, 144, 145, 146, 146, 147, 148, 149, 149, 150, 151,
	152, 153, 153, 154, 155, 156, 157, 157, 158, 159, 160,
	161, 161, 162, 163, 164, 165, 166, 166, 167, 168, 169,
	170, 171, 171, 172, 173, 174, 175, 176, 177, 177, 178,
	179, 180, 181, 182, 183, 184, 184, 185, 186, 187, 188,
	189, 190, 191, 192, 192, 193, 194, 195, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 204, 205, 206, 207, 208,
	209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
	220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
	231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
	242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
	253, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
	265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 276,
	277, 279, 280, 281, 282, 283, 284, 285, 287, 288, 289,
	290, 291, 292, 293, 295, 296, 297, 298, 299, 300, 302,
	303, 304, 305, 306, 308, 309, 310, 311, 312, 314, 315,
	316, 317, 318, 320, 321, 322, 323, 324, 326, 327, 328,
	329, 331, 332, 333, 334, 336, 337, 338, 339, 341, 342,
	343, 344, 346, 347, 348, 350, 351, 352, 353, 355, 356,
	357, 359, 360, 361, 363, 364, 365, 367, 368, 369, 370,
	372, 373, 374, 376, 377, 378, 380, 381, 383, 384, 385,
	387, 388, 389, 391, 392, 393, 395, 396, 398, 399, 400,
	402, 403, 405, 406, 407, 409, 410, 412, 413, 414, 416,
	417, 419, 420, 421, 423, 424, 426, 427, 429, 430, 432,
	433, 434, 436, 437, 439, 440, 442, 443, 445, 446, 448,
	449, 451, 452, 454, 455, 457, 458, 460, 461, 463, 464,
	466, 467, 469, 470, 472, 473, 475, 476, 478, 479, 481,
	483, 484, 486, 487, 489, 490, 492, 493, 495, 497, 498,
	500, 501, 503, 505, 506, 508, 509, 511, 512, 514, 516,
	517, 519, 521, 522, 524, 525, 527, 529, 530, 532, 534,
	535, 537, 539, 540, 542, 543, 545, 547, 548, 550, 552,
	553, 555, 557, 559, 560, 562, 564, 565, 567, 569, 570,
	572, 574, 576, 577, 579, 581, 582, 584, 586, 588, 589,
	591, 593, 595, 596, 598, 600, 602, 603, 605, 607, 609,
	610, 612, 614, 616, 618, 619, 621, 623, 625, 627, 628,
	630, 632, 634, 636, 637, 639, 641, 643, 645, 647, 648,
	650, 652, 654, 656, 658, 660, 661, 663, 665, 667, 669,
	671, 673, 674, 676, 678, 680, 682, 684, 686, 688, 690,
	692, 693, 695, 697, 699, 701, 703, 705, 707, 709, 711,
	713, 715, 717, 719, 721, 723, 724, 726, 728, 730, 732,
	734, 736, 738, 740, 742, 744, 746, 748, 750, 752, 754,
	756, 758, 760, 762, 764, 766, 768, 770, 772, 774, 777,
	779, 781, 783, 785, 787, 789, 791, 793, 795, 797, 799,
	801, 803, 805, 808, 810, 812, 814, 816, 818, 820, 822,
	824, 826, 829, 831, 833, 835, 837, 839, 841, 844, 846,
	848, 850, 852, 854, 856, 859, 861, 863, 865, 867, 870,
	872, 874, 876, 878, 880, 883, 885, 887, 889, 891, 894,
	896, 898, 900, 903, 905, 907, 909, 912, 914, 916, 918,
	921, 923, 925, 927, 930, 932, 934, 936, 939, 941, 943,
	946, 948, 950, 952, 955, 957, 959, 962, 964, 966, 969,
	971, 973, 976, 978, 980, 983, 985, 987, 990, 992, 994,
	997, 999, 1002, 1004, 1006, 1009, 1011, 1013, 1016, 1018, 1021,
	1023,
};

static const u16 xgamma10_25[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9,
	9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11,
	11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12,
	13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14,
	15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 17,
	17, 17, 17, 18, 18, 18, 18, 18, 19, 19, 19,
	19, 20, 20, 20, 20, 20, 21, 21, 21, 21, 22,
	22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 25,
	25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 28,
	28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31,
	31, 31, 32, 32, 32, 33, 33, 33, 34, 34, 34,
	35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38,
	38, 39, 39, 39, 40, 40, 40, 41, 41, 42, 42,
	42, 43, 43, 43, 44, 44, 45, 45, 45, 46, 46,
	46, 47, 47, 48, 48, 48, 49, 49, 50, 50, 50,
	51, 51, 52, 52, 53, 53, 53, 54, 54, 55, 55,
	56, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60,
	60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65,
	66, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71,
	71, 72, 72, 73, 73, 74, 74, 75, 75, 76, 76,
	77, 77, 78, 78, 79, 79, 80, 80, 81, 82, 82,
	83, 83, 84, 84, 85, 85, 86, 87, 87, 88, 88,
	89, 89, 90, 91, 91, 92, 92, 93, 94, 94, 95,
	95, 96, 97, 97, 98, 98, 99, 100, 100, 101, 102,
	102, 103, 103, 104, 105, 105, 106, 107, 107, 108, 109,
	109, 110, 110, 111, 112, 112, 113, 114, 114, 115, 116,
	117, 117, 118, 119, 119, 120, 121, 121, 122, 123, 123,
	124, 125, 126, 126, 127, 128, 128, 129, 130, 131, 131,
	132, 133, 133, 134, 135, 136, 136, 137, 138, 139, 139,
	140, 141, 142, 143, 143, 144, 145, 146, 146, 147, 148,
	149, 149, 150, 151, 152, 153, 153, 154, 155, 156, 157,
	158, 158, 159, 160, 161, 162, 162, 163, 164, 165, 166,
	167, 167, 168, 169, 170, 171, 172, 173, 173, 174, 175,
	176, 177, 178, 179, 180, 180, 181, 182, 183, 184, 185,
	186, 187, 188, 188, 189, 190, 191, 192, 193, 194, 195,
	196, 197, 198, 199, 200, 200, 201, 202, 203, 204, 205,
	206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
	217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227,
	228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238,
	239, 240, 241, 242, 243, 244, 245, 247, 248, 249, 250,
	251, 252, 253, 254, 255, 256, 257, 258, 260, 261, 262,
	263, 264, 265, 266, 267, 268, 270, 271, 272, 273, 274,
	275, 276, 277, 279, 280, 281, 282, 283, 284, 286, 287,
	288, 289, 290, 291, 293, 294, 295, 296, 297, 298, 300,
	301, 302, 303, 304, 306, 307, 308, 309, 311, 312, 313,
	314, 315, 317, 318, 319, 320, 322, 323, 324, 325, 327,
	328, 329, 330, 332, 333, 334, 336, 337, 338, 339, 341,
	342, 343, 345, 346, 347, 349, 350, 351, 352, 354, 355,
	356, 358, 359, 360, 362, 363, 364, 366, 367, 369, 370,
	371, 373, 374, 375, 377, 378, 379, 381, 382, 384, 385,
	386, 388, 389, 391, 392, 393, 395, 396, 398, 399, 400,
	402, 403, 405, 406, 408, 409, 411, 412, 413, 415, 416,
	418, 419, 421, 422, 424, 425, 427, 428, 430, 431, 433,
	434, 436, 437, 439, 440, 442, 443, 445, 446, 448, 449,
	451, 452, 454, 455, 457, 458, 460, 461, 463, 465, 466,
	468, 469, 471, 472, 474, 476, 477, 479, 480, 482, 483,
	485, 487, 488, 490, 491, 493, 495, 496, 498, 500, 501,
	503, 504, 506, 508, 509, 511, 513, 514, 516, 518, 519,
	521, 523, 524, 526, 528, 529, 531, 533, 534, 536, 538,
	540, 541, 543, 545, 546, 548, 550, 552, 553, 555, 557,
	558, 560, 562, 564, 565, 567, 569, 571, 572, 574, 576,
	578, 580, 581, 583, 585, 587, 588, 590, 592, 594, 596,
	597, 599, 601, 603, 605, 607, 608, 610, 612, 614, 616,
	618, 619, 621, 623, 625, 627, 629, 631, 632, 634, 636,
	638, 640, 642, 644, 646, 648, 649, 651, 653, 655, 657,
	659, 661, 663, 665, 667, 669, 671, 673, 674, 676, 678,
	680, 682, 684, 686, 688, 690, 692, 694, 696, 698, 700,
	702, 704, 706, 708, 710, 712, 714, 716, 718, 720, 722,
	724, 726, 728, 730, 732, 734, 736, 739, 741, 743, 745,
	747, 749, 751, 753, 755, 757, 759, 761, 763, 766, 768,
	770, 772, 774, 776, 778, 780, 782, 785, 787, 789, 791,
	793, 795, 797, 800, 802, 804, 806, 808, 810, 813, 815,
	817, 819, 821, 824, 826, 828, 830, 832, 835, 837, 839,
	841, 843, 846, 848, 850, 852, 855, 857, 859, 861, 864,
	866, 868, 870, 873, 875, 877, 880, 882, 884, 886, 889,
	891, 893, 896, 898, 900, 903, 905, 907, 910, 912, 914,
	917, 919, 921, 924, 926, 928, 931, 933, 935, 938, 940,
	942, 945, 947, 950, 952, 954, 957, 959, 962, 964, 966,
	969, 971, 974, 976, 979, 981, 983, 986, 988, 991, 993,
	996, 998, 1001, 1003, 1006, 1008, 1011, 1013, 1016, 1018, 1021,
	1023,
};

static const u16 xgamma10_26[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10,
	11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12,
	12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14,
	14, 14, 15, 15, 15, 15, 15, 16, 16, 16, 16,
	16, 17, 17, 17, 17, 18, 18, 18, 18, 18, 19,
	19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21,
	21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24,
	24, 24, 25, 25, 25, 25, 26, 26, 26, 27, 27,
	27, 27, 28, 28, 28, 28, 29, 29, 29, 30, 30,
	30, 31, 31, 31, 31, 32, 32, 32, 33, 33, 33,
	34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37,
	37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41,
	41, 41, 42, 42, 43, 43, 43, 44, 44, 44, 45,
	45, 46, 46, 46, 47, 47, 47, 48, 48, 49, 49,
	49, 50, 50, 51, 51, 51, 52, 52, 53, 53, 54,
	54, 54, 55, 55, 56, 56, 57, 57, 57, 58, 58,
	59, 59, 60, 60, 61, 61, 62, 62, 62, 63, 63,
	64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69,
	69, 70, 70, 71, 71, 72, 72, 73, 73, 74, 74,
	75, 75, 76, 76, 77, 77, 78, 78, 79, 80, 80,
	81, 81, 82, 82, 83, 83, 84, 84, 85, 86, 86,
	87, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93,
	93, 94, 94, 95, 96, 96, 97, 97, 98, 99, 99,
	100, 100, 101, 102, 102, 103, 104, 104, 105, 106, 106,
	107, 107, 108, 109, 109, 110, 111, 111, 112, 113, 113,
	114, 115, 115, 116, 117, 117, 118, 119, 120, 120, 121,
	122, 122, 123, 124, 124, 125, 126, 127, 127, 128, 129,
	129, 130, 131, 132, 132, 133, 134, 135, 135, 136, 137,
	138, 138, 139, 140, 141, 141, 142, 143, 144, 145, 145,
	146, 147, 148, 149, 149, 150, 151, 152, 153, 153, 154,
	155, 156, 157, 157, 158, 159, 160, 161, 162, 162, 163,
	164, 165, 166, 167, 167, 168, 169, 170, 171, 172, 173,
	173, 174, 175, 176, 177, 178, 179, 180, 181, 181, 182,
	183, 184, 185, 186, 187, 188, 189, 190, 191, 191, 192,
	193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203,
	204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214,
	215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225,
	226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236,
	237, 238, 239, 240, 241, 242, 243, 245, 246, 247, 248,
	249, 250, 251, 252, 253, 254, 256, 257, 258, 259, 260,
	261, 262, 263, 264, 266, 267, 268, 269, 270, 271, 272,
	274, 275, 276, 277, 278, 279, 281, 282, 283, 284, 285,
	286, 288, 289, 290, 291, 292, 294, 295, 296, 297, 299,
	300, 301, 302, 303, 305, 306, 307, 308, 310, 311, 312,
	313, 315, 316, 317, 318, 320, 321, 322, 323, 325, 326,
	327, 329, 330, 331, 333, 334, 335, 336, 338, 339, 340,
	342, 343, 344, 346, 347, 348, 350, 351, 352, 354, 355,
	356, 358, 359, 361, 362, 363, 365, 366, 367, 369, 370,
	372, 373, 374, 376, 377, 379, 380, 381, 383, 384, 386,
	387, 389, 390, 391, 393, 394, 396, 397, 399, 400, 402,
	403, 405, 406, 407, 409, 410, 412, 413, 415, 416, 418,
	419, 421, 422, 424, 425, 427, 428, 430, 432, 433, 435,
	436, 438, 439, 441, 442, 444, 445, 447, 449, 450, 452,
	453, 455, 456, 458, 460, 461, 463, 464, 466, 468, 469,
	471, 472, 474, 476, 477, 479, 481, 482, 484, 485, 487,
	489, 490, 492, 494, 495, 497, 499, 500, 502, 504, 505,
	507, 509, 510, 512, 514, 516, 517, 519, 521, 522, 524,
	526, 528, 529, 531, 533, 535, 536, 538, 540, 542, 543,
	545, 547, 549, 550, 552, 554, 556, 558, 559, 561, 563,
	565, 567, 568, 570, 572, 574, 576, 577, 579, 581, 583,
	585, 587, 588, 590, 592, 594, 596, 598, 600, 601, 603,
	605, 607, 609, 611, 613, 615, 617, 619, 620, 622, 624,
	626, 628, 630, 632, 634, 636, 638, 640, 642, 644, 646,
	648, 650, 651, 653, 655, 657, 659, 661, 663, 665, 667,
	669, 671, 673, 675, 677, 679, 681, 683, 685, 688, 690,
	692, 694, 696, 698, 700, 702, 704, 706, 708, 710, 712,
	714, 716, 718, 721, 723, 725, 727, 729, 731, 733, 735,
	737, 740, 742, 744, 746, 748, 750, 752, 755, 757, 759,
	761, 763, 765, 768, 770, 772, 774, 776, 779, 781, 783,
	785, 787, 790, 792, 794, 796, 798, 801, 803, 805, 807,
	810, 812, 814, 816, 819, 821, 823, 826, 828, 830, 832,
	835, 837, 839, 842, 844, 846, 849, 851, 853, 855, 858,
	860, 862, 865, 867, 870, 872, 874, 877, 879, 881, 884,
	886, 888, 891, 893, 896, 898, 900, 903, 905, 908, 910,
	913, 915, 917, 920, 922, 925, 927, 930, 932, 934, 937,
	939, 942, 944, 947, 949, 952, 954, 957, 959, 962, 964,
	967, 969, 972, 974, 977, 979, 982, 984, 987, 990, 992,
	995, 997, 1000, 1002, 1005, 1007, 1010, 1013, 1015, 1018, 1020,
	1023,
};

static const u16 xgamma10_27[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10,
	10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12,
	12, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14,
	14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16,
	16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18,
	18, 19, 19, 19, 19, 20, 20, 20, 20, 20, 21,
	21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23,
	24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26,
	26, 27, 27, 27, 27, 28, 28, 28, 29, 29, 29,
	29, 30, 30, 30, 31, 31, 31, 32, 32, 32, 32,
	33, 33, 33, 34, 34, 34, 35, 35, 35, 36, 36,
	36, 37, 37, 37, 38, 38, 38, 39, 39, 39, 40,
	40, 40, 41, 41, 41, 42, 42, 43, 43, 43, 44,
	44, 44, 45, 45, 46, 46, 46, 47, 47, 47, 48,
	48, 49, 49, 49, 50, 50, 51, 51, 51, 52, 52,
	53, 53, 54, 54, 54, 55, 55, 56, 56, 57, 57,
	57, 58, 58, 59, 59, 60, 60, 61, 61, 61, 62,
	62, 63, 63, 64, 64, 65, 65, 66, 66, 67, 67,
	68, 68, 69, 69, 70, 70, 71, 71, 72, 72, 73,
	73, 74, 74, 75, 75, 76, 76, 77, 77, 78, 78,
	79, 79, 80, 81, 81, 82, 82, 83, 83, 84, 84,
	85, 86, 86, 87, 87, 88, 88, 89, 90, 90, 91,
	91, 92, 92, 93, 94, 94, 95, 95, 96, 97, 97,
	98, 99, 99, 100, 100, 101, 102, 102, 103, 104, 104,
	105, 105, 106, 107, 107, 108, 109, 109, 110, 111, 111,
	112, 113, 113, 114, 115, 115, 116, 117, 118, 118, 119,
	120, 120, 121, 122, 122, 123, 124, 125, 125, 126, 127,
	127, 128, 129, 130, 130, 131, 132, 133, 133, 134, 135,
	136, 136, 137, 138, 139, 139, 140, 141, 142, 143, 143,
	144, 145, 146, 146, 147, 148, 149, 150, 150, 151, 152,
	153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161,
	162, 163, 164, 165, 165, 166, 167, 168, 169, 170, 171,
	172, 172, 173, 174, 175, 176, 177, 178, 179, 180, 180,
	181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
	192, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
	202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
	213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
	224, 225, 226, 227, 228, 229, 230, 231, 233, 234, 235,
	236, 237, 238, 239, 240, 241, 242, 243, 244, 246, 247,
	248, 249, 250, 251, 252, 253, 254, 256, 257, 258, 259,
	260, 261, 262, 263, 265, 266, 267, 268, 269, 270, 272,
	273, 274, 275, 276, 278, 279, 280, 281, 282, 283, 285,
	286, 287, 288, 290, 291, 292, 293, 294, 296, 297, 298,
	299, 301, 302, 303, 304, 306, 307, 308, 309, 311, 312,
	313, 315, 316, 317, 318, 320, 321, 322, 324, 325, 326,
	328, 329, 330, 332, 333, 334, 336, 337, 338, 340, 341,
	342, 344, 345, 346, 348, 349, 351, 352, 353, 355, 356,
	357, 359, 360, 362, 363, 364, 366, 367, 369, 370, 372,
	373, 374, 376, 377, 379, 380, 382, 383, 385, 386, 387,
	389, 390, 392, 393, 395, 396, 398, 399, 401, 402, 404,
	405, 407, 408, 410, 411, 413, 414, 416, 417, 419, 421,
	422, 424, 425, 427, 428, 430, 431, 433, 435, 436, 438,
	439, 441, 442, 444, 446, 447, 449, 450, 452, 454, 455,
	457, 459, 460, 462, 463, 465, 467, 468, 470, 472, 473,
	475, 477, 478, 480, 482, 483, 485, 487, 488, 490, 492,
	494, 495, 497, 499, 500, 502, 504, 506, 507, 509, 511,
	513, 514, 516, 518, 520, 521, 523, 525, 527, 528, 530,
	532, 534, 536, 537, 539, 541, 543, 545, 546, 548, 550,
	552, 554, 556, 557, 559, 561, 563, 565, 567, 569, 570,
	572, 574, 576, 578, 580, 582, 584, 586, 587, 589, 591,
	593, 595, 597, 599, 601, 603, 605, 607, 609, 611, 613,
	614, 616, 618, 620, 622, 624, 626, 628, 630, 632, 634,
	636, 638, 640, 642, 644, 646, 648, 650, 652, 654, 656,
	659, 661, 663, 665, 667, 669, 671, 673, 675, 677, 679,
	681, 683, 685, 688, 690, 692, 694, 696, 698, 700, 702,
	705, 707, 709, 711, 713, 715, 717, 720, 722, 724, 726,
	728, 730, 733, 735, 737, 739, 741, 744, 746, 748, 750,
	752, 755, 757, 759, 761, 764, 766, 768, 770, 773, 775,
	777, 779, 782, 784, 786, 789, 791, 793, 795, 798, 800,
	802, 805, 807, 809, 812, 814, 816, 819, 821, 823, 826,
	828, 831, 833, 835, 838, 840, 842, 845, 847, 850, 852,
	854, 857, 859, 862, 864, 867, 869, 871, 874, 876, 879,
	881, 884, 886, 889, 891, 894, 896, 899, 901, 903, 906,
	908, 911, 914, 916, 919, 921, 924, 926, 929, 931, 934,
	936, 939, 941, 944, 947, 949, 952, 954, 957, 959, 962,
	965, 967, 970, 973, 975, 978, 980, 983, 986, 988, 991,
	994, 996, 999, 1002, 1004, 1007, 1010, 1012, 1015, 1018, 1020,
	1023,
};

static const u16 xgamma10_28[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10,
	10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12,
	12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14,
	14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16,
	16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18,
	18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20,
	20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23,
	23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26,
	26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 29,
	29, 29, 29, 30, 30, 30, 31, 31, 31, 31, 32,
	32, 32, 33, 33, 33, 34, 34, 34, 35, 35, 35,
	35, 36, 36, 36, 37, 37, 37, 38, 38, 38, 39,
	39, 40, 40, 40, 41, 41, 41, 42, 42, 42, 43,
	43, 43, 44, 44, 45, 45, 45, 46, 46, 46, 47,
	47, 48, 48, 48, 49, 49, 50, 50, 50, 51, 51,
	52, 52, 52, 53, 53, 54, 54, 55, 55, 55, 56,
	56, 57, 57, 58, 58, 58, 59, 59, 60, 60, 61,
	61, 62, 62, 63, 63, 63, 64, 64, 65, 65, 66,
	66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71,
	72, 72, 73, 73, 74, 74, 75, 75, 76, 76, 77,
	77, 78, 79, 79, 80, 80, 81, 81, 82, 82, 83,
	83, 84, 85, 85, 86, 86, 87, 87, 88, 89, 89,
	90, 90, 91, 92, 92, 93, 93, 94, 95, 95, 96,
	96, 97, 98, 98, 99, 99, 100, 101, 101, 102, 103,
	103, 104, 105, 105, 106, 106, 107, 108, 108, 109, 110,
	110, 111, 112, 112, 113, 114, 115, 115, 116, 117, 117,
	118, 119, 119, 120, 121, 122, 122, 123, 124, 124, 125,
	126, 127, 127, 128, 129, 130, 130, 131, 132, 132, 133,
	134, 135, 136, 136, 137, 138, 139, 139, 140, 141, 142,
	143, 143, 144, 145, 146, 146, 147, 148, 149, 150, 151,
	151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160,
	161, 161, 162, 163, 164, 165, 166, 167, 167, 168, 169,
	170, 171, 172, 173, 174, 175, 175, 176, 177, 178, 179,
	180, 181, 182, 183, 184, 185, 186, 186, 187, 188, 189,
	190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
	201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222,
	223, 224, 225, 226, 228, 229, 230, 231, 232, 233, 234,
	235, 236, 237, 238, 239, 241, 242, 243, 244, 245, 246,
	247, 248, 249, 251, 252, 253, 254, 255, 256, 257, 259,
	260, 261, 262, 263, 264, 266, 267, 268, 269, 270, 272,
	273, 274, 275, 276, 278, 279, 280, 281, 282, 284, 285,
	286, 287, 289, 290, 291, 292, 294, 295, 296, 297, 299,
	300, 301, 302, 304, 305, 306, 308, 309, 310, 311, 313,
	314, 315, 317, 318, 319, 321, 322, 323, 325, 326, 327,
	329, 330, 331, 333, 334, 336, 337, 338, 340, 341, 342,
	344, 345, 347, 348, 349, 351, 352, 354, 355, 356, 358,
	359, 361, 362, 364, 365, 366, 368, 369, 371, 372, 374,
	375, 377, 378, 380, 381, 383, 384, 386, 387, 389, 390,
	392, 393, 395, 396, 398, 399, 401, 402, 404, 405, 407,
	408, 410, 412, 413, 415, 416, 418, 419, 421, 423, 424,
	426, 427, 429, 431, 432, 434, 435, 437, 439, 440, 442,
	444, 445, 447, 448, 450, 452, 453, 455, 457, 458, 460,
	462, 463, 465, 467, 468, 470, 472, 474, 475, 477, 479,
	480, 482, 484, 486, 487, 489, 491, 493, 494, 496, 498,
	500, 501, 503, 505, 507, 509, 510, 512, 514, 516, 518,
	519, 521, 523, 525, 527, 528, 530, 532, 534, 536, 538,
	539, 541, 543, 545, 547, 549, 551, 553, 554, 556, 558,
	560, 562, 564, 566, 568, 570, 572, 574, 575, 577, 579,
	581, 583, 585, 587, 589, 591, 593, 595, 597, 599, 601,
	603, 605, 607, 609, 611, 613, 615, 617, 619, 621, 623,
	625, 627, 629, 631, 633, 635, 637, 640, 642, 644, 646,
	648, 650, 652, 654, 656, 658, 660, 663, 665, 667, 669,
	671, 673, 675, 678, 680, 682, 684, 686, 688, 690, 693,
	695, 697, 699, 701, 704, 706, 708, 710, 712, 715, 717,
	719, 721, 724, 726, 728, 730, 733, 735, 737, 739, 742,
	744, 746, 749, 751, 753, 755, 758, 760, 762, 765, 767,
	769, 772, 774, 776, 779, 781, 783, 786, 788, 790, 793,
	795, 798, 800, 802, 805, 807, 810, 812, 814, 817, 819,
	822, 824, 827, 829, 831, 834, 836, 839, 841, 844, 846,
	849, 851, 854, 856, 859, 861, 864, 866, 869, 871, 874,
	876, 879, 881, 884, 887, 889, 892, 894, 897, 899, 902,
	905, 907, 910, 912, 915, 918, 920, 923, 925, 928, 931,
	933, 936, 939, 941, 944, 947, 949, 952, 955, 957, 960,
	963, 965, 968, 971, 973, 976, 979, 982, 984, 987, 990,
	992, 995, 998, 1001, 1004, 1006, 1009, 1012, 1015, 1017, 1020,
	1023,
};

static const u16 xgamma10_29[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9,
	9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10,
	10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12,
	12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13,
	14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15,
	16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18,
	18, 18, 18, 18, 19, 19, 19, 19, 19, 20, 20,
	20, 20, 21, 21, 21, 21, 21, 22, 22, 22, 22,
	23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25,
	25, 26, 26, 26, 26, 27, 27, 27, 28, 28, 28,
	28, 29, 29, 29, 29, 30, 30, 30, 31, 31, 31,
	31, 32, 32, 32, 33, 33, 33, 34, 34, 34, 35,
	35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38,
	38, 39, 39, 39, 40, 40, 41, 41, 41, 42, 42,
	42, 43, 43, 43, 44, 44, 44, 45, 45, 46, 46,
	46, 47, 47, 48, 48, 48, 49, 49, 49, 50, 50,
	51, 51, 52, 52, 52, 53, 53, 54, 54, 54, 55,
	55, 56, 56, 57, 57, 57, 58, 58, 59, 59, 60,
	60, 61, 61, 61, 62, 62, 63, 63, 64, 64, 65,
	65, 66, 66, 67, 67, 68, 68, 69, 69, 70, 70,
	71, 71, 72, 72, 73, 73, 74, 74, 75, 75, 76,
	76, 77, 77, 78, 78, 79, 80, 80, 81, 81, 82,
	82, 83, 83, 84, 85, 85, 86, 86, 87, 87, 88,
	89, 89, 90, 90, 91, 92, 92, 93, 93, 94, 95,
	95, 96, 96, 97, 98, 98, 99, 99, 100, 101, 101,
	102, 103, 103, 104, 105, 105, 106, 107, 107, 108, 109,
	109, 110, 111, 111, 112, 113, 113, 114, 115, 115, 116,
	117, 117, 118, 119, 120, 120, 121, 122, 122, 123, 124,
	125, 125, 126, 127, 128, 128, 129, 130, 131, 131, 132,
	133, 134, 134, 135, 136, 137, 137, 138, 139, 140, 141,
	141, 142, 143, 144, 145, 145, 146, 147, 148, 149, 149,
	150, 151, 152, 153, 154, 154, 155, 156, 157, 158, 159,
	160, 160, 161, 162, 163, 164, 165, 166, 166, 167, 168,
	169, 170, 171, 172, 173, 174, 175, 175, 176, 177, 178,
	179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	190, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
	211, 212, 214, 215, 216, 217, 218, 219, 220, 221, 222,
	223, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234,
	235, 236, 237, 238, 239, 241, 242, 243, 244, 245, 246,
	247, 248, 250, 251, 252, 253, 254, 255, 257, 258, 259,
	260, 261, 263, 264, 265, 266, 267, 269, 270, 271, 272,
	273, 275, 276, 277, 278, 280, 281, 282, 283, 285, 286,
	287, 288, 290, 291, 292, 293, 295, 296, 297, 299, 300,
	301, 302, 304, 305, 306, 308, 309, 310, 312, 313, 314,
	316, 317, 318, 320, 321, 322, 324, 325, 327, 328, 329,
	331, 332, 333, 335, 336, 338, 339, 340, 342, 343, 345,
	346, 348, 349, 350, 352, 353, 355, 356, 358, 359, 361,
	362, 363, 365, 366, 368, 369, 371, 372, 374, 375, 377,
	378, 380, 381, 383, 384, 386, 388, 389, 391, 392, 394,
	395, 397, 398, 400, 402, 403, 405, 406, 408, 409, 411,
	413, 414, 416, 417, 419, 421, 422, 424, 426, 427, 429,
	430, 432, 434, 435, 437, 439, 440, 442, 444, 445, 447,
	449, 450, 452, 454, 456, 457, 459, 461, 462, 464, 466,
	468, 469, 471, 473, 475, 476, 478, 480, 482, 483, 485,
	487, 489, 491, 492, 494, 496, 498, 500, 501, 503, 505,
	507, 509, 511, 512, 514, 516, 518, 520, 522, 524, 525,
	527, 529, 531, 533, 535, 537, 539, 541, 542, 544, 546,
	548, 550, 552, 554, 556, 558, 560, 562, 564, 566, 568,
	570, 572, 574, 576, 578, 580, 582, 584, 586, 588, 590,
	592, 594, 596, 598, 600, 602, 604, 606, 608, 610, 612,
	614, 616, 618, 621, 623, 625, 627, 629, 631, 633, 635,
	637, 640, 642, 644, 646, 648, 650, 652, 655, 657, 659,
	661, 663, 665, 668, 670, 672, 674, 676, 679, 681, 683,
	685, 688, 690, 692, 694, 697, 699, 701, 703, 706, 708,
	710, 712, 715, 717, 719, 722, 724, 726, 729, 731, 733,
	736, 738, 740, 743, 745, 747, 750, 752, 754, 757, 759,
	762, 764, 766, 769, 771, 774, 776, 778, 781, 783, 786,
	788, 791, 793, 795, 798, 800, 803, 805, 808, 810, 813,
	815, 818, 820, 823, 825, 828, 830, 833, 835, 838, 841,
	843, 846, 848, 851, 853, 856, 859, 861, 864, 866, 869,
	872, 874, 877, 879, 882, 885, 887, 890, 893, 895, 898,
	901, 903, 906, 909, 911, 914, 917, 919, 922, 925, 927,
	930, 933, 936, 938, 941, 944, 947, 949, 952, 955, 958,
	960, 963, 966, 969, 972, 974, 977, 980, 983, 986, 989,
	991, 994, 997, 1000, 1003, 1006, 1009, 1011, 1014, 1017, 1020,
	1023,
};

static const u16 xgamma10_30[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9,
	9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
	10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13,
	14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15,
	15, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17,
	18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 20,
	20, 20, 20, 21, 21, 21, 21, 21, 22, 22, 22,
	22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25,
	25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28,
	28, 28, 28, 29, 29, 29, 30, 30, 30, 30, 31,
	31, 31, 32, 32, 32, 33, 33, 33, 33, 34, 34,
	34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38,
	38, 38, 39, 39, 39, 40, 40, 40, 41, 41, 41,
	42, 42, 42, 43, 43, 43, 44, 44, 45, 45, 45,
	46, 46, 46, 47, 47, 48, 48, 48, 49, 49, 50,
	50, 50, 51, 51, 52, 52, 52, 53, 53, 54, 54,
	55, 55, 55, 56, 56, 57, 57, 58, 58, 58, 59,
	59, 60, 60, 61, 61, 62, 62, 63, 63, 63, 64,
	64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69,
	70, 70, 71, 71, 72, 72, 73, 73, 74, 74, 75,
	75, 76, 77, 77, 78, 78, 79, 79, 80, 80, 81,
	81, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87,
	88, 88, 89, 89, 90, 91, 91, 92, 92, 93, 94,
	94, 95, 95, 96, 97, 97, 98, 99, 99, 100, 100,
	101, 102, 102, 103, 104, 104, 105, 106, 106, 107, 108,
	108, 109, 110, 110, 111, 112, 112, 113, 114, 114, 115,
	116, 117, 117, 118, 119, 119, 120, 121, 122, 122, 123,
	124, 125, 125, 126, 127, 128, 128, 129, 130, 131, 131,
	132, 133, 134, 134, 135, 136, 137, 137, 138, 139, 140,
	141, 141, 142, 143, 144, 145, 146, 146, 147, 148, 149,
	150, 150, 151, 152, 153, 154, 155, 156, 156, 157, 158,
	159, 160, 161, 162, 162, 163, 164, 165, 166, 167, 168,
	169, 170, 171, 171, 172, 173, 174, 175, 176, 177, 178,
	179, 180, 181, 182, 183, 184, 185, 185, 186, 187, 188,
	189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
	200, 201, 202, 203, 204, 205, 206, 207, 208, 210, 211,
	212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222,
	223, 224, 226, 227, 228, 229, 230, 231, 232, 233, 234,
	236, 237, 238, 239, 240, 241, 242, 244, 245, 246, 247,
	248, 249, 250, 252, 253, 254, 255, 256, 258, 259, 260,
	261, 262, 264, 265, 266, 267, 269, 270, 271, 272, 273,
	275, 276, 277, 278, 280, 281, 282, 284, 285, 286, 287,
	289, 290, 291, 293, 294, 295, 296, 298, 299, 300, 302,
	303, 304, 306, 307, 308, 310, 311, 313, 314, 315, 317,
	318, 319, 321, 322, 324, 325, 326, 328, 329, 331, 332,
	333, 335, 336, 338, 339, 341, 342, 343, 345, 346, 348,
	349, 351, 352, 354, 355, 357, 358, 360, 361, 363, 364,
	366, 367, 369, 370, 372, 373, 375, 376, 378, 379, 381,
	383, 384, 386, 387, 389, 390, 392, 394, 395, 397, 398,
	400, 402, 403, 405, 406, 408, 410, 411, 413, 415, 416,
	418, 419, 421, 423, 424, 426, 428, 429, 431, 433, 435,
	436, 438, 440, 441, 443, 445, 447, 448, 450, 452, 453,
	455, 457, 459, 460, 462, 464, 466, 468, 469, 471, 473,
	475, 477, 478, 480, 482, 484, 486, 487, 489, 491, 493,
	495, 497, 498, 500, 502, 504, 506, 508, 510, 512, 513,
	515, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535,
	537, 539, 540, 542, 544, 546, 548, 550, 552, 554, 556,
	558, 560, 562, 564, 566, 568, 570, 572, 574, 577, 579,
	581, 583, 585, 587, 589, 591, 593, 595, 597, 599, 601,
	604, 606, 608, 610, 612, 614, 616, 618, 621, 623, 625,
	627, 629, 631, 634, 636, 638, 640, 642, 645, 647, 649,
	651, 653, 656, 658, 660, 662, 665, 667, 669, 671, 674,
	676, 678, 680, 683, 685, 687, 690, 692, 694, 697, 699,
	701, 704, 706, 708, 711, 713, 715, 718, 720, 722, 725,
	727, 730, 732, 734, 737, 739, 742, 744, 746, 749, 751,
	754, 756, 759, 761, 764, 766, 769, 771, 774, 776, 779,
	781, 784, 786, 789, 791, 794, 796, 799, 801, 804, 806,
	809, 812, 814, 817, 819, 822, 824, 827, 830, 832, 835,
	837, 840, 843, 845, 848, 851, 853, 856, 859, 861, 864,
	867, 869, 872, 875, 878, 880, 883, 886, 888, 891, 894,
	897, 899, 902, 905, 908, 910, 913, 916, 919, 922, 924,
	927, 930, 933, 936, 938, 941, 944, 947, 950, 953, 956,
	958, 961, 964, 967, 970, 973, 976, 979, 982, 984, 987,
	990, 993, 996, 999, 1002, 1005, 1008, 1011, 1014, 1017, 1020,
	1023,
};

static const u16 xgamma10_31[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9,
	9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
	10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
	20, 20, 20, 20, 21, 21, 21, 21, 21, 22, 22,
	22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25,
	25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
	28, 28, 28, 28, 29, 29, 29, 30, 30, 30, 30,
	31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 34,
	34, 34, 35, 35, 35, 36, 36, 36, 36, 37, 37,
	37, 38, 38, 38, 39, 39, 39, 40, 40, 41, 41,
	41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 45,
	45, 46, 46, 46, 47, 47, 47, 48, 48, 49, 49,
	49, 50, 50, 51, 51, 51, 52, 52, 53, 53, 54,
	54, 54, 55, 55, 56, 56, 57, 57, 57, 58, 58,
	59, 59, 60, 60, 61, 61, 61, 62, 62, 63, 63,
	64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69,
	69, 70, 70, 71, 71, 72, 72, 73, 73, 74, 74,
	75, 75, 76, 76, 77, 77, 78, 79, 79, 80, 80,
	81, 81, 82, 82, 83, 84, 84, 85, 85, 86, 86,
	87, 88, 88, 89, 89, 90, 91, 91, 92, 92, 93,
	94, 94, 95, 95, 96, 97, 97, 98, 99, 99, 100,
	101, 101, 102, 102, 103, 104, 104, 105, 106, 106, 107,
	108, 108, 109, 110, 111, 111, 112, 113, 113, 114, 115,
	115, 116, 117, 118, 118, 119, 120, 120, 121, 122, 123,
	123, 124, 125, 126, 126, 127, 128, 129, 129, 130, 131,
	132, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140,
	140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149,
	149, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158,
	159, 160, 161, 162, 162, 163, 164, 165, 166, 167, 168,
	169, 170, 171, 171, 172, 173, 174, 175, 176, 177, 178,
	179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
	201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
	212, 213, 214, 216, 217, 218, 219, 220, 221, 222, 223,
	224, 225, 227, 228, 229, 230, 231, 232, 233, 234, 236,
	237, 238, 239, 240, 241, 243, 244, 245, 246, 247, 248,
	250, 251, 252, 253, 254, 256, 257, 258, 259, 260, 262,
	263, 264, 265, 267, 268, 269, 270, 272, 273, 274, 275,
	277, 278, 279, 281, 282, 283, 285, 286, 287, 288, 290,
	291, 292, 294, 295, 296, 298, 299, 300, 302, 303, 305,
	306, 307, 309, 310, 311, 313, 314, 316, 317, 318, 320,
	321, 323, 324, 325, 327, 328, 330, 331, 333, 334, 336,
	337, 338, 340, 341, 343, 344, 346, 347, 349, 350, 352,
	353, 355, 356, 358, 359, 361, 362, 364, 366, 367, 369,
	370, 372, 373, 375, 376, 378, 380, 381, 383, 384, 386,
	388, 389, 391, 392, 394, 396, 397, 399, 401, 402, 404,
	406, 407, 409, 411, 412, 414, 416, 417, 419, 421, 422,
	424, 426, 427, 429, 431, 433, 434, 436, 438, 440, 441,
	443, 445, 447, 448, 450, 452, 454, 456, 457, 459, 461,
	463, 465, 466, 468, 470, 472, 474, 476, 477, 479, 481,
	483, 485, 487, 489, 490, 492, 494, 496, 498, 500, 502,
	504, 506, 508, 510, 511, 513, 515, 517, 519, 521, 523,
	525, 527, 529, 531, 533, 535, 537, 539, 541, 543, 545,
	547, 549, 551, 553, 555, 557, 559, 561, 564, 566, 568,
	570, 572, 574, 576, 578, 580, 582, 584, 587, 589, 591,
	593, 595, 597, 599, 602, 604, 606, 608, 610, 613, 615,
	617, 619, 621, 624, 626, 628, 630, 632, 635, 637, 639,
	641, 644, 646, 648, 651, 653, 655, 657, 660, 662, 664,
	667, 669, 671, 674, 676, 678, 681, 683, 685, 688, 690,
	692, 695, 697, 700, 702, 704, 707, 709, 712, 714, 717,
	719, 721, 724, 726, 729, 731, 734, 736, 739, 741, 744,
	746, 749, 751, 754, 756, 759, 761, 764, 766, 769, 772,
	774, 777, 779, 782, 784, 787, 790, 792, 795, 797, 800,
	803, 805, 808, 811, 813, 816, 819, 821, 824, 827, 829,
	832, 835, 837, 840, 843, 845, 848, 851, 854, 856, 859,
	862, 865, 867, 870, 873, 876, 879, 881, 884, 887, 890,
	893, 895, 898, 901, 904, 907, 910, 913, 915, 918, 921,
	924, 927, 930, 933, 936, 939, 942, 945, 947, 950, 953,
	956, 959, 962, 965, 968, 971, 974, 977, 980, 983, 986,
	989, 992, 995, 998, 1001, 1005, 1008, 1011, 1014, 1017, 1020,
	1023,
};

static const u16 xgamma10_32[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10,
	10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 15, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
	20, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22,
	22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24,
	25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27,
	27, 28, 28, 28, 28, 29, 29, 29, 30, 30, 30,
	30, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33,
	34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37,
	37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 41,
	41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44,
	45, 45, 46, 46, 46, 47, 47, 48, 48, 48, 49,
	49, 49, 50, 50, 51, 51, 51, 52, 52, 53, 53,
	54, 54, 54, 55, 55, 56, 56, 57, 57, 57, 58,
	58, 59, 59, 60, 60, 61, 61, 62, 62, 62, 63,
	63, 64, 64, 65, 65, 66, 66, 67, 67, 68, 68,
	69, 69, 70, 70, 71, 71, 72, 72, 73, 73, 74,
	74, 75, 75, 76, 77, 77, 78, 78, 79, 79, 80,
	80, 81, 81, 82, 83, 83, 84, 84, 85, 85, 86,
	87, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93,
	93, 94, 95, 95, 96, 96, 97, 98, 98, 99, 100,
	100, 101, 102, 102, 103, 104, 104, 105, 106, 106, 107,
	108, 108, 109, 110, 110, 111, 112, 112, 113, 114, 114,
	115, 116, 117, 117, 118, 119, 120, 120, 121, 122, 122,
	123, 124, 125, 125, 126, 127, 128, 129, 129, 130, 131,
	132, 132, 133, 134, 135, 136, 136, 137, 138, 139, 140,
	140, 141, 142, 143, 144, 145, 145, 146, 147, 148, 149,
	150, 150, 151, 152, 153, 154, 155, 156, 157, 157, 158,
	159, 160, 161, 162, 163, 164, 165, 166, 166, 167, 168,
	169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
	180, 181, 182, 183, 184, 185, 186, 186, 187, 188, 189,
	190, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
	202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
	214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225,
	226, 227, 228, 229, 230, 231, 233, 234, 235, 236, 237,
	238, 240, 241, 242, 243, 244, 246, 247, 248, 249, 250,
	252, 253, 254, 255, 257, 258, 259, 260, 262, 263, 264,
	265, 267, 268, 269, 270, 272, 273, 274, 276, 277, 278,
	280, 281, 282, 283, 285, 286, 287, 289, 290, 291, 293,
	294, 296, 297, 298, 300, 301, 302, 304, 305, 307, 308,
	309, 311, 312, 314, 315, 316, 318, 319, 321, 322, 324,
	325, 327, 328, 330, 331, 332, 334, 335, 337, 338, 340,
	341, 343, 344, 346, 347, 349, 351, 352, 354, 355, 357,
	358, 360, 361, 363, 364, 366, 368, 369, 371, 372, 374,
	376, 377, 379, 380, 382, 384, 385, 387, 389, 390, 392,
	394, 395, 397, 399, 400, 402, 404, 405, 407, 409, 410,
	412, 414, 416, 417, 419, 421, 423, 424, 426, 428, 430,
	431, 433, 435, 437, 438, 440, 442, 444, 446, 447, 449,
	451, 453, 455, 457, 458, 460, 462, 464, 466, 468, 469,
	471, 473, 475, 477, 479, 481, 483, 485, 487, 488, 490,
	492, 494, 496, 498, 500, 502, 504, 506, 508, 510, 512,
	514, 516, 518, 520, 522, 524, 526, 528, 530, 532, 534,
	536, 538, 540, 542, 544, 547, 549, 551, 553, 555, 557,
	559, 561, 563, 565, 568, 570, 572, 574, 576, 578, 581,
	583, 585, 587, 589, 591, 594, 596, 598, 600, 602, 605,
	607, 609, 611, 614, 616, 618, 620, 623, 625, 627, 630,
	632, 634, 636, 639, 641, 643, 646, 648, 650, 653, 655,
	657, 660, 662, 665, 667, 669, 672, 674, 677, 679, 681,
	684, 686, 689, 691, 694, 696, 698, 701, 703, 706, 708,
	711, 713, 716, 718, 721, 723, 726, 728, 731, 734, 736,
	739, 741, 744, 746, 749, 751, 754, 757, 759, 762, 765,
	767, 770, 772, 775, 778, 780, 783, 786, 788, 791, 794,
	796, 799, 802, 804, 807, 810, 813, 815, 818, 821, 824,
	826, 829, 832, 835, 838, 840, 843, 846, 849, 852, 854,
	857, 860, 863, 866, 869, 871, 874, 877, 880, 883, 886,
	889, 892, 895, 897, 900, 903, 906, 909, 912, 915, 918,
	921, 924, 927, 930, 933, 936, 939, 942, 945, 948, 951,
	954, 957, 960, 963, 967, 970, 973, 976, 979, 982, 985,
	988, 991, 994, 998, 1001, 1004, 1007, 1010, 1013, 1017, 1020,
	1023,
};

static const u16 xgamma10_33[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 15, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 17, 18, 18, 18, 18, 18, 19, 19, 19, 19,
	19, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22,
	22, 22, 22, 23, 23, 23, 23, 23, 24, 24, 24,
	24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27,
	27, 28, 28, 28, 28, 29, 29, 29, 29, 30, 30,
	30, 31, 31, 31, 31, 32, 32, 32, 33, 33, 33,
	33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37,
	37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40,
	41, 41, 41, 42, 42, 42, 43, 43, 44, 44, 44,
	45, 45, 45, 46, 46, 47, 47, 47, 48, 48, 48,
	49, 49, 50, 50, 50, 51, 51, 52, 52, 53, 53,
	53, 54, 54, 55, 55, 55, 56, 56, 57, 57, 58,
	58, 59, 59, 59, 60, 60, 61, 61, 62, 62, 63,
	63, 64, 64, 65, 65, 66, 66, 67, 67, 68, 68,
	69, 69, 70, 70, 71, 71, 72, 72, 73, 73, 74,
	74, 75, 75, 76, 76, 77, 77, 78, 79, 79, 80,
	80, 81, 81, 82, 82, 83, 84, 84, 85, 85, 86,
	87, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93,
	93, 94, 94, 95, 96, 96, 97, 98, 98, 99, 100,
	100, 101, 102, 102, 103, 104, 104, 105, 106, 106, 107,
	108, 108, 109, 110, 110, 111, 112, 112, 113, 114, 115,
	115, 116, 117, 118, 118, 119, 120, 120, 121, 122, 123,
	123, 124, 125, 126, 127, 127, 128, 129, 130, 130, 131,
	132, 133, 134, 134, 135, 136, 137, 138, 138, 139, 140,
	141, 142, 143, 143, 144, 145, 146, 147, 148, 148, 149,
	150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159,
	160, 161, 162, 163, 164, 165, 165, 166, 167, 168, 169,
	170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
	181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
	192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202,
	203, 204, 206, 207, 208, 209, 210, 211, 212, 213, 214,
	215, 216, 218, 219, 220, 221, 222, 223, 224, 226, 227,
	228, 229, 230, 231, 233, 234, 235, 236, 237, 238, 240,
	241, 242, 243, 245, 246, 247, 248, 249, 251, 252, 253,
	254, 256, 257, 258, 259, 261, 262, 263, 265, 266, 267,
	268, 270, 271, 272, 274, 275, 276, 278, 279, 280, 282,
	283, 284, 286, 287, 288, 290, 291, 292, 294, 295, 297,
	298, 299, 301, 302, 304, 305, 307, 308, 309, 311, 312,
	314, 315, 317, 318, 320, 321, 322, 324, 325, 327, 328,
	330, 331, 333, 334, 336, 337, 339, 341, 342, 344, 345,
	347, 348, 350, 351, 353, 355, 356, 358, 359, 361, 362,
	364, 366, 367, 369, 371, 372, 374, 375, 377, 379, 380,
	382, 384, 385, 387, 389, 390, 392, 394, 395, 397, 399,
	401, 402, 404, 406, 408, 409, 411, 413, 414, 416, 418,
	420, 422, 423, 425, 427, 429, 431, 432, 434, 436, 438,
	440, 441, 443, 445, 447, 449, 451, 453, 454, 456, 458,
	460, 462, 464, 466, 468, 470, 472, 473, 475, 477, 479,
	481, 483, 485, 487, 489, 491, 493, 495, 497, 499, 501,
	503, 505, 507, 509, 511, 513, 515, 517, 519, 521, 523,
	525, 528, 530, 532, 534, 536, 538, 540, 542, 544, 547,
	549, 551, 553, 555, 557, 559, 562, 564, 566, 568, 570,
	573, 575, 577, 579, 581, 584, 586, 588, 590, 593, 595,
	597, 599, 602, 604, 606, 609, 611, 613, 615, 618, 620,
	622, 625, 627, 629, 632, 634, 637, 639, 641, 644, 646,
	648, 651, 653, 656, 658, 661, 663, 665, 668, 670, 673,
	675, 678, 680, 683, 685, 688, 690, 693, 695, 698, 700,
	703, 705, 708, 710, 713, 716, 718, 721, 723, 726, 729,
	731, 734, 736, 739, 742, 744, 747, 750, 752, 755, 758,
	760, 763, 766, 768, 771, 774, 776, 779, 782, 785, 787,
	790, 793, 796, 798, 801, 804, 807, 810, 812, 815, 818,
	821, 824, 827, 829, 832, 835, 838, 841, 844, 847, 850,
	852, 855, 858, 861, 864, 867, 870, 873, 876, 879, 882,
	885, 888, 891, 894, 897, 900, 903, 906, 909, 912, 915,
	918, 921, 924, 927, 930, 933, 937, 940, 943, 946, 949,
	952, 955, 958, 962, 965, 968, 971, 974, 978, 981, 984,
	987, 990, 994, 997, 1000, 1003, 1007, 1010, 1013, 1016, 1020,
	1023,
};

static const u16 xgamma10_34[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9,
	9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10,
	10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12,
	12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 15, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 17, 18, 18, 18, 18, 18, 19, 19, 19, 19,
	19, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22,
	22, 22, 22, 23, 23, 23, 23, 23, 24, 24, 24,
	24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27,
	27, 27, 28, 28, 28, 29, 29, 29, 29, 30, 30,
	30, 30, 31, 31, 31, 32, 32, 32, 33, 33, 33,
	33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37,
	37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40,
	41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44,
	45, 45, 45, 46, 46, 46, 47, 47, 48, 48, 48,
	49, 49, 50, 50, 50, 51, 51, 52, 52, 52, 53,
	53, 54, 54, 55, 55, 55, 56, 56, 57, 57, 58,
	58, 59, 59, 59, 60, 60, 61, 61, 62, 62, 63,
	63, 64, 64, 65, 65, 66, 66, 67, 67, 68, 68,
	69, 69, 70, 70, 71, 71, 72, 72, 73, 73, 74,
	74, 75, 75, 76, 76, 77, 78, 78, 79, 79, 80,
	80, 81, 81, 82, 83, 83, 84, 84, 85, 86, 86,
	87, 87, 88, 88, 89, 90, 90, 91, 92, 92, 93,
	93, 94, 95, 95, 96, 97, 97, 98, 99, 99, 100,
	101, 101, 102, 102, 103, 104, 105, 105, 106, 107, 107,
	108, 109, 109, 110, 111, 111, 112, 113, 114, 114, 115,
	116, 117, 117, 118, 119, 119, 120, 121, 122, 123, 123,
	124, 125, 126, 126, 127, 128, 129, 129, 130, 131, 132,
	133, 133, 134, 135, 136, 137, 138, 138, 139, 140, 141,
	142, 143, 143, 144, 145, 146, 147, 148, 149, 149, 150,
	151, 152, 153, 154, 155, 156, 157, 157, 158, 159, 160,
	161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171,
	172, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
	182, 183, 184, 185, 186, 187, 188, 189, 191, 192, 193,
	194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
	205, 207, 208, 209, 210, 211, 212, 213, 214, 215, 217,
	218, 219, 220, 221, 222, 223, 225, 226, 227, 228, 229,
	231, 232, 233, 234, 235, 237, 238, 239, 240, 241, 243,
	244, 245, 246, 248, 249, 250, 251, 253, 254, 255, 256,
	258, 259, 260, 262, 263, 264, 266, 267, 268, 269, 271,
	272, 273, 275, 276, 278, 279, 280, 282, 283, 284, 286,
	287, 288, 290, 291, 293, 294, 296, 297, 298, 300, 301,
	303, 304, 306, 307, 308, 310, 311, 313, 314, 316, 317,
	319, 320, 322, 323, 325, 326, 328, 329, 331, 332, 334,
	335, 337, 339, 340, 342, 343, 345, 346, 348, 350, 351,
	353, 354, 356, 358, 359, 361, 363, 364, 366, 367, 369,
	371, 372, 374, 376, 377, 379, 381, 383, 384, 386, 388,
	389, 391, 393, 395, 396, 398, 400, 402, 403, 405, 407,
	409, 410, 412, 414, 416, 418, 419, 421, 423, 425, 427,
	429, 430, 432, 434, 436, 438, 440, 442, 443, 445, 447,
	449, 451, 453, 455, 457, 459, 461, 463, 464, 466, 468,
	470, 472, 474, 476, 478, 480, 482, 484, 486, 488, 490,
	492, 494, 496, 498, 500, 503, 505, 507, 509, 511, 513,
	515, 517, 519, 521, 523, 526, 528, 530, 532, 534, 536,
	538, 541, 543, 545, 547, 549, 551, 554, 556, 558, 560,
	563, 565, 567, 569, 572, 574, 576, 578, 581, 583, 585,
	587, 590, 592, 594, 597, 599, 601, 604, 606, 608, 611,
	613, 615, 618, 620, 623, 625, 627, 630, 632, 635, 637,
	640, 642, 644, 647, 649, 652, 654, 657, 659, 662, 664,
	667, 669, 672, 674, 677, 679, 682, 685, 687, 690, 692,
	695, 697, 700, 703, 705, 708, 711, 713, 716, 718, 721,
	724, 726, 729, 732, 734, 737, 740, 743, 745, 748, 751,
	753, 756, 759, 762, 764, 767, 770, 773, 776, 778, 781,
	784, 787, 790, 793, 795, 798, 801, 804, 807, 810, 813,
	815, 818, 821, 824, 827, 830, 833, 836, 839, 842, 845,
	848, 851, 854, 857, 860, 863, 866, 869, 872, 875, 878,
	881, 884, 887, 890, 893, 896, 899, 903, 906, 909, 912,
	915, 918, 921, 925, 928, 931, 934, 937, 940, 944, 947,
	950, 953, 957, 960, 963, 966, 970, 973, 976, 979, 983,
	986, 989, 993, 996, 999, 1003, 1006, 1009, 1013, 1016, 1020,
	1023,
};

static const u16 xgamma10_35[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8,
	8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9,
	9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12,
	12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13,
	13, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15,
	15, 15, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19,
	20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22,
	22, 22, 22, 23, 23, 23, 23, 23, 24, 24, 24,
	24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27,
	27, 27, 28, 28, 28, 29, 29, 29, 29, 30, 30,
	30, 31, 31, 31, 31, 32, 32, 32, 33, 33, 33,
	33, 34, 34, 34, 35, 35, 35, 36, 36, 36, 37,
	37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40,
	41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44,
	45, 45, 45, 46, 46, 47, 47, 47, 48, 48, 48,
	49, 49, 50, 50, 50, 51, 51, 52, 52, 53, 53,
	53, 54, 54, 55, 55, 56, 56, 56, 57, 57, 58,
	58, 59, 59, 60, 60, 60, 61, 61, 62, 62, 63,
	63, 64, 64, 65, 65, 66, 66, 67, 67, 68, 68,
	69, 69, 70, 70, 71, 71, 72, 72, 73, 73, 74,
	75, 75, 76, 76, 77, 77, 78, 78, 79, 79, 80,
	81, 81, 82, 82, 83, 84, 84, 85, 85, 86, 86,
	87, 88, 88, 89, 89, 90, 91, 91, 92, 93, 93,
	94, 95, 95, 96, 96, 97, 98, 98, 99, 100, 100,
	101, 102, 102, 103, 104, 104, 105, 106, 107, 107, 108,
	109, 109, 110, 111, 111, 112, 113, 114, 114, 115, 116,
	117, 117, 118, 119, 120, 120, 121, 122, 123, 123, 124,
	125, 126, 126, 127, 128, 129, 130, 130, 131, 132, 133,
	134, 135, 135, 136, 137, 138, 139, 140, 140, 141, 142,
	143, 144, 145, 146, 146, 147, 148, 149, 150, 151, 152,
	153, 154, 154, 155, 156, 157, 158, 159, 160, 161, 162,
	163, 164, 165, 166, 167, 167, 168, 169, 170, 171, 172,
	173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183,
	184, 185, 186, 188, 189, 190, 191, 192, 193, 194, 195,
	196, 197, 198, 199, 200, 201, 202, 204, 205, 206, 207,
	208, 209, 210, 211, 213, 214, 215, 216, 217, 218, 219,
	221, 222, 223, 224, 225, 227, 228, 229, 230, 231, 233,
	234, 235, 236, 237, 239, 240, 241, 242, 244, 245, 246,
	247, 249, 250, 251, 253, 254, 255, 256, 258, 259, 260,
	262, 263, 264, 266, 267, 268, 270, 271, 272, 274, 275,
	277, 278, 279, 281, 282, 284, 285, 286, 288, 289, 291,
	292, 293, 295, 296, 298, 299, 301, 302, 304, 305, 307,
	308, 310, 311, 313, 314, 316, 317, 319, 320, 322, 323,
	325, 326, 328, 329, 331, 332, 334, 336, 337, 339, 340,
	342, 344, 345, 347, 348, 350, 352, 353, 355, 357, 358,
	360, 362, 363, 365, 367, 368, 370, 372, 373, 375, 377,
	378, 380, 382, 384, 385, 387, 389, 391, 392, 394, 396,
	398, 400, 401, 403, 405, 407, 409, 410, 412, 414, 416,
	418, 420, 421, 423, 425, 427, 429, 431, 433, 435, 436,
	438, 440, 442, 444, 446, 448, 450, 452, 454, 456, 458,
	460, 462, 464, 466, 468, 470, 472, 474, 476, 478, 480,
	482, 484, 486, 488, 490, 492, 494, 496, 498, 500, 503,
	505, 507, 509, 511, 513, 515, 517, 520, 522, 524, 526,
	528, 531, 533, 535, 537, 539, 542, 544, 546, 548, 550,
	553, 555, 557, 560, 562, 564, 566, 569, 571, 573, 576,
	578, 580, 583, 585, 587, 590, 592, 594, 597, 599, 602,
	604, 606, 609, 611, 614, 616, 618, 621, 623, 626, 628,
	631, 633, 636, 638, 641, 643, 646, 648, 651, 653, 656,
	658, 661, 664, 666, 669, 671, 674, 677, 679, 682, 684,
	687, 690, 692, 695, 698, 700, 703, 706, 708, 711, 714,
	716, 719, 722, 725, 727, 730, 733, 736, 738, 741, 744,
	747, 750, 752, 755, 758, 761, 764, 766, 769, 772, 775,
	778, 781, 784, 787, 789, 792, 795, 798, 801, 804, 807,
	810, 813, 816, 819, 822, 825, 828, 831, 834, 837, 840,
	843, 846, 849, 852, 855, 858, 862, 865, 868, 871, 874,
	877, 880, 883, 887, 890, 893, 896, 899, 902, 906, 909,
	912, 915, 919, 922, 925, 928, 932, 935, 938, 941, 945,
	948, 951, 955, 958, 961, 965, 968, 971, 975, 978, 982,
	985, 988, 992, 995, 999, 1002, 1006, 1009, 1013, 1016, 1020,
	1023,
};

static const u16 xgamma10_36[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8,
	8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9,
	9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10,
	10, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12,
	12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13,
	14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15,
	15, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17,
	17, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
	20, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22,
	22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24,
	25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27,
	27, 28, 28, 28, 28, 29, 29, 29, 29, 30, 30,
	30, 31, 31, 31, 31, 32, 32, 32, 33, 33, 33,
	34, 34, 34, 35, 35, 35, 35, 36, 36, 36, 37,
	37, 37, 38, 38, 38, 39, 39, 39, 40, 40, 40,
	41, 41, 41, 42, 42, 43, 43, 43, 44, 44, 44,
	45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 49,
	49, 49, 50, 50, 51, 51, 52, 52, 52, 53, 53,
	54, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58,
	58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63,
	64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69,
	69, 70, 70, 71, 71, 72, 72, 73, 73, 74, 74,
	75, 76, 76, 77, 77, 78, 78, 79, 79, 80, 81,
	81, 82, 82, 83, 83, 84, 85, 85, 86, 86, 87,
	88, 88, 89, 90, 90, 91, 91, 92, 93, 93, 94,
	95, 95, 96, 97, 97, 98, 99, 99, 100, 101, 101,
	102, 103, 103, 104, 105, 105, 106, 107, 107, 108, 109,
	110, 110, 111, 112, 112, 113, 114, 115, 115, 116, 117,
	118, 118, 119, 120, 121, 121, 122, 123, 124, 125, 125,
	126, 127, 128, 129, 129, 130, 131, 132, 133, 133, 134,
	135, 136, 137, 138, 138, 139, 140, 141, 142, 143, 144,
	145, 145, 146, 147, 148, 149, 150, 151, 152, 153, 153,
	154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
	165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
	187, 188, 189, 190, 191, 192, 193, 194, 196, 197, 198,
	199, 200, 201, 202, 203, 204, 205, 207, 208, 209, 210,
	211, 212, 214, 215, 216, 217, 218, 219, 221, 222, 223,
	224, 225, 227, 228, 229, 230, 231, 233, 234, 235, 236,
	238, 239, 240, 241, 243, 244, 245, 247, 248, 249, 250,
	252, 253, 254, 256, 257, 258, 260, 261, 262, 264, 265,
	266, 268, 269, 271, 272, 273, 275, 276, 277, 279, 280,
	282, 283, 285, 286, 287, 289, 290, 292, 293, 295, 296,
	298, 299, 301, 302, 304, 305, 307, 308, 310, 311, 313,
	314, 316, 317, 319, 320, 322, 324, 325, 327, 328, 330,
	331, 333, 335, 336, 338, 339, 341, 343, 344, 346, 348,
	349, 351, 353, 354, 356, 358, 359, 361, 363, 364, 366,
	368, 370, 371, 373, 375, 377, 378, 380, 382, 384, 385,
	387, 389, 391, 393, 394, 396, 398, 400, 402, 403, 405,
	407, 409, 411, 413, 415, 416, 418, 420, 422, 424, 426,
	428, 430, 432, 434, 436, 438, 439, 441, 443, 445, 447,
	449, 451, 453, 455, 457, 459, 461, 463, 465, 467, 470,
	472, 474, 476, 478, 480, 482, 484, 486, 488, 490, 492,
	495, 497, 499, 501, 503, 505, 508, 510, 512, 514, 516,
	518, 521, 523, 525, 527, 530, 532, 534, 536, 539, 541,
	543, 545, 548, 550, 552, 555, 557, 559, 562, 564, 566,
	569, 571, 573, 576, 578, 580, 583, 585, 588, 590, 592,
	595, 597, 600, 602, 605, 607, 610, 612, 615, 617, 620,
	622, 625, 627, 630, 632, 635, 637, 640, 642, 645, 648,
	650, 653, 655, 658, 661, 663, 666, 669, 671, 674, 677,
	679, 682, 685, 687, 690, 693, 695, 698, 701, 704, 706,
	709, 712, 715, 717, 720, 723, 726, 729, 732, 734, 737,
	740, 743, 746, 749, 751, 754, 757, 760, 763, 766, 769,
	772, 775, 778, 781, 784, 787, 790, 793, 796, 799, 802,
	805, 808, 811, 814, 817, 820, 823, 826, 829, 832, 835,
	838, 842, 845, 848, 851, 854, 857, 860, 864, 867, 870,
	873, 876, 880, 883, 886, 889, 893, 896, 899, 903, 906,
	909, 912, 916, 919, 922, 926, 929, 932, 936, 939, 943,
	946, 949, 953, 956, 960, 963, 967, 970, 973, 977, 980,
	984, 987, 991, 994, 998, 1002, 1005, 1009, 1012, 1016, 1019,
	1023,
};

static const u16 xgamma10_37[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
	9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10,
	11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12,
	12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14,
	14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15,
	16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17,
	18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 20,
	20, 20, 20, 20, 21, 21, 21, 21, 21, 22, 22,
	22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 24,
	25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27,
	28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30,
	31, 31, 31, 31, 32, 32, 32, 33, 33, 33, 33,
	34, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37,
	37, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41,
	41, 41, 42, 42, 42, 43, 43, 44, 44, 44, 45,
	45, 45, 46, 46, 47, 47, 47, 48, 48, 49, 49,
	49, 50, 50, 51, 51, 51, 52, 52, 53, 53, 54,
	54, 54, 55, 55, 56, 56, 57, 57, 58, 58, 58,
	59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64,
	64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69,
	70, 70, 71, 71, 72, 72, 73, 73, 74, 75, 75,
	76, 76, 77, 77, 78, 78, 79, 80, 80, 81, 81,
	82, 82, 83, 84, 84, 85, 85, 86, 87, 87, 88,
	89, 89, 90, 90, 91, 92, 92, 93, 94, 94, 95,
	96, 96, 97, 98, 98, 99, 100, 100, 101, 102, 102,
	103, 104, 104, 105, 106, 106, 107, 108, 109, 109, 110,
	111, 112, 112, 113, 114, 114, 115, 116, 117, 118, 118,
	119, 120, 121, 121, 122, 123, 124, 125, 125, 126, 127,
	128, 129, 129, 130, 131, 132, 133, 134, 134, 135, 136,
	137, 138, 139, 139, 140, 141, 142, 143, 144, 145, 146,
	146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156,
	157, 158, 158, 159, 160, 161, 162, 163, 164, 165, 166,
	167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177,
	178, 179, 180, 181, 182, 184, 185, 186, 187, 188, 189,
	190, 191, 192, 193, 194, 195, 197, 198, 199, 200, 201,
	202, 203, 204, 206, 207, 208, 209, 210, 211, 213, 214,
	215, 216, 217, 218, 220, 221, 222, 223, 225, 226, 227,
	228, 229, 231, 232, 233, 234, 236, 237, 238, 240, 241,
	242, 243, 245, 246, 247, 249, 250, 251, 253, 254, 255,
	257, 258, 259, 261, 262, 263, 265, 266, 268, 269, 270,
	272, 273, 275, 276, 277, 279, 280, 282, 283, 285, 286,
	288, 289, 291, 292, 294, 295, 297, 298, 300, 301, 303,
	304, 306, 307, 309, 310, 312, 313, 315, 316, 318, 320,
	321, 323, 324, 326, 328, 329, 331, 332, 334, 336, 337,
	339, 341, 342, 344, 346, 347, 349, 351, 352, 354, 356,
	358, 359, 361, 363, 364, 366, 368, 370, 372, 373, 375,
	377, 379, 380, 382, 384, 386, 388, 389, 391, 393, 395,
	397, 399, 401, 402, 404, 406, 408, 410, 412, 414, 416,
	418, 420, 421, 423, 425, 427, 429, 431, 433, 435, 437,
	439, 441, 443, 445, 447, 449, 451, 453, 455, 457, 459,
	462, 464, 466, 468, 470, 472, 474, 476, 478, 480, 483,
	485, 487, 489, 491, 493, 496, 498, 500, 502, 504, 507,
	509, 511, 513, 515, 518, 520, 522, 524, 527, 529, 531,
	534, 536, 538, 541, 543, 545, 548, 550, 552, 555, 557,
	559, 562, 564, 567, 569, 571, 574, 576, 579, 581, 584,
	586, 589, 591, 593, 596, 598, 601, 603, 606, 609, 611,
	614, 616, 619, 621, 624, 626, 629, 632, 634, 637, 639,
	642, 645, 647, 650, 653, 655, 658, 661, 663, 666, 669,
	672, 674, 677, 680, 682, 685, 688, 691, 694, 696, 699,
	702, 705, 708, 710, 713, 716, 719, 722, 725, 728, 730,
	733, 736, 739, 742, 745, 748, 751, 754, 757, 760, 763,
	766, 769, 772, 775, 778, 781, 784, 787, 790, 793, 796,
	799, 802, 805, 809, 812, 815, 818, 821, 824, 827, 831,
	834, 837, 840, 843, 847, 850, 853, 856, 860, 863, 866,
	869, 873, 876, 879, 883, 886, 889, 893, 896, 899, 903,
	906, 910, 913, 916, 920, 923, 927, 930, 934, 937, 940,
	944, 947, 951, 954, 958, 961, 965, 969, 972, 976, 979,
	983, 986, 990, 994, 997, 1001, 1005, 1008, 1012, 1016, 1019,
	1023,
};

static const u16 xgamma10_38[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9,
	9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11,
	11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12,
	12, 12, 13, 13, 13, 13, 13, 13, 13, 14, 14,
	14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 16,
	16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18,
	18, 18, 18, 18, 19, 19, 19, 19, 19, 20, 20,
	20, 20, 20, 21, 21, 21, 21, 21, 22, 22, 22,
	22, 23, 23, 23, 23, 24, 24, 24, 24, 24, 25,
	25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 28,
	28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 31,
	31, 31, 31, 32, 32, 32, 33, 33, 33, 33, 34,
	34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37,
	38, 38, 38, 39, 39, 39, 40, 40, 40, 41, 41,
	41, 42, 42, 43, 43, 43, 44, 44, 44, 45, 45,
	46, 46, 46, 47, 47, 47, 48, 48, 49, 49, 49,
	50, 50, 51, 51, 52, 52, 52, 53, 53, 54, 54,
	55, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59,
	60, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64,
	65, 65, 66, 66, 67, 67, 68, 68, 69, 69, 70,
	70, 71, 72, 72, 73, 73, 74, 74, 75, 75, 76,
	76, 77, 78, 78, 79, 79, 80, 81, 81, 82, 82,
	83, 83, 84, 85, 85, 86, 86, 87, 88, 88, 89,
	90, 90, 91, 92, 92, 93, 93, 94, 95, 95, 96,
	97, 97, 98, 99, 99, 100, 101, 102, 102, 103, 104,
	104, 105, 106, 106, 107, 108, 109, 109, 110, 111, 112,
	112, 113, 114, 115, 115, 116, 117, 118, 118, 119, 120,
	121, 122, 122, 123, 124, 125, 126, 126, 127, 128, 129,
	130, 130, 131, 132, 133, 134, 135, 136, 136, 137, 138,
	139, 140, 141, 142, 143, 143, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 153, 153, 154, 155, 156, 157, 158,
	159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
	170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
	182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192,
	193, 195, 196, 197, 198, 199, 200, 201, 203, 204, 205,
	206, 207, 208, 210, 211, 212, 213, 214, 216, 217, 218,
	219, 220, 222, 223, 224, 225, 227, 228, 229, 230, 232,
	233, 234, 235, 237, 238, 239, 241, 242, 243, 245, 246,
	247, 249, 250, 251, 253, 254, 255, 257, 258, 259, 261,
	262, 264, 265, 266, 268, 269, 271, 272, 274, 275, 276,
	278, 279, 281, 282, 284, 285, 287, 288, 290, 291, 293,
	294, 296, 297, 299, 300, 302, 303, 305, 307, 308, 310,
	311, 313, 314, 316, 318, 319, 321, 323, 324, 326, 327,
	329, 331, 332, 334, 336, 337, 339, 341, 342, 344, 346,
	348, 349, 351, 353, 354, 356, 358, 360, 361, 363, 365,
	367, 369, 370, 372, 374, 376, 378, 379, 381, 383, 385,
	387, 389, 391, 392, 394, 396, 398, 400, 402, 404, 406,
	408, 410, 412, 413, 415, 417, 419, 421, 423, 425, 427,
	429, 431, 433, 435, 437, 439, 441, 443, 446, 448, 450,
	452, 454, 456, 458, 460, 462, 464, 466, 469, 471, 473,
	475, 477, 479, 482, 484, 486, 488, 490, 493, 495, 497,
	499, 501, 504, 506, 508, 511, 513, 515, 517, 520, 522,
	524, 527, 529, 531, 534, 536, 538, 541, 543, 546, 548,
	550, 553, 555, 558, 560, 562, 565, 567, 570, 572, 575,
	577, 580, 582, 585, 587, 590, 592, 595, 597, 600, 603,
	605, 608, 610, 613, 616, 618, 621, 623, 626, 629, 631,
	634, 637, 639, 642, 645, 648, 650, 653, 656, 658, 661,
	664, 667, 669, 672, 675, 678, 681, 684, 686, 689, 692,
	695, 698, 701, 703, 706, 709, 712, 715, 718, 721, 724,
	727, 730, 733, 736, 739, 742, 745, 748, 751, 754, 757,
	760, 763, 766, 769, 772, 775, 778, 781, 785, 788, 791,
	794, 797, 800, 803, 807, 810, 813, 816, 820, 823, 826,
	829, 832, 836, 839, 842, 846, 849, 852, 856, 859, 862,
	866, 869, 872, 876, 879, 883, 886, 889, 893, 896, 900,
	903, 907, 910, 914, 917, 921, 924, 928, 931, 935, 938,
	942, 945, 949, 953, 956, 960, 964, 967, 971, 974, 978,
	982, 986, 989, 993, 997, 1000, 1004, 1008, 1012, 1015, 1019,
	1023,
};

static const u16 xgamma10_39[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9,
	9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11,
	11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12,
	12, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14,
	14, 14, 14, 15, 15, 15, 15, 15, 15, 16, 16,
	16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18,
	18, 18, 18, 19, 19, 19, 19, 19, 20, 20, 20,
	20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 22,
	23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25,
	25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28,
	28, 28, 29, 29, 29, 29, 30, 30, 30, 31, 31,
	31, 31, 32, 32, 32, 33, 33, 33, 34, 34, 34,
	35, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38,
	38, 38, 39, 39, 39, 40, 40, 41, 41, 41, 42,
	42, 42, 43, 43, 43, 44, 44, 45, 45, 45, 46,
	46, 46, 47, 47, 48, 48, 48, 49, 49, 50, 50,
	51, 51, 51, 52, 52, 53, 53, 53, 54, 54, 55,
	55, 56, 56, 57, 57, 57, 58, 58, 59, 59, 60,
	60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65,
	66, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71,
	71, 72, 73, 73, 74, 74, 75, 75, 76, 76, 77,
	78, 78, 79, 79, 80, 80, 81, 82, 82, 83, 83,
	84, 85, 85, 86, 87, 87, 88, 88, 89, 90, 90,
	91, 92, 92, 93, 94, 94, 95, 96, 96, 97, 98,
	98, 99, 100, 100, 101, 102, 102, 103, 104, 105, 105,
	106, 107, 107, 108, 109, 110, 110, 111, 112, 113, 113,
	114, 115, 116, 116, 117, 118, 119, 120, 120, 121, 122,
	123, 124, 124, 125, 126, 127, 128, 129, 129, 130, 131,
	132, 133, 134, 134, 135, 136, 137, 138, 139, 140, 141,
	141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
	152, 153, 153, 154, 155, 156, 157, 158, 159, 160, 161,
	162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172,
	173, 174, 176, 177, 178, 179, 180, 181, 182, 183, 184,
	185, 186, 187, 188, 190, 191, 192, 193, 194, 195, 196,
	198, 199, 200, 201, 202, 203, 204, 206, 207, 208, 209,
	210, 212, 213, 214, 215, 217, 218, 219, 220, 221, 223,
	224, 225, 227, 228, 229, 230, 232, 233, 234, 236, 237,
	238, 239, 241, 242, 243, 245, 246, 248, 249, 250, 252,
	253, 254, 256, 257, 259, 260, 261, 263, 264, 266, 267,
	269, 270, 271, 273, 274, 276, 277, 279, 280, 282, 283,
	285, 286, 288, 289, 291, 292, 294, 295, 297, 299, 300,
	302, 303, 305, 306, 308, 310, 311, 313, 314, 316, 318,
	319, 321, 323, 324, 326, 328, 329, 331, 333, 334, 336,
	338, 340, 341, 343, 345, 346, 348, 350, 352, 353, 355,
	357, 359, 361, 362, 364, 366, 368, 370, 372, 373, 375,
	377, 379, 381, 383, 385, 386, 388, 390, 392, 394, 396,
	398, 400, 402, 404, 406, 408, 410, 412, 414, 416, 418,
	420, 422, 424, 426, 428, 430, 432, 434, 436, 438, 440,
	442, 444, 446, 448, 451, 453, 455, 457, 459, 461, 463,
	466, 468, 470, 472, 474, 477, 479, 481, 483, 485, 488,
	490, 492, 494, 497, 499, 501, 504, 506, 508, 511, 513,
	515, 518, 520, 522, 525, 527, 529, 532, 534, 537, 539,
	541, 544, 546, 549, 551, 554, 556, 559, 561, 564, 566,
	569, 571, 574, 576, 579, 581, 584, 586, 589, 592, 594,
	597, 599, 602, 605, 607, 610, 613, 615, 618, 621, 623,
	626, 629, 632, 634, 637, 640, 643, 645, 648, 651, 654,
	656, 659, 662, 665, 668, 671, 673, 676, 679, 682, 685,
	688, 691, 694, 697, 700, 702, 705, 708, 711, 714, 717,
	720, 723, 726, 729, 732, 735, 739, 742, 745, 748, 751,
	754, 757, 760, 763, 766, 770, 773, 776, 779, 782, 786,
	789, 792, 795, 798, 802, 805, 808, 811, 815, 818, 821,
	825, 828, 831, 835, 838, 841, 845, 848, 852, 855, 858,
	862, 865, 869, 872, 876, 879, 883, 886, 890, 893, 897,
	900, 904, 907, 911, 914, 918, 922, 925, 929, 933, 936,
	940, 944, 947, 951, 955, 958, 962, 966, 969, 973, 977,
	981, 985, 988, 992, 996, 1000, 1004, 1007, 1011, 1015, 1019,
	1023,
};

static const u16 xgamma10_40[GAMMA10_TABLE_LENGTH] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
	7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10,
	10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
	11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12,
	13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14,
	14, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16,
	16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18,
	18, 18, 19, 19, 19, 19, 19, 20, 20, 20, 20,
	21, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23,
	23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25,
	26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28,
	29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31,
	32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 35,
	35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 38,
	39, 39, 39, 40, 40, 40, 41, 41, 41, 42, 42,
	43, 43, 43, 44, 44, 44, 45, 45, 46, 46, 46,
	47, 47, 48, 48, 48, 49, 49, 50, 50, 50, 51,
	51, 52, 52, 53, 53, 53, 54, 54, 55, 55, 56,
	56, 57, 57, 57, 58, 58, 59, 59, 60, 60, 61,
	61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66,
	67, 67, 68, 68, 69, 69, 70, 70, 71, 72, 72,
	73, 73, 74, 74, 75, 75, 76, 77, 77, 78, 78,
	79, 79, 80, 81, 81, 82, 82, 83, 84, 84, 85,
	85, 86, 87, 87, 88, 89, 89, 90, 91, 91, 92,
	93, 93, 94, 95, 95, 96, 97, 97, 98, 99, 99,
	100, 101, 101, 102, 103, 104, 104, 105, 106, 106, 107,
	108, 109, 109, 110, 111, 112, 112, 113, 114, 115, 116,
	116, 117, 118, 119, 119, 120, 121, 122, 123, 123, 124,
	125, 126, 127, 128, 128, 129, 130, 131, 132, 133, 134,
	134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 143,
	144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154,
	155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165,
	166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176,
	177, 178, 179, 180, 182, 183, 184, 185, 186, 187, 188,
	189, 190, 192, 193, 194, 195, 196, 197, 199, 200, 201,
	202, 203, 204, 206, 207, 208, 209, 210, 212, 213, 214,
	215, 217, 218, 219, 220, 222, 223, 224, 226, 227, 228,
	229, 231, 232, 233, 235, 236, 237, 239, 240, 241, 243,
	244, 245, 247, 248, 250, 251, 252, 254, 255, 257, 258,
	259, 261, 262, 264, 265, 267, 268, 270, 271, 273, 274,
	276, 277, 279, 280, 282, 283, 285, 286, 288, 289, 291,
	292, 294, 296, 297, 299, 300, 302, 304, 305, 307, 308,
	310, 312, 313, 315, 317, 318, 320, 322, 323, 325, 327,
	328, 330, 332, 333, 335, 337, 339, 340, 342, 344, 346,
	348, 349, 351, 353, 355, 357, 358, 360, 362, 364, 366,
	368, 369, 371, 373, 375, 377, 379, 381, 383, 385, 386,
	388, 390, 392, 394, 396, 398, 400, 402, 404, 406, 408,
	410, 412, 414, 416, 418, 420, 422, 424, 426, 429, 431,
	433, 435, 437, 439, 441, 443, 445, 448, 450, 452, 454,
	456, 458, 461, 463, 465, 467, 469, 472, 474, 476, 478,
	481, 483, 485, 488, 490, 492, 495, 497, 499, 501, 504,
	506, 509, 511, 513, 516, 518, 521, 523, 525, 528, 530,
	533, 535, 538, 540, 543, 545, 548, 550, 553, 555, 558,
	560, 563, 565, 568, 570, 573, 576, 578, 581, 583, 586,
	589, 591, 594, 597, 599, 602, 605, 607, 610, 613, 616,
	618, 621, 624, 627, 629, 632, 635, 638, 641, 643, 646,
	649, 652, 655, 658, 660, 663, 666, 669, 672, 675, 678,
	681, 684, 687, 690, 693, 696, 699, 702, 705, 708, 711,
	714, 717, 720, 723, 726, 729, 732, 735, 739, 742, 745,
	748, 751, 754, 758, 761, 764, 767, 770, 774, 777, 780,
	783, 787, 790, 793, 797, 800, 803, 807, 810, 813, 817,
	820, 824, 827, 830, 834, 837, 841, 844, 848, 851, 855,
	858, 862, 865, 869, 872, 876, 879, 883, 886, 890, 894,
	897, 901, 905, 908, 912, 916, 919, 923, 927, 930, 934,
	938, 942, 945, 949, 953, 957, 960, 964, 968, 972, 976,
	980, 984, 987, 991, 995, 999, 1003, 1007, 1011, 1015, 1019,
	1023,
};

static const u16 *xgamma10_curves[GAMMA_CURVE_LENGTH] =  {
	&xgamma10_01[0],
	&xgamma10_02[0],
	&xgamma10_03[0],
	&xgamma10_04[0],
	&xgamma10_05[0],
	&xgamma10_06[0],
	&xgamma10_07[0],
	&xgamma10_08[0],
	&xgamma10_09[0],
	&xgamma10_10[0],
	&xgamma10_11[0],
	&xgamma10_12[0],
	&xgamma10_13[0],
	&xgamma10_14[0],
	&xgamma10_15[0],
	&xgamma10_16[0],
	&xgamma10_17[0],
	&xgamma10_18[0],
	&xgamma10_19[0],
	&xgamma10_20[0],
	&xgamma10_21[0],
	&xgamma10_22[0],
	&xgamma10_23[0],
	&xgamma10_24[0],
	&xgamma10_25[0],
	&xgamma10_26[0],
	&xgamma10_27[0],
	&xgamma10_28[0],
	&xgamma10_29[0],
	&xgamma10_30[0],
	&xgamma10_31[0],
	&xgamma10_32[0],
	&xgamma10_33[0],
	&xgamma10_34[0],
	&xgamma10_35[0],
	&xgamma10_36[0],
	&xgamma10_37[0],
	&xgamma10_38[0],
	&xgamma10_39[0],
	&xgamma10_40[0],
};
#endif /* __XILINX_GAMMA_COEFF_H__ */
