/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright (C) 2022 - 2023, Advanced Micro Devices, Inc.
 */

#ifndef __XILINX_GAMMA_CORRECTION_H__
#define __XILINX_GAMMA_CORRECTION_H__

#define XISP_GAMMA_CURVE_LENGTH		(40)

#define XISP_GAMMA_BPC_8			(6)
#define XISP_GAMMA8_TABLE_LENGTH	BIT(XISP_GAMMA_BPC_8)

static const u32 xgamma8_40[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.1 */
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01000000, 0x01010101, 0x01010101, 0x02020101, 0x02020202, 0x03030303,
	0x04040403, 0x05050504, 0x07070606, 0x09080807, 0x0b0a0a09, 0x0e0d0c0c,
	0x11100f0e, 0x15141312, 0x1a181716, 0x1f1e1c1b, 0x26242221, 0x2e2c2a28,
	0x37353230, 0x423f3c3a, 0x4f4c4845, 0x5e5a5653, 0x706b6763, 0x857f7a75,
	0x9d97908b, 0xb9b2aaa4, 0xd9d1c8c1, 0xfff5ebe2
};

static const u32 xgamma8_39[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.2 */
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x01010100, 0x01010101, 0x01010101,
	0x02020201, 0x02020202, 0x03030302, 0x03030303, 0x04040404, 0x05050504,
	0x06060605, 0x07070706, 0x09080808, 0x0a0a0909, 0x0c0b0b0b, 0x0e0d0d0c,
	0x100f0f0e, 0x12111110, 0x15141313, 0x18171615, 0x1b1a1918, 0x1e1d1c1c,
	0x2221201f, 0x26252423, 0x2b2a2927, 0x302f2d2c, 0x36343331, 0x3c3a3937,
	0x42403f3d, 0x49474644, 0x514f4d4b, 0x59575553, 0x62605e5c, 0x6c6a6765,
	0x7774716f, 0x827f7c79, 0x8e8b8885, 0x9b989491, 0xa9a5a29e, 0xb8b4b0ad,
	0xc8c4c0bc, 0xd9d5d0cc, 0xebe6e2dd, 0xfffaf5f0
};

static const u32 xgamma8_38[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.3 */
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01010100, 0x01010101, 0x01010101, 0x02020202, 0x02020202, 0x03030303,
	0x04040303, 0x05040404, 0x06050505, 0x07060606, 0x08070707, 0x09090808,
	0x0a0a0a09, 0x0c0c0b0b, 0x0e0d0d0c, 0x0f0f0f0e, 0x11111010, 0x14131212,
	0x16151514, 0x18181717, 0x1b1a1a19, 0x1e1d1d1c, 0x2120201f, 0x25242322,
	0x28272625, 0x2c2b2a29, 0x302f2e2d, 0x34333231, 0x39383735, 0x3e3c3b3a,
	0x4342403f, 0x48474544, 0x4e4c4b4a, 0x5452514f, 0x5a595755, 0x615f5d5c,
	0x68666463, 0x6f6d6b6a, 0x77757371, 0x7f7d7b79, 0x87858381, 0x908e8b89,
	0x99979492, 0xa3a09e9b, 0xadaaa8a5, 0xb7b4b2af, 0xc2bfbcba, 0xcdcac7c4,
	0xd9d6d3d0, 0xe5e2dfdc, 0xf1eeebe8, 0xfffbf8f5
};

static const u32 xgamma8_37[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.4 */
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x01010101, 0x01010101, 0x02020201, 0x02020202, 0x03030303,
	0x04040403, 0x05050504, 0x06060605, 0x07070706, 0x09080808, 0x0a0a0909,
	0x0b0b0b0a, 0x0d0d0c0c, 0x0f0e0e0e, 0x1110100f, 0x13121211, 0x15151413,
	0x17171616, 0x1a191918, 0x1d1c1b1b, 0x1f1f1e1d, 0x22222120, 0x25252423,
	0x29282726, 0x2c2b2a2a, 0x302f2e2d, 0x34333231, 0x37363534, 0x3c3b3938,
	0x403f3e3d, 0x44434241, 0x49484745, 0x4e4d4b4a, 0x5352504f, 0x58575554,
	0x5d5c5b59, 0x6362605f, 0x69676664, 0x6f6d6c6a, 0x75737270, 0x7b7a7877,
	0x82807f7d, 0x89878584, 0x908e8c8a, 0x97959391, 0x9e9c9b99, 0xa6a4a2a0,
	0xaeacaaa8, 0xb6b4b2b0, 0xbebcbab8, 0xc7c5c2c0, 0xcfcdcbc9, 0xd8d6d4d2,
	0xe2dfdddb, 0xebe9e6e4, 0xf5f2f0ed, 0xfffcfaf7
};

static const u32 xgamma8_36[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.5 */
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01010101, 0x02010101,
	0x02020202, 0x03030303, 0x04040404, 0x05050505, 0x07060606, 0x08080707,
	0x0a090909, 0x0b0b0b0a, 0x0d0d0c0c, 0x0f0f0e0e, 0x11111010, 0x13131212,
	0x16151414, 0x18171716, 0x1b1a1919, 0x1d1d1c1b, 0x201f1f1e, 0x23222121,
	0x26252424, 0x29282827, 0x2c2c2b2a, 0x302f2e2d, 0x33323231, 0x37363534,
	0x3b3a3938, 0x3f3e3d3c, 0x43424140, 0x47464544, 0x4b4a4948, 0x504f4d4c,
	0x54535251, 0x59585755, 0x5e5d5b5a, 0x6361605f, 0x68666564, 0x6d6c6a69,
	0x7271706e, 0x78767574, 0x7d7c7a79, 0x8381807f, 0x89878684, 0x8f8d8c8a,
	0x95939290, 0x9b999896, 0xa1a09e9c, 0xa8a6a4a3, 0xaeacaba9, 0xb5b3b1b0,
	0xbcbab8b6, 0xc3c1bfbd, 0xcac8c6c4, 0xd1cfcdcb, 0xd8d6d4d3, 0xe0dedcda,
	0xe7e5e3e1, 0xefedebe9, 0xf7f5f3f1, 0xfffdfbf9
};

static const u32 xgamma8_35[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.6 */
	0x00000000, 0x00000000, 0x01010000, 0x02020101, 0x03030202, 0x04040303,
	0x06050504, 0x07070606, 0x09080808, 0x0b0a0a09, 0x0d0c0c0b, 0x0f0e0e0d,
	0x1110100f, 0x13131212, 0x16151414, 0x18181716, 0x1b1a1a19, 0x1e1d1c1c,
	0x21201f1e, 0x24232221, 0x27262524, 0x2a292828, 0x2d2c2c2b, 0x31302f2e,
	0x34333232, 0x38373635, 0x3b3b3a39, 0x3f3e3d3c, 0x43424140, 0x47464544,
	0x4b4a4948, 0x4f4e4d4c, 0x54525150, 0x58575655, 0x5c5b5a59, 0x61605e5d,
	0x65646362, 0x6a696866, 0x6f6e6c6b, 0x74727170, 0x78777675, 0x7d7c7b7a,
	0x8381807f, 0x88868584, 0x8d8c8a89, 0x9291908e, 0x98969594, 0x9d9c9a99,
	0xa3a1a09e, 0xa8a7a5a4, 0xaeacabaa, 0xb4b2b1af, 0xb9b8b7b5, 0xbfbebcbb,
	0xc5c4c2c1, 0xcbcac8c7, 0xd2d0cecd, 0xd8d6d5d3, 0xdedcdbd9, 0xe4e3e1e0,
	0xebe9e8e6, 0xf1f0eeec, 0xf8f6f5f3, 0xfffdfbfa
};

static const u32 xgamma8_34[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.7 */
	0x00000000, 0x01010000, 0x02020201, 0x04040303, 0x06050504, 0x08070706,
	0x0a090908, 0x0c0b0b0a, 0x0e0e0d0d, 0x1110100f, 0x14131212, 0x16161514,
	0x19181817, 0x1c1b1b1a, 0x1f1e1d1d, 0x22212120, 0x25242423, 0x29282726,
	0x2c2b2a29, 0x2f2e2e2d, 0x33323130, 0x36353534, 0x3a393837, 0x3e3d3c3b,
	0x4141403f, 0x45444342, 0x49484746, 0x4d4c4b4a, 0x51504f4e, 0x55545352,
	0x59585756, 0x5e5d5c5b, 0x6261605f, 0x66656463, 0x6b6a6867, 0x6f6e6d6c,
	0x74727170, 0x78777675, 0x7d7c7a79, 0x81807f7e, 0x86858483, 0x8b8a8887,
	0x908e8d8c, 0x94939291, 0x99989796, 0x9e9d9c9b, 0xa3a2a19f, 0xa8a7a6a4,
	0xadacabaa, 0xb2b1b0af, 0xb8b6b5b4, 0xbdbbbab9, 0xc2c1bfbe, 0xc7c6c5c3,
	0xcdcbcac9, 0xd2d1cfce, 0xd7d6d5d3, 0xdddcdad9, 0xe2e1e0de, 0xe8e7e5e4,
	0xeeecebe9, 0xf3f2f0ef, 0xf9f7f6f5, 0xfffdfcfa
};

static const u32 xgamma8_33[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.8 */
	0x00000000, 0x02020101, 0x05040303, 0x07060605, 0x09090808, 0x0c0b0b0a,
	0x0f0e0d0d, 0x12111010, 0x15141313, 0x18171616, 0x1b1a1919, 0x1e1d1d1c,
	0x2221201f, 0x25242322, 0x28282726, 0x2c2b2a29, 0x2f2f2e2d, 0x33323130,
	0x37363534, 0x3a3a3938, 0x3e3d3c3b, 0x4241403f, 0x46454443, 0x4a494847,
	0x4e4d4c4b, 0x5251504f, 0x56555453, 0x5a595857, 0x5e5d5c5b, 0x6261605f,
	0x66656463, 0x6a696867, 0x6e6d6c6b, 0x7372716f, 0x77767574, 0x7b7a7978,
	0x807f7d7c, 0x84838281, 0x88878685, 0x8d8c8b89, 0x91908f8e, 0x96959392,
	0x9a999897, 0x9f9e9d9b, 0xa3a2a1a0, 0xa8a7a6a4, 0xadabaaa9, 0xb1b0afae,
	0xb6b5b4b2, 0xbbb9b8b7, 0xbfbebdbc, 0xc4c3c2c0, 0xc9c8c6c5, 0xcecccbca,
	0xd2d1d0cf, 0xd7d6d5d4, 0xdcdbdad8, 0xe1e0dedd, 0xe6e5e3e2, 0xebe9e8e7,
	0xf0eeedec, 0xf5f3f2f1, 0xfaf8f7f6, 0xfffdfcfb
};

static const u32 xgamma8_32[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 0.9 */
	0x01010000, 0x04030302, 0x07060605, 0x0a0a0908, 0x0e0d0c0b, 0x11100f0f,
	0x15141312, 0x18171615, 0x1c1b1a19, 0x1f1e1d1c, 0x23222120, 0x26262524,
	0x2a292827, 0x2e2d2c2b, 0x3231302f, 0x35343433, 0x39383736, 0x3d3c3b3a,
	0x41403f3e, 0x45444342, 0x49484746, 0x4d4c4b4a, 0x51504f4e, 0x55545352,
	0x59585756, 0x5d5c5b5a, 0x61605f5e, 0x65646362, 0x69686766, 0x6d6c6b6a,
	0x71706f6e, 0x75747372, 0x79787776, 0x7d7c7b7a, 0x81807f7e, 0x86858482,
	0x8a898887, 0x8e8d8c8b, 0x9291908f, 0x96959493, 0x9b9a9897, 0x9f9e9d9c,
	0xa3a2a1a0, 0xa7a6a5a4, 0xacaba9a8, 0xb0afaead, 0xb4b3b2b1, 0xb8b7b6b5,
	0xbdbcbbba, 0xc1c0bfbe, 0xc5c4c3c2, 0xcac9c8c7, 0xcecdcccb, 0xd2d1d0cf,
	0xd7d6d5d4, 0xdbdad9d8, 0xe0dedddc, 0xe4e3e2e1, 0xe8e7e6e5, 0xedecebe9,
	0xf1f0efee, 0xf6f5f3f2, 0xfaf9f8f7, 0xfffdfcfb
};

static const u32 xgamma8_31[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1 */
	0x03010100, 0x07050503, 0x0a0a0808, 0x0f0e0c0c, 0x1311110f, 0x16161513,
	0x1a1a1818, 0x1f1d1c1c, 0x2321211f, 0x26262423, 0x2a2a2828, 0x2f2d2d2b,
	0x3331312f, 0x36363434, 0x3b3a3838, 0x3f3d3d3b, 0x4242413f, 0x46464444,
	0x4b494948, 0x4f4d4d4b, 0x5252504f, 0x56565454, 0x5b595957, 0x5e5d5d5b,
	0x62626060, 0x67666464, 0x6b696967, 0x6e6e6d6b, 0x72727070, 0x77757574,
	0x7b797977, 0x7e7e7c7c, 0x82828080, 0x87858583, 0x8a898987, 0x8e8e8c8c,
	0x93919090, 0x97959593, 0x9a9a9997, 0x9e9e9c9c, 0xa3a1a1a0, 0xa7a5a5a3,
	0xaaaaa8a8, 0xafaeacac, 0xb3b1b1af, 0xb6b5b5b3, 0xbabab8b8, 0xbfbdbcbc,
	0xc3c1c1bf, 0xc6c6c4c3, 0xcacac8c8, 0xcfcdcdcc, 0xd3d1d1cf, 0xd6d6d4d4,
	0xdbdad8d8, 0xdfdddddb, 0xe2e2e1df, 0xe6e6e4e4, 0xebe9e8e8, 0xefededeb,
	0xf2f2f0ef, 0xf6f6f4f4, 0xfbf9f9f8, 0xfffdfdfb
};

static const u32 xgamma8_30[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.1 */
	0x04030100, 0x09080705, 0x0e0d0c0a, 0x1312110f, 0x18161514, 0x1c1b1a19,
	0x211f1e1d, 0x25242322, 0x29282726, 0x2e2d2c2b, 0x3231302f, 0x36353433,
	0x3b393837, 0x3f3e3d3c, 0x43424140, 0x47464544, 0x4b4a4948, 0x4f4e4d4c,
	0x53525150, 0x57565554, 0x5b5a5958, 0x5f5e5d5c, 0x63626160, 0x67666564,
	0x6b6a6968, 0x6f6e6d6c, 0x73727170, 0x77767574, 0x7b7a7978, 0x7f7e7d7c,
	0x83828180, 0x87868584, 0x8b8a8988, 0x8f8e8d8c, 0x9291908f, 0x96959493,
	0x9a999897, 0x9e9d9c9b, 0xa2a1a09f, 0xa5a5a4a3, 0xa9a8a7a6, 0xadacabaa,
	0xb1b0afae, 0xb5b4b3b2, 0xb8b7b6b6, 0xbcbbbab9, 0xc0bfbebd, 0xc4c3c2c1,
	0xc7c6c5c5, 0xcbcac9c8, 0xcfcecdcc, 0xd2d2d1d0, 0xd6d5d4d3, 0xdad9d8d7,
	0xdedddcdb, 0xe1e0dfde, 0xe5e4e3e2, 0xe9e8e7e6, 0xecebeaea, 0xf0efeeed,
	0xf4f3f2f1, 0xf7f6f5f4, 0xfbfaf9f8, 0xfffefdfc
};

static const u32 xgamma8_29[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.2 */
	0x06040200, 0x0c0b0907, 0x12110f0e, 0x18161513, 0x1d1b1a19, 0x22211f1e,
	0x27262423, 0x2c2a2928, 0x302f2e2d, 0x35343331, 0x39383736, 0x3e3d3c3a,
	0x4241403f, 0x47454443, 0x4b4a4948, 0x4f4e4d4c, 0x53525150, 0x57565554,
	0x5b5a5958, 0x605f5e5c, 0x64636261, 0x68676665, 0x6c6b6a69, 0x6f6f6e6d,
	0x73727170, 0x77767574, 0x7b7a7978, 0x7f7e7d7c, 0x83828180, 0x87868584,
	0x8a898988, 0x8e8d8c8b, 0x9291908f, 0x96959493, 0x99989797, 0x9d9c9b9a,
	0xa1a09f9e, 0xa4a3a2a2, 0xa8a7a6a5, 0xacabaaa9, 0xafaeadac, 0xb3b2b1b0,
	0xb6b5b4b4, 0xbab9b8b7, 0xbdbcbcbb, 0xc1c0bfbe, 0xc4c4c3c2, 0xc8c7c6c5,
	0xcbcbcac9, 0xcfcecdcc, 0xd2d1d1d0, 0xd6d5d4d3, 0xd9d8d8d7, 0xdddcdbda,
	0xe0dfdede, 0xe4e3e2e1, 0xe7e6e5e4, 0xeae9e9e8, 0xeeedeceb, 0xf1f0efef,
	0xf4f4f3f2, 0xf8f7f6f5, 0xfbfaf9f9, 0xfffefdfc
};

static const u32 xgamma8_28[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.3 */
	0x08060300, 0x100e0c0a, 0x16151311, 0x1c1b1918, 0x22211f1e, 0x28262523,
	0x2d2c2a29, 0x32312f2e, 0x37363433, 0x3c3a3938, 0x403f3e3d, 0x45444342,
	0x49484746, 0x4e4d4c4b, 0x5251504f, 0x56555453, 0x5b5a5958, 0x5f5e5d5c,
	0x63626160, 0x67666564, 0x6b6a6968, 0x6f6e6d6c, 0x73727170, 0x77767574,
	0x7b7a7978, 0x7e7e7d7c, 0x8281807f, 0x86858483, 0x8a898887, 0x8d8c8c8b,
	0x91908f8e, 0x95949392, 0x98979696, 0x9c9b9a99, 0x9f9f9e9d, 0xa3a2a1a0,
	0xa6a6a5a4, 0xaaa9a8a7, 0xadadacab, 0xb1b0afae, 0xb4b3b3b2, 0xb8b7b6b5,
	0xbbbab9b8, 0xbebebdbc, 0xc2c1c0bf, 0xc5c4c3c3, 0xc8c8c7c6, 0xcccbcac9,
	0xcfcecdcc, 0xd2d1d1d0, 0xd5d5d4d3, 0xd9d8d7d6, 0xdcdbdada, 0xdfdededd,
	0xe2e2e1e0, 0xe6e5e4e3, 0xe9e8e7e6, 0xecebeae9, 0xefeeeded, 0xf2f1f1f0,
	0xf5f4f4f3, 0xf8f8f7f6, 0xfbfbfaf9, 0xfffefdfc
};

static const u32 xgamma8_27[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.4 */
	0x0a070400, 0x13110f0d, 0x1b191715, 0x21201e1c, 0x27262423, 0x2d2c2a29,
	0x3331302f, 0x38373534, 0x3d3c3b39, 0x4241403e, 0x47464543, 0x4c4b4948,
	0x504f4e4d, 0x55545351, 0x59585756, 0x5d5c5b5a, 0x6261605e, 0x66656463,
	0x6a696867, 0x6e6d6c6b, 0x7271706f, 0x76757473, 0x7a797877, 0x7d7d7c7b,
	0x81807f7e, 0x85848382, 0x89888786, 0x8c8b8a8a, 0x908f8e8d, 0x93939291,
	0x97969594, 0x9a9a9998, 0x9e9d9c9b, 0xa1a1a09f, 0xa5a4a3a2, 0xa8a7a7a6,
	0xacabaaa9, 0xafaeadac, 0xb2b1b1b0, 0xb5b5b4b3, 0xb9b8b7b6, 0xbcbbbaba,
	0xbfbebebd, 0xc2c2c1c0, 0xc6c5c4c3, 0xc9c8c7c6, 0xcccbcac9, 0xcfcecdcd,
	0xd2d1d0d0, 0xd5d4d4d3, 0xd8d7d7d6, 0xdbdadad9, 0xdedddddc, 0xe1e0e0df,
	0xe4e3e3e2, 0xe7e6e6e5, 0xeae9e9e8, 0xedececeb, 0xf0efefee, 0xf3f2f2f1,
	0xf6f5f4f4, 0xf9f8f7f7, 0xfcfbfaf9, 0xfffefdfc
};

static const u32 xgamma8_26[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.5 */
	0x0d0a0600, 0x1714120f, 0x1f1d1b19, 0x26242321, 0x2d2b2928, 0x3331302e,
	0x39373634, 0x3e3d3b3a, 0x4342413f, 0x48474645, 0x4d4c4b4a, 0x5251504f,
	0x57565453, 0x5b5a5958, 0x605f5d5c, 0x64636261, 0x68676665, 0x6c6b6a69,
	0x706f6e6d, 0x74737271, 0x78777675, 0x7c7b7a79, 0x807f7e7d, 0x84838281,
	0x87868584, 0x8b8a8988, 0x8e8e8d8c, 0x9291908f, 0x95959493, 0x99989796,
	0x9c9b9b9a, 0xa09f9e9d, 0xa3a2a1a1, 0xa6a6a5a4, 0xaaa9a8a7, 0xadacabaa,
	0xb0afafae, 0xb3b3b2b1, 0xb6b6b5b4, 0xbab9b8b7, 0xbdbcbbba, 0xc0bfbebd,
	0xc3c2c1c1, 0xc6c5c4c4, 0xc9c8c7c7, 0xcccbcaca, 0xcfcecdcd, 0xd2d1d0d0,
	0xd5d4d3d3, 0xd8d7d6d5, 0xdbdad9d8, 0xdddddcdb, 0xe0e0dfde, 0xe3e2e2e1,
	0xe6e5e4e4, 0xe9e8e7e7, 0xebebeae9, 0xeeeeedec, 0xf1f0f0ef, 0xf4f3f2f2,
	0xf6f6f5f4, 0xf9f8f8f7, 0xfcfbfafa, 0xfffefdfc
};

static const u32 xgamma8_25[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.6 */
	0x0f0c0700, 0x1a181512, 0x23211f1d, 0x2b292725, 0x32302e2d, 0x38373533,
	0x3e3d3b3a, 0x44424140, 0x49484745, 0x4e4d4c4b, 0x53525150, 0x58575655,
	0x5d5c5a59, 0x61605f5e, 0x66656362, 0x6a696867, 0x6e6d6c6b, 0x7271706f,
	0x76757473, 0x7a797877, 0x7e7d7c7b, 0x8281807f, 0x85858483, 0x89888786,
	0x8d8c8b8a, 0x908f8e8e, 0x94939291, 0x97969595, 0x9b9a9998, 0x9e9d9c9b,
	0xa1a0a09f, 0xa4a4a3a2, 0xa8a7a6a5, 0xabaaa9a8, 0xaeadacac, 0xb1b0b0af,
	0xb4b3b3b2, 0xb7b7b6b5, 0xbabab9b8, 0xbdbdbcbb, 0xc0c0bfbe, 0xc3c2c2c1,
	0xc6c5c5c4, 0xc9c8c8c7, 0xcccbcaca, 0xcfcecdcd, 0xd2d1d0cf, 0xd4d4d3d2,
	0xd7d6d6d5, 0xdad9d9d8, 0xdddcdbdb, 0xdfdfdedd, 0xe2e1e1e0, 0xe5e4e3e3,
	0xe7e7e6e5, 0xeae9e9e8, 0xedecebeb, 0xefefeeed, 0xf2f1f1f0, 0xf4f4f3f2,
	0xf7f6f6f5, 0xf9f9f8f8, 0xfcfbfbfa, 0xfffefdfd
};

static const u32 xgamma8_24[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.7 */
	0x120e0900, 0x1e1c1916, 0x28252321, 0x302e2c2a, 0x37353332, 0x3d3c3a39,
	0x4442413f, 0x49484645, 0x4f4d4c4b, 0x54535150, 0x59585755, 0x5e5d5b5a,
	0x6261605f, 0x67666564, 0x6b6a6968, 0x706e6d6c, 0x74737271, 0x78777675,
	0x7c7b7a79, 0x7f7f7e7d, 0x83828180, 0x87868584, 0x8b8a8988, 0x8e8d8c8b,
	0x9291908f, 0x95949393, 0x98989796, 0x9c9b9a99, 0x9f9e9d9d, 0xa2a2a1a0,
	0xa6a5a4a3, 0xa9a8a7a6, 0xacabaaaa, 0xafaeadad, 0xb2b1b0b0, 0xb5b4b3b3,
	0xb8b7b6b6, 0xbbbab9b9, 0xbebdbcbc, 0xc1c0bfbe, 0xc3c3c2c1, 0xc6c6c5c4,
	0xc9c8c8c7, 0xcccbcaca, 0xcfcecdcd, 0xd1d1d0cf, 0xd4d3d3d2, 0xd7d6d5d5,
	0xd9d9d8d7, 0xdcdbdbda, 0xdededddd, 0xe1e0e0df, 0xe4e3e2e2, 0xe6e6e5e4,
	0xe9e8e7e7, 0xebebeae9, 0xeeedecec, 0xf0efefee, 0xf3f2f1f1, 0xf5f4f4f3,
	0xf7f7f6f6, 0xfaf9f9f8, 0xfcfcfbfa, 0xfffefdfd
};

static const u32 xgamma8_23[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.8 */
	0x15110b00, 0x221f1c19, 0x2c2a2725, 0x3432302e, 0x3c3a3836, 0x43413f3d,
	0x49474644, 0x4f4d4c4a, 0x54535150, 0x59585755, 0x5e5d5c5b, 0x63626160,
	0x68676564, 0x6c6b6a69, 0x71706e6d, 0x75747372, 0x79787776, 0x7d7c7b7a,
	0x81807f7e, 0x84848382, 0x88878685, 0x8c8b8a89, 0x8f8e8e8d, 0x93929190,
	0x96959594, 0x9a999897, 0x9d9c9b9a, 0xa09f9f9e, 0xa3a3a2a1, 0xa6a6a5a4,
	0xaaa9a8a7, 0xadacabaa, 0xb0afaead, 0xb3b2b1b0, 0xb6b5b4b3, 0xb8b8b7b6,
	0xbbbbbab9, 0xbebdbdbc, 0xc1c0bfbf, 0xc4c3c2c2, 0xc6c6c5c4, 0xc9c8c8c7,
	0xcccbcaca, 0xcececdcc, 0xd1d0d0cf, 0xd4d3d2d2, 0xd6d6d5d4, 0xd9d8d7d7,
	0xdbdbdad9, 0xdedddcdc, 0xe0e0dfde, 0xe3e2e1e1, 0xe5e4e4e3, 0xe7e7e6e6,
	0xeae9e9e8, 0xececebea, 0xefeeeded, 0xf1f0f0ef, 0xf3f3f2f1, 0xf5f5f4f4,
	0xf8f7f7f6, 0xfaf9f9f8, 0xfcfcfbfb, 0xfffefdfd
};

static const u32 xgamma8_22[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 1.9 */
	0x18130d00, 0x2623201c, 0x302e2b29, 0x39373533, 0x413f3d3b, 0x47464442,
	0x4e4c4b49, 0x5452514f, 0x59585655, 0x5e5d5c5b, 0x63626160, 0x68676665,
	0x6d6c6b69, 0x71706f6e, 0x76747372, 0x7a797877, 0x7e7d7c7b, 0x8281807f,
	0x85848483, 0x89888786, 0x8d8c8b8a, 0x908f8f8e, 0x94939291, 0x97969595,
	0x9a9a9998, 0x9e9d9c9b, 0xa1a09f9f, 0xa4a3a3a2, 0xa7a6a6a5, 0xaaa9a9a8,
	0xadacacab, 0xb0afafae, 0xb3b2b2b1, 0xb6b5b5b4, 0xb9b8b7b7, 0xbcbbbab9,
	0xbebebdbc, 0xc1c0c0bf, 0xc4c3c2c2, 0xc6c6c5c4, 0xc9c8c8c7, 0xcccbcaca,
	0xcecdcdcc, 0xd1d0cfcf, 0xd3d3d2d1, 0xd6d5d4d4, 0xd8d7d7d6, 0xdbdad9d9,
	0xdddcdcdb, 0xdfdfdede, 0xe2e1e0e0, 0xe4e3e3e2, 0xe6e6e5e5, 0xe9e8e7e7,
	0xebeaeae9, 0xededeceb, 0xefefeeee, 0xf2f1f0f0, 0xf4f3f3f2, 0xf6f5f5f4,
	0xf8f8f7f6, 0xfafaf9f9, 0xfcfcfbfb, 0xfffefdfd
};

static const u32 xgamma8_21[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2 */
	0x1b160f00, 0x2a27231f, 0x34322f2d, 0x3d3b3937, 0x4543413f, 0x4c4a4947,
	0x52514f4e, 0x58575554, 0x5e5d5b5a, 0x6362615f, 0x68676664, 0x6d6c6b69,
	0x72706f6e, 0x76757473, 0x7a797877, 0x7e7d7c7b, 0x8281807f, 0x86858483,
	0x8a898887, 0x8d8d8c8b, 0x91908f8e, 0x94949392, 0x98979695, 0x9b9a9999,
	0x9e9e9d9c, 0xa2a1a09f, 0xa5a4a3a2, 0xa8a7a6a5, 0xabaaa9a8, 0xaeadacab,
	0xb1b0afae, 0xb3b3b2b1, 0xb6b6b5b4, 0xb9b8b8b7, 0xbcbbbaba, 0xbebebdbc,
	0xc1c0c0bf, 0xc4c3c2c2, 0xc6c6c5c4, 0xc9c8c8c7, 0xcbcbcac9, 0xcecdcdcc,
	0xd0d0cfce, 0xd3d2d2d1, 0xd5d5d4d3, 0xd8d7d6d6, 0xdad9d9d8, 0xdcdcdbda,
	0xdededddd, 0xe1e0e0df, 0xe3e2e2e1, 0xe5e5e4e4, 0xe7e7e6e6, 0xeae9e9e8,
	0xecebebea, 0xeeededec, 0xf0f0efee, 0xf2f2f1f1, 0xf4f4f3f3, 0xf6f6f5f5,
	0xf8f8f7f7, 0xfafaf9f9, 0xfcfcfbfb, 0xfffefdfd
};

static const u32 xgamma8_20[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.1 */
	0x1e191200, 0x2e2a2723, 0x39363331, 0x42403d3b, 0x4a484644, 0x514f4d4b,
	0x57555452, 0x5d5c5a59, 0x6361605e, 0x68676564, 0x6d6c6a69, 0x71706f6e,
	0x76757473, 0x7a797877, 0x7f7d7c7b, 0x83828180, 0x86858584, 0x8a898887,
	0x8e8d8c8b, 0x9191908f, 0x95949392, 0x98979796, 0x9c9b9a99, 0x9f9e9d9c,
	0xa2a1a0a0, 0xa5a4a4a3, 0xa8a7a7a6, 0xabaaaaa9, 0xaeadadac, 0xb1b0afaf,
	0xb4b3b2b2, 0xb6b6b5b4, 0xb9b9b8b7, 0xbcbbbbba, 0xbfbebdbd, 0xc1c0c0bf,
	0xc4c3c2c2, 0xc6c6c5c4, 0xc9c8c7c7, 0xcbcbcac9, 0xcecdcccc, 0xd0cfcfce,
	0xd2d2d1d1, 0xd5d4d3d3, 0xd7d6d6d5, 0xd9d9d8d8, 0xdbdbdada, 0xdedddddc,
	0xe0dfdfde, 0xe2e2e1e0, 0xe4e4e3e3, 0xe6e6e5e5, 0xe9e8e7e7, 0xebeaeae9,
	0xedececeb, 0xefeeeeed, 0xf1f0f0ef, 0xf3f2f2f1, 0xf5f4f4f3, 0xf7f6f6f5,
	0xf9f8f8f7, 0xfbfafaf9, 0xfdfcfcfb, 0xfffefefd
};

static const u32 xgamma8_19[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.2 */
	0x211c1400, 0x312e2a26, 0x3d3a3734, 0x4644413f, 0x4e4c4a48, 0x55535150,
	0x5b5a5857, 0x61605e5d, 0x67666463, 0x6c6b6a68, 0x71706f6d, 0x76757372,
	0x7a797877, 0x7e7d7c7b, 0x83828180, 0x87868584, 0x8a898888, 0x8e8d8c8b,
	0x9291908f, 0x95949393, 0x99989796, 0x9c9b9a99, 0x9f9e9e9d, 0xa2a2a1a0,
	0xa5a5a4a3, 0xa8a8a7a6, 0xababaaa9, 0xaeaeadac, 0xb1b0b0af, 0xb4b3b2b2,
	0xb7b6b5b5, 0xb9b9b8b7, 0xbcbbbbba, 0xbebebdbd, 0xc1c0c0bf, 0xc4c3c2c2,
	0xc6c5c5c4, 0xc8c8c7c7, 0xcbcacac9, 0xcdcdcccb, 0xd0cfcece, 0xd2d1d1d0,
	0xd4d4d3d2, 0xd6d6d5d5, 0xd9d8d8d7, 0xdbdadad9, 0xdddcdcdb, 0xdfdfdede,
	0xe1e1e0e0, 0xe3e3e2e2, 0xe5e5e4e4, 0xe7e7e6e6, 0xe9e9e8e8, 0xebebeaea,
	0xededecec, 0xefefeeee, 0xf1f1f0f0, 0xf3f3f2f2, 0xf5f5f4f4, 0xf7f7f6f6,
	0xf9f9f8f8, 0xfbfafaf9, 0xfdfcfcfb, 0xfffefefd
};

static const u32 xgamma8_18[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.3 */
	0x241e1600, 0x35312e29, 0x413e3b38, 0x4a484543, 0x52504e4c, 0x59575654,
	0x605e5c5b, 0x66646361, 0x6b6a6867, 0x706f6e6c, 0x75747371, 0x7a797776,
	0x7e7d7c7b, 0x8281807f, 0x86858483, 0x8a898887, 0x8e8d8c8b, 0x9291908f,
	0x95949493, 0x99989796, 0x9c9b9a9a, 0x9f9e9e9d, 0xa2a2a1a0, 0xa5a5a4a3,
	0xa8a8a7a6, 0xababaaa9, 0xaeaeadac, 0xb1b0b0af, 0xb4b3b3b2, 0xb7b6b5b5,
	0xb9b9b8b7, 0xbcbbbbba, 0xbebebdbc, 0xc1c0c0bf, 0xc3c3c2c2, 0xc6c5c5c4,
	0xc8c8c7c6, 0xcbcac9c9, 0xcdcccccb, 0xcfcfcecd, 0xd1d1d0d0, 0xd4d3d3d2,
	0xd6d5d5d4, 0xd8d7d7d6, 0xdadad9d9, 0xdcdcdbdb, 0xdededddd, 0xe0e0dfdf,
	0xe2e2e1e1, 0xe4e4e3e3, 0xe6e6e5e5, 0xe8e8e7e7, 0xeaeae9e9, 0xececebeb,
	0xeeeeeded, 0xf0f0efef, 0xf2f1f1f1, 0xf4f3f3f2, 0xf6f5f5f4, 0xf7f7f7f6,
	0xf9f9f8f8, 0xfbfbfafa, 0xfdfcfcfb, 0xfffefefd
};

static const u32 xgamma8_17[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.4 */
	0x28211900, 0x3935312d, 0x44423f3c, 0x4e4c4947, 0x56545250, 0x5d5b5a58,
	0x6462605f, 0x69686765, 0x6f6e6c6b, 0x74737270, 0x79787775, 0x7e7c7b7a,
	0x8281807f, 0x86858483, 0x8a898887, 0x8e8d8c8b, 0x9291908f, 0x95949393,
	0x99989796, 0x9c9b9a99, 0x9f9e9e9d, 0xa2a2a1a0, 0xa5a5a4a3, 0xa8a8a7a6,
	0xababaaa9, 0xaeaeadac, 0xb1b0b0af, 0xb4b3b2b2, 0xb6b6b5b4, 0xb9b8b8b7,
	0xbcbbbaba, 0xbebebdbc, 0xc1c0bfbf, 0xc3c3c2c1, 0xc6c5c4c4, 0xc8c7c7c6,
	0xcacac9c8, 0xcccccbcb, 0xcfcececd, 0xd1d0d0cf, 0xd3d3d2d1, 0xd5d5d4d4,
	0xd7d7d6d6, 0xd9d9d8d8, 0xdcdbdbda, 0xdedddddc, 0xe0dfdfde, 0xe2e1e1e0,
	0xe4e3e3e2, 0xe5e5e5e4, 0xe7e7e6e6, 0xe9e9e8e8, 0xebebeaea, 0xededecec,
	0xefeeeeed, 0xf1f0f0ef, 0xf2f2f2f1, 0xf4f4f3f3, 0xf6f6f5f5, 0xf8f7f7f6,
	0xf9f9f9f8, 0xfbfbfafa, 0xfdfcfcfc, 0xfffefefd
};

static const u32 xgamma8_16[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.5 */
	0x2b241b00, 0x3c383430, 0x4845423f, 0x524f4d4b, 0x5a585654, 0x615f5d5c,
	0x67666463, 0x6d6c6a69, 0x7371706f, 0x78777574, 0x7d7b7a79, 0x81807f7e,
	0x85848382, 0x8a898886, 0x8d8d8c8b, 0x91908f8e, 0x95949392, 0x98989796,
	0x9c9b9a99, 0x9f9e9d9d, 0xa2a1a1a0, 0xa5a5a4a3, 0xa8a8a7a6, 0xababaaa9,
	0xaeadadac, 0xb1b0b0af, 0xb4b3b2b2, 0xb6b6b5b4, 0xb9b8b8b7, 0xbbbbbaba,
	0xbebdbdbc, 0xc0c0bfbf, 0xc3c2c2c1, 0xc5c5c4c3, 0xc8c7c6c6, 0xcac9c9c8,
	0xcccccbca, 0xcececdcd, 0xd0d0cfcf, 0xd3d2d2d1, 0xd5d4d4d3, 0xd7d6d6d5,
	0xd9d8d8d7, 0xdbdadad9, 0xdddcdcdb, 0xdfdededd, 0xe1e0e0df, 0xe3e2e2e1,
	0xe5e4e4e3, 0xe6e6e5e5, 0xe8e8e7e7, 0xeaeae9e9, 0xecebebeb, 0xeeededec,
	0xefefefee, 0xf1f1f0f0, 0xf3f2f2f2, 0xf5f4f4f3, 0xf6f6f5f5, 0xf8f8f7f7,
	0xfaf9f9f8, 0xfbfbfafa, 0xfdfcfcfc, 0xfffefefd
};

static const u32 xgamma8_15[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.6 */
	0x2e271e00, 0x3f3c3833, 0x4c494643, 0x5553514e, 0x5d5b5957, 0x6563615f,
	0x6b696866, 0x716f6e6d, 0x76757472, 0x7b7a7978, 0x807f7e7d, 0x85838281,
	0x89888786, 0x8d8c8b8a, 0x91908f8e, 0x94949392, 0x98979695, 0x9b9b9a99,
	0x9f9e9d9c, 0xa2a1a0a0, 0xa5a4a4a3, 0xa8a7a7a6, 0xabaaaaa9, 0xaeadadac,
	0xb1b0afaf, 0xb3b3b2b1, 0xb6b5b5b4, 0xb9b8b7b7, 0xbbbbbab9, 0xbebdbcbc,
	0xc0c0bfbe, 0xc3c2c1c1, 0xc5c4c4c3, 0xc7c7c6c5, 0xc9c9c8c8, 0xcccbcbca,
	0xcecdcdcc, 0xd0cfcfce, 0xd2d2d1d0, 0xd4d4d3d3, 0xd6d6d5d5, 0xd8d8d7d7,
	0xdadad9d9, 0xdcdcdbdb, 0xdededddd, 0xe0dfdfdf, 0xe2e1e1e0, 0xe4e3e3e2,
	0xe6e5e5e4, 0xe7e7e6e6, 0xe9e9e8e8, 0xebeaeaea, 0xedececeb, 0xeeeeeded,
	0xf0f0efef, 0xf2f1f1f0, 0xf3f3f3f2, 0xf5f5f4f4, 0xf7f6f6f5, 0xf8f8f7f7,
	0xfaf9f9f9, 0xfbfbfbfa, 0xfdfdfcfc, 0xfffefefd
};

static const u32 xgamma8_14[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.7 */
	0x312a2000, 0x433f3b36, 0x4f4c4946, 0x59575452, 0x615f5d5b, 0x68666563,
	0x6f6d6b6a, 0x74737170, 0x7a787776, 0x7f7d7c7b, 0x83828180, 0x88878685,
	0x8c8b8a89, 0x908f8e8d, 0x94939291, 0x97979695, 0x9b9a9998, 0x9e9d9d9c,
	0xa2a1a09f, 0xa5a4a3a2, 0xa8a7a6a5, 0xabaaa9a9, 0xaeadacab, 0xb0b0afae,
	0xb3b2b2b1, 0xb6b5b4b4, 0xb8b8b7b6, 0xbbbabab9, 0xbdbdbcbc, 0xc0bfbfbe,
	0xc2c2c1c0, 0xc4c4c3c3, 0xc7c6c6c5, 0xc9c8c8c7, 0xcbcbcaca, 0xcdcdcccc,
	0xcfcfcece, 0xd2d1d0d0, 0xd4d3d3d2, 0xd6d5d5d4, 0xd8d7d7d6, 0xdad9d9d8,
	0xdbdbdada, 0xdddddcdc, 0xdfdfdede, 0xe1e1e0e0, 0xe3e2e2e1, 0xe5e4e4e3,
	0xe6e6e6e5, 0xe8e8e7e7, 0xeae9e9e9, 0xecebebea, 0xededecec, 0xefeeeeee,
	0xf1f0f0ef, 0xf2f2f1f1, 0xf4f3f3f3, 0xf5f5f5f4, 0xf7f7f6f6, 0xf8f8f8f7,
	0xfafaf9f9, 0xfcfbfbfa, 0xfdfdfcfc, 0xfffefefd
};

static const u32 xgamma8_13[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.8 */
	0x342d2300, 0x46423e39, 0x52504d4a, 0x5c5a5855, 0x6462605e, 0x6b6a6866,
	0x72706f6d, 0x78767573, 0x7d7c7a79, 0x82817f7e, 0x87858483, 0x8b8a8988,
	0x8f8e8d8c, 0x93929190, 0x97969594, 0x9a999898, 0x9e9d9c9b, 0xa1a09f9f,
	0xa4a3a3a2, 0xa7a7a6a5, 0xaaaaa9a8, 0xadacacab, 0xb0afafae, 0xb3b2b1b1,
	0xb5b5b4b3, 0xb8b7b7b6, 0xbabab9b9, 0xbdbcbcbb, 0xbfbfbebe, 0xc2c1c1c0,
	0xc4c3c3c2, 0xc6c6c5c5, 0xc9c8c7c7, 0xcbcacac9, 0xcdcccccb, 0xcfcececd,
	0xd1d0d0cf, 0xd3d2d2d1, 0xd5d4d4d3, 0xd7d6d6d5, 0xd9d8d8d7, 0xdbdadad9,
	0xdddcdcdb, 0xdedededd, 0xe0e0dfdf, 0xe2e2e1e1, 0xe4e3e3e2, 0xe5e5e5e4,
	0xe7e7e6e6, 0xe9e8e8e8, 0xebeaeae9, 0xececebeb, 0xeeededed, 0xefefefee,
	0xf1f1f0f0, 0xf3f2f2f1, 0xf4f4f3f3, 0xf6f5f5f5, 0xf7f7f6f6, 0xf9f8f8f8,
	0xfafaf9f9, 0xfcfbfbfb, 0xfdfdfcfc, 0xfffefefd
};

static const u32 xgamma8_12[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 2.9 */
	0x372f2500, 0x4945413c, 0x5653504d, 0x5f5d5b58, 0x68666462, 0x6f6d6b6a,
	0x75747270, 0x7b797877, 0x807f7d7c, 0x85848381, 0x8a888786, 0x8e8d8c8b,
	0x9291908f, 0x96959493, 0x99999897, 0x9d9c9b9a, 0xa0a09f9e, 0xa4a3a2a1,
	0xa7a6a5a4, 0xaaa9a8a7, 0xadacabaa, 0xafafaead, 0xb2b2b1b0, 0xb5b4b4b3,
	0xb8b7b6b6, 0xbab9b9b8, 0xbdbcbbbb, 0xbfbebebd, 0xc1c1c0c0, 0xc4c3c2c2,
	0xc6c5c5c4, 0xc8c7c7c6, 0xcacac9c9, 0xcccccbcb, 0xcececdcd, 0xd0d0cfcf,
	0xd2d2d1d1, 0xd4d4d3d3, 0xd6d6d5d5, 0xd8d8d7d7, 0xdadad9d9, 0xdcdbdbda,
	0xdedddddc, 0xdfdfdfde, 0xe1e1e0e0, 0xe3e3e2e2, 0xe5e4e4e3, 0xe6e6e5e5,
	0xe8e8e7e7, 0xeae9e9e8, 0xebebeaea, 0xedececec, 0xeeeeeeed, 0xf0f0efef,
	0xf1f1f1f0, 0xf3f3f2f2, 0xf4f4f4f3, 0xf6f6f5f5, 0xf7f7f7f6, 0xf9f9f8f8,
	0xfafafaf9, 0xfcfbfbfb, 0xfdfdfcfc, 0xfffefefd
};

static const u32 xgamma8_11[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3 */
	0x39322800, 0x4c49443f, 0x59565350, 0x63605e5c, 0x6b696765, 0x72706e6d,
	0x78777573, 0x7e7c7b7a, 0x8382807f, 0x88878584, 0x8c8b8a89, 0x91908f8d,
	0x95949392, 0x98979796, 0x9c9b9a99, 0xa09f9e9d, 0xa3a2a1a0, 0xa6a5a4a4,
	0xa9a8a8a7, 0xacababaa, 0xafaeadad, 0xb2b1b0b0, 0xb4b4b3b2, 0xb7b6b6b5,
	0xbab9b8b8, 0xbcbbbbba, 0xbebebdbd, 0xc1c0c0bf, 0xc3c2c2c1, 0xc5c5c4c4,
	0xc7c7c6c6, 0xcac9c9c8, 0xcccbcbca, 0xcecdcdcc, 0xd0cfcfce, 0xd2d1d1d0,
	0xd4d3d3d2, 0xd6d5d5d4, 0xd8d7d7d6, 0xd9d9d8d8, 0xdbdbdada, 0xdddddcdc,
	0xdfdededd, 0xe0e0e0df, 0xe2e2e1e1, 0xe4e3e3e3, 0xe5e5e5e4, 0xe7e7e6e6,
	0xe9e8e8e7, 0xeaeae9e9, 0xecebebeb, 0xedededec, 0xefefeeee, 0xf0f0f0ef,
	0xf2f2f1f1, 0xf3f3f3f2, 0xf5f4f4f4, 0xf6f6f6f5, 0xf8f7f7f7, 0xf9f9f8f8,
	0xfafafaf9, 0xfcfbfbfb, 0xfdfdfcfc, 0xfffefefd
};

static const u32 xgamma8_10[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.1 */
	0x3c352a00, 0x4f4c4742, 0x5c595653, 0x6663615f, 0x6e6c6a68, 0x75737170,
	0x7b7a7876, 0x817f7e7d, 0x86858382, 0x8b898887, 0x8f8e8d8c, 0x93929190,
	0x97969594, 0x9b9a9998, 0x9f9e9d9c, 0xa2a1a09f, 0xa5a4a4a3, 0xa8a8a7a6,
	0xababaaa9, 0xaeaeadac, 0xb1b0b0af, 0xb4b3b2b2, 0xb6b6b5b4, 0xb9b8b8b7,
	0xbbbbbaba, 0xbebdbdbc, 0xc0c0bfbe, 0xc2c2c1c1, 0xc5c4c4c3, 0xc7c6c6c5,
	0xc9c9c8c7, 0xcbcbcaca, 0xcdcdcccc, 0xcfcfcece, 0xd1d1d0d0, 0xd3d3d2d2,
	0xd5d5d4d4, 0xd7d6d6d5, 0xd9d8d8d7, 0xdadadad9, 0xdcdcdbdb, 0xdededddd,
	0xe0dfdfde, 0xe1e1e1e0, 0xe3e3e2e2, 0xe5e4e4e3, 0xe6e6e5e5, 0xe8e7e7e7,
	0xe9e9e9e8, 0xebebeaea, 0xecececeb, 0xeeeeeded, 0xefefefee, 0xf1f0f0f0,
	0xf2f2f2f1, 0xf4f3f3f3, 0xf5f5f4f4, 0xf6f6f6f5, 0xf8f8f7f7, 0xf9f9f9f8,
	0xfbfafafa, 0xfcfcfbfb, 0xfdfdfdfc, 0xfffefefe
};

static const u32 xgamma8_09[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.2 */
	0x3f382d00, 0x524f4a45, 0x5f5c5956, 0x69666462, 0x716f6d6b, 0x78767473,
	0x7e7c7b79, 0x8382817f, 0x89878685, 0x8d8c8b8a, 0x9291908e, 0x96959493,
	0x9a999897, 0x9d9c9c9b, 0xa1a09f9e, 0xa4a3a3a2, 0xa7a7a6a5, 0xabaaa9a8,
	0xadadacab, 0xb0b0afae, 0xb3b2b2b1, 0xb6b5b4b4, 0xb8b8b7b6, 0xbbbabab9,
	0xbdbdbcbb, 0xc0bfbebe, 0xc2c1c1c0, 0xc4c4c3c2, 0xc6c6c5c5, 0xc8c8c7c7,
	0xcbcacac9, 0xcdcccccb, 0xcfcececd, 0xd1d0d0cf, 0xd2d2d2d1, 0xd4d4d3d3,
	0xd6d6d5d5, 0xd8d8d7d7, 0xdad9d9d8, 0xdcdbdbda, 0xdddddcdc, 0xdfdedede,
	0xe1e0e0df, 0xe2e2e1e1, 0xe4e3e3e3, 0xe5e5e5e4, 0xe7e7e6e6, 0xe8e8e8e7,
	0xeaeae9e9, 0xebebebea, 0xededecec, 0xeeeeeeed, 0xf0efefef, 0xf1f1f1f0,
	0xf3f2f2f2, 0xf4f4f3f3, 0xf5f5f5f4, 0xf7f6f6f6, 0xf8f8f7f7, 0xf9f9f9f8,
	0xfbfafafa, 0xfcfcfbfb, 0xfdfdfdfc, 0xfffefefe
};

static const u32 xgamma8_08[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.3 */
	0x423a2f00, 0x55514d48, 0x625f5c59, 0x6c696764, 0x7472706e, 0x7b797775,
	0x817f7e7c, 0x86858382, 0x8b8a8987, 0x908f8e8c, 0x94939291, 0x98979695,
	0x9c9b9a99, 0xa09f9e9d, 0xa3a2a1a1, 0xa6a6a5a4, 0xaaa9a8a7, 0xadacabaa,
	0xafafaead, 0xb2b2b1b0, 0xb5b4b4b3, 0xb8b7b6b6, 0xbab9b9b8, 0xbdbcbbbb,
	0xbfbebebd, 0xc1c1c0c0, 0xc3c3c2c2, 0xc6c5c5c4, 0xc8c7c7c6, 0xcac9c9c8,
	0xcccbcbca, 0xcecdcdcc, 0xd0cfcfce, 0xd2d1d1d0, 0xd4d3d3d2, 0xd6d5d5d4,
	0xd7d7d6d6, 0xd9d9d8d8, 0xdbdadad9, 0xdcdcdcdb, 0xdededddd, 0xe0dfdfdf,
	0xe1e1e1e0, 0xe3e3e2e2, 0xe5e4e4e3, 0xe6e6e5e5, 0xe8e7e7e6, 0xe9e9e8e8,
	0xebeaeae9, 0xececebeb, 0xedededec, 0xefefeeee, 0xf0f0f0ef, 0xf2f1f1f1,
	0xf3f3f2f2, 0xf4f4f4f3, 0xf6f5f5f5, 0xf7f7f6f6, 0xf8f8f8f7, 0xfaf9f9f9,
	0xfbfafafa, 0xfcfcfbfb, 0xfdfdfdfc, 0xfffefefe
};

static const u32 xgamma8_07[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.4 */
	0x453d3100, 0x5854504b, 0x65625f5c, 0x6e6c6a67, 0x76747270, 0x7d7c7a78,
	0x8382807f, 0x89878685, 0x8e8c8b8a, 0x9291908f, 0x97969493, 0x9b9a9998,
	0x9e9d9c9c, 0xa2a1a09f, 0xa5a4a4a3, 0xa9a8a7a6, 0xacabaaa9, 0xafaeadac,
	0xb1b1b0af, 0xb4b3b3b2, 0xb7b6b5b5, 0xb9b9b8b7, 0xbcbbbbba, 0xbebebdbc,
	0xc1c0bfbf, 0xc3c2c2c1, 0xc5c4c4c3, 0xc7c7c6c6, 0xc9c9c8c8, 0xcbcbcaca,
	0xcdcdcccc, 0xcfcfcece, 0xd1d1d0d0, 0xd3d3d2d2, 0xd5d4d4d3, 0xd7d6d6d5,
	0xd8d8d7d7, 0xdadad9d9, 0xdcdbdbdb, 0xdddddddc, 0xdfdfdede, 0xe1e0e0df,
	0xe2e2e1e1, 0xe4e3e3e3, 0xe5e5e5e4, 0xe7e6e6e6, 0xe8e8e8e7, 0xeae9e9e9,
	0xebebeaea, 0xedececec, 0xeeeeeded, 0xefefefee, 0xf1f0f0f0, 0xf2f2f1f1,
	0xf3f3f3f2, 0xf5f4f4f4, 0xf6f6f5f5, 0xf7f7f7f6, 0xf8f8f8f8, 0xfaf9f9f9,
	0xfbfbfafa, 0xfcfcfcfb, 0xfdfdfdfc, 0xfffefefe
};

static const u32 xgamma8_06[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.5 */
	0x473f3400, 0x5b57524d, 0x6765625e, 0x716f6c6a, 0x79777573, 0x807e7c7b,
	0x86848381, 0x8b8a8987, 0x908f8e8c, 0x95949291, 0x99989796, 0x9d9c9b9a,
	0xa1a09f9e, 0xa4a3a2a1, 0xa7a7a6a5, 0xabaaa9a8, 0xaeadacab, 0xb0b0afae,
	0xb3b3b2b1, 0xb6b5b5b4, 0xb9b8b7b7, 0xbbbabab9, 0xbdbdbcbc, 0xc0bfbfbe,
	0xc2c2c1c0, 0xc4c4c3c3, 0xc6c6c5c5, 0xc9c8c8c7, 0xcbcacac9, 0xcdcccccb,
	0xcfcececd, 0xd0d0d0cf, 0xd2d2d1d1, 0xd4d4d3d3, 0xd6d5d5d5, 0xd8d7d7d6,
	0xd9d9d9d8, 0xdbdbdada, 0xdddcdcdb, 0xdedededd, 0xe0dfdfdf, 0xe1e1e1e0,
	0xe3e3e2e2, 0xe4e4e4e3, 0xe6e6e5e5, 0xe7e7e7e6, 0xe9e9e8e8, 0xeaeaeae9,
	0xecebebeb, 0xededecec, 0xeeeeeeed, 0xf0efefef, 0xf1f1f0f0, 0xf2f2f2f1,
	0xf4f3f3f3, 0xf5f5f4f4, 0xf6f6f6f5, 0xf7f7f7f6, 0xf9f8f8f8, 0xfafaf9f9,
	0xfbfbfafa, 0xfcfcfcfb, 0xfdfdfdfc, 0xfffefefe
};

static const u32 xgamma8_05[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.6 */
	0x4a423600, 0x5d595550, 0x6a676461, 0x74716f6d, 0x7b7a7876, 0x82817f7d,
	0x88878584, 0x8e8c8b8a, 0x9291908f, 0x97969594, 0x9b9a9998, 0x9f9e9d9c,
	0xa3a2a1a0, 0xa6a5a4a3, 0xa9a9a8a7, 0xacacabaa, 0xafafaead, 0xb2b2b1b0,
	0xb5b4b4b3, 0xb8b7b6b6, 0xbabab9b8, 0xbdbcbbbb, 0xbfbebebd, 0xc1c1c0c0,
	0xc4c3c2c2, 0xc6c5c5c4, 0xc8c7c7c6, 0xcac9c9c8, 0xcccbcbca, 0xcecdcdcc,
	0xd0cfcfce, 0xd2d1d1d0, 0xd3d3d3d2, 0xd5d5d4d4, 0xd7d7d6d6, 0xd9d8d8d7,
	0xdadad9d9, 0xdcdcdbdb, 0xdedddddc, 0xdfdfdede, 0xe1e0e0e0, 0xe2e2e1e1,
	0xe4e3e3e3, 0xe5e5e4e4, 0xe7e6e6e6, 0xe8e8e7e7, 0xe9e9e9e8, 0xebeaeaea,
	0xecececeb, 0xeeededed, 0xefefeeee, 0xf0f0efef, 0xf1f1f1f0, 0xf3f2f2f2,
	0xf4f4f3f3, 0xf5f5f5f4, 0xf6f6f6f5, 0xf8f7f7f7, 0xf9f8f8f8, 0xfafaf9f9,
	0xfbfbfbfa, 0xfcfcfcfb, 0xfdfdfdfd, 0xfffefefe
};

static const u32 xgamma8_04[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.7 */
	0x4c443900, 0x605c5852, 0x6d6a6764, 0x7674726f, 0x7e7c7a78, 0x85838180,
	0x8a898886, 0x908f8d8c, 0x95939291, 0x99989796, 0x9d9c9b9a, 0xa1a09f9e,
	0xa5a4a3a2, 0xa8a7a6a5, 0xabaaaaa9, 0xaeaeadac, 0xb1b0b0af, 0xb4b3b3b2,
	0xb7b6b5b5, 0xb9b9b8b7, 0xbcbbbbba, 0xbebebdbc, 0xc1c0bfbf, 0xc3c2c2c1,
	0xc5c4c4c3, 0xc7c7c6c5, 0xc9c9c8c8, 0xcbcbcaca, 0xcdcdcccc, 0xcfcfcece,
	0xd1d0d0d0, 0xd3d2d2d1, 0xd4d4d4d3, 0xd6d6d5d5, 0xd8d8d7d7, 0xdad9d9d8,
	0xdbdbdada, 0xdddcdcdc, 0xdedededd, 0xe0e0dfdf, 0xe1e1e1e0, 0xe3e3e2e2,
	0xe4e4e4e3, 0xe6e5e5e5, 0xe7e7e7e6, 0xe9e8e8e8, 0xeaeae9e9, 0xebebebea,
	0xedececec, 0xeeeeeded, 0xefefefee, 0xf1f0f0f0, 0xf2f1f1f1, 0xf3f3f2f2,
	0xf4f4f4f3, 0xf5f5f5f5, 0xf7f6f6f6, 0xf8f7f7f7, 0xf9f9f8f8, 0xfafafaf9,
	0xfbfbfbfa, 0xfcfcfcfb, 0xfdfdfdfd, 0xfffefefe
};

static const u32 xgamma8_03[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.8 */
	0x4f473b00, 0x625f5a55, 0x6f6c6966, 0x78767472, 0x807e7d7b, 0x87858482,
	0x8d8b8a88, 0x92918f8e, 0x97969493, 0x9b9a9998, 0x9f9e9d9c, 0xa3a2a1a0,
	0xa6a6a5a4, 0xaaa9a8a7, 0xadacabab, 0xb0afafae, 0xb3b2b1b1, 0xb6b5b4b4,
	0xb8b8b7b6, 0xbbbabab9, 0xbdbdbcbb, 0xc0bfbebe, 0xc2c1c1c0, 0xc4c4c3c2,
	0xc6c6c5c5, 0xc8c8c7c7, 0xcacac9c9, 0xcccccbcb, 0xcececdcd, 0xd0d0cfcf,
	0xd2d2d1d1, 0xd4d3d3d2, 0xd6d5d5d4, 0xd7d7d6d6, 0xd9d8d8d8, 0xdadadad9,
	0xdcdcdbdb, 0xdedddddc, 0xdfdfdede, 0xe1e0e0e0, 0xe2e2e1e1, 0xe4e3e3e3,
	0xe5e5e4e4, 0xe6e6e6e5, 0xe8e7e7e7, 0xe9e9e9e8, 0xebeaeaea, 0xececebeb,
	0xededecec, 0xeeeeeeed, 0xf0efefef, 0xf1f1f0f0, 0xf2f2f1f1, 0xf3f3f3f2,
	0xf4f4f4f4, 0xf6f5f5f5, 0xf7f7f6f6, 0xf8f8f7f7, 0xf9f9f9f8, 0xfafafaf9,
	0xfbfbfbfa, 0xfcfcfcfc, 0xfdfdfdfd, 0xfffefefe
};

static const u32 xgamma8_02[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 3.9 */
	0x51493d00, 0x65615d57, 0x716f6c68, 0x7b797674, 0x83817f7d, 0x89888684,
	0x8f8e8c8b, 0x94939290, 0x99989695, 0x9d9c9b9a, 0xa1a09f9e, 0xa5a4a3a2,
	0xa8a7a7a6, 0xacabaaa9, 0xafaeadac, 0xb2b1b0af, 0xb5b4b3b2, 0xb7b7b6b5,
	0xbab9b9b8, 0xbcbcbbba, 0xbfbebebd, 0xc1c0c0bf, 0xc3c3c2c2, 0xc5c5c4c4,
	0xc8c7c7c6, 0xcac9c9c8, 0xcccbcbca, 0xcecdcdcc, 0xcfcfcece, 0xd1d1d0d0,
	0xd3d3d2d2, 0xd5d4d4d3, 0xd6d6d6d5, 0xd8d8d7d7, 0xdad9d9d9, 0xdbdbdbda,
	0xdddddcdc, 0xdedededd, 0xe0e0dfdf, 0xe1e1e1e0, 0xe3e2e2e2, 0xe4e4e4e3,
	0xe6e5e5e5, 0xe7e7e6e6, 0xe8e8e8e7, 0xeae9e9e9, 0xebebeaea, 0xecececeb,
	0xeeededed, 0xefeeeeee, 0xf0f0efef, 0xf1f1f1f0, 0xf2f2f2f2, 0xf4f3f3f3,
	0xf5f4f4f4, 0xf6f6f5f5, 0xf7f7f6f6, 0xf8f8f8f7, 0xf9f9f9f8, 0xfafafaf9,
	0xfbfbfbfb, 0xfcfcfcfc, 0xfdfdfdfd, 0xfffefefe
};

static const u32 xgamma8_01[XISP_GAMMA8_TABLE_LENGTH] = {
	/* For Gamma : 4 */
	0x534b3f00, 0x67635f5a, 0x74716e6b, 0x7d7b7976, 0x8583817f, 0x8b8a8886,
	0x91908e8d, 0x96959492, 0x9b9a9897, 0x9f9e9d9c, 0xa3a2a1a0, 0xa7a6a5a4,
	0xaaa9a8a7, 0xadacacab, 0xb0b0afae, 0xb3b3b2b1, 0xb6b5b5b4, 0xb9b8b7b7,
	0xbbbbbab9, 0xbebdbdbc, 0xc0c0bfbe, 0xc2c2c1c1, 0xc5c4c3c3, 0xc7c6c6c5,
	0xc9c8c8c7, 0xcbcacac9, 0xcdcccccb, 0xcfcececd, 0xd0d0d0cf, 0xd2d2d1d1,
	0xd4d4d3d3, 0xd6d5d5d4, 0xd7d7d7d6, 0xd9d9d8d8, 0xdbdadad9, 0xdcdcdbdb,
	0xdedddddd, 0xdfdfdede, 0xe1e0e0e0, 0xe2e2e1e1, 0xe4e3e3e2, 0xe5e5e4e4,
	0xe6e6e6e5, 0xe8e7e7e7, 0xe9e9e8e8, 0xeaeaeae9, 0xebebebeb, 0xedececec,
	0xeeeeeded, 0xefefefee, 0xf0f0f0ef, 0xf2f1f1f1, 0xf3f2f2f2, 0xf4f4f3f3,
	0xf5f5f4f4, 0xf6f6f6f5, 0xf7f7f7f6, 0xf8f8f8f7, 0xf9f9f9f9, 0xfafafafa,
	0xfbfbfbfb, 0xfcfcfcfc, 0xfdfdfdfd, 0xfffefefe
};

static const u32 *xgamma_curves[XISP_GAMMA_CURVE_LENGTH] =  {
	&xgamma8_01[0],
	&xgamma8_02[0],
	&xgamma8_03[0],
	&xgamma8_04[0],
	&xgamma8_05[0],
	&xgamma8_06[0],
	&xgamma8_07[0],
	&xgamma8_08[0],
	&xgamma8_09[0],
	&xgamma8_10[0],
	&xgamma8_11[0],
	&xgamma8_12[0],
	&xgamma8_13[0],
	&xgamma8_14[0],
	&xgamma8_15[0],
	&xgamma8_16[0],
	&xgamma8_17[0],
	&xgamma8_18[0],
	&xgamma8_19[0],
	&xgamma8_20[0],
	&xgamma8_21[0],
	&xgamma8_22[0],
	&xgamma8_23[0],
	&xgamma8_24[0],
	&xgamma8_25[0],
	&xgamma8_26[0],
	&xgamma8_27[0],
	&xgamma8_28[0],
	&xgamma8_29[0],
	&xgamma8_30[0],
	&xgamma8_31[0],
	&xgamma8_32[0],
	&xgamma8_33[0],
	&xgamma8_34[0],
	&xgamma8_35[0],
	&xgamma8_36[0],
	&xgamma8_37[0],
	&xgamma8_38[0],
	&xgamma8_39[0],
	&xgamma8_40[0],
};

#endif /* __XILINX_GAMMA_CORRECTION_H__ */
