// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2018 Xilinx, Inc.
 *
 * Vasileios Bimpikas <vasileios.bimpikas@xilinx.com>
 */
/*-----------------------------------------------------------------------------
 * C Header bank BASE definitions
 *-----------------------------------------------------------------------------
 */
#define ROE_FRAMER_V1_0_CFG_BASE_ADDR 0x0 /* 0 */
#define ROE_FRAMER_V1_0_FRAM_BASE_ADDR 0x2000 /* 8192 */
#define ROE_FRAMER_V1_0_FRAM_DRP_BASE_ADDR 0x4000 /* 16384 */
#define ROE_FRAMER_V1_0_DEFM_BASE_ADDR 0x6000 /* 24576 */
#define ROE_FRAMER_V1_0_DEFM_DRP_BASE_ADDR 0x8000 /* 32768 */
#define ROE_FRAMER_V1_0_ETH_BASE_ADDR 0xa000 /* 40960 */
#define ROE_FRAMER_V1_0_STATS_BASE_ADDR 0xc000 /* 49152 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_cfg
 * with prefix cfg_ @ address 0x0
 *-----------------------------------------------------------------------------
 */
/* Type = roInt */
#define CFG_MAJOR_REVISION_ADDR 0x0 /* 0 */
#define CFG_MAJOR_REVISION_MASK 0xff000000 /* 4278190080 */
#define CFG_MAJOR_REVISION_OFFSET 0x18 /* 24 */
#define CFG_MAJOR_REVISION_WIDTH 0x8 /* 8 */
#define CFG_MAJOR_REVISION_DEFAULT 0x1 /* 1 */

/* Type = roInt */
#define CFG_MINOR_REVISION_ADDR 0x0 /* 0 */
#define CFG_MINOR_REVISION_MASK 0xff0000 /* 16711680 */
#define CFG_MINOR_REVISION_OFFSET 0x10 /* 16 */
#define CFG_MINOR_REVISION_WIDTH 0x8 /* 8 */
#define CFG_MINOR_REVISION_DEFAULT 0x0 /* 0 */

/* Type = roInt */
#define CFG_VERSION_REVISION_ADDR 0x0 /* 0 */
#define CFG_VERSION_REVISION_MASK 0xff00 /* 65280 */
#define CFG_VERSION_REVISION_OFFSET 0x8 /* 8 */
#define CFG_VERSION_REVISION_WIDTH 0x8 /* 8 */
#define CFG_VERSION_REVISION_DEFAULT 0x0 /* 0 */

/* Type = roInt */
#define CFG_INTERNAL_REVISION_ADDR 0x4 /* 4 */
#define CFG_INTERNAL_REVISION_MASK 0xffffffff /* 4294967295 */
#define CFG_INTERNAL_REVISION_OFFSET 0x0 /* 0 */
#define CFG_INTERNAL_REVISION_WIDTH 0x20 /* 32 */
#define CFG_INTERNAL_REVISION_DEFAULT 0x12345678 /* 305419896 */

/* Type = rw */
#define CFG_TIMEOUT_VALUE_ADDR 0x8 /* 8 */
#define CFG_TIMEOUT_VALUE_MASK 0xfff /* 4095 */
#define CFG_TIMEOUT_VALUE_OFFSET 0x0 /* 0 */
#define CFG_TIMEOUT_VALUE_WIDTH 0xc /* 12 */
#define CFG_TIMEOUT_VALUE_DEFAULT 0x80 /* 128 */

/* Type = rw */
#define CFG_USER_RW_OUT_ADDR 0xc /* 12 */
#define CFG_USER_RW_OUT_MASK 0xff /* 255 */
#define CFG_USER_RW_OUT_OFFSET 0x0 /* 0 */
#define CFG_USER_RW_OUT_WIDTH 0x8 /* 8 */
#define CFG_USER_RW_OUT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_USER_RO_IN_ADDR 0xc /* 12 */
#define CFG_USER_RO_IN_MASK 0xff0000 /* 16711680 */
#define CFG_USER_RO_IN_OFFSET 0x10 /* 16 */
#define CFG_USER_RO_IN_WIDTH 0x8 /* 8 */
#define CFG_USER_RO_IN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define CFG_MASTER_INT_ENABLE_ADDR 0x10 /* 16 */
#define CFG_MASTER_INT_ENABLE_MASK 0x1 /* 1 */
#define CFG_MASTER_INT_ENABLE_OFFSET 0x0 /* 0 */
#define CFG_MASTER_INT_ENABLE_WIDTH 0x1 /* 1 */
#define CFG_MASTER_INT_ENABLE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define CFG_FRAM_FIFO_OF_ENABLE_ADDR 0x14 /* 20 */
#define CFG_FRAM_FIFO_OF_ENABLE_MASK 0x1 /* 1 */
#define CFG_FRAM_FIFO_OF_ENABLE_OFFSET 0x0 /* 0 */
#define CFG_FRAM_FIFO_OF_ENABLE_WIDTH 0x1 /* 1 */
#define CFG_FRAM_FIFO_OF_ENABLE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define CFG_FRAM_FIFO_UF_ENABLE_ADDR 0x14 /* 20 */
#define CFG_FRAM_FIFO_UF_ENABLE_MASK 0x2 /* 2 */
#define CFG_FRAM_FIFO_UF_ENABLE_OFFSET 0x1 /* 1 */
#define CFG_FRAM_FIFO_UF_ENABLE_WIDTH 0x1 /* 1 */
#define CFG_FRAM_FIFO_UF_ENABLE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define CFG_AXI_TIMEOUT_ENABLE_ADDR 0x14 /* 20 */
#define CFG_AXI_TIMEOUT_ENABLE_MASK 0x80000000 /* 2147483648 */
#define CFG_AXI_TIMEOUT_ENABLE_OFFSET 0x1f /* 31 */
#define CFG_AXI_TIMEOUT_ENABLE_WIDTH 0x1 /* 1 */
#define CFG_AXI_TIMEOUT_ENABLE_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define CFG_INTERRUPT_STATUS_SAMPLE_ADDR 0x1c /* 28 */
#define CFG_INTERRUPT_STATUS_SAMPLE_MASK 0x1 /* 1 */
#define CFG_INTERRUPT_STATUS_SAMPLE_OFFSET 0x0 /* 0 */
#define CFG_INTERRUPT_STATUS_SAMPLE_WIDTH 0x1 /* 1 */
#define CFG_INTERRUPT_STATUS_SAMPLE_DEFAULT 0x1 /* 1 */

/* Type = roSig */
#define CFG_FRAM_RESET_STATUS_ADDR 0x18 /* 24 */
#define CFG_FRAM_RESET_STATUS_MASK 0x1 /* 1 */
#define CFG_FRAM_RESET_STATUS_OFFSET 0x0 /* 0 */
#define CFG_FRAM_RESET_STATUS_WIDTH 0x1 /* 1 */
#define CFG_FRAM_RESET_STATUS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_DEFM_RESET_STATUS_ADDR 0x18 /* 24 */
#define CFG_DEFM_RESET_STATUS_MASK 0x2 /* 2 */
#define CFG_DEFM_RESET_STATUS_OFFSET 0x1 /* 1 */
#define CFG_DEFM_RESET_STATUS_WIDTH 0x1 /* 1 */
#define CFG_DEFM_RESET_STATUS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_FRAM_ANT_OF_INTERRUPT_ADDR 0x18 /* 24 */
#define CFG_FRAM_ANT_OF_INTERRUPT_MASK 0x100 /* 256 */
#define CFG_FRAM_ANT_OF_INTERRUPT_OFFSET 0x8 /* 8 */
#define CFG_FRAM_ANT_OF_INTERRUPT_WIDTH 0x1 /* 1 */
#define CFG_FRAM_ANT_OF_INTERRUPT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_FRAM_ETH_OF_INTERRUPT_ADDR 0x18 /* 24 */
#define CFG_FRAM_ETH_OF_INTERRUPT_MASK 0x200 /* 512 */
#define CFG_FRAM_ETH_OF_INTERRUPT_OFFSET 0x9 /* 9 */
#define CFG_FRAM_ETH_OF_INTERRUPT_WIDTH 0x1 /* 1 */
#define CFG_FRAM_ETH_OF_INTERRUPT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_FRAM_ANT_UF_INTERRUPT_ADDR 0x18 /* 24 */
#define CFG_FRAM_ANT_UF_INTERRUPT_MASK 0x400 /* 1024 */
#define CFG_FRAM_ANT_UF_INTERRUPT_OFFSET 0xa /* 10 */
#define CFG_FRAM_ANT_UF_INTERRUPT_WIDTH 0x1 /* 1 */
#define CFG_FRAM_ANT_UF_INTERRUPT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_FRAM_ETH_UF_INTERRUPT_ADDR 0x18 /* 24 */
#define CFG_FRAM_ETH_UF_INTERRUPT_MASK 0x800 /* 2048 */
#define CFG_FRAM_ETH_UF_INTERRUPT_OFFSET 0xb /* 11 */
#define CFG_FRAM_ETH_UF_INTERRUPT_WIDTH 0x1 /* 1 */
#define CFG_FRAM_ETH_UF_INTERRUPT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_AXI_TIMEOUT_STATUS_ADDR 0x18 /* 24 */
#define CFG_AXI_TIMEOUT_STATUS_MASK 0x80000000 /* 2147483648 */
#define CFG_AXI_TIMEOUT_STATUS_OFFSET 0x1f /* 31 */
#define CFG_AXI_TIMEOUT_STATUS_WIDTH 0x1 /* 1 */
#define CFG_AXI_TIMEOUT_STATUS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_CONFIG_NO_OF_FRAM_ANTS_ADDR 0x20 /* 32 */
#define CFG_CONFIG_NO_OF_FRAM_ANTS_MASK 0xffff /* 65535 */
#define CFG_CONFIG_NO_OF_FRAM_ANTS_OFFSET 0x0 /* 0 */
#define CFG_CONFIG_NO_OF_FRAM_ANTS_WIDTH 0x10 /* 16 */
#define CFG_CONFIG_NO_OF_FRAM_ANTS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_CONFIG_NO_OF_DEFM_ANTS_ADDR 0x20 /* 32 */
#define CFG_CONFIG_NO_OF_DEFM_ANTS_MASK 0xffff0000 /* 4294901760 */
#define CFG_CONFIG_NO_OF_DEFM_ANTS_OFFSET 0x10 /* 16 */
#define CFG_CONFIG_NO_OF_DEFM_ANTS_WIDTH 0x10 /* 16 */
#define CFG_CONFIG_NO_OF_DEFM_ANTS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_CONFIG_NO_OF_ETH_PORTS_ADDR 0x24 /* 36 */
#define CFG_CONFIG_NO_OF_ETH_PORTS_MASK 0x3ff /* 1023 */
#define CFG_CONFIG_NO_OF_ETH_PORTS_OFFSET 0x0 /* 0 */
#define CFG_CONFIG_NO_OF_ETH_PORTS_WIDTH 0xa /* 10 */
#define CFG_CONFIG_NO_OF_ETH_PORTS_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define CFG_CONFIG_ETH_SPEED_ADDR 0x24 /* 36 */
#define CFG_CONFIG_ETH_SPEED_MASK 0x3ff0000 /* 67043328 */
#define CFG_CONFIG_ETH_SPEED_OFFSET 0x10 /* 16 */
#define CFG_CONFIG_ETH_SPEED_WIDTH 0xa /* 10 */
#define CFG_CONFIG_ETH_SPEED_DEFAULT 0x0 /* 0 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_fram
 * with prefix fram_ @ address 0x2000
 *------------------------------------------------------------------------------
 */
/* Type = rwpdef */
#define FRAM_DISABLE_ADDR 0x2000 /* 8192 */
#define FRAM_DISABLE_MASK 0x1 /* 1 */
#define FRAM_DISABLE_OFFSET 0x0 /* 0 */
#define FRAM_DISABLE_WIDTH 0x1 /* 1 */
#define FRAM_DISABLE_DEFAULT 0x1 /* 1 */

/* Type = roSig */
#define FRAM_READY_ADDR 0x2000 /* 8192 */
#define FRAM_READY_MASK 0x2 /* 2 */
#define FRAM_READY_OFFSET 0x1 /* 1 */
#define FRAM_READY_WIDTH 0x1 /* 1 */
#define FRAM_READY_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define FRAM_FIFO_FULL_INDICATOR_ADDR 0x2004 /* 8196 */
#define FRAM_FIFO_FULL_INDICATOR_MASK 0xffffffff /* 4294967295 */
#define FRAM_FIFO_FULL_INDICATOR_OFFSET 0x0 /* 0 */
#define FRAM_FIFO_FULL_INDICATOR_WIDTH 0x20 /* 32 */
#define FRAM_FIFO_FULL_INDICATOR_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_SN_DATA_LOW_CNT_MIN_ADDR 0x2020 /* 8224 */
#define FRAM_SN_DATA_LOW_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_LOW_CNT_MIN_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_LOW_CNT_MIN_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_LOW_CNT_MIN_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_SN_DATA_LOW_CNT_MAX_ADDR 0x2024 /* 8228 */
#define FRAM_SN_DATA_LOW_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_LOW_CNT_MAX_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_LOW_CNT_MAX_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_LOW_CNT_MAX_DEFAULT 0x78 /* 120 */

/* Type = rw */
#define FRAM_SN_DATA_LOW_CNT_INITVAL_ADDR 0x2028 /* 8232 */
#define FRAM_SN_DATA_LOW_CNT_INITVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_LOW_CNT_INITVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_LOW_CNT_INITVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_LOW_CNT_INITVAL_DEFAULT 0x75 /* 117 */

/* Type = rw */
#define FRAM_SN_DATA_LOW_CNT_INCVAL_ADDR 0x202c /* 8236 */
#define FRAM_SN_DATA_LOW_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_LOW_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_LOW_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_LOW_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_SN_DATA_HIGH_CNT_MIN_ADDR 0x2030 /* 8240 */
#define FRAM_SN_DATA_HIGH_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_HIGH_CNT_MIN_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_HIGH_CNT_MIN_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_HIGH_CNT_MIN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_SN_DATA_HIGH_CNT_MAX_ADDR 0x2034 /* 8244 */
#define FRAM_SN_DATA_HIGH_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_HIGH_CNT_MAX_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_HIGH_CNT_MAX_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_HIGH_CNT_MAX_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define FRAM_SN_DATA_HIGH_CNT_INITVAL_ADDR 0x2038 /* 8248 */
#define FRAM_SN_DATA_HIGH_CNT_INITVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_HIGH_CNT_INITVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_HIGH_CNT_INITVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_HIGH_CNT_INITVAL_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define FRAM_SN_DATA_HIGH_CNT_INCVAL_ADDR 0x203c /* 8252 */
#define FRAM_SN_DATA_HIGH_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_DATA_HIGH_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_DATA_HIGH_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_DATA_HIGH_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_SN_CTRL_LOW_CNT_MIN_ADDR 0x2050 /* 8272 */
#define FRAM_SN_CTRL_LOW_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_LOW_CNT_MIN_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_LOW_CNT_MIN_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_LOW_CNT_MIN_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_SN_CTRL_LOW_CNT_MAX_ADDR 0x2054 /* 8276 */
#define FRAM_SN_CTRL_LOW_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_LOW_CNT_MAX_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_LOW_CNT_MAX_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_LOW_CNT_MAX_DEFAULT 0x78 /* 120 */

/* Type = rw */
#define FRAM_SN_CTRL_LOW_CNT_INITVAL_ADDR 0x2058 /* 8280 */
#define FRAM_SN_CTRL_LOW_CNT_INITVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_LOW_CNT_INITVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_LOW_CNT_INITVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_LOW_CNT_INITVAL_DEFAULT 0x75 /* 117 */

/* Type = rw */
#define FRAM_SN_CTRL_LOW_CNT_INCVAL_ADDR 0x205c /* 8284 */
#define FRAM_SN_CTRL_LOW_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_LOW_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_LOW_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_LOW_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_SN_CTRL_HIGH_CNT_MIN_ADDR 0x2060 /* 8288 */
#define FRAM_SN_CTRL_HIGH_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_HIGH_CNT_MIN_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_HIGH_CNT_MIN_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_HIGH_CNT_MIN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_SN_CTRL_HIGH_CNT_MAX_ADDR 0x2064 /* 8292 */
#define FRAM_SN_CTRL_HIGH_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_HIGH_CNT_MAX_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_HIGH_CNT_MAX_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_HIGH_CNT_MAX_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define FRAM_SN_CTRL_HIGH_CNT_INITVAL_ADDR 0x2068 /* 8296 */
#define FRAM_SN_CTRL_HIGH_CNT_INITVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_HIGH_CNT_INITVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_HIGH_CNT_INITVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_HIGH_CNT_INITVAL_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define FRAM_SN_CTRL_HIGH_CNT_INCVAL_ADDR 0x206c /* 8300 */
#define FRAM_SN_CTRL_HIGH_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define FRAM_SN_CTRL_HIGH_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define FRAM_SN_CTRL_HIGH_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define FRAM_SN_CTRL_HIGH_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define FRAM_PROTOCOL_DEFINITION_ADDR 0x2200 /* 8704 */
#define FRAM_PROTOCOL_DEFINITION_MASK 0xf /* 15 */
#define FRAM_PROTOCOL_DEFINITION_OFFSET 0x0 /* 0 */
#define FRAM_PROTOCOL_DEFINITION_WIDTH 0x4 /* 4 */
#define FRAM_PROTOCOL_DEFINITION_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_GEN_VLAN_TAG_ADDR 0x2200 /* 8704 */
#define FRAM_GEN_VLAN_TAG_MASK 0x10 /* 16 */
#define FRAM_GEN_VLAN_TAG_OFFSET 0x4 /* 4 */
#define FRAM_GEN_VLAN_TAG_WIDTH 0x1 /* 1 */
#define FRAM_GEN_VLAN_TAG_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_SEL_IPV_ADDRESS_TYPE_ADDR 0x2200 /* 8704 */
#define FRAM_SEL_IPV_ADDRESS_TYPE_MASK 0x60 /* 96 */
#define FRAM_SEL_IPV_ADDRESS_TYPE_OFFSET 0x5 /* 5 */
#define FRAM_SEL_IPV_ADDRESS_TYPE_WIDTH 0x2 /* 2 */
#define FRAM_SEL_IPV_ADDRESS_TYPE_DEFAULT 0x0 /* 0 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_fram_drp
 * with prefix fram_drp @ address 0x4000
 *------------------------------------------------------------------------------
 */
/* Type = rw */
#define FRAM_DRPFRAM_DATA_PC_ID_ADDR 0x4000 /* 16384 */
#define FRAM_DRPFRAM_DATA_PC_ID_MASK 0xffff /* 65535 */
#define FRAM_DRPFRAM_DATA_PC_ID_OFFSET 0x0 /* 0 */
#define FRAM_DRPFRAM_DATA_PC_ID_WIDTH 0x10 /* 16 */
#define FRAM_DRPFRAM_DATA_PC_ID_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_DRPFRAM_DATA_MESSAGE_TYPE_ADDR 0x4000 /* 16384 */
#define FRAM_DRPFRAM_DATA_MESSAGE_TYPE_MASK 0xff0000 /* 16711680 */
#define FRAM_DRPFRAM_DATA_MESSAGE_TYPE_OFFSET 0x10 /* 16 */
#define FRAM_DRPFRAM_DATA_MESSAGE_TYPE_WIDTH 0x8 /* 8 */
#define FRAM_DRPFRAM_DATA_MESSAGE_TYPE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_DRPFRAM_DATA_ETHERNET_PORT_ADDR 0x4000 /* 16384 */
#define FRAM_DRPFRAM_DATA_ETHERNET_PORT_MASK 0xff000000 /* 4278190080 */
#define FRAM_DRPFRAM_DATA_ETHERNET_PORT_OFFSET 0x18 /* 24 */
#define FRAM_DRPFRAM_DATA_ETHERNET_PORT_WIDTH 0x8 /* 8 */
#define FRAM_DRPFRAM_DATA_ETHERNET_PORT_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_DRPFRAM_CTRL_PC_ID_ADDR 0x4400 /* 17408 */
#define FRAM_DRPFRAM_CTRL_PC_ID_MASK 0xffff /* 65535 */
#define FRAM_DRPFRAM_CTRL_PC_ID_OFFSET 0x0 /* 0 */
#define FRAM_DRPFRAM_CTRL_PC_ID_WIDTH 0x10 /* 16 */
#define FRAM_DRPFRAM_CTRL_PC_ID_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_DRPFRAM_CTRL_MESSAGE_TYPE_ADDR 0x4400 /* 17408 */
#define FRAM_DRPFRAM_CTRL_MESSAGE_TYPE_MASK 0xff0000 /* 16711680 */
#define FRAM_DRPFRAM_CTRL_MESSAGE_TYPE_OFFSET 0x10 /* 16 */
#define FRAM_DRPFRAM_CTRL_MESSAGE_TYPE_WIDTH 0x8 /* 8 */
#define FRAM_DRPFRAM_CTRL_MESSAGE_TYPE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define FRAM_DRPFRAM_CTRL_ETHERNET_PORT_ADDR 0x4400 /* 17408 */
#define FRAM_DRPFRAM_CTRL_ETHERNET_PORT_MASK 0xff000000 /* 4278190080 */
#define FRAM_DRPFRAM_CTRL_ETHERNET_PORT_OFFSET 0x18 /* 24 */
#define FRAM_DRPFRAM_CTRL_ETHERNET_PORT_WIDTH 0x8 /* 8 */
#define FRAM_DRPFRAM_CTRL_ETHERNET_PORT_DEFAULT 0x0 /* 0 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_defm
 * with prefix defm_ @ address 0x6000
 *------------------------------------------------------------------------------
 */
/* Type = rw */
#define DEFM_RESTART_ADDR 0x6000 /* 24576 */
#define DEFM_RESTART_MASK 0x1 /* 1 */
#define DEFM_RESTART_OFFSET 0x0 /* 0 */
#define DEFM_RESTART_WIDTH 0x1 /* 1 */
#define DEFM_RESTART_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_READY_ADDR 0x6000 /* 24576 */
#define DEFM_READY_MASK 0x2 /* 2 */
#define DEFM_READY_OFFSET 0x1 /* 1 */
#define DEFM_READY_WIDTH 0x1 /* 1 */
#define DEFM_READY_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_ERR_PACKET_FILTER_ADDR 0x6004 /* 24580 */
#define DEFM_ERR_PACKET_FILTER_MASK 0x3 /* 3 */
#define DEFM_ERR_PACKET_FILTER_OFFSET 0x0 /* 0 */
#define DEFM_ERR_PACKET_FILTER_WIDTH 0x2 /* 2 */
#define DEFM_ERR_PACKET_FILTER_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_DATA_PKT_MESSAGE_TYPE_ADDR 0x6008 /* 24584 */
#define DEFM_DATA_PKT_MESSAGE_TYPE_MASK 0xff /* 255 */
#define DEFM_DATA_PKT_MESSAGE_TYPE_OFFSET 0x0 /* 0 */
#define DEFM_DATA_PKT_MESSAGE_TYPE_WIDTH 0x8 /* 8 */
#define DEFM_DATA_PKT_MESSAGE_TYPE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_CTRL_PKT_MESSAGE_TYPE_ADDR 0x600c /* 24588 */
#define DEFM_CTRL_PKT_MESSAGE_TYPE_MASK 0xff /* 255 */
#define DEFM_CTRL_PKT_MESSAGE_TYPE_OFFSET 0x0 /* 0 */
#define DEFM_CTRL_PKT_MESSAGE_TYPE_WIDTH 0x8 /* 8 */
#define DEFM_CTRL_PKT_MESSAGE_TYPE_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_SN_DATA_LOW_CNT_MIN_ADDR 0x6020 /* 24608 */
#define DEFM_SN_DATA_LOW_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_LOW_CNT_MIN_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_LOW_CNT_MIN_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_LOW_CNT_MIN_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define DEFM_SN_DATA_LOW_CNT_MAX_ADDR 0x6024 /* 24612 */
#define DEFM_SN_DATA_LOW_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_LOW_CNT_MAX_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_LOW_CNT_MAX_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_LOW_CNT_MAX_DEFAULT 0x78 /* 120 */

/* Type = rw */
#define DEFM_SN_DATA_LOW_CNT_INCVAL_ADDR 0x602c /* 24620 */
#define DEFM_SN_DATA_LOW_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_LOW_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_LOW_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_LOW_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define DEFM_SN_DATA_HIGH_CNT_MIN_ADDR 0x6030 /* 24624 */
#define DEFM_SN_DATA_HIGH_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_HIGH_CNT_MIN_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_HIGH_CNT_MIN_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_HIGH_CNT_MIN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_SN_DATA_HIGH_CNT_MAX_ADDR 0x6034 /* 24628 */
#define DEFM_SN_DATA_HIGH_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_HIGH_CNT_MAX_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_HIGH_CNT_MAX_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_HIGH_CNT_MAX_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define DEFM_SN_DATA_HIGH_CNT_INCVAL_ADDR 0x603c /* 24636 */
#define DEFM_SN_DATA_HIGH_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_DATA_HIGH_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define DEFM_SN_DATA_HIGH_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define DEFM_SN_DATA_HIGH_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define DEFM_SN_CTRL_LOW_CNT_MIN_ADDR 0x6050 /* 24656 */
#define DEFM_SN_CTRL_LOW_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_LOW_CNT_MIN_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_LOW_CNT_MIN_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_LOW_CNT_MIN_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define DEFM_SN_CTRL_LOW_CNT_MAX_ADDR 0x6054 /* 24660 */
#define DEFM_SN_CTRL_LOW_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_LOW_CNT_MAX_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_LOW_CNT_MAX_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_LOW_CNT_MAX_DEFAULT 0x78 /* 120 */

/* Type = rw */
#define DEFM_SN_CTRL_LOW_CNT_INCVAL_ADDR 0x605c /* 24668 */
#define DEFM_SN_CTRL_LOW_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_LOW_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_LOW_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_LOW_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rw */
#define DEFM_SN_CTRL_HIGH_CNT_MIN_ADDR 0x6060 /* 24672 */
#define DEFM_SN_CTRL_HIGH_CNT_MIN_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_HIGH_CNT_MIN_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_HIGH_CNT_MIN_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_HIGH_CNT_MIN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_SN_CTRL_HIGH_CNT_MAX_ADDR 0x6064 /* 24676 */
#define DEFM_SN_CTRL_HIGH_CNT_MAX_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_HIGH_CNT_MAX_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_HIGH_CNT_MAX_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_HIGH_CNT_MAX_DEFAULT 0x4f /* 79 */

/* Type = rw */
#define DEFM_SN_CTRL_HIGH_CNT_INCVAL_ADDR 0x606c /* 24684 */
#define DEFM_SN_CTRL_HIGH_CNT_INCVAL_MASK 0xffffffff /* 4294967295 */
#define DEFM_SN_CTRL_HIGH_CNT_INCVAL_OFFSET 0x0 /* 0 */
#define DEFM_SN_CTRL_HIGH_CNT_INCVAL_WIDTH 0x20 /* 32 */
#define DEFM_SN_CTRL_HIGH_CNT_INCVAL_DEFAULT 0x1 /* 1 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W0_31_0_ADDR 0x6100 /* 24832 */
#define DEFM_USER_DATA_FILTER_W0_31_0_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W0_31_0_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W0_31_0_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W0_31_0_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W0_63_32_ADDR 0x6104 /* 24836 */
#define DEFM_USER_DATA_FILTER_W0_63_32_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W0_63_32_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W0_63_32_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W0_63_32_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W0_95_64_ADDR 0x6108 /* 24840 */
#define DEFM_USER_DATA_FILTER_W0_95_64_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W0_95_64_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W0_95_64_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W0_95_64_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W0_127_96_ADDR 0x610c /* 24844 */
#define DEFM_USER_DATA_FILTER_W0_127_96_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W0_127_96_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W0_127_96_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W0_127_96_DEFAULT 0xfffffeae /* 4294966958 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W0_MASK_ADDR 0x6110 /* 24848 */
#define DEFM_USER_DATA_FILTER_W0_MASK_MASK 0xffff /* 65535 */
#define DEFM_USER_DATA_FILTER_W0_MASK_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W0_MASK_WIDTH 0x10 /* 16 */
#define DEFM_USER_DATA_FILTER_W0_MASK_DEFAULT 0xcfff /* 53247 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W1_31_0_ADDR 0x6120 /* 24864 */
#define DEFM_USER_DATA_FILTER_W1_31_0_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W1_31_0_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W1_31_0_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W1_31_0_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W1_63_32_ADDR 0x6124 /* 24868 */
#define DEFM_USER_DATA_FILTER_W1_63_32_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W1_63_32_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W1_63_32_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W1_63_32_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W1_95_64_ADDR 0x6128 /* 24872 */
#define DEFM_USER_DATA_FILTER_W1_95_64_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W1_95_64_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W1_95_64_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W1_95_64_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W1_127_96_ADDR 0x612c /* 24876 */
#define DEFM_USER_DATA_FILTER_W1_127_96_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W1_127_96_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W1_127_96_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W1_127_96_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W1_MASK_ADDR 0x6130 /* 24880 */
#define DEFM_USER_DATA_FILTER_W1_MASK_MASK 0xffff /* 65535 */
#define DEFM_USER_DATA_FILTER_W1_MASK_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W1_MASK_WIDTH 0x10 /* 16 */
#define DEFM_USER_DATA_FILTER_W1_MASK_DEFAULT 0xffff /* 65535 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W2_31_0_ADDR 0x6140 /* 24896 */
#define DEFM_USER_DATA_FILTER_W2_31_0_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W2_31_0_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W2_31_0_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W2_31_0_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W2_63_32_ADDR 0x6144 /* 24900 */
#define DEFM_USER_DATA_FILTER_W2_63_32_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W2_63_32_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W2_63_32_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W2_63_32_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W2_95_64_ADDR 0x6148 /* 24904 */
#define DEFM_USER_DATA_FILTER_W2_95_64_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W2_95_64_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W2_95_64_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W2_95_64_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W2_127_96_ADDR 0x614c /* 24908 */
#define DEFM_USER_DATA_FILTER_W2_127_96_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W2_127_96_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W2_127_96_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W2_127_96_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W2_MASK_ADDR 0x6150 /* 24912 */
#define DEFM_USER_DATA_FILTER_W2_MASK_MASK 0xffff /* 65535 */
#define DEFM_USER_DATA_FILTER_W2_MASK_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W2_MASK_WIDTH 0x10 /* 16 */
#define DEFM_USER_DATA_FILTER_W2_MASK_DEFAULT 0xffff /* 65535 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W3_31_0_ADDR 0x6160 /* 24928 */
#define DEFM_USER_DATA_FILTER_W3_31_0_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W3_31_0_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W3_31_0_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W3_31_0_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W3_63_32_ADDR 0x6164 /* 24932 */
#define DEFM_USER_DATA_FILTER_W3_63_32_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W3_63_32_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W3_63_32_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W3_63_32_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W3_95_64_ADDR 0x6168 /* 24936 */
#define DEFM_USER_DATA_FILTER_W3_95_64_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W3_95_64_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W3_95_64_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W3_95_64_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W3_127_96_ADDR 0x616c /* 24940 */
#define DEFM_USER_DATA_FILTER_W3_127_96_MASK 0xffffffff /* 4294967295 */
#define DEFM_USER_DATA_FILTER_W3_127_96_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W3_127_96_WIDTH 0x20 /* 32 */
#define DEFM_USER_DATA_FILTER_W3_127_96_DEFAULT 0xffffffff /* 4294967295 */

/* Type = rwpdef */
#define DEFM_USER_DATA_FILTER_W3_MASK_ADDR 0x6170 /* 24944 */
#define DEFM_USER_DATA_FILTER_W3_MASK_MASK 0xffff /* 65535 */
#define DEFM_USER_DATA_FILTER_W3_MASK_OFFSET 0x0 /* 0 */
#define DEFM_USER_DATA_FILTER_W3_MASK_WIDTH 0x10 /* 16 */
#define DEFM_USER_DATA_FILTER_W3_MASK_DEFAULT 0xffff /* 65535 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_defm_drp
 * with prefix defm_drp @ address 0x8000
 *------------------------------------------------------------------------------
 */
/* Type = rw */
#define DEFM_DRPDEFM_DATA_PC_ID_ADDR 0x8000 /* 32768 */
#define DEFM_DRPDEFM_DATA_PC_ID_MASK 0xffff /* 65535 */
#define DEFM_DRPDEFM_DATA_PC_ID_OFFSET 0x0 /* 0 */
#define DEFM_DRPDEFM_DATA_PC_ID_WIDTH 0x10 /* 16 */
#define DEFM_DRPDEFM_DATA_PC_ID_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define DEFM_DRPDEFM_CTRL_PC_ID_ADDR 0x8400 /* 33792 */
#define DEFM_DRPDEFM_CTRL_PC_ID_MASK 0xffff /* 65535 */
#define DEFM_DRPDEFM_CTRL_PC_ID_OFFSET 0x0 /* 0 */
#define DEFM_DRPDEFM_CTRL_PC_ID_WIDTH 0x10 /* 16 */
#define DEFM_DRPDEFM_CTRL_PC_ID_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_LATENCY_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_LATENCY_MASK 0xffffff /* 16777215 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_LATENCY_OFFSET 0x0 /* 0 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_LATENCY_WIDTH 0x18 /* 24 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_LATENCY_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_ALIGNMENT_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_ALIGNMENT_MASK 0x1000000 /* 16777216 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_ALIGNMENT_OFFSET 0x18 /* 24 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_ALIGNMENT_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_ALIGNMENT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_OVERFLOW_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_OVERFLOW_MASK 0x2000000 /* 33554432 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_OVERFLOW_OFFSET 0x19 /* 25 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_OVERFLOW_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_OVERFLOW_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_UNDERFLOW_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_UNDERFLOW_MASK 0x4000000 /* 67108864 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_UNDERFLOW_OFFSET 0x1a /* 26 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_UNDERFLOW_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_UNDERFLOW_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_REGULAR_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_REGULAR_MASK 0x8000000 /* 134217728 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_REGULAR_OFFSET 0x1b /* 27 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_REGULAR_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_REGULAR_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_RWIN_ADDR 0x8800 /* 34816 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_RWIN_MASK 0xf0000000 /* 4026531840 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_RWIN_OFFSET 0x1c /* 28 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_RWIN_WIDTH 0x4 /* 4 */
#define DEFM_DRPDEFM_DATA_BUFFER_STATE_RWIN_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_LATENCY_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_LATENCY_MASK 0xffffff /* 16777215 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_LATENCY_OFFSET 0x0 /* 0 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_LATENCY_WIDTH 0x18 /* 24 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_LATENCY_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_ALIGNMENT_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_ALIGNMENT_MASK 0x1000000 /* 16777216 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_ALIGNMENT_OFFSET 0x18 /* 24 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_ALIGNMENT_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_ALIGNMENT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_OVERFLOW_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_OVERFLOW_MASK 0x2000000 /* 33554432 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_OVERFLOW_OFFSET 0x19 /* 25 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_OVERFLOW_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_OVERFLOW_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_UNDERFLOW_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_UNDERFLOW_MASK 0x4000000 /* 67108864 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_UNDERFLOW_OFFSET 0x1a /* 26 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_UNDERFLOW_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_UNDERFLOW_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_REGULAR_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_REGULAR_MASK 0x8000000 /* 134217728 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_REGULAR_OFFSET 0x1b /* 27 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_REGULAR_WIDTH 0x1 /* 1 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_REGULAR_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_RWIN_ADDR 0x9800 /* 38912 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_RWIN_MASK 0xf0000000 /* 4026531840 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_RWIN_OFFSET 0x1c /* 28 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_RWIN_WIDTH 0x4 /* 4 */
#define DEFM_DRPDEFM_CTRL_BUFFER_STATE_RWIN_DEFAULT 0x0 /* 0 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_eth
 * with prefix eth_ @ address 0xa000
 *------------------------------------------------------------------------------
 */
/* Type = rwpdef */
#define ETH_DEST_ADDR_31_0_ADDR 0xa000 /* 40960 */
#define ETH_DEST_ADDR_31_0_MASK 0xffffffff /* 4294967295 */
#define ETH_DEST_ADDR_31_0_OFFSET 0x0 /* 0 */
#define ETH_DEST_ADDR_31_0_WIDTH 0x20 /* 32 */
#define ETH_DEST_ADDR_31_0_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_DEST_ADDR_47_32_ADDR 0xa004 /* 40964 */
#define ETH_DEST_ADDR_47_32_MASK 0xffff /* 65535 */
#define ETH_DEST_ADDR_47_32_OFFSET 0x0 /* 0 */
#define ETH_DEST_ADDR_47_32_WIDTH 0x10 /* 16 */
#define ETH_DEST_ADDR_47_32_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_SRC_ADDR_31_0_ADDR 0xa008 /* 40968 */
#define ETH_SRC_ADDR_31_0_MASK 0xffffffff /* 4294967295 */
#define ETH_SRC_ADDR_31_0_OFFSET 0x0 /* 0 */
#define ETH_SRC_ADDR_31_0_WIDTH 0x20 /* 32 */
#define ETH_SRC_ADDR_31_0_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_SRC_ADDR_47_32_ADDR 0xa00c /* 40972 */
#define ETH_SRC_ADDR_47_32_MASK 0xffff /* 65535 */
#define ETH_SRC_ADDR_47_32_OFFSET 0x0 /* 0 */
#define ETH_SRC_ADDR_47_32_WIDTH 0x10 /* 16 */
#define ETH_SRC_ADDR_47_32_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_VLAN_ID_ADDR 0xa010 /* 40976 */
#define ETH_VLAN_ID_MASK 0xfff /* 4095 */
#define ETH_VLAN_ID_OFFSET 0x0 /* 0 */
#define ETH_VLAN_ID_WIDTH 0xc /* 12 */
#define ETH_VLAN_ID_DEFAULT 0x1 /* 1 */

/* Type = rwpdef */
#define ETH_VLAN_DEI_ADDR 0xa010 /* 40976 */
#define ETH_VLAN_DEI_MASK 0x1000 /* 4096 */
#define ETH_VLAN_DEI_OFFSET 0xc /* 12 */
#define ETH_VLAN_DEI_WIDTH 0x1 /* 1 */
#define ETH_VLAN_DEI_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_VLAN_PCP_ADDR 0xa010 /* 40976 */
#define ETH_VLAN_PCP_MASK 0xe000 /* 57344 */
#define ETH_VLAN_PCP_OFFSET 0xd /* 13 */
#define ETH_VLAN_PCP_WIDTH 0x3 /* 3 */
#define ETH_VLAN_PCP_DEFAULT 0x7 /* 7 */

/* Type = rw */
#define ETH_IPV4_VERSION_ADDR 0xa030 /* 41008 */
#define ETH_IPV4_VERSION_MASK 0xf /* 15 */
#define ETH_IPV4_VERSION_OFFSET 0x0 /* 0 */
#define ETH_IPV4_VERSION_WIDTH 0x4 /* 4 */
#define ETH_IPV4_VERSION_DEFAULT 0x4 /* 4 */

/* Type = rw */
#define ETH_IPV4_IHL_ADDR 0xa030 /* 41008 */
#define ETH_IPV4_IHL_MASK 0xf0 /* 240 */
#define ETH_IPV4_IHL_OFFSET 0x4 /* 4 */
#define ETH_IPV4_IHL_WIDTH 0x4 /* 4 */
#define ETH_IPV4_IHL_DEFAULT 0x5 /* 5 */

/* Type = rw */
#define ETH_IPV4_DSCP_ADDR 0xa034 /* 41012 */
#define ETH_IPV4_DSCP_MASK 0x3f /* 63 */
#define ETH_IPV4_DSCP_OFFSET 0x0 /* 0 */
#define ETH_IPV4_DSCP_WIDTH 0x6 /* 6 */
#define ETH_IPV4_DSCP_DEFAULT 0x2e /* 46 */

/* Type = rw */
#define ETH_IPV4_ECN_ADDR 0xa034 /* 41012 */
#define ETH_IPV4_ECN_MASK 0xc0 /* 192 */
#define ETH_IPV4_ECN_OFFSET 0x6 /* 6 */
#define ETH_IPV4_ECN_WIDTH 0x2 /* 2 */
#define ETH_IPV4_ECN_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_IPV4_ID_ADDR 0xa038 /* 41016 */
#define ETH_IPV4_ID_MASK 0xffff /* 65535 */
#define ETH_IPV4_ID_OFFSET 0x0 /* 0 */
#define ETH_IPV4_ID_WIDTH 0x10 /* 16 */
#define ETH_IPV4_ID_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_IPV4_FLAGS_ADDR 0xa03c /* 41020 */
#define ETH_IPV4_FLAGS_MASK 0x7 /* 7 */
#define ETH_IPV4_FLAGS_OFFSET 0x0 /* 0 */
#define ETH_IPV4_FLAGS_WIDTH 0x3 /* 3 */
#define ETH_IPV4_FLAGS_DEFAULT 0x2 /* 2 */

/* Type = rw */
#define ETH_IPV4_FRAGMENT_OFFSET_ADDR 0xa03c /* 41020 */
#define ETH_IPV4_FRAGMENT_OFFSET_MASK 0x1fff8 /* 131064 */
#define ETH_IPV4_FRAGMENT_OFFSET_OFFSET 0x3 /* 3 */
#define ETH_IPV4_FRAGMENT_OFFSET_WIDTH 0xe /* 14 */
#define ETH_IPV4_FRAGMENT_OFFSET_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_IPV4_TIME_TO_LIVE_ADDR 0xa040 /* 41024 */
#define ETH_IPV4_TIME_TO_LIVE_MASK 0xff /* 255 */
#define ETH_IPV4_TIME_TO_LIVE_OFFSET 0x0 /* 0 */
#define ETH_IPV4_TIME_TO_LIVE_WIDTH 0x8 /* 8 */
#define ETH_IPV4_TIME_TO_LIVE_DEFAULT 0x40 /* 64 */

/* Type = rw */
#define ETH_IPV4_PROTOCOL_ADDR 0xa044 /* 41028 */
#define ETH_IPV4_PROTOCOL_MASK 0xff /* 255 */
#define ETH_IPV4_PROTOCOL_OFFSET 0x0 /* 0 */
#define ETH_IPV4_PROTOCOL_WIDTH 0x8 /* 8 */
#define ETH_IPV4_PROTOCOL_DEFAULT 0x11 /* 17 */

/* Type = rwpdef */
#define ETH_IPV4_SOURCE_ADD_ADDR 0xa048 /* 41032 */
#define ETH_IPV4_SOURCE_ADD_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV4_SOURCE_ADD_OFFSET 0x0 /* 0 */
#define ETH_IPV4_SOURCE_ADD_WIDTH 0x20 /* 32 */
#define ETH_IPV4_SOURCE_ADD_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV4_DESTINATION_ADD_ADDR 0xa04c /* 41036 */
#define ETH_IPV4_DESTINATION_ADD_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV4_DESTINATION_ADD_OFFSET 0x0 /* 0 */
#define ETH_IPV4_DESTINATION_ADD_WIDTH 0x20 /* 32 */
#define ETH_IPV4_DESTINATION_ADD_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_UDP_SOURCE_PORT_ADDR 0xa050 /* 41040 */
#define ETH_UDP_SOURCE_PORT_MASK 0xffff /* 65535 */
#define ETH_UDP_SOURCE_PORT_OFFSET 0x0 /* 0 */
#define ETH_UDP_SOURCE_PORT_WIDTH 0x10 /* 16 */
#define ETH_UDP_SOURCE_PORT_DEFAULT 0x8000 /* 32768 */

/* Type = rw */
#define ETH_UDP_DESTINATION_PORT_ADDR 0xa050 /* 41040 */
#define ETH_UDP_DESTINATION_PORT_MASK 0xffff0000 /* 4294901760 */
#define ETH_UDP_DESTINATION_PORT_OFFSET 0x10 /* 16 */
#define ETH_UDP_DESTINATION_PORT_WIDTH 0x10 /* 16 */
#define ETH_UDP_DESTINATION_PORT_DEFAULT 0xc000 /* 49152 */

/* Type = rw */
#define ETH_IPV6_V_ADDR 0xa080 /* 41088 */
#define ETH_IPV6_V_MASK 0xf /* 15 */
#define ETH_IPV6_V_OFFSET 0x0 /* 0 */
#define ETH_IPV6_V_WIDTH 0x4 /* 4 */
#define ETH_IPV6_V_DEFAULT 0x6 /* 6 */

/* Type = rw */
#define ETH_IPV6_TRAFFIC_CLASS_ADDR 0xa084 /* 41092 */
#define ETH_IPV6_TRAFFIC_CLASS_MASK 0xff /* 255 */
#define ETH_IPV6_TRAFFIC_CLASS_OFFSET 0x0 /* 0 */
#define ETH_IPV6_TRAFFIC_CLASS_WIDTH 0x8 /* 8 */
#define ETH_IPV6_TRAFFIC_CLASS_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_IPV6_FLOW_LABEL_ADDR 0xa088 /* 41096 */
#define ETH_IPV6_FLOW_LABEL_MASK 0xfffff /* 1048575 */
#define ETH_IPV6_FLOW_LABEL_OFFSET 0x0 /* 0 */
#define ETH_IPV6_FLOW_LABEL_WIDTH 0x14 /* 20 */
#define ETH_IPV6_FLOW_LABEL_DEFAULT 0x0 /* 0 */

/* Type = rw */
#define ETH_IPV6_NEXT_HEADER_ADDR 0xa08c /* 41100 */
#define ETH_IPV6_NEXT_HEADER_MASK 0xff /* 255 */
#define ETH_IPV6_NEXT_HEADER_OFFSET 0x0 /* 0 */
#define ETH_IPV6_NEXT_HEADER_WIDTH 0x8 /* 8 */
#define ETH_IPV6_NEXT_HEADER_DEFAULT 0x11 /* 17 */

/* Type = rw */
#define ETH_IPV6_HOP_LIMIT_ADDR 0xa090 /* 41104 */
#define ETH_IPV6_HOP_LIMIT_MASK 0xff /* 255 */
#define ETH_IPV6_HOP_LIMIT_OFFSET 0x0 /* 0 */
#define ETH_IPV6_HOP_LIMIT_WIDTH 0x8 /* 8 */
#define ETH_IPV6_HOP_LIMIT_DEFAULT 0x40 /* 64 */

/* Type = rwpdef */
#define ETH_IPV6_SOURCE_ADD_31_0_ADDR 0xa094 /* 41108 */
#define ETH_IPV6_SOURCE_ADD_31_0_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_SOURCE_ADD_31_0_OFFSET 0x0 /* 0 */
#define ETH_IPV6_SOURCE_ADD_31_0_WIDTH 0x20 /* 32 */
#define ETH_IPV6_SOURCE_ADD_31_0_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_SOURCE_ADD_63_32_ADDR 0xa098 /* 41112 */
#define ETH_IPV6_SOURCE_ADD_63_32_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_SOURCE_ADD_63_32_OFFSET 0x0 /* 0 */
#define ETH_IPV6_SOURCE_ADD_63_32_WIDTH 0x20 /* 32 */
#define ETH_IPV6_SOURCE_ADD_63_32_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_SOURCE_ADD_95_64_ADDR 0xa09c /* 41116 */
#define ETH_IPV6_SOURCE_ADD_95_64_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_SOURCE_ADD_95_64_OFFSET 0x0 /* 0 */
#define ETH_IPV6_SOURCE_ADD_95_64_WIDTH 0x20 /* 32 */
#define ETH_IPV6_SOURCE_ADD_95_64_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_SOURCE_ADD_127_96_ADDR 0xa0a0 /* 41120 */
#define ETH_IPV6_SOURCE_ADD_127_96_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_SOURCE_ADD_127_96_OFFSET 0x0 /* 0 */
#define ETH_IPV6_SOURCE_ADD_127_96_WIDTH 0x20 /* 32 */
#define ETH_IPV6_SOURCE_ADD_127_96_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_DEST_ADD_31_0_ADDR 0xa0a4 /* 41124 */
#define ETH_IPV6_DEST_ADD_31_0_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_DEST_ADD_31_0_OFFSET 0x0 /* 0 */
#define ETH_IPV6_DEST_ADD_31_0_WIDTH 0x20 /* 32 */
#define ETH_IPV6_DEST_ADD_31_0_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_DEST_ADD_63_32_ADDR 0xa0a8 /* 41128 */
#define ETH_IPV6_DEST_ADD_63_32_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_DEST_ADD_63_32_OFFSET 0x0 /* 0 */
#define ETH_IPV6_DEST_ADD_63_32_WIDTH 0x20 /* 32 */
#define ETH_IPV6_DEST_ADD_63_32_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_DEST_ADD_95_64_ADDR 0xa0ac /* 41132 */
#define ETH_IPV6_DEST_ADD_95_64_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_DEST_ADD_95_64_OFFSET 0x0 /* 0 */
#define ETH_IPV6_DEST_ADD_95_64_WIDTH 0x20 /* 32 */
#define ETH_IPV6_DEST_ADD_95_64_DEFAULT 0x0 /* 0 */

/* Type = rwpdef */
#define ETH_IPV6_DEST_ADD_127_96_ADDR 0xa0b0 /* 41136 */
#define ETH_IPV6_DEST_ADD_127_96_MASK 0xffffffff /* 4294967295 */
#define ETH_IPV6_DEST_ADD_127_96_OFFSET 0x0 /* 0 */
#define ETH_IPV6_DEST_ADD_127_96_WIDTH 0x20 /* 32 */
#define ETH_IPV6_DEST_ADD_127_96_DEFAULT 0x0 /* 0 */

/*-----------------------------------------------------------------------------
 * C Header bank register definitions for bank roe_framer_v1_0_stats
 * with prefix stats_ @ address 0xc000
 *------------------------------------------------------------------------------
 */
/* Type = roSig */
#define STATS_TOTAL_RX_GOOD_PKT_CNT_ADDR 0xc000 /* 49152 */
#define STATS_TOTAL_RX_GOOD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_TOTAL_RX_GOOD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_TOTAL_RX_GOOD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_TOTAL_RX_GOOD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_TOTAL_RX_BAD_PKT_CNT_ADDR 0xc004 /* 49156 */
#define STATS_TOTAL_RX_BAD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_TOTAL_RX_BAD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_TOTAL_RX_BAD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_TOTAL_RX_BAD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_TOTAL_RX_BAD_FCS_CNT_ADDR 0xc008 /* 49160 */
#define STATS_TOTAL_RX_BAD_FCS_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_TOTAL_RX_BAD_FCS_CNT_OFFSET 0x0 /* 0 */
#define STATS_TOTAL_RX_BAD_FCS_CNT_WIDTH 0x20 /* 32 */
#define STATS_TOTAL_RX_BAD_FCS_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_DATA_RX_PACKETS_CNT_ADDR 0xc00c /* 49164 */
#define STATS_USER_DATA_RX_PACKETS_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_DATA_RX_PACKETS_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_DATA_RX_PACKETS_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_DATA_RX_PACKETS_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_DATA_RX_GOOD_PKT_CNT_ADDR 0xc010 /* 49168 */
#define STATS_USER_DATA_RX_GOOD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_DATA_RX_GOOD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_DATA_RX_GOOD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_DATA_RX_GOOD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_DATA_RX_BAD_PKT_CNT_ADDR 0xc014 /* 49172 */
#define STATS_USER_DATA_RX_BAD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_DATA_RX_BAD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_DATA_RX_BAD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_DATA_RX_BAD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_DATA_RX_BAD_FCS_CNT_ADDR 0xc018 /* 49176 */
#define STATS_USER_DATA_RX_BAD_FCS_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_DATA_RX_BAD_FCS_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_DATA_RX_BAD_FCS_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_DATA_RX_BAD_FCS_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_CTRL_RX_PACKETS_CNT_ADDR 0xc01c /* 49180 */
#define STATS_USER_CTRL_RX_PACKETS_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_CTRL_RX_PACKETS_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_CTRL_RX_PACKETS_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_CTRL_RX_PACKETS_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_CTRL_RX_GOOD_PKT_CNT_ADDR 0xc020 /* 49184 */
#define STATS_USER_CTRL_RX_GOOD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_CTRL_RX_GOOD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_CTRL_RX_GOOD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_CTRL_RX_GOOD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_CTRL_RX_BAD_PKT_CNT_ADDR 0xc024 /* 49188 */
#define STATS_USER_CTRL_RX_BAD_PKT_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_CTRL_RX_BAD_PKT_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_CTRL_RX_BAD_PKT_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_CTRL_RX_BAD_PKT_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_CTRL_RX_BAD_FCS_CNT_ADDR 0xc028 /* 49192 */
#define STATS_USER_CTRL_RX_BAD_FCS_CNT_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_CTRL_RX_BAD_FCS_CNT_OFFSET 0x0 /* 0 */
#define STATS_USER_CTRL_RX_BAD_FCS_CNT_WIDTH 0x20 /* 32 */
#define STATS_USER_CTRL_RX_BAD_FCS_CNT_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_DATA_RX_PKTS_RATE_ADDR 0xc02c /* 49196 */
#define STATS_USER_DATA_RX_PKTS_RATE_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_DATA_RX_PKTS_RATE_OFFSET 0x0 /* 0 */
#define STATS_USER_DATA_RX_PKTS_RATE_WIDTH 0x20 /* 32 */
#define STATS_USER_DATA_RX_PKTS_RATE_DEFAULT 0x0 /* 0 */

/* Type = roSig */
#define STATS_USER_CTRL_RX_PKTS_RATE_ADDR 0xc030 /* 49200 */
#define STATS_USER_CTRL_RX_PKTS_RATE_MASK 0xffffffff /* 4294967295 */
#define STATS_USER_CTRL_RX_PKTS_RATE_OFFSET 0x0 /* 0 */
#define STATS_USER_CTRL_RX_PKTS_RATE_WIDTH 0x20 /* 32 */
#define STATS_USER_CTRL_RX_PKTS_RATE_DEFAULT 0x0 /* 0 */
