#include <stdio.h>
#include <time.h>

#define FRIDAY 5
#define MONDAY 1

struct holiday {
	int month;
	int day;
	int wday;
	char *name;
};

int weekend(int holiday, int mday, int wday)
{
	if( mday>holiday-2 && mday<holiday+2 )
	{
		if( mday==holiday-1 && wday==FRIDAY )
			return(2);
		if( mday==holiday+1 && wday==MONDAY )
			return(2);
		if( mday==holiday )
			return(1);
	}
	return(0);
}

int isholiday(struct holiday *h)
{
	char *n[] = {
		"New Years Day",
		"Juneteenth",
		"Independence Day",
		"Veterans Day",
		"Christmas"
	};
	int r;

	if( h->month==11 && h->day==31 && h->wday==FRIDAY )
	{
		h->name = n[0];
		return(2);
	}
	if( h->month==0 && h->day==1 )
	{
		h->name = n[0];
		return(1);
	}
	if( h->month==0 && h->day==2 && h->wday==MONDAY )
	{
		h->name = n[0];
		return(2);
	}

	if( h->month==5 )
	{
		r = weekend(19,h->day,h->wday);
		h->name = n[1];
		return(r);
	}

	if( h->month==6 )
	{
		r = weekend(4,h->day,h->wday);
		h->name = n[2];
		return(r);
	}

	if( h->month==10 )
	{
		r = weekend(11,h->day,h->wday);
		h->name = n[3];
		return(r);
	}

	if( h->month==11 )
	{
		r = weekend(25,h->day,h->wday);
		h->name = n[4];
		return(r);
	}

	return(0);
}

int main()
{
	time_t now;
	struct tm *today;
	struct holiday h;
	int r;

	now = time(NULL);
	today = localtime(&now);

	h.month = today->tm_mon;
	h.day = today->tm_mday;
	h.wday = today->tm_wday;
	h.name = NULL;

	printf("Today is %d/%02d/%d, ",
			today->tm_mon+1,
			today->tm_mday,
			today->tm_year+1900
		  );

	r = isholiday(&h);
	if(r==1)
		puts(h.name);
	else if(r==2)
		printf("%s observed\n",h.name);
	else
		puts("not a holiday");

	return(r);
}
