/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.gui.screen.ScriptRestrictionWarningScreen;
import com.lx862.jcm.mod.render.gui.screen.TextureTextAtlasScreen;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.gui.widget.ListViewWidget;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.render.gui.widget.WidgetSet;
import com.lx862.jcm.mod.scripting.jcm.JCMScripting;
import com.lx862.jcm.mod.scripting.mtr.MTRScripting;
import com.lx862.jcm.mod.util.JCMLogger;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.io.File;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class ClientConfigScreen
extends TitledScreen
implements GuiHelper {
    private static final Identifier TEXTURE_BACKGROUND = new Identifier("jsblock:textures/gui/config_screen/bg.png");
    private static final Identifier TEXTURE_STAR = new Identifier("jsblock:textures/gui/config_screen/stars.png");
    private static final Identifier TEXTURE_TERRAIN = new Identifier("jsblock:textures/gui/config_screen/terrain.png");
    private static final int STAR_ROTATION_LENGTH = 260000;
    private final WidgetSet bottomRowWidget = new WidgetSet(20);
    private final ListViewWidget listViewWidget = new ListViewWidget();
    private final CheckboxWidgetExtension disableRenderingButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().disableRendering = bool;
    });
    private final CheckboxWidgetExtension useNewTextRendererButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().useNewTextRenderer = bool;
    });
    private final CheckboxWidgetExtension debugModeButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().debug = bool;
    });
    private final CheckboxWidgetExtension disableScriptingClassRestrictionButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        if (bool.booleanValue()) {
            MinecraftClient.getInstance().openScreen(new Screen((class_437)new ScriptRestrictionWarningScreen(() -> {
                JCMClient.getConfig().disableScriptingRestriction = true;
            }).withPreviousScreen(new Screen((class_437)this))));
        } else {
            JCMClient.getConfig().disableScriptingRestriction = false;
        }
    });
    private final ButtonWidgetExtension textAtlasButton = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "config.listview.widget.open", new Object[0]), buttonWidget -> MinecraftClient.getInstance().openScreen(new Screen((class_437)new TextureTextAtlasScreen().withPreviousScreen(new Screen((class_437)this)))));
    private boolean discardConfig = false;

    public ClientConfigScreen() {
        super(true);
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.translatable(TextCategory.GUI, "brand", new Object[0]);
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.translatable(TextCategory.GUI, "config.version", "2.1.0");
    }

    protected void init2() {
        super.init2();
        this.listViewWidget.reset();
        this.bottomRowWidget.reset();
        int contentWidth = (int)Math.min((double)this.field_22789 * 0.75, 400.0);
        int listViewHeight = (int)((double)(this.field_22790 - 60) * 0.75);
        int startX = (this.field_22789 - contentWidth) / 2;
        int startY = 50;
        int bottomEntryHeight = this.field_22790 - startY - listViewHeight - 12;
        this.addConfigEntries();
        this.addBottomButtons();
        this.addChild(new ClickableWidget((class_339)this.listViewWidget));
        this.addChild(new ClickableWidget((class_339)this.bottomRowWidget));
        this.listViewWidget.setXYSize(startX, startY, contentWidth, listViewHeight);
        this.bottomRowWidget.setXYSize(startX, startY + listViewHeight + 6, contentWidth, bottomEntryHeight);
    }

    private void setEntryStateFromClientConfig() {
        this.disableRenderingButton.setChecked(JCMClient.getConfig().disableRendering);
        this.useNewTextRendererButton.setChecked(JCMClient.getConfig().useNewTextRenderer);
        this.debugModeButton.setChecked(JCMClient.getConfig().debug);
        this.disableScriptingClassRestrictionButton.setChecked(JCMClient.getConfig().disableScriptingRestriction);
    }

    private void addConfigEntries() {
        this.setEntryStateFromClientConfig();
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.general", new Object[0]));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.disable_rendering", new Object[0]), new MappedWidget(this.disableRenderingButton));
        this.addChild(new ClickableWidget((class_339)this.disableRenderingButton));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.disable_scripting_class_restriction", new Object[0]), new MappedWidget(this.disableScriptingClassRestrictionButton));
        this.addChild(new ClickableWidget((class_339)this.disableScriptingClassRestrictionButton));
        if (JCMClient.getConfig().useNewTextRenderer) {
            this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.experimental", new Object[0]));
            this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.new_text_rendering", new Object[0]), new MappedWidget(this.useNewTextRendererButton));
            this.addChild(new ClickableWidget((class_339)this.useNewTextRendererButton));
        }
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.debug", new Object[0]));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.debug_mode", new Object[0]), new MappedWidget(this.debugModeButton));
        this.addChild(new ClickableWidget((class_339)this.debugModeButton));
        if (JCMClient.getConfig().useNewTextRenderer) {
            this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.open_atlas_screen", new Object[0]), new MappedWidget(this.textAtlasButton));
            this.addChild(new ClickableWidget((class_339)this.textAtlasButton));
        }
    }

    private void addBottomButtons() {
        ButtonWidgetExtension latestLogButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.latest_log", new Object[0]), btn -> ClientConfigScreen.openLatestLog());
        ButtonWidgetExtension crashLogButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.crash_log", new Object[0]), btn -> ClientConfigScreen.openLatestCrashReport());
        ButtonWidgetExtension saveButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.save", new Object[0]), btn -> this.onClose2());
        ButtonWidgetExtension discardButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.discard", new Object[0]), btn -> {
            this.discardConfig = true;
            this.onClose2();
        });
        ButtonWidgetExtension resetButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.reset", new Object[0]), btn -> {
            JCMClient.getConfig().reset();
            this.setEntryStateFromClientConfig();
        });
        this.addChild(new ClickableWidget((class_339)latestLogButton));
        this.addChild(new ClickableWidget((class_339)crashLogButton));
        this.addChild(new ClickableWidget((class_339)saveButton));
        this.addChild(new ClickableWidget((class_339)discardButton));
        this.addChild(new ClickableWidget((class_339)resetButton));
        this.bottomRowWidget.addWidget(latestLogButton);
        this.bottomRowWidget.addWidget(crashLogButton);
        this.bottomRowWidget.insertRow();
        this.bottomRowWidget.addWidget(saveButton);
        this.bottomRowWidget.addWidget(discardButton);
        this.bottomRowWidget.addWidget(resetButton);
    }

    @Override
    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        double terrainHeight = (double)this.getWidthMapped() / 3.75;
        double starSize = Math.max(this.field_22789, this.field_22790) * 4;
        float starUVSize = (float)(starSize / 384.0);
        double translateY = (double)this.field_22790 * (1.0 - this.animationProgress);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_BACKGROUND, 0.0, 0.0, this.field_22789, this.field_22790);
        graphicsHolder.push();
        graphicsHolder.translate(0.0, translateY * (double)0.2f, 0.0);
        graphicsHolder.translate((double)this.getWidthMapped() / 2.0, (double)this.getHeightMapped() / 2.0, 0.0);
        float starRot = (float)(System.currentTimeMillis() % 260000L) / 260000.0f;
        graphicsHolder.rotateZDegrees(starRot * 360.0f);
        graphicsHolder.translate((double)(-this.getWidthMapped()) / 2.0, (double)(-this.getHeightMapped()) / 2.0, 0.0);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_STAR, 0.0, 0.0, starSize, starSize, 0.0f, 0.0f, starUVSize, starUVSize);
        graphicsHolder.pop();
        GuiHelper.drawTexture(guiDrawing, TEXTURE_TERRAIN, 0.0, translateY + (double)this.field_22790 - terrainHeight, this.field_22789, terrainHeight);
    }

    @Override
    public void onClose2() {
        if (!this.closing) {
            if (!this.discardConfig) {
                JCMClient.getConfig().write();
                JCMScripting.getScriptManager().getClassShutter().setEnabled(!JCMClient.getConfig().disableScriptingRestriction);
                MTRScripting.getScriptManager().getClassShutter().setEnabled(!JCMClient.getConfig().disableScriptingRestriction);
            } else {
                JCMClient.getConfig().read();
            }
        }
        super.onClose2();
    }

    public static void openLatestLog() {
        File latestLog = Paths.get(MinecraftClient.getInstance().getRunDirectoryMapped().toString(), "logs", "latest.log").toFile();
        if (latestLog.exists()) {
            Util.getOperatingSystem().open(latestLog);
        }
    }

    public static void openLatestCrashReport() {
        File[] crashReports;
        File crashReportDir = Paths.get(MinecraftClient.getInstance().getRunDirectoryMapped().toString(), "crash-reports").toFile();
        if (crashReportDir.exists() && (crashReports = crashReportDir.listFiles()) != null && crashReportDir.length() > 0L) {
            SimpleDateFormat crashReportFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
            Arrays.sort(crashReports, (o1, o2) -> {
                String filename1 = o1.getName().replace("crash-", "").replace("-client", "");
                String filename2 = o2.getName().replace("crash-", "").replace("-client", "");
                if (o1 == o2) {
                    return 0;
                }
                try {
                    long ts1 = crashReportFormat.parse(filename1).getTime();
                    long ts2 = crashReportFormat.parse(filename2).getTime();
                    return ts1 > ts2 ? -1 : 1;
                }
                catch (ParseException e) {
                    JCMLogger.debug("Cannot compare crash report file name " + filename1 + " <-> " + filename2, new Object[0]);
                    return 1;
                }
            });
            JCMLogger.debug("Latest crash report is: " + crashReports[0].getName(), new Object[0]);
            Util.getOperatingSystem().open(crashReports[0]);
        }
    }
}

