/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen.base;

import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.AnimatedScreen;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;

public abstract class TitledScreen
extends AnimatedScreen {
    public static final int TEXT_PADDING = 10;
    public static final int TITLE_SCALE = 2;
    protected double elapsed = 0.0;

    public TitledScreen(boolean animatable) {
        super(animatable);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        this.drawBackground(graphicsHolder, mouseX, mouseY, tickDelta);
        this.drawTitle(graphicsHolder);
        this.drawSubtitle(graphicsHolder);
        this.elapsed += (double)(tickDelta / 20.0f);
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
    }

    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.renderBackground(graphicsHolder);
    }

    private void drawTitle(GraphicsHolder graphicsHolder) {
        int titleHeight = 18;
        MutableText titleText = this.getScreenTitle();
        graphicsHolder.push();
        graphicsHolder.translate((double)this.field_22789 / 2.0, 10.0, 0.0);
        graphicsHolder.translate(0.0, -((double)(titleHeight + 10) * (1.0 - this.animationProgress)), 0.0);
        graphicsHolder.scale(2.0f, 2.0f, 2.0f);
        RenderHelper.scaleToFit(graphicsHolder, GraphicsHolder.getTextWidth((MutableText)titleText), (float)this.field_22789 / 2.0f, true);
        graphicsHolder.drawCenteredText(titleText, 0, 0, -1);
        graphicsHolder.pop();
    }

    private void drawSubtitle(GraphicsHolder graphicsHolder) {
        double titleHeight = 18.0;
        MutableText subtitleText = this.getScreenSubtitle();
        graphicsHolder.push();
        graphicsHolder.translate((double)this.field_22789 / 2.0, titleHeight * this.animationProgress, 0.0);
        graphicsHolder.translate(0.0, 15.0, 0.0);
        RenderHelper.scaleToFit(graphicsHolder, GraphicsHolder.getTextWidth((MutableText)subtitleText), this.field_22789, true);
        graphicsHolder.drawCenteredText(subtitleText, 0, 0, -1);
        graphicsHolder.pop();
    }

    public abstract MutableText getScreenTitle();

    public abstract MutableText getScreenSubtitle();
}

