/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.scripting.mtr.render;

import com.lx862.jcm.mod.scripting.mtr.render.QuadDrawCall;
import com.lx862.jcm.mod.scripting.mtr.render.RenderDrawCall;
import com.lx862.mtrscripting.util.ScriptVector3f;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.render.StoredMatrixTransformations;

public class DisplayHelperCompat
extends RenderDrawCall<DisplayHelperCompat> {
    private final List<QuadDrawCall> quadDrawCalls;

    private DisplayHelperCompat() {
        this.quadDrawCalls = new ArrayList<QuadDrawCall>();
    }

    private DisplayHelperCompat(List<QuadDrawCall> calls) {
        this.quadDrawCalls = calls;
    }

    public static DisplayHelperCompat create() {
        return new DisplayHelperCompat();
    }

    public DisplayHelperCompat addQuad(QuadDrawCall model) {
        this.quadDrawCalls.add(model);
        return this;
    }

    public DisplayHelperCompat copy(Identifier textureId) {
        ArrayList<QuadDrawCall> newDrawCalls = new ArrayList<QuadDrawCall>();
        for (QuadDrawCall quadDrawCall : this.quadDrawCalls) {
            QuadDrawCall copyCall = quadDrawCall.copy();
            copyCall.texture(textureId);
            newDrawCalls.add(copyCall);
        }
        return new DisplayHelperCompat(newDrawCalls);
    }

    public List<RenderDrawCall<QuadDrawCall>> getDrawCalls() {
        return new ArrayList<RenderDrawCall<QuadDrawCall>>(this.quadDrawCalls);
    }

    @Override
    public void run(World world, ScriptVector3f basePos, GraphicsHolder graphicsHolder, StoredMatrixTransformations storedMatrixTransformations, Direction facing, int light) {
        super.run(world, basePos, graphicsHolder, storedMatrixTransformations, facing, light);
        for (QuadDrawCall drawCall : this.quadDrawCalls) {
            drawCall.run(world, basePos, graphicsHolder, storedMatrixTransformations, facing, light);
        }
    }

    @Override
    public void validate() {
        for (QuadDrawCall drawCall : this.quadDrawCalls) {
            drawCall.validate();
        }
    }
}

