/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater;

import cn.zbx1425.resourcepackupdater.Config;
import cn.zbx1425.resourcepackupdater.mappings.Text;
import cn.zbx1425.resourcepackupdater.network.ClientVersionC2SPacket;
import cn.zbx1425.resourcepackupdater.network.ServerLockS2CPacket;
import cn.zbx1425.resourcepackupdater.network.ServerLockTask;
import cn.zbx1425.resourcepackupdater.util.MismatchingVersionException;
import cn.zbx1425.resourcepackupdater.util.MtrVersion;
import com.google.gson.JsonParser;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackUpdater
implements ModInitializer {
    public static final String MOD_ID = "resourcepackupdater";
    public static final Logger LOGGER = LogManager.getLogger((String)"ResourcePackUpdater");
    public static String MOD_VERSION = "";
    public static final Config CONFIG = new Config();
    public static final JsonParser JSON_PARSER = new JsonParser();

    public void onInitialize() {
        MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion().getFriendlyString();
        try {
            CONFIG.load();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ServerLockS2CPacket.TYPE)) {
                handler.addTask((class_8605)new ServerLockTask((String)ResourcePackUpdater.CONFIG.serverLockKey.value));
            } else if (((Boolean)ResourcePackUpdater.CONFIG.clientEnforceInstall.value).booleanValue()) {
                handler.method_52396((class_2561)Text.literal(new MismatchingVersionException(MOD_VERSION, "\u672a\u5b89\u88dd NOT INSTALLED").getMessage().trim()));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ClientVersionC2SPacket.TYPE, (packet, handler, sender) -> {
            String clientVersion = packet.clientVersion;
            if (!((String)ResourcePackUpdater.CONFIG.clientEnforceVersion.value).isEmpty()) {
                String versionCriteria = ((String)ResourcePackUpdater.CONFIG.clientEnforceVersion.value).replace("current", MOD_VERSION);
                if (!MtrVersion.parse(clientVersion).matches(versionCriteria)) {
                    handler.method_52396((class_2561)Text.literal(new MismatchingVersionException(MOD_VERSION, clientVersion).getMessage().trim()));
                }
            }
            handler.completeTask(ServerLockTask.TYPE);
        });
    }
}

