/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.resourcepackupdater.io.network;

import cn.zbx1425.resourcepackupdater.io.ProgressReceiver;
import cn.zbx1425.resourcepackupdater.io.network.DownloadTask;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class DownloadDispatcher {
    private final ProgressReceiver progressReceiver;
    public long totalBytes;
    public long downloadedBytes;
    public AtomicLong newlyDownloadedBytes = new AtomicLong(0L);
    private long lastSummaryTime = -1L;
    private long lastSummaryBytes = 0L;
    public long summaryBytesPerSecond = 0L;
    private final ExecutorService executor = Executors.newFixedThreadPool(4);
    public ConcurrentLinkedQueue<DownloadTask> runningTasks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<DownloadTask> incompleteTasks = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> delayedProgresses = new ConcurrentLinkedQueue();
    private Exception taskException = null;
    private final int MAX_RETRIES = 8;

    public DownloadDispatcher(ProgressReceiver progressReceiver) {
        this.progressReceiver = progressReceiver;
    }

    public void dispatch(DownloadTask task, Supplier<OutputStream> target) {
        this.totalBytes += task.expectedSize;
        this.incompleteTasks.add(task);
        this.executor.submit(() -> {
            this.runningTasks.add(task);
            try {
                while (true) {
                    try {
                        task.runBlocking((OutputStream)target.get());
                        if (task.failedAttempts > 0) {
                            this.delayedProgresses.add(() -> this.progressReceiver.printLog(String.format("Downloading files ... (Retry %d succeed)", task.failedAttempts)));
                        }
                    }
                    catch (Exception ex) {
                        ++task.failedAttempts;
                        if (task.failedAttempts < 8) {
                            this.delayedProgresses.add(() -> {
                                this.progressReceiver.printLog(String.format("Retry (%d/%d) for %s due to error:", task.failedAttempts, 8, task.fileName));
                                this.progressReceiver.printLog(String.format("Retry %d: %s", task.failedAttempts, ex.toString()));
                            });
                            continue;
                        }
                        throw ex;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.taskException = e;
                this.executor.shutdown();
                this.runningTasks.clear();
                this.incompleteTasks.clear();
            }
            finally {
                this.runningTasks.remove(task);
                this.incompleteTasks.remove(task);
            }
        });
    }

    public void updateSummary() {
        while (!this.delayedProgresses.isEmpty()) {
            this.delayedProgresses.poll().run();
        }
        long newBytes = this.newlyDownloadedBytes.getAndSet(0L);
        this.downloadedBytes += newBytes;
        if (this.lastSummaryTime == -1L) {
            this.lastSummaryTime = System.currentTimeMillis();
            this.lastSummaryBytes = this.downloadedBytes;
        } else {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.lastSummaryTime;
            double SMOOTH_FACTOR = 0.05;
            double instantSpeed = (double)(this.downloadedBytes - this.lastSummaryBytes) * 1000.0 / (double)deltaTime;
            this.summaryBytesPerSecond = (long)((double)this.summaryBytesPerSecond * (1.0 - SMOOTH_FACTOR) + instantSpeed * SMOOTH_FACTOR);
            this.lastSummaryTime = currentTime;
            this.lastSummaryBytes = this.downloadedBytes;
        }
        String message = String.format(": % 5.2f MiB / % 5.2f MiB; %5d KiB/s", (double)this.downloadedBytes / 1048576.0, (double)this.totalBytes / 1048576.0, this.summaryBytesPerSecond / 1024L);
        this.progressReceiver.setProgress((float)this.downloadedBytes * 1.0f / (float)this.totalBytes, 0.0f);
        String runningProgress = this.incompleteTasks.size() + " Files Remaining\n" + String.join((CharSequence)"\n", this.runningTasks.stream().map(task -> "  " + (task.totalBytes == 0L ? "WAIT" : String.format("%.1f%%", Float.valueOf((float)task.downloadedBytes * 100.0f / (float)task.totalBytes))) + "\t" + (String)(task.failedAttempts > 0 ? "(RETRY " + task.failedAttempts + ") " : "") + task.fileName).toList());
        this.progressReceiver.setInfo(runningProgress, message);
    }

    public boolean tasksFinished() throws Exception {
        if (this.taskException != null) {
            while (!this.delayedProgresses.isEmpty()) {
                this.delayedProgresses.poll().run();
            }
            throw this.taskException;
        }
        return this.incompleteTasks.isEmpty();
    }

    protected void onDownloadProgress(long deltaBytes) {
        this.newlyDownloadedBytes.addAndGet(deltaBytes);
    }

    public void close() {
        this.executor.shutdown();
    }
}

